/*
 * Decompiled with CFR 0.152.
 */
package org.junit.rules;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.rules.Verifier;
import org.junit.runners.model.MultipleFailureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorCollector
extends Verifier {
    private List<Throwable> errors = new ArrayList<Throwable>();

    @Override
    protected void verify() throws Throwable {
        MultipleFailureException.assertEmpty(this.errors);
    }

    public void addError(Throwable throwable) {
        this.errors.add(throwable);
    }

    public <T> void checkThat(T t, Matcher<T> matcher) {
        this.checkThat("", t, matcher);
    }

    public <T> void checkThat(final String string, final T t, final Matcher<T> matcher) {
        this.checkSucceeds(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Assert.assertThat(string, t, matcher);
                return t;
            }
        });
    }

    public Object checkSucceeds(Callable<Object> callable) {
        try {
            return callable.call();
        }
        catch (Throwable throwable) {
            this.addError(throwable);
            return null;
        }
    }
}

