/*
 * Decompiled with CFR 0.152.
 */
package org.junit.runners;

import java.util.List;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.internal.runners.model.ReflectiveCallable;
import org.junit.internal.runners.rules.RuleFieldValidator;
import org.junit.internal.runners.statements.ExpectException;
import org.junit.internal.runners.statements.Fail;
import org.junit.internal.runners.statements.FailOnTimeout;
import org.junit.internal.runners.statements.InvokeMethod;
import org.junit.internal.runners.statements.RunAfters;
import org.junit.internal.runners.statements.RunBefores;
import org.junit.rules.MethodRule;
import org.junit.rules.RunRules;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockJUnit4ClassRunner
extends ParentRunner<FrameworkMethod> {
    public BlockJUnit4ClassRunner(Class<?> clazz) throws InitializationError {
        super(clazz);
    }

    @Override
    protected void runChild(FrameworkMethod frameworkMethod, RunNotifier runNotifier) {
        Description description = this.describeChild(frameworkMethod);
        if (frameworkMethod.getAnnotation(Ignore.class) != null) {
            runNotifier.fireTestIgnored(description);
        } else {
            this.runLeaf(this.methodBlock(frameworkMethod), description, runNotifier);
        }
    }

    @Override
    protected Description describeChild(FrameworkMethod frameworkMethod) {
        return Description.createTestDescription(this.getTestClass().getJavaClass(), this.testName(frameworkMethod), frameworkMethod.getAnnotations());
    }

    @Override
    protected List<FrameworkMethod> getChildren() {
        return this.computeTestMethods();
    }

    protected List<FrameworkMethod> computeTestMethods() {
        return this.getTestClass().getAnnotatedMethods(Test.class);
    }

    @Override
    protected void collectInitializationErrors(List<Throwable> list) {
        super.collectInitializationErrors(list);
        this.validateNoNonStaticInnerClass(list);
        this.validateConstructor(list);
        this.validateInstanceMethods(list);
        this.validateFields(list);
    }

    protected void validateNoNonStaticInnerClass(List<Throwable> list) {
        if (this.getTestClass().isANonStaticInnerClass()) {
            String string = "The inner class " + this.getTestClass().getName() + " is not static.";
            list.add(new Exception(string));
        }
    }

    protected void validateConstructor(List<Throwable> list) {
        this.validateOnlyOneConstructor(list);
        this.validateZeroArgConstructor(list);
    }

    protected void validateOnlyOneConstructor(List<Throwable> list) {
        if (!this.hasOneConstructor()) {
            String string = "Test class should have exactly one public constructor";
            list.add(new Exception(string));
        }
    }

    protected void validateZeroArgConstructor(List<Throwable> list) {
        if (!this.getTestClass().isANonStaticInnerClass() && this.hasOneConstructor() && this.getTestClass().getOnlyConstructor().getParameterTypes().length != 0) {
            String string = "Test class should have exactly one public zero-argument constructor";
            list.add(new Exception(string));
        }
    }

    private boolean hasOneConstructor() {
        return this.getTestClass().getJavaClass().getConstructors().length == 1;
    }

    @Deprecated
    protected void validateInstanceMethods(List<Throwable> list) {
        this.validatePublicVoidNoArgMethods(After.class, false, list);
        this.validatePublicVoidNoArgMethods(Before.class, false, list);
        this.validateTestMethods(list);
        if (this.computeTestMethods().size() == 0) {
            list.add(new Exception("No runnable methods"));
        }
    }

    private void validateFields(List<Throwable> list) {
        RuleFieldValidator.RULE_VALIDATOR.validate(this.getTestClass(), list);
    }

    protected void validateTestMethods(List<Throwable> list) {
        this.validatePublicVoidNoArgMethods(Test.class, false, list);
    }

    protected Object createTest() throws Exception {
        return this.getTestClass().getOnlyConstructor().newInstance(new Object[0]);
    }

    protected String testName(FrameworkMethod frameworkMethod) {
        return frameworkMethod.getName();
    }

    protected Statement methodBlock(FrameworkMethod frameworkMethod) {
        Object object;
        try {
            object = new ReflectiveCallable(){

                protected Object runReflectiveCall() throws Throwable {
                    return BlockJUnit4ClassRunner.this.createTest();
                }
            }.run();
        }
        catch (Throwable throwable) {
            return new Fail(throwable);
        }
        Statement statement = this.methodInvoker(frameworkMethod, object);
        statement = this.possiblyExpectingExceptions(frameworkMethod, object, statement);
        statement = this.withPotentialTimeout(frameworkMethod, object, statement);
        statement = this.withBefores(frameworkMethod, object, statement);
        statement = this.withAfters(frameworkMethod, object, statement);
        statement = this.withRules(frameworkMethod, object, statement);
        return statement;
    }

    protected Statement methodInvoker(FrameworkMethod frameworkMethod, Object object) {
        return new InvokeMethod(frameworkMethod, object);
    }

    @Deprecated
    protected Statement possiblyExpectingExceptions(FrameworkMethod frameworkMethod, Object object, Statement statement) {
        Test test = frameworkMethod.getAnnotation(Test.class);
        return this.expectsException(test) ? new ExpectException(statement, this.getExpectedException(test)) : statement;
    }

    @Deprecated
    protected Statement withPotentialTimeout(FrameworkMethod frameworkMethod, Object object, Statement statement) {
        long l = this.getTimeout(frameworkMethod.getAnnotation(Test.class));
        return l > 0L ? new FailOnTimeout(statement, l) : statement;
    }

    @Deprecated
    protected Statement withBefores(FrameworkMethod frameworkMethod, Object object, Statement statement) {
        List<FrameworkMethod> list = this.getTestClass().getAnnotatedMethods(Before.class);
        return list.isEmpty() ? statement : new RunBefores(statement, list, object);
    }

    @Deprecated
    protected Statement withAfters(FrameworkMethod frameworkMethod, Object object, Statement statement) {
        List<FrameworkMethod> list = this.getTestClass().getAnnotatedMethods(After.class);
        return list.isEmpty() ? statement : new RunAfters(statement, list, object);
    }

    private Statement withRules(FrameworkMethod frameworkMethod, Object object, Statement statement) {
        Statement statement2 = statement;
        statement2 = this.withMethodRules(frameworkMethod, object, statement2);
        statement2 = this.withTestRules(frameworkMethod, object, statement2);
        return statement2;
    }

    private Statement withMethodRules(FrameworkMethod frameworkMethod, Object object, Statement statement) {
        List<TestRule> list = this.getTestRules(object);
        for (MethodRule methodRule : this.getMethodRules(object)) {
            if (list.contains(methodRule)) continue;
            statement = methodRule.apply(statement, frameworkMethod, object);
        }
        return statement;
    }

    private List<MethodRule> getMethodRules(Object object) {
        return this.rules(object);
    }

    @Deprecated
    protected List<MethodRule> rules(Object object) {
        return this.getTestClass().getAnnotatedFieldValues(object, Rule.class, MethodRule.class);
    }

    private Statement withTestRules(FrameworkMethod frameworkMethod, Object object, Statement statement) {
        List<TestRule> list = this.getTestRules(object);
        return list.isEmpty() ? statement : new RunRules(statement, list, this.describeChild(frameworkMethod));
    }

    protected List<TestRule> getTestRules(Object object) {
        return this.getTestClass().getAnnotatedFieldValues(object, Rule.class, TestRule.class);
    }

    private Class<? extends Throwable> getExpectedException(Test test) {
        if (test == null || test.expected() == Test.None.class) {
            return null;
        }
        return test.expected();
    }

    private boolean expectsException(Test test) {
        return this.getExpectedException(test) != null;
    }

    private long getTimeout(Test test) {
        if (test == null) {
            return 0L;
        }
        return test.timeout();
    }
}

