/*
 * Decompiled with CFR 0.152.
 */
package org.junit.runners.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.List;
import org.junit.internal.runners.model.ReflectiveCallable;
import org.junit.runners.model.FrameworkMember;
import org.junit.runners.model.NoGenericTypeParametersValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameworkMethod
extends FrameworkMember<FrameworkMethod> {
    final Method fMethod;

    public FrameworkMethod(Method method) {
        this.fMethod = method;
    }

    public Method getMethod() {
        return this.fMethod;
    }

    public Object invokeExplosively(final Object object, final Object ... objectArray) throws Throwable {
        return new ReflectiveCallable(){

            protected Object runReflectiveCall() throws Throwable {
                return FrameworkMethod.this.fMethod.invoke(object, objectArray);
            }
        }.run();
    }

    public String getName() {
        return this.fMethod.getName();
    }

    public void validatePublicVoidNoArg(boolean bl, List<Throwable> list) {
        this.validatePublicVoid(bl, list);
        if (this.fMethod.getParameterTypes().length != 0) {
            list.add(new Exception("Method " + this.fMethod.getName() + " should have no parameters"));
        }
    }

    public void validatePublicVoid(boolean bl, List<Throwable> list) {
        if (Modifier.isStatic(this.fMethod.getModifiers()) != bl) {
            String string = bl ? "should" : "should not";
            list.add(new Exception("Method " + this.fMethod.getName() + "() " + string + " be static"));
        }
        if (!Modifier.isPublic(this.fMethod.getDeclaringClass().getModifiers())) {
            list.add(new Exception("Class " + this.fMethod.getDeclaringClass().getName() + " should be public"));
        }
        if (!Modifier.isPublic(this.fMethod.getModifiers())) {
            list.add(new Exception("Method " + this.fMethod.getName() + "() should be public"));
        }
        if (this.fMethod.getReturnType() != Void.TYPE) {
            list.add(new Exception("Method " + this.fMethod.getName() + "() should be void"));
        }
    }

    public void validateNoTypeParametersOnArgs(List<Throwable> list) {
        new NoGenericTypeParametersValidator(this.fMethod).validate(list);
    }

    @Override
    public boolean isShadowedBy(FrameworkMethod frameworkMethod) {
        if (!frameworkMethod.getName().equals(this.getName())) {
            return false;
        }
        if (frameworkMethod.getParameterTypes().length != this.getParameterTypes().length) {
            return false;
        }
        for (int i = 0; i < frameworkMethod.getParameterTypes().length; ++i) {
            if (frameworkMethod.getParameterTypes()[i].equals(this.getParameterTypes()[i])) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (!FrameworkMethod.class.isInstance(object)) {
            return false;
        }
        return ((FrameworkMethod)object).fMethod.equals(this.fMethod);
    }

    public int hashCode() {
        return this.fMethod.hashCode();
    }

    @Deprecated
    public boolean producesType(Type type) {
        return this.getParameterTypes().length == 0 && type instanceof Class && ((Class)type).isAssignableFrom(this.fMethod.getReturnType());
    }

    private Class<?>[] getParameterTypes() {
        return this.fMethod.getParameterTypes();
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.fMethod.getAnnotations();
    }

    public <T extends Annotation> T getAnnotation(Class<T> clazz) {
        return this.fMethod.getAnnotation(clazz);
    }
}

