---
title: Best Practices Guide
weight: 1000
---

The purpose of this section is to consolidate best practices for Rancher implementations. This also includes recommendations for related technologies, such as Kubernetes, Docker, containers, and more. The objective is to improve the outcome of a Rancher implementation using the operational experience of Rancher and its customers.

If you have any questions about how these might apply to your use case, please contact your Customer Success Manager or Support.

Use the navigation bar on the left to find the current best practices for managing and deploying the Rancher Server.

For more guidance on best practices, you can consult these resources:

- [Rancher Docs]({{<baseurl>}})
    - [Monitoring]({{<baseurl>}}/rancher/v2.x/en/cluster-admin/tools/monitoring/)
    - [Backups and Disaster Recovery]({{<baseurl>}}/rancher/v2.x/en/backups/)
    - [Security]({{<baseurl>}}/rancher/v2.x/en/security/)
- [Rancher Blog](https://rancher.com/blog/)
    - [Articles about best practices on the Rancher blog](https://rancher.com/tags/best-practices/)
    - [101 More Security Best Practices for Kubernetes](https://rancher.com/blog/2019/2019-01-17-101-more-kubernetes-security-best-practices/)
- [Rancher Forum](https://forums.rancher.com/)
- [Rancher Users Slack](https://slack.rancher.io/)
- [Rancher Labs YouTube Channel - Online Meetups, Demos, Training, and Webinars](https://www.youtube.com/channel/UCh5Xtp82q8wjijP8npkVTBA/featured)
