---
title: Container Network Interface (CNI) Providers
description: Learn about Container Network Interface (CNI), the CNI providers Rancher provides, the features they offer, and how to choose a provider for you
weight: 2300
---

## What is CNI?

CNI (Container Network Interface), a [Cloud Native Computing Foundation project](https://cncf.io/), consists of a specification and libraries for writing plugins to configure network interfaces in Linux containers, along with a number of  plugins. CNI concerns itself only with network connectivity of containers and removing allocated resources when the container is deleted.

Kubernetes uses CNI as an interface between network providers and Kubernetes pod networking.

![CNI Logo]({{<baseurl>}}/img/rancher/cni-logo.png)

For more information visit [CNI GitHub project](https://github.com/containernetworking/cni).

### What Network Models are Used in CNI?

CNI network providers implement their network fabric using either an encapsulated network model such as Virtual Extensible Lan ([VXLAN](https://github.com/coreos/flannel/blob/master/Documentation/backends.md#vxlan)) or an unencapsulated network model such as Border Gateway Protocol ([BGP](https://en.wikipedia.org/wiki/Border_Gateway_Protocol)).

#### What is an Encapsulated Network?

This network model provides a logical Layer 2 (L2) network encapsulated over the existing Layer 3 (L3) network topology that spans the Kubernetes cluster nodes. With this model you have an isolated L2 network for containers without needing routing distribution, all at the cost of minimal overhead in terms of processing and increased IP package size, which comes from an IP header generated by overlay encapsulation. Encapsulation information is distributed by UDP ports between Kubernetes workers, interchanging network control plane information about how MAC addresses can be reached. Common encapsulation used in this kind of network model is VXLAN, Internet Protocol Security (IPSec), and IP-in-IP.

In simple terms, this network model generates a kind of network bridge extended between Kubernetes workers, where pods are connected.

This network model is used when an extended L2 bridge is preferred. This network model is sensitive to L3 network latencies of the Kubernetes workers. If datacenters are in distinct geolocations, be sure to have low latencies between them to avoid eventual network segmentation.

CNI network providers using this network model include Flannel, Canal, and Weave.

![Encapsulated Network]({{<baseurl>}}/img/rancher/encapsulated-network.png)

#### What is an Unencapsulated Network?

This network model provides an L3 network to route packets between containers. This model doesn't generate an isolated l2 network, nor generates overhead. These benefits come at the cost of Kubernetes workers having to manage any route distribution that's needed. Instead of using IP headers for encapsulation, this network model uses a network protocol between Kubernetes workers to distribute routing information to reach pods, such as [BGP](https://en.wikipedia.org/wiki/Border_Gateway_Protocol).

In simple terms, this network model generates a kind of network router extended between Kubernetes workers, which provides information about how to reach pods.

This network model is used when a routed L3 network is preferred. This mode dynamically updates routes at the OS level for Kubernetes workers. It's less sensitive to latency.

CNI network providers using this network model include Calico and Romana.

![Unencapsulated Network]({{<baseurl>}}/img/rancher/unencapsulated-network.png)

### What CNI Providers are Provided by Rancher?

Out-of-the-box, Rancher provides the following CNI network providers for Kubernetes clusters: Canal, Flannel, Calico and Weave (Weave is available as of v2.2.0). You can choose your CNI network provider when you create new Kubernetes clusters from Rancher.

#### Canal

![Canal Logo]({{<baseurl>}}/img/rancher/canal-logo.png)

Canal is a CNI network provider that gives you the best of Flannel and Calico. It allows users to easily deploy Calico and Flannel networking together as a unified networking solution, combining Calico’s network policy enforcement with the rich superset of Calico (unencapsulated) and/or Flannel (encapsulated) network connectivity options.

In Rancher, Canal is the default CNI network provider combined with Flannel and VXLAN encapsulation.

Kubernetes workers should open UDP port `8472` (VXLAN) and TCP port `9099` (healthcheck). For details, refer to [the port requirements for user clusters.]({{<baseurl>}}/rancher/v2.x/en/cluster-provisioning/node-requirements/)

{{< img "/img/rancher/canal-diagram.png" "Canal Diagram">}}

For more information, see the [Canal GitHub Page.](https://github.com/projectcalico/canal)

#### Flannel

![Flannel Logo]({{<baseurl>}}/img/rancher/flannel-logo.png)

Flannel is a simple and easy way to configure L3 network fabric designed for Kubernetes. Flannel runs a single binary agent named flanneld on each host, which is responsible for allocating a subnet lease to each host out of a larger, preconfigured address space. Flannel uses either the Kubernetes API or etcd directly to store the network configuration, the allocated subnets, and any auxiliary data (such as the host's public IP). Packets are forwarded using one of several backend mechanisms, with the default encapsulation being [VXLAN](https://github.com/coreos/flannel/blob/master/Documentation/backends.md#vxlan).

Encapsulated traffic is unencrypted by default. Therefore, flannel provides an experimental backend for encryption, [IPSec](https://github.com/coreos/flannel/blob/master/Documentation/backends.md#ipsec), which makes use of [strongSwan](https://www.strongswan.org/) to establish encrypted IPSec tunnels between Kubernetes workers.

Kubernetes workers should open UDP port `8472` (VXLAN) and TCP port `9099` (healthcheck). See [the port requirements for user clusters]({{<baseurl>}}/rancher/v2.x/en/cluster-provisioning/node-requirements/#networking-requirements/) for more details.

![Flannel Diagram]({{<baseurl>}}/img/rancher/flannel-diagram.png)

For more information, see the [Flannel GitHub Page](https://github.com/coreos/flannel).

#### Calico

![Calico Logo]({{<baseurl>}}/img/rancher/calico-logo.png)

Calico enables networking and network policy in Kubernetes clusters across the cloud. Calico uses a pure, unencapsulated IP network fabric and policy engine to provide networking for your Kubernetes workloads. Workloads are able to communicate over both cloud infrastructure and on-premise using BGP.

Calico also provides a stateless IP-in-IP encapsulation mode that can be used, if necessary. Calico also offers policy isolation, allowing you to secure and govern your Kubernetes workloads using advanced ingress and egress policies.

Kubernetes workers should open TCP port `179` (BGP). See [the port requirements for user clusters]({{<baseurl>}}/rancher/v2.x/en/cluster-provisioning/node-requirements/#networking-requirements/) for more details.

![Calico Diagram]({{<baseurl>}}/img/rancher/calico-diagram.svg)

For more information, see the following pages:

- [Project Calico Official Site](https://www.projectcalico.org/)
- [Project Calico GitHub Page](https://github.com/projectcalico/calico)


#### Weave

![Weave Logo]({{<baseurl>}}/img/rancher/weave-logo.png)

_Available as of v2.2.0_

Weave enables networking and network policy in Kubernetes clusters across the cloud. Additionally, it support encrypting traffic between the peers.

Kubernetes workers should open TCP port `6783` (control port), UDP port `6783` and UDP port `6784` (data ports). See the [port requirements for user clusters]({{<baseurl>}}/rancher/v2.x/en/cluster-provisioning/node-requirements/#networking-requirements/) for more details.

For more information, see the following pages:

- [Weave Net Official Site](https://www.weave.works/)

### CNI Features by Provider

The following table summarizes the different features available for each CNI network provider provided by Rancher.

| Provider | Network Model | Route Distribution | Network Policies | Mesh | External Datastore | Encryption | Ingress/Egress Policies |
| ---- | ---- | ---- | ---- | ---- | ---- | ---- | ---- |
| Canal | Encapsulated (VXLAN) | No | Yes | No | K8S API | No | Yes |
| Flannel | Encapsulated (VXLAN) | No | No | No | K8S API | No | No |
| Calico | Unencapsulated | Yes | Yes | Yes | Etcd | No | Yes |
| Weave | Encapsulated | Yes | Yes | Yes | No | Yes | Yes |

- Network Model: Encapsulated or unencapsulated. For more information, see [What Network Models are Used in CNI?](#what-network-models-are-used-in-cni)

- Route Distribution: An exterior gateway protocol designed to exchange routing and reachability information on the Internet. BGP can assist with pod-to-pod networking between clusters. This feature is a must on unencapsulated CNI network providers, and it is typically done by BGP. If you plan to build clusters split across network segments, route distribution is a feature that's nice-to-have.

- Network Policies: Kubernetes offers functionality to enforce rules about which services can communicate with each other using network policies. This feature is stable as of Kubernetes v1.7 and is ready to use with certain networking plugins.

- Mesh: This feature allows service-to-service networking communication between distinct Kubernetes clusters.

- External Datastore: CNI network providers with this feature need an external datastore for its data.

- Encryption: This feature allows cyphered and secure network control and data planes.

- Ingress/Egress Policies: This feature allows you to manage routing control for both Kubernetes and non-Kubernetes communications.

#### CNI Community Popularity

The following table summarizes different GitHub metrics to give you an idea of each project's popularity and activity. This data was collected in January 2020.

| Provider | Project | Stars | Forks | Contributors |
| ---- | ---- | ---- | ---- | ---- |
| Canal | https://github.com/projectcalico/canal | 614 | 89 | 19 |
| flannel | https://github.com/coreos/flannel | 4977 | 1.4k | 140 |
| Calico | https://github.com/projectcalico/calico | 1534 | 429 | 135 |
| Weave | https://github.com/weaveworks/weave/ | 5737 | 559 | 73 |

<br/>
### Which CNI Provider Should I Use?

It depends on your project needs. There are many different providers, which each have various features and options. There isn't one provider that meets everyone's needs.

As of Rancher v2.0.7, Canal is the default CNI network provider. We recommend it for most use cases. It provides encapsulated networking for containers with Flannel, while adding Calico network policies that can provide project/namespace isolation in terms of networking.

### How can I configure a CNI network provider?

Please see [Cluster Options]({{<baseurl>}}/rancher/v2.x/en/cluster-provisioning/rke-clusters/options/) on how to configure a network provider for your cluster. For more advanced configuration options, please see how to configure your cluster using a [Config File]({{<baseurl>}}/rancher/v2.x/en/cluster-provisioning/rke-clusters/options/#config-file) and the options for [Network Plug-ins]({{<baseurl>}}/rke/latest/en/config-options/add-ons/network-plugins/).
