---
title: "Layer 4 and Layer 7 Load Balancing"
description: "Kubernetes supports load balancing in two ways: Layer-4 Load Balancing and Layer-7 Load Balancing. Learn about the support for each way in different deployments"
weight: 3041
aliases:
  - /rancher/v2.x/en/concepts/load-balancing/
---
Kubernetes supports load balancing in two ways: Layer-4 Load Balancing and Layer-7 Load Balancing.

## Layer-4 Load Balancer

Layer-4 load balancer (or the external load balancer) forwards traffic to Nodeports. Layer-4 load balancer allows you to forward both HTTP and TCP traffic.

Often, the Layer-4 load balancer is supported by the underlying cloud provider, so when you deploy RKE clusters on bare-metal servers and vSphere clusters, Layer-4 load balancer is not supported. However, a single [globally managed config-map](https://kubernetes.github.io/ingress-nginx/user-guide/exposing-tcp-udp-services/) can be used to expose services on NGINX or third-party ingress.

> **Note:** It is possible to deploy a cluster with a non-cloud load balancer, such as [MetalLB.](https://metallb.universe.tf/) However, that use case is more advanced than the Layer-4 load balancer supported by a cloud provider, and it is not configurable in Rancher or RKE.

### Support for Layer-4 Load Balancing

Support for layer-4 load balancer varies based on the underlying cloud provider.

Cluster Deployment                            | Layer-4 Load Balancer Support
----------------------------------------------|--------------------------------
Amazon EKS                | Supported by AWS cloud provider
Google GKE                   | Supported by GCE cloud provider
Azure AKS                       | Supported by Azure cloud provider
RKE on EC2                 | Supported by AWS cloud provider
RKE on DigitalOcean         | Limited NGINX or third-party Ingress*
RKE on vSphere           | Limited NGINX or third party-Ingress*
RKE on Custom Hosts<br/>(e.g. bare-metal servers) | Limited NGINX or third-party Ingress*
Third-party MetalLB | Limited NGINX or third-party Ingress*

\* Services can be exposed through a single [globally managed config-map.](https://kubernetes.github.io/ingress-nginx/user-guide/exposing-tcp-udp-services/)

## Layer-7 Load Balancer

Layer-7 load balancer (or the ingress controller) supports host and path-based load balancing and SSL termination. Layer-7 load balancer only forwards HTTP and HTTPS traffic and therefore they listen on ports 80 and 443 only. Cloud providers such as Amazon and Google support layer-7 load balancer. In addition, RKE clusters deploys the Nginx Ingress Controller.

### Support for Layer-7 Load Balancing

Support for layer-7 load balancer varies based on the underlying cloud provider.

Cluster Deployment                            | Layer-7 Load Balancer Support
----------------------------------------------|--------------------------------
Amazon EKS                                    | Supported by AWS cloud provider
Google GKE                                    | Supported by GKE cloud provider
Azure AKS                                     | Not Supported
RKE on EC2                                    | Nginx Ingress Controller
RKE on DigitalOcean                           | Nginx Ingress Controller
RKE on vSphere                                | Nginx Ingress Controller
RKE on Custom Hosts<br/>(e.g. bare-metal servers) | Nginx Ingress Controller

### Host Names in Layer-7 Load Balancer

Some cloud-managed layer-7 load balancers (such as the ALB ingress controller on AWS) expose DNS addresses for ingress rules. You need to map (via CNAME) your domain name to the DNS address generated by the layer-7 load balancer.

Other layer-7 load balancers, such as the Google Load Balancer or Nginx Ingress Controller, directly expose one or more IP addresses. Google Load Balancer provides a single routable IP address. Nginx Ingress Controller exposes the external IP of all nodes that run the Nginx Ingress Controller. You can do either of the following:

1.	Configure your own DNS to map (via A records) your domain name to the IP addresses exposes by the Layer-7 load balancer.
2.	Ask Rancher to generate an xip.io host name for your ingress rule. Rancher will take one of your exposed IPs, say a.b.c.d, and generate a host name <ingressname>.<namespace>.a.b.c.d.xip.io.

The benefit of using xip.io is that you obtain a working entrypoint URL immediately after you create the ingress rule. Setting up your own domain name, on the other hand, requires you to configure DNS servers and wait for DNS to propagate.

## Related Links

- [Create an External Load Balancer](https://kubernetes.io/docs/tasks/access-application-cluster/create-external-load-balancer/)

#### Tutorials

- [Kubernetes installation with External Load Balancer (HTTPS/Layer 7)]({{<baseurl>}}/rancher/v2.x/en/installation/ha-server-install-external-lb)
- [Kubernetes installation with External Load Balancer (TCP/Layer 4)]({{<baseurl>}}/rancher/v2.x/en/installation/ha-server-install)
- [Docker Installation with External Load Balancer]({{<baseurl>}}/rancher/v2.x/en/installation/single-node-install-external-lb)


