---
title: Istio
weight: 3528
---

_Available as of v2.3.0_

Using Rancher, you can connect, secure, control, and observe services through integration with [Istio](https://istio.io/), a leading open-source service mesh solution. Istio provides behavioral insights and operational control over the service mesh as a whole, offering a complete solution to satisfy the diverse requirements of microservice applications.

This service mesh provides features that include but are not limited to the following:

- Traffic management features
- Enhanced monitoring and tracing
- Service discovery and routing
- Secure connections and service-to-service authentication with mutual TLS
- Load balancing
- Automatic retries, backoff, and circuit breaking

Istio needs to be set up by a Rancher administrator or cluster administrator before it can be used in a project for [comprehensive data visualizations,]({{<baseurl>}}/rancher/v2.x/en/cluster-admin/tools/istio/#accessing-visualizations) traffic management, or any of its other features.

For information on how Istio is integrated with Rancher and how to set it up, refer to the [section about Istio.]({{<baseurl>}}/rancher/v2.x/en/cluster-admin/tools/istio)
