---
title: Migrating from a Kubernetes Install with an RKE Add-on
weight: 1030
aliases:
  - /rancher/v2.x/en/upgrades/ha-server-upgrade/
  - /rancher/v2.x/en/upgrades/upgrades/ha-server-upgrade/
---

> **Important: RKE add-on install is only supported up to Rancher v2.0.8**
>
>If you are currently using the RKE add-on install method, please follow these directions to migrate to the Helm install.


The following instructions will help guide you through migrating from the RKE Add-on install to managing Rancher with the Helm package manager.

You will need the to have [kubectl](https://kubernetes.io/docs/tasks/tools/install-kubectl/#install-kubectl) installed and the kubeconfig YAML file (`kube_config_rancher-cluster.yml`) generated by RKE.

> **Note:** This guide assumes a standard Rancher install. If you have modified any of the object names or namespaces, please adjust accordingly.

> **Note:** If you are upgrading from from Rancher v2.0.13 or earlier, or v2.1.8 or earlier, and your cluster's certificates have expired, you will need to perform [additional steps]({{<baseurl>}}/rancher/v2.x/en/cluster-admin/certificate-rotation/#rotating-expired-certificates-after-upgrading-older-rancher-versions) to rotate the certificates.

### Point kubectl at your Rancher Cluster

Make sure `kubectl` is using the correct kubeconfig YAML file. Set the `KUBECONFIG` environmental variable to point to `kube_config_rancher-cluster.yml`:

```
export KUBECONFIG=$(pwd)/kube_config_rancher-cluster.yml
```

After setting the `KUBECONFIG` environment variable, verify that it contains the correct `server` parameter. It should point directly to one of your cluster nodes on port `6443`.

```
kubectl config view -o=jsonpath='{.clusters[*].cluster.server}'
https://NODE:6443
```

If the output from the command shows your Rancher hostname with the suffix `/k8s/clusters`, the wrong kubeconfig YAML file is configured. It should be the file that was created when you used RKE to create the cluster to run Rancher.

### Save your certificates

If you have terminated ssl on the Rancher cluster ingress, recover your certificate and key for use in the Helm install.

Use `kubectl` to get the secret, decode the value and direct the output to a file.

```
kubectl -n cattle-system get secret cattle-keys-ingress -o jsonpath --template='{ .data.tls\.crt }' | base64 -d > tls.crt
kubectl -n cattle-system get secret cattle-keys-ingress -o jsonpath --template='{ .data.tls\.key }' | base64 -d > tls.key
```

If you specified a private CA root cert

```
kubectl -n cattle-system get secret cattle-keys-server -o jsonpath --template='{ .data.cacerts\.pem }' | base64 -d > cacerts.pem
```

### Remove previous Kubernetes objects

Remove the Kubernetes objects created by the RKE install.

> **Note:** Removing these Kubernetes components will not affect the Rancher configuration or database, but with any maintenance it is a good idea to create a backup of the data before hand. See [Creating Backups-Kubernetes Install]({{<baseurl>}}/rancher/v2.x/en/backups/backups/ha-backups) for details.

```
kubectl -n cattle-system delete ingress cattle-ingress-http
kubectl -n cattle-system delete service cattle-service
kubectl -n cattle-system delete deployment cattle
kubectl -n cattle-system delete clusterrolebinding cattle-crb
kubectl -n cattle-system delete serviceaccount cattle-admin
```

### Remove addons section from `rancher-cluster.yml`

The addons section from `rancher-cluster.yml` contains all the resources needed to deploy Rancher using RKE. By switching to Helm, this part of the cluster configuration file is no longer needed. Open `rancher-cluster.yml` in your favorite text editor and remove the addons section:

>**Important:** Make sure you only remove the addons section from the cluster configuration file.

```
nodes:
  - address: <IP> # hostname or IP to access nodes
    user: <USER> # root user (usually 'root')
    role: [controlplane,etcd,worker] # K8s roles for node
    ssh_key_path: <PEM_FILE> # path to PEM file
  - address: <IP>
    user: <USER>
    role: [controlplane,etcd,worker]
    ssh_key_path: <PEM_FILE>
  - address: <IP>
    user: <USER>
    role: [controlplane,etcd,worker]
    ssh_key_path: <PEM_FILE>

services:
  etcd:
    snapshot: true
    creation: 6h
    retention: 24h

# Remove addons section from here til end of file
addons: |-
  ---
  ...
# End of file
```

### Follow Helm and Rancher install steps

From here follow the standard install steps.

* [3 - Initialize Helm]({{<baseurl>}}/rancher/v2.x/en/installation/options/helm2/helm-init/)
* [4 - Install Rancher]({{<baseurl>}}/rancher/v2.x/en/installation/options/helm2/helm-rancher/)
