# API Reference

```{eval-rst}
.. toctree::
  :maxdepth: 1
  :hidden:

  markdown
  inputs/index
  layouts/index
  plotting
  media/index
  status
  outputs
  control_flow
  html
  state
  debugging
```

Use the marimo library in marimo notebooks (`import marimo as mo`) to

- connect interactive inputs like sliders, dropdowns, and tables to Python,
- express yourself with dynamically created markdown,
- layout information with tabs or grids,
- output media like images and audio,
- and more!

|                      |                                                           |
| :------------------- | :-------------------------------------------------------- |
| {doc}`markdown`      | Write markdown with `mo.md`                               |
| {doc}`inputs/index`  | Connect sliders, dropdowns, tables, and more to Python    |
| {doc}`layouts/index` | Customize outputs with accordions, tabs, stacks, and more |
| {doc}`plotting`      | Output interactive plots                                  |
| {doc}`media/index`   | Output media like images, audio, PDFs, and plain text     |
| {doc}`status`        | Display progress indicators                               |
| {doc}`outputs`       | Modify cell outputs, redirect console output              |
| {doc}`control_flow`  | Control how cells execute                                 |
| {doc}`html`          | Manipulate HTML objects                                   |
| {doc}`state`         | Make stateful apps with `mo.state`                        |
| {doc}`debugging`     | Debugging utilities                                       |
