# Guides

```{eval-rst}
.. toctree::
  :maxdepth: 2
  :hidden:

  overview
  reactivity
  interactivity
  outputs
  plotting
  state
  apps
  scripts
  best_practices
```

These guides cover marimo's core concepts.

|                       |                                           |
| :-------------------- | :---------------------------------------- |
| {doc}`overview`       | An overview of basic concepts             |
| {doc}`reactivity`     | How reactive execution works              |
| {doc}`interactivity`  | Using interactive UI elements             |
| {doc}`outputs`        | Markdown, plots, and other visual outputs |
| {doc}`plotting`       | Interactive and reactive plots            |
| {doc}`state`          | Reacting to interactions with state       |
| {doc}`apps`           | Running notebooks as apps                 |
| {doc}`scripts`        | Running notebooks as scripts              |
| {doc}`best_practices` | Best practices when working with marimo   |

```{admonition} Learn by doing!
:class: tip

Prefer a hands-on learning experience? marimo comes packaged with interactive
tutorials that you can launch with `marimo tutorial` at the command line.
```
