<p align="center" style="margin-top: 40px; margin-bottom: 40px;">
  <img src="_static/marimo-logotype-thick.svg" width="210px">
</p>

**marimo** is a next-generation Python notebook where every notebook is
also shareable as an interactive web app: _explore data, run
experiments, build tools, and deploy apps, all from one seamless
environment_.

**Highlights.** marimo is purpose-built for working with data in Python. Some
key features:

- **reactive**: run a cell, and marimo automatically runs cells that depend on it
- **interactive**: connect inputs like sliders, dropdowns, tables, and more to Python
- **reproducible**: no hidden state
- **simple**: no callbacks, no magical syntax — just Python
- **expressive**: create dynamic makdown parametrized by interactive elements, plots, or anything else
- **Pythonic**: cells only run Python; notebooks stored as `.py` files (clean git diffs!)
- **performant**: powered by static analysis, zero runtime overhead

marimo was built from the ground up to solve many
<a href="/getting_started/faq.html#faq-jupyter">well-known problems associated with traditional notebooks</a>;
marimo is _not_ built on Jupyter or any other notebook or app library.

> ⚡ marimo notebooks run automatically with interactions and code changes

<div align="center">
<figure>
<img src="/_static/readme-ui.gif"/>
</figure>
</div>

> ✨ express yourself with markdown, LaTeX, tables, accordions, tabs, grids, and more

<div align="center">
<figure>
<img src="/_static/outputs.gif"/>
</figure>
</div>

> 🔬 do reproducible science in an environment that makes your data tangible

<div align="center">
<figure>
<img src="/_static/faq-marimo-ui.gif"/>
</figure>
</div>

> 🚀 deploy your creations as interactive web apps

<div align="center">
<figure>
<img src="/_static/docs-intro-app.gif"/>
</figure>
</div>

<h3>Contents</h3>

```{eval-rst}
.. toctree::
   :maxdepth: 2

   getting_started/index
   guides/index
   api/index
   examples
   faq
   community
```

<h3>Index</h3>

```{eval-rst}
* :ref:`genindex`
```
