/* Copyright 2023 Marimo. All rights reserved. */
import * as React from "react";

import { cn } from "@/lib/utils";

export interface TextareaProps
  extends React.TextareaHTMLAttributes<HTMLTextAreaElement> {
  bottomAdornment?: React.ReactNode;
}

const Textarea = React.forwardRef<HTMLTextAreaElement, TextareaProps>(
  ({ className, bottomAdornment, ...props }, ref) => {
    return (
      <div className="relative">
        <textarea
          className={cn(
            "shadow-xsSolid hover:shadow-smSolid disabled:shadow-xsSolid focus-visible:shadow-mdSolid",
            "flex h-20 w-full mb-1 rounded-sm border border-input bg-transparent px-3 py-2 text-sm font-code ring-offset-background placeholder:text-muted-foreground focus-visible:outline-none focus-visible:ring-1 focus-visible:ring-ring focus-visible:border-accent disabled:cursor-not-allowed disabled:opacity-50 min-h-[1.5rem]",
            className
          )}
          ref={ref}
          {...props}
        />
        {bottomAdornment && (
          <div className="absolute right-0 bottom-1 flex items-center pr-[6px] pointer-events-none text-muted-foreground h-6">
            {bottomAdornment}
          </div>
        )}
      </div>
    );
  }
);
Textarea.displayName = "Textarea";

export { Textarea };
