tera_flag配置项解释
---

tera中通过gflag传入配置参数，参数数目较多，在不同的应用场景或需求下可能要配置成不同的值，下面对参数的意义和使用场景进行简单解释。

##  关键

`DEFINE_string(tera_zk_addr_list, "localhost:2180", "zookeeper server list");`

——**Tera严格依赖zookeeper，可配置多个zk server，“,”分隔**

`DEFINE_string(tera_zk_root_path, "/tera", "zookeeper root path");`

——**每个tera系统对应zk上一个路径**

`DEFINE_string(tera_role, "", "the role of tera running binary, should be one of (master | tabletnode)");`

——tera_main的启动模式，“master"或"tabletnode"

`DEFINE_string(tera_log_prefix, "", "prefix of log file (INFO, WARNING)");`

——tera使用glog打印日志，通过此项指定日志文件名前缀（默认二进制名称）

## zookeeper 配置

除去上面的必需配置以外，zookeeper还可以配置以下内容：

`DEFINE_int32(tera_zk_timeout, 10000, "zookeeper session timeout");`

——zk超时时间（ms，默认10s）

`DEFINE_int64(tera_zk_retry_period, 3000, "zookeeper operation retry period (in ms)");`

——zk操作重试周期（ms，默认3s）

`DEFINE_int32(tera_zk_retry_max_times, 10, "zookeeper operation max retry times");`

——zk操作重试次数（默认10次）

`DEFINE_string(tera_zk_lib_log_path, "./zk.log", "zookeeper library log output file");`

——zk日志路径（默认 ./zk.log）

## master 配置

`DEFINE_string(tera_master_port, "10000", "the master port of tera system");`

——**master 端口号，启动master时必须指定**

`DEFINE_string(tera_master_meta_table_name, "meta_table", "the meta table name");`
`DEFINE_string(tera_master_meta_table_path, "meta", "the path of meta table");`

——meta表名称及路径名（第一次启动tera时指定，以后不可以更改）

`DEFINE_int32(tera_master_connect_retry_times, 5, "the max retry times when connect to master");`
`DEFINE_int32(tera_master_connect_retry_period, 1000, "the retry period (in ms) between two master connection");`
`DEFINE_int32(tera_master_connect_timeout_period, 5000, "the timeout period (in ms) for each master connection");`

——连接master的重试时间，重试次数，超时时间

`DEFINE_int32(tera_master_collect_info_timeout, 3000, "the timeout period (in ms) for collect tabletnode info");`
`DEFINE_int32(tera_master_collect_info_retry_period, 3000, "the retry period (in ms) for collect tabletnode info");`
`DEFINE_int32(tera_master_collect_info_retry_times, 10, "the max retry times for collect tabletnode info");`

——master启动时，收集tabletnode信息的超时时间、重试周期、重试次数

`DEFINE_int32(tera_master_query_tabletnode_period, 10000, "the period (in ms) for query tabletnode status" );`

——master查询tabletnode周期（ms，默认10s）

`DEFINE_int32(tera_master_gc_period, 60000, "the period (in ms) for master gc");`

——master垃圾收集周期（ms，默认60s）

`DEFINE_int32(tera_master_meta_retry_times, 5, "the max retry times when master read/write meta");`

——master meta操作的重试次数（默认5次）

`DEFINE_int32(tera_master_impl_retry_times, 5, "the max retry times when master impl operation fail");`

——master 其它操作的重试次数（默认5次）

`DEFINE_int32(tera_master_thread_min_num, 1, "the min thread number of master server");`
`DEFINE_int32(tera_master_thread_max_num, 10, "the max thread number of master server");`
`DEFINE_int32(tera_master_impl_thread_min_num, 1, "the min thread number for master impl operations");`
`DEFINE_int32(tera_master_impl_thread_max_num, 20, "the max thread number for master impl operations");`

——master 工作线程池配置

`DEFINE_int64(tera_master_split_tablet_size, 512, "the size (in MB) of tablet to trigger split");`
`DEFINE_int64(tera_master_merge_tablet_size, 0, "the size (in MB) of tablet to trigger merge");`

——split & merge tablet的阈值

`DEFINE_int32(tera_master_max_split_concurrency, 1, "the max concurrency of tabletnode for split tablet");`
`DEFINE_int32(tera_master_max_load_concurrency, 5, "the max concurrency of tabletnode for load tablet");`

——load & split 最大并发数

`DEFINE_int32(tera_master_load_balance_period, 10000, "the period (in ms) for load balance policy execute");`

——master负载均衡执行周期

`DEFINE_double(tera_safemode_tablet_locality_ratio, 0.9, "the tablet locality ratio threshold of safemode");`

——safemode阈值，当正常状态tablet占总tablet数目比例低于此值时，master进入safemode

`DEFINE_double(tera_master_load_balance_size_overload_ratio, 1.2, "the overload ratio of data size to average size");`

——负载均衡阈值，当不同tabletnode负载之比达到此阈值时，启动负载均衡

`DEFINE_bool(tera_master_meta_isolate_enabled, false, "enable master to reserve a tabletnode for meta");`

——meta table 独自占用一个tabletnode

`DEFINE_bool(tera_master_kick_tabletnode_enabled, true, "enable master to kick tabletnode");`
`DEFINE_int32(tera_master_kick_tabletnode_query_fail_times, 10, "the number of query fail to kick tabletnode");`

——当master查询tabletnode失败次数达到此阈值时，将此tabletnode kick掉

`DEFINE_bool(tera_master_rpc_limit_enabled, false, "enable the rpc traffic limit in master");`
`DEFINE_int32(tera_master_rpc_limit_max_inflow, 10, "the max bandwidth (in MB/s) for master rpc traffic limitation on input flow");`
`DEFINE_int32(tera_master_rpc_limit_max_outflow, 10, "the max bandwidth (in MB/s) for master rpc traffic limitation on output flow");`
`DEFINE_int32(tera_master_rpc_max_pending_buffer_size, 2, "max pending buffer size (in MB) for master rpc");`
`DEFINE_int32(tera_master_rpc_work_thread_num, 8, "thread num of master rpc client");``

——rpc属性配置

`DEFINE_bool(tera_master_stat_table_enabled, true, "whether dump system status to stat_table");`
`DEFINE_string(tera_master_stat_table_name, "stat_table", "a specific table for system status dumping");`
`DEFINE_int64(tera_master_stat_table_ttl, 8000000, "default ttl for stat table (s / 100d).");`
`DEFINE_int64(tera_master_stat_table_interval, 60, "interval of system status dumping (s)");`
`DEFINE_int64(tera_master_stat_table_splitsize, 100, "default split size of stat table");`

——stat table属性配置（stat table用来记录历史系统信息）

`DEFINE_int32(tera_max_pre_assign_tablet_num, 100000, "max num of pre-assign tablets per table");`

——创建表格时预分配tablet数目的最大值

`DEFINE_int32(tera_master_load_rpc_timeout, 60000, "the timeout period (in ms) for load rpc");`
`DEFINE_int32(tera_master_unload_rpc_timeout, 60000, "the timeout period (in ms) for unload rpc");`
`DEFINE_int32(tera_master_split_rpc_timeout, 120000, "the timeout period (in ms) for split rpc");`
`DEFINE_int32(tera_master_tabletnode_timeout, 60000, "the timeout period (in ms) for move tablet after tabletnode down");`

——master几类操作的超时时间

`DEFINE_bool(tera_master_meta_recovery_enabled, false, "whether recovery meta tablet at startup");`
`DEFINE_string(tera_master_meta_recovery_file, "../data/meta.bak", "path of meta table recovery file");`

——使用本地meta文件启动master（meta table 损坏时使用）

`DEFINE_int32(tera_master_load_interval, 300, "the delay interval (in sec) for load tablet");`

`DEFINE_int32(tera_master_load_slow_retry_times, 60, "the max retry times when master load very slow tablet");`

## tabletnode 配置
`DEFINE_string(tera_tabletnode_port, "20000", "the tablet node port of tera system");`

——**tabletnode端口，必需**

`DEFINE_string(tera_tabletnode_path_prefix, "./data/", "the path prefix for table storage");`

——**tera在文件系统上的根目录，必需**

`DEFINE_string(tera_tabletnode_cache_paths, "./tera_cache_path/", "paths for cached data storage. Mutiple definition like: \"./path1/;./path2/\"");`

——**tera本地磁盘cache路径，必需**

`DEFINE_string(tera_leveldb_env_type, "dfs", "the default type for leveldb IO environment, should be [local | dfs]");`

——tera底层存储的类型，支持分布式或本地文件系统，必需

`DEFINE_string(tera_leveldb_env_dfs_type, "hdfs", "the default type for leveldb IO dfs environment, [hdfs | nfs]");`

——tera分布式文件系统类型，当前支持hdfs和hdfs2

`DEFINE_string(tera_leveldb_env_hdfs2_nameservice_list, "default", "the nameservice list of hdfs2");`

——若文件系统为hdfs2时启用

`DEFINE_int32(tera_tabletnode_write_thread_num, 10, "the write thread number of tablet node server");`
`DEFINE_int32(tera_tabletnode_read_thread_num, 40, "the read thread number of tablet node server");`
`DEFINE_int32(tera_tabletnode_scan_thread_num, 5, "the scan thread number of tablet node server");`
`DEFINE_int32(tera_tabletnode_manual_compact_thread_num, 2, "the manual compact thread number of tablet node server");`
`DEFINE_int32(tera_tabletnode_impl_thread_min_num, 1, "the min thread number for tablet node impl operations");`
`DEFINE_int32(tera_tabletnode_impl_thread_max_num, 10, "the max thread number for tablet node impl operations");`
`DEFINE_int32(tera_tabletnode_compact_thread_num, 10, "the max thread number for leveldb compaction");`

——各类线程池大小配置

`DEFINE_int32(tera_tabletnode_connect_retry_times, 5, "the max retry times when connect to tablet node");`
`DEFINE_int32(tera_tabletnode_connect_retry_period, 1000, "the retry period (in ms) between retry two tablet node connection");`
`DEFINE_int32(tera_tabletnode_connect_timeout_period, 180000, "the timeout period (in ms) for each tablet node connection");`

——连接tabletnode的重试时间，重试次数，超时时间

`DEFINE_int32(tera_asyncwriter_pending_limit, 10000, "the max pending data size (KB) in async writer");`
`DEFINE_int32(tera_asyncwriter_sync_interval, 100, "the interval (in ms) to sync write buffer to disk");`
`DEFINE_int32(tera_asyncwriter_sync_size_threshold, 1024, "force sync per X KB");`
`DEFINE_int32(tera_asyncwriter_batch_size, 1024, "write batch to leveldb per X KB");`

——异步写入时属性配置

`DEFINE_int32(tera_tabletnode_write_meta_rpc_timeout, 60000, "the timeout period (in ms) for tabletnode write meta");`

——meta操作超时时间

`DEFINE_int32(tera_tabletnode_retry_period, 100, "the retry interval period (in ms) when operate tablet");`

——tabletnode 操作重试时间

`DEFINE_int32(tera_tabletnode_scan_pack_max_size, 10240, "the max size(KB) of the package for scan rpc");`

——scan操作每次打包最大值

`DEFINE_int32(tera_io_retry_period, 100, "the retry interval period (in ms) when operate file");`
`DEFINE_int32(tera_io_retry_max_times, 20, "the max retry times when meets trouble");`

——tablet_io 中重试周期，最大重试次数

### LevelDB属性配置
`DEFINE_string(tera_leveldb_log_path, "./leveldb.log", "the default path for leveldb logger");`

——leveldb 日志文件

`DEFINE_int32(tera_tabletnode_block_cache_size, 100, "the cache size of tablet (in MB)");`
`DEFINE_int32(tera_tabletnode_table_cache_size, 10000, "the table cache size, means the max num of files keeping open in this tabletnode.");`

——block cache、table cache大小，tabletnode全局唯一

`DEFINE_int32(tera_request_pending_limit, 100000, "the max read/write request pending");`
`DEFINE_int32(tera_scan_request_pending_limit, 1000, "the max scan request pending");`

——任务队列长度

`DEFINE_int32(tera_garbage_collect_period, 1800, "garbage collect period in s");`

——本地cache垃圾收集周期

`DEFINE_int32(tera_tabletnode_rpc_timeout_period, 300000, "the timeout period (in ms) for tabletnode rpc");`
`DEFINE_bool(tera_tabletnode_rpc_limit_enabled, false, "enable the rpc traffic limit in tabletnode");`
`DEFINE_int32(tera_tabletnode_rpc_limit_max_inflow, 10, "the max bandwidth (in MB/s) for tabletnode rpc traffic limitation on input flow");`
`DEFINE_int32(tera_tabletnode_rpc_limit_max_outflow, 10, "the max bandwidth (in MB/s) for tabletnode rpc traffic limitation on output flow");`
`DEFINE_int32(tera_tabletnode_rpc_max_pending_buffer_size, 2, "max pending buffer size (in MB) for tabletnode rpc");`
`DEFINE_int32(tera_tabletnode_rpc_work_thread_num, 8, "thread num of tabletnode rpc client");`

——tabletnode rpc配置

`DEFINE_bool(tera_tabletnode_cpu_affinity_enabled, false, "enable cpu affinity or not");`
`DEFINE_string(tera_tabletnode_cpu_affinity_set, "1,2", "the cpu set of cpu affinity setting");`

——CPU绑核设定

`DEFINE_bool(tera_tabletnode_hang_detect_enabled, false, "enable detect read/write hang");`
`DEFINE_int32(tera_tabletnode_hang_detect_threshold, 60000, "read/write hang detect threshold (in ms)");`

——文件系统夯住检查，满足条件时，tabletnode会重启

`DEFINE_int64(tera_tablet_write_log_time_out, 5, "max time(sec) to wait for log writing or sync");`
`DEFINE_bool(tera_log_async_mode, true, "enable async mode for log writing and sync");`
`DEFINE_int64(tera_tablet_log_file_size, 32, "the log file size (in MB) for tablet");`
`DEFINE_int64(tera_tablet_write_buffer_size, 32, "the buffer size (in MB) for tablet write buffer");`
`DEFINE_int64(tera_tablet_write_block_size, 4, "the block size (in KB) for teblet write block");`
`DEFINE_int32(tera_tablet_flush_log_num, 100000, "the max log number before flush memtable");`

——leveldb WAL 属性配置

`DEFINE_int32(tera_leveldb_env_local_seek_latency, 50000, "the random access latency (in ns) of local storage device");`
`DEFINE_int32(tera_leveldb_env_dfs_seek_latency, 10000000, "the random access latency (in ns) of dfs storage device");`

——不同介质下每次seek的耗时（估计值）

`DEFINE_int64(tera_io_scan_stream_task_max_num, 5000, "the max number of concurrent rpc task");`
`DEFINE_int64(tera_io_scan_stream_task_pending_time, 180, "the max pending time (in sec) for timeout and interator cleaning");`

——流式Scan属性配置

## SDK 配置
`DEFINE_string(tera_sdk_conf_file, "", "the path of default flag file");`

——conf地址

`DEFINE_int32(tera_sdk_retry_times, 10, "the max retry times during sdk operation fail");`
`DEFINE_int32(tera_sdk_retry_period, 500, "the retry period (in ms) between two operations");`

——SDK操作重试次数及周期

`DEFINE_int32(tera_sdk_show_max_num, 20000, "the max fetch meta number for each rpc connection");`

——show相关命令里最大的显示条目数

`DEFINE_int32(tera_sdk_thread_max_num, 20, "the max thread number for tablet node impl operations");`

——SDK线程池大小

`DEFINE_bool(tera_sdk_rpc_limit_enabled, false, "enable the rpc traffic limit in sdk");`
`DEFINE_int32(tera_sdk_rpc_limit_max_inflow, 10, "the max bandwidth (in MB/s) for sdk rpc traffic limitation on input flow");`
`DEFINE_int32(tera_sdk_rpc_limit_max_outflow, 10, "the max bandwidth (in MB/s) for sdk rpc traffic limitation on output flow");`
`DEFINE_int32(tera_sdk_rpc_max_pending_buffer_size, 200, "max pending buffer size (in MB) for sdk rpc");`
`DEFINE_int32(tera_sdk_rpc_work_thread_num, 8, "thread num of sdk rpc client");`

——SDK rpc配置

`DEFINE_bool(tera_sdk_cookie_enabled, true, "enable sdk cookie");`
`DEFINE_string(tera_sdk_cookie_path, "/tmp/.tera_cookie", "the default path of sdk cookie");`
`DEFINE_int32(tera_sdk_cookie_update_interval, 600, "the interval of cookie updating(s)");`

——SDK本地cookie配置

`DEFINE_int32(tera_sdk_batch_size, 100, "batch_size");`
`DEFINE_int32(tera_sdk_batch_send_interval, 100, "batch send interval time");`

——SDK异步发送的周期、batch大小

`DEFINE_int32(tera_sdk_delay_send_internal, 2, "the sdk resend the request internal time(s)");`

——SDK提交写入时重试间隔

`DEFINE_int32(tera_sdk_sync_wait_timeout, 60000, "timeout of wait in sync reader&mutation mode");`

——SDK同步写入超时时间

`DEFINE_int32(tera_sdk_update_meta_concurrency, 3, "the concurrency for updating meta");`

——SDK更新Meta时最大并发值

`DEFINE_int64(tera_sdk_scan_async_cache_size, 16, "the max buffer size (in MB) for cached scan results");`
`DEFINE_int32(tera_sdk_scan_async_parallel_max_num, 500, "the max number of concurrent task sending");`

——异步Scan中cache大小及并发任务数目
