# 读写性能优化建议

#### 1. 何时使用kv存储，何时使用表格模型存储？

能使用kv的场景下，尽量使用kv存储。

随机读、扫描等简单操作的性能会明显优于表格模式，cpu的利用效率也会更高。表格存储提供了更高级的功能，应该将更核心、更复杂的逻辑应用在其上。

#### 2. 刚建的表为什么无法支持高吞吐的读写？集群资源够的情况下。

刚建的表只有一个tablet，只能使用一台机器，吞吐必然很低。随着读写的持续进行，tera会进行分裂，将负载分散。

也可以在建表时**预分多个tablet**，这样就可以直接利用更多的机器资源。

#### 3. 某些行更新频率很高的表，该行读性能会下降？

有可能，如果存在单行更新频率很高的情况，可以将该表格配置为内存compact模式，可以大幅提升此情况下的读性能。

#### 4. 表格存在明显的读写热点情况如何处理？

如果热点不是非常集中的情况下，可以将对应tablet进行拆分，分散压力。

如果非常集中，极端情况下，可能读写热点全部集中在某一行上（比如dns中，80%的读写可能全集中在少数几个站点上）：

  * 读热点，极端情况下，可能一行的读取压力（每秒数万以上）将cpu占满，此时需要客户端进行适当缓存。
  * 写热点，开启内存compact功能，可大幅提升写性能。
  
#### 5. 按某一列进行扫描时，cpu消耗很高，而且速度很慢？

当某表列很多时，只扫描其中一列，会将所有列数据扫描一遍，速度会很慢，cpu也会消耗很高。

此时可以针对不同列的扫描需求，将不同列拆分至不同Locality Groups，进行IO隔离，扫描时访问所需列数据，节省资源，提高性能。
