# Tera中读写一致性的保证

## 一、读写时序 - “实读实写”
  * 以写操作返回成功为准，自此刻发起的所有读取操作会返回最新更新成功的数据。
  * 写操作返回成功前，可能读到旧数据，也可能读到新数据。
  * 保证读到全新或全旧的数据，不会出现“残行”。

## 二、语义

tera在kv模型的基础上实现了多LocalityGroup及多列数据模型。读写一致性上，tera实现了两种语义。

### 1. 原子单行更新
#### 语义
  * 单行中某些列（包含跨LG的列）更新的过程中，要么全部成功，要么全部失败

#### 实现
  * 更新过程包含sync Write-Ahead-Log(WAL)和更新内存
  * 更新内存不会失败，所以更新的成功与否取决于sync WAL
  * tera实现了同一行的多个LocalityGroup/多列共享同一个WAL
  * 更新过程中此WAL sync成功，所有列更新成功；sync失败保证所有列更新同时失败

### 2. 并发更新读取隔离
#### 语义
  * 读取过程中发生的更新，对本次读取不生效，返回更新前数据
  * 在整行（多列）更新完成之前，新数据不可见，旧数据可读；避免出现更新至一半，“残行”出现。

#### 实现
  * 更新过程：
   * 更新开始时创建一个临时快照，保证新版本数据生效前旧数据不被删除。
   * 自此发生的所有读取操作基于此快照，保证新写入的数据不被读到。
   * 所有列更新完成后，删除快照，新发生的读取操作作用至新版本数据上。
  * 读取过程：
   * 读取开始时持有一个临时快照
   * 此快照保护所需数据在读取过程中不被删除
   * 以此快照为准进行读取，忽略正在更新的数据
