// Copyright (c) 2015, Baidu.com, Inc. All Rights Reserved
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include <string>

#include <gflags/gflags.h>

#include "proto/master_client.h"


DECLARE_int32(tera_master_connect_retry_times);
DECLARE_int32(tera_master_connect_retry_period);
DECLARE_int32(tera_master_connect_timeout_period);

namespace tera {
namespace master {

MasterClient::MasterClient(const std::string& server_addr,
                           int32_t rpc_timeout)
    : RpcClient<MasterServer::Stub>(server_addr),
      rpc_timeout_(rpc_timeout) {}

MasterClient::~MasterClient() {}

bool MasterClient::GetSnapshot(const GetSnapshotRequest* request,
                               GetSnapshotResponse* response) {
    return SendMessageWithRetry(&MasterServer::Stub::GetSnapshot,
                                request, response,
                                (Closure<void, GetSnapshotRequest*, GetSnapshotResponse*, bool, int>*)NULL,
                                "GetSnapshot", rpc_timeout_);
}

bool MasterClient::DelSnapshot(const DelSnapshotRequest* request,
                               DelSnapshotResponse* response) {
    return SendMessageWithRetry(&MasterServer::Stub::DelSnapshot,
                                request, response,
                                (Closure<void, DelSnapshotRequest*, DelSnapshotResponse*, bool, int>*)NULL,
                                "DelSnapshot", rpc_timeout_);
}

bool MasterClient::GetRollback(const RollbackRequest* request,
                               RollbackResponse* response) {
    return SendMessageWithRetry(&MasterServer::Stub::GetRollback,
                                request, response,
                                (Closure<void, RollbackRequest*, RollbackResponse*, bool, int>*)NULL,
                                "GetRollback", rpc_timeout_);
}

bool MasterClient::CreateTable(const CreateTableRequest* request,
                               CreateTableResponse* response) {
    return SendMessageWithRetry(&MasterServer::Stub::CreateTable,
                                request, response,
                                (Closure<void, CreateTableRequest*, CreateTableResponse*, bool, int>*)NULL,
                                "CreateTable", rpc_timeout_);
}

bool MasterClient::DeleteTable(const DeleteTableRequest* request,
                               DeleteTableResponse* response) {
    return SendMessageWithRetry(&MasterServer::Stub::DeleteTable,
                                request, response,
                                (Closure<void, DeleteTableRequest*, DeleteTableResponse*, bool, int>*)NULL,
                                "DeleteTable", rpc_timeout_);
}

bool MasterClient::DisableTable(const DisableTableRequest* request,
                                DisableTableResponse* response) {
    return SendMessageWithRetry(&MasterServer::Stub::DisableTable,
                                request, response,
                                (Closure<void, DisableTableRequest*, DisableTableResponse*, bool, int>*)NULL,
                                "DisableTable", rpc_timeout_);
}

bool MasterClient::EnableTable(const EnableTableRequest* request,
                               EnableTableResponse* response) {
    return SendMessageWithRetry(&MasterServer::Stub::EnableTable,
                                request, response,
                                (Closure<void, EnableTableRequest*, EnableTableResponse*, bool, int>*)NULL,
                                "EnableTable", rpc_timeout_);
}

bool MasterClient::UpdateTable(const UpdateTableRequest* request,
                               UpdateTableResponse* response) {
    return SendMessageWithRetry(&MasterServer::Stub::UpdateTable,
                                request, response,
                                (Closure<void, UpdateTableRequest*, UpdateTableResponse*, bool, int>*)NULL,
                                "UpdateTable", rpc_timeout_);
}

bool MasterClient::UpdateCheck(const UpdateCheckRequest* request,
                               UpdateCheckResponse* response) {
    return SendMessageWithRetry(&MasterServer::Stub::UpdateCheck,
                                request, response,
                                (Closure<void, UpdateCheckRequest*, UpdateCheckResponse*, bool, int>*)NULL,
                                "UpdateCheck", rpc_timeout_);
}

bool MasterClient::SearchTable(const SearchTableRequest* request,
                               SearchTableResponse* response) {
    return SendMessageWithRetry(&MasterServer::Stub::SearchTable,
                                request, response,
                                (Closure<void, SearchTableRequest*, SearchTableResponse*, bool, int>*)NULL,
                                "SearchTable", rpc_timeout_);
}

bool MasterClient::CompactTable(const CompactTableRequest* request,
                                CompactTableResponse* response) {
    return SendMessageWithRetry(&MasterServer::Stub::CompactTable,
                                request, response,
                                (Closure<void, CompactTableRequest*, CompactTableResponse*, bool, int>*)NULL,
                                "CompactTable", rpc_timeout_);
}

bool MasterClient::ShowTables(const ShowTablesRequest* request,
                              ShowTablesResponse* response) {
    return SendMessageWithRetry(&MasterServer::Stub::ShowTables,
                                request, response,
                                (Closure<void, ShowTablesRequest*, ShowTablesResponse*, bool, int>*)NULL,
                                "ShowTables", rpc_timeout_);
}

bool MasterClient::ShowTabletNodes(const ShowTabletNodesRequest* request,
                                   ShowTabletNodesResponse* response) {
    return SendMessageWithRetry(&MasterServer::Stub::ShowTabletNodes,
                                request, response,
                                (Closure<void, ShowTabletNodesRequest*, ShowTabletNodesResponse*, bool, int>*)NULL,
                                "ShowTabletNodes", rpc_timeout_);
}

bool MasterClient::Register(const RegisterRequest* request,
                            RegisterResponse* response) {
    return SendMessageWithRetry(&MasterServer::Stub::Register,
                                request, response,
                                (Closure<void, RegisterRequest*, RegisterResponse*, bool, int>*)NULL,
                                "Register", rpc_timeout_);
}

bool MasterClient::Report(const ReportRequest* request,
                          ReportResponse* response) {
    return SendMessageWithRetry(&MasterServer::Stub::Report,
                                request, response,
                                (Closure<void, ReportRequest*, ReportResponse*, bool, int>*)NULL,
                                "Report", rpc_timeout_);
}

bool MasterClient::CmdCtrl(const CmdCtrlRequest* request,
                           CmdCtrlResponse* response) {
    return SendMessageWithRetry(&MasterServer::Stub::CmdCtrl,
                                request, response,
                                (Closure<void, CmdCtrlRequest*, CmdCtrlResponse*, bool, int>*)NULL,
                                "CmdCtrl", rpc_timeout_);
}

bool MasterClient::OperateUser(const OperateUserRequest* request,
                               OperateUserResponse* response) {
    return SendMessageWithRetry(&MasterServer::Stub::OperateUser,
                                request, response,
                                (Closure<void, OperateUserRequest*, OperateUserResponse*, bool, int>*)NULL,
                                "OperateUser", rpc_timeout_);
}

bool MasterClient::RenameTable(const RenameTableRequest* request,
                               RenameTableResponse* response) {
    return SendMessageWithRetry(&MasterServer::Stub::RenameTable,
                                request, response,
                                (Closure<void, RenameTableRequest*,
                                         RenameTableResponse*, bool, int>*)NULL,
                                "RenameTable", rpc_timeout_);
}

} // namespace master
} // namespace tera
