/* Automatically generated by bindgen. Do not hand-edit.

This code is generated for documentation purposes, so that it is
easy to reference on docs.rs. Bindings are regenerated for your
build of pgrx, and the values of your Postgres version may differ.
*/
use crate as pg_sys;
use crate::{Datum, MultiXactId, Oid, PgNode, TransactionId};
#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    fn extract_bit(byte: u8, index: usize) -> bool {
        let bit_index = if cfg!(target_endian = "big") { 7 - (index % 8) } else { index % 8 };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        Self::extract_bit(byte, index)
    }
    #[inline]
    pub unsafe fn raw_get_bit(this: *const Self, index: usize) -> bool {
        debug_assert!(index / 8 < core::mem::size_of::<Storage>());
        let byte_index = index / 8;
        let byte = *(core::ptr::addr_of!((*this).storage) as *const u8).offset(byte_index as isize);
        Self::extract_bit(byte, index)
    }
    #[inline]
    fn change_bit(byte: u8, index: usize, val: bool) -> u8 {
        let bit_index = if cfg!(target_endian = "big") { 7 - (index % 8) } else { index % 8 };
        let mask = 1 << bit_index;
        if val {
            byte | mask
        } else {
            byte & !mask
        }
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        *byte = Self::change_bit(*byte, index, val);
    }
    #[inline]
    pub unsafe fn raw_set_bit(this: *mut Self, index: usize, val: bool) {
        debug_assert!(index / 8 < core::mem::size_of::<Storage>());
        let byte_index = index / 8;
        let byte =
            (core::ptr::addr_of_mut!((*this).storage) as *mut u8).offset(byte_index as isize);
        *byte = Self::change_bit(*byte, index, val);
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index =
                    if cfg!(target_endian = "big") { bit_width as usize - 1 - i } else { i };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub unsafe fn raw_get(this: *const Self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < core::mem::size_of::<Storage>());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= core::mem::size_of::<Storage>());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if Self::raw_get_bit(this, i + bit_offset) {
                let index =
                    if cfg!(target_endian = "big") { bit_width as usize - 1 - i } else { i };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") { bit_width as usize - 1 - i } else { i };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
    #[inline]
    pub unsafe fn raw_set(this: *mut Self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < core::mem::size_of::<Storage>());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= core::mem::size_of::<Storage>());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") { bit_width as usize - 1 - i } else { i };
            Self::raw_set_bit(this, index + bit_offset, val_bit_is_set);
        }
    }
}
#[repr(C)]
#[derive(Default)]
pub struct __IncompleteArrayField<T>(::core::marker::PhantomData<T>, [T; 0]);
impl<T> __IncompleteArrayField<T> {
    #[inline]
    pub const fn new() -> Self {
        __IncompleteArrayField(::core::marker::PhantomData, [])
    }
    #[inline]
    pub fn as_ptr(&self) -> *const T {
        self as *const _ as *const T
    }
    #[inline]
    pub fn as_mut_ptr(&mut self) -> *mut T {
        self as *mut _ as *mut T
    }
    #[inline]
    pub unsafe fn as_slice(&self, len: usize) -> &[T] {
        unsafe { ::core::slice::from_raw_parts(self.as_ptr(), len) }
    }
    #[inline]
    pub unsafe fn as_mut_slice(&mut self, len: usize) -> &mut [T] {
        unsafe { ::core::slice::from_raw_parts_mut(self.as_mut_ptr(), len) }
    }
}
impl<T> ::core::fmt::Debug for __IncompleteArrayField<T> {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.write_str("__IncompleteArrayField")
    }
}
pub const PG_DIAG_SEVERITY: u8 = 83u8;
pub const PG_DIAG_SEVERITY_NONLOCALIZED: u8 = 86u8;
pub const PG_DIAG_SQLSTATE: u8 = 67u8;
pub const PG_DIAG_MESSAGE_PRIMARY: u8 = 77u8;
pub const PG_DIAG_MESSAGE_DETAIL: u8 = 68u8;
pub const PG_DIAG_MESSAGE_HINT: u8 = 72u8;
pub const PG_DIAG_STATEMENT_POSITION: u8 = 80u8;
pub const PG_DIAG_INTERNAL_POSITION: u8 = 112u8;
pub const PG_DIAG_INTERNAL_QUERY: u8 = 113u8;
pub const PG_DIAG_CONTEXT: u8 = 87u8;
pub const PG_DIAG_SCHEMA_NAME: u8 = 115u8;
pub const PG_DIAG_TABLE_NAME: u8 = 116u8;
pub const PG_DIAG_COLUMN_NAME: u8 = 99u8;
pub const PG_DIAG_DATATYPE_NAME: u8 = 100u8;
pub const PG_DIAG_CONSTRAINT_NAME: u8 = 110u8;
pub const PG_DIAG_SOURCE_FILE: u8 = 70u8;
pub const PG_DIAG_SOURCE_LINE: u8 = 76u8;
pub const PG_DIAG_SOURCE_FUNCTION: u8 = 82u8;
pub const ALIGNOF_DOUBLE: u32 = 8;
pub const ALIGNOF_INT: u32 = 4;
pub const ALIGNOF_LONG: u32 = 8;
pub const ALIGNOF_PG_INT128_TYPE: u32 = 16;
pub const ALIGNOF_SHORT: u32 = 2;
pub const BLCKSZ: u32 = 8192;
pub const DEF_PGPORT: u32 = 28815;
pub const DEF_PGPORT_STR: &::core::ffi::CStr = c"28815";
pub const DLSUFFIX: &::core::ffi::CStr = c".so";
pub const ENABLE_THREAD_SAFETY: u32 = 1;
pub const INT64_MODIFIER: &::core::ffi::CStr = c"l";
pub const MAXIMUM_ALIGNOF: u32 = 8;
pub const MEMSET_LOOP_LIMIT: u32 = 1024;
pub const PACKAGE_BUGREPORT: &::core::ffi::CStr = c"pgsql-bugs@lists.postgresql.org";
pub const PACKAGE_NAME: &::core::ffi::CStr = c"PostgreSQL";
pub const PACKAGE_STRING: &::core::ffi::CStr = c"PostgreSQL 15.13";
pub const PACKAGE_TARNAME: &::core::ffi::CStr = c"postgresql";
pub const PACKAGE_URL: &::core::ffi::CStr = c"https://www.postgresql.org/";
pub const PACKAGE_VERSION: &::core::ffi::CStr = c"15.13";
pub const PG_KRB_SRVNAM: &::core::ffi::CStr = c"postgres";
pub const PG_MAJORVERSION: &::core::ffi::CStr = c"15";
pub const PG_MAJORVERSION_NUM: u32 = 15;
pub const PG_MINORVERSION_NUM: u32 = 13;
pub const PG_USE_STDBOOL: u32 = 1;
pub const PG_VERSION: &::core::ffi::CStr = c"15.13";
pub const PG_VERSION_NUM: u32 = 150013;
pub const PG_VERSION_STR : & :: core :: ffi :: CStr = c"PostgreSQL 15.13 on x86_64-pc-linux-gnu, compiled by gcc (Ubuntu 11.4.0-1ubuntu1~22.04) 11.4.0, 64-bit" ;
pub const RELSEG_SIZE: u32 = 131072;
pub const SIZEOF_BOOL: u32 = 1;
pub const SIZEOF_LONG: u32 = 8;
pub const SIZEOF_OFF_T: u32 = 8;
pub const SIZEOF_SIZE_T: u32 = 8;
pub const SIZEOF_VOID_P: u32 = 8;
pub const STDC_HEADERS: u32 = 1;
pub const USE_ASSERT_CHECKING: u32 = 1;
pub const USE_SSE42_CRC32C_WITH_RUNTIME_CHECK: u32 = 1;
pub const USE_SYSV_SHARED_MEMORY: u32 = 1;
pub const USE_UNNAMED_POSIX_SEMAPHORES: u32 = 1;
pub const XLOG_BLCKSZ: u32 = 8192;
pub const DEFAULT_XLOG_SEG_SIZE: u32 = 16777216;
pub const NAMEDATALEN: u32 = 64;
pub const FUNC_MAX_ARGS: u32 = 100;
pub const FMGR_ABI_EXTRA: &::core::ffi::CStr = c"PostgreSQL";
pub const INDEX_MAX_KEYS: u32 = 32;
pub const PARTITION_MAX_KEYS: u32 = 32;
pub const USE_FLOAT8_BYVAL: u32 = 1;
pub const NUM_SPINLOCK_SEMAPHORES: u32 = 128;
pub const NUM_ATOMICS_SEMAPHORES: u32 = 64;
pub const MAXPGPATH: u32 = 1024;
pub const PG_SOMAXCONN: u32 = 10000;
pub const BITS_PER_BYTE: u32 = 8;
pub const ALIGNOF_BUFFER: u32 = 32;
pub const DEFAULT_BACKEND_FLUSH_AFTER: u32 = 0;
pub const DEFAULT_BGWRITER_FLUSH_AFTER: u32 = 64;
pub const DEFAULT_CHECKPOINT_FLUSH_AFTER: u32 = 32;
pub const WRITEBACK_MAX_PENDING_FLUSHES: u32 = 256;
pub const DEFAULT_PGSOCKET_DIR: &::core::ffi::CStr = c"/tmp";
pub const DEFAULT_EVENT_SOURCE: &::core::ffi::CStr = c"PostgreSQL";
pub const PG_CACHE_LINE_SIZE: u32 = 128;
pub const TRACE_SORT: u32 = 1;
pub const SIG_ATOMIC_MIN: i32 = -2147483648;
pub const SIG_ATOMIC_MAX: u32 = 2147483647;
pub const SIG_ATOMIC_WIDTH: u32 = 32;
pub const INT64_FORMAT: &::core::ffi::CStr = c"%ld";
pub const UINT64_FORMAT: &::core::ffi::CStr = c"%lu";
pub const PG_INT8_MIN: i32 = -128;
pub const PG_INT8_MAX: u32 = 127;
pub const PG_UINT8_MAX: u32 = 255;
pub const PG_INT16_MIN: i32 = -32768;
pub const PG_INT16_MAX: u32 = 32767;
pub const PG_UINT16_MAX: u32 = 65535;
pub const PG_INT32_MIN: i32 = -2147483648;
pub const PG_INT32_MAX: u32 = 2147483647;
pub const PG_UINT32_MAX: u32 = 4294967295;
pub const FLOAT8PASSBYVAL: u32 = 1;
pub const HIGHBIT: u32 = 128;
pub const ESCAPE_STRING_SYNTAX: u8 = 69u8;
pub const STATUS_OK: u32 = 0;
pub const STATUS_ERROR: i32 = -1;
pub const STATUS_EOF: i32 = -2;
pub const PG_BINARY: u32 = 0;
pub const PG_BINARY_A: &::core::ffi::CStr = c"a";
pub const PG_BINARY_R: &::core::ffi::CStr = c"r";
pub const PG_BINARY_W: &::core::ffi::CStr = c"w";
pub const PGINVALID_SOCKET: i32 = -1;
pub const PG_BACKEND_VERSIONSTR: &::core::ffi::CStr = c"postgres (PostgreSQL) 15.13\n";
pub const EXE: &::core::ffi::CStr = c"";
pub const DEVNULL: &::core::ffi::CStr = c"/dev/null";
pub const USE_REPL_SNPRINTF: u32 = 1;
pub const PG_STRERROR_R_BUFLEN: u32 = 256;
pub const PG_IOLBF: u32 = 1;
pub const DEBUG5: u32 = 10;
pub const DEBUG4: u32 = 11;
pub const DEBUG3: u32 = 12;
pub const DEBUG2: u32 = 13;
pub const DEBUG1: u32 = 14;
pub const LOG: u32 = 15;
pub const LOG_SERVER_ONLY: u32 = 16;
pub const COMMERROR: u32 = 16;
pub const INFO: u32 = 17;
pub const NOTICE: u32 = 18;
pub const WARNING: u32 = 19;
pub const PGWARNING: u32 = 19;
pub const WARNING_CLIENT_ONLY: u32 = 20;
pub const PGERROR: u32 = 21;
pub const FATAL: u32 = 22;
pub const PANIC: u32 = 23;
pub const LOG_DESTINATION_STDERR: u32 = 1;
pub const LOG_DESTINATION_SYSLOG: u32 = 2;
pub const LOG_DESTINATION_EVENTLOG: u32 = 4;
pub const LOG_DESTINATION_CSVLOG: u32 = 8;
pub const LOG_DESTINATION_JSONLOG: u32 = 16;
pub const MCXT_ALLOC_HUGE: u32 = 1;
pub const MCXT_ALLOC_NO_OOM: u32 = 2;
pub const MCXT_ALLOC_ZERO: u32 = 4;
pub const VARLENA_EXTSIZE_BITS: u32 = 30;
pub const VARLENA_EXTSIZE_MASK: u32 = 1073741823;
pub const VARATT_SHORT_MAX: u32 = 127;
pub const FIELDNO_NULLABLE_DATUM_DATUM: u32 = 0;
pub const FIELDNO_NULLABLE_DATUM_ISNULL: u32 = 1;
pub const SIZEOF_DATUM: u32 = 8;
pub const InvalidAttrNumber: u32 = 0;
pub const MaxAttrNumber: u32 = 32767;
pub const AttributeRelationId: Oid = Oid(1249);
pub const AttributeRelation_Rowtype_Id: u32 = 75;
pub const AttributeRelidNameIndexId: u32 = 2658;
pub const AttributeRelidNumIndexId: u32 = 2659;
pub const Anum_pg_attribute_attrelid: u32 = 1;
pub const Anum_pg_attribute_attname: u32 = 2;
pub const Anum_pg_attribute_atttypid: u32 = 3;
pub const Anum_pg_attribute_attstattarget: u32 = 4;
pub const Anum_pg_attribute_attlen: u32 = 5;
pub const Anum_pg_attribute_attnum: u32 = 6;
pub const Anum_pg_attribute_attndims: u32 = 7;
pub const Anum_pg_attribute_attcacheoff: u32 = 8;
pub const Anum_pg_attribute_atttypmod: u32 = 9;
pub const Anum_pg_attribute_attbyval: u32 = 10;
pub const Anum_pg_attribute_attalign: u32 = 11;
pub const Anum_pg_attribute_attstorage: u32 = 12;
pub const Anum_pg_attribute_attcompression: u32 = 13;
pub const Anum_pg_attribute_attnotnull: u32 = 14;
pub const Anum_pg_attribute_atthasdef: u32 = 15;
pub const Anum_pg_attribute_atthasmissing: u32 = 16;
pub const Anum_pg_attribute_attidentity: u32 = 17;
pub const Anum_pg_attribute_attgenerated: u32 = 18;
pub const Anum_pg_attribute_attisdropped: u32 = 19;
pub const Anum_pg_attribute_attislocal: u32 = 20;
pub const Anum_pg_attribute_attinhcount: u32 = 21;
pub const Anum_pg_attribute_attcollation: u32 = 22;
pub const Anum_pg_attribute_attacl: u32 = 23;
pub const Anum_pg_attribute_attoptions: u32 = 24;
pub const Anum_pg_attribute_attfdwoptions: u32 = 25;
pub const Anum_pg_attribute_attmissingval: u32 = 26;
pub const Natts_pg_attribute: u32 = 26;
pub const ATTRIBUTE_IDENTITY_ALWAYS: u8 = 97u8;
pub const ATTRIBUTE_IDENTITY_BY_DEFAULT: u8 = 100u8;
pub const ATTRIBUTE_GENERATED_STORED: u8 = 115u8;
pub const AGGSPLITOP_COMBINE: u32 = 1;
pub const AGGSPLITOP_SKIPFINAL: u32 = 2;
pub const AGGSPLITOP_SERIALIZE: u32 = 4;
pub const AGGSPLITOP_DESERIALIZE: u32 = 8;
pub const LP_UNUSED: u32 = 0;
pub const LP_NORMAL: u32 = 1;
pub const LP_REDIRECT: u32 = 2;
pub const LP_DEAD: u32 = 3;
pub const SpecTokenOffsetNumber: u32 = 65534;
pub const MovedPartitionsOffsetNumber: u32 = 65533;
pub const FIELDNO_HEAPTUPLEDATA_DATA: u32 = 3;
pub const InvalidXLogRecPtr: u32 = 0;
pub const OPEN_SYNC_FLAG: u32 = 1052672;
pub const OPEN_DATASYNC_FLAG: u32 = 4096;
pub const FirstGenbkiObjectId: u32 = 10000;
pub const FirstUnpinnedObjectId: u32 = 12000;
pub const FirstNormalObjectId: u32 = 16384;
pub const TypeRelationId: Oid = Oid(1247);
pub const TypeRelation_Rowtype_Id: u32 = 71;
pub const TypeOidIndexId: u32 = 2703;
pub const TypeNameNspIndexId: u32 = 2704;
pub const Anum_pg_type_oid: u32 = 1;
pub const Anum_pg_type_typname: u32 = 2;
pub const Anum_pg_type_typnamespace: u32 = 3;
pub const Anum_pg_type_typowner: u32 = 4;
pub const Anum_pg_type_typlen: u32 = 5;
pub const Anum_pg_type_typbyval: u32 = 6;
pub const Anum_pg_type_typtype: u32 = 7;
pub const Anum_pg_type_typcategory: u32 = 8;
pub const Anum_pg_type_typispreferred: u32 = 9;
pub const Anum_pg_type_typisdefined: u32 = 10;
pub const Anum_pg_type_typdelim: u32 = 11;
pub const Anum_pg_type_typrelid: u32 = 12;
pub const Anum_pg_type_typsubscript: u32 = 13;
pub const Anum_pg_type_typelem: u32 = 14;
pub const Anum_pg_type_typarray: u32 = 15;
pub const Anum_pg_type_typinput: u32 = 16;
pub const Anum_pg_type_typoutput: u32 = 17;
pub const Anum_pg_type_typreceive: u32 = 18;
pub const Anum_pg_type_typsend: u32 = 19;
pub const Anum_pg_type_typmodin: u32 = 20;
pub const Anum_pg_type_typmodout: u32 = 21;
pub const Anum_pg_type_typanalyze: u32 = 22;
pub const Anum_pg_type_typalign: u32 = 23;
pub const Anum_pg_type_typstorage: u32 = 24;
pub const Anum_pg_type_typnotnull: u32 = 25;
pub const Anum_pg_type_typbasetype: u32 = 26;
pub const Anum_pg_type_typtypmod: u32 = 27;
pub const Anum_pg_type_typndims: u32 = 28;
pub const Anum_pg_type_typcollation: u32 = 29;
pub const Anum_pg_type_typdefaultbin: u32 = 30;
pub const Anum_pg_type_typdefault: u32 = 31;
pub const Anum_pg_type_typacl: u32 = 32;
pub const Natts_pg_type: u32 = 32;
pub const TYPTYPE_BASE: u8 = 98u8;
pub const TYPTYPE_COMPOSITE: u8 = 99u8;
pub const TYPTYPE_DOMAIN: u8 = 100u8;
pub const TYPTYPE_ENUM: u8 = 101u8;
pub const TYPTYPE_MULTIRANGE: u8 = 109u8;
pub const TYPTYPE_PSEUDO: u8 = 112u8;
pub const TYPTYPE_RANGE: u8 = 114u8;
pub const TYPCATEGORY_INVALID: u8 = 0u8;
pub const TYPCATEGORY_ARRAY: u8 = 65u8;
pub const TYPCATEGORY_BOOLEAN: u8 = 66u8;
pub const TYPCATEGORY_COMPOSITE: u8 = 67u8;
pub const TYPCATEGORY_DATETIME: u8 = 68u8;
pub const TYPCATEGORY_ENUM: u8 = 69u8;
pub const TYPCATEGORY_GEOMETRIC: u8 = 71u8;
pub const TYPCATEGORY_NETWORK: u8 = 73u8;
pub const TYPCATEGORY_NUMERIC: u8 = 78u8;
pub const TYPCATEGORY_PSEUDOTYPE: u8 = 80u8;
pub const TYPCATEGORY_RANGE: u8 = 82u8;
pub const TYPCATEGORY_STRING: u8 = 83u8;
pub const TYPCATEGORY_TIMESPAN: u8 = 84u8;
pub const TYPCATEGORY_USER: u8 = 85u8;
pub const TYPCATEGORY_BITSTRING: u8 = 86u8;
pub const TYPCATEGORY_UNKNOWN: u8 = 88u8;
pub const TYPCATEGORY_INTERNAL: u8 = 90u8;
pub const TYPALIGN_CHAR: u8 = 99u8;
pub const TYPALIGN_SHORT: u8 = 115u8;
pub const TYPALIGN_INT: u8 = 105u8;
pub const TYPALIGN_DOUBLE: u8 = 100u8;
pub const TYPSTORAGE_PLAIN: u8 = 112u8;
pub const TYPSTORAGE_EXTERNAL: u8 = 101u8;
pub const TYPSTORAGE_EXTENDED: u8 = 120u8;
pub const TYPSTORAGE_MAIN: u8 = 109u8;
pub const BOOLOID: Oid = Oid(16);
pub const BYTEAOID: Oid = Oid(17);
pub const CHAROID: Oid = Oid(18);
pub const NAMEOID: Oid = Oid(19);
pub const INT8OID: Oid = Oid(20);
pub const INT2OID: Oid = Oid(21);
pub const INT2VECTOROID: Oid = Oid(22);
pub const INT4OID: Oid = Oid(23);
pub const REGPROCOID: Oid = Oid(24);
pub const TEXTOID: Oid = Oid(25);
pub const OIDOID: Oid = Oid(26);
pub const TIDOID: Oid = Oid(27);
pub const XIDOID: Oid = Oid(28);
pub const CIDOID: Oid = Oid(29);
pub const OIDVECTOROID: Oid = Oid(30);
pub const JSONOID: Oid = Oid(114);
pub const XMLOID: Oid = Oid(142);
pub const PG_NODE_TREEOID: Oid = Oid(194);
pub const PG_NDISTINCTOID: Oid = Oid(3361);
pub const PG_DEPENDENCIESOID: Oid = Oid(3402);
pub const PG_MCV_LISTOID: Oid = Oid(5017);
pub const PG_DDL_COMMANDOID: Oid = Oid(32);
pub const XID8OID: Oid = Oid(5069);
pub const POINTOID: Oid = Oid(600);
pub const LSEGOID: Oid = Oid(601);
pub const PATHOID: Oid = Oid(602);
pub const BOXOID: Oid = Oid(603);
pub const POLYGONOID: Oid = Oid(604);
pub const LINEOID: Oid = Oid(628);
pub const FLOAT4OID: Oid = Oid(700);
pub const FLOAT8OID: Oid = Oid(701);
pub const UNKNOWNOID: Oid = Oid(705);
pub const CIRCLEOID: Oid = Oid(718);
pub const MONEYOID: Oid = Oid(790);
pub const MACADDROID: Oid = Oid(829);
pub const INETOID: Oid = Oid(869);
pub const CIDROID: Oid = Oid(650);
pub const MACADDR8OID: Oid = Oid(774);
pub const ACLITEMOID: Oid = Oid(1033);
pub const BPCHAROID: Oid = Oid(1042);
pub const VARCHAROID: Oid = Oid(1043);
pub const DATEOID: Oid = Oid(1082);
pub const TIMEOID: Oid = Oid(1083);
pub const TIMESTAMPOID: Oid = Oid(1114);
pub const TIMESTAMPTZOID: Oid = Oid(1184);
pub const INTERVALOID: Oid = Oid(1186);
pub const TIMETZOID: Oid = Oid(1266);
pub const BITOID: Oid = Oid(1560);
pub const VARBITOID: Oid = Oid(1562);
pub const NUMERICOID: Oid = Oid(1700);
pub const REFCURSOROID: Oid = Oid(1790);
pub const REGPROCEDUREOID: Oid = Oid(2202);
pub const REGOPEROID: Oid = Oid(2203);
pub const REGOPERATOROID: Oid = Oid(2204);
pub const REGCLASSOID: Oid = Oid(2205);
pub const REGCOLLATIONOID: Oid = Oid(4191);
pub const REGTYPEOID: Oid = Oid(2206);
pub const REGROLEOID: Oid = Oid(4096);
pub const REGNAMESPACEOID: Oid = Oid(4089);
pub const UUIDOID: Oid = Oid(2950);
pub const PG_LSNOID: Oid = Oid(3220);
pub const TSVECTOROID: Oid = Oid(3614);
pub const GTSVECTOROID: Oid = Oid(3642);
pub const TSQUERYOID: Oid = Oid(3615);
pub const REGCONFIGOID: Oid = Oid(3734);
pub const REGDICTIONARYOID: Oid = Oid(3769);
pub const JSONBOID: Oid = Oid(3802);
pub const JSONPATHOID: Oid = Oid(4072);
pub const TXID_SNAPSHOTOID: Oid = Oid(2970);
pub const PG_SNAPSHOTOID: Oid = Oid(5038);
pub const INT4RANGEOID: Oid = Oid(3904);
pub const NUMRANGEOID: Oid = Oid(3906);
pub const TSRANGEOID: Oid = Oid(3908);
pub const TSTZRANGEOID: Oid = Oid(3910);
pub const DATERANGEOID: Oid = Oid(3912);
pub const INT8RANGEOID: Oid = Oid(3926);
pub const INT4MULTIRANGEOID: Oid = Oid(4451);
pub const NUMMULTIRANGEOID: Oid = Oid(4532);
pub const TSMULTIRANGEOID: Oid = Oid(4533);
pub const TSTZMULTIRANGEOID: Oid = Oid(4534);
pub const DATEMULTIRANGEOID: Oid = Oid(4535);
pub const INT8MULTIRANGEOID: Oid = Oid(4536);
pub const RECORDOID: Oid = Oid(2249);
pub const RECORDARRAYOID: Oid = Oid(2287);
pub const CSTRINGOID: Oid = Oid(2275);
pub const ANYOID: Oid = Oid(2276);
pub const ANYARRAYOID: Oid = Oid(2277);
pub const VOIDOID: Oid = Oid(2278);
pub const TRIGGEROID: Oid = Oid(2279);
pub const EVENT_TRIGGEROID: Oid = Oid(3838);
pub const LANGUAGE_HANDLEROID: Oid = Oid(2280);
pub const INTERNALOID: Oid = Oid(2281);
pub const ANYELEMENTOID: Oid = Oid(2283);
pub const ANYNONARRAYOID: Oid = Oid(2776);
pub const ANYENUMOID: Oid = Oid(3500);
pub const FDW_HANDLEROID: Oid = Oid(3115);
pub const INDEX_AM_HANDLEROID: Oid = Oid(325);
pub const TSM_HANDLEROID: Oid = Oid(3310);
pub const TABLE_AM_HANDLEROID: Oid = Oid(269);
pub const ANYRANGEOID: Oid = Oid(3831);
pub const ANYCOMPATIBLEOID: Oid = Oid(5077);
pub const ANYCOMPATIBLEARRAYOID: Oid = Oid(5078);
pub const ANYCOMPATIBLENONARRAYOID: Oid = Oid(5079);
pub const ANYCOMPATIBLERANGEOID: Oid = Oid(5080);
pub const ANYMULTIRANGEOID: Oid = Oid(4537);
pub const ANYCOMPATIBLEMULTIRANGEOID: Oid = Oid(4538);
pub const PG_BRIN_BLOOM_SUMMARYOID: Oid = Oid(4600);
pub const PG_BRIN_MINMAX_MULTI_SUMMARYOID: Oid = Oid(4601);
pub const BOOLARRAYOID: Oid = Oid(1000);
pub const BYTEAARRAYOID: Oid = Oid(1001);
pub const CHARARRAYOID: Oid = Oid(1002);
pub const NAMEARRAYOID: Oid = Oid(1003);
pub const INT8ARRAYOID: Oid = Oid(1016);
pub const INT2ARRAYOID: Oid = Oid(1005);
pub const INT2VECTORARRAYOID: Oid = Oid(1006);
pub const INT4ARRAYOID: Oid = Oid(1007);
pub const REGPROCARRAYOID: Oid = Oid(1008);
pub const TEXTARRAYOID: Oid = Oid(1009);
pub const OIDARRAYOID: Oid = Oid(1028);
pub const TIDARRAYOID: Oid = Oid(1010);
pub const XIDARRAYOID: Oid = Oid(1011);
pub const CIDARRAYOID: Oid = Oid(1012);
pub const OIDVECTORARRAYOID: Oid = Oid(1013);
pub const PG_TYPEARRAYOID: Oid = Oid(210);
pub const PG_ATTRIBUTEARRAYOID: Oid = Oid(270);
pub const PG_PROCARRAYOID: Oid = Oid(272);
pub const PG_CLASSARRAYOID: Oid = Oid(273);
pub const JSONARRAYOID: Oid = Oid(199);
pub const XMLARRAYOID: Oid = Oid(143);
pub const XID8ARRAYOID: Oid = Oid(271);
pub const POINTARRAYOID: Oid = Oid(1017);
pub const LSEGARRAYOID: Oid = Oid(1018);
pub const PATHARRAYOID: Oid = Oid(1019);
pub const BOXARRAYOID: Oid = Oid(1020);
pub const POLYGONARRAYOID: Oid = Oid(1027);
pub const LINEARRAYOID: Oid = Oid(629);
pub const FLOAT4ARRAYOID: Oid = Oid(1021);
pub const FLOAT8ARRAYOID: Oid = Oid(1022);
pub const CIRCLEARRAYOID: Oid = Oid(719);
pub const MONEYARRAYOID: Oid = Oid(791);
pub const MACADDRARRAYOID: Oid = Oid(1040);
pub const INETARRAYOID: Oid = Oid(1041);
pub const CIDRARRAYOID: Oid = Oid(651);
pub const MACADDR8ARRAYOID: Oid = Oid(775);
pub const ACLITEMARRAYOID: Oid = Oid(1034);
pub const BPCHARARRAYOID: Oid = Oid(1014);
pub const VARCHARARRAYOID: Oid = Oid(1015);
pub const DATEARRAYOID: Oid = Oid(1182);
pub const TIMEARRAYOID: Oid = Oid(1183);
pub const TIMESTAMPARRAYOID: Oid = Oid(1115);
pub const TIMESTAMPTZARRAYOID: Oid = Oid(1185);
pub const INTERVALARRAYOID: Oid = Oid(1187);
pub const TIMETZARRAYOID: Oid = Oid(1270);
pub const BITARRAYOID: Oid = Oid(1561);
pub const VARBITARRAYOID: Oid = Oid(1563);
pub const NUMERICARRAYOID: Oid = Oid(1231);
pub const REFCURSORARRAYOID: Oid = Oid(2201);
pub const REGPROCEDUREARRAYOID: Oid = Oid(2207);
pub const REGOPERARRAYOID: Oid = Oid(2208);
pub const REGOPERATORARRAYOID: Oid = Oid(2209);
pub const REGCLASSARRAYOID: Oid = Oid(2210);
pub const REGCOLLATIONARRAYOID: Oid = Oid(4192);
pub const REGTYPEARRAYOID: Oid = Oid(2211);
pub const REGROLEARRAYOID: Oid = Oid(4097);
pub const REGNAMESPACEARRAYOID: Oid = Oid(4090);
pub const UUIDARRAYOID: Oid = Oid(2951);
pub const PG_LSNARRAYOID: Oid = Oid(3221);
pub const TSVECTORARRAYOID: Oid = Oid(3643);
pub const GTSVECTORARRAYOID: Oid = Oid(3644);
pub const TSQUERYARRAYOID: Oid = Oid(3645);
pub const REGCONFIGARRAYOID: Oid = Oid(3735);
pub const REGDICTIONARYARRAYOID: Oid = Oid(3770);
pub const JSONBARRAYOID: Oid = Oid(3807);
pub const JSONPATHARRAYOID: Oid = Oid(4073);
pub const TXID_SNAPSHOTARRAYOID: Oid = Oid(2949);
pub const PG_SNAPSHOTARRAYOID: Oid = Oid(5039);
pub const INT4RANGEARRAYOID: Oid = Oid(3905);
pub const NUMRANGEARRAYOID: Oid = Oid(3907);
pub const TSRANGEARRAYOID: Oid = Oid(3909);
pub const TSTZRANGEARRAYOID: Oid = Oid(3911);
pub const DATERANGEARRAYOID: Oid = Oid(3913);
pub const INT8RANGEARRAYOID: Oid = Oid(3927);
pub const INT4MULTIRANGEARRAYOID: Oid = Oid(6150);
pub const NUMMULTIRANGEARRAYOID: Oid = Oid(6151);
pub const TSMULTIRANGEARRAYOID: Oid = Oid(6152);
pub const TSTZMULTIRANGEARRAYOID: Oid = Oid(6153);
pub const DATEMULTIRANGEARRAYOID: Oid = Oid(6155);
pub const INT8MULTIRANGEARRAYOID: Oid = Oid(6157);
pub const CSTRINGARRAYOID: Oid = Oid(1263);
pub const PD_HAS_FREE_LINES: u32 = 1;
pub const PD_PAGE_FULL: u32 = 2;
pub const PD_ALL_VISIBLE: u32 = 4;
pub const PD_VALID_FLAG_BITS: u32 = 7;
pub const PG_PAGE_LAYOUT_VERSION: u32 = 4;
pub const PG_DATA_CHECKSUM_VERSION: u32 = 1;
pub const PAI_OVERWRITE: u32 = 1;
pub const PAI_IS_HEAP: u32 = 2;
pub const PIV_LOG_WARNING: u32 = 1;
pub const PIV_REPORT_STAT: u32 = 2;
pub const MaxTupleAttributeNumber: u32 = 1664;
pub const MaxHeapAttributeNumber: u32 = 1600;
pub const FIELDNO_HEAPTUPLEHEADERDATA_INFOMASK2: u32 = 2;
pub const FIELDNO_HEAPTUPLEHEADERDATA_INFOMASK: u32 = 3;
pub const FIELDNO_HEAPTUPLEHEADERDATA_HOFF: u32 = 4;
pub const FIELDNO_HEAPTUPLEHEADERDATA_BITS: u32 = 5;
pub const HEAP_HASNULL: u32 = 1;
pub const HEAP_HASVARWIDTH: u32 = 2;
pub const HEAP_HASEXTERNAL: u32 = 4;
pub const HEAP_HASOID_OLD: u32 = 8;
pub const HEAP_XMAX_KEYSHR_LOCK: u32 = 16;
pub const HEAP_COMBOCID: u32 = 32;
pub const HEAP_XMAX_EXCL_LOCK: u32 = 64;
pub const HEAP_XMAX_LOCK_ONLY: u32 = 128;
pub const HEAP_XMAX_SHR_LOCK: u32 = 80;
pub const HEAP_LOCK_MASK: u32 = 80;
pub const HEAP_XMIN_COMMITTED: u32 = 256;
pub const HEAP_XMIN_INVALID: u32 = 512;
pub const HEAP_XMIN_FROZEN: u32 = 768;
pub const HEAP_XMAX_COMMITTED: u32 = 1024;
pub const HEAP_XMAX_INVALID: u32 = 2048;
pub const HEAP_XMAX_IS_MULTI: u32 = 4096;
pub const HEAP_UPDATED: u32 = 8192;
pub const HEAP_MOVED_OFF: u32 = 16384;
pub const HEAP_MOVED_IN: u32 = 32768;
pub const HEAP_MOVED: u32 = 49152;
pub const HEAP_XACT_MASK: u32 = 65520;
pub const HEAP_XMAX_BITS: u32 = 7376;
pub const HEAP_NATTS_MASK: u32 = 2047;
pub const HEAP_KEYS_UPDATED: u32 = 8192;
pub const HEAP_HOT_UPDATED: u32 = 16384;
pub const HEAP_ONLY_TUPLE: u32 = 32768;
pub const HEAP2_XACT_MASK: u32 = 57344;
pub const HEAP_TUPLE_HAS_MATCH: u32 = 32768;
pub const MaxAttrSize: u32 = 10485760;
pub const SelfItemPointerAttributeNumber: i32 = -1;
pub const MinTransactionIdAttributeNumber: i32 = -2;
pub const MinCommandIdAttributeNumber: i32 = -3;
pub const MaxTransactionIdAttributeNumber: i32 = -4;
pub const MaxCommandIdAttributeNumber: i32 = -5;
pub const TableOidAttributeNumber: i32 = -6;
pub const FirstLowInvalidHeapAttributeNumber: i32 = -7;
pub const InvalidBuffer: u32 = 0;
pub const TTS_FLAG_EMPTY: u32 = 2;
pub const TTS_FLAG_SHOULDFREE: u32 = 4;
pub const TTS_FLAG_SLOW: u32 = 8;
pub const TTS_FLAG_FIXED: u32 = 16;
pub const FIELDNO_TUPLETABLESLOT_FLAGS: u32 = 1;
pub const FIELDNO_TUPLETABLESLOT_NVALID: u32 = 2;
pub const FIELDNO_TUPLETABLESLOT_TUPLEDESCRIPTOR: u32 = 4;
pub const FIELDNO_TUPLETABLESLOT_VALUES: u32 = 5;
pub const FIELDNO_TUPLETABLESLOT_ISNULL: u32 = 6;
pub const FIELDNO_HEAPTUPLETABLESLOT_TUPLE: u32 = 1;
pub const FIELDNO_HEAPTUPLETABLESLOT_OFF: u32 = 2;
pub const FIELDNO_MINIMALTUPLETABLESLOT_TUPLE: u32 = 1;
pub const FIELDNO_MINIMALTUPLETABLESLOT_OFF: u32 = 4;
pub const BITS_PER_BITMAPWORD: u32 = 64;
pub const PG_INSTR_CLOCK: u32 = 1;
pub const FIELDNO_FUNCTIONCALLINFODATA_ISNULL: u32 = 4;
pub const FIELDNO_FUNCTIONCALLINFODATA_ARGS: u32 = 6;
pub const PG_MAGIC_FUNCTION_NAME_STRING: &::core::ffi::CStr = c"Pg_magic_func";
pub const AGG_CONTEXT_AGGREGATE: u32 = 1;
pub const AGG_CONTEXT_WINDOW: u32 = 2;
pub const PARAM_FLAG_CONST: u32 = 1;
pub const BTLessStrategyNumber: u32 = 1;
pub const BTLessEqualStrategyNumber: u32 = 2;
pub const BTEqualStrategyNumber: u32 = 3;
pub const BTGreaterEqualStrategyNumber: u32 = 4;
pub const BTGreaterStrategyNumber: u32 = 5;
pub const BTMaxStrategyNumber: u32 = 5;
pub const HTEqualStrategyNumber: u32 = 1;
pub const HTMaxStrategyNumber: u32 = 1;
pub const RTLeftStrategyNumber: u32 = 1;
pub const RTOverLeftStrategyNumber: u32 = 2;
pub const RTOverlapStrategyNumber: u32 = 3;
pub const RTOverRightStrategyNumber: u32 = 4;
pub const RTRightStrategyNumber: u32 = 5;
pub const RTSameStrategyNumber: u32 = 6;
pub const RTContainsStrategyNumber: u32 = 7;
pub const RTContainedByStrategyNumber: u32 = 8;
pub const RTOverBelowStrategyNumber: u32 = 9;
pub const RTBelowStrategyNumber: u32 = 10;
pub const RTAboveStrategyNumber: u32 = 11;
pub const RTOverAboveStrategyNumber: u32 = 12;
pub const RTOldContainsStrategyNumber: u32 = 13;
pub const RTOldContainedByStrategyNumber: u32 = 14;
pub const RTKNNSearchStrategyNumber: u32 = 15;
pub const RTContainsElemStrategyNumber: u32 = 16;
pub const RTAdjacentStrategyNumber: u32 = 17;
pub const RTEqualStrategyNumber: u32 = 18;
pub const RTNotEqualStrategyNumber: u32 = 19;
pub const RTLessStrategyNumber: u32 = 20;
pub const RTLessEqualStrategyNumber: u32 = 21;
pub const RTGreaterStrategyNumber: u32 = 22;
pub const RTGreaterEqualStrategyNumber: u32 = 23;
pub const RTSubStrategyNumber: u32 = 24;
pub const RTSubEqualStrategyNumber: u32 = 25;
pub const RTSuperStrategyNumber: u32 = 26;
pub const RTSuperEqualStrategyNumber: u32 = 27;
pub const RTPrefixStrategyNumber: u32 = 28;
pub const RTOldBelowStrategyNumber: u32 = 29;
pub const RTOldAboveStrategyNumber: u32 = 30;
pub const RTMaxStrategyNumber: u32 = 30;
pub const INNER_VAR: i32 = -1;
pub const OUTER_VAR: i32 = -2;
pub const INDEX_VAR: i32 = -3;
pub const ROWID_VAR: i32 = -4;
pub const PRS2_OLD_VARNO: u32 = 1;
pub const PRS2_NEW_VARNO: u32 = 2;
pub const ACL_INSERT: u32 = 1;
pub const ACL_SELECT: u32 = 2;
pub const ACL_UPDATE: u32 = 4;
pub const ACL_DELETE: u32 = 8;
pub const ACL_TRUNCATE: u32 = 16;
pub const ACL_REFERENCES: u32 = 32;
pub const ACL_TRIGGER: u32 = 64;
pub const ACL_EXECUTE: u32 = 128;
pub const ACL_USAGE: u32 = 256;
pub const ACL_CREATE: u32 = 512;
pub const ACL_CREATE_TEMP: u32 = 1024;
pub const ACL_CONNECT: u32 = 2048;
pub const ACL_SET: u32 = 4096;
pub const ACL_ALTER_SYSTEM: u32 = 8192;
pub const N_ACL_RIGHTS: u32 = 14;
pub const ACL_NO_RIGHTS: u32 = 0;
pub const ACL_SELECT_FOR_UPDATE: u32 = 4;
pub const FRAMEOPTION_NONDEFAULT: u32 = 1;
pub const FRAMEOPTION_RANGE: u32 = 2;
pub const FRAMEOPTION_ROWS: u32 = 4;
pub const FRAMEOPTION_GROUPS: u32 = 8;
pub const FRAMEOPTION_BETWEEN: u32 = 16;
pub const FRAMEOPTION_START_UNBOUNDED_PRECEDING: u32 = 32;
pub const FRAMEOPTION_END_UNBOUNDED_PRECEDING: u32 = 64;
pub const FRAMEOPTION_START_UNBOUNDED_FOLLOWING: u32 = 128;
pub const FRAMEOPTION_END_UNBOUNDED_FOLLOWING: u32 = 256;
pub const FRAMEOPTION_START_CURRENT_ROW: u32 = 512;
pub const FRAMEOPTION_END_CURRENT_ROW: u32 = 1024;
pub const FRAMEOPTION_START_OFFSET_PRECEDING: u32 = 2048;
pub const FRAMEOPTION_END_OFFSET_PRECEDING: u32 = 4096;
pub const FRAMEOPTION_START_OFFSET_FOLLOWING: u32 = 8192;
pub const FRAMEOPTION_END_OFFSET_FOLLOWING: u32 = 16384;
pub const FRAMEOPTION_EXCLUDE_CURRENT_ROW: u32 = 32768;
pub const FRAMEOPTION_EXCLUDE_GROUP: u32 = 65536;
pub const FRAMEOPTION_EXCLUDE_TIES: u32 = 131072;
pub const FRAMEOPTION_START_OFFSET: u32 = 10240;
pub const FRAMEOPTION_END_OFFSET: u32 = 20480;
pub const FRAMEOPTION_EXCLUSION: u32 = 229376;
pub const FRAMEOPTION_DEFAULTS: u32 = 1058;
pub const PARTITION_STRATEGY_HASH: u8 = 104u8;
pub const PARTITION_STRATEGY_LIST: u8 = 108u8;
pub const PARTITION_STRATEGY_RANGE: u8 = 114u8;
pub const FKCONSTR_ACTION_NOACTION: u8 = 97u8;
pub const FKCONSTR_ACTION_RESTRICT: u8 = 114u8;
pub const FKCONSTR_ACTION_CASCADE: u8 = 99u8;
pub const FKCONSTR_ACTION_SETNULL: u8 = 110u8;
pub const FKCONSTR_ACTION_SETDEFAULT: u8 = 100u8;
pub const FKCONSTR_MATCH_FULL: u8 = 102u8;
pub const FKCONSTR_MATCH_PARTIAL: u8 = 112u8;
pub const FKCONSTR_MATCH_SIMPLE: u8 = 115u8;
pub const OPCLASS_ITEM_OPERATOR: u32 = 1;
pub const OPCLASS_ITEM_FUNCTION: u32 = 2;
pub const OPCLASS_ITEM_STORAGETYPE: u32 = 3;
pub const CURSOR_OPT_BINARY: u32 = 1;
pub const CURSOR_OPT_SCROLL: u32 = 2;
pub const CURSOR_OPT_NO_SCROLL: u32 = 4;
pub const CURSOR_OPT_INSENSITIVE: u32 = 8;
pub const CURSOR_OPT_ASENSITIVE: u32 = 16;
pub const CURSOR_OPT_HOLD: u32 = 32;
pub const CURSOR_OPT_FAST_PLAN: u32 = 256;
pub const CURSOR_OPT_GENERIC_PLAN: u32 = 512;
pub const CURSOR_OPT_CUSTOM_PLAN: u32 = 1024;
pub const CURSOR_OPT_PARALLEL_OK: u32 = 2048;
pub const DSM_IMPL_POSIX: u32 = 1;
pub const DSM_IMPL_SYSV: u32 = 2;
pub const DSM_IMPL_WINDOWS: u32 = 3;
pub const DSM_IMPL_MMAP: u32 = 4;
pub const DEFAULT_DYNAMIC_SHARED_MEMORY_TYPE: u32 = 1;
pub const PG_DYNSHMEM_DIR: &::core::ffi::CStr = c"pg_dynshmem";
pub const PG_DYNSHMEM_MMAP_FILE_PREFIX: &::core::ffi::CStr = c"mmap.";
pub const DSM_CREATE_NULL_IF_MAXSEGMENTS: u32 = 1;
pub const DSM_HANDLE_INVALID: u32 = 0;
pub const SIZEOF_DSA_POINTER: u32 = 8;
pub const DSA_POINTER_FORMAT: &::core::ffi::CStr = c"%016lx";
pub const DSA_ALLOC_HUGE: u32 = 1;
pub const DSA_ALLOC_NO_OOM: u32 = 2;
pub const DSA_ALLOC_ZERO: u32 = 4;
pub const DEFAULT_SPINS_PER_DELAY: u32 = 100;
pub const HASH_PARTITION: u32 = 1;
pub const HASH_SEGMENT: u32 = 2;
pub const HASH_DIRSIZE: u32 = 4;
pub const HASH_ELEM: u32 = 8;
pub const HASH_STRINGS: u32 = 16;
pub const HASH_BLOBS: u32 = 32;
pub const HASH_FUNCTION: u32 = 64;
pub const HASH_COMPARE: u32 = 128;
pub const HASH_KEYCOPY: u32 = 256;
pub const HASH_ALLOC: u32 = 512;
pub const HASH_CONTEXT: u32 = 1024;
pub const HASH_SHARED_MEM: u32 = 2048;
pub const HASH_ATTACH: u32 = 4096;
pub const HASH_FIXED_SIZE: u32 = 8192;
pub const NO_MAX_DSIZE: i32 = -1;
pub const PG_O_DIRECT: u32 = 16384;
pub const PG_TEMP_FILES_DIR: &::core::ffi::CStr = c"pgsql_tmp";
pub const PG_TEMP_FILE_PREFIX: &::core::ffi::CStr = c"pgsql_tmp";
pub const SHARED_TUPLESTORE_SINGLE_PASS: u32 = 1;
pub const MAX_TIMESTAMP_PRECISION: u32 = 6;
pub const MAX_INTERVAL_PRECISION: u32 = 6;
pub const TS_PREC_INV: f64 = 1000000.0;
pub const DAYS_PER_YEAR: f64 = 365.25;
pub const MONTHS_PER_YEAR: u32 = 12;
pub const DAYS_PER_MONTH: u32 = 30;
pub const HOURS_PER_DAY: u32 = 24;
pub const SECS_PER_YEAR: u32 = 31557600;
pub const SECS_PER_DAY: u32 = 86400;
pub const SECS_PER_HOUR: u32 = 3600;
pub const SECS_PER_MINUTE: u32 = 60;
pub const MINS_PER_HOUR: u32 = 60;
pub const MAX_TZDISP_HOUR: u32 = 15;
pub const TZDISP_LIMIT: u32 = 57600;
pub const JULIAN_MINYEAR: i32 = -4713;
pub const JULIAN_MINMONTH: u32 = 11;
pub const JULIAN_MINDAY: u32 = 24;
pub const JULIAN_MAXYEAR: u32 = 5874898;
pub const JULIAN_MAXMONTH: u32 = 6;
pub const JULIAN_MAXDAY: u32 = 3;
pub const UNIX_EPOCH_JDATE: u32 = 2440588;
pub const POSTGRES_EPOCH_JDATE: u32 = 2451545;
pub const DATETIME_MIN_JULIAN: u32 = 0;
pub const DATE_END_JULIAN: u32 = 2147483494;
pub const TIMESTAMP_END_JULIAN: u32 = 109203528;
pub const RELCACHE_INIT_FILENAME: &::core::ffi::CStr = c"pg_internal.init";
pub const INDEX_SIZE_MASK: u32 = 8191;
pub const INDEX_AM_RESERVED_BIT: u32 = 8192;
pub const INDEX_VAR_MASK: u32 = 16384;
pub const INDEX_NULL_MASK: u32 = 32768;
pub const NUM_TUPLESORTMETHODS: u32 = 4;
pub const TUPLESORT_NONE: u32 = 0;
pub const TUPLESORT_RANDOMACCESS: u32 = 1;
pub const TUPLESORT_ALLOWBOUNDED: u32 = 2;
pub const EEO_FLAG_IS_QUAL: u32 = 1;
pub const FIELDNO_EXPRSTATE_RESNULL: u32 = 2;
pub const FIELDNO_EXPRSTATE_RESVALUE: u32 = 3;
pub const FIELDNO_EXPRSTATE_RESULTSLOT: u32 = 4;
pub const FIELDNO_EXPRSTATE_PARENT: u32 = 11;
pub const FIELDNO_EXPRCONTEXT_SCANTUPLE: u32 = 1;
pub const FIELDNO_EXPRCONTEXT_INNERTUPLE: u32 = 2;
pub const FIELDNO_EXPRCONTEXT_OUTERTUPLE: u32 = 3;
pub const FIELDNO_EXPRCONTEXT_AGGVALUES: u32 = 8;
pub const FIELDNO_EXPRCONTEXT_AGGNULLS: u32 = 9;
pub const FIELDNO_EXPRCONTEXT_CASEDATUM: u32 = 10;
pub const FIELDNO_EXPRCONTEXT_CASENULL: u32 = 11;
pub const FIELDNO_EXPRCONTEXT_DOMAINDATUM: u32 = 12;
pub const FIELDNO_EXPRCONTEXT_DOMAINNULL: u32 = 13;
pub const TRY_POPCNT_FAST: u32 = 1;
pub const MERGE_INSERT: u32 = 1;
pub const MERGE_UPDATE: u32 = 2;
pub const MERGE_DELETE: u32 = 4;
pub const FIELDNO_AGGSTATE_CURAGGCONTEXT: u32 = 14;
pub const FIELDNO_AGGSTATE_CURPERTRANS: u32 = 16;
pub const FIELDNO_AGGSTATE_CURRENT_SET: u32 = 20;
pub const FIELDNO_AGGSTATE_ALL_PERGROUPS: u32 = 53;
pub const COMPLETION_TAG_BUFSIZE: u32 = 64;
pub const MaxAllocHugeSize: u32 = 0;
pub const ALLOCSET_DEFAULT_MINSIZE: u32 = 0;
pub const ALLOCSET_DEFAULT_INITSIZE: u32 = 8192;
pub const ALLOCSET_DEFAULT_MAXSIZE: u32 = 8388608;
pub const ALLOCSET_SMALL_MINSIZE: u32 = 0;
pub const ALLOCSET_SMALL_INITSIZE: u32 = 1024;
pub const ALLOCSET_SMALL_MAXSIZE: u32 = 8192;
pub const ALLOCSET_SEPARATE_THRESHOLD: u32 = 8192;
pub const SLAB_DEFAULT_BLOCK_SIZE: u32 = 8192;
pub const SLAB_LARGE_BLOCK_SIZE: u32 = 8388608;
pub const EXEC_FLAG_EXPLAIN_ONLY: u32 = 1;
pub const EXEC_FLAG_REWIND: u32 = 2;
pub const EXEC_FLAG_BACKWARD: u32 = 4;
pub const EXEC_FLAG_MARK: u32 = 8;
pub const EXEC_FLAG_SKIP_TRIGGERS: u32 = 16;
pub const EXEC_FLAG_WITH_NO_DATA: u32 = 32;
pub const MAT_SRF_USE_EXPECTED_DESC: u32 = 1;
pub const MAT_SRF_BLESS: u32 = 2;
pub const SRF_SINGLE_USE_EXPECTED: u32 = 1;
pub const SRF_SINGLE_BLESS: u32 = 2;
pub const SIGINT: u32 = 2;
pub const SIGILL: u32 = 4;
pub const SIGABRT: u32 = 6;
pub const SIGFPE: u32 = 8;
pub const SIGSEGV: u32 = 11;
pub const SIGTERM: u32 = 15;
pub const SIGHUP: u32 = 1;
pub const SIGQUIT: u32 = 3;
pub const SIGTRAP: u32 = 5;
pub const SIGKILL: u32 = 9;
pub const SIGPIPE: u32 = 13;
pub const SIGALRM: u32 = 14;
pub const SIGIOT: u32 = 6;
pub const SIGSTKFLT: u32 = 16;
pub const SIGPWR: u32 = 30;
pub const SIGBUS: u32 = 7;
pub const SIGSYS: u32 = 31;
pub const SIGURG: u32 = 23;
pub const SIGSTOP: u32 = 19;
pub const SIGTSTP: u32 = 20;
pub const SIGCONT: u32 = 18;
pub const SIGCHLD: u32 = 17;
pub const SIGTTIN: u32 = 21;
pub const SIGTTOU: u32 = 22;
pub const SIGPOLL: u32 = 29;
pub const SIGXFSZ: u32 = 25;
pub const SIGXCPU: u32 = 24;
pub const SIGVTALRM: u32 = 26;
pub const SIGPROF: u32 = 27;
pub const SIGUSR1: u32 = 10;
pub const SIGUSR2: u32 = 12;
pub const SIGWINCH: u32 = 28;
pub const SIGIO: u32 = 29;
pub const SIGCLD: u32 = 17;
pub const SIG_BLOCK: u32 = 0;
pub const SIG_UNBLOCK: u32 = 1;
pub const SIG_SETMASK: u32 = 2;
pub const SIGSTKSZ: u32 = 8192;
pub const TZ_STRLEN_MAX: u32 = 255;
pub const InvalidPid: i32 = -1;
pub const USE_POSTGRES_DATES: u32 = 0;
pub const USE_ISO_DATES: u32 = 1;
pub const USE_SQL_DATES: u32 = 2;
pub const USE_GERMAN_DATES: u32 = 3;
pub const USE_XSD_DATES: u32 = 4;
pub const DATEORDER_YMD: u32 = 0;
pub const DATEORDER_DMY: u32 = 1;
pub const DATEORDER_MDY: u32 = 2;
pub const INTSTYLE_POSTGRES: u32 = 0;
pub const INTSTYLE_POSTGRES_VERBOSE: u32 = 1;
pub const INTSTYLE_SQL_STANDARD: u32 = 2;
pub const INTSTYLE_ISO_8601: u32 = 3;
pub const MAXTZLEN: u32 = 10;
pub const SECURITY_LOCAL_USERID_CHANGE: u32 = 1;
pub const SECURITY_RESTRICTED_OPERATION: u32 = 2;
pub const SECURITY_NOFORCE_RLS: u32 = 4;
pub const MIN_XFN_CHARS: u32 = 16;
pub const MAX_XFN_CHARS: u32 = 40;
pub const VALID_XFN_CHARS: &::core::ffi::CStr = c"0123456789ABCDEF.history.backup.partial";
pub const PGSTAT_NUM_PROGRESS_PARAM: u32 = 20;
pub const MAX_STARTUP_PACKET_LENGTH: u32 = 10000;
pub const AUTH_REQ_OK: u32 = 0;
pub const AUTH_REQ_KRB4: u32 = 1;
pub const AUTH_REQ_KRB5: u32 = 2;
pub const AUTH_REQ_PASSWORD: u32 = 3;
pub const AUTH_REQ_CRYPT: u32 = 4;
pub const AUTH_REQ_MD5: u32 = 5;
pub const AUTH_REQ_SCM_CREDS: u32 = 6;
pub const AUTH_REQ_GSS: u32 = 7;
pub const AUTH_REQ_GSS_CONT: u32 = 8;
pub const AUTH_REQ_SSPI: u32 = 9;
pub const AUTH_REQ_SASL: u32 = 10;
pub const AUTH_REQ_SASL_CONT: u32 = 11;
pub const AUTH_REQ_SASL_FIN: u32 = 12;
pub const PG_WAIT_LWLOCK: u32 = 16777216;
pub const PG_WAIT_LOCK: u32 = 50331648;
pub const PG_WAIT_BUFFER_PIN: u32 = 67108864;
pub const PG_WAIT_ACTIVITY: u32 = 83886080;
pub const PG_WAIT_CLIENT: u32 = 100663296;
pub const PG_WAIT_EXTENSION: u32 = 117440512;
pub const PG_WAIT_IPC: u32 = 134217728;
pub const PG_WAIT_TIMEOUT: u32 = 150994944;
pub const PG_WAIT_IO: u32 = 167772160;
pub const PGSTAT_STAT_PERMANENT_DIRECTORY: &::core::ffi::CStr = c"pg_stat";
pub const PGSTAT_STAT_PERMANENT_FILENAME: &::core::ffi::CStr = c"pg_stat/pgstat.stat";
pub const PGSTAT_STAT_PERMANENT_TMPFILE: &::core::ffi::CStr = c"pg_stat/pgstat.tmp";
pub const PG_STAT_TMP_DIR: &::core::ffi::CStr = c"pg_stat_tmp";
pub const PGSTAT_FILE_FORMAT_ID: u32 = 27638951;
pub const SK_ISNULL: u32 = 1;
pub const SK_UNARY: u32 = 2;
pub const SK_ROW_HEADER: u32 = 4;
pub const SK_ROW_MEMBER: u32 = 8;
pub const SK_ROW_END: u32 = 16;
pub const SK_SEARCHARRAY: u32 = 32;
pub const SK_SEARCHNULL: u32 = 64;
pub const SK_SEARCHNOTNULL: u32 = 128;
pub const SK_ORDER_BY: u32 = 256;
pub const NoLock: u32 = 0;
pub const AccessShareLock: u32 = 1;
pub const RowShareLock: u32 = 2;
pub const RowExclusiveLock: u32 = 3;
pub const ShareUpdateExclusiveLock: u32 = 4;
pub const ShareLock: u32 = 5;
pub const ShareRowExclusiveLock: u32 = 6;
pub const ExclusiveLock: u32 = 7;
pub const AccessExclusiveLock: u32 = 8;
pub const MaxLockMode: u32 = 8;
pub const InplaceUpdateTupleLock: u32 = 7;
pub const RM_MAX_ID: u32 = 255;
pub const RM_MIN_CUSTOM_ID: u32 = 128;
pub const RM_MAX_CUSTOM_ID: u32 = 255;
pub const RM_N_IDS: u32 = 256;
pub const RM_N_CUSTOM_IDS: u32 = 128;
pub const RM_EXPERIMENTAL_ID: u32 = 128;
pub const CATALOG_VERSION_NO: u32 = 202209061;
pub const OIDCHARS: u32 = 10;
pub const FORKNAMECHARS: u32 = 4;
pub const InvalidBackendId: i32 = -1;
pub const XLR_INFO_MASK: u32 = 15;
pub const XLR_RMGR_INFO_MASK: u32 = 240;
pub const XLR_SPECIAL_REL_UPDATE: u32 = 1;
pub const XLR_CHECK_CONSISTENCY: u32 = 2;
pub const BKPIMAGE_HAS_HOLE: u32 = 1;
pub const BKPIMAGE_APPLY: u32 = 2;
pub const BKPIMAGE_COMPRESS_PGLZ: u32 = 4;
pub const BKPIMAGE_COMPRESS_LZ4: u32 = 8;
pub const BKPIMAGE_COMPRESS_ZSTD: u32 = 16;
pub const BKPBLOCK_FORK_MASK: u32 = 15;
pub const BKPBLOCK_FLAG_MASK: u32 = 240;
pub const BKPBLOCK_HAS_IMAGE: u32 = 16;
pub const BKPBLOCK_HAS_DATA: u32 = 32;
pub const BKPBLOCK_WILL_INIT: u32 = 64;
pub const BKPBLOCK_SAME_REL: u32 = 128;
pub const XLR_MAX_BLOCK_ID: u32 = 32;
pub const XLR_BLOCK_ID_DATA_SHORT: u32 = 255;
pub const XLR_BLOCK_ID_DATA_LONG: u32 = 254;
pub const XLR_BLOCK_ID_ORIGIN: u32 = 253;
pub const XLR_BLOCK_ID_TOPLEVEL_XID: u32 = 252;
pub const SYNC_METHOD_FSYNC: u32 = 0;
pub const SYNC_METHOD_FDATASYNC: u32 = 1;
pub const SYNC_METHOD_OPEN: u32 = 2;
pub const SYNC_METHOD_FSYNC_WRITETHROUGH: u32 = 3;
pub const SYNC_METHOD_OPEN_DSYNC: u32 = 4;
pub const CHECKPOINT_IS_SHUTDOWN: u32 = 1;
pub const CHECKPOINT_END_OF_RECOVERY: u32 = 2;
pub const CHECKPOINT_IMMEDIATE: u32 = 4;
pub const CHECKPOINT_FORCE: u32 = 8;
pub const CHECKPOINT_FLUSH_ALL: u32 = 16;
pub const CHECKPOINT_WAIT: u32 = 32;
pub const CHECKPOINT_REQUESTED: u32 = 64;
pub const CHECKPOINT_CAUSE_XLOG: u32 = 128;
pub const CHECKPOINT_CAUSE_TIME: u32 = 256;
pub const XLOG_INCLUDE_ORIGIN: u32 = 1;
pub const XLOG_MARK_UNIMPORTANT: u32 = 2;
pub const RECOVERY_SIGNAL_FILE: &::core::ffi::CStr = c"recovery.signal";
pub const STANDBY_SIGNAL_FILE: &::core::ffi::CStr = c"standby.signal";
pub const BACKUP_LABEL_FILE: &::core::ffi::CStr = c"backup_label";
pub const BACKUP_LABEL_OLD: &::core::ffi::CStr = c"backup_label.old";
pub const TABLESPACE_MAP: &::core::ffi::CStr = c"tablespace_map";
pub const TABLESPACE_MAP_OLD: &::core::ffi::CStr = c"tablespace_map.old";
pub const PROMOTE_SIGNAL_FILE: &::core::ffi::CStr = c"promote";
pub const XLOG_PAGE_MAGIC: u32 = 53520;
pub const XLP_FIRST_IS_CONTRECORD: u32 = 1;
pub const XLP_LONG_HEADER: u32 = 2;
pub const XLP_BKP_REMOVABLE: u32 = 4;
pub const XLP_FIRST_IS_OVERWRITE_CONTRECORD: u32 = 8;
pub const XLP_ALL_FLAGS: u32 = 15;
pub const WalSegMinSize: u32 = 1048576;
pub const WalSegMaxSize: u32 = 1073741824;
pub const DEFAULT_MIN_WAL_SEGS: u32 = 5;
pub const DEFAULT_MAX_WAL_SEGS: u32 = 64;
pub const XLOGDIR: &::core::ffi::CStr = c"pg_wal";
pub const XLOG_CONTROL_FILE: &::core::ffi::CStr = c"global/pg_control";
pub const MAXFNAMELEN: u32 = 64;
pub const XLOG_FNAME_LEN: u32 = 24;
pub const XLR_NORMAL_MAX_BLOCK_ID: u32 = 4;
pub const XLR_NORMAL_RDATAS: u32 = 20;
pub const REGBUF_FORCE_IMAGE: u32 = 1;
pub const REGBUF_NO_IMAGE: u32 = 2;
pub const REGBUF_WILL_INIT: u32 = 6;
pub const REGBUF_STANDARD: u32 = 8;
pub const REGBUF_KEEP_DATA: u32 = 16;
pub const RelationRelationId: Oid = Oid(1259);
pub const RelationRelation_Rowtype_Id: u32 = 83;
pub const ClassOidIndexId: u32 = 2662;
pub const ClassNameNspIndexId: u32 = 2663;
pub const ClassTblspcRelfilenodeIndexId: u32 = 3455;
pub const Anum_pg_class_oid: u32 = 1;
pub const Anum_pg_class_relname: u32 = 2;
pub const Anum_pg_class_relnamespace: u32 = 3;
pub const Anum_pg_class_reltype: u32 = 4;
pub const Anum_pg_class_reloftype: u32 = 5;
pub const Anum_pg_class_relowner: u32 = 6;
pub const Anum_pg_class_relam: u32 = 7;
pub const Anum_pg_class_relfilenode: u32 = 8;
pub const Anum_pg_class_reltablespace: u32 = 9;
pub const Anum_pg_class_relpages: u32 = 10;
pub const Anum_pg_class_reltuples: u32 = 11;
pub const Anum_pg_class_relallvisible: u32 = 12;
pub const Anum_pg_class_reltoastrelid: u32 = 13;
pub const Anum_pg_class_relhasindex: u32 = 14;
pub const Anum_pg_class_relisshared: u32 = 15;
pub const Anum_pg_class_relpersistence: u32 = 16;
pub const Anum_pg_class_relkind: u32 = 17;
pub const Anum_pg_class_relnatts: u32 = 18;
pub const Anum_pg_class_relchecks: u32 = 19;
pub const Anum_pg_class_relhasrules: u32 = 20;
pub const Anum_pg_class_relhastriggers: u32 = 21;
pub const Anum_pg_class_relhassubclass: u32 = 22;
pub const Anum_pg_class_relrowsecurity: u32 = 23;
pub const Anum_pg_class_relforcerowsecurity: u32 = 24;
pub const Anum_pg_class_relispopulated: u32 = 25;
pub const Anum_pg_class_relreplident: u32 = 26;
pub const Anum_pg_class_relispartition: u32 = 27;
pub const Anum_pg_class_relrewrite: u32 = 28;
pub const Anum_pg_class_relfrozenxid: u32 = 29;
pub const Anum_pg_class_relminmxid: u32 = 30;
pub const Anum_pg_class_relacl: u32 = 31;
pub const Anum_pg_class_reloptions: u32 = 32;
pub const Anum_pg_class_relpartbound: u32 = 33;
pub const Natts_pg_class: u32 = 33;
pub const RELKIND_RELATION: u8 = 114u8;
pub const RELKIND_INDEX: u8 = 105u8;
pub const RELKIND_SEQUENCE: u8 = 83u8;
pub const RELKIND_TOASTVALUE: u8 = 116u8;
pub const RELKIND_VIEW: u8 = 118u8;
pub const RELKIND_MATVIEW: u8 = 109u8;
pub const RELKIND_COMPOSITE_TYPE: u8 = 99u8;
pub const RELKIND_FOREIGN_TABLE: u8 = 102u8;
pub const RELKIND_PARTITIONED_TABLE: u8 = 112u8;
pub const RELKIND_PARTITIONED_INDEX: u8 = 73u8;
pub const RELPERSISTENCE_PERMANENT: u8 = 112u8;
pub const RELPERSISTENCE_UNLOGGED: u8 = 117u8;
pub const RELPERSISTENCE_TEMP: u8 = 116u8;
pub const REPLICA_IDENTITY_DEFAULT: u8 = 100u8;
pub const REPLICA_IDENTITY_NOTHING: u8 = 110u8;
pub const REPLICA_IDENTITY_FULL: u8 = 102u8;
pub const REPLICA_IDENTITY_INDEX: u8 = 105u8;
pub const IndexRelationId: Oid = Oid(2610);
pub const IndexIndrelidIndexId: u32 = 2678;
pub const IndexRelidIndexId: u32 = 2679;
pub const Anum_pg_index_indexrelid: u32 = 1;
pub const Anum_pg_index_indrelid: u32 = 2;
pub const Anum_pg_index_indnatts: u32 = 3;
pub const Anum_pg_index_indnkeyatts: u32 = 4;
pub const Anum_pg_index_indisunique: u32 = 5;
pub const Anum_pg_index_indnullsnotdistinct: u32 = 6;
pub const Anum_pg_index_indisprimary: u32 = 7;
pub const Anum_pg_index_indisexclusion: u32 = 8;
pub const Anum_pg_index_indimmediate: u32 = 9;
pub const Anum_pg_index_indisclustered: u32 = 10;
pub const Anum_pg_index_indisvalid: u32 = 11;
pub const Anum_pg_index_indcheckxmin: u32 = 12;
pub const Anum_pg_index_indisready: u32 = 13;
pub const Anum_pg_index_indislive: u32 = 14;
pub const Anum_pg_index_indisreplident: u32 = 15;
pub const Anum_pg_index_indkey: u32 = 16;
pub const Anum_pg_index_indcollation: u32 = 17;
pub const Anum_pg_index_indclass: u32 = 18;
pub const Anum_pg_index_indoption: u32 = 19;
pub const Anum_pg_index_indexprs: u32 = 20;
pub const Anum_pg_index_indpred: u32 = 21;
pub const Natts_pg_index: u32 = 21;
pub const INDOPTION_DESC: u32 = 1;
pub const INDOPTION_NULLS_FIRST: u32 = 2;
pub const PublicationRelationId: Oid = Oid(6104);
pub const PublicationObjectIndexId: u32 = 6110;
pub const PublicationNameIndexId: u32 = 6111;
pub const Anum_pg_publication_oid: u32 = 1;
pub const Anum_pg_publication_pubname: u32 = 2;
pub const Anum_pg_publication_pubowner: u32 = 3;
pub const Anum_pg_publication_puballtables: u32 = 4;
pub const Anum_pg_publication_pubinsert: u32 = 5;
pub const Anum_pg_publication_pubupdate: u32 = 6;
pub const Anum_pg_publication_pubdelete: u32 = 7;
pub const Anum_pg_publication_pubtruncate: u32 = 8;
pub const Anum_pg_publication_pubviaroot: u32 = 9;
pub const Natts_pg_publication: u32 = 9;
pub const HEAP_MIN_FILLFACTOR: u32 = 10;
pub const HEAP_DEFAULT_FILLFACTOR: u32 = 100;
pub const MAX_GENERIC_XLOG_PAGES: u32 = 4;
pub const GENERIC_XLOG_FULL_IMAGE: u32 = 1;
pub const GIN_COMPARE_PROC: u32 = 1;
pub const GIN_EXTRACTVALUE_PROC: u32 = 2;
pub const GIN_EXTRACTQUERY_PROC: u32 = 3;
pub const GIN_CONSISTENT_PROC: u32 = 4;
pub const GIN_COMPARE_PARTIAL_PROC: u32 = 5;
pub const GIN_TRICONSISTENT_PROC: u32 = 6;
pub const GIN_OPTIONS_PROC: u32 = 7;
pub const GINNProcs: u32 = 7;
pub const GIN_SEARCH_MODE_DEFAULT: u32 = 0;
pub const GIN_SEARCH_MODE_INCLUDE_EMPTY: u32 = 1;
pub const GIN_SEARCH_MODE_ALL: u32 = 2;
pub const GIN_SEARCH_MODE_EVERYTHING: u32 = 3;
pub const GIN_FALSE: u32 = 0;
pub const GIN_TRUE: u32 = 1;
pub const GIN_MAYBE: u32 = 2;
pub const GIST_CONSISTENT_PROC: u32 = 1;
pub const GIST_UNION_PROC: u32 = 2;
pub const GIST_COMPRESS_PROC: u32 = 3;
pub const GIST_DECOMPRESS_PROC: u32 = 4;
pub const GIST_PENALTY_PROC: u32 = 5;
pub const GIST_PICKSPLIT_PROC: u32 = 6;
pub const GIST_EQUAL_PROC: u32 = 7;
pub const GIST_DISTANCE_PROC: u32 = 8;
pub const GIST_FETCH_PROC: u32 = 9;
pub const GIST_OPTIONS_PROC: u32 = 10;
pub const GIST_SORTSUPPORT_PROC: u32 = 11;
pub const GISTNProcs: u32 = 11;
pub const F_LEAF: u32 = 1;
pub const F_DELETED: u32 = 2;
pub const F_TUPLES_DELETED: u32 = 4;
pub const F_FOLLOW_RIGHT: u32 = 8;
pub const F_HAS_GARBAGE: u32 = 16;
pub const GIST_PAGE_ID: u32 = 65409;
pub const SHAREDINVALCATALOG_ID: i32 = -1;
pub const SHAREDINVALRELCACHE_ID: i32 = -2;
pub const SHAREDINVALSMGR_ID: i32 = -3;
pub const SHAREDINVALRELMAP_ID: i32 = -4;
pub const SHAREDINVALSNAPSHOT_ID: i32 = -5;
pub const GIDSIZE: u32 = 200;
pub const XACT_READ_UNCOMMITTED: u32 = 0;
pub const XACT_READ_COMMITTED: u32 = 1;
pub const XACT_REPEATABLE_READ: u32 = 2;
pub const XACT_SERIALIZABLE: u32 = 3;
pub const XACT_FLAGS_ACCESSEDTEMPNAMESPACE: u32 = 1;
pub const XACT_FLAGS_ACQUIREDACCESSEXCLUSIVELOCK: u32 = 2;
pub const XACT_FLAGS_NEEDIMMEDIATECOMMIT: u32 = 4;
pub const XACT_FLAGS_PIPELINING: u32 = 8;
pub const XLOG_XACT_COMMIT: u32 = 0;
pub const XLOG_XACT_PREPARE: u32 = 16;
pub const XLOG_XACT_ABORT: u32 = 32;
pub const XLOG_XACT_COMMIT_PREPARED: u32 = 48;
pub const XLOG_XACT_ABORT_PREPARED: u32 = 64;
pub const XLOG_XACT_ASSIGNMENT: u32 = 80;
pub const XLOG_XACT_INVALIDATIONS: u32 = 96;
pub const XLOG_XACT_OPMASK: u32 = 112;
pub const XLOG_XACT_HAS_INFO: u32 = 128;
pub const XACT_XINFO_HAS_DBINFO: u32 = 1;
pub const XACT_XINFO_HAS_SUBXACTS: u32 = 2;
pub const XACT_XINFO_HAS_RELFILENODES: u32 = 4;
pub const XACT_XINFO_HAS_INVALS: u32 = 8;
pub const XACT_XINFO_HAS_TWOPHASE: u32 = 16;
pub const XACT_XINFO_HAS_ORIGIN: u32 = 32;
pub const XACT_XINFO_HAS_AE_LOCKS: u32 = 64;
pub const XACT_XINFO_HAS_GID: u32 = 128;
pub const XACT_XINFO_HAS_DROPPED_STATS: u32 = 256;
pub const XACT_COMPLETION_APPLY_FEEDBACK: u32 = 536870912;
pub const XACT_COMPLETION_UPDATE_RELCACHE_FILE: u32 = 1073741824;
pub const XACT_COMPLETION_FORCE_SYNC_COMMIT: u32 = 2147483648;
pub const EOH_HEADER_MAGIC: i32 = -1;
pub const MAXDIM: u32 = 6;
pub const EA_MAGIC: u32 = 689375833;
pub const PG_AUTOCONF_FILENAME: &::core::ffi::CStr = c"postgresql.auto.conf";
pub const GUC_QUALIFIER_SEPARATOR: u8 = 46u8;
pub const GUC_LIST_INPUT: u32 = 1;
pub const GUC_LIST_QUOTE: u32 = 2;
pub const GUC_NO_SHOW_ALL: u32 = 4;
pub const GUC_NO_RESET_ALL: u32 = 8;
pub const GUC_REPORT: u32 = 16;
pub const GUC_NOT_IN_SAMPLE: u32 = 32;
pub const GUC_DISALLOW_IN_FILE: u32 = 64;
pub const GUC_CUSTOM_PLACEHOLDER: u32 = 128;
pub const GUC_SUPERUSER_ONLY: u32 = 256;
pub const GUC_IS_NAME: u32 = 512;
pub const GUC_NOT_WHILE_SEC_REST: u32 = 1024;
pub const GUC_DISALLOW_IN_AUTO_FILE: u32 = 2048;
pub const GUC_UNIT_KB: u32 = 4096;
pub const GUC_UNIT_BLOCKS: u32 = 8192;
pub const GUC_UNIT_XBLOCKS: u32 = 12288;
pub const GUC_UNIT_MB: u32 = 16384;
pub const GUC_UNIT_BYTE: u32 = 32768;
pub const GUC_UNIT_MEMORY: u32 = 61440;
pub const GUC_UNIT_MS: u32 = 65536;
pub const GUC_UNIT_S: u32 = 131072;
pub const GUC_UNIT_MIN: u32 = 196608;
pub const GUC_UNIT_TIME: u32 = 983040;
pub const GUC_EXPLAIN: u32 = 1048576;
pub const GUC_RUNTIME_COMPUTED: u32 = 2097152;
pub const GUC_ALLOW_IN_PARALLEL: u32 = 4194304;
pub const GUC_UNIT: u32 = 1044480;
pub const DEFAULT_TABLE_ACCESS_METHOD: &::core::ffi::CStr = c"heap";
pub const TABLE_INSERT_SKIP_FSM: u32 = 2;
pub const TABLE_INSERT_FROZEN: u32 = 4;
pub const TABLE_INSERT_NO_LOGICAL: u32 = 8;
pub const TUPLE_LOCK_FLAG_LOCK_UPDATE_IN_PROGRESS: u32 = 1;
pub const TUPLE_LOCK_FLAG_FIND_LAST_VERSION: u32 = 2;
pub const SHMEM_INDEX_KEYSIZE: u32 = 48;
pub const SHMEM_INDEX_SIZE: u32 = 64;
pub const HEAP_INSERT_SKIP_FSM: u32 = 2;
pub const HEAP_INSERT_FROZEN: u32 = 4;
pub const HEAP_INSERT_NO_LOGICAL: u32 = 8;
pub const HEAP_INSERT_SPECULATIVE: u32 = 16;
pub const NUM_MULTIXACTOFFSET_BUFFERS: u32 = 8;
pub const NUM_MULTIXACTMEMBER_BUFFERS: u32 = 16;
pub const XLOG_MULTIXACT_ZERO_OFF_PAGE: u32 = 0;
pub const XLOG_MULTIXACT_ZERO_MEM_PAGE: u32 = 16;
pub const XLOG_MULTIXACT_CREATE_ID: u32 = 32;
pub const XLOG_MULTIXACT_TRUNCATE_ID: u32 = 48;
pub const LWLOCK_PADDED_SIZE: u32 = 128;
pub const NUM_INDIVIDUAL_LWLOCKS: u32 = 48;
pub const NUM_BUFFER_PARTITIONS: u32 = 128;
pub const LOG2_NUM_LOCK_PARTITIONS: u32 = 4;
pub const NUM_LOCK_PARTITIONS: u32 = 16;
pub const LOG2_NUM_PREDICATELOCK_PARTITIONS: u32 = 4;
pub const NUM_PREDICATELOCK_PARTITIONS: u32 = 16;
pub const BUFFER_MAPPING_LWLOCK_OFFSET: u32 = 48;
pub const LOCK_MANAGER_LWLOCK_OFFSET: u32 = 176;
pub const PREDICATELOCK_MANAGER_LWLOCK_OFFSET: u32 = 192;
pub const NUM_FIXED_LWLOCKS: u32 = 208;
pub const INTERVAL_FULL_RANGE: u32 = 32767;
pub const INTERVAL_RANGE_MASK: u32 = 32767;
pub const INTERVAL_FULL_PRECISION: u32 = 65535;
pub const INTERVAL_PRECISION_MASK: u32 = 65535;
pub const InvalidLocalTransactionId: u32 = 0;
pub const MAX_LOCKMODES: u32 = 10;
pub const DEFAULT_LOCKMETHOD: u32 = 1;
pub const USER_LOCKMETHOD: u32 = 2;
pub const BITS_PER_HEAPBLOCK: u32 = 2;
pub const VISIBILITYMAP_ALL_VISIBLE: u32 = 1;
pub const VISIBILITYMAP_ALL_FROZEN: u32 = 2;
pub const VISIBILITYMAP_VALID_BITS: u32 = 3;
pub const PG_CONTROL_VERSION: u32 = 1300;
pub const MOCK_AUTH_NONCE_LEN: u32 = 32;
pub const XLOG_CHECKPOINT_SHUTDOWN: u32 = 0;
pub const XLOG_CHECKPOINT_ONLINE: u32 = 16;
pub const XLOG_NOOP: u32 = 32;
pub const XLOG_NEXTOID: Oid = Oid(48);
pub const XLOG_SWITCH: u32 = 64;
pub const XLOG_BACKUP_END: u32 = 80;
pub const XLOG_PARAMETER_CHANGE: u32 = 96;
pub const XLOG_RESTORE_POINT: u32 = 112;
pub const XLOG_FPW_CHANGE: u32 = 128;
pub const XLOG_END_OF_RECOVERY: u32 = 144;
pub const XLOG_FPI_FOR_HINT: u32 = 160;
pub const XLOG_FPI: u32 = 176;
pub const XLOG_OVERWRITE_CONTRECORD: u32 = 208;
pub const FLOATFORMAT_VALUE: f64 = 1234567.0;
pub const PG_CONTROL_MAX_SAFE_SIZE: u32 = 512;
pub const PG_CONTROL_FILE_SIZE: u32 = 8192;
pub const OLD_SNAPSHOT_PADDING_ENTRIES: u32 = 10;
pub const MAX_IO_CONCURRENCY: u32 = 1000;
pub const BUFFER_LOCK_UNLOCK: u32 = 0;
pub const BUFFER_LOCK_SHARE: u32 = 1;
pub const BUFFER_LOCK_EXCLUSIVE: u32 = 2;
pub const PERFORM_DELETION_INTERNAL: u32 = 1;
pub const PERFORM_DELETION_CONCURRENTLY: u32 = 2;
pub const PERFORM_DELETION_QUIETLY: u32 = 4;
pub const PERFORM_DELETION_SKIP_ORIGINAL: u32 = 8;
pub const PERFORM_DELETION_SKIP_EXTENSIONS: u32 = 16;
pub const PERFORM_DELETION_CONCURRENT_LOCK: u32 = 32;
pub const DEFAULT_INDEX_TYPE: &::core::ffi::CStr = c"btree";
pub const REINDEXOPT_VERBOSE: u32 = 1;
pub const REINDEXOPT_REPORT_PROGRESS: u32 = 2;
pub const REINDEXOPT_MISSING_OK: u32 = 4;
pub const REINDEXOPT_CONCURRENTLY: u32 = 8;
pub const INDEX_CREATE_IS_PRIMARY: u32 = 1;
pub const INDEX_CREATE_ADD_CONSTRAINT: u32 = 2;
pub const INDEX_CREATE_SKIP_BUILD: u32 = 4;
pub const INDEX_CREATE_CONCURRENT: u32 = 8;
pub const INDEX_CREATE_IF_NOT_EXISTS: u32 = 16;
pub const INDEX_CREATE_PARTITIONED: u32 = 32;
pub const INDEX_CREATE_INVALID: u32 = 64;
pub const INDEX_CONSTR_CREATE_MARK_AS_PRIMARY: u32 = 1;
pub const INDEX_CONSTR_CREATE_DEFERRABLE: u32 = 2;
pub const INDEX_CONSTR_CREATE_INIT_DEFERRED: u32 = 4;
pub const INDEX_CONSTR_CREATE_UPDATE_INDEX: u32 = 8;
pub const INDEX_CONSTR_CREATE_REMOVE_OLD_DEPS: u32 = 16;
pub const REINDEX_REL_PROCESS_TOAST: u32 = 1;
pub const REINDEX_REL_SUPPRESS_INDEX_USE: u32 = 2;
pub const REINDEX_REL_CHECK_CONSTRAINTS: u32 = 4;
pub const REINDEX_REL_FORCE_INDEXES_UNLOGGED: u32 = 8;
pub const REINDEX_REL_FORCE_INDEXES_PERMANENT: u32 = 16;
pub const MAX_CATALOG_MULTI_INSERT_BYTES: u32 = 65535;
pub const AccessMethodRelationId: Oid = Oid(2601);
pub const AmNameIndexId: u32 = 2651;
pub const AmOidIndexId: u32 = 2652;
pub const Anum_pg_am_oid: u32 = 1;
pub const Anum_pg_am_amname: u32 = 2;
pub const Anum_pg_am_amhandler: u32 = 3;
pub const Anum_pg_am_amtype: u32 = 4;
pub const Natts_pg_am: u32 = 4;
pub const AMTYPE_INDEX: u8 = 105u8;
pub const AMTYPE_TABLE: u8 = 116u8;
pub const HEAP_TABLE_AM_OID: Oid = Oid(2);
pub const BTREE_AM_OID: Oid = Oid(403);
pub const HASH_AM_OID: Oid = Oid(405);
pub const GIST_AM_OID: Oid = Oid(783);
pub const GIN_AM_OID: Oid = Oid(2742);
pub const SPGIST_AM_OID: Oid = Oid(4000);
pub const BRIN_AM_OID: Oid = Oid(3580);
pub const AccessMethodOperatorRelationId: Oid = Oid(2602);
pub const AccessMethodStrategyIndexId: u32 = 2653;
pub const AccessMethodOperatorIndexId: u32 = 2654;
pub const AccessMethodOperatorOidIndexId: u32 = 2756;
pub const Anum_pg_amop_oid: u32 = 1;
pub const Anum_pg_amop_amopfamily: u32 = 2;
pub const Anum_pg_amop_amoplefttype: u32 = 3;
pub const Anum_pg_amop_amoprighttype: u32 = 4;
pub const Anum_pg_amop_amopstrategy: u32 = 5;
pub const Anum_pg_amop_amoppurpose: u32 = 6;
pub const Anum_pg_amop_amopopr: u32 = 7;
pub const Anum_pg_amop_amopmethod: u32 = 8;
pub const Anum_pg_amop_amopsortfamily: u32 = 9;
pub const Natts_pg_amop: u32 = 9;
pub const AMOP_SEARCH: u8 = 115u8;
pub const AMOP_ORDER: u8 = 111u8;
pub const AccessMethodProcedureRelationId: Oid = Oid(2603);
pub const AccessMethodProcedureIndexId: u32 = 2655;
pub const AccessMethodProcedureOidIndexId: u32 = 2757;
pub const Anum_pg_amproc_oid: u32 = 1;
pub const Anum_pg_amproc_amprocfamily: u32 = 2;
pub const Anum_pg_amproc_amproclefttype: u32 = 3;
pub const Anum_pg_amproc_amprocrighttype: u32 = 4;
pub const Anum_pg_amproc_amprocnum: u32 = 5;
pub const Anum_pg_amproc_amproc: u32 = 6;
pub const Natts_pg_amproc: u32 = 6;
pub const AuthIdRelationId: Oid = Oid(1260);
pub const AuthIdRelation_Rowtype_Id: u32 = 2842;
pub const PgAuthidToastTable: u32 = 4175;
pub const PgAuthidToastIndex: u32 = 4176;
pub const AuthIdRolnameIndexId: u32 = 2676;
pub const AuthIdOidIndexId: u32 = 2677;
pub const Anum_pg_authid_oid: u32 = 1;
pub const Anum_pg_authid_rolname: u32 = 2;
pub const Anum_pg_authid_rolsuper: u32 = 3;
pub const Anum_pg_authid_rolinherit: u32 = 4;
pub const Anum_pg_authid_rolcreaterole: u32 = 5;
pub const Anum_pg_authid_rolcreatedb: u32 = 6;
pub const Anum_pg_authid_rolcanlogin: u32 = 7;
pub const Anum_pg_authid_rolreplication: u32 = 8;
pub const Anum_pg_authid_rolbypassrls: u32 = 9;
pub const Anum_pg_authid_rolconnlimit: u32 = 10;
pub const Anum_pg_authid_rolpassword: u32 = 11;
pub const Anum_pg_authid_rolvaliduntil: u32 = 12;
pub const Natts_pg_authid: u32 = 12;
pub const BOOTSTRAP_SUPERUSERID: u32 = 10;
pub const ROLE_PG_DATABASE_OWNER: u32 = 6171;
pub const ROLE_PG_READ_ALL_DATA: u32 = 6181;
pub const ROLE_PG_WRITE_ALL_DATA: u32 = 6182;
pub const ROLE_PG_MONITOR: u32 = 3373;
pub const ROLE_PG_READ_ALL_SETTINGS: u32 = 3374;
pub const ROLE_PG_READ_ALL_STATS: u32 = 3375;
pub const ROLE_PG_STAT_SCAN_TABLES: u32 = 3377;
pub const ROLE_PG_READ_SERVER_FILES: u32 = 4569;
pub const ROLE_PG_WRITE_SERVER_FILES: u32 = 4570;
pub const ROLE_PG_EXECUTE_SERVER_PROGRAM: u32 = 4571;
pub const ROLE_PG_SIGNAL_BACKEND: u32 = 4200;
pub const ROLE_PG_CHECKPOINT: u32 = 4544;
pub const CollationRelationId: Oid = Oid(3456);
pub const CollationNameEncNspIndexId: u32 = 3164;
pub const CollationOidIndexId: u32 = 3085;
pub const Anum_pg_collation_oid: u32 = 1;
pub const Anum_pg_collation_collname: u32 = 2;
pub const Anum_pg_collation_collnamespace: u32 = 3;
pub const Anum_pg_collation_collowner: u32 = 4;
pub const Anum_pg_collation_collprovider: u32 = 5;
pub const Anum_pg_collation_collisdeterministic: u32 = 6;
pub const Anum_pg_collation_collencoding: u32 = 7;
pub const Anum_pg_collation_collcollate: u32 = 8;
pub const Anum_pg_collation_collctype: u32 = 9;
pub const Anum_pg_collation_colliculocale: u32 = 10;
pub const Anum_pg_collation_collversion: u32 = 11;
pub const Natts_pg_collation: u32 = 11;
pub const COLLPROVIDER_DEFAULT: u8 = 100u8;
pub const COLLPROVIDER_ICU: u8 = 105u8;
pub const COLLPROVIDER_LIBC: u8 = 99u8;
pub const DEFAULT_COLLATION_OID: Oid = Oid(100);
pub const C_COLLATION_OID: Oid = Oid(950);
pub const POSIX_COLLATION_OID: Oid = Oid(951);
pub const DatabaseRelationId: Oid = Oid(1262);
pub const DatabaseRelation_Rowtype_Id: u32 = 1248;
pub const PgDatabaseToastTable: u32 = 4177;
pub const PgDatabaseToastIndex: u32 = 4178;
pub const DatabaseNameIndexId: u32 = 2671;
pub const DatabaseOidIndexId: u32 = 2672;
pub const Template0DbOid: u32 = 4;
pub const PostgresDbOid: u32 = 5;
pub const Anum_pg_database_oid: u32 = 1;
pub const Anum_pg_database_datname: u32 = 2;
pub const Anum_pg_database_datdba: u32 = 3;
pub const Anum_pg_database_encoding: u32 = 4;
pub const Anum_pg_database_datlocprovider: u32 = 5;
pub const Anum_pg_database_datistemplate: u32 = 6;
pub const Anum_pg_database_datallowconn: u32 = 7;
pub const Anum_pg_database_datconnlimit: u32 = 8;
pub const Anum_pg_database_datfrozenxid: u32 = 9;
pub const Anum_pg_database_datminmxid: u32 = 10;
pub const Anum_pg_database_dattablespace: u32 = 11;
pub const Anum_pg_database_datcollate: u32 = 12;
pub const Anum_pg_database_datctype: u32 = 13;
pub const Anum_pg_database_daticulocale: u32 = 14;
pub const Anum_pg_database_datcollversion: u32 = 15;
pub const Anum_pg_database_datacl: u32 = 16;
pub const Natts_pg_database: u32 = 16;
pub const Template1DbOid: u32 = 1;
pub const DATCONNLIMIT_UNLIMITED: i32 = -1;
pub const DATCONNLIMIT_INVALID_DB: i32 = -2;
pub const EnumRelationId: Oid = Oid(3501);
pub const EnumOidIndexId: u32 = 3502;
pub const EnumTypIdLabelIndexId: u32 = 3503;
pub const EnumTypIdSortOrderIndexId: u32 = 3534;
pub const Anum_pg_enum_oid: u32 = 1;
pub const Anum_pg_enum_enumtypid: u32 = 2;
pub const Anum_pg_enum_enumsortorder: u32 = 3;
pub const Anum_pg_enum_enumlabel: u32 = 4;
pub const Natts_pg_enum: u32 = 4;
pub const ExtensionRelationId: Oid = Oid(3079);
pub const ExtensionOidIndexId: u32 = 3080;
pub const ExtensionNameIndexId: u32 = 3081;
pub const Anum_pg_extension_oid: u32 = 1;
pub const Anum_pg_extension_extname: u32 = 2;
pub const Anum_pg_extension_extowner: u32 = 3;
pub const Anum_pg_extension_extnamespace: u32 = 4;
pub const Anum_pg_extension_extrelocatable: u32 = 5;
pub const Anum_pg_extension_extversion: u32 = 6;
pub const Anum_pg_extension_extconfig: u32 = 7;
pub const Anum_pg_extension_extcondition: u32 = 8;
pub const Natts_pg_extension: u32 = 8;
pub const ForeignDataWrapperRelationId: Oid = Oid(2328);
pub const ForeignDataWrapperOidIndexId: u32 = 112;
pub const ForeignDataWrapperNameIndexId: u32 = 548;
pub const Anum_pg_foreign_data_wrapper_oid: u32 = 1;
pub const Anum_pg_foreign_data_wrapper_fdwname: u32 = 2;
pub const Anum_pg_foreign_data_wrapper_fdwowner: u32 = 3;
pub const Anum_pg_foreign_data_wrapper_fdwhandler: u32 = 4;
pub const Anum_pg_foreign_data_wrapper_fdwvalidator: u32 = 5;
pub const Anum_pg_foreign_data_wrapper_fdwacl: u32 = 6;
pub const Anum_pg_foreign_data_wrapper_fdwoptions: u32 = 7;
pub const Natts_pg_foreign_data_wrapper: u32 = 7;
pub const ForeignServerRelationId: Oid = Oid(1417);
pub const ForeignServerOidIndexId: u32 = 113;
pub const ForeignServerNameIndexId: u32 = 549;
pub const Anum_pg_foreign_server_oid: u32 = 1;
pub const Anum_pg_foreign_server_srvname: u32 = 2;
pub const Anum_pg_foreign_server_srvowner: u32 = 3;
pub const Anum_pg_foreign_server_srvfdw: u32 = 4;
pub const Anum_pg_foreign_server_srvtype: u32 = 5;
pub const Anum_pg_foreign_server_srvversion: u32 = 6;
pub const Anum_pg_foreign_server_srvacl: u32 = 7;
pub const Anum_pg_foreign_server_srvoptions: u32 = 8;
pub const Natts_pg_foreign_server: u32 = 8;
pub const ForeignTableRelationId: Oid = Oid(3118);
pub const ForeignTableRelidIndexId: u32 = 3119;
pub const Anum_pg_foreign_table_ftrelid: u32 = 1;
pub const Anum_pg_foreign_table_ftserver: u32 = 2;
pub const Anum_pg_foreign_table_ftoptions: u32 = 3;
pub const Natts_pg_foreign_table: u32 = 3;
pub const OperatorRelationId: Oid = Oid(2617);
pub const OperatorOidIndexId: u32 = 2688;
pub const OperatorNameNspIndexId: u32 = 2689;
pub const Anum_pg_operator_oid: u32 = 1;
pub const Anum_pg_operator_oprname: u32 = 2;
pub const Anum_pg_operator_oprnamespace: u32 = 3;
pub const Anum_pg_operator_oprowner: u32 = 4;
pub const Anum_pg_operator_oprkind: u32 = 5;
pub const Anum_pg_operator_oprcanmerge: u32 = 6;
pub const Anum_pg_operator_oprcanhash: u32 = 7;
pub const Anum_pg_operator_oprleft: u32 = 8;
pub const Anum_pg_operator_oprright: u32 = 9;
pub const Anum_pg_operator_oprresult: u32 = 10;
pub const Anum_pg_operator_oprcom: u32 = 11;
pub const Anum_pg_operator_oprnegate: u32 = 12;
pub const Anum_pg_operator_oprcode: u32 = 13;
pub const Anum_pg_operator_oprrest: u32 = 14;
pub const Anum_pg_operator_oprjoin: u32 = 15;
pub const Natts_pg_operator: u32 = 15;
pub const BooleanNotEqualOperator: u32 = 85;
pub const BooleanEqualOperator: u32 = 91;
pub const Int4EqualOperator: u32 = 96;
pub const Int4LessOperator: u32 = 97;
pub const TextEqualOperator: u32 = 98;
pub const TextPrefixOperator: u32 = 3877;
pub const NameEqualTextOperator: u32 = 254;
pub const NameLessTextOperator: u32 = 255;
pub const NameGreaterEqualTextOperator: u32 = 257;
pub const TIDEqualOperator: u32 = 387;
pub const TIDLessOperator: u32 = 2799;
pub const TIDGreaterOperator: u32 = 2800;
pub const TIDLessEqOperator: u32 = 2801;
pub const TIDGreaterEqOperator: u32 = 2802;
pub const Int8LessOperator: u32 = 412;
pub const OID_NAME_REGEXEQ_OP: u32 = 639;
pub const OID_TEXT_REGEXEQ_OP: u32 = 641;
pub const TextLessOperator: u32 = 664;
pub const TextGreaterEqualOperator: u32 = 667;
pub const Float8LessOperator: u32 = 672;
pub const BpcharEqualOperator: u32 = 1054;
pub const OID_BPCHAR_REGEXEQ_OP: u32 = 1055;
pub const BpcharLessOperator: u32 = 1058;
pub const BpcharGreaterEqualOperator: u32 = 1061;
pub const ARRAY_EQ_OP: u32 = 1070;
pub const ARRAY_LT_OP: u32 = 1072;
pub const ARRAY_GT_OP: u32 = 1073;
pub const OID_NAME_LIKE_OP: u32 = 1207;
pub const OID_TEXT_LIKE_OP: u32 = 1209;
pub const OID_BPCHAR_LIKE_OP: u32 = 1211;
pub const OID_NAME_ICREGEXEQ_OP: u32 = 1226;
pub const OID_TEXT_ICREGEXEQ_OP: u32 = 1228;
pub const OID_BPCHAR_ICREGEXEQ_OP: u32 = 1234;
pub const OID_INET_SUB_OP: u32 = 931;
pub const OID_INET_SUBEQ_OP: u32 = 932;
pub const OID_INET_SUP_OP: u32 = 933;
pub const OID_INET_SUPEQ_OP: u32 = 934;
pub const OID_INET_OVERLAP_OP: u32 = 3552;
pub const OID_NAME_ICLIKE_OP: u32 = 1625;
pub const OID_TEXT_ICLIKE_OP: u32 = 1627;
pub const OID_BPCHAR_ICLIKE_OP: u32 = 1629;
pub const ByteaEqualOperator: u32 = 1955;
pub const ByteaLessOperator: u32 = 1957;
pub const ByteaGreaterEqualOperator: u32 = 1960;
pub const OID_BYTEA_LIKE_OP: u32 = 2016;
pub const TextPatternLessOperator: u32 = 2314;
pub const TextPatternGreaterEqualOperator: u32 = 2317;
pub const BpcharPatternLessOperator: u32 = 2326;
pub const BpcharPatternGreaterEqualOperator: u32 = 2329;
pub const OID_ARRAY_OVERLAP_OP: u32 = 2750;
pub const OID_ARRAY_CONTAINS_OP: u32 = 2751;
pub const OID_ARRAY_CONTAINED_OP: u32 = 2752;
pub const RECORD_EQ_OP: u32 = 2988;
pub const RECORD_LT_OP: u32 = 2990;
pub const RECORD_GT_OP: u32 = 2991;
pub const OID_RANGE_LESS_OP: u32 = 3884;
pub const OID_RANGE_LESS_EQUAL_OP: u32 = 3885;
pub const OID_RANGE_GREATER_EQUAL_OP: u32 = 3886;
pub const OID_RANGE_GREATER_OP: u32 = 3887;
pub const OID_RANGE_OVERLAP_OP: u32 = 3888;
pub const OID_RANGE_CONTAINS_ELEM_OP: u32 = 3889;
pub const OID_RANGE_CONTAINS_OP: u32 = 3890;
pub const OID_RANGE_ELEM_CONTAINED_OP: u32 = 3891;
pub const OID_RANGE_CONTAINED_OP: u32 = 3892;
pub const OID_RANGE_LEFT_OP: u32 = 3893;
pub const OID_RANGE_RIGHT_OP: u32 = 3894;
pub const OID_RANGE_OVERLAPS_LEFT_OP: u32 = 3895;
pub const OID_RANGE_OVERLAPS_RIGHT_OP: u32 = 3896;
pub const OID_MULTIRANGE_LESS_OP: u32 = 2862;
pub const OID_MULTIRANGE_LESS_EQUAL_OP: u32 = 2863;
pub const OID_MULTIRANGE_GREATER_EQUAL_OP: u32 = 2864;
pub const OID_MULTIRANGE_GREATER_OP: u32 = 2865;
pub const OID_RANGE_OVERLAPS_MULTIRANGE_OP: u32 = 2866;
pub const OID_MULTIRANGE_OVERLAPS_RANGE_OP: u32 = 2867;
pub const OID_MULTIRANGE_OVERLAPS_MULTIRANGE_OP: u32 = 2868;
pub const OID_MULTIRANGE_CONTAINS_ELEM_OP: u32 = 2869;
pub const OID_MULTIRANGE_CONTAINS_RANGE_OP: u32 = 2870;
pub const OID_MULTIRANGE_CONTAINS_MULTIRANGE_OP: u32 = 2871;
pub const OID_MULTIRANGE_ELEM_CONTAINED_OP: u32 = 2872;
pub const OID_MULTIRANGE_RANGE_CONTAINED_OP: u32 = 2873;
pub const OID_MULTIRANGE_MULTIRANGE_CONTAINED_OP: u32 = 2874;
pub const OID_RANGE_CONTAINS_MULTIRANGE_OP: u32 = 4539;
pub const OID_RANGE_MULTIRANGE_CONTAINED_OP: u32 = 4540;
pub const OID_RANGE_OVERLAPS_LEFT_MULTIRANGE_OP: u32 = 2875;
pub const OID_MULTIRANGE_OVERLAPS_LEFT_RANGE_OP: u32 = 2876;
pub const OID_MULTIRANGE_OVERLAPS_LEFT_MULTIRANGE_OP: u32 = 2877;
pub const OID_RANGE_OVERLAPS_RIGHT_MULTIRANGE_OP: u32 = 3585;
pub const OID_MULTIRANGE_OVERLAPS_RIGHT_RANGE_OP: u32 = 4035;
pub const OID_MULTIRANGE_OVERLAPS_RIGHT_MULTIRANGE_OP: u32 = 4142;
pub const OID_RANGE_ADJACENT_MULTIRANGE_OP: u32 = 4179;
pub const OID_MULTIRANGE_ADJACENT_RANGE_OP: u32 = 4180;
pub const OID_MULTIRANGE_ADJACENT_MULTIRANGE_OP: u32 = 4198;
pub const OID_RANGE_LEFT_MULTIRANGE_OP: u32 = 4395;
pub const OID_MULTIRANGE_LEFT_RANGE_OP: u32 = 4396;
pub const OID_MULTIRANGE_LEFT_MULTIRANGE_OP: u32 = 4397;
pub const OID_RANGE_RIGHT_MULTIRANGE_OP: u32 = 4398;
pub const OID_MULTIRANGE_RIGHT_RANGE_OP: u32 = 4399;
pub const OID_MULTIRANGE_RIGHT_MULTIRANGE_OP: u32 = 4400;
pub const OperatorClassRelationId: Oid = Oid(2616);
pub const OpclassAmNameNspIndexId: u32 = 2686;
pub const OpclassOidIndexId: u32 = 2687;
pub const Anum_pg_opclass_oid: u32 = 1;
pub const Anum_pg_opclass_opcmethod: u32 = 2;
pub const Anum_pg_opclass_opcname: u32 = 3;
pub const Anum_pg_opclass_opcnamespace: u32 = 4;
pub const Anum_pg_opclass_opcowner: u32 = 5;
pub const Anum_pg_opclass_opcfamily: u32 = 6;
pub const Anum_pg_opclass_opcintype: u32 = 7;
pub const Anum_pg_opclass_opcdefault: u32 = 8;
pub const Anum_pg_opclass_opckeytype: u32 = 9;
pub const Natts_pg_opclass: u32 = 9;
pub const DATE_BTREE_OPS_OID: Oid = Oid(3122);
pub const FLOAT8_BTREE_OPS_OID: Oid = Oid(3123);
pub const INT2_BTREE_OPS_OID: Oid = Oid(1979);
pub const INT4_BTREE_OPS_OID: Oid = Oid(1978);
pub const INT8_BTREE_OPS_OID: Oid = Oid(3124);
pub const NUMERIC_BTREE_OPS_OID: Oid = Oid(3125);
pub const OID_BTREE_OPS_OID: Oid = Oid(1981);
pub const TEXT_BTREE_OPS_OID: Oid = Oid(3126);
pub const TIMESTAMPTZ_BTREE_OPS_OID: Oid = Oid(3127);
pub const TIMESTAMP_BTREE_OPS_OID: Oid = Oid(3128);
pub const TEXT_BTREE_PATTERN_OPS_OID: Oid = Oid(4217);
pub const VARCHAR_BTREE_PATTERN_OPS_OID: Oid = Oid(4218);
pub const BPCHAR_BTREE_PATTERN_OPS_OID: Oid = Oid(4219);
pub const OperatorFamilyRelationId: Oid = Oid(2753);
pub const OpfamilyAmNameNspIndexId: u32 = 2754;
pub const OpfamilyOidIndexId: u32 = 2755;
pub const Anum_pg_opfamily_oid: u32 = 1;
pub const Anum_pg_opfamily_opfmethod: u32 = 2;
pub const Anum_pg_opfamily_opfname: u32 = 3;
pub const Anum_pg_opfamily_opfnamespace: u32 = 4;
pub const Anum_pg_opfamily_opfowner: u32 = 5;
pub const Natts_pg_opfamily: u32 = 5;
pub const BOOL_BTREE_FAM_OID: Oid = Oid(424);
pub const BPCHAR_BTREE_FAM_OID: Oid = Oid(426);
pub const BYTEA_BTREE_FAM_OID: Oid = Oid(428);
pub const NETWORK_BTREE_FAM_OID: Oid = Oid(1974);
pub const INTEGER_BTREE_FAM_OID: Oid = Oid(1976);
pub const INTERVAL_BTREE_FAM_OID: Oid = Oid(1982);
pub const OID_BTREE_FAM_OID: Oid = Oid(1989);
pub const TEXT_BTREE_FAM_OID: Oid = Oid(1994);
pub const TEXT_PATTERN_BTREE_FAM_OID: Oid = Oid(2095);
pub const BPCHAR_PATTERN_BTREE_FAM_OID: Oid = Oid(2097);
pub const BOOL_HASH_FAM_OID: Oid = Oid(2222);
pub const TEXT_SPGIST_FAM_OID: Oid = Oid(4017);
pub const ProcedureRelationId: Oid = Oid(1255);
pub const ProcedureRelation_Rowtype_Id: u32 = 81;
pub const ProcedureOidIndexId: u32 = 2690;
pub const ProcedureNameArgsNspIndexId: u32 = 2691;
pub const Anum_pg_proc_oid: u32 = 1;
pub const Anum_pg_proc_proname: u32 = 2;
pub const Anum_pg_proc_pronamespace: u32 = 3;
pub const Anum_pg_proc_proowner: u32 = 4;
pub const Anum_pg_proc_prolang: u32 = 5;
pub const Anum_pg_proc_procost: u32 = 6;
pub const Anum_pg_proc_prorows: u32 = 7;
pub const Anum_pg_proc_provariadic: u32 = 8;
pub const Anum_pg_proc_prosupport: u32 = 9;
pub const Anum_pg_proc_prokind: u32 = 10;
pub const Anum_pg_proc_prosecdef: u32 = 11;
pub const Anum_pg_proc_proleakproof: u32 = 12;
pub const Anum_pg_proc_proisstrict: u32 = 13;
pub const Anum_pg_proc_proretset: u32 = 14;
pub const Anum_pg_proc_provolatile: u32 = 15;
pub const Anum_pg_proc_proparallel: u32 = 16;
pub const Anum_pg_proc_pronargs: u32 = 17;
pub const Anum_pg_proc_pronargdefaults: u32 = 18;
pub const Anum_pg_proc_prorettype: u32 = 19;
pub const Anum_pg_proc_proargtypes: u32 = 20;
pub const Anum_pg_proc_proallargtypes: u32 = 21;
pub const Anum_pg_proc_proargmodes: u32 = 22;
pub const Anum_pg_proc_proargnames: u32 = 23;
pub const Anum_pg_proc_proargdefaults: u32 = 24;
pub const Anum_pg_proc_protrftypes: u32 = 25;
pub const Anum_pg_proc_prosrc: u32 = 26;
pub const Anum_pg_proc_probin: u32 = 27;
pub const Anum_pg_proc_prosqlbody: u32 = 28;
pub const Anum_pg_proc_proconfig: u32 = 29;
pub const Anum_pg_proc_proacl: u32 = 30;
pub const Natts_pg_proc: u32 = 30;
pub const PROKIND_FUNCTION: u8 = 102u8;
pub const PROKIND_AGGREGATE: u8 = 97u8;
pub const PROKIND_WINDOW: u8 = 119u8;
pub const PROKIND_PROCEDURE: u8 = 112u8;
pub const PROVOLATILE_IMMUTABLE: u8 = 105u8;
pub const PROVOLATILE_STABLE: u8 = 115u8;
pub const PROVOLATILE_VOLATILE: u8 = 118u8;
pub const PROPARALLEL_SAFE: u8 = 115u8;
pub const PROPARALLEL_RESTRICTED: u8 = 114u8;
pub const PROPARALLEL_UNSAFE: u8 = 117u8;
pub const PROARGMODE_IN: u8 = 105u8;
pub const PROARGMODE_OUT: u8 = 111u8;
pub const PROARGMODE_INOUT: u8 = 98u8;
pub const PROARGMODE_VARIADIC: u8 = 118u8;
pub const PROARGMODE_TABLE: u8 = 116u8;
pub const NamespaceRelationId: Oid = Oid(2615);
pub const NamespaceNameIndexId: u32 = 2684;
pub const NamespaceOidIndexId: u32 = 2685;
pub const Anum_pg_namespace_oid: u32 = 1;
pub const Anum_pg_namespace_nspname: u32 = 2;
pub const Anum_pg_namespace_nspowner: u32 = 3;
pub const Anum_pg_namespace_nspacl: u32 = 4;
pub const Natts_pg_namespace: u32 = 4;
pub const PG_CATALOG_NAMESPACE: u32 = 11;
pub const PG_TOAST_NAMESPACE: u32 = 99;
pub const PG_PUBLIC_NAMESPACE: u32 = 2200;
pub const ACL_ID_PUBLIC: u32 = 0;
pub const ACL_MODECHG_ADD: u32 = 1;
pub const ACL_MODECHG_DEL: u32 = 2;
pub const ACL_MODECHG_EQL: u32 = 3;
pub const ACL_INSERT_CHR: u8 = 97u8;
pub const ACL_SELECT_CHR: u8 = 114u8;
pub const ACL_UPDATE_CHR: u8 = 119u8;
pub const ACL_DELETE_CHR: u8 = 100u8;
pub const ACL_TRUNCATE_CHR: u8 = 68u8;
pub const ACL_REFERENCES_CHR: u8 = 120u8;
pub const ACL_TRIGGER_CHR: u8 = 116u8;
pub const ACL_EXECUTE_CHR: u8 = 88u8;
pub const ACL_USAGE_CHR: u8 = 85u8;
pub const ACL_CREATE_CHR: u8 = 67u8;
pub const ACL_CREATE_TEMP_CHR: u8 = 84u8;
pub const ACL_CONNECT_CHR: u8 = 99u8;
pub const ACL_SET_CHR: u8 = 115u8;
pub const ACL_ALTER_SYSTEM_CHR: u8 = 65u8;
pub const ACL_ALL_RIGHTS_STR: &::core::ffi::CStr = c"arwdDxtXUCTcsA";
pub const ACL_ALL_RIGHTS_COLUMN: u32 = 39;
pub const ACL_ALL_RIGHTS_RELATION: u32 = 127;
pub const ACL_ALL_RIGHTS_SEQUENCE: u32 = 262;
pub const ACL_ALL_RIGHTS_DATABASE: u32 = 3584;
pub const ACL_ALL_RIGHTS_FDW: u32 = 256;
pub const ACL_ALL_RIGHTS_FOREIGN_SERVER: u32 = 256;
pub const ACL_ALL_RIGHTS_FUNCTION: u32 = 128;
pub const ACL_ALL_RIGHTS_LANGUAGE: u32 = 256;
pub const ACL_ALL_RIGHTS_LARGEOBJECT: u32 = 6;
pub const ACL_ALL_RIGHTS_PARAMETER_ACL: u32 = 12288;
pub const ACL_ALL_RIGHTS_SCHEMA: u32 = 768;
pub const ACL_ALL_RIGHTS_TABLESPACE: u32 = 512;
pub const ACL_ALL_RIGHTS_TYPE: u32 = 256;
pub const SecLabelRelationId: Oid = Oid(3596);
pub const SecLabelObjectIndexId: u32 = 3597;
pub const Anum_pg_seclabel_objoid: u32 = 1;
pub const Anum_pg_seclabel_classoid: u32 = 2;
pub const Anum_pg_seclabel_objsubid: u32 = 3;
pub const Anum_pg_seclabel_provider: u32 = 4;
pub const Anum_pg_seclabel_label: u32 = 5;
pub const Natts_pg_seclabel: u32 = 5;
pub const StatisticExtRelationId: Oid = Oid(3381);
pub const StatisticExtOidIndexId: u32 = 3380;
pub const StatisticExtNameIndexId: u32 = 3997;
pub const StatisticExtRelidIndexId: u32 = 3379;
pub const Anum_pg_statistic_ext_oid: u32 = 1;
pub const Anum_pg_statistic_ext_stxrelid: u32 = 2;
pub const Anum_pg_statistic_ext_stxname: u32 = 3;
pub const Anum_pg_statistic_ext_stxnamespace: u32 = 4;
pub const Anum_pg_statistic_ext_stxowner: u32 = 5;
pub const Anum_pg_statistic_ext_stxstattarget: u32 = 6;
pub const Anum_pg_statistic_ext_stxkeys: u32 = 7;
pub const Anum_pg_statistic_ext_stxkind: u32 = 8;
pub const Anum_pg_statistic_ext_stxexprs: u32 = 9;
pub const Natts_pg_statistic_ext: u32 = 9;
pub const STATS_EXT_NDISTINCT: u8 = 100u8;
pub const STATS_EXT_DEPENDENCIES: u8 = 102u8;
pub const STATS_EXT_MCV: u8 = 109u8;
pub const STATS_EXT_EXPRESSIONS: u8 = 101u8;
pub const TableSpaceRelationId: Oid = Oid(1213);
pub const PgTablespaceToastTable: u32 = 4185;
pub const PgTablespaceToastIndex: u32 = 4186;
pub const TablespaceOidIndexId: u32 = 2697;
pub const TablespaceNameIndexId: u32 = 2698;
pub const Anum_pg_tablespace_oid: u32 = 1;
pub const Anum_pg_tablespace_spcname: u32 = 2;
pub const Anum_pg_tablespace_spcowner: u32 = 3;
pub const Anum_pg_tablespace_spcacl: u32 = 4;
pub const Anum_pg_tablespace_spcoptions: u32 = 5;
pub const Natts_pg_tablespace: u32 = 5;
pub const DEFAULTTABLESPACE_OID: Oid = Oid(1663);
pub const GLOBALTABLESPACE_OID: Oid = Oid(1664);
pub const TriggerRelationId: Oid = Oid(2620);
pub const TriggerConstraintIndexId: u32 = 2699;
pub const TriggerRelidNameIndexId: u32 = 2701;
pub const TriggerOidIndexId: u32 = 2702;
pub const Anum_pg_trigger_oid: u32 = 1;
pub const Anum_pg_trigger_tgrelid: u32 = 2;
pub const Anum_pg_trigger_tgparentid: u32 = 3;
pub const Anum_pg_trigger_tgname: u32 = 4;
pub const Anum_pg_trigger_tgfoid: u32 = 5;
pub const Anum_pg_trigger_tgtype: u32 = 6;
pub const Anum_pg_trigger_tgenabled: u32 = 7;
pub const Anum_pg_trigger_tgisinternal: u32 = 8;
pub const Anum_pg_trigger_tgconstrrelid: u32 = 9;
pub const Anum_pg_trigger_tgconstrindid: u32 = 10;
pub const Anum_pg_trigger_tgconstraint: u32 = 11;
pub const Anum_pg_trigger_tgdeferrable: u32 = 12;
pub const Anum_pg_trigger_tginitdeferred: u32 = 13;
pub const Anum_pg_trigger_tgnargs: u32 = 14;
pub const Anum_pg_trigger_tgattr: u32 = 15;
pub const Anum_pg_trigger_tgargs: u32 = 16;
pub const Anum_pg_trigger_tgqual: u32 = 17;
pub const Anum_pg_trigger_tgoldtable: u32 = 18;
pub const Anum_pg_trigger_tgnewtable: u32 = 19;
pub const Natts_pg_trigger: u32 = 19;
pub const TRIGGER_TYPE_ROW: u32 = 1;
pub const TRIGGER_TYPE_BEFORE: u32 = 2;
pub const TRIGGER_TYPE_INSERT: u32 = 4;
pub const TRIGGER_TYPE_DELETE: u32 = 8;
pub const TRIGGER_TYPE_UPDATE: u32 = 16;
pub const TRIGGER_TYPE_TRUNCATE: u32 = 32;
pub const TRIGGER_TYPE_INSTEAD: u32 = 64;
pub const TRIGGER_TYPE_LEVEL_MASK: u32 = 1;
pub const TRIGGER_TYPE_STATEMENT: u32 = 0;
pub const TRIGGER_TYPE_TIMING_MASK: u32 = 66;
pub const TRIGGER_TYPE_AFTER: u32 = 0;
pub const TRIGGER_TYPE_EVENT_MASK: u32 = 60;
pub const UserMappingRelationId: Oid = Oid(1418);
pub const UserMappingOidIndexId: u32 = 174;
pub const UserMappingUserServerIndexId: u32 = 175;
pub const Anum_pg_user_mapping_oid: u32 = 1;
pub const Anum_pg_user_mapping_umuser: u32 = 2;
pub const Anum_pg_user_mapping_umserver: u32 = 3;
pub const Anum_pg_user_mapping_umoptions: u32 = 4;
pub const Natts_pg_user_mapping: u32 = 4;
pub const EventTriggerRelationId: Oid = Oid(3466);
pub const EventTriggerNameIndexId: u32 = 3467;
pub const EventTriggerOidIndexId: u32 = 3468;
pub const Anum_pg_event_trigger_oid: u32 = 1;
pub const Anum_pg_event_trigger_evtname: u32 = 2;
pub const Anum_pg_event_trigger_evtevent: u32 = 3;
pub const Anum_pg_event_trigger_evtowner: u32 = 4;
pub const Anum_pg_event_trigger_evtfoid: u32 = 5;
pub const Anum_pg_event_trigger_evtenabled: u32 = 6;
pub const Anum_pg_event_trigger_evttags: u32 = 7;
pub const Natts_pg_event_trigger: u32 = 7;
pub const AT_REWRITE_ALTER_PERSISTENCE: u32 = 1;
pub const AT_REWRITE_DEFAULT_VAL: u32 = 2;
pub const AT_REWRITE_COLUMN_REWRITE: u32 = 4;
pub const AT_REWRITE_ACCESS_METHOD: u32 = 8;
pub const CACHEDPLANSOURCE_MAGIC: u32 = 195726186;
pub const CACHEDPLAN_MAGIC: u32 = 953717834;
pub const CACHEDEXPR_MAGIC: u32 = 838275847;
pub const PROGRESS_VACUUM_PHASE: u32 = 0;
pub const PROGRESS_VACUUM_TOTAL_HEAP_BLKS: u32 = 1;
pub const PROGRESS_VACUUM_HEAP_BLKS_SCANNED: u32 = 2;
pub const PROGRESS_VACUUM_HEAP_BLKS_VACUUMED: u32 = 3;
pub const PROGRESS_VACUUM_NUM_INDEX_VACUUMS: u32 = 4;
pub const PROGRESS_VACUUM_MAX_DEAD_TUPLES: u32 = 5;
pub const PROGRESS_VACUUM_NUM_DEAD_TUPLES: u32 = 6;
pub const PROGRESS_VACUUM_PHASE_SCAN_HEAP: u32 = 1;
pub const PROGRESS_VACUUM_PHASE_VACUUM_INDEX: u32 = 2;
pub const PROGRESS_VACUUM_PHASE_VACUUM_HEAP: u32 = 3;
pub const PROGRESS_VACUUM_PHASE_INDEX_CLEANUP: u32 = 4;
pub const PROGRESS_VACUUM_PHASE_TRUNCATE: u32 = 5;
pub const PROGRESS_VACUUM_PHASE_FINAL_CLEANUP: u32 = 6;
pub const PROGRESS_ANALYZE_PHASE: u32 = 0;
pub const PROGRESS_ANALYZE_BLOCKS_TOTAL: u32 = 1;
pub const PROGRESS_ANALYZE_BLOCKS_DONE: u32 = 2;
pub const PROGRESS_ANALYZE_EXT_STATS_TOTAL: u32 = 3;
pub const PROGRESS_ANALYZE_EXT_STATS_COMPUTED: u32 = 4;
pub const PROGRESS_ANALYZE_CHILD_TABLES_TOTAL: u32 = 5;
pub const PROGRESS_ANALYZE_CHILD_TABLES_DONE: u32 = 6;
pub const PROGRESS_ANALYZE_CURRENT_CHILD_TABLE_RELID: u32 = 7;
pub const PROGRESS_ANALYZE_PHASE_ACQUIRE_SAMPLE_ROWS: u32 = 1;
pub const PROGRESS_ANALYZE_PHASE_ACQUIRE_SAMPLE_ROWS_INH: u32 = 2;
pub const PROGRESS_ANALYZE_PHASE_COMPUTE_STATS: u32 = 3;
pub const PROGRESS_ANALYZE_PHASE_COMPUTE_EXT_STATS: u32 = 4;
pub const PROGRESS_ANALYZE_PHASE_FINALIZE_ANALYZE: u32 = 5;
pub const PROGRESS_CLUSTER_COMMAND: u32 = 0;
pub const PROGRESS_CLUSTER_PHASE: u32 = 1;
pub const PROGRESS_CLUSTER_INDEX_RELID: u32 = 2;
pub const PROGRESS_CLUSTER_HEAP_TUPLES_SCANNED: u32 = 3;
pub const PROGRESS_CLUSTER_HEAP_TUPLES_WRITTEN: u32 = 4;
pub const PROGRESS_CLUSTER_TOTAL_HEAP_BLKS: u32 = 5;
pub const PROGRESS_CLUSTER_HEAP_BLKS_SCANNED: u32 = 6;
pub const PROGRESS_CLUSTER_INDEX_REBUILD_COUNT: u32 = 7;
pub const PROGRESS_CLUSTER_PHASE_SEQ_SCAN_HEAP: u32 = 1;
pub const PROGRESS_CLUSTER_PHASE_INDEX_SCAN_HEAP: u32 = 2;
pub const PROGRESS_CLUSTER_PHASE_SORT_TUPLES: u32 = 3;
pub const PROGRESS_CLUSTER_PHASE_WRITE_NEW_HEAP: u32 = 4;
pub const PROGRESS_CLUSTER_PHASE_SWAP_REL_FILES: u32 = 5;
pub const PROGRESS_CLUSTER_PHASE_REBUILD_INDEX: u32 = 6;
pub const PROGRESS_CLUSTER_PHASE_FINAL_CLEANUP: u32 = 7;
pub const PROGRESS_CLUSTER_COMMAND_CLUSTER: u32 = 1;
pub const PROGRESS_CLUSTER_COMMAND_VACUUM_FULL: u32 = 2;
pub const PROGRESS_CREATEIDX_COMMAND: u32 = 0;
pub const PROGRESS_CREATEIDX_INDEX_OID: Oid = Oid(6);
pub const PROGRESS_CREATEIDX_ACCESS_METHOD_OID: Oid = Oid(8);
pub const PROGRESS_CREATEIDX_PHASE: u32 = 9;
pub const PROGRESS_CREATEIDX_SUBPHASE: u32 = 10;
pub const PROGRESS_CREATEIDX_TUPLES_TOTAL: u32 = 11;
pub const PROGRESS_CREATEIDX_TUPLES_DONE: u32 = 12;
pub const PROGRESS_CREATEIDX_PARTITIONS_TOTAL: u32 = 13;
pub const PROGRESS_CREATEIDX_PARTITIONS_DONE: u32 = 14;
pub const PROGRESS_CREATEIDX_PHASE_WAIT_1: u32 = 1;
pub const PROGRESS_CREATEIDX_PHASE_BUILD: u32 = 2;
pub const PROGRESS_CREATEIDX_PHASE_WAIT_2: u32 = 3;
pub const PROGRESS_CREATEIDX_PHASE_VALIDATE_IDXSCAN: u32 = 4;
pub const PROGRESS_CREATEIDX_PHASE_VALIDATE_SORT: u32 = 5;
pub const PROGRESS_CREATEIDX_PHASE_VALIDATE_TABLESCAN: u32 = 6;
pub const PROGRESS_CREATEIDX_PHASE_WAIT_3: u32 = 7;
pub const PROGRESS_CREATEIDX_PHASE_WAIT_4: u32 = 8;
pub const PROGRESS_CREATEIDX_PHASE_WAIT_5: u32 = 9;
pub const PROGRESS_CREATEIDX_SUBPHASE_INITIALIZE: u32 = 1;
pub const PROGRESS_CREATEIDX_COMMAND_CREATE: u32 = 1;
pub const PROGRESS_CREATEIDX_COMMAND_CREATE_CONCURRENTLY: u32 = 2;
pub const PROGRESS_CREATEIDX_COMMAND_REINDEX: u32 = 3;
pub const PROGRESS_CREATEIDX_COMMAND_REINDEX_CONCURRENTLY: u32 = 4;
pub const PROGRESS_WAITFOR_TOTAL: u32 = 3;
pub const PROGRESS_WAITFOR_DONE: u32 = 4;
pub const PROGRESS_WAITFOR_CURRENT_PID: u32 = 5;
pub const PROGRESS_SCAN_BLOCKS_TOTAL: u32 = 15;
pub const PROGRESS_SCAN_BLOCKS_DONE: u32 = 16;
pub const PROGRESS_BASEBACKUP_PHASE: u32 = 0;
pub const PROGRESS_BASEBACKUP_BACKUP_TOTAL: u32 = 1;
pub const PROGRESS_BASEBACKUP_BACKUP_STREAMED: u32 = 2;
pub const PROGRESS_BASEBACKUP_TBLSPC_TOTAL: u32 = 3;
pub const PROGRESS_BASEBACKUP_TBLSPC_STREAMED: u32 = 4;
pub const PROGRESS_BASEBACKUP_PHASE_WAIT_CHECKPOINT: u32 = 1;
pub const PROGRESS_BASEBACKUP_PHASE_ESTIMATE_BACKUP_SIZE: u32 = 2;
pub const PROGRESS_BASEBACKUP_PHASE_STREAM_BACKUP: u32 = 3;
pub const PROGRESS_BASEBACKUP_PHASE_WAIT_WAL_ARCHIVE: u32 = 4;
pub const PROGRESS_BASEBACKUP_PHASE_TRANSFER_WAL: u32 = 5;
pub const PROGRESS_COPY_BYTES_PROCESSED: u32 = 0;
pub const PROGRESS_COPY_BYTES_TOTAL: u32 = 1;
pub const PROGRESS_COPY_TUPLES_PROCESSED: u32 = 2;
pub const PROGRESS_COPY_TUPLES_EXCLUDED: u32 = 3;
pub const PROGRESS_COPY_COMMAND: u32 = 4;
pub const PROGRESS_COPY_TYPE: u32 = 5;
pub const PROGRESS_COPY_COMMAND_FROM: u32 = 1;
pub const PROGRESS_COPY_COMMAND_TO: u32 = 2;
pub const PROGRESS_COPY_TYPE_FILE: u32 = 1;
pub const PROGRESS_COPY_TYPE_PROGRAM: u32 = 2;
pub const PROGRESS_COPY_TYPE_PIPE: u32 = 3;
pub const PROGRESS_COPY_TYPE_CALLBACK: u32 = 4;
pub const XLOG_TBLSPC_CREATE: u32 = 0;
pub const XLOG_TBLSPC_DROP: u32 = 16;
pub const TRIGGER_EVENT_INSERT: u32 = 0;
pub const TRIGGER_EVENT_DELETE: u32 = 1;
pub const TRIGGER_EVENT_UPDATE: u32 = 2;
pub const TRIGGER_EVENT_TRUNCATE: u32 = 3;
pub const TRIGGER_EVENT_OPMASK: u32 = 3;
pub const TRIGGER_EVENT_ROW: u32 = 4;
pub const TRIGGER_EVENT_BEFORE: u32 = 8;
pub const TRIGGER_EVENT_AFTER: u32 = 0;
pub const TRIGGER_EVENT_INSTEAD: u32 = 16;
pub const TRIGGER_EVENT_TIMINGMASK: u32 = 24;
pub const AFTER_TRIGGER_DEFERRABLE: u32 = 32;
pub const AFTER_TRIGGER_INITDEFERRED: u32 = 64;
pub const SESSION_REPLICATION_ROLE_ORIGIN: u32 = 0;
pub const SESSION_REPLICATION_ROLE_REPLICA: u32 = 1;
pub const SESSION_REPLICATION_ROLE_LOCAL: u32 = 2;
pub const TRIGGER_FIRES_ON_ORIGIN: u8 = 79u8;
pub const TRIGGER_FIRES_ALWAYS: u8 = 65u8;
pub const TRIGGER_FIRES_ON_REPLICA: u8 = 82u8;
pub const TRIGGER_DISABLED: u8 = 68u8;
pub const RI_TRIGGER_PK: u32 = 1;
pub const RI_TRIGGER_FK: u32 = 2;
pub const RI_TRIGGER_NONE: u32 = 0;
pub const BGWORKER_SHMEM_ACCESS: u32 = 1;
pub const BGWORKER_BACKEND_DATABASE_CONNECTION: u32 = 2;
pub const BGWORKER_CLASS_PARALLEL: u32 = 16;
pub const BGW_DEFAULT_RESTART_INTERVAL: u32 = 60;
pub const BGW_NEVER_RESTART: i32 = -1;
pub const BGW_MAXLEN: u32 = 96;
pub const BGW_EXTRALEN: u32 = 128;
pub const BGWORKER_BYPASS_ALLOWCONN: u32 = 1;
pub const TRANSACTION_STATUS_IN_PROGRESS: u32 = 0;
pub const TRANSACTION_STATUS_COMMITTED: u32 = 1;
pub const TRANSACTION_STATUS_ABORTED: u32 = 2;
pub const TRANSACTION_STATUS_SUB_COMMITTED: u32 = 3;
pub const CLOG_ZEROPAGE: u32 = 0;
pub const CLOG_TRUNCATE: u32 = 16;
pub const WL_LATCH_SET: u32 = 1;
pub const WL_SOCKET_READABLE: u32 = 2;
pub const WL_SOCKET_WRITEABLE: u32 = 4;
pub const WL_TIMEOUT: u32 = 8;
pub const WL_POSTMASTER_DEATH: u32 = 16;
pub const WL_EXIT_ON_PM_DEATH: u32 = 32;
pub const WL_SOCKET_CONNECTED: u32 = 4;
pub const WL_SOCKET_CLOSED: u32 = 128;
pub const WL_SOCKET_MASK: u32 = 134;
pub const PGPROC_MAX_CACHED_SUBXIDS: u32 = 64;
pub const PROC_IS_AUTOVACUUM: u32 = 1;
pub const PROC_IN_VACUUM: u32 = 2;
pub const PROC_IN_SAFE_IC: u32 = 4;
pub const PROC_VACUUM_FOR_WRAPAROUND: u32 = 8;
pub const PROC_IN_LOGICAL_DECODING: u32 = 16;
pub const PROC_AFFECTS_ALL_HORIZONS: u32 = 32;
pub const PROC_VACUUM_STATE_MASK: u32 = 14;
pub const PROC_XMIN_FLAGS: u32 = 6;
pub const FP_LOCK_SLOTS_PER_BACKEND: u32 = 16;
pub const INVALID_PGPROCNO: u32 = 2147483647;
pub const DELAY_CHKPT_START: u32 = 1;
pub const DELAY_CHKPT_COMPLETE: u32 = 2;
pub const NUM_AUXILIARY_PROCS: u32 = 5;
pub const StatisticRelationId: Oid = Oid(2619);
pub const StatisticRelidAttnumInhIndexId: u32 = 2696;
pub const Anum_pg_statistic_starelid: u32 = 1;
pub const Anum_pg_statistic_staattnum: u32 = 2;
pub const Anum_pg_statistic_stainherit: u32 = 3;
pub const Anum_pg_statistic_stanullfrac: u32 = 4;
pub const Anum_pg_statistic_stawidth: u32 = 5;
pub const Anum_pg_statistic_stadistinct: u32 = 6;
pub const Anum_pg_statistic_stakind1: u32 = 7;
pub const Anum_pg_statistic_stakind2: u32 = 8;
pub const Anum_pg_statistic_stakind3: u32 = 9;
pub const Anum_pg_statistic_stakind4: u32 = 10;
pub const Anum_pg_statistic_stakind5: u32 = 11;
pub const Anum_pg_statistic_staop1: u32 = 12;
pub const Anum_pg_statistic_staop2: u32 = 13;
pub const Anum_pg_statistic_staop3: u32 = 14;
pub const Anum_pg_statistic_staop4: u32 = 15;
pub const Anum_pg_statistic_staop5: u32 = 16;
pub const Anum_pg_statistic_stacoll1: u32 = 17;
pub const Anum_pg_statistic_stacoll2: u32 = 18;
pub const Anum_pg_statistic_stacoll3: u32 = 19;
pub const Anum_pg_statistic_stacoll4: u32 = 20;
pub const Anum_pg_statistic_stacoll5: u32 = 21;
pub const Anum_pg_statistic_stanumbers1: u32 = 22;
pub const Anum_pg_statistic_stanumbers2: u32 = 23;
pub const Anum_pg_statistic_stanumbers3: u32 = 24;
pub const Anum_pg_statistic_stanumbers4: u32 = 25;
pub const Anum_pg_statistic_stanumbers5: u32 = 26;
pub const Anum_pg_statistic_stavalues1: u32 = 27;
pub const Anum_pg_statistic_stavalues2: u32 = 28;
pub const Anum_pg_statistic_stavalues3: u32 = 29;
pub const Anum_pg_statistic_stavalues4: u32 = 30;
pub const Anum_pg_statistic_stavalues5: u32 = 31;
pub const Natts_pg_statistic: u32 = 31;
pub const STATISTIC_KIND_MCV: u32 = 1;
pub const STATISTIC_KIND_HISTOGRAM: u32 = 2;
pub const STATISTIC_KIND_CORRELATION: u32 = 3;
pub const STATISTIC_KIND_MCELEM: u32 = 4;
pub const STATISTIC_KIND_DECHIST: u32 = 5;
pub const STATISTIC_KIND_RANGE_LENGTH_HISTOGRAM: u32 = 6;
pub const STATISTIC_KIND_BOUNDS_HISTOGRAM: u32 = 7;
pub const STATISTIC_NUM_SLOTS: u32 = 5;
pub const VACUUM_OPTION_NO_PARALLEL: u32 = 0;
pub const VACUUM_OPTION_PARALLEL_BULKDEL: u32 = 1;
pub const VACUUM_OPTION_PARALLEL_COND_CLEANUP: u32 = 2;
pub const VACUUM_OPTION_PARALLEL_CLEANUP: u32 = 4;
pub const VACUUM_OPTION_MAX_VALID_VALUE: u32 = 7;
pub const VACOPT_VACUUM: u32 = 1;
pub const VACOPT_ANALYZE: u32 = 2;
pub const VACOPT_VERBOSE: u32 = 4;
pub const VACOPT_FREEZE: u32 = 8;
pub const VACOPT_FULL: u32 = 16;
pub const VACOPT_SKIP_LOCKED: u32 = 32;
pub const VACOPT_PROCESS_TOAST: u32 = 64;
pub const VACOPT_DISABLE_PAGE_SKIPPING: u32 = 128;
pub const FIELDNO_AGGSTATEPERGROUPDATA_TRANSVALUE: u32 = 0;
pub const FIELDNO_AGGSTATEPERGROUPDATA_TRANSVALUEISNULL: u32 = 1;
pub const FIELDNO_AGGSTATEPERGROUPDATA_NOTRANSVALUE: u32 = 2;
pub const EEO_FLAG_INTERPRETER_INITIALIZED: u32 = 2;
pub const EEO_FLAG_DIRECT_THREADED: u32 = 4;
pub const SPI_ERROR_CONNECT: i32 = -1;
pub const SPI_ERROR_COPY: i32 = -2;
pub const SPI_ERROR_OPUNKNOWN: i32 = -3;
pub const SPI_ERROR_UNCONNECTED: i32 = -4;
pub const SPI_ERROR_CURSOR: i32 = -5;
pub const SPI_ERROR_ARGUMENT: i32 = -6;
pub const SPI_ERROR_PARAM: i32 = -7;
pub const SPI_ERROR_TRANSACTION: i32 = -8;
pub const SPI_ERROR_NOATTRIBUTE: i32 = -9;
pub const SPI_ERROR_NOOUTFUNC: i32 = -10;
pub const SPI_ERROR_TYPUNKNOWN: i32 = -11;
pub const SPI_ERROR_REL_DUPLICATE: i32 = -12;
pub const SPI_ERROR_REL_NOT_FOUND: i32 = -13;
pub const SPI_OK_CONNECT: u32 = 1;
pub const SPI_OK_FINISH: u32 = 2;
pub const SPI_OK_FETCH: u32 = 3;
pub const SPI_OK_UTILITY: u32 = 4;
pub const SPI_OK_SELECT: u32 = 5;
pub const SPI_OK_SELINTO: u32 = 6;
pub const SPI_OK_INSERT: u32 = 7;
pub const SPI_OK_DELETE: u32 = 8;
pub const SPI_OK_UPDATE: u32 = 9;
pub const SPI_OK_CURSOR: u32 = 10;
pub const SPI_OK_INSERT_RETURNING: u32 = 11;
pub const SPI_OK_DELETE_RETURNING: u32 = 12;
pub const SPI_OK_UPDATE_RETURNING: u32 = 13;
pub const SPI_OK_REWRITTEN: u32 = 14;
pub const SPI_OK_REL_REGISTER: u32 = 15;
pub const SPI_OK_REL_UNREGISTER: u32 = 16;
pub const SPI_OK_TD_REGISTER: u32 = 17;
pub const SPI_OK_MERGE: u32 = 18;
pub const SPI_OPT_NONATOMIC: u32 = 1;
pub const AMFLAG_HAS_TID_RANGE: u32 = 1;
pub const GROUPING_CAN_USE_SORT: u32 = 1;
pub const GROUPING_CAN_USE_HASH: u32 = 2;
pub const GROUPING_CAN_PARTIAL_AGG: u32 = 4;
pub const FSV_MISSING_OK: u32 = 1;
pub const FDW_MISSING_OK: u32 = 1;
pub const PGJIT_NONE: u32 = 0;
pub const PGJIT_PERFORM: u32 = 1;
pub const PGJIT_OPT3: u32 = 2;
pub const PGJIT_INLINE: u32 = 4;
pub const PGJIT_EXPR: u32 = 8;
pub const PGJIT_DEFORM: u32 = 16;
pub const MAX_MULTIBYTE_CHAR_LEN: u32 = 4;
pub const SS2: u32 = 142;
pub const SS3: u32 = 143;
pub const LC_ISO8859_1: u32 = 129;
pub const LC_ISO8859_2: u32 = 130;
pub const LC_ISO8859_3: u32 = 131;
pub const LC_ISO8859_4: u32 = 132;
pub const LC_TIS620: u32 = 133;
pub const LC_ISO8859_7: u32 = 134;
pub const LC_ISO8859_6: u32 = 135;
pub const LC_ISO8859_8: u32 = 136;
pub const LC_JISX0201K: u32 = 137;
pub const LC_JISX0201R: u32 = 138;
pub const LC_KOI8_R: u32 = 139;
pub const LC_ISO8859_5: u32 = 140;
pub const LC_ISO8859_9: u32 = 141;
pub const LC_ISO8859_15: u32 = 142;
pub const LC_JISX0208_1978: u32 = 144;
pub const LC_GB2312_80: u32 = 145;
pub const LC_JISX0208: u32 = 146;
pub const LC_KS5601: u32 = 147;
pub const LC_JISX0212: u32 = 148;
pub const LC_CNS11643_1: u32 = 149;
pub const LC_CNS11643_2: u32 = 150;
pub const LC_JISX0213_1: u32 = 151;
pub const LC_BIG5_1: u32 = 152;
pub const LC_BIG5_2: u32 = 153;
pub const LCPRV1_A: u32 = 154;
pub const LCPRV1_B: u32 = 155;
pub const LCPRV2_A: u32 = 156;
pub const LCPRV2_B: u32 = 157;
pub const LC_SISHENG: u32 = 160;
pub const LC_IPA: u32 = 161;
pub const LC_VISCII_LOWER: u32 = 162;
pub const LC_VISCII_UPPER: u32 = 163;
pub const LC_ARABIC_DIGIT: u32 = 164;
pub const LC_ARABIC_1_COLUMN: u32 = 165;
pub const LC_ASCII_RIGHT_TO_LEFT: u32 = 166;
pub const LC_LAO: u32 = 167;
pub const LC_ARABIC_2_COLUMN: u32 = 168;
pub const LC_INDIAN_1_COLUMN: u32 = 240;
pub const LC_TIBETAN_1_COLUMN: u32 = 241;
pub const LC_UNICODE_SUBSET_2: u32 = 242;
pub const LC_UNICODE_SUBSET_3: u32 = 243;
pub const LC_UNICODE_SUBSET: u32 = 244;
pub const LC_ETHIOPIC: u32 = 245;
pub const LC_CNS11643_3: u32 = 246;
pub const LC_CNS11643_4: u32 = 247;
pub const LC_CNS11643_5: u32 = 248;
pub const LC_CNS11643_6: u32 = 249;
pub const LC_CNS11643_7: u32 = 250;
pub const LC_INDIAN_2_COLUMN: u32 = 251;
pub const LC_TIBETAN: u32 = 252;
pub const MAX_CONVERSION_GROWTH: u32 = 4;
pub const MAX_CONVERSION_INPUT_LENGTH: u32 = 16;
pub const MAX_UNICODE_EQUIVALENT_STRING: u32 = 16;
pub const EXTNODENAME_MAX_LEN: u32 = 64;
pub const CUSTOMPATH_SUPPORT_BACKWARD_SCAN: u32 = 1;
pub const CUSTOMPATH_SUPPORT_MARK_RESTORE: u32 = 2;
pub const CUSTOMPATH_SUPPORT_PROJECTION: u32 = 4;
pub const QTW_IGNORE_RT_SUBQUERIES: u32 = 1;
pub const QTW_IGNORE_CTE_SUBQUERIES: u32 = 2;
pub const QTW_IGNORE_RC_SUBQUERIES: u32 = 3;
pub const QTW_IGNORE_JOINALIASES: u32 = 4;
pub const QTW_IGNORE_RANGE_TABLE: u32 = 8;
pub const QTW_EXAMINE_RTES_BEFORE: u32 = 16;
pub const QTW_EXAMINE_RTES_AFTER: u32 = 32;
pub const QTW_DONT_COPY_QUERY: u32 = 64;
pub const QTW_EXAMINE_SORTGROUP: u32 = 128;
pub const DEFAULT_SEQ_PAGE_COST: f64 = 1.0;
pub const DEFAULT_RANDOM_PAGE_COST: f64 = 4.0;
pub const DEFAULT_CPU_TUPLE_COST: f64 = 0.01;
pub const DEFAULT_CPU_INDEX_TUPLE_COST: f64 = 0.005;
pub const DEFAULT_CPU_OPERATOR_COST: f64 = 0.0025;
pub const DEFAULT_PARALLEL_TUPLE_COST: f64 = 0.1;
pub const DEFAULT_PARALLEL_SETUP_COST: f64 = 1000.0;
pub const DEFAULT_RECURSIVE_WORKTABLE_FACTOR: f64 = 10.0;
pub const DEFAULT_EFFECTIVE_CACHE_SIZE: u32 = 524288;
pub const PVC_INCLUDE_AGGREGATES: u32 = 1;
pub const PVC_RECURSE_AGGREGATES: u32 = 2;
pub const PVC_INCLUDE_WINDOWFUNCS: u32 = 4;
pub const PVC_RECURSE_WINDOWFUNCS: u32 = 8;
pub const PVC_INCLUDE_PLACEHOLDERS: u32 = 16;
pub const PVC_RECURSE_PLACEHOLDERS: u32 = 32;
pub const DEFAULT_CURSOR_TUPLE_FRACTION: f64 = 0.1;
pub const JUMBLE_SIZE: u32 = 1024;
pub const ER_MAGIC: u32 = 1384727874;
pub const ER_FLAG_FVALUE_VALID: u32 = 1;
pub const ER_FLAG_FVALUE_ALLOCED: u32 = 2;
pub const ER_FLAG_DVALUES_VALID: u32 = 4;
pub const ER_FLAG_DVALUES_ALLOCED: u32 = 8;
pub const ER_FLAG_HAVE_EXTERNAL: u32 = 16;
pub const ER_FLAG_TUPDESC_ALLOCED: u32 = 32;
pub const ER_FLAG_IS_DOMAIN: u32 = 64;
pub const ER_FLAG_IS_DUMMY: u32 = 128;
pub const ER_FLAGS_NON_DATA: u32 = 224;
pub const TYPECACHE_EQ_OPR: u32 = 1;
pub const TYPECACHE_LT_OPR: u32 = 2;
pub const TYPECACHE_GT_OPR: u32 = 4;
pub const TYPECACHE_CMP_PROC: u32 = 8;
pub const TYPECACHE_HASH_PROC: u32 = 16;
pub const TYPECACHE_EQ_OPR_FINFO: u32 = 32;
pub const TYPECACHE_CMP_PROC_FINFO: u32 = 64;
pub const TYPECACHE_HASH_PROC_FINFO: u32 = 128;
pub const TYPECACHE_TUPDESC: u32 = 256;
pub const TYPECACHE_BTREE_OPFAMILY: u32 = 512;
pub const TYPECACHE_HASH_OPFAMILY: u32 = 1024;
pub const TYPECACHE_RANGE_INFO: u32 = 2048;
pub const TYPECACHE_DOMAIN_BASE_INFO: u32 = 4096;
pub const TYPECACHE_DOMAIN_CONSTR_INFO: u32 = 8192;
pub const TYPECACHE_HASH_EXTENDED_PROC: u32 = 16384;
pub const TYPECACHE_HASH_EXTENDED_PROC_FINFO: u32 = 32768;
pub const TYPECACHE_MULTIRANGE_INFO: u32 = 65536;
pub const PLPGSQL_XCHECK_NONE: u32 = 0;
pub const PLPGSQL_XCHECK_SHADOWVAR: u32 = 2;
pub const PLPGSQL_XCHECK_TOOMANYROWS: u32 = 4;
pub const PLPGSQL_XCHECK_STRICTMULTIASSIGNMENT: u32 = 8;
pub const POSTMASTER_FD_WATCH: u32 = 0;
pub const POSTMASTER_FD_OWN: u32 = 1;
pub const MAX_BACKENDS: u32 = 262143;
pub const PIPE_PROTO_IS_LAST: u32 = 1;
pub const PIPE_PROTO_DEST_STDERR: u32 = 16;
pub const PIPE_PROTO_DEST_CSVLOG: u32 = 32;
pub const PIPE_PROTO_DEST_JSONLOG: u32 = 64;
pub const LOG_METAINFO_DATAFILE: &::core::ffi::CStr = c"current_logfiles";
pub const LOG_METAINFO_DATAFILE_TMP: &::core::ffi::CStr = c"current_logfiles.tmp";
pub const RBTXN_HAS_CATALOG_CHANGES: u32 = 1;
pub const RBTXN_IS_SUBXACT: u32 = 2;
pub const RBTXN_IS_SERIALIZED: u32 = 4;
pub const RBTXN_IS_SERIALIZED_CLEAR: u32 = 8;
pub const RBTXN_IS_STREAMED: u32 = 16;
pub const RBTXN_HAS_PARTIAL_CHANGE: u32 = 32;
pub const RBTXN_PREPARE: u32 = 64;
pub const RBTXN_SKIPPED_PREPARE: u32 = 128;
pub const LOGICALREP_PROTO_MIN_VERSION_NUM: u32 = 1;
pub const LOGICALREP_PROTO_VERSION_NUM: u32 = 1;
pub const LOGICALREP_PROTO_STREAM_VERSION_NUM: u32 = 2;
pub const LOGICALREP_PROTO_TWOPHASE_VERSION_NUM: u32 = 3;
pub const LOGICALREP_PROTO_MAX_VERSION_NUM: u32 = 3;
pub const LOGICALREP_COLUMN_NULL: u8 = 110u8;
pub const LOGICALREP_COLUMN_UNCHANGED: u8 = 117u8;
pub const LOGICALREP_COLUMN_TEXT: u8 = 116u8;
pub const LOGICALREP_COLUMN_BINARY: u8 = 98u8;
pub const MAXCONNINFO: u32 = 1024;
pub const STATS_MAX_DIMENSIONS: u32 = 8;
pub const STATS_NDISTINCT_MAGIC: u32 = 2740109220;
pub const STATS_NDISTINCT_TYPE_BASIC: u32 = 1;
pub const STATS_DEPS_MAGIC: u32 = 3025443372;
pub const STATS_DEPS_TYPE_BASIC: u32 = 1;
pub const STATS_MCV_MAGIC: u32 = 3785773506;
pub const STATS_MCV_TYPE_BASIC: u32 = 1;
pub const STATS_MCVLIST_MAX_ITEMS: u32 = 10000;
pub const BUF_REFCOUNT_ONE: u32 = 1;
pub const BUF_REFCOUNT_MASK: u32 = 262143;
pub const BUF_USAGECOUNT_MASK: u32 = 3932160;
pub const BUF_USAGECOUNT_ONE: u32 = 262144;
pub const BUF_USAGECOUNT_SHIFT: u32 = 18;
pub const BUF_FLAG_MASK: u32 = 4290772992;
pub const BM_LOCKED: u32 = 4194304;
pub const BM_DIRTY: u32 = 8388608;
pub const BM_VALID: u32 = 16777216;
pub const BM_TAG_VALID: u32 = 33554432;
pub const BM_IO_IN_PROGRESS: u32 = 67108864;
pub const BM_IO_ERROR: u32 = 134217728;
pub const BM_JUST_DIRTIED: u32 = 268435456;
pub const BM_PIN_COUNT_WAITER: u32 = 536870912;
pub const BM_CHECKPOINT_NEEDED: u32 = 1073741824;
pub const BM_PERMANENT: u32 = 2147483648;
pub const BM_MAX_USAGE_COUNT: u32 = 5;
pub const FREENEXT_END_OF_LIST: i32 = -1;
pub const FREENEXT_NOT_IN_LIST: i32 = -2;
pub const XLOG_STANDBY_LOCK: u32 = 0;
pub const XLOG_RUNNING_XACTS: u32 = 16;
pub const XLOG_INVALIDATIONS: u32 = 32;
pub const STACK_DEPTH_SLOP: u32 = 524288;
pub const RESTRICT_RELKIND_VIEW: u32 = 1;
pub const RESTRICT_RELKIND_FOREIGN_TABLE: u32 = 2;
pub const COMMAND_OK_IN_READ_ONLY_TXN: u32 = 1;
pub const COMMAND_OK_IN_PARALLEL_MODE: u32 = 2;
pub const COMMAND_OK_IN_RECOVERY: u32 = 4;
pub const COMMAND_IS_STRICTLY_READ_ONLY: u32 = 7;
pub const COMMAND_IS_NOT_READ_ONLY: u32 = 0;
pub const MAXSTRLEN: u32 = 2047;
pub const MAXSTRPOS: u32 = 1048575;
pub const MAXENTRYPOS: u32 = 16384;
pub const MAXNUMPOS: u32 = 256;
pub const QI_VAL: u32 = 1;
pub const QI_OPR: u32 = 2;
pub const QI_VALSTOP: u32 = 3;
pub const OP_NOT: u32 = 1;
pub const OP_AND: u32 = 2;
pub const OP_OR: u32 = 3;
pub const OP_PHRASE: u32 = 4;
pub const OP_COUNT: u32 = 4;
pub const TSL_ADDPOS: u32 = 1;
pub const TSL_PREFIX: u32 = 2;
pub const TSL_FILTER: u32 = 4;
pub const P_TSV_OPR_IS_DELIM: u32 = 1;
pub const P_TSV_IS_TSQUERY: u32 = 2;
pub const P_TSV_IS_WEB: u32 = 4;
pub const P_TSQ_PLAIN: u32 = 1;
pub const P_TSQ_WEB: u32 = 2;
pub const TS_EXEC_EMPTY: u32 = 0;
pub const TS_EXEC_SKIP_NOT: u32 = 1;
pub const TS_EXEC_PHRASE_NO_POS: u32 = 2;
pub const TSearchStrategyNumber: u32 = 1;
pub const TSearchWithClassStrategyNumber: u32 = 2;
pub const QTN_NEEDFREE: u32 = 1;
pub const QTN_NOCHANGE: u32 = 2;
pub const QTN_WORDFREE: u32 = 4;
pub const MAXINT8LEN: u32 = 20;
pub const FORMAT_TYPE_TYPEMOD_GIVEN: u32 = 1;
pub const FORMAT_TYPE_ALLOW_INVALID: u32 = 2;
pub const FORMAT_TYPE_FORCE_QUALIFY: u32 = 4;
pub const FORMAT_TYPE_INVALID_AS_NULL: u32 = 8;
pub const MAX_TIME_PRECISION: u32 = 6;
pub const DAGO: &::core::ffi::CStr = c"ago";
pub const DCURRENT: &::core::ffi::CStr = c"current";
pub const EPOCH: &::core::ffi::CStr = c"epoch";
pub const INVALID: &::core::ffi::CStr = c"invalid";
pub const EARLY: &::core::ffi::CStr = c"-infinity";
pub const LATE: &::core::ffi::CStr = c"infinity";
pub const NOW: &::core::ffi::CStr = c"now";
pub const TODAY: &::core::ffi::CStr = c"today";
pub const TOMORROW: &::core::ffi::CStr = c"tomorrow";
pub const YESTERDAY: &::core::ffi::CStr = c"yesterday";
pub const ZULU: &::core::ffi::CStr = c"zulu";
pub const DMICROSEC: &::core::ffi::CStr = c"usecond";
pub const DMILLISEC: &::core::ffi::CStr = c"msecond";
pub const DSECOND: &::core::ffi::CStr = c"second";
pub const DMINUTE: &::core::ffi::CStr = c"minute";
pub const DHOUR: &::core::ffi::CStr = c"hour";
pub const DDAY: &::core::ffi::CStr = c"day";
pub const DWEEK: &::core::ffi::CStr = c"week";
pub const DMONTH: &::core::ffi::CStr = c"month";
pub const DQUARTER: &::core::ffi::CStr = c"quarter";
pub const DYEAR: &::core::ffi::CStr = c"year";
pub const DDECADE: &::core::ffi::CStr = c"decade";
pub const DCENTURY: &::core::ffi::CStr = c"century";
pub const DMILLENNIUM: &::core::ffi::CStr = c"millennium";
pub const DA_D: &::core::ffi::CStr = c"ad";
pub const DB_C: &::core::ffi::CStr = c"bc";
pub const DTIMEZONE: &::core::ffi::CStr = c"timezone";
pub const AM: u32 = 0;
pub const PM: u32 = 1;
pub const HR24: u32 = 2;
pub const AD: u32 = 0;
pub const BC: u32 = 1;
pub const RESERV: u32 = 0;
pub const MONTH: u32 = 1;
pub const YEAR: u32 = 2;
pub const DAY: u32 = 3;
pub const JULIAN: u32 = 4;
pub const TZ: u32 = 5;
pub const DTZ: u32 = 6;
pub const DYNTZ: u32 = 7;
pub const IGNORE_DTF: u32 = 8;
pub const AMPM: u32 = 9;
pub const HOUR: u32 = 10;
pub const MINUTE: u32 = 11;
pub const SECOND: u32 = 12;
pub const MILLISECOND: u32 = 13;
pub const MICROSECOND: u32 = 14;
pub const DOY: u32 = 15;
pub const DOW: u32 = 16;
pub const UNITS: u32 = 17;
pub const ADBC: u32 = 18;
pub const AGO: u32 = 19;
pub const ABS_BEFORE: u32 = 20;
pub const ABS_AFTER: u32 = 21;
pub const ISODATE: u32 = 22;
pub const ISOTIME: u32 = 23;
pub const WEEK: u32 = 24;
pub const DECADE: u32 = 25;
pub const CENTURY: u32 = 26;
pub const MILLENNIUM: u32 = 27;
pub const DTZMOD: u32 = 28;
pub const UNKNOWN_FIELD: u32 = 31;
pub const DTK_NUMBER: u32 = 0;
pub const DTK_STRING: u32 = 1;
pub const DTK_DATE: u32 = 2;
pub const DTK_TIME: u32 = 3;
pub const DTK_TZ: u32 = 4;
pub const DTK_AGO: u32 = 5;
pub const DTK_SPECIAL: u32 = 6;
pub const DTK_EARLY: u32 = 9;
pub const DTK_LATE: u32 = 10;
pub const DTK_EPOCH: u32 = 11;
pub const DTK_NOW: u32 = 12;
pub const DTK_YESTERDAY: u32 = 13;
pub const DTK_TODAY: u32 = 14;
pub const DTK_TOMORROW: u32 = 15;
pub const DTK_ZULU: u32 = 16;
pub const DTK_DELTA: u32 = 17;
pub const DTK_SECOND: u32 = 18;
pub const DTK_MINUTE: u32 = 19;
pub const DTK_HOUR: u32 = 20;
pub const DTK_DAY: u32 = 21;
pub const DTK_WEEK: u32 = 22;
pub const DTK_MONTH: u32 = 23;
pub const DTK_QUARTER: u32 = 24;
pub const DTK_YEAR: u32 = 25;
pub const DTK_DECADE: u32 = 26;
pub const DTK_CENTURY: u32 = 27;
pub const DTK_MILLENNIUM: u32 = 28;
pub const DTK_MILLISEC: u32 = 29;
pub const DTK_MICROSEC: u32 = 30;
pub const DTK_JULIAN: u32 = 31;
pub const DTK_DOW: u32 = 32;
pub const DTK_DOY: u32 = 33;
pub const DTK_TZ_HOUR: u32 = 34;
pub const DTK_TZ_MINUTE: u32 = 35;
pub const DTK_ISOYEAR: u32 = 36;
pub const DTK_ISODOW: u32 = 37;
pub const MAXDATELEN: u32 = 128;
pub const MAXDATEFIELDS: u32 = 25;
pub const TOKMAXLEN: u32 = 10;
pub const DTERR_BAD_FORMAT: i32 = -1;
pub const DTERR_FIELD_OVERFLOW: i32 = -2;
pub const DTERR_MD_FIELD_OVERFLOW: i32 = -3;
pub const DTERR_INTERVAL_OVERFLOW: i32 = -4;
pub const DTERR_TZDISP_OVERFLOW: i32 = -5;
pub const RADIANS_PER_DEGREE: f64 = 0.017453292519943295;
pub const F_HEAP_TABLEAM_HANDLER: u32 = 3;
pub const F_BYTEAOUT: u32 = 31;
pub const F_CHAROUT: u32 = 33;
pub const F_NAMEIN: u32 = 34;
pub const F_NAMEOUT: u32 = 35;
pub const F_INT2IN: u32 = 38;
pub const F_INT2OUT: u32 = 39;
pub const F_INT2VECTORIN: u32 = 40;
pub const F_INT2VECTOROUT: u32 = 41;
pub const F_INT4IN: u32 = 42;
pub const F_INT4OUT: u32 = 43;
pub const F_REGPROCIN: u32 = 44;
pub const F_REGPROCOUT: u32 = 45;
pub const F_TEXTIN: u32 = 46;
pub const F_TEXTOUT: u32 = 47;
pub const F_TIDIN: u32 = 48;
pub const F_TIDOUT: u32 = 49;
pub const F_XIDIN: u32 = 50;
pub const F_XIDOUT: u32 = 51;
pub const F_CIDIN: u32 = 52;
pub const F_CIDOUT: u32 = 53;
pub const F_OIDVECTORIN: u32 = 54;
pub const F_OIDVECTOROUT: u32 = 55;
pub const F_BOOLLT: u32 = 56;
pub const F_BOOLGT: u32 = 57;
pub const F_BOOLEQ: u32 = 60;
pub const F_CHAREQ: u32 = 61;
pub const F_NAMEEQ: u32 = 62;
pub const F_INT2EQ: u32 = 63;
pub const F_INT2LT: u32 = 64;
pub const F_INT4EQ: u32 = 65;
pub const F_INT4LT: u32 = 66;
pub const F_TEXTEQ: u32 = 67;
pub const F_XIDEQ: u32 = 68;
pub const F_CIDEQ: u32 = 69;
pub const F_CHARNE: u32 = 70;
pub const F_CHARLE: u32 = 72;
pub const F_CHARGT: u32 = 73;
pub const F_CHARGE: u32 = 74;
pub const F_INT4_CHAR: u32 = 77;
pub const F_CHAR_INT4: u32 = 78;
pub const F_NAMEREGEXEQ: u32 = 79;
pub const F_BOOLNE: u32 = 84;
pub const F_PG_DDL_COMMAND_IN: u32 = 86;
pub const F_PG_DDL_COMMAND_OUT: u32 = 87;
pub const F_PG_DDL_COMMAND_RECV: u32 = 88;
pub const F_VERSION: u32 = 89;
pub const F_PG_DDL_COMMAND_SEND: u32 = 90;
pub const F_EQSEL: u32 = 101;
pub const F_NEQSEL: u32 = 102;
pub const F_SCALARLTSEL: u32 = 103;
pub const F_SCALARGTSEL: u32 = 104;
pub const F_EQJOINSEL: u32 = 105;
pub const F_NEQJOINSEL: u32 = 106;
pub const F_SCALARLTJOINSEL: u32 = 107;
pub const F_SCALARGTJOINSEL: u32 = 108;
pub const F_UNKNOWNIN: u32 = 109;
pub const F_UNKNOWNOUT: u32 = 110;
pub const F_BOX_ABOVE_EQ: u32 = 115;
pub const F_BOX_BELOW_EQ: u32 = 116;
pub const F_POINT_IN: u32 = 117;
pub const F_POINT_OUT: u32 = 118;
pub const F_LSEG_IN: u32 = 119;
pub const F_LSEG_OUT: u32 = 120;
pub const F_PATH_IN: u32 = 121;
pub const F_PATH_OUT: u32 = 122;
pub const F_BOX_IN: u32 = 123;
pub const F_BOX_OUT: u32 = 124;
pub const F_BOX_OVERLAP: u32 = 125;
pub const F_BOX_GE: u32 = 126;
pub const F_BOX_GT: u32 = 127;
pub const F_BOX_EQ: u32 = 128;
pub const F_BOX_LT: u32 = 129;
pub const F_BOX_LE: u32 = 130;
pub const F_POINT_ABOVE: u32 = 131;
pub const F_POINT_LEFT: u32 = 132;
pub const F_POINT_RIGHT: u32 = 133;
pub const F_POINT_BELOW: u32 = 134;
pub const F_POINT_EQ: u32 = 135;
pub const F_ON_PB: u32 = 136;
pub const F_ON_PPATH: u32 = 137;
pub const F_BOX_CENTER: u32 = 138;
pub const F_AREASEL: u32 = 139;
pub const F_AREAJOINSEL: u32 = 140;
pub const F_INT4MUL: u32 = 141;
pub const F_INT4NE: u32 = 144;
pub const F_INT2NE: u32 = 145;
pub const F_INT2GT: u32 = 146;
pub const F_INT4GT: u32 = 147;
pub const F_INT2LE: u32 = 148;
pub const F_INT4LE: u32 = 149;
pub const F_INT4GE: u32 = 150;
pub const F_INT2GE: u32 = 151;
pub const F_INT2MUL: u32 = 152;
pub const F_INT2DIV: u32 = 153;
pub const F_INT4DIV: u32 = 154;
pub const F_INT2MOD: u32 = 155;
pub const F_INT4MOD: u32 = 156;
pub const F_TEXTNE: u32 = 157;
pub const F_INT24EQ: u32 = 158;
pub const F_INT42EQ: u32 = 159;
pub const F_INT24LT: u32 = 160;
pub const F_INT42LT: u32 = 161;
pub const F_INT24GT: u32 = 162;
pub const F_INT42GT: u32 = 163;
pub const F_INT24NE: u32 = 164;
pub const F_INT42NE: u32 = 165;
pub const F_INT24LE: u32 = 166;
pub const F_INT42LE: u32 = 167;
pub const F_INT24GE: u32 = 168;
pub const F_INT42GE: u32 = 169;
pub const F_INT24MUL: u32 = 170;
pub const F_INT42MUL: u32 = 171;
pub const F_INT24DIV: u32 = 172;
pub const F_INT42DIV: u32 = 173;
pub const F_INT2PL: u32 = 176;
pub const F_INT4PL: u32 = 177;
pub const F_INT24PL: u32 = 178;
pub const F_INT42PL: u32 = 179;
pub const F_INT2MI: u32 = 180;
pub const F_INT4MI: u32 = 181;
pub const F_INT24MI: u32 = 182;
pub const F_INT42MI: u32 = 183;
pub const F_OIDEQ: u32 = 184;
pub const F_OIDNE: u32 = 185;
pub const F_BOX_SAME: u32 = 186;
pub const F_BOX_CONTAIN: u32 = 187;
pub const F_BOX_LEFT: u32 = 188;
pub const F_BOX_OVERLEFT: u32 = 189;
pub const F_BOX_OVERRIGHT: u32 = 190;
pub const F_BOX_RIGHT: u32 = 191;
pub const F_BOX_CONTAINED: u32 = 192;
pub const F_BOX_CONTAIN_PT: u32 = 193;
pub const F_PG_NODE_TREE_IN: u32 = 195;
pub const F_PG_NODE_TREE_OUT: u32 = 196;
pub const F_PG_NODE_TREE_RECV: u32 = 197;
pub const F_PG_NODE_TREE_SEND: u32 = 198;
pub const F_FLOAT4IN: u32 = 200;
pub const F_FLOAT4OUT: u32 = 201;
pub const F_FLOAT4MUL: u32 = 202;
pub const F_FLOAT4DIV: u32 = 203;
pub const F_FLOAT4PL: u32 = 204;
pub const F_FLOAT4MI: u32 = 205;
pub const F_FLOAT4UM: u32 = 206;
pub const F_FLOAT4ABS: u32 = 207;
pub const F_FLOAT4_ACCUM: u32 = 208;
pub const F_FLOAT4LARGER: u32 = 209;
pub const F_FLOAT4SMALLER: u32 = 211;
pub const F_INT4UM: u32 = 212;
pub const F_INT2UM: u32 = 213;
pub const F_FLOAT8IN: u32 = 214;
pub const F_FLOAT8OUT: u32 = 215;
pub const F_FLOAT8MUL: u32 = 216;
pub const F_FLOAT8DIV: u32 = 217;
pub const F_FLOAT8PL: u32 = 218;
pub const F_FLOAT8MI: u32 = 219;
pub const F_FLOAT8UM: u32 = 220;
pub const F_FLOAT8ABS: u32 = 221;
pub const F_FLOAT8_ACCUM: u32 = 222;
pub const F_FLOAT8LARGER: u32 = 223;
pub const F_FLOAT8SMALLER: u32 = 224;
pub const F_LSEG_CENTER: u32 = 225;
pub const F_POLY_CENTER: u32 = 227;
pub const F_DROUND: u32 = 228;
pub const F_DTRUNC: u32 = 229;
pub const F_DSQRT: u32 = 230;
pub const F_DCBRT: u32 = 231;
pub const F_DPOW: u32 = 232;
pub const F_DEXP: u32 = 233;
pub const F_DLOG1: u32 = 234;
pub const F_FLOAT8_INT2: u32 = 235;
pub const F_FLOAT4_INT2: u32 = 236;
pub const F_INT2_FLOAT8: u32 = 237;
pub const F_INT2_FLOAT4: u32 = 238;
pub const F_LINE_DISTANCE: u32 = 239;
pub const F_NAMEEQTEXT: u32 = 240;
pub const F_NAMELTTEXT: u32 = 241;
pub const F_NAMELETEXT: u32 = 242;
pub const F_NAMEGETEXT: u32 = 243;
pub const F_NAMEGTTEXT: u32 = 244;
pub const F_NAMENETEXT: u32 = 245;
pub const F_BTNAMETEXTCMP: u32 = 246;
pub const F_TEXTEQNAME: u32 = 247;
pub const F_TEXTLTNAME: u32 = 248;
pub const F_TEXTLENAME: u32 = 249;
pub const F_TEXTGENAME: u32 = 250;
pub const F_TEXTGTNAME: u32 = 251;
pub const F_TEXTNENAME: u32 = 252;
pub const F_BTTEXTNAMECMP: u32 = 253;
pub const F_NAMECONCATOID: Oid = Oid(266);
pub const F_TABLE_AM_HANDLER_IN: u32 = 267;
pub const F_TABLE_AM_HANDLER_OUT: u32 = 268;
pub const F_TIMEOFDAY: u32 = 274;
pub const F_PG_NEXTOID: Oid = Oid(275);
pub const F_FLOAT8_COMBINE: u32 = 276;
pub const F_INTER_SL: u32 = 277;
pub const F_INTER_LB: u32 = 278;
pub const F_FLOAT48MUL: u32 = 279;
pub const F_FLOAT48DIV: u32 = 280;
pub const F_FLOAT48PL: u32 = 281;
pub const F_FLOAT48MI: u32 = 282;
pub const F_FLOAT84MUL: u32 = 283;
pub const F_FLOAT84DIV: u32 = 284;
pub const F_FLOAT84PL: u32 = 285;
pub const F_FLOAT84MI: u32 = 286;
pub const F_FLOAT4EQ: u32 = 287;
pub const F_FLOAT4NE: u32 = 288;
pub const F_FLOAT4LT: u32 = 289;
pub const F_FLOAT4LE: u32 = 290;
pub const F_FLOAT4GT: u32 = 291;
pub const F_FLOAT4GE: u32 = 292;
pub const F_FLOAT8EQ: u32 = 293;
pub const F_FLOAT8NE: u32 = 294;
pub const F_FLOAT8LT: u32 = 295;
pub const F_FLOAT8LE: u32 = 296;
pub const F_FLOAT8GT: u32 = 297;
pub const F_FLOAT8GE: u32 = 298;
pub const F_FLOAT48EQ: u32 = 299;
pub const F_FLOAT48NE: u32 = 300;
pub const F_FLOAT48LT: u32 = 301;
pub const F_FLOAT48LE: u32 = 302;
pub const F_FLOAT48GT: u32 = 303;
pub const F_FLOAT48GE: u32 = 304;
pub const F_FLOAT84EQ: u32 = 305;
pub const F_FLOAT84NE: u32 = 306;
pub const F_FLOAT84LT: u32 = 307;
pub const F_FLOAT84LE: u32 = 308;
pub const F_FLOAT84GT: u32 = 309;
pub const F_FLOAT84GE: u32 = 310;
pub const F_FLOAT8_FLOAT4: u32 = 311;
pub const F_FLOAT4_FLOAT8: u32 = 312;
pub const F_INT4_INT2: u32 = 313;
pub const F_INT2_INT4: u32 = 314;
pub const F_PG_JIT_AVAILABLE: u32 = 315;
pub const F_FLOAT8_INT4: u32 = 316;
pub const F_INT4_FLOAT8: u32 = 317;
pub const F_FLOAT4_INT4: u32 = 318;
pub const F_INT4_FLOAT4: u32 = 319;
pub const F_WIDTH_BUCKET_FLOAT8_FLOAT8_FLOAT8_INT4: u32 = 320;
pub const F_JSON_IN: u32 = 321;
pub const F_JSON_OUT: u32 = 322;
pub const F_JSON_RECV: u32 = 323;
pub const F_JSON_SEND: u32 = 324;
pub const F_INDEX_AM_HANDLER_IN: u32 = 326;
pub const F_INDEX_AM_HANDLER_OUT: u32 = 327;
pub const F_HASHMACADDR8: u32 = 328;
pub const F_HASH_ACLITEM: u32 = 329;
pub const F_BTHANDLER: u32 = 330;
pub const F_HASHHANDLER: u32 = 331;
pub const F_GISTHANDLER: u32 = 332;
pub const F_GINHANDLER: u32 = 333;
pub const F_SPGHANDLER: u32 = 334;
pub const F_BRINHANDLER: u32 = 335;
pub const F_SCALARLESEL: u32 = 336;
pub const F_SCALARGESEL: u32 = 337;
pub const F_AMVALIDATE: u32 = 338;
pub const F_POLY_SAME: u32 = 339;
pub const F_POLY_CONTAIN: u32 = 340;
pub const F_POLY_LEFT: u32 = 341;
pub const F_POLY_OVERLEFT: u32 = 342;
pub const F_POLY_OVERRIGHT: u32 = 343;
pub const F_POLY_RIGHT: u32 = 344;
pub const F_POLY_CONTAINED: u32 = 345;
pub const F_POLY_OVERLAP: u32 = 346;
pub const F_POLY_IN: u32 = 347;
pub const F_POLY_OUT: u32 = 348;
pub const F_BTINT2CMP: u32 = 350;
pub const F_BTINT4CMP: u32 = 351;
pub const F_BTFLOAT4CMP: u32 = 354;
pub const F_BTFLOAT8CMP: u32 = 355;
pub const F_BTOIDCMP: u32 = 356;
pub const F_DIST_BP: u32 = 357;
pub const F_BTCHARCMP: u32 = 358;
pub const F_BTNAMECMP: u32 = 359;
pub const F_BTTEXTCMP: u32 = 360;
pub const F_LSEG_DISTANCE: u32 = 361;
pub const F_LSEG_INTERPT: u32 = 362;
pub const F_DIST_PS: u32 = 363;
pub const F_DIST_PB: u32 = 364;
pub const F_DIST_SB: u32 = 365;
pub const F_CLOSE_PS: u32 = 366;
pub const F_CLOSE_PB: u32 = 367;
pub const F_CLOSE_SB: u32 = 368;
pub const F_ON_PS: u32 = 369;
pub const F_PATH_DISTANCE: u32 = 370;
pub const F_DIST_PPATH: u32 = 371;
pub const F_ON_SB: u32 = 372;
pub const F_INTER_SB: u32 = 373;
pub const F_STRING_TO_ARRAY_TEXT_TEXT_TEXT: u32 = 376;
pub const F_CASH_CMP: u32 = 377;
pub const F_ARRAY_APPEND: u32 = 378;
pub const F_ARRAY_PREPEND: u32 = 379;
pub const F_DIST_SP: u32 = 380;
pub const F_DIST_BS: u32 = 381;
pub const F_BTARRAYCMP: u32 = 382;
pub const F_ARRAY_CAT: u32 = 383;
pub const F_ARRAY_TO_STRING_ANYARRAY_TEXT_TEXT: u32 = 384;
pub const F_SCALARLEJOINSEL: u32 = 386;
pub const F_ARRAY_NE: u32 = 390;
pub const F_ARRAY_LT: u32 = 391;
pub const F_ARRAY_GT: u32 = 392;
pub const F_ARRAY_LE: u32 = 393;
pub const F_STRING_TO_ARRAY_TEXT_TEXT: u32 = 394;
pub const F_ARRAY_TO_STRING_ANYARRAY_TEXT: u32 = 395;
pub const F_ARRAY_GE: u32 = 396;
pub const F_SCALARGEJOINSEL: u32 = 398;
pub const F_HASHMACADDR: u32 = 399;
pub const F_HASHTEXT: u32 = 400;
pub const F_TEXT_BPCHAR: u32 = 401;
pub const F_BTOIDVECTORCMP: u32 = 404;
pub const F_TEXT_NAME: u32 = 406;
pub const F_NAME_TEXT: u32 = 407;
pub const F_BPCHAR_NAME: u32 = 408;
pub const F_NAME_BPCHAR: u32 = 409;
pub const F_DIST_PATHP: u32 = 421;
pub const F_HASHINET: u32 = 422;
pub const F_HASHINT4EXTENDED: u32 = 425;
pub const F_HASH_NUMERIC: u32 = 432;
pub const F_MACADDR_IN: u32 = 436;
pub const F_MACADDR_OUT: u32 = 437;
pub const F_NUM_NULLS: u32 = 438;
pub const F_NUM_NONNULLS: u32 = 440;
pub const F_HASHINT2EXTENDED: u32 = 441;
pub const F_HASHINT8EXTENDED: u32 = 442;
pub const F_HASHFLOAT4EXTENDED: u32 = 443;
pub const F_HASHFLOAT8EXTENDED: u32 = 444;
pub const F_HASHOIDEXTENDED: u32 = 445;
pub const F_HASHCHAREXTENDED: u32 = 446;
pub const F_HASHNAMEEXTENDED: u32 = 447;
pub const F_HASHTEXTEXTENDED: u32 = 448;
pub const F_HASHINT2: u32 = 449;
pub const F_HASHINT4: u32 = 450;
pub const F_HASHFLOAT4: u32 = 451;
pub const F_HASHFLOAT8: u32 = 452;
pub const F_HASHOID: Oid = Oid(453);
pub const F_HASHCHAR: u32 = 454;
pub const F_HASHNAME: u32 = 455;
pub const F_HASHVARLENA: u32 = 456;
pub const F_HASHOIDVECTOR: u32 = 457;
pub const F_TEXT_LARGER: u32 = 458;
pub const F_TEXT_SMALLER: u32 = 459;
pub const F_INT8IN: u32 = 460;
pub const F_INT8OUT: u32 = 461;
pub const F_INT8UM: u32 = 462;
pub const F_INT8PL: u32 = 463;
pub const F_INT8MI: u32 = 464;
pub const F_INT8MUL: u32 = 465;
pub const F_INT8DIV: u32 = 466;
pub const F_INT8EQ: u32 = 467;
pub const F_INT8NE: u32 = 468;
pub const F_INT8LT: u32 = 469;
pub const F_INT8GT: u32 = 470;
pub const F_INT8LE: u32 = 471;
pub const F_INT8GE: u32 = 472;
pub const F_INT84EQ: u32 = 474;
pub const F_INT84NE: u32 = 475;
pub const F_INT84LT: u32 = 476;
pub const F_INT84GT: u32 = 477;
pub const F_INT84LE: u32 = 478;
pub const F_INT84GE: u32 = 479;
pub const F_INT4_INT8: u32 = 480;
pub const F_INT8_INT4: u32 = 481;
pub const F_FLOAT8_INT8: u32 = 482;
pub const F_INT8_FLOAT8: u32 = 483;
pub const F_ARRAY_LARGER: u32 = 515;
pub const F_ARRAY_SMALLER: u32 = 516;
pub const F_ABBREV_INET: u32 = 598;
pub const F_ABBREV_CIDR: u32 = 599;
pub const F_SET_MASKLEN_INET_INT4: u32 = 605;
pub const F_OIDVECTORNE: u32 = 619;
pub const F_HASH_ARRAY: u32 = 626;
pub const F_SET_MASKLEN_CIDR_INT4: u32 = 635;
pub const F_PG_INDEXAM_HAS_PROPERTY: u32 = 636;
pub const F_PG_INDEX_HAS_PROPERTY: u32 = 637;
pub const F_PG_INDEX_COLUMN_HAS_PROPERTY: u32 = 638;
pub const F_FLOAT4_INT8: u32 = 652;
pub const F_INT8_FLOAT4: u32 = 653;
pub const F_NAMELT: u32 = 655;
pub const F_NAMELE: u32 = 656;
pub const F_NAMEGT: u32 = 657;
pub const F_NAMEGE: u32 = 658;
pub const F_NAMENE: u32 = 659;
pub const F_BPCHAR_BPCHAR_INT4_BOOL: u32 = 668;
pub const F_VARCHAR_VARCHAR_INT4_BOOL: u32 = 669;
pub const F_PG_INDEXAM_PROGRESS_PHASENAME: u32 = 676;
pub const F_OIDVECTORLT: u32 = 677;
pub const F_OIDVECTORLE: u32 = 678;
pub const F_OIDVECTOREQ: u32 = 679;
pub const F_OIDVECTORGE: u32 = 680;
pub const F_OIDVECTORGT: u32 = 681;
pub const F_NETWORK: u32 = 683;
pub const F_NETMASK: u32 = 696;
pub const F_MASKLEN: u32 = 697;
pub const F_BROADCAST: u32 = 698;
pub const F_HOST: u32 = 699;
pub const F_DIST_LP: u32 = 702;
pub const F_DIST_LS: u32 = 704;
pub const F_GETPGUSERNAME: u32 = 710;
pub const F_FAMILY: u32 = 711;
pub const F_INT2_INT8: u32 = 714;
pub const F_LO_CREATE: u32 = 715;
pub const F_OIDLT: u32 = 716;
pub const F_OIDLE: u32 = 717;
pub const F_OCTET_LENGTH_BYTEA: u32 = 720;
pub const F_GET_BYTE: u32 = 721;
pub const F_SET_BYTE: u32 = 722;
pub const F_GET_BIT_BYTEA_INT8: u32 = 723;
pub const F_SET_BIT_BYTEA_INT8_INT4: u32 = 724;
pub const F_DIST_PL: u32 = 725;
pub const F_DIST_SL: u32 = 727;
pub const F_DIST_CPOLY: u32 = 728;
pub const F_POLY_DISTANCE: u32 = 729;
pub const F_TEXT_INET: u32 = 730;
pub const F_TEXT_LT: u32 = 740;
pub const F_TEXT_LE: u32 = 741;
pub const F_TEXT_GT: u32 = 742;
pub const F_TEXT_GE: u32 = 743;
pub const F_ARRAY_EQ: u32 = 744;
pub const F_CURRENT_USER: u32 = 745;
pub const F_SESSION_USER: u32 = 746;
pub const F_ARRAY_DIMS: u32 = 747;
pub const F_ARRAY_NDIMS: u32 = 748;
pub const F_OVERLAY_BYTEA_BYTEA_INT4_INT4: u32 = 749;
pub const F_ARRAY_IN: u32 = 750;
pub const F_ARRAY_OUT: u32 = 751;
pub const F_OVERLAY_BYTEA_BYTEA_INT4: u32 = 752;
pub const F_TRUNC_MACADDR: u32 = 753;
pub const F_INT8_INT2: u32 = 754;
pub const F_LO_IMPORT_TEXT: u32 = 764;
pub const F_LO_EXPORT: u32 = 765;
pub const F_INT4INC: u32 = 766;
pub const F_LO_IMPORT_TEXT_OID: Oid = Oid(767);
pub const F_INT4LARGER: u32 = 768;
pub const F_INT4SMALLER: u32 = 769;
pub const F_INT2LARGER: u32 = 770;
pub const F_INT2SMALLER: u32 = 771;
pub const F_HASHVARLENAEXTENDED: u32 = 772;
pub const F_HASHOIDVECTOREXTENDED: u32 = 776;
pub const F_HASH_ACLITEM_EXTENDED: u32 = 777;
pub const F_HASHMACADDREXTENDED: u32 = 778;
pub const F_HASHINETEXTENDED: u32 = 779;
pub const F_HASH_NUMERIC_EXTENDED: u32 = 780;
pub const F_HASHMACADDR8EXTENDED: u32 = 781;
pub const F_HASH_ARRAY_EXTENDED: u32 = 782;
pub const F_DIST_POLYC: u32 = 785;
pub const F_PG_CLIENT_ENCODING: u32 = 810;
pub const F_CURRENT_QUERY: u32 = 817;
pub const F_MACADDR_EQ: u32 = 830;
pub const F_MACADDR_LT: u32 = 831;
pub const F_MACADDR_LE: u32 = 832;
pub const F_MACADDR_GT: u32 = 833;
pub const F_MACADDR_GE: u32 = 834;
pub const F_MACADDR_NE: u32 = 835;
pub const F_MACADDR_CMP: u32 = 836;
pub const F_INT82PL: u32 = 837;
pub const F_INT82MI: u32 = 838;
pub const F_INT82MUL: u32 = 839;
pub const F_INT82DIV: u32 = 840;
pub const F_INT28PL: u32 = 841;
pub const F_BTINT8CMP: u32 = 842;
pub const F_CASH_MUL_FLT4: u32 = 846;
pub const F_CASH_DIV_FLT4: u32 = 847;
pub const F_FLT4_MUL_CASH: u32 = 848;
pub const F_POSITION_TEXT_TEXT: u32 = 849;
pub const F_TEXTLIKE: u32 = 850;
pub const F_TEXTNLIKE: u32 = 851;
pub const F_INT48EQ: u32 = 852;
pub const F_INT48NE: u32 = 853;
pub const F_INT48LT: u32 = 854;
pub const F_INT48GT: u32 = 855;
pub const F_INT48LE: u32 = 856;
pub const F_INT48GE: u32 = 857;
pub const F_NAMELIKE: u32 = 858;
pub const F_NAMENLIKE: u32 = 859;
pub const F_BPCHAR_CHAR: u32 = 860;
pub const F_CURRENT_DATABASE: u32 = 861;
pub const F_INT4_MUL_CASH: u32 = 862;
pub const F_INT2_MUL_CASH: u32 = 863;
pub const F_CASH_MUL_INT4: u32 = 864;
pub const F_CASH_DIV_INT4: u32 = 865;
pub const F_CASH_MUL_INT2: u32 = 866;
pub const F_CASH_DIV_INT2: u32 = 867;
pub const F_STRPOS: u32 = 868;
pub const F_LOWER_TEXT: u32 = 870;
pub const F_UPPER_TEXT: u32 = 871;
pub const F_INITCAP: u32 = 872;
pub const F_LPAD_TEXT_INT4_TEXT: u32 = 873;
pub const F_RPAD_TEXT_INT4_TEXT: u32 = 874;
pub const F_LTRIM_TEXT_TEXT: u32 = 875;
pub const F_RTRIM_TEXT_TEXT: u32 = 876;
pub const F_SUBSTR_TEXT_INT4_INT4: u32 = 877;
pub const F_TRANSLATE: u32 = 878;
pub const F_LPAD_TEXT_INT4: u32 = 879;
pub const F_RPAD_TEXT_INT4: u32 = 880;
pub const F_LTRIM_TEXT: u32 = 881;
pub const F_RTRIM_TEXT: u32 = 882;
pub const F_SUBSTR_TEXT_INT4: u32 = 883;
pub const F_BTRIM_TEXT_TEXT: u32 = 884;
pub const F_BTRIM_TEXT: u32 = 885;
pub const F_CASH_IN: u32 = 886;
pub const F_CASH_OUT: u32 = 887;
pub const F_CASH_EQ: u32 = 888;
pub const F_CASH_NE: u32 = 889;
pub const F_CASH_LT: u32 = 890;
pub const F_CASH_LE: u32 = 891;
pub const F_CASH_GT: u32 = 892;
pub const F_CASH_GE: u32 = 893;
pub const F_CASH_PL: u32 = 894;
pub const F_CASH_MI: u32 = 895;
pub const F_CASH_MUL_FLT8: u32 = 896;
pub const F_CASH_DIV_FLT8: u32 = 897;
pub const F_CASHLARGER: u32 = 898;
pub const F_CASHSMALLER: u32 = 899;
pub const F_INET_IN: u32 = 910;
pub const F_INET_OUT: u32 = 911;
pub const F_FLT8_MUL_CASH: u32 = 919;
pub const F_NETWORK_EQ: u32 = 920;
pub const F_NETWORK_LT: u32 = 921;
pub const F_NETWORK_LE: u32 = 922;
pub const F_NETWORK_GT: u32 = 923;
pub const F_NETWORK_GE: u32 = 924;
pub const F_NETWORK_NE: u32 = 925;
pub const F_NETWORK_CMP: u32 = 926;
pub const F_NETWORK_SUB: u32 = 927;
pub const F_NETWORK_SUBEQ: u32 = 928;
pub const F_NETWORK_SUP: u32 = 929;
pub const F_NETWORK_SUPEQ: u32 = 930;
pub const F_CASH_WORDS: u32 = 935;
pub const F_SUBSTRING_TEXT_INT4_INT4: u32 = 936;
pub const F_SUBSTRING_TEXT_INT4: u32 = 937;
pub const F_GENERATE_SERIES_TIMESTAMP_TIMESTAMP_INTERVAL: u32 = 938;
pub const F_GENERATE_SERIES_TIMESTAMPTZ_TIMESTAMPTZ_INTERVAL: u32 = 939;
pub const F_MOD_INT2_INT2: u32 = 940;
pub const F_MOD_INT4_INT4: u32 = 941;
pub const F_INT28MI: u32 = 942;
pub const F_INT28MUL: u32 = 943;
pub const F_CHAR_TEXT: u32 = 944;
pub const F_INT8MOD: u32 = 945;
pub const F_TEXT_CHAR: u32 = 946;
pub const F_MOD_INT8_INT8: u32 = 947;
pub const F_INT28DIV: u32 = 948;
pub const F_HASHINT8: u32 = 949;
pub const F_LO_OPEN: u32 = 952;
pub const F_LO_CLOSE: u32 = 953;
pub const F_LOREAD: u32 = 954;
pub const F_LOWRITE: u32 = 955;
pub const F_LO_LSEEK: u32 = 956;
pub const F_LO_CREAT: u32 = 957;
pub const F_LO_TELL: u32 = 958;
pub const F_ON_PL: u32 = 959;
pub const F_ON_SL: u32 = 960;
pub const F_CLOSE_PL: u32 = 961;
pub const F_LO_UNLINK: u32 = 964;
pub const F_HASHBPCHAREXTENDED: u32 = 972;
pub const F_PATH_INTER: u32 = 973;
pub const F_AREA_BOX: u32 = 975;
pub const F_WIDTH: u32 = 976;
pub const F_HEIGHT: u32 = 977;
pub const F_BOX_DISTANCE: u32 = 978;
pub const F_AREA_PATH: u32 = 979;
pub const F_BOX_INTERSECT: u32 = 980;
pub const F_DIAGONAL: u32 = 981;
pub const F_PATH_N_LT: u32 = 982;
pub const F_PATH_N_GT: u32 = 983;
pub const F_PATH_N_EQ: u32 = 984;
pub const F_PATH_N_LE: u32 = 985;
pub const F_PATH_N_GE: u32 = 986;
pub const F_PATH_LENGTH: u32 = 987;
pub const F_POINT_NE: u32 = 988;
pub const F_POINT_VERT: u32 = 989;
pub const F_POINT_HORIZ: u32 = 990;
pub const F_POINT_DISTANCE: u32 = 991;
pub const F_SLOPE: u32 = 992;
pub const F_LSEG_POINT_POINT: u32 = 993;
pub const F_LSEG_INTERSECT: u32 = 994;
pub const F_LSEG_PARALLEL: u32 = 995;
pub const F_LSEG_PERP: u32 = 996;
pub const F_LSEG_VERTICAL: u32 = 997;
pub const F_LSEG_HORIZONTAL: u32 = 998;
pub const F_LSEG_EQ: u32 = 999;
pub const F_LO_TRUNCATE: u32 = 1004;
pub const F_TEXTLIKE_SUPPORT: u32 = 1023;
pub const F_TEXTICREGEXEQ_SUPPORT: u32 = 1024;
pub const F_TEXTICLIKE_SUPPORT: u32 = 1025;
pub const F_TIMEZONE_INTERVAL_TIMESTAMPTZ: u32 = 1026;
pub const F_GIST_POINT_COMPRESS: u32 = 1030;
pub const F_ACLITEMIN: u32 = 1031;
pub const F_ACLITEMOUT: u32 = 1032;
pub const F_ACLINSERT: u32 = 1035;
pub const F_ACLREMOVE: u32 = 1036;
pub const F_ACLCONTAINS: u32 = 1037;
pub const F_GETDATABASEENCODING: u32 = 1039;
pub const F_BPCHARIN: u32 = 1044;
pub const F_BPCHAROUT: u32 = 1045;
pub const F_VARCHARIN: u32 = 1046;
pub const F_VARCHAROUT: u32 = 1047;
pub const F_BPCHAREQ: u32 = 1048;
pub const F_BPCHARLT: u32 = 1049;
pub const F_BPCHARLE: u32 = 1050;
pub const F_BPCHARGT: u32 = 1051;
pub const F_BPCHARGE: u32 = 1052;
pub const F_BPCHARNE: u32 = 1053;
pub const F_ACLITEMEQ: u32 = 1062;
pub const F_BPCHAR_LARGER: u32 = 1063;
pub const F_BPCHAR_SMALLER: u32 = 1064;
pub const F_PG_PREPARED_XACT: u32 = 1065;
pub const F_GENERATE_SERIES_INT4_INT4_INT4: u32 = 1066;
pub const F_GENERATE_SERIES_INT4_INT4: u32 = 1067;
pub const F_GENERATE_SERIES_INT8_INT8_INT8: u32 = 1068;
pub const F_GENERATE_SERIES_INT8_INT8: u32 = 1069;
pub const F_BPCHARCMP: u32 = 1078;
pub const F_REGCLASS: u32 = 1079;
pub const F_HASHBPCHAR: u32 = 1080;
pub const F_FORMAT_TYPE: u32 = 1081;
pub const F_DATE_IN: u32 = 1084;
pub const F_DATE_OUT: u32 = 1085;
pub const F_DATE_EQ: u32 = 1086;
pub const F_DATE_LT: u32 = 1087;
pub const F_DATE_LE: u32 = 1088;
pub const F_DATE_GT: u32 = 1089;
pub const F_DATE_GE: u32 = 1090;
pub const F_DATE_NE: u32 = 1091;
pub const F_DATE_CMP: u32 = 1092;
pub const F_TIME_LT: u32 = 1102;
pub const F_TIME_LE: u32 = 1103;
pub const F_TIME_GT: u32 = 1104;
pub const F_TIME_GE: u32 = 1105;
pub const F_TIME_NE: u32 = 1106;
pub const F_TIME_CMP: u32 = 1107;
pub const F_PG_STAT_GET_WAL: u32 = 1136;
pub const F_PG_GET_WAL_REPLAY_PAUSE_STATE: u32 = 1137;
pub const F_DATE_LARGER: u32 = 1138;
pub const F_DATE_SMALLER: u32 = 1139;
pub const F_DATE_MI: u32 = 1140;
pub const F_DATE_PLI: u32 = 1141;
pub const F_DATE_MII: u32 = 1142;
pub const F_TIME_IN: u32 = 1143;
pub const F_TIME_OUT: u32 = 1144;
pub const F_TIME_EQ: u32 = 1145;
pub const F_CIRCLE_ADD_PT: u32 = 1146;
pub const F_CIRCLE_SUB_PT: u32 = 1147;
pub const F_CIRCLE_MUL_PT: u32 = 1148;
pub const F_CIRCLE_DIV_PT: u32 = 1149;
pub const F_TIMESTAMPTZ_IN: u32 = 1150;
pub const F_TIMESTAMPTZ_OUT: u32 = 1151;
pub const F_TIMESTAMPTZ_EQ: u32 = 1152;
pub const F_TIMESTAMPTZ_NE: u32 = 1153;
pub const F_TIMESTAMPTZ_LT: u32 = 1154;
pub const F_TIMESTAMPTZ_LE: u32 = 1155;
pub const F_TIMESTAMPTZ_GE: u32 = 1156;
pub const F_TIMESTAMPTZ_GT: u32 = 1157;
pub const F_TO_TIMESTAMP_FLOAT8: u32 = 1158;
pub const F_TIMEZONE_TEXT_TIMESTAMPTZ: u32 = 1159;
pub const F_INTERVAL_IN: u32 = 1160;
pub const F_INTERVAL_OUT: u32 = 1161;
pub const F_INTERVAL_EQ: u32 = 1162;
pub const F_INTERVAL_NE: u32 = 1163;
pub const F_INTERVAL_LT: u32 = 1164;
pub const F_INTERVAL_LE: u32 = 1165;
pub const F_INTERVAL_GE: u32 = 1166;
pub const F_INTERVAL_GT: u32 = 1167;
pub const F_INTERVAL_UM: u32 = 1168;
pub const F_INTERVAL_PL: u32 = 1169;
pub const F_INTERVAL_MI: u32 = 1170;
pub const F_DATE_PART_TEXT_TIMESTAMPTZ: u32 = 1171;
pub const F_DATE_PART_TEXT_INTERVAL: u32 = 1172;
pub const F_NETWORK_SUBSET_SUPPORT: u32 = 1173;
pub const F_TIMESTAMPTZ_DATE: u32 = 1174;
pub const F_JUSTIFY_HOURS: u32 = 1175;
pub const F_TIMESTAMPTZ_DATE_TIME: u32 = 1176;
pub const F_JSONB_PATH_EXISTS_TZ: u32 = 1177;
pub const F_DATE_TIMESTAMPTZ: u32 = 1178;
pub const F_JSONB_PATH_QUERY_TZ: u32 = 1179;
pub const F_JSONB_PATH_QUERY_ARRAY_TZ: u32 = 1180;
pub const F_AGE_XID: u32 = 1181;
pub const F_TIMESTAMPTZ_MI: u32 = 1188;
pub const F_TIMESTAMPTZ_PL_INTERVAL: u32 = 1189;
pub const F_TIMESTAMPTZ_MI_INTERVAL: u32 = 1190;
pub const F_GENERATE_SUBSCRIPTS_ANYARRAY_INT4_BOOL: u32 = 1191;
pub const F_GENERATE_SUBSCRIPTS_ANYARRAY_INT4: u32 = 1192;
pub const F_ARRAY_FILL_ANYELEMENT__INT4: u32 = 1193;
pub const F_LOG10_FLOAT8: u32 = 1194;
pub const F_TIMESTAMPTZ_SMALLER: u32 = 1195;
pub const F_TIMESTAMPTZ_LARGER: u32 = 1196;
pub const F_INTERVAL_SMALLER: u32 = 1197;
pub const F_INTERVAL_LARGER: u32 = 1198;
pub const F_AGE_TIMESTAMPTZ_TIMESTAMPTZ: u32 = 1199;
pub const F_INTERVAL_INTERVAL_INT4: u32 = 1200;
pub const F_OBJ_DESCRIPTION_OID_NAME: u32 = 1215;
pub const F_COL_DESCRIPTION: u32 = 1216;
pub const F_DATE_TRUNC_TEXT_TIMESTAMPTZ: u32 = 1217;
pub const F_DATE_TRUNC_TEXT_INTERVAL: u32 = 1218;
pub const F_INT8INC: u32 = 1219;
pub const F_INT8ABS: u32 = 1230;
pub const F_INT8LARGER: u32 = 1236;
pub const F_INT8SMALLER: u32 = 1237;
pub const F_TEXTICREGEXEQ: u32 = 1238;
pub const F_TEXTICREGEXNE: u32 = 1239;
pub const F_NAMEICREGEXEQ: u32 = 1240;
pub const F_NAMEICREGEXNE: u32 = 1241;
pub const F_BOOLIN: u32 = 1242;
pub const F_BOOLOUT: u32 = 1243;
pub const F_BYTEAIN: u32 = 1244;
pub const F_CHARIN: u32 = 1245;
pub const F_CHARLT: u32 = 1246;
pub const F_UNIQUE_KEY_RECHECK: u32 = 1250;
pub const F_INT4ABS: u32 = 1251;
pub const F_NAMEREGEXNE: u32 = 1252;
pub const F_INT2ABS: u32 = 1253;
pub const F_TEXTREGEXEQ: u32 = 1254;
pub const F_TEXTREGEXNE: u32 = 1256;
pub const F_TEXTLEN: u32 = 1257;
pub const F_TEXTCAT: u32 = 1258;
pub const F_PG_CHAR_TO_ENCODING: u32 = 1264;
pub const F_TIDNE: u32 = 1265;
pub const F_CIDR_IN: u32 = 1267;
pub const F_PARSE_IDENT: u32 = 1268;
pub const F_PG_COLUMN_SIZE: u32 = 1269;
pub const F_OVERLAPS_TIMETZ_TIMETZ_TIMETZ_TIMETZ: u32 = 1271;
pub const F_DATETIME_PL: u32 = 1272;
pub const F_DATE_PART_TEXT_TIMETZ: u32 = 1273;
pub const F_INT84PL: u32 = 1274;
pub const F_INT84MI: u32 = 1275;
pub const F_INT84MUL: u32 = 1276;
pub const F_INT84DIV: u32 = 1277;
pub const F_INT48PL: u32 = 1278;
pub const F_INT48MI: u32 = 1279;
pub const F_INT48MUL: u32 = 1280;
pub const F_INT48DIV: u32 = 1281;
pub const F_QUOTE_IDENT: u32 = 1282;
pub const F_QUOTE_LITERAL_TEXT: u32 = 1283;
pub const F_DATE_TRUNC_TEXT_TIMESTAMPTZ_TEXT: u32 = 1284;
pub const F_QUOTE_LITERAL_ANYELEMENT: u32 = 1285;
pub const F_ARRAY_FILL_ANYELEMENT__INT4__INT4: u32 = 1286;
pub const F_OID: Oid = Oid(1287);
pub const F_INT8_OID: Oid = Oid(1288);
pub const F_QUOTE_NULLABLE_TEXT: u32 = 1289;
pub const F_QUOTE_NULLABLE_ANYELEMENT: u32 = 1290;
pub const F_SUPPRESS_REDUNDANT_UPDATES_TRIGGER: u32 = 1291;
pub const F_TIDEQ: u32 = 1292;
pub const F_UNNEST_ANYMULTIRANGE: u32 = 1293;
pub const F_CURRTID2: u32 = 1294;
pub const F_JUSTIFY_DAYS: u32 = 1295;
pub const F_TIMEDATE_PL: u32 = 1296;
pub const F_DATETIMETZ_PL: u32 = 1297;
pub const F_TIMETZDATE_PL: u32 = 1298;
pub const F_NOW: u32 = 1299;
pub const F_POSITIONSEL: u32 = 1300;
pub const F_POSITIONJOINSEL: u32 = 1301;
pub const F_CONTSEL: u32 = 1302;
pub const F_CONTJOINSEL: u32 = 1303;
pub const F_OVERLAPS_TIMESTAMPTZ_TIMESTAMPTZ_TIMESTAMPTZ_TIMESTAMPTZ: u32 = 1304;
pub const F_OVERLAPS_TIMESTAMPTZ_INTERVAL_TIMESTAMPTZ_INTERVAL: u32 = 1305;
pub const F_OVERLAPS_TIMESTAMPTZ_TIMESTAMPTZ_TIMESTAMPTZ_INTERVAL: u32 = 1306;
pub const F_OVERLAPS_TIMESTAMPTZ_INTERVAL_TIMESTAMPTZ_TIMESTAMPTZ: u32 = 1307;
pub const F_OVERLAPS_TIME_TIME_TIME_TIME: u32 = 1308;
pub const F_OVERLAPS_TIME_INTERVAL_TIME_INTERVAL: u32 = 1309;
pub const F_OVERLAPS_TIME_TIME_TIME_INTERVAL: u32 = 1310;
pub const F_OVERLAPS_TIME_INTERVAL_TIME_TIME: u32 = 1311;
pub const F_TIMESTAMP_IN: u32 = 1312;
pub const F_TIMESTAMP_OUT: u32 = 1313;
pub const F_TIMESTAMPTZ_CMP: u32 = 1314;
pub const F_INTERVAL_CMP: u32 = 1315;
pub const F_TIME_TIMESTAMP: u32 = 1316;
pub const F_LENGTH_TEXT: u32 = 1317;
pub const F_LENGTH_BPCHAR: u32 = 1318;
pub const F_XIDEQINT4: u32 = 1319;
pub const F_INTERVAL_DIV: u32 = 1326;
pub const F_DLOG10: u32 = 1339;
pub const F_LOG_FLOAT8: u32 = 1340;
pub const F_LN_FLOAT8: u32 = 1341;
pub const F_ROUND_FLOAT8: u32 = 1342;
pub const F_TRUNC_FLOAT8: u32 = 1343;
pub const F_SQRT_FLOAT8: u32 = 1344;
pub const F_CBRT: u32 = 1345;
pub const F_POW_FLOAT8_FLOAT8: u32 = 1346;
pub const F_EXP_FLOAT8: u32 = 1347;
pub const F_OBJ_DESCRIPTION_OID: Oid = Oid(1348);
pub const F_OIDVECTORTYPES: u32 = 1349;
pub const F_TIMETZ_IN: u32 = 1350;
pub const F_TIMETZ_OUT: u32 = 1351;
pub const F_TIMETZ_EQ: u32 = 1352;
pub const F_TIMETZ_NE: u32 = 1353;
pub const F_TIMETZ_LT: u32 = 1354;
pub const F_TIMETZ_LE: u32 = 1355;
pub const F_TIMETZ_GE: u32 = 1356;
pub const F_TIMETZ_GT: u32 = 1357;
pub const F_TIMETZ_CMP: u32 = 1358;
pub const F_TIMESTAMPTZ_DATE_TIMETZ: u32 = 1359;
pub const F_HOSTMASK: u32 = 1362;
pub const F_TEXTREGEXEQ_SUPPORT: u32 = 1364;
pub const F_MAKEACLITEM: u32 = 1365;
pub const F_CHARACTER_LENGTH_BPCHAR: u32 = 1367;
pub const F_POWER_FLOAT8_FLOAT8: u32 = 1368;
pub const F_CHARACTER_LENGTH_TEXT: u32 = 1369;
pub const F_INTERVAL_TIME: u32 = 1370;
pub const F_PG_LOCK_STATUS: u32 = 1371;
pub const F_CHAR_LENGTH_BPCHAR: u32 = 1372;
pub const F_ISFINITE_DATE: u32 = 1373;
pub const F_OCTET_LENGTH_TEXT: u32 = 1374;
pub const F_OCTET_LENGTH_BPCHAR: u32 = 1375;
pub const F_FACTORIAL: u32 = 1376;
pub const F_TIME_LARGER: u32 = 1377;
pub const F_TIME_SMALLER: u32 = 1378;
pub const F_TIMETZ_LARGER: u32 = 1379;
pub const F_TIMETZ_SMALLER: u32 = 1380;
pub const F_CHAR_LENGTH_TEXT: u32 = 1381;
pub const F_DATE_PART_TEXT_DATE: u32 = 1384;
pub const F_DATE_PART_TEXT_TIME: u32 = 1385;
pub const F_AGE_TIMESTAMPTZ: u32 = 1386;
pub const F_PG_GET_CONSTRAINTDEF_OID: Oid = Oid(1387);
pub const F_TIMETZ_TIMESTAMPTZ: u32 = 1388;
pub const F_ISFINITE_TIMESTAMPTZ: u32 = 1389;
pub const F_ISFINITE_INTERVAL: u32 = 1390;
pub const F_PG_STAT_GET_BACKEND_START: u32 = 1391;
pub const F_PG_STAT_GET_BACKEND_CLIENT_ADDR: u32 = 1392;
pub const F_PG_STAT_GET_BACKEND_CLIENT_PORT: u32 = 1393;
pub const F_ABS_FLOAT4: u32 = 1394;
pub const F_ABS_FLOAT8: u32 = 1395;
pub const F_ABS_INT8: u32 = 1396;
pub const F_ABS_INT4: u32 = 1397;
pub const F_ABS_INT2: u32 = 1398;
pub const F_NAME_VARCHAR: u32 = 1400;
pub const F_VARCHAR_NAME: u32 = 1401;
pub const F_CURRENT_SCHEMA: u32 = 1402;
pub const F_CURRENT_SCHEMAS: u32 = 1403;
pub const F_OVERLAY_TEXT_TEXT_INT4_INT4: u32 = 1404;
pub const F_OVERLAY_TEXT_TEXT_INT4: u32 = 1405;
pub const F_ISVERTICAL_POINT_POINT: u32 = 1406;
pub const F_ISHORIZONTAL_POINT_POINT: u32 = 1407;
pub const F_ISPARALLEL_LSEG_LSEG: u32 = 1408;
pub const F_ISPERP_LSEG_LSEG: u32 = 1409;
pub const F_ISVERTICAL_LSEG: u32 = 1410;
pub const F_ISHORIZONTAL_LSEG: u32 = 1411;
pub const F_ISPARALLEL_LINE_LINE: u32 = 1412;
pub const F_ISPERP_LINE_LINE: u32 = 1413;
pub const F_ISVERTICAL_LINE: u32 = 1414;
pub const F_ISHORIZONTAL_LINE: u32 = 1415;
pub const F_POINT_CIRCLE: u32 = 1416;
pub const F_TIME_INTERVAL: u32 = 1419;
pub const F_BOX_POINT_POINT: u32 = 1421;
pub const F_BOX_ADD: u32 = 1422;
pub const F_BOX_SUB: u32 = 1423;
pub const F_BOX_MUL: u32 = 1424;
pub const F_BOX_DIV: u32 = 1425;
pub const F_PATH_CONTAIN_PT: u32 = 1426;
pub const F_CIDR_OUT: u32 = 1427;
pub const F_POLY_CONTAIN_PT: u32 = 1428;
pub const F_PT_CONTAINED_POLY: u32 = 1429;
pub const F_ISCLOSED: u32 = 1430;
pub const F_ISOPEN: u32 = 1431;
pub const F_PATH_NPOINTS: u32 = 1432;
pub const F_PCLOSE: u32 = 1433;
pub const F_POPEN: u32 = 1434;
pub const F_PATH_ADD: u32 = 1435;
pub const F_PATH_ADD_PT: u32 = 1436;
pub const F_PATH_SUB_PT: u32 = 1437;
pub const F_PATH_MUL_PT: u32 = 1438;
pub const F_PATH_DIV_PT: u32 = 1439;
pub const F_POINT_FLOAT8_FLOAT8: u32 = 1440;
pub const F_POINT_ADD: u32 = 1441;
pub const F_POINT_SUB: u32 = 1442;
pub const F_POINT_MUL: u32 = 1443;
pub const F_POINT_DIV: u32 = 1444;
pub const F_POLY_NPOINTS: u32 = 1445;
pub const F_BOX_POLYGON: u32 = 1446;
pub const F_PATH: u32 = 1447;
pub const F_POLYGON_BOX: u32 = 1448;
pub const F_POLYGON_PATH: u32 = 1449;
pub const F_CIRCLE_IN: u32 = 1450;
pub const F_CIRCLE_OUT: u32 = 1451;
pub const F_CIRCLE_SAME: u32 = 1452;
pub const F_CIRCLE_CONTAIN: u32 = 1453;
pub const F_CIRCLE_LEFT: u32 = 1454;
pub const F_CIRCLE_OVERLEFT: u32 = 1455;
pub const F_CIRCLE_OVERRIGHT: u32 = 1456;
pub const F_CIRCLE_RIGHT: u32 = 1457;
pub const F_CIRCLE_CONTAINED: u32 = 1458;
pub const F_CIRCLE_OVERLAP: u32 = 1459;
pub const F_CIRCLE_BELOW: u32 = 1460;
pub const F_CIRCLE_ABOVE: u32 = 1461;
pub const F_CIRCLE_EQ: u32 = 1462;
pub const F_CIRCLE_NE: u32 = 1463;
pub const F_CIRCLE_LT: u32 = 1464;
pub const F_CIRCLE_GT: u32 = 1465;
pub const F_CIRCLE_LE: u32 = 1466;
pub const F_CIRCLE_GE: u32 = 1467;
pub const F_AREA_CIRCLE: u32 = 1468;
pub const F_DIAMETER: u32 = 1469;
pub const F_RADIUS: u32 = 1470;
pub const F_CIRCLE_DISTANCE: u32 = 1471;
pub const F_CIRCLE_CENTER: u32 = 1472;
pub const F_CIRCLE_POINT_FLOAT8: u32 = 1473;
pub const F_CIRCLE_POLYGON: u32 = 1474;
pub const F_POLYGON_INT4_CIRCLE: u32 = 1475;
pub const F_DIST_PC: u32 = 1476;
pub const F_CIRCLE_CONTAIN_PT: u32 = 1477;
pub const F_PT_CONTAINED_CIRCLE: u32 = 1478;
pub const F_CIRCLE_BOX: u32 = 1479;
pub const F_BOX_CIRCLE: u32 = 1480;
pub const F_LOG10_NUMERIC: u32 = 1481;
pub const F_LSEG_NE: u32 = 1482;
pub const F_LSEG_LT: u32 = 1483;
pub const F_LSEG_LE: u32 = 1484;
pub const F_LSEG_GT: u32 = 1485;
pub const F_LSEG_GE: u32 = 1486;
pub const F_LSEG_LENGTH: u32 = 1487;
pub const F_CLOSE_LS: u32 = 1488;
pub const F_CLOSE_LSEG: u32 = 1489;
pub const F_LINE_IN: u32 = 1490;
pub const F_LINE_OUT: u32 = 1491;
pub const F_LINE_EQ: u32 = 1492;
pub const F_LINE: u32 = 1493;
pub const F_LINE_INTERPT: u32 = 1494;
pub const F_LINE_INTERSECT: u32 = 1495;
pub const F_LINE_PARALLEL: u32 = 1496;
pub const F_LINE_PERP: u32 = 1497;
pub const F_LINE_VERTICAL: u32 = 1498;
pub const F_LINE_HORIZONTAL: u32 = 1499;
pub const F_LENGTH_LSEG: u32 = 1530;
pub const F_LENGTH_PATH: u32 = 1531;
pub const F_POINT_LSEG: u32 = 1532;
pub const F_POINT_BOX: u32 = 1534;
pub const F_POINT_POLYGON: u32 = 1540;
pub const F_LSEG_BOX: u32 = 1541;
pub const F_CENTER_BOX: u32 = 1542;
pub const F_CENTER_CIRCLE: u32 = 1543;
pub const F_POLYGON_CIRCLE: u32 = 1544;
pub const F_NPOINTS_PATH: u32 = 1545;
pub const F_NPOINTS_POLYGON: u32 = 1556;
pub const F_BIT_IN: u32 = 1564;
pub const F_BIT_OUT: u32 = 1565;
pub const F_LIKE_TEXT_TEXT: u32 = 1569;
pub const F_NOTLIKE_TEXT_TEXT: u32 = 1570;
pub const F_LIKE_NAME_TEXT: u32 = 1571;
pub const F_NOTLIKE_NAME_TEXT: u32 = 1572;
pub const F_PG_GET_RULEDEF_OID: Oid = Oid(1573);
pub const F_NEXTVAL: u32 = 1574;
pub const F_CURRVAL: u32 = 1575;
pub const F_SETVAL_REGCLASS_INT8: u32 = 1576;
pub const F_VARBIT_IN: u32 = 1579;
pub const F_VARBIT_OUT: u32 = 1580;
pub const F_BITEQ: u32 = 1581;
pub const F_BITNE: u32 = 1582;
pub const F_BITGE: u32 = 1592;
pub const F_BITGT: u32 = 1593;
pub const F_BITLE: u32 = 1594;
pub const F_BITLT: u32 = 1595;
pub const F_BITCMP: u32 = 1596;
pub const F_PG_ENCODING_TO_CHAR: u32 = 1597;
pub const F_RANDOM: u32 = 1598;
pub const F_SETSEED: u32 = 1599;
pub const F_ASIN: u32 = 1600;
pub const F_ACOS: u32 = 1601;
pub const F_ATAN: u32 = 1602;
pub const F_ATAN2: u32 = 1603;
pub const F_SIN: u32 = 1604;
pub const F_COS: u32 = 1605;
pub const F_TAN: u32 = 1606;
pub const F_COT: u32 = 1607;
pub const F_DEGREES: u32 = 1608;
pub const F_RADIANS: u32 = 1609;
pub const F_PI: u32 = 1610;
pub const F_INTERVAL_MUL: u32 = 1618;
pub const F_PG_TYPEOF: u32 = 1619;
pub const F_ASCII: u32 = 1620;
pub const F_CHR: u32 = 1621;
pub const F_REPEAT: u32 = 1622;
pub const F_SIMILAR_ESCAPE: u32 = 1623;
pub const F_MUL_D_INTERVAL: u32 = 1624;
pub const F_BPCHARLIKE: u32 = 1631;
pub const F_BPCHARNLIKE: u32 = 1632;
pub const F_TEXTICLIKE: u32 = 1633;
pub const F_TEXTICNLIKE: u32 = 1634;
pub const F_NAMEICLIKE: u32 = 1635;
pub const F_NAMEICNLIKE: u32 = 1636;
pub const F_LIKE_ESCAPE_TEXT_TEXT: u32 = 1637;
pub const F_OIDGT: u32 = 1638;
pub const F_OIDGE: u32 = 1639;
pub const F_PG_GET_VIEWDEF_TEXT: u32 = 1640;
pub const F_PG_GET_VIEWDEF_OID: Oid = Oid(1641);
pub const F_PG_GET_USERBYID: u32 = 1642;
pub const F_PG_GET_INDEXDEF_OID: Oid = Oid(1643);
pub const F_RI_FKEY_CHECK_INS: u32 = 1644;
pub const F_RI_FKEY_CHECK_UPD: u32 = 1645;
pub const F_RI_FKEY_CASCADE_DEL: u32 = 1646;
pub const F_RI_FKEY_CASCADE_UPD: u32 = 1647;
pub const F_RI_FKEY_RESTRICT_DEL: u32 = 1648;
pub const F_RI_FKEY_RESTRICT_UPD: u32 = 1649;
pub const F_RI_FKEY_SETNULL_DEL: u32 = 1650;
pub const F_RI_FKEY_SETNULL_UPD: u32 = 1651;
pub const F_RI_FKEY_SETDEFAULT_DEL: u32 = 1652;
pub const F_RI_FKEY_SETDEFAULT_UPD: u32 = 1653;
pub const F_RI_FKEY_NOACTION_DEL: u32 = 1654;
pub const F_RI_FKEY_NOACTION_UPD: u32 = 1655;
pub const F_BPCHARICREGEXEQ: u32 = 1656;
pub const F_BPCHARICREGEXNE: u32 = 1657;
pub const F_BPCHARREGEXEQ: u32 = 1658;
pub const F_BPCHARREGEXNE: u32 = 1659;
pub const F_BPCHARICLIKE: u32 = 1660;
pub const F_BPCHARICNLIKE: u32 = 1661;
pub const F_PG_GET_TRIGGERDEF_OID: Oid = Oid(1662);
pub const F_PG_GET_SERIAL_SEQUENCE: u32 = 1665;
pub const F_VARBITEQ: u32 = 1666;
pub const F_VARBITNE: u32 = 1667;
pub const F_VARBITGE: u32 = 1668;
pub const F_VARBITGT: u32 = 1669;
pub const F_VARBITLE: u32 = 1670;
pub const F_VARBITLT: u32 = 1671;
pub const F_VARBITCMP: u32 = 1672;
pub const F_BITAND: u32 = 1673;
pub const F_BITOR: u32 = 1674;
pub const F_BITXOR: u32 = 1675;
pub const F_BITNOT: u32 = 1676;
pub const F_BITSHIFTLEFT: u32 = 1677;
pub const F_BITSHIFTRIGHT: u32 = 1678;
pub const F_BITCAT: u32 = 1679;
pub const F_SUBSTRING_BIT_INT4_INT4: u32 = 1680;
pub const F_LENGTH_BIT: u32 = 1681;
pub const F_OCTET_LENGTH_BIT: u32 = 1682;
pub const F_BIT_INT4_INT4: u32 = 1683;
pub const F_INT4_BIT: u32 = 1684;
pub const F_BIT_BIT_INT4_BOOL: u32 = 1685;
pub const F_PG_GET_KEYWORDS: u32 = 1686;
pub const F_VARBIT: u32 = 1687;
pub const F_TIME_HASH: u32 = 1688;
pub const F_ACLEXPLODE: u32 = 1689;
pub const F_TIME_MI_TIME: u32 = 1690;
pub const F_BOOLLE: u32 = 1691;
pub const F_BOOLGE: u32 = 1692;
pub const F_BTBOOLCMP: u32 = 1693;
pub const F_TIMETZ_HASH: u32 = 1696;
pub const F_INTERVAL_HASH: u32 = 1697;
pub const F_POSITION_BIT_BIT: u32 = 1698;
pub const F_SUBSTRING_BIT_INT4: u32 = 1699;
pub const F_NUMERIC_IN: u32 = 1701;
pub const F_NUMERIC_OUT: u32 = 1702;
pub const F_NUMERIC_NUMERIC_INT4: u32 = 1703;
pub const F_NUMERIC_ABS: u32 = 1704;
pub const F_ABS_NUMERIC: u32 = 1705;
pub const F_SIGN_NUMERIC: u32 = 1706;
pub const F_ROUND_NUMERIC_INT4: u32 = 1707;
pub const F_ROUND_NUMERIC: u32 = 1708;
pub const F_TRUNC_NUMERIC_INT4: u32 = 1709;
pub const F_TRUNC_NUMERIC: u32 = 1710;
pub const F_CEIL_NUMERIC: u32 = 1711;
pub const F_FLOOR_NUMERIC: u32 = 1712;
pub const F_LENGTH_BYTEA_NAME: u32 = 1713;
pub const F_CONVERT_FROM: u32 = 1714;
pub const F_CIDR: u32 = 1715;
pub const F_PG_GET_EXPR_PG_NODE_TREE_OID: Oid = Oid(1716);
pub const F_CONVERT_TO: u32 = 1717;
pub const F_NUMERIC_EQ: u32 = 1718;
pub const F_NUMERIC_NE: u32 = 1719;
pub const F_NUMERIC_GT: u32 = 1720;
pub const F_NUMERIC_GE: u32 = 1721;
pub const F_NUMERIC_LT: u32 = 1722;
pub const F_NUMERIC_LE: u32 = 1723;
pub const F_NUMERIC_ADD: u32 = 1724;
pub const F_NUMERIC_SUB: u32 = 1725;
pub const F_NUMERIC_MUL: u32 = 1726;
pub const F_NUMERIC_DIV: u32 = 1727;
pub const F_MOD_NUMERIC_NUMERIC: u32 = 1728;
pub const F_NUMERIC_MOD: u32 = 1729;
pub const F_SQRT_NUMERIC: u32 = 1730;
pub const F_NUMERIC_SQRT: u32 = 1731;
pub const F_EXP_NUMERIC: u32 = 1732;
pub const F_NUMERIC_EXP: u32 = 1733;
pub const F_LN_NUMERIC: u32 = 1734;
pub const F_NUMERIC_LN: u32 = 1735;
pub const F_LOG_NUMERIC_NUMERIC: u32 = 1736;
pub const F_NUMERIC_LOG: u32 = 1737;
pub const F_POW_NUMERIC_NUMERIC: u32 = 1738;
pub const F_NUMERIC_POWER: u32 = 1739;
pub const F_NUMERIC_INT4: u32 = 1740;
pub const F_LOG_NUMERIC: u32 = 1741;
pub const F_NUMERIC_FLOAT4: u32 = 1742;
pub const F_NUMERIC_FLOAT8: u32 = 1743;
pub const F_INT4_NUMERIC: u32 = 1744;
pub const F_FLOAT4_NUMERIC: u32 = 1745;
pub const F_FLOAT8_NUMERIC: u32 = 1746;
pub const F_TIME_PL_INTERVAL: u32 = 1747;
pub const F_TIME_MI_INTERVAL: u32 = 1748;
pub const F_TIMETZ_PL_INTERVAL: u32 = 1749;
pub const F_TIMETZ_MI_INTERVAL: u32 = 1750;
pub const F_NUMERIC_INC: u32 = 1764;
pub const F_SETVAL_REGCLASS_INT8_BOOL: u32 = 1765;
pub const F_NUMERIC_SMALLER: u32 = 1766;
pub const F_NUMERIC_LARGER: u32 = 1767;
pub const F_TO_CHAR_INTERVAL_TEXT: u32 = 1768;
pub const F_NUMERIC_CMP: u32 = 1769;
pub const F_TO_CHAR_TIMESTAMPTZ_TEXT: u32 = 1770;
pub const F_NUMERIC_UMINUS: u32 = 1771;
pub const F_TO_CHAR_NUMERIC_TEXT: u32 = 1772;
pub const F_TO_CHAR_INT4_TEXT: u32 = 1773;
pub const F_TO_CHAR_INT8_TEXT: u32 = 1774;
pub const F_TO_CHAR_FLOAT4_TEXT: u32 = 1775;
pub const F_TO_CHAR_FLOAT8_TEXT: u32 = 1776;
pub const F_TO_NUMBER: u32 = 1777;
pub const F_TO_TIMESTAMP_TEXT_TEXT: u32 = 1778;
pub const F_INT8_NUMERIC: u32 = 1779;
pub const F_TO_DATE: u32 = 1780;
pub const F_NUMERIC_INT8: u32 = 1781;
pub const F_NUMERIC_INT2: u32 = 1782;
pub const F_INT2_NUMERIC: u32 = 1783;
pub const F_OIDIN: u32 = 1798;
pub const F_OIDOUT: u32 = 1799;
pub const F_BIT_LENGTH_BYTEA: u32 = 1810;
pub const F_BIT_LENGTH_TEXT: u32 = 1811;
pub const F_BIT_LENGTH_BIT: u32 = 1812;
pub const F_CONVERT: u32 = 1813;
pub const F_ICLIKESEL: u32 = 1814;
pub const F_ICNLIKESEL: u32 = 1815;
pub const F_ICLIKEJOINSEL: u32 = 1816;
pub const F_ICNLIKEJOINSEL: u32 = 1817;
pub const F_REGEXEQSEL: u32 = 1818;
pub const F_LIKESEL: u32 = 1819;
pub const F_ICREGEXEQSEL: u32 = 1820;
pub const F_REGEXNESEL: u32 = 1821;
pub const F_NLIKESEL: u32 = 1822;
pub const F_ICREGEXNESEL: u32 = 1823;
pub const F_REGEXEQJOINSEL: u32 = 1824;
pub const F_LIKEJOINSEL: u32 = 1825;
pub const F_ICREGEXEQJOINSEL: u32 = 1826;
pub const F_REGEXNEJOINSEL: u32 = 1827;
pub const F_NLIKEJOINSEL: u32 = 1828;
pub const F_ICREGEXNEJOINSEL: u32 = 1829;
pub const F_FLOAT8_AVG: u32 = 1830;
pub const F_FLOAT8_VAR_SAMP: u32 = 1831;
pub const F_FLOAT8_STDDEV_SAMP: u32 = 1832;
pub const F_NUMERIC_ACCUM: u32 = 1833;
pub const F_INT2_ACCUM: u32 = 1834;
pub const F_INT4_ACCUM: u32 = 1835;
pub const F_INT8_ACCUM: u32 = 1836;
pub const F_NUMERIC_AVG: u32 = 1837;
pub const F_NUMERIC_VAR_SAMP: u32 = 1838;
pub const F_NUMERIC_STDDEV_SAMP: u32 = 1839;
pub const F_INT2_SUM: u32 = 1840;
pub const F_INT4_SUM: u32 = 1841;
pub const F_INT8_SUM: u32 = 1842;
pub const F_INTERVAL_ACCUM: u32 = 1843;
pub const F_INTERVAL_AVG: u32 = 1844;
pub const F_TO_ASCII_TEXT: u32 = 1845;
pub const F_TO_ASCII_TEXT_INT4: u32 = 1846;
pub const F_TO_ASCII_TEXT_NAME: u32 = 1847;
pub const F_INTERVAL_PL_TIME: u32 = 1848;
pub const F_INT28EQ: u32 = 1850;
pub const F_INT28NE: u32 = 1851;
pub const F_INT28LT: u32 = 1852;
pub const F_INT28GT: u32 = 1853;
pub const F_INT28LE: u32 = 1854;
pub const F_INT28GE: u32 = 1855;
pub const F_INT82EQ: u32 = 1856;
pub const F_INT82NE: u32 = 1857;
pub const F_INT82LT: u32 = 1858;
pub const F_INT82GT: u32 = 1859;
pub const F_INT82LE: u32 = 1860;
pub const F_INT82GE: u32 = 1861;
pub const F_INT2AND: u32 = 1892;
pub const F_INT2OR: u32 = 1893;
pub const F_INT2XOR: u32 = 1894;
pub const F_INT2NOT: u32 = 1895;
pub const F_INT2SHL: u32 = 1896;
pub const F_INT2SHR: u32 = 1897;
pub const F_INT4AND: u32 = 1898;
pub const F_INT4OR: u32 = 1899;
pub const F_INT4XOR: u32 = 1900;
pub const F_INT4NOT: u32 = 1901;
pub const F_INT4SHL: u32 = 1902;
pub const F_INT4SHR: u32 = 1903;
pub const F_INT8AND: u32 = 1904;
pub const F_INT8OR: u32 = 1905;
pub const F_INT8XOR: u32 = 1906;
pub const F_INT8NOT: u32 = 1907;
pub const F_INT8SHL: u32 = 1908;
pub const F_INT8SHR: u32 = 1909;
pub const F_INT8UP: u32 = 1910;
pub const F_INT2UP: u32 = 1911;
pub const F_INT4UP: u32 = 1912;
pub const F_FLOAT4UP: u32 = 1913;
pub const F_FLOAT8UP: u32 = 1914;
pub const F_NUMERIC_UPLUS: u32 = 1915;
pub const F_HAS_TABLE_PRIVILEGE_NAME_TEXT_TEXT: u32 = 1922;
pub const F_HAS_TABLE_PRIVILEGE_NAME_OID_TEXT: u32 = 1923;
pub const F_HAS_TABLE_PRIVILEGE_OID_TEXT_TEXT: u32 = 1924;
pub const F_HAS_TABLE_PRIVILEGE_OID_OID_TEXT: u32 = 1925;
pub const F_HAS_TABLE_PRIVILEGE_TEXT_TEXT: u32 = 1926;
pub const F_HAS_TABLE_PRIVILEGE_OID_TEXT: u32 = 1927;
pub const F_PG_STAT_GET_NUMSCANS: u32 = 1928;
pub const F_PG_STAT_GET_TUPLES_RETURNED: u32 = 1929;
pub const F_PG_STAT_GET_TUPLES_FETCHED: u32 = 1930;
pub const F_PG_STAT_GET_TUPLES_INSERTED: u32 = 1931;
pub const F_PG_STAT_GET_TUPLES_UPDATED: u32 = 1932;
pub const F_PG_STAT_GET_TUPLES_DELETED: u32 = 1933;
pub const F_PG_STAT_GET_BLOCKS_FETCHED: u32 = 1934;
pub const F_PG_STAT_GET_BLOCKS_HIT: u32 = 1935;
pub const F_PG_STAT_GET_BACKEND_IDSET: u32 = 1936;
pub const F_PG_STAT_GET_BACKEND_PID: u32 = 1937;
pub const F_PG_STAT_GET_BACKEND_DBID: u32 = 1938;
pub const F_PG_STAT_GET_BACKEND_USERID: u32 = 1939;
pub const F_PG_STAT_GET_BACKEND_ACTIVITY: u32 = 1940;
pub const F_PG_STAT_GET_DB_NUMBACKENDS: u32 = 1941;
pub const F_PG_STAT_GET_DB_XACT_COMMIT: u32 = 1942;
pub const F_PG_STAT_GET_DB_XACT_ROLLBACK: u32 = 1943;
pub const F_PG_STAT_GET_DB_BLOCKS_FETCHED: u32 = 1944;
pub const F_PG_STAT_GET_DB_BLOCKS_HIT: u32 = 1945;
pub const F_ENCODE: u32 = 1946;
pub const F_DECODE: u32 = 1947;
pub const F_BYTEAEQ: u32 = 1948;
pub const F_BYTEALT: u32 = 1949;
pub const F_BYTEALE: u32 = 1950;
pub const F_BYTEAGT: u32 = 1951;
pub const F_BYTEAGE: u32 = 1952;
pub const F_BYTEANE: u32 = 1953;
pub const F_BYTEACMP: u32 = 1954;
pub const F_TIMESTAMP_TIMESTAMP_INT4: u32 = 1961;
pub const F_INT2_AVG_ACCUM: u32 = 1962;
pub const F_INT4_AVG_ACCUM: u32 = 1963;
pub const F_INT8_AVG: u32 = 1964;
pub const F_OIDLARGER: u32 = 1965;
pub const F_OIDSMALLER: u32 = 1966;
pub const F_TIMESTAMPTZ_TIMESTAMPTZ_INT4: u32 = 1967;
pub const F_TIME_TIME_INT4: u32 = 1968;
pub const F_TIMETZ_TIMETZ_INT4: u32 = 1969;
pub const F_PG_STAT_GET_TUPLES_HOT_UPDATED: u32 = 1972;
pub const F_DIV: u32 = 1973;
pub const F_NUMERIC_DIV_TRUNC: u32 = 1980;
pub const F_SIMILAR_TO_ESCAPE_TEXT_TEXT: u32 = 1986;
pub const F_SIMILAR_TO_ESCAPE_TEXT: u32 = 1987;
pub const F_SHOBJ_DESCRIPTION: u32 = 1993;
pub const F_TEXTANYCAT: u32 = 2003;
pub const F_ANYTEXTCAT: u32 = 2004;
pub const F_BYTEALIKE: u32 = 2005;
pub const F_BYTEANLIKE: u32 = 2006;
pub const F_LIKE_BYTEA_BYTEA: u32 = 2007;
pub const F_NOTLIKE_BYTEA_BYTEA: u32 = 2008;
pub const F_LIKE_ESCAPE_BYTEA_BYTEA: u32 = 2009;
pub const F_LENGTH_BYTEA: u32 = 2010;
pub const F_BYTEACAT: u32 = 2011;
pub const F_SUBSTRING_BYTEA_INT4_INT4: u32 = 2012;
pub const F_SUBSTRING_BYTEA_INT4: u32 = 2013;
pub const F_POSITION_BYTEA_BYTEA: u32 = 2014;
pub const F_BTRIM_BYTEA_BYTEA: u32 = 2015;
pub const F_TIME_TIMESTAMPTZ: u32 = 2019;
pub const F_DATE_TRUNC_TEXT_TIMESTAMP: u32 = 2020;
pub const F_DATE_PART_TEXT_TIMESTAMP: u32 = 2021;
pub const F_PG_STAT_GET_ACTIVITY: u32 = 2022;
pub const F_JSONB_PATH_QUERY_FIRST_TZ: u32 = 2023;
pub const F_TIMESTAMP_DATE: u32 = 2024;
pub const F_TIMESTAMP_DATE_TIME: u32 = 2025;
pub const F_PG_BACKEND_PID: u32 = 2026;
pub const F_TIMESTAMP_TIMESTAMPTZ: u32 = 2027;
pub const F_TIMESTAMPTZ_TIMESTAMP: u32 = 2028;
pub const F_DATE_TIMESTAMP: u32 = 2029;
pub const F_JSONB_PATH_MATCH_TZ: u32 = 2030;
pub const F_TIMESTAMP_MI: u32 = 2031;
pub const F_TIMESTAMP_PL_INTERVAL: u32 = 2032;
pub const F_TIMESTAMP_MI_INTERVAL: u32 = 2033;
pub const F_PG_CONF_LOAD_TIME: u32 = 2034;
pub const F_TIMESTAMP_SMALLER: u32 = 2035;
pub const F_TIMESTAMP_LARGER: u32 = 2036;
pub const F_TIMEZONE_TEXT_TIMETZ: u32 = 2037;
pub const F_TIMEZONE_INTERVAL_TIMETZ: u32 = 2038;
pub const F_TIMESTAMP_HASH: u32 = 2039;
pub const F_OVERLAPS_TIMESTAMP_TIMESTAMP_TIMESTAMP_TIMESTAMP: u32 = 2041;
pub const F_OVERLAPS_TIMESTAMP_INTERVAL_TIMESTAMP_INTERVAL: u32 = 2042;
pub const F_OVERLAPS_TIMESTAMP_TIMESTAMP_TIMESTAMP_INTERVAL: u32 = 2043;
pub const F_OVERLAPS_TIMESTAMP_INTERVAL_TIMESTAMP_TIMESTAMP: u32 = 2044;
pub const F_TIMESTAMP_CMP: u32 = 2045;
pub const F_TIME_TIMETZ: u32 = 2046;
pub const F_TIMETZ_TIME: u32 = 2047;
pub const F_ISFINITE_TIMESTAMP: u32 = 2048;
pub const F_TO_CHAR_TIMESTAMP_TEXT: u32 = 2049;
pub const F_MAX_ANYARRAY: u32 = 2050;
pub const F_MIN_ANYARRAY: u32 = 2051;
pub const F_TIMESTAMP_EQ: u32 = 2052;
pub const F_TIMESTAMP_NE: u32 = 2053;
pub const F_TIMESTAMP_LT: u32 = 2054;
pub const F_TIMESTAMP_LE: u32 = 2055;
pub const F_TIMESTAMP_GE: u32 = 2056;
pub const F_TIMESTAMP_GT: u32 = 2057;
pub const F_AGE_TIMESTAMP_TIMESTAMP: u32 = 2058;
pub const F_AGE_TIMESTAMP: u32 = 2059;
pub const F_TIMEZONE_TEXT_TIMESTAMP: u32 = 2069;
pub const F_TIMEZONE_INTERVAL_TIMESTAMP: u32 = 2070;
pub const F_DATE_PL_INTERVAL: u32 = 2071;
pub const F_DATE_MI_INTERVAL: u32 = 2072;
pub const F_SUBSTRING_TEXT_TEXT: u32 = 2073;
pub const F_SUBSTRING_TEXT_TEXT_TEXT: u32 = 2074;
pub const F_BIT_INT8_INT4: u32 = 2075;
pub const F_INT8_BIT: u32 = 2076;
pub const F_CURRENT_SETTING_TEXT: u32 = 2077;
pub const F_SET_CONFIG: u32 = 2078;
pub const F_PG_TABLE_IS_VISIBLE: u32 = 2079;
pub const F_PG_TYPE_IS_VISIBLE: u32 = 2080;
pub const F_PG_FUNCTION_IS_VISIBLE: u32 = 2081;
pub const F_PG_OPERATOR_IS_VISIBLE: u32 = 2082;
pub const F_PG_OPCLASS_IS_VISIBLE: u32 = 2083;
pub const F_PG_SHOW_ALL_SETTINGS: u32 = 2084;
pub const F_SUBSTR_BYTEA_INT4_INT4: u32 = 2085;
pub const F_SUBSTR_BYTEA_INT4: u32 = 2086;
pub const F_REPLACE: u32 = 2087;
pub const F_SPLIT_PART: u32 = 2088;
pub const F_TO_HEX_INT4: u32 = 2089;
pub const F_TO_HEX_INT8: u32 = 2090;
pub const F_ARRAY_LOWER: u32 = 2091;
pub const F_ARRAY_UPPER: u32 = 2092;
pub const F_PG_CONVERSION_IS_VISIBLE: u32 = 2093;
pub const F_PG_STAT_GET_BACKEND_ACTIVITY_START: u32 = 2094;
pub const F_PG_TERMINATE_BACKEND: u32 = 2096;
pub const F_PG_GET_FUNCTIONDEF: u32 = 2098;
pub const F_AVG_INT8: u32 = 2100;
pub const F_AVG_INT4: u32 = 2101;
pub const F_AVG_INT2: u32 = 2102;
pub const F_AVG_NUMERIC: u32 = 2103;
pub const F_AVG_FLOAT4: u32 = 2104;
pub const F_AVG_FLOAT8: u32 = 2105;
pub const F_AVG_INTERVAL: u32 = 2106;
pub const F_SUM_INT8: u32 = 2107;
pub const F_SUM_INT4: u32 = 2108;
pub const F_SUM_INT2: u32 = 2109;
pub const F_SUM_FLOAT4: u32 = 2110;
pub const F_SUM_FLOAT8: u32 = 2111;
pub const F_SUM_MONEY: u32 = 2112;
pub const F_SUM_INTERVAL: u32 = 2113;
pub const F_SUM_NUMERIC: u32 = 2114;
pub const F_MAX_INT8: u32 = 2115;
pub const F_MAX_INT4: u32 = 2116;
pub const F_MAX_INT2: u32 = 2117;
pub const F_MAX_OID: Oid = Oid(2118);
pub const F_MAX_FLOAT4: u32 = 2119;
pub const F_MAX_FLOAT8: u32 = 2120;
pub const F_PG_COLUMN_COMPRESSION: u32 = 2121;
pub const F_MAX_DATE: u32 = 2122;
pub const F_MAX_TIME: u32 = 2123;
pub const F_MAX_TIMETZ: u32 = 2124;
pub const F_MAX_MONEY: u32 = 2125;
pub const F_MAX_TIMESTAMP: u32 = 2126;
pub const F_MAX_TIMESTAMPTZ: u32 = 2127;
pub const F_MAX_INTERVAL: u32 = 2128;
pub const F_MAX_TEXT: u32 = 2129;
pub const F_MAX_NUMERIC: u32 = 2130;
pub const F_MIN_INT8: u32 = 2131;
pub const F_MIN_INT4: u32 = 2132;
pub const F_MIN_INT2: u32 = 2133;
pub const F_MIN_OID: Oid = Oid(2134);
pub const F_MIN_FLOAT4: u32 = 2135;
pub const F_MIN_FLOAT8: u32 = 2136;
pub const F_PG_STAT_FORCE_NEXT_FLUSH: u32 = 2137;
pub const F_MIN_DATE: u32 = 2138;
pub const F_MIN_TIME: u32 = 2139;
pub const F_MIN_TIMETZ: u32 = 2140;
pub const F_MIN_MONEY: u32 = 2141;
pub const F_MIN_TIMESTAMP: u32 = 2142;
pub const F_MIN_TIMESTAMPTZ: u32 = 2143;
pub const F_MIN_INTERVAL: u32 = 2144;
pub const F_MIN_TEXT: u32 = 2145;
pub const F_MIN_NUMERIC: u32 = 2146;
pub const F_COUNT_ANY: u32 = 2147;
pub const F_VARIANCE_INT8: u32 = 2148;
pub const F_VARIANCE_INT4: u32 = 2149;
pub const F_VARIANCE_INT2: u32 = 2150;
pub const F_VARIANCE_FLOAT4: u32 = 2151;
pub const F_VARIANCE_FLOAT8: u32 = 2152;
pub const F_VARIANCE_NUMERIC: u32 = 2153;
pub const F_STDDEV_INT8: u32 = 2154;
pub const F_STDDEV_INT4: u32 = 2155;
pub const F_STDDEV_INT2: u32 = 2156;
pub const F_STDDEV_FLOAT4: u32 = 2157;
pub const F_STDDEV_FLOAT8: u32 = 2158;
pub const F_STDDEV_NUMERIC: u32 = 2159;
pub const F_TEXT_PATTERN_LT: u32 = 2160;
pub const F_TEXT_PATTERN_LE: u32 = 2161;
pub const F_PG_GET_FUNCTION_ARGUMENTS: u32 = 2162;
pub const F_TEXT_PATTERN_GE: u32 = 2163;
pub const F_TEXT_PATTERN_GT: u32 = 2164;
pub const F_PG_GET_FUNCTION_RESULT: u32 = 2165;
pub const F_BTTEXT_PATTERN_CMP: u32 = 2166;
pub const F_CEILING_NUMERIC: u32 = 2167;
pub const F_PG_DATABASE_SIZE_NAME: u32 = 2168;
pub const F_POWER_NUMERIC_NUMERIC: u32 = 2169;
pub const F_WIDTH_BUCKET_NUMERIC_NUMERIC_NUMERIC_INT4: u32 = 2170;
pub const F_PG_CANCEL_BACKEND: u32 = 2171;
pub const F_PG_BACKUP_START: u32 = 2172;
pub const F_BPCHAR_PATTERN_LT: u32 = 2174;
pub const F_BPCHAR_PATTERN_LE: u32 = 2175;
pub const F_ARRAY_LENGTH: u32 = 2176;
pub const F_BPCHAR_PATTERN_GE: u32 = 2177;
pub const F_BPCHAR_PATTERN_GT: u32 = 2178;
pub const F_GIST_POINT_CONSISTENT: u32 = 2179;
pub const F_BTBPCHAR_PATTERN_CMP: u32 = 2180;
pub const F_HAS_SEQUENCE_PRIVILEGE_NAME_TEXT_TEXT: u32 = 2181;
pub const F_HAS_SEQUENCE_PRIVILEGE_NAME_OID_TEXT: u32 = 2182;
pub const F_HAS_SEQUENCE_PRIVILEGE_OID_TEXT_TEXT: u32 = 2183;
pub const F_HAS_SEQUENCE_PRIVILEGE_OID_OID_TEXT: u32 = 2184;
pub const F_HAS_SEQUENCE_PRIVILEGE_TEXT_TEXT: u32 = 2185;
pub const F_HAS_SEQUENCE_PRIVILEGE_OID_TEXT: u32 = 2186;
pub const F_BTINT48CMP: u32 = 2188;
pub const F_BTINT84CMP: u32 = 2189;
pub const F_BTINT24CMP: u32 = 2190;
pub const F_BTINT42CMP: u32 = 2191;
pub const F_BTINT28CMP: u32 = 2192;
pub const F_BTINT82CMP: u32 = 2193;
pub const F_BTFLOAT48CMP: u32 = 2194;
pub const F_BTFLOAT84CMP: u32 = 2195;
pub const F_INET_CLIENT_ADDR: u32 = 2196;
pub const F_INET_CLIENT_PORT: u32 = 2197;
pub const F_INET_SERVER_ADDR: u32 = 2198;
pub const F_INET_SERVER_PORT: u32 = 2199;
pub const F_REGPROCEDUREIN: u32 = 2212;
pub const F_REGPROCEDUREOUT: u32 = 2213;
pub const F_REGOPERIN: u32 = 2214;
pub const F_REGOPEROUT: u32 = 2215;
pub const F_REGOPERATORIN: u32 = 2216;
pub const F_REGOPERATOROUT: u32 = 2217;
pub const F_REGCLASSIN: u32 = 2218;
pub const F_REGCLASSOUT: u32 = 2219;
pub const F_REGTYPEIN: u32 = 2220;
pub const F_REGTYPEOUT: u32 = 2221;
pub const F_PG_STAT_CLEAR_SNAPSHOT: u32 = 2230;
pub const F_PG_GET_FUNCTION_IDENTITY_ARGUMENTS: u32 = 2232;
pub const F_HASHTID: u32 = 2233;
pub const F_HASHTIDEXTENDED: u32 = 2234;
pub const F_BIT_AND_INT2: u32 = 2236;
pub const F_BIT_OR_INT2: u32 = 2237;
pub const F_BIT_AND_INT4: u32 = 2238;
pub const F_BIT_OR_INT4: u32 = 2239;
pub const F_BIT_AND_INT8: u32 = 2240;
pub const F_BIT_OR_INT8: u32 = 2241;
pub const F_BIT_AND_BIT: u32 = 2242;
pub const F_BIT_OR_BIT: u32 = 2243;
pub const F_MAX_BPCHAR: u32 = 2244;
pub const F_MIN_BPCHAR: u32 = 2245;
pub const F_FMGR_INTERNAL_VALIDATOR: u32 = 2246;
pub const F_FMGR_C_VALIDATOR: u32 = 2247;
pub const F_FMGR_SQL_VALIDATOR: u32 = 2248;
pub const F_HAS_DATABASE_PRIVILEGE_NAME_TEXT_TEXT: u32 = 2250;
pub const F_HAS_DATABASE_PRIVILEGE_NAME_OID_TEXT: u32 = 2251;
pub const F_HAS_DATABASE_PRIVILEGE_OID_TEXT_TEXT: u32 = 2252;
pub const F_HAS_DATABASE_PRIVILEGE_OID_OID_TEXT: u32 = 2253;
pub const F_HAS_DATABASE_PRIVILEGE_TEXT_TEXT: u32 = 2254;
pub const F_HAS_DATABASE_PRIVILEGE_OID_TEXT: u32 = 2255;
pub const F_HAS_FUNCTION_PRIVILEGE_NAME_TEXT_TEXT: u32 = 2256;
pub const F_HAS_FUNCTION_PRIVILEGE_NAME_OID_TEXT: u32 = 2257;
pub const F_HAS_FUNCTION_PRIVILEGE_OID_TEXT_TEXT: u32 = 2258;
pub const F_HAS_FUNCTION_PRIVILEGE_OID_OID_TEXT: u32 = 2259;
pub const F_HAS_FUNCTION_PRIVILEGE_TEXT_TEXT: u32 = 2260;
pub const F_HAS_FUNCTION_PRIVILEGE_OID_TEXT: u32 = 2261;
pub const F_HAS_LANGUAGE_PRIVILEGE_NAME_TEXT_TEXT: u32 = 2262;
pub const F_HAS_LANGUAGE_PRIVILEGE_NAME_OID_TEXT: u32 = 2263;
pub const F_HAS_LANGUAGE_PRIVILEGE_OID_TEXT_TEXT: u32 = 2264;
pub const F_HAS_LANGUAGE_PRIVILEGE_OID_OID_TEXT: u32 = 2265;
pub const F_HAS_LANGUAGE_PRIVILEGE_TEXT_TEXT: u32 = 2266;
pub const F_HAS_LANGUAGE_PRIVILEGE_OID_TEXT: u32 = 2267;
pub const F_HAS_SCHEMA_PRIVILEGE_NAME_TEXT_TEXT: u32 = 2268;
pub const F_HAS_SCHEMA_PRIVILEGE_NAME_OID_TEXT: u32 = 2269;
pub const F_HAS_SCHEMA_PRIVILEGE_OID_TEXT_TEXT: u32 = 2270;
pub const F_HAS_SCHEMA_PRIVILEGE_OID_OID_TEXT: u32 = 2271;
pub const F_HAS_SCHEMA_PRIVILEGE_TEXT_TEXT: u32 = 2272;
pub const F_HAS_SCHEMA_PRIVILEGE_OID_TEXT: u32 = 2273;
pub const F_PG_STAT_RESET: u32 = 2274;
pub const F_PG_GET_BACKEND_MEMORY_CONTEXTS: u32 = 2282;
pub const F_REGEXP_REPLACE_TEXT_TEXT_TEXT: u32 = 2284;
pub const F_REGEXP_REPLACE_TEXT_TEXT_TEXT_TEXT: u32 = 2285;
pub const F_PG_TOTAL_RELATION_SIZE: u32 = 2286;
pub const F_PG_SIZE_PRETTY_INT8: u32 = 2288;
pub const F_PG_OPTIONS_TO_TABLE: u32 = 2289;
pub const F_RECORD_IN: u32 = 2290;
pub const F_RECORD_OUT: u32 = 2291;
pub const F_CSTRING_IN: u32 = 2292;
pub const F_CSTRING_OUT: u32 = 2293;
pub const F_ANY_IN: u32 = 2294;
pub const F_ANY_OUT: u32 = 2295;
pub const F_ANYARRAY_IN: u32 = 2296;
pub const F_ANYARRAY_OUT: u32 = 2297;
pub const F_VOID_IN: u32 = 2298;
pub const F_VOID_OUT: u32 = 2299;
pub const F_TRIGGER_IN: u32 = 2300;
pub const F_TRIGGER_OUT: u32 = 2301;
pub const F_LANGUAGE_HANDLER_IN: u32 = 2302;
pub const F_LANGUAGE_HANDLER_OUT: u32 = 2303;
pub const F_INTERNAL_IN: u32 = 2304;
pub const F_INTERNAL_OUT: u32 = 2305;
pub const F_PG_STAT_GET_SLRU: u32 = 2306;
pub const F_PG_STAT_RESET_SLRU: u32 = 2307;
pub const F_CEIL_FLOAT8: u32 = 2308;
pub const F_FLOOR_FLOAT8: u32 = 2309;
pub const F_SIGN_FLOAT8: u32 = 2310;
pub const F_MD5_TEXT: u32 = 2311;
pub const F_ANYELEMENT_IN: u32 = 2312;
pub const F_ANYELEMENT_OUT: u32 = 2313;
pub const F_POSTGRESQL_FDW_VALIDATOR: u32 = 2316;
pub const F_PG_ENCODING_MAX_LENGTH: u32 = 2319;
pub const F_CEILING_FLOAT8: u32 = 2320;
pub const F_MD5_BYTEA: u32 = 2321;
pub const F_PG_TABLESPACE_SIZE_OID: Oid = Oid(2322);
pub const F_PG_TABLESPACE_SIZE_NAME: u32 = 2323;
pub const F_PG_DATABASE_SIZE_OID: Oid = Oid(2324);
pub const F_PG_RELATION_SIZE_REGCLASS: u32 = 2325;
pub const F_UNNEST_ANYARRAY: u32 = 2331;
pub const F_PG_RELATION_SIZE_REGCLASS_TEXT: u32 = 2332;
pub const F_ARRAY_AGG_TRANSFN: u32 = 2333;
pub const F_ARRAY_AGG_FINALFN: u32 = 2334;
pub const F_ARRAY_AGG_ANYNONARRAY: u32 = 2335;
pub const F_DATE_LT_TIMESTAMP: u32 = 2338;
pub const F_DATE_LE_TIMESTAMP: u32 = 2339;
pub const F_DATE_EQ_TIMESTAMP: u32 = 2340;
pub const F_DATE_GT_TIMESTAMP: u32 = 2341;
pub const F_DATE_GE_TIMESTAMP: u32 = 2342;
pub const F_DATE_NE_TIMESTAMP: u32 = 2343;
pub const F_DATE_CMP_TIMESTAMP: u32 = 2344;
pub const F_DATE_LT_TIMESTAMPTZ: u32 = 2351;
pub const F_DATE_LE_TIMESTAMPTZ: u32 = 2352;
pub const F_DATE_EQ_TIMESTAMPTZ: u32 = 2353;
pub const F_DATE_GT_TIMESTAMPTZ: u32 = 2354;
pub const F_DATE_GE_TIMESTAMPTZ: u32 = 2355;
pub const F_DATE_NE_TIMESTAMPTZ: u32 = 2356;
pub const F_DATE_CMP_TIMESTAMPTZ: u32 = 2357;
pub const F_TIMESTAMP_LT_DATE: u32 = 2364;
pub const F_TIMESTAMP_LE_DATE: u32 = 2365;
pub const F_TIMESTAMP_EQ_DATE: u32 = 2366;
pub const F_TIMESTAMP_GT_DATE: u32 = 2367;
pub const F_TIMESTAMP_GE_DATE: u32 = 2368;
pub const F_TIMESTAMP_NE_DATE: u32 = 2369;
pub const F_TIMESTAMP_CMP_DATE: u32 = 2370;
pub const F_TIMESTAMPTZ_LT_DATE: u32 = 2377;
pub const F_TIMESTAMPTZ_LE_DATE: u32 = 2378;
pub const F_TIMESTAMPTZ_EQ_DATE: u32 = 2379;
pub const F_TIMESTAMPTZ_GT_DATE: u32 = 2380;
pub const F_TIMESTAMPTZ_GE_DATE: u32 = 2381;
pub const F_TIMESTAMPTZ_NE_DATE: u32 = 2382;
pub const F_TIMESTAMPTZ_CMP_DATE: u32 = 2383;
pub const F_HAS_TABLESPACE_PRIVILEGE_NAME_TEXT_TEXT: u32 = 2390;
pub const F_HAS_TABLESPACE_PRIVILEGE_NAME_OID_TEXT: u32 = 2391;
pub const F_HAS_TABLESPACE_PRIVILEGE_OID_TEXT_TEXT: u32 = 2392;
pub const F_HAS_TABLESPACE_PRIVILEGE_OID_OID_TEXT: u32 = 2393;
pub const F_HAS_TABLESPACE_PRIVILEGE_TEXT_TEXT: u32 = 2394;
pub const F_HAS_TABLESPACE_PRIVILEGE_OID_TEXT: u32 = 2395;
pub const F_SHELL_IN: u32 = 2398;
pub const F_SHELL_OUT: u32 = 2399;
pub const F_ARRAY_RECV: u32 = 2400;
pub const F_ARRAY_SEND: u32 = 2401;
pub const F_RECORD_RECV: u32 = 2402;
pub const F_RECORD_SEND: u32 = 2403;
pub const F_INT2RECV: u32 = 2404;
pub const F_INT2SEND: u32 = 2405;
pub const F_INT4RECV: u32 = 2406;
pub const F_INT4SEND: u32 = 2407;
pub const F_INT8RECV: u32 = 2408;
pub const F_INT8SEND: u32 = 2409;
pub const F_INT2VECTORRECV: u32 = 2410;
pub const F_INT2VECTORSEND: u32 = 2411;
pub const F_BYTEARECV: u32 = 2412;
pub const F_BYTEASEND: u32 = 2413;
pub const F_TEXTRECV: u32 = 2414;
pub const F_TEXTSEND: u32 = 2415;
pub const F_UNKNOWNRECV: u32 = 2416;
pub const F_UNKNOWNSEND: u32 = 2417;
pub const F_OIDRECV: u32 = 2418;
pub const F_OIDSEND: u32 = 2419;
pub const F_OIDVECTORRECV: u32 = 2420;
pub const F_OIDVECTORSEND: u32 = 2421;
pub const F_NAMERECV: u32 = 2422;
pub const F_NAMESEND: u32 = 2423;
pub const F_FLOAT4RECV: u32 = 2424;
pub const F_FLOAT4SEND: u32 = 2425;
pub const F_FLOAT8RECV: u32 = 2426;
pub const F_FLOAT8SEND: u32 = 2427;
pub const F_POINT_RECV: u32 = 2428;
pub const F_POINT_SEND: u32 = 2429;
pub const F_BPCHARRECV: u32 = 2430;
pub const F_BPCHARSEND: u32 = 2431;
pub const F_VARCHARRECV: u32 = 2432;
pub const F_VARCHARSEND: u32 = 2433;
pub const F_CHARRECV: u32 = 2434;
pub const F_CHARSEND: u32 = 2435;
pub const F_BOOLRECV: u32 = 2436;
pub const F_BOOLSEND: u32 = 2437;
pub const F_TIDRECV: u32 = 2438;
pub const F_TIDSEND: u32 = 2439;
pub const F_XIDRECV: u32 = 2440;
pub const F_XIDSEND: u32 = 2441;
pub const F_CIDRECV: u32 = 2442;
pub const F_CIDSEND: u32 = 2443;
pub const F_REGPROCRECV: u32 = 2444;
pub const F_REGPROCSEND: u32 = 2445;
pub const F_REGPROCEDURERECV: u32 = 2446;
pub const F_REGPROCEDURESEND: u32 = 2447;
pub const F_REGOPERRECV: u32 = 2448;
pub const F_REGOPERSEND: u32 = 2449;
pub const F_REGOPERATORRECV: u32 = 2450;
pub const F_REGOPERATORSEND: u32 = 2451;
pub const F_REGCLASSRECV: u32 = 2452;
pub const F_REGCLASSSEND: u32 = 2453;
pub const F_REGTYPERECV: u32 = 2454;
pub const F_REGTYPESEND: u32 = 2455;
pub const F_BIT_RECV: u32 = 2456;
pub const F_BIT_SEND: u32 = 2457;
pub const F_VARBIT_RECV: u32 = 2458;
pub const F_VARBIT_SEND: u32 = 2459;
pub const F_NUMERIC_RECV: u32 = 2460;
pub const F_NUMERIC_SEND: u32 = 2461;
pub const F_SINH: u32 = 2462;
pub const F_COSH: u32 = 2463;
pub const F_TANH: u32 = 2464;
pub const F_ASINH: u32 = 2465;
pub const F_ACOSH: u32 = 2466;
pub const F_ATANH: u32 = 2467;
pub const F_DATE_RECV: u32 = 2468;
pub const F_DATE_SEND: u32 = 2469;
pub const F_TIME_RECV: u32 = 2470;
pub const F_TIME_SEND: u32 = 2471;
pub const F_TIMETZ_RECV: u32 = 2472;
pub const F_TIMETZ_SEND: u32 = 2473;
pub const F_TIMESTAMP_RECV: u32 = 2474;
pub const F_TIMESTAMP_SEND: u32 = 2475;
pub const F_TIMESTAMPTZ_RECV: u32 = 2476;
pub const F_TIMESTAMPTZ_SEND: u32 = 2477;
pub const F_INTERVAL_RECV: u32 = 2478;
pub const F_INTERVAL_SEND: u32 = 2479;
pub const F_LSEG_RECV: u32 = 2480;
pub const F_LSEG_SEND: u32 = 2481;
pub const F_PATH_RECV: u32 = 2482;
pub const F_PATH_SEND: u32 = 2483;
pub const F_BOX_RECV: u32 = 2484;
pub const F_BOX_SEND: u32 = 2485;
pub const F_POLY_RECV: u32 = 2486;
pub const F_POLY_SEND: u32 = 2487;
pub const F_LINE_RECV: u32 = 2488;
pub const F_LINE_SEND: u32 = 2489;
pub const F_CIRCLE_RECV: u32 = 2490;
pub const F_CIRCLE_SEND: u32 = 2491;
pub const F_CASH_RECV: u32 = 2492;
pub const F_CASH_SEND: u32 = 2493;
pub const F_MACADDR_RECV: u32 = 2494;
pub const F_MACADDR_SEND: u32 = 2495;
pub const F_INET_RECV: u32 = 2496;
pub const F_INET_SEND: u32 = 2497;
pub const F_CIDR_RECV: u32 = 2498;
pub const F_CIDR_SEND: u32 = 2499;
pub const F_CSTRING_RECV: u32 = 2500;
pub const F_CSTRING_SEND: u32 = 2501;
pub const F_ANYARRAY_RECV: u32 = 2502;
pub const F_ANYARRAY_SEND: u32 = 2503;
pub const F_PG_GET_RULEDEF_OID_BOOL: u32 = 2504;
pub const F_PG_GET_VIEWDEF_TEXT_BOOL: u32 = 2505;
pub const F_PG_GET_VIEWDEF_OID_BOOL: u32 = 2506;
pub const F_PG_GET_INDEXDEF_OID_INT4_BOOL: u32 = 2507;
pub const F_PG_GET_CONSTRAINTDEF_OID_BOOL: u32 = 2508;
pub const F_PG_GET_EXPR_PG_NODE_TREE_OID_BOOL: u32 = 2509;
pub const F_PG_PREPARED_STATEMENT: u32 = 2510;
pub const F_PG_CURSOR: u32 = 2511;
pub const F_FLOAT8_VAR_POP: u32 = 2512;
pub const F_FLOAT8_STDDEV_POP: u32 = 2513;
pub const F_NUMERIC_VAR_POP: u32 = 2514;
pub const F_BOOLAND_STATEFUNC: u32 = 2515;
pub const F_BOOLOR_STATEFUNC: u32 = 2516;
pub const F_BOOL_AND: u32 = 2517;
pub const F_BOOL_OR: u32 = 2518;
pub const F_EVERY: u32 = 2519;
pub const F_TIMESTAMP_LT_TIMESTAMPTZ: u32 = 2520;
pub const F_TIMESTAMP_LE_TIMESTAMPTZ: u32 = 2521;
pub const F_TIMESTAMP_EQ_TIMESTAMPTZ: u32 = 2522;
pub const F_TIMESTAMP_GT_TIMESTAMPTZ: u32 = 2523;
pub const F_TIMESTAMP_GE_TIMESTAMPTZ: u32 = 2524;
pub const F_TIMESTAMP_NE_TIMESTAMPTZ: u32 = 2525;
pub const F_TIMESTAMP_CMP_TIMESTAMPTZ: u32 = 2526;
pub const F_TIMESTAMPTZ_LT_TIMESTAMP: u32 = 2527;
pub const F_TIMESTAMPTZ_LE_TIMESTAMP: u32 = 2528;
pub const F_TIMESTAMPTZ_EQ_TIMESTAMP: u32 = 2529;
pub const F_TIMESTAMPTZ_GT_TIMESTAMP: u32 = 2530;
pub const F_TIMESTAMPTZ_GE_TIMESTAMP: u32 = 2531;
pub const F_TIMESTAMPTZ_NE_TIMESTAMP: u32 = 2532;
pub const F_TIMESTAMPTZ_CMP_TIMESTAMP: u32 = 2533;
pub const F_INTERVAL_PL_DATE: u32 = 2546;
pub const F_INTERVAL_PL_TIMETZ: u32 = 2547;
pub const F_INTERVAL_PL_TIMESTAMP: u32 = 2548;
pub const F_INTERVAL_PL_TIMESTAMPTZ: u32 = 2549;
pub const F_INTEGER_PL_DATE: u32 = 2550;
pub const F_PG_TABLESPACE_DATABASES: u32 = 2556;
pub const F_BOOL_INT4: u32 = 2557;
pub const F_INT4_BOOL: u32 = 2558;
pub const F_LASTVAL: u32 = 2559;
pub const F_PG_POSTMASTER_START_TIME: u32 = 2560;
pub const F_PG_BLOCKING_PIDS: u32 = 2561;
pub const F_BOX_BELOW: u32 = 2562;
pub const F_BOX_OVERBELOW: u32 = 2563;
pub const F_BOX_OVERABOVE: u32 = 2564;
pub const F_BOX_ABOVE: u32 = 2565;
pub const F_POLY_BELOW: u32 = 2566;
pub const F_POLY_OVERBELOW: u32 = 2567;
pub const F_POLY_OVERABOVE: u32 = 2568;
pub const F_POLY_ABOVE: u32 = 2569;
pub const F_GIST_BOX_CONSISTENT: u32 = 2578;
pub const F_FLOAT8_JSONB: u32 = 2580;
pub const F_GIST_BOX_PENALTY: u32 = 2581;
pub const F_GIST_BOX_PICKSPLIT: u32 = 2582;
pub const F_GIST_BOX_UNION: u32 = 2583;
pub const F_GIST_BOX_SAME: u32 = 2584;
pub const F_GIST_POLY_CONSISTENT: u32 = 2585;
pub const F_GIST_POLY_COMPRESS: u32 = 2586;
pub const F_CIRCLE_OVERBELOW: u32 = 2587;
pub const F_CIRCLE_OVERABOVE: u32 = 2588;
pub const F_GIST_CIRCLE_CONSISTENT: u32 = 2591;
pub const F_GIST_CIRCLE_COMPRESS: u32 = 2592;
pub const F_NUMERIC_STDDEV_POP: u32 = 2596;
pub const F_DOMAIN_IN: u32 = 2597;
pub const F_DOMAIN_RECV: u32 = 2598;
pub const F_PG_TIMEZONE_ABBREVS: u32 = 2599;
pub const F_XMLEXISTS: u32 = 2614;
pub const F_PG_RELOAD_CONF: u32 = 2621;
pub const F_PG_ROTATE_LOGFILE: u32 = 2622;
pub const F_PG_STAT_FILE_TEXT: u32 = 2623;
pub const F_PG_READ_FILE_TEXT_INT8_INT8: u32 = 2624;
pub const F_PG_LS_DIR_TEXT: u32 = 2625;
pub const F_PG_SLEEP: u32 = 2626;
pub const F_INETNOT: u32 = 2627;
pub const F_INETAND: u32 = 2628;
pub const F_INETOR: u32 = 2629;
pub const F_INETPL: u32 = 2630;
pub const F_INT8PL_INET: u32 = 2631;
pub const F_INETMI_INT8: u32 = 2632;
pub const F_INETMI: u32 = 2633;
pub const F_VAR_SAMP_INT8: u32 = 2641;
pub const F_VAR_SAMP_INT4: u32 = 2642;
pub const F_VAR_SAMP_INT2: u32 = 2643;
pub const F_VAR_SAMP_FLOAT4: u32 = 2644;
pub const F_VAR_SAMP_FLOAT8: u32 = 2645;
pub const F_VAR_SAMP_NUMERIC: u32 = 2646;
pub const F_TRANSACTION_TIMESTAMP: u32 = 2647;
pub const F_STATEMENT_TIMESTAMP: u32 = 2648;
pub const F_CLOCK_TIMESTAMP: u32 = 2649;
pub const F_GIN_CMP_PREFIX: u32 = 2700;
pub const F_PG_HAS_ROLE_NAME_NAME_TEXT: u32 = 2705;
pub const F_PG_HAS_ROLE_NAME_OID_TEXT: u32 = 2706;
pub const F_PG_HAS_ROLE_OID_NAME_TEXT: u32 = 2707;
pub const F_PG_HAS_ROLE_OID_OID_TEXT: u32 = 2708;
pub const F_PG_HAS_ROLE_NAME_TEXT: u32 = 2709;
pub const F_PG_HAS_ROLE_OID_TEXT: u32 = 2710;
pub const F_JUSTIFY_INTERVAL: u32 = 2711;
pub const F_STDDEV_SAMP_INT8: u32 = 2712;
pub const F_STDDEV_SAMP_INT4: u32 = 2713;
pub const F_STDDEV_SAMP_INT2: u32 = 2714;
pub const F_STDDEV_SAMP_FLOAT4: u32 = 2715;
pub const F_STDDEV_SAMP_FLOAT8: u32 = 2716;
pub const F_STDDEV_SAMP_NUMERIC: u32 = 2717;
pub const F_VAR_POP_INT8: u32 = 2718;
pub const F_VAR_POP_INT4: u32 = 2719;
pub const F_VAR_POP_INT2: u32 = 2720;
pub const F_VAR_POP_FLOAT4: u32 = 2721;
pub const F_VAR_POP_FLOAT8: u32 = 2722;
pub const F_VAR_POP_NUMERIC: u32 = 2723;
pub const F_STDDEV_POP_INT8: u32 = 2724;
pub const F_STDDEV_POP_INT4: u32 = 2725;
pub const F_STDDEV_POP_INT2: u32 = 2726;
pub const F_STDDEV_POP_FLOAT4: u32 = 2727;
pub const F_STDDEV_POP_FLOAT8: u32 = 2728;
pub const F_STDDEV_POP_NUMERIC: u32 = 2729;
pub const F_PG_GET_TRIGGERDEF_OID_BOOL: u32 = 2730;
pub const F_ASIND: u32 = 2731;
pub const F_ACOSD: u32 = 2732;
pub const F_ATAND: u32 = 2733;
pub const F_ATAN2D: u32 = 2734;
pub const F_SIND: u32 = 2735;
pub const F_COSD: u32 = 2736;
pub const F_TAND: u32 = 2737;
pub const F_COTD: u32 = 2738;
pub const F_PG_BACKUP_STOP: u32 = 2739;
pub const F_NUMERIC_AVG_SERIALIZE: u32 = 2740;
pub const F_NUMERIC_AVG_DESERIALIZE: u32 = 2741;
pub const F_GINARRAYEXTRACT_ANYARRAY_INTERNAL_INTERNAL: u32 = 2743;
pub const F_GINARRAYCONSISTENT: u32 = 2744;
pub const F_INT8_AVG_ACCUM: u32 = 2746;
pub const F_ARRAYOVERLAP: u32 = 2747;
pub const F_ARRAYCONTAINS: u32 = 2748;
pub const F_ARRAYCONTAINED: u32 = 2749;
pub const F_PG_STAT_GET_DB_TUPLES_RETURNED: u32 = 2758;
pub const F_PG_STAT_GET_DB_TUPLES_FETCHED: u32 = 2759;
pub const F_PG_STAT_GET_DB_TUPLES_INSERTED: u32 = 2760;
pub const F_PG_STAT_GET_DB_TUPLES_UPDATED: u32 = 2761;
pub const F_PG_STAT_GET_DB_TUPLES_DELETED: u32 = 2762;
pub const F_REGEXP_MATCHES_TEXT_TEXT: u32 = 2763;
pub const F_REGEXP_MATCHES_TEXT_TEXT_TEXT: u32 = 2764;
pub const F_REGEXP_SPLIT_TO_TABLE_TEXT_TEXT: u32 = 2765;
pub const F_REGEXP_SPLIT_TO_TABLE_TEXT_TEXT_TEXT: u32 = 2766;
pub const F_REGEXP_SPLIT_TO_ARRAY_TEXT_TEXT: u32 = 2767;
pub const F_REGEXP_SPLIT_TO_ARRAY_TEXT_TEXT_TEXT: u32 = 2768;
pub const F_PG_STAT_GET_BGWRITER_TIMED_CHECKPOINTS: u32 = 2769;
pub const F_PG_STAT_GET_BGWRITER_REQUESTED_CHECKPOINTS: u32 = 2770;
pub const F_PG_STAT_GET_BGWRITER_BUF_WRITTEN_CHECKPOINTS: u32 = 2771;
pub const F_PG_STAT_GET_BGWRITER_BUF_WRITTEN_CLEAN: u32 = 2772;
pub const F_PG_STAT_GET_BGWRITER_MAXWRITTEN_CLEAN: u32 = 2773;
pub const F_GINQUERYARRAYEXTRACT: u32 = 2774;
pub const F_PG_STAT_GET_BUF_WRITTEN_BACKEND: u32 = 2775;
pub const F_ANYNONARRAY_IN: u32 = 2777;
pub const F_ANYNONARRAY_OUT: u32 = 2778;
pub const F_PG_STAT_GET_LAST_VACUUM_TIME: u32 = 2781;
pub const F_PG_STAT_GET_LAST_AUTOVACUUM_TIME: u32 = 2782;
pub const F_PG_STAT_GET_LAST_ANALYZE_TIME: u32 = 2783;
pub const F_PG_STAT_GET_LAST_AUTOANALYZE_TIME: u32 = 2784;
pub const F_INT8_AVG_COMBINE: u32 = 2785;
pub const F_INT8_AVG_SERIALIZE: u32 = 2786;
pub const F_INT8_AVG_DESERIALIZE: u32 = 2787;
pub const F_PG_STAT_GET_BACKEND_WAIT_EVENT_TYPE: u32 = 2788;
pub const F_TIDGT: u32 = 2790;
pub const F_TIDLT: u32 = 2791;
pub const F_TIDGE: u32 = 2792;
pub const F_TIDLE: u32 = 2793;
pub const F_BTTIDCMP: u32 = 2794;
pub const F_TIDLARGER: u32 = 2795;
pub const F_TIDSMALLER: u32 = 2796;
pub const F_MAX_TID: u32 = 2797;
pub const F_MIN_TID: u32 = 2798;
pub const F_COUNT_: u32 = 2803;
pub const F_INT8INC_ANY: u32 = 2804;
pub const F_INT8INC_FLOAT8_FLOAT8: u32 = 2805;
pub const F_FLOAT8_REGR_ACCUM: u32 = 2806;
pub const F_FLOAT8_REGR_SXX: u32 = 2807;
pub const F_FLOAT8_REGR_SYY: u32 = 2808;
pub const F_FLOAT8_REGR_SXY: u32 = 2809;
pub const F_FLOAT8_REGR_AVGX: u32 = 2810;
pub const F_FLOAT8_REGR_AVGY: u32 = 2811;
pub const F_FLOAT8_REGR_R2: u32 = 2812;
pub const F_FLOAT8_REGR_SLOPE: u32 = 2813;
pub const F_FLOAT8_REGR_INTERCEPT: u32 = 2814;
pub const F_FLOAT8_COVAR_POP: u32 = 2815;
pub const F_FLOAT8_COVAR_SAMP: u32 = 2816;
pub const F_FLOAT8_CORR: u32 = 2817;
pub const F_REGR_COUNT: u32 = 2818;
pub const F_REGR_SXX: u32 = 2819;
pub const F_REGR_SYY: u32 = 2820;
pub const F_REGR_SXY: u32 = 2821;
pub const F_REGR_AVGX: u32 = 2822;
pub const F_REGR_AVGY: u32 = 2823;
pub const F_REGR_R2: u32 = 2824;
pub const F_REGR_SLOPE: u32 = 2825;
pub const F_REGR_INTERCEPT: u32 = 2826;
pub const F_COVAR_POP: u32 = 2827;
pub const F_COVAR_SAMP: u32 = 2828;
pub const F_CORR: u32 = 2829;
pub const F_PG_STAT_GET_DB_BLK_READ_TIME: u32 = 2844;
pub const F_PG_STAT_GET_DB_BLK_WRITE_TIME: u32 = 2845;
pub const F_PG_SWITCH_WAL: u32 = 2848;
pub const F_PG_CURRENT_WAL_LSN: u32 = 2849;
pub const F_PG_WALFILE_NAME_OFFSET: u32 = 2850;
pub const F_PG_WALFILE_NAME: u32 = 2851;
pub const F_PG_CURRENT_WAL_INSERT_LSN: u32 = 2852;
pub const F_PG_STAT_GET_BACKEND_WAIT_EVENT: u32 = 2853;
pub const F_PG_MY_TEMP_SCHEMA: u32 = 2854;
pub const F_PG_IS_OTHER_TEMP_SCHEMA: u32 = 2855;
pub const F_PG_TIMEZONE_NAMES: u32 = 2856;
pub const F_PG_STAT_GET_BACKEND_XACT_START: u32 = 2857;
pub const F_NUMERIC_AVG_ACCUM: u32 = 2858;
pub const F_PG_STAT_GET_BUF_ALLOC: u32 = 2859;
pub const F_PG_STAT_GET_LIVE_TUPLES: u32 = 2878;
pub const F_PG_STAT_GET_DEAD_TUPLES: u32 = 2879;
pub const F_PG_ADVISORY_LOCK_INT8: u32 = 2880;
pub const F_PG_ADVISORY_LOCK_SHARED_INT8: u32 = 2881;
pub const F_PG_TRY_ADVISORY_LOCK_INT8: u32 = 2882;
pub const F_PG_TRY_ADVISORY_LOCK_SHARED_INT8: u32 = 2883;
pub const F_PG_ADVISORY_UNLOCK_INT8: u32 = 2884;
pub const F_PG_ADVISORY_UNLOCK_SHARED_INT8: u32 = 2885;
pub const F_PG_ADVISORY_LOCK_INT4_INT4: u32 = 2886;
pub const F_PG_ADVISORY_LOCK_SHARED_INT4_INT4: u32 = 2887;
pub const F_PG_TRY_ADVISORY_LOCK_INT4_INT4: u32 = 2888;
pub const F_PG_TRY_ADVISORY_LOCK_SHARED_INT4_INT4: u32 = 2889;
pub const F_PG_ADVISORY_UNLOCK_INT4_INT4: u32 = 2890;
pub const F_PG_ADVISORY_UNLOCK_SHARED_INT4_INT4: u32 = 2891;
pub const F_PG_ADVISORY_UNLOCK_ALL: u32 = 2892;
pub const F_XML_IN: u32 = 2893;
pub const F_XML_OUT: u32 = 2894;
pub const F_XMLCOMMENT: u32 = 2895;
pub const F_XML: u32 = 2896;
pub const F_XMLVALIDATE: u32 = 2897;
pub const F_XML_RECV: u32 = 2898;
pub const F_XML_SEND: u32 = 2899;
pub const F_XMLCONCAT2: u32 = 2900;
pub const F_XMLAGG: u32 = 2901;
pub const F_VARBITTYPMODIN: u32 = 2902;
pub const F_INTERVALTYPMODIN: u32 = 2903;
pub const F_INTERVALTYPMODOUT: u32 = 2904;
pub const F_TIMESTAMPTYPMODIN: u32 = 2905;
pub const F_TIMESTAMPTYPMODOUT: u32 = 2906;
pub const F_TIMESTAMPTZTYPMODIN: u32 = 2907;
pub const F_TIMESTAMPTZTYPMODOUT: u32 = 2908;
pub const F_TIMETYPMODIN: u32 = 2909;
pub const F_TIMETYPMODOUT: u32 = 2910;
pub const F_TIMETZTYPMODIN: u32 = 2911;
pub const F_TIMETZTYPMODOUT: u32 = 2912;
pub const F_BPCHARTYPMODIN: u32 = 2913;
pub const F_BPCHARTYPMODOUT: u32 = 2914;
pub const F_VARCHARTYPMODIN: u32 = 2915;
pub const F_VARCHARTYPMODOUT: u32 = 2916;
pub const F_NUMERICTYPMODIN: u32 = 2917;
pub const F_NUMERICTYPMODOUT: u32 = 2918;
pub const F_BITTYPMODIN: u32 = 2919;
pub const F_BITTYPMODOUT: u32 = 2920;
pub const F_VARBITTYPMODOUT: u32 = 2921;
pub const F_TEXT_XML: u32 = 2922;
pub const F_TABLE_TO_XML: u32 = 2923;
pub const F_QUERY_TO_XML: u32 = 2924;
pub const F_CURSOR_TO_XML: u32 = 2925;
pub const F_TABLE_TO_XMLSCHEMA: u32 = 2926;
pub const F_QUERY_TO_XMLSCHEMA: u32 = 2927;
pub const F_CURSOR_TO_XMLSCHEMA: u32 = 2928;
pub const F_TABLE_TO_XML_AND_XMLSCHEMA: u32 = 2929;
pub const F_QUERY_TO_XML_AND_XMLSCHEMA: u32 = 2930;
pub const F_XPATH_TEXT_XML__TEXT: u32 = 2931;
pub const F_XPATH_TEXT_XML: u32 = 2932;
pub const F_SCHEMA_TO_XML: u32 = 2933;
pub const F_SCHEMA_TO_XMLSCHEMA: u32 = 2934;
pub const F_SCHEMA_TO_XML_AND_XMLSCHEMA: u32 = 2935;
pub const F_DATABASE_TO_XML: u32 = 2936;
pub const F_DATABASE_TO_XMLSCHEMA: u32 = 2937;
pub const F_DATABASE_TO_XML_AND_XMLSCHEMA: u32 = 2938;
pub const F_TXID_SNAPSHOT_IN: u32 = 2939;
pub const F_TXID_SNAPSHOT_OUT: u32 = 2940;
pub const F_TXID_SNAPSHOT_RECV: u32 = 2941;
pub const F_TXID_SNAPSHOT_SEND: u32 = 2942;
pub const F_TXID_CURRENT: u32 = 2943;
pub const F_TXID_CURRENT_SNAPSHOT: u32 = 2944;
pub const F_TXID_SNAPSHOT_XMIN: u32 = 2945;
pub const F_TXID_SNAPSHOT_XMAX: u32 = 2946;
pub const F_TXID_SNAPSHOT_XIP: u32 = 2947;
pub const F_TXID_VISIBLE_IN_SNAPSHOT: u32 = 2948;
pub const F_UUID_IN: u32 = 2952;
pub const F_UUID_OUT: u32 = 2953;
pub const F_UUID_LT: u32 = 2954;
pub const F_UUID_LE: u32 = 2955;
pub const F_UUID_EQ: u32 = 2956;
pub const F_UUID_GE: u32 = 2957;
pub const F_UUID_GT: u32 = 2958;
pub const F_UUID_NE: u32 = 2959;
pub const F_UUID_CMP: u32 = 2960;
pub const F_UUID_RECV: u32 = 2961;
pub const F_UUID_SEND: u32 = 2962;
pub const F_UUID_HASH: u32 = 2963;
pub const F_TEXT_BOOL: u32 = 2971;
pub const F_PG_STAT_GET_FUNCTION_CALLS: u32 = 2978;
pub const F_PG_STAT_GET_FUNCTION_TOTAL_TIME: u32 = 2979;
pub const F_PG_STAT_GET_FUNCTION_SELF_TIME: u32 = 2980;
pub const F_RECORD_EQ: u32 = 2981;
pub const F_RECORD_NE: u32 = 2982;
pub const F_RECORD_LT: u32 = 2983;
pub const F_RECORD_GT: u32 = 2984;
pub const F_RECORD_LE: u32 = 2985;
pub const F_RECORD_GE: u32 = 2986;
pub const F_BTRECORDCMP: u32 = 2987;
pub const F_PG_TABLE_SIZE: u32 = 2997;
pub const F_PG_INDEXES_SIZE: u32 = 2998;
pub const F_PG_RELATION_FILENODE: u32 = 2999;
pub const F_HAS_FOREIGN_DATA_WRAPPER_PRIVILEGE_NAME_TEXT_TEXT: u32 = 3000;
pub const F_HAS_FOREIGN_DATA_WRAPPER_PRIVILEGE_NAME_OID_TEXT: u32 = 3001;
pub const F_HAS_FOREIGN_DATA_WRAPPER_PRIVILEGE_OID_TEXT_TEXT: u32 = 3002;
pub const F_HAS_FOREIGN_DATA_WRAPPER_PRIVILEGE_OID_OID_TEXT: u32 = 3003;
pub const F_HAS_FOREIGN_DATA_WRAPPER_PRIVILEGE_TEXT_TEXT: u32 = 3004;
pub const F_HAS_FOREIGN_DATA_WRAPPER_PRIVILEGE_OID_TEXT: u32 = 3005;
pub const F_HAS_SERVER_PRIVILEGE_NAME_TEXT_TEXT: u32 = 3006;
pub const F_HAS_SERVER_PRIVILEGE_NAME_OID_TEXT: u32 = 3007;
pub const F_HAS_SERVER_PRIVILEGE_OID_TEXT_TEXT: u32 = 3008;
pub const F_HAS_SERVER_PRIVILEGE_OID_OID_TEXT: u32 = 3009;
pub const F_HAS_SERVER_PRIVILEGE_TEXT_TEXT: u32 = 3010;
pub const F_HAS_SERVER_PRIVILEGE_OID_TEXT: u32 = 3011;
pub const F_HAS_COLUMN_PRIVILEGE_NAME_TEXT_TEXT_TEXT: u32 = 3012;
pub const F_HAS_COLUMN_PRIVILEGE_NAME_TEXT_INT2_TEXT: u32 = 3013;
pub const F_HAS_COLUMN_PRIVILEGE_NAME_OID_TEXT_TEXT: u32 = 3014;
pub const F_HAS_COLUMN_PRIVILEGE_NAME_OID_INT2_TEXT: u32 = 3015;
pub const F_HAS_COLUMN_PRIVILEGE_OID_TEXT_TEXT_TEXT: u32 = 3016;
pub const F_HAS_COLUMN_PRIVILEGE_OID_TEXT_INT2_TEXT: u32 = 3017;
pub const F_HAS_COLUMN_PRIVILEGE_OID_OID_TEXT_TEXT: u32 = 3018;
pub const F_HAS_COLUMN_PRIVILEGE_OID_OID_INT2_TEXT: u32 = 3019;
pub const F_HAS_COLUMN_PRIVILEGE_TEXT_TEXT_TEXT: u32 = 3020;
pub const F_HAS_COLUMN_PRIVILEGE_TEXT_INT2_TEXT: u32 = 3021;
pub const F_HAS_COLUMN_PRIVILEGE_OID_TEXT_TEXT: u32 = 3022;
pub const F_HAS_COLUMN_PRIVILEGE_OID_INT2_TEXT: u32 = 3023;
pub const F_HAS_ANY_COLUMN_PRIVILEGE_NAME_TEXT_TEXT: u32 = 3024;
pub const F_HAS_ANY_COLUMN_PRIVILEGE_NAME_OID_TEXT: u32 = 3025;
pub const F_HAS_ANY_COLUMN_PRIVILEGE_OID_TEXT_TEXT: u32 = 3026;
pub const F_HAS_ANY_COLUMN_PRIVILEGE_OID_OID_TEXT: u32 = 3027;
pub const F_HAS_ANY_COLUMN_PRIVILEGE_TEXT_TEXT: u32 = 3028;
pub const F_HAS_ANY_COLUMN_PRIVILEGE_OID_TEXT: u32 = 3029;
pub const F_OVERLAY_BIT_BIT_INT4_INT4: u32 = 3030;
pub const F_OVERLAY_BIT_BIT_INT4: u32 = 3031;
pub const F_GET_BIT_BIT_INT4: u32 = 3032;
pub const F_SET_BIT_BIT_INT4_INT4: u32 = 3033;
pub const F_PG_RELATION_FILEPATH: u32 = 3034;
pub const F_PG_LISTENING_CHANNELS: u32 = 3035;
pub const F_PG_NOTIFY: u32 = 3036;
pub const F_PG_STAT_GET_XACT_NUMSCANS: u32 = 3037;
pub const F_PG_STAT_GET_XACT_TUPLES_RETURNED: u32 = 3038;
pub const F_PG_STAT_GET_XACT_TUPLES_FETCHED: u32 = 3039;
pub const F_PG_STAT_GET_XACT_TUPLES_INSERTED: u32 = 3040;
pub const F_PG_STAT_GET_XACT_TUPLES_UPDATED: u32 = 3041;
pub const F_PG_STAT_GET_XACT_TUPLES_DELETED: u32 = 3042;
pub const F_PG_STAT_GET_XACT_TUPLES_HOT_UPDATED: u32 = 3043;
pub const F_PG_STAT_GET_XACT_BLOCKS_FETCHED: u32 = 3044;
pub const F_PG_STAT_GET_XACT_BLOCKS_HIT: u32 = 3045;
pub const F_PG_STAT_GET_XACT_FUNCTION_CALLS: u32 = 3046;
pub const F_PG_STAT_GET_XACT_FUNCTION_TOTAL_TIME: u32 = 3047;
pub const F_PG_STAT_GET_XACT_FUNCTION_SELF_TIME: u32 = 3048;
pub const F_XPATH_EXISTS_TEXT_XML__TEXT: u32 = 3049;
pub const F_XPATH_EXISTS_TEXT_XML: u32 = 3050;
pub const F_XML_IS_WELL_FORMED: u32 = 3051;
pub const F_XML_IS_WELL_FORMED_DOCUMENT: u32 = 3052;
pub const F_XML_IS_WELL_FORMED_CONTENT: u32 = 3053;
pub const F_PG_STAT_GET_VACUUM_COUNT: u32 = 3054;
pub const F_PG_STAT_GET_AUTOVACUUM_COUNT: u32 = 3055;
pub const F_PG_STAT_GET_ANALYZE_COUNT: u32 = 3056;
pub const F_PG_STAT_GET_AUTOANALYZE_COUNT: u32 = 3057;
pub const F_CONCAT: u32 = 3058;
pub const F_CONCAT_WS: u32 = 3059;
pub const F_LEFT: u32 = 3060;
pub const F_RIGHT: u32 = 3061;
pub const F_REVERSE: u32 = 3062;
pub const F_PG_STAT_GET_BUF_FSYNC_BACKEND: u32 = 3063;
pub const F_GIST_POINT_DISTANCE: u32 = 3064;
pub const F_PG_STAT_GET_DB_CONFLICT_TABLESPACE: u32 = 3065;
pub const F_PG_STAT_GET_DB_CONFLICT_LOCK: u32 = 3066;
pub const F_PG_STAT_GET_DB_CONFLICT_SNAPSHOT: u32 = 3067;
pub const F_PG_STAT_GET_DB_CONFLICT_BUFFERPIN: u32 = 3068;
pub const F_PG_STAT_GET_DB_CONFLICT_STARTUP_DEADLOCK: u32 = 3069;
pub const F_PG_STAT_GET_DB_CONFLICT_ALL: u32 = 3070;
pub const F_PG_WAL_REPLAY_PAUSE: u32 = 3071;
pub const F_PG_WAL_REPLAY_RESUME: u32 = 3072;
pub const F_PG_IS_WAL_REPLAY_PAUSED: u32 = 3073;
pub const F_PG_STAT_GET_DB_STAT_RESET_TIME: u32 = 3074;
pub const F_PG_STAT_GET_BGWRITER_STAT_RESET_TIME: u32 = 3075;
pub const F_GINARRAYEXTRACT_ANYARRAY_INTERNAL: u32 = 3076;
pub const F_GIN_EXTRACT_TSVECTOR_TSVECTOR_INTERNAL: u32 = 3077;
pub const F_PG_SEQUENCE_PARAMETERS: u32 = 3078;
pub const F_PG_AVAILABLE_EXTENSIONS: u32 = 3082;
pub const F_PG_AVAILABLE_EXTENSION_VERSIONS: u32 = 3083;
pub const F_PG_EXTENSION_UPDATE_PATHS: u32 = 3084;
pub const F_PG_EXTENSION_CONFIG_DUMP: u32 = 3086;
pub const F_GIN_EXTRACT_TSQUERY_TSQUERY_INTERNAL_INT2_INTERNAL_INTERNAL: u32 = 3087;
pub const F_GIN_TSQUERY_CONSISTENT_INTERNAL_INT2_TSQUERY_INT4_INTERNAL_INTERNAL: u32 = 3088;
pub const F_PG_ADVISORY_XACT_LOCK_INT8: u32 = 3089;
pub const F_PG_ADVISORY_XACT_LOCK_SHARED_INT8: u32 = 3090;
pub const F_PG_TRY_ADVISORY_XACT_LOCK_INT8: u32 = 3091;
pub const F_PG_TRY_ADVISORY_XACT_LOCK_SHARED_INT8: u32 = 3092;
pub const F_PG_ADVISORY_XACT_LOCK_INT4_INT4: u32 = 3093;
pub const F_PG_ADVISORY_XACT_LOCK_SHARED_INT4_INT4: u32 = 3094;
pub const F_PG_TRY_ADVISORY_XACT_LOCK_INT4_INT4: u32 = 3095;
pub const F_PG_TRY_ADVISORY_XACT_LOCK_SHARED_INT4_INT4: u32 = 3096;
pub const F_VARCHAR_SUPPORT: u32 = 3097;
pub const F_PG_CREATE_RESTORE_POINT: u32 = 3098;
pub const F_PG_STAT_GET_WAL_SENDERS: u32 = 3099;
pub const F_ROW_NUMBER: u32 = 3100;
pub const F_RANK_: u32 = 3101;
pub const F_DENSE_RANK_: u32 = 3102;
pub const F_PERCENT_RANK_: u32 = 3103;
pub const F_CUME_DIST_: u32 = 3104;
pub const F_NTILE: u32 = 3105;
pub const F_LAG_ANYELEMENT: u32 = 3106;
pub const F_LAG_ANYELEMENT_INT4: u32 = 3107;
pub const F_LAG_ANYCOMPATIBLE_INT4_ANYCOMPATIBLE: u32 = 3108;
pub const F_LEAD_ANYELEMENT: u32 = 3109;
pub const F_LEAD_ANYELEMENT_INT4: u32 = 3110;
pub const F_LEAD_ANYCOMPATIBLE_INT4_ANYCOMPATIBLE: u32 = 3111;
pub const F_FIRST_VALUE: u32 = 3112;
pub const F_LAST_VALUE: u32 = 3113;
pub const F_NTH_VALUE: u32 = 3114;
pub const F_FDW_HANDLER_IN: u32 = 3116;
pub const F_FDW_HANDLER_OUT: u32 = 3117;
pub const F_VOID_RECV: u32 = 3120;
pub const F_VOID_SEND: u32 = 3121;
pub const F_BTINT2SORTSUPPORT: u32 = 3129;
pub const F_BTINT4SORTSUPPORT: u32 = 3130;
pub const F_BTINT8SORTSUPPORT: u32 = 3131;
pub const F_BTFLOAT4SORTSUPPORT: u32 = 3132;
pub const F_BTFLOAT8SORTSUPPORT: u32 = 3133;
pub const F_BTOIDSORTSUPPORT: u32 = 3134;
pub const F_BTNAMESORTSUPPORT: u32 = 3135;
pub const F_DATE_SORTSUPPORT: u32 = 3136;
pub const F_TIMESTAMP_SORTSUPPORT: u32 = 3137;
pub const F_HAS_TYPE_PRIVILEGE_NAME_TEXT_TEXT: u32 = 3138;
pub const F_HAS_TYPE_PRIVILEGE_NAME_OID_TEXT: u32 = 3139;
pub const F_HAS_TYPE_PRIVILEGE_OID_TEXT_TEXT: u32 = 3140;
pub const F_HAS_TYPE_PRIVILEGE_OID_OID_TEXT: u32 = 3141;
pub const F_HAS_TYPE_PRIVILEGE_TEXT_TEXT: u32 = 3142;
pub const F_HAS_TYPE_PRIVILEGE_OID_TEXT: u32 = 3143;
pub const F_MACADDR_NOT: u32 = 3144;
pub const F_MACADDR_AND: u32 = 3145;
pub const F_MACADDR_OR: u32 = 3146;
pub const F_PG_STAT_GET_DB_TEMP_FILES: u32 = 3150;
pub const F_PG_STAT_GET_DB_TEMP_BYTES: u32 = 3151;
pub const F_PG_STAT_GET_DB_DEADLOCKS: u32 = 3152;
pub const F_ARRAY_TO_JSON_ANYARRAY: u32 = 3153;
pub const F_ARRAY_TO_JSON_ANYARRAY_BOOL: u32 = 3154;
pub const F_ROW_TO_JSON_RECORD: u32 = 3155;
pub const F_ROW_TO_JSON_RECORD_BOOL: u32 = 3156;
pub const F_NUMERIC_SUPPORT: u32 = 3157;
pub const F_VARBIT_SUPPORT: u32 = 3158;
pub const F_PG_GET_VIEWDEF_OID_INT4: u32 = 3159;
pub const F_PG_STAT_GET_CHECKPOINT_WRITE_TIME: u32 = 3160;
pub const F_PG_STAT_GET_CHECKPOINT_SYNC_TIME: u32 = 3161;
pub const F_PG_COLLATION_FOR: u32 = 3162;
pub const F_PG_TRIGGER_DEPTH: u32 = 3163;
pub const F_PG_WAL_LSN_DIFF: u32 = 3165;
pub const F_PG_SIZE_PRETTY_NUMERIC: u32 = 3166;
pub const F_ARRAY_REMOVE: u32 = 3167;
pub const F_ARRAY_REPLACE: u32 = 3168;
pub const F_RANGESEL: u32 = 3169;
pub const F_LO_LSEEK64: u32 = 3170;
pub const F_LO_TELL64: u32 = 3171;
pub const F_LO_TRUNCATE64: u32 = 3172;
pub const F_JSON_AGG_TRANSFN: u32 = 3173;
pub const F_JSON_AGG_FINALFN: u32 = 3174;
pub const F_JSON_AGG: u32 = 3175;
pub const F_TO_JSON: u32 = 3176;
pub const F_PG_STAT_GET_MOD_SINCE_ANALYZE: u32 = 3177;
pub const F_NUMERIC_SUM: u32 = 3178;
pub const F_CARDINALITY: u32 = 3179;
pub const F_JSON_OBJECT_AGG_TRANSFN: u32 = 3180;
pub const F_RECORD_IMAGE_EQ: u32 = 3181;
pub const F_RECORD_IMAGE_NE: u32 = 3182;
pub const F_RECORD_IMAGE_LT: u32 = 3183;
pub const F_RECORD_IMAGE_GT: u32 = 3184;
pub const F_RECORD_IMAGE_LE: u32 = 3185;
pub const F_RECORD_IMAGE_GE: u32 = 3186;
pub const F_BTRECORDIMAGECMP: u32 = 3187;
pub const F_PG_STAT_GET_ARCHIVER: u32 = 3195;
pub const F_JSON_OBJECT_AGG_FINALFN: u32 = 3196;
pub const F_JSON_OBJECT_AGG: u32 = 3197;
pub const F_JSON_BUILD_ARRAY_ANY: u32 = 3198;
pub const F_JSON_BUILD_ARRAY_: u32 = 3199;
pub const F_JSON_BUILD_OBJECT_ANY: u32 = 3200;
pub const F_JSON_BUILD_OBJECT_: u32 = 3201;
pub const F_JSON_OBJECT__TEXT: u32 = 3202;
pub const F_JSON_OBJECT__TEXT__TEXT: u32 = 3203;
pub const F_JSON_TO_RECORD: u32 = 3204;
pub const F_JSON_TO_RECORDSET: u32 = 3205;
pub const F_JSONB_ARRAY_LENGTH: u32 = 3207;
pub const F_JSONB_EACH: u32 = 3208;
pub const F_JSONB_POPULATE_RECORD: u32 = 3209;
pub const F_JSONB_TYPEOF: u32 = 3210;
pub const F_JSONB_OBJECT_FIELD_TEXT: u32 = 3214;
pub const F_JSONB_ARRAY_ELEMENT: u32 = 3215;
pub const F_JSONB_ARRAY_ELEMENT_TEXT: u32 = 3216;
pub const F_JSONB_EXTRACT_PATH: u32 = 3217;
pub const F_WIDTH_BUCKET_ANYCOMPATIBLE_ANYCOMPATIBLEARRAY: u32 = 3218;
pub const F_JSONB_ARRAY_ELEMENTS: u32 = 3219;
pub const F_PG_LSN_IN: u32 = 3229;
pub const F_PG_LSN_OUT: u32 = 3230;
pub const F_PG_LSN_LT: u32 = 3231;
pub const F_PG_LSN_LE: u32 = 3232;
pub const F_PG_LSN_EQ: u32 = 3233;
pub const F_PG_LSN_GE: u32 = 3234;
pub const F_PG_LSN_GT: u32 = 3235;
pub const F_PG_LSN_NE: u32 = 3236;
pub const F_PG_LSN_MI: u32 = 3237;
pub const F_PG_LSN_RECV: u32 = 3238;
pub const F_PG_LSN_SEND: u32 = 3239;
pub const F_PG_LSN_CMP: u32 = 3251;
pub const F_PG_LSN_HASH: u32 = 3252;
pub const F_BTTEXTSORTSUPPORT: u32 = 3255;
pub const F_GENERATE_SERIES_NUMERIC_NUMERIC_NUMERIC: u32 = 3259;
pub const F_GENERATE_SERIES_NUMERIC_NUMERIC: u32 = 3260;
pub const F_JSON_STRIP_NULLS: u32 = 3261;
pub const F_JSONB_STRIP_NULLS: u32 = 3262;
pub const F_JSONB_OBJECT__TEXT: u32 = 3263;
pub const F_JSONB_OBJECT__TEXT__TEXT: u32 = 3264;
pub const F_JSONB_AGG_TRANSFN: u32 = 3265;
pub const F_JSONB_AGG_FINALFN: u32 = 3266;
pub const F_JSONB_AGG: u32 = 3267;
pub const F_JSONB_OBJECT_AGG_TRANSFN: u32 = 3268;
pub const F_JSONB_OBJECT_AGG_FINALFN: u32 = 3269;
pub const F_JSONB_OBJECT_AGG: u32 = 3270;
pub const F_JSONB_BUILD_ARRAY_ANY: u32 = 3271;
pub const F_JSONB_BUILD_ARRAY_: u32 = 3272;
pub const F_JSONB_BUILD_OBJECT_ANY: u32 = 3273;
pub const F_JSONB_BUILD_OBJECT_: u32 = 3274;
pub const F_DIST_PPOLY: u32 = 3275;
pub const F_ARRAY_POSITION_ANYCOMPATIBLEARRAY_ANYCOMPATIBLE: u32 = 3277;
pub const F_ARRAY_POSITION_ANYCOMPATIBLEARRAY_ANYCOMPATIBLE_INT4: u32 = 3278;
pub const F_ARRAY_POSITIONS: u32 = 3279;
pub const F_GIST_CIRCLE_DISTANCE: u32 = 3280;
pub const F_SCALE: u32 = 3281;
pub const F_GIST_POINT_FETCH: u32 = 3282;
pub const F_NUMERIC_SORTSUPPORT: u32 = 3283;
pub const F_GIST_POLY_DISTANCE: u32 = 3288;
pub const F_DIST_CPOINT: u32 = 3290;
pub const F_DIST_POLYP: u32 = 3292;
pub const F_PG_READ_FILE_TEXT_INT8_INT8_BOOL: u32 = 3293;
pub const F_CURRENT_SETTING_TEXT_BOOL: u32 = 3294;
pub const F_PG_READ_BINARY_FILE_TEXT_INT8_INT8_BOOL: u32 = 3295;
pub const F_PG_NOTIFICATION_QUEUE_USAGE: u32 = 3296;
pub const F_PG_LS_DIR_TEXT_BOOL_BOOL: u32 = 3297;
pub const F_ROW_SECURITY_ACTIVE_OID: Oid = Oid(3298);
pub const F_ROW_SECURITY_ACTIVE_TEXT: u32 = 3299;
pub const F_UUID_SORTSUPPORT: u32 = 3300;
pub const F_JSONB_CONCAT: u32 = 3301;
pub const F_JSONB_DELETE_JSONB_TEXT: u32 = 3302;
pub const F_JSONB_DELETE_JSONB_INT4: u32 = 3303;
pub const F_JSONB_DELETE_PATH: u32 = 3304;
pub const F_JSONB_SET: u32 = 3305;
pub const F_JSONB_PRETTY: u32 = 3306;
pub const F_PG_STAT_FILE_TEXT_BOOL: u32 = 3307;
pub const F_XIDNEQ: u32 = 3308;
pub const F_XIDNEQINT4: u32 = 3309;
pub const F_TSM_HANDLER_IN: u32 = 3311;
pub const F_TSM_HANDLER_OUT: u32 = 3312;
pub const F_BERNOULLI: u32 = 3313;
pub const F_SYSTEM: u32 = 3314;
pub const F_PG_STAT_GET_WAL_RECEIVER: u32 = 3317;
pub const F_PG_STAT_GET_PROGRESS_INFO: u32 = 3318;
pub const F_TS_FILTER: u32 = 3319;
pub const F_SETWEIGHT_TSVECTOR_CHAR__TEXT: u32 = 3320;
pub const F_TS_DELETE_TSVECTOR_TEXT: u32 = 3321;
pub const F_UNNEST_TSVECTOR: u32 = 3322;
pub const F_TS_DELETE_TSVECTOR__TEXT: u32 = 3323;
pub const F_INT4_AVG_COMBINE: u32 = 3324;
pub const F_INTERVAL_COMBINE: u32 = 3325;
pub const F_TSVECTOR_TO_ARRAY: u32 = 3326;
pub const F_ARRAY_TO_TSVECTOR: u32 = 3327;
pub const F_BPCHAR_SORTSUPPORT: u32 = 3328;
pub const F_PG_SHOW_ALL_FILE_SETTINGS: u32 = 3329;
pub const F_PG_CURRENT_WAL_FLUSH_LSN: u32 = 3330;
pub const F_BYTEA_SORTSUPPORT: u32 = 3331;
pub const F_BTTEXT_PATTERN_SORTSUPPORT: u32 = 3332;
pub const F_BTBPCHAR_PATTERN_SORTSUPPORT: u32 = 3333;
pub const F_PG_SIZE_BYTES: u32 = 3334;
pub const F_NUMERIC_SERIALIZE: u32 = 3335;
pub const F_NUMERIC_DESERIALIZE: u32 = 3336;
pub const F_NUMERIC_AVG_COMBINE: u32 = 3337;
pub const F_NUMERIC_POLY_COMBINE: u32 = 3338;
pub const F_NUMERIC_POLY_SERIALIZE: u32 = 3339;
pub const F_NUMERIC_POLY_DESERIALIZE: u32 = 3340;
pub const F_NUMERIC_COMBINE: u32 = 3341;
pub const F_FLOAT8_REGR_COMBINE: u32 = 3342;
pub const F_JSONB_DELETE_JSONB__TEXT: u32 = 3343;
pub const F_CASH_MUL_INT8: u32 = 3344;
pub const F_CASH_DIV_INT8: u32 = 3345;
pub const F_TXID_CURRENT_IF_ASSIGNED: u32 = 3348;
pub const F_PG_GET_PARTKEYDEF: u32 = 3352;
pub const F_PG_LS_LOGDIR: u32 = 3353;
pub const F_PG_LS_WALDIR: u32 = 3354;
pub const F_PG_NDISTINCT_IN: u32 = 3355;
pub const F_PG_NDISTINCT_OUT: u32 = 3356;
pub const F_PG_NDISTINCT_RECV: u32 = 3357;
pub const F_PG_NDISTINCT_SEND: u32 = 3358;
pub const F_MACADDR_SORTSUPPORT: u32 = 3359;
pub const F_TXID_STATUS: u32 = 3360;
pub const F_PG_SAFE_SNAPSHOT_BLOCKING_PIDS: u32 = 3376;
pub const F_PG_ISOLATION_TEST_SESSION_IS_BLOCKED: u32 = 3378;
pub const F_PG_IDENTIFY_OBJECT_AS_ADDRESS: u32 = 3382;
pub const F_BRIN_MINMAX_OPCINFO: u32 = 3383;
pub const F_BRIN_MINMAX_ADD_VALUE: u32 = 3384;
pub const F_BRIN_MINMAX_CONSISTENT: u32 = 3385;
pub const F_BRIN_MINMAX_UNION: u32 = 3386;
pub const F_INT8_AVG_ACCUM_INV: u32 = 3387;
pub const F_NUMERIC_POLY_SUM: u32 = 3388;
pub const F_NUMERIC_POLY_AVG: u32 = 3389;
pub const F_NUMERIC_POLY_VAR_POP: u32 = 3390;
pub const F_NUMERIC_POLY_VAR_SAMP: u32 = 3391;
pub const F_NUMERIC_POLY_STDDEV_POP: u32 = 3392;
pub const F_NUMERIC_POLY_STDDEV_SAMP: u32 = 3393;
pub const F_REGEXP_MATCH_TEXT_TEXT: u32 = 3396;
pub const F_REGEXP_MATCH_TEXT_TEXT_TEXT: u32 = 3397;
pub const F_INT8_MUL_CASH: u32 = 3399;
pub const F_PG_CONFIG: u32 = 3400;
pub const F_PG_HBA_FILE_RULES: u32 = 3401;
pub const F_PG_STATISTICS_OBJ_IS_VISIBLE: u32 = 3403;
pub const F_PG_DEPENDENCIES_IN: u32 = 3404;
pub const F_PG_DEPENDENCIES_OUT: u32 = 3405;
pub const F_PG_DEPENDENCIES_RECV: u32 = 3406;
pub const F_PG_DEPENDENCIES_SEND: u32 = 3407;
pub const F_PG_GET_PARTITION_CONSTRAINTDEF: u32 = 3408;
pub const F_TIME_HASH_EXTENDED: u32 = 3409;
pub const F_TIMETZ_HASH_EXTENDED: u32 = 3410;
pub const F_TIMESTAMP_HASH_EXTENDED: u32 = 3411;
pub const F_UUID_HASH_EXTENDED: u32 = 3412;
pub const F_PG_LSN_HASH_EXTENDED: u32 = 3413;
pub const F_HASHENUMEXTENDED: u32 = 3414;
pub const F_PG_GET_STATISTICSOBJDEF: u32 = 3415;
pub const F_JSONB_HASH_EXTENDED: u32 = 3416;
pub const F_HASH_RANGE_EXTENDED: u32 = 3417;
pub const F_INTERVAL_HASH_EXTENDED: u32 = 3418;
pub const F_SHA224: u32 = 3419;
pub const F_SHA256: u32 = 3420;
pub const F_SHA384: u32 = 3421;
pub const F_SHA512: u32 = 3422;
pub const F_PG_PARTITION_TREE: u32 = 3423;
pub const F_PG_PARTITION_ROOT: u32 = 3424;
pub const F_PG_PARTITION_ANCESTORS: u32 = 3425;
pub const F_PG_STAT_GET_DB_CHECKSUM_FAILURES: u32 = 3426;
pub const F_PG_MCV_LIST_ITEMS: u32 = 3427;
pub const F_PG_STAT_GET_DB_CHECKSUM_LAST_FAILURE: u32 = 3428;
pub const F_GEN_RANDOM_UUID: u32 = 3432;
pub const F_GTSVECTOR_OPTIONS: u32 = 3434;
pub const F_GIST_POINT_SORTSUPPORT: u32 = 3435;
pub const F_PG_PROMOTE: u32 = 3436;
pub const F_PREFIXSEL: u32 = 3437;
pub const F_PREFIXJOINSEL: u32 = 3438;
pub const F_PG_CONTROL_SYSTEM: u32 = 3441;
pub const F_PG_CONTROL_CHECKPOINT: u32 = 3442;
pub const F_PG_CONTROL_RECOVERY: u32 = 3443;
pub const F_PG_CONTROL_INIT: u32 = 3444;
pub const F_PG_IMPORT_SYSTEM_COLLATIONS: u32 = 3445;
pub const F_MACADDR8_RECV: u32 = 3446;
pub const F_MACADDR8_SEND: u32 = 3447;
pub const F_PG_COLLATION_ACTUAL_VERSION: u32 = 3448;
pub const F_NUMERIC_JSONB: u32 = 3449;
pub const F_INT2_JSONB: u32 = 3450;
pub const F_INT4_JSONB: u32 = 3451;
pub const F_INT8_JSONB: u32 = 3452;
pub const F_FLOAT4_JSONB: u32 = 3453;
pub const F_PG_FILENODE_RELATION: u32 = 3454;
pub const F_LO_FROM_BYTEA: u32 = 3457;
pub const F_LO_GET_OID: Oid = Oid(3458);
pub const F_LO_GET_OID_INT8_INT4: u32 = 3459;
pub const F_LO_PUT: u32 = 3460;
pub const F_MAKE_TIMESTAMP: u32 = 3461;
pub const F_MAKE_TIMESTAMPTZ_INT4_INT4_INT4_INT4_INT4_FLOAT8: u32 = 3462;
pub const F_MAKE_TIMESTAMPTZ_INT4_INT4_INT4_INT4_INT4_FLOAT8_TEXT: u32 = 3463;
pub const F_MAKE_INTERVAL: u32 = 3464;
pub const F_JSONB_ARRAY_ELEMENTS_TEXT: u32 = 3465;
pub const F_SPG_RANGE_QUAD_CONFIG: u32 = 3469;
pub const F_SPG_RANGE_QUAD_CHOOSE: u32 = 3470;
pub const F_SPG_RANGE_QUAD_PICKSPLIT: u32 = 3471;
pub const F_SPG_RANGE_QUAD_INNER_CONSISTENT: u32 = 3472;
pub const F_SPG_RANGE_QUAD_LEAF_CONSISTENT: u32 = 3473;
pub const F_JSONB_POPULATE_RECORDSET: u32 = 3475;
pub const F_TO_REGOPERATOR: u32 = 3476;
pub const F_JSONB_OBJECT_FIELD: u32 = 3478;
pub const F_TO_REGPROCEDURE: u32 = 3479;
pub const F_GIN_COMPARE_JSONB: u32 = 3480;
pub const F_GIN_EXTRACT_JSONB: u32 = 3482;
pub const F_GIN_EXTRACT_JSONB_QUERY: u32 = 3483;
pub const F_GIN_CONSISTENT_JSONB: u32 = 3484;
pub const F_GIN_EXTRACT_JSONB_PATH: u32 = 3485;
pub const F_GIN_EXTRACT_JSONB_QUERY_PATH: u32 = 3486;
pub const F_GIN_CONSISTENT_JSONB_PATH: u32 = 3487;
pub const F_GIN_TRICONSISTENT_JSONB: u32 = 3488;
pub const F_GIN_TRICONSISTENT_JSONB_PATH: u32 = 3489;
pub const F_JSONB_TO_RECORD: u32 = 3490;
pub const F_JSONB_TO_RECORDSET: u32 = 3491;
pub const F_TO_REGOPER: u32 = 3492;
pub const F_TO_REGTYPE: u32 = 3493;
pub const F_TO_REGPROC: u32 = 3494;
pub const F_TO_REGCLASS: u32 = 3495;
pub const F_BOOL_ACCUM: u32 = 3496;
pub const F_BOOL_ACCUM_INV: u32 = 3497;
pub const F_BOOL_ALLTRUE: u32 = 3498;
pub const F_BOOL_ANYTRUE: u32 = 3499;
pub const F_ANYENUM_IN: u32 = 3504;
pub const F_ANYENUM_OUT: u32 = 3505;
pub const F_ENUM_IN: u32 = 3506;
pub const F_ENUM_OUT: u32 = 3507;
pub const F_ENUM_EQ: u32 = 3508;
pub const F_ENUM_NE: u32 = 3509;
pub const F_ENUM_LT: u32 = 3510;
pub const F_ENUM_GT: u32 = 3511;
pub const F_ENUM_LE: u32 = 3512;
pub const F_ENUM_GE: u32 = 3513;
pub const F_ENUM_CMP: u32 = 3514;
pub const F_HASHENUM: u32 = 3515;
pub const F_ENUM_SMALLER: u32 = 3524;
pub const F_ENUM_LARGER: u32 = 3525;
pub const F_MAX_ANYENUM: u32 = 3526;
pub const F_MIN_ANYENUM: u32 = 3527;
pub const F_ENUM_FIRST: u32 = 3528;
pub const F_ENUM_LAST: u32 = 3529;
pub const F_ENUM_RANGE_ANYENUM_ANYENUM: u32 = 3530;
pub const F_ENUM_RANGE_ANYENUM: u32 = 3531;
pub const F_ENUM_RECV: u32 = 3532;
pub const F_ENUM_SEND: u32 = 3533;
pub const F_STRING_AGG_TRANSFN: u32 = 3535;
pub const F_STRING_AGG_FINALFN: u32 = 3536;
pub const F_PG_DESCRIBE_OBJECT: u32 = 3537;
pub const F_STRING_AGG_TEXT_TEXT: u32 = 3538;
pub const F_FORMAT_TEXT_ANY: u32 = 3539;
pub const F_FORMAT_TEXT: u32 = 3540;
pub const F_BYTEA_STRING_AGG_TRANSFN: u32 = 3543;
pub const F_BYTEA_STRING_AGG_FINALFN: u32 = 3544;
pub const F_STRING_AGG_BYTEA_BYTEA: u32 = 3545;
pub const F_INT8DEC: u32 = 3546;
pub const F_INT8DEC_ANY: u32 = 3547;
pub const F_NUMERIC_ACCUM_INV: u32 = 3548;
pub const F_INTERVAL_ACCUM_INV: u32 = 3549;
pub const F_NETWORK_OVERLAP: u32 = 3551;
pub const F_INET_GIST_CONSISTENT: u32 = 3553;
pub const F_INET_GIST_UNION: u32 = 3554;
pub const F_INET_GIST_COMPRESS: u32 = 3555;
pub const F_BOOL_JSONB: u32 = 3556;
pub const F_INET_GIST_PENALTY: u32 = 3557;
pub const F_INET_GIST_PICKSPLIT: u32 = 3558;
pub const F_INET_GIST_SAME: u32 = 3559;
pub const F_NETWORKSEL: u32 = 3560;
pub const F_NETWORKJOINSEL: u32 = 3561;
pub const F_NETWORK_LARGER: u32 = 3562;
pub const F_NETWORK_SMALLER: u32 = 3563;
pub const F_MAX_INET: u32 = 3564;
pub const F_MIN_INET: u32 = 3565;
pub const F_PG_EVENT_TRIGGER_DROPPED_OBJECTS: u32 = 3566;
pub const F_INT2_ACCUM_INV: u32 = 3567;
pub const F_INT4_ACCUM_INV: u32 = 3568;
pub const F_INT8_ACCUM_INV: u32 = 3569;
pub const F_INT2_AVG_ACCUM_INV: u32 = 3570;
pub const F_INT4_AVG_ACCUM_INV: u32 = 3571;
pub const F_INT2INT4_SUM: u32 = 3572;
pub const F_INET_GIST_FETCH: u32 = 3573;
pub const F_PG_LOGICAL_EMIT_MESSAGE_BOOL_TEXT_TEXT: u32 = 3577;
pub const F_PG_LOGICAL_EMIT_MESSAGE_BOOL_TEXT_BYTEA: u32 = 3578;
pub const F_JSONB_INSERT: u32 = 3579;
pub const F_PG_XACT_COMMIT_TIMESTAMP: u32 = 3581;
pub const F_BINARY_UPGRADE_SET_NEXT_PG_TYPE_OID: Oid = Oid(3582);
pub const F_PG_LAST_COMMITTED_XACT: u32 = 3583;
pub const F_BINARY_UPGRADE_SET_NEXT_ARRAY_PG_TYPE_OID: Oid = Oid(3584);
pub const F_BINARY_UPGRADE_SET_NEXT_HEAP_PG_CLASS_OID: Oid = Oid(3586);
pub const F_BINARY_UPGRADE_SET_NEXT_INDEX_PG_CLASS_OID: Oid = Oid(3587);
pub const F_BINARY_UPGRADE_SET_NEXT_TOAST_PG_CLASS_OID: Oid = Oid(3588);
pub const F_BINARY_UPGRADE_SET_NEXT_PG_ENUM_OID: Oid = Oid(3589);
pub const F_BINARY_UPGRADE_SET_NEXT_PG_AUTHID_OID: Oid = Oid(3590);
pub const F_BINARY_UPGRADE_CREATE_EMPTY_EXTENSION: u32 = 3591;
pub const F_EVENT_TRIGGER_IN: u32 = 3594;
pub const F_EVENT_TRIGGER_OUT: u32 = 3595;
pub const F_TSVECTORIN: u32 = 3610;
pub const F_TSVECTOROUT: u32 = 3611;
pub const F_TSQUERYIN: u32 = 3612;
pub const F_TSQUERYOUT: u32 = 3613;
pub const F_TSVECTOR_LT: u32 = 3616;
pub const F_TSVECTOR_LE: u32 = 3617;
pub const F_TSVECTOR_EQ: u32 = 3618;
pub const F_TSVECTOR_NE: u32 = 3619;
pub const F_TSVECTOR_GE: u32 = 3620;
pub const F_TSVECTOR_GT: u32 = 3621;
pub const F_TSVECTOR_CMP: u32 = 3622;
pub const F_STRIP: u32 = 3623;
pub const F_SETWEIGHT_TSVECTOR_CHAR: u32 = 3624;
pub const F_TSVECTOR_CONCAT: u32 = 3625;
pub const F_TS_MATCH_VQ: u32 = 3634;
pub const F_TS_MATCH_QV: u32 = 3635;
pub const F_TSVECTORSEND: u32 = 3638;
pub const F_TSVECTORRECV: u32 = 3639;
pub const F_TSQUERYSEND: u32 = 3640;
pub const F_TSQUERYRECV: u32 = 3641;
pub const F_GTSVECTORIN: u32 = 3646;
pub const F_GTSVECTOROUT: u32 = 3647;
pub const F_GTSVECTOR_COMPRESS: u32 = 3648;
pub const F_GTSVECTOR_DECOMPRESS: u32 = 3649;
pub const F_GTSVECTOR_PICKSPLIT: u32 = 3650;
pub const F_GTSVECTOR_UNION: u32 = 3651;
pub const F_GTSVECTOR_SAME: u32 = 3652;
pub const F_GTSVECTOR_PENALTY: u32 = 3653;
pub const F_GTSVECTOR_CONSISTENT_INTERNAL_TSVECTOR_INT2_OID_INTERNAL: u32 = 3654;
pub const F_GIN_EXTRACT_TSVECTOR_TSVECTOR_INTERNAL_INTERNAL: u32 = 3656;
pub const F_GIN_EXTRACT_TSQUERY_TSVECTOR_INTERNAL_INT2_INTERNAL_INTERNAL_INTERNAL_INTERNAL: u32 =
    3657;
pub const F_GIN_TSQUERY_CONSISTENT_INTERNAL_INT2_TSVECTOR_INT4_INTERNAL_INTERNAL_INTERNAL_INTERNAL : u32 = 3658 ;
pub const F_TSQUERY_LT: u32 = 3662;
pub const F_TSQUERY_LE: u32 = 3663;
pub const F_TSQUERY_EQ: u32 = 3664;
pub const F_TSQUERY_NE: u32 = 3665;
pub const F_TSQUERY_GE: u32 = 3666;
pub const F_TSQUERY_GT: u32 = 3667;
pub const F_TSQUERY_CMP: u32 = 3668;
pub const F_TSQUERY_AND: u32 = 3669;
pub const F_TSQUERY_OR: u32 = 3670;
pub const F_TSQUERY_NOT: u32 = 3671;
pub const F_NUMNODE: u32 = 3672;
pub const F_QUERYTREE: u32 = 3673;
pub const F_TS_REWRITE_TSQUERY_TSQUERY_TSQUERY: u32 = 3684;
pub const F_TS_REWRITE_TSQUERY_TEXT: u32 = 3685;
pub const F_TSMATCHSEL: u32 = 3686;
pub const F_TSMATCHJOINSEL: u32 = 3687;
pub const F_TS_TYPANALYZE: u32 = 3688;
pub const F_TS_STAT_TEXT: u32 = 3689;
pub const F_TS_STAT_TEXT_TEXT: u32 = 3690;
pub const F_TSQ_MCONTAINS: u32 = 3691;
pub const F_TSQ_MCONTAINED: u32 = 3692;
pub const F_GTSQUERY_COMPRESS: u32 = 3695;
pub const F_STARTS_WITH: u32 = 3696;
pub const F_GTSQUERY_PICKSPLIT: u32 = 3697;
pub const F_GTSQUERY_UNION: u32 = 3698;
pub const F_GTSQUERY_SAME: u32 = 3699;
pub const F_GTSQUERY_PENALTY: u32 = 3700;
pub const F_GTSQUERY_CONSISTENT_INTERNAL_TSQUERY_INT2_OID_INTERNAL: u32 = 3701;
pub const F_TS_RANK__FLOAT4_TSVECTOR_TSQUERY_INT4: u32 = 3703;
pub const F_TS_RANK__FLOAT4_TSVECTOR_TSQUERY: u32 = 3704;
pub const F_TS_RANK_TSVECTOR_TSQUERY_INT4: u32 = 3705;
pub const F_TS_RANK_TSVECTOR_TSQUERY: u32 = 3706;
pub const F_TS_RANK_CD__FLOAT4_TSVECTOR_TSQUERY_INT4: u32 = 3707;
pub const F_TS_RANK_CD__FLOAT4_TSVECTOR_TSQUERY: u32 = 3708;
pub const F_TS_RANK_CD_TSVECTOR_TSQUERY_INT4: u32 = 3709;
pub const F_TS_RANK_CD_TSVECTOR_TSQUERY: u32 = 3710;
pub const F_LENGTH_TSVECTOR: u32 = 3711;
pub const F_TS_TOKEN_TYPE_OID: Oid = Oid(3713);
pub const F_TS_TOKEN_TYPE_TEXT: u32 = 3714;
pub const F_TS_PARSE_OID_TEXT: u32 = 3715;
pub const F_TS_PARSE_TEXT_TEXT: u32 = 3716;
pub const F_PRSD_START: u32 = 3717;
pub const F_PRSD_NEXTTOKEN: u32 = 3718;
pub const F_PRSD_END: u32 = 3719;
pub const F_PRSD_HEADLINE: u32 = 3720;
pub const F_PRSD_LEXTYPE: u32 = 3721;
pub const F_TS_LEXIZE: u32 = 3723;
pub const F_GIN_CMP_TSLEXEME: u32 = 3724;
pub const F_DSIMPLE_INIT: u32 = 3725;
pub const F_DSIMPLE_LEXIZE: u32 = 3726;
pub const F_DSYNONYM_INIT: u32 = 3728;
pub const F_DSYNONYM_LEXIZE: u32 = 3729;
pub const F_DISPELL_INIT: u32 = 3731;
pub const F_DISPELL_LEXIZE: u32 = 3732;
pub const F_REGCONFIGIN: u32 = 3736;
pub const F_REGCONFIGOUT: u32 = 3737;
pub const F_REGCONFIGRECV: u32 = 3738;
pub const F_REGCONFIGSEND: u32 = 3739;
pub const F_THESAURUS_INIT: u32 = 3740;
pub const F_THESAURUS_LEXIZE: u32 = 3741;
pub const F_TS_HEADLINE_REGCONFIG_TEXT_TSQUERY_TEXT: u32 = 3743;
pub const F_TS_HEADLINE_REGCONFIG_TEXT_TSQUERY: u32 = 3744;
pub const F_TO_TSVECTOR_REGCONFIG_TEXT: u32 = 3745;
pub const F_TO_TSQUERY_REGCONFIG_TEXT: u32 = 3746;
pub const F_PLAINTO_TSQUERY_REGCONFIG_TEXT: u32 = 3747;
pub const F_TO_TSVECTOR_TEXT: u32 = 3749;
pub const F_TO_TSQUERY_TEXT: u32 = 3750;
pub const F_PLAINTO_TSQUERY_TEXT: u32 = 3751;
pub const F_TSVECTOR_UPDATE_TRIGGER: u32 = 3752;
pub const F_TSVECTOR_UPDATE_TRIGGER_COLUMN: u32 = 3753;
pub const F_TS_HEADLINE_TEXT_TSQUERY_TEXT: u32 = 3754;
pub const F_TS_HEADLINE_TEXT_TSQUERY: u32 = 3755;
pub const F_PG_TS_PARSER_IS_VISIBLE: u32 = 3756;
pub const F_PG_TS_DICT_IS_VISIBLE: u32 = 3757;
pub const F_PG_TS_CONFIG_IS_VISIBLE: u32 = 3758;
pub const F_GET_CURRENT_TS_CONFIG: u32 = 3759;
pub const F_TS_MATCH_TT: u32 = 3760;
pub const F_TS_MATCH_TQ: u32 = 3761;
pub const F_PG_TS_TEMPLATE_IS_VISIBLE: u32 = 3768;
pub const F_REGDICTIONARYIN: u32 = 3771;
pub const F_REGDICTIONARYOUT: u32 = 3772;
pub const F_REGDICTIONARYRECV: u32 = 3773;
pub const F_REGDICTIONARYSEND: u32 = 3774;
pub const F_PG_STAT_RESET_SHARED: u32 = 3775;
pub const F_PG_STAT_RESET_SINGLE_TABLE_COUNTERS: u32 = 3776;
pub const F_PG_STAT_RESET_SINGLE_FUNCTION_COUNTERS: u32 = 3777;
pub const F_PG_TABLESPACE_LOCATION: u32 = 3778;
pub const F_PG_CREATE_PHYSICAL_REPLICATION_SLOT: u32 = 3779;
pub const F_PG_DROP_REPLICATION_SLOT: u32 = 3780;
pub const F_PG_GET_REPLICATION_SLOTS: u32 = 3781;
pub const F_PG_LOGICAL_SLOT_GET_CHANGES: u32 = 3782;
pub const F_PG_LOGICAL_SLOT_GET_BINARY_CHANGES: u32 = 3783;
pub const F_PG_LOGICAL_SLOT_PEEK_CHANGES: u32 = 3784;
pub const F_PG_LOGICAL_SLOT_PEEK_BINARY_CHANGES: u32 = 3785;
pub const F_PG_CREATE_LOGICAL_REPLICATION_SLOT: u32 = 3786;
pub const F_TO_JSONB: u32 = 3787;
pub const F_PG_STAT_GET_SNAPSHOT_TIMESTAMP: u32 = 3788;
pub const F_GIN_CLEAN_PENDING_LIST: u32 = 3789;
pub const F_GTSVECTOR_CONSISTENT_INTERNAL_GTSVECTOR_INT4_OID_INTERNAL: u32 = 3790;
pub const F_GIN_EXTRACT_TSQUERY_TSQUERY_INTERNAL_INT2_INTERNAL_INTERNAL_INTERNAL_INTERNAL: u32 =
    3791;
pub const F_GIN_TSQUERY_CONSISTENT_INTERNAL_INT2_TSQUERY_INT4_INTERNAL_INTERNAL_INTERNAL_INTERNAL : u32 = 3792 ;
pub const F_GTSQUERY_CONSISTENT_INTERNAL_INTERNAL_INT4_OID_INTERNAL: u32 = 3793;
pub const F_INET_SPG_CONFIG: u32 = 3795;
pub const F_INET_SPG_CHOOSE: u32 = 3796;
pub const F_INET_SPG_PICKSPLIT: u32 = 3797;
pub const F_INET_SPG_INNER_CONSISTENT: u32 = 3798;
pub const F_INET_SPG_LEAF_CONSISTENT: u32 = 3799;
pub const F_PG_CURRENT_LOGFILE_: u32 = 3800;
pub const F_PG_CURRENT_LOGFILE_TEXT: u32 = 3801;
pub const F_JSONB_SEND: u32 = 3803;
pub const F_JSONB_OUT: u32 = 3804;
pub const F_JSONB_RECV: u32 = 3805;
pub const F_JSONB_IN: u32 = 3806;
pub const F_PG_GET_FUNCTION_ARG_DEFAULT: u32 = 3808;
pub const F_PG_EXPORT_SNAPSHOT: u32 = 3809;
pub const F_PG_IS_IN_RECOVERY: u32 = 3810;
pub const F_MONEY_INT4: u32 = 3811;
pub const F_MONEY_INT8: u32 = 3812;
pub const F_PG_COLLATION_IS_VISIBLE: u32 = 3815;
pub const F_ARRAY_TYPANALYZE: u32 = 3816;
pub const F_ARRAYCONTSEL: u32 = 3817;
pub const F_ARRAYCONTJOINSEL: u32 = 3818;
pub const F_PG_GET_MULTIXACT_MEMBERS: u32 = 3819;
pub const F_PG_LAST_WAL_RECEIVE_LSN: u32 = 3820;
pub const F_PG_LAST_WAL_REPLAY_LSN: u32 = 3821;
pub const F_CASH_DIV_CASH: u32 = 3822;
pub const F_NUMERIC_MONEY: u32 = 3823;
pub const F_MONEY_NUMERIC: u32 = 3824;
pub const F_PG_READ_FILE_TEXT: u32 = 3826;
pub const F_PG_READ_BINARY_FILE_TEXT_INT8_INT8: u32 = 3827;
pub const F_PG_READ_BINARY_FILE_TEXT: u32 = 3828;
pub const F_PG_OPFAMILY_IS_VISIBLE: u32 = 3829;
pub const F_PG_LAST_XACT_REPLAY_TIMESTAMP: u32 = 3830;
pub const F_ANYRANGE_IN: u32 = 3832;
pub const F_ANYRANGE_OUT: u32 = 3833;
pub const F_RANGE_IN: u32 = 3834;
pub const F_RANGE_OUT: u32 = 3835;
pub const F_RANGE_RECV: u32 = 3836;
pub const F_RANGE_SEND: u32 = 3837;
pub const F_PG_IDENTIFY_OBJECT: u32 = 3839;
pub const F_INT4RANGE_INT4_INT4: u32 = 3840;
pub const F_INT4RANGE_INT4_INT4_TEXT: u32 = 3841;
pub const F_PG_RELATION_IS_UPDATABLE: u32 = 3842;
pub const F_PG_COLUMN_IS_UPDATABLE: u32 = 3843;
pub const F_NUMRANGE_NUMERIC_NUMERIC: u32 = 3844;
pub const F_NUMRANGE_NUMERIC_NUMERIC_TEXT: u32 = 3845;
pub const F_MAKE_DATE: u32 = 3846;
pub const F_MAKE_TIME: u32 = 3847;
pub const F_LOWER_ANYRANGE: u32 = 3848;
pub const F_UPPER_ANYRANGE: u32 = 3849;
pub const F_ISEMPTY_ANYRANGE: u32 = 3850;
pub const F_LOWER_INC_ANYRANGE: u32 = 3851;
pub const F_UPPER_INC_ANYRANGE: u32 = 3852;
pub const F_LOWER_INF_ANYRANGE: u32 = 3853;
pub const F_UPPER_INF_ANYRANGE: u32 = 3854;
pub const F_RANGE_EQ: u32 = 3855;
pub const F_RANGE_NE: u32 = 3856;
pub const F_RANGE_OVERLAPS: u32 = 3857;
pub const F_RANGE_CONTAINS_ELEM: u32 = 3858;
pub const F_RANGE_CONTAINS: u32 = 3859;
pub const F_ELEM_CONTAINED_BY_RANGE: u32 = 3860;
pub const F_RANGE_CONTAINED_BY: u32 = 3861;
pub const F_RANGE_ADJACENT: u32 = 3862;
pub const F_RANGE_BEFORE: u32 = 3863;
pub const F_RANGE_AFTER: u32 = 3864;
pub const F_RANGE_OVERLEFT: u32 = 3865;
pub const F_RANGE_OVERRIGHT: u32 = 3866;
pub const F_RANGE_UNION: u32 = 3867;
pub const F_RANGE_INTERSECT: u32 = 3868;
pub const F_RANGE_MINUS: u32 = 3869;
pub const F_RANGE_CMP: u32 = 3870;
pub const F_RANGE_LT: u32 = 3871;
pub const F_RANGE_LE: u32 = 3872;
pub const F_RANGE_GE: u32 = 3873;
pub const F_RANGE_GT: u32 = 3874;
pub const F_RANGE_GIST_CONSISTENT: u32 = 3875;
pub const F_RANGE_GIST_UNION: u32 = 3876;
pub const F_PG_REPLICATION_SLOT_ADVANCE: u32 = 3878;
pub const F_RANGE_GIST_PENALTY: u32 = 3879;
pub const F_RANGE_GIST_PICKSPLIT: u32 = 3880;
pub const F_RANGE_GIST_SAME: u32 = 3881;
pub const F_HASH_RANGE: u32 = 3902;
pub const F_INT4RANGE_CANONICAL: u32 = 3914;
pub const F_DATERANGE_CANONICAL: u32 = 3915;
pub const F_RANGE_TYPANALYZE: u32 = 3916;
pub const F_TIMESTAMP_SUPPORT: u32 = 3917;
pub const F_INTERVAL_SUPPORT: u32 = 3918;
pub const F_GINARRAYTRICONSISTENT: u32 = 3920;
pub const F_GIN_TSQUERY_TRICONSISTENT: u32 = 3921;
pub const F_INT4RANGE_SUBDIFF: u32 = 3922;
pub const F_INT8RANGE_SUBDIFF: u32 = 3923;
pub const F_NUMRANGE_SUBDIFF: u32 = 3924;
pub const F_DATERANGE_SUBDIFF: u32 = 3925;
pub const F_INT8RANGE_CANONICAL: u32 = 3928;
pub const F_TSRANGE_SUBDIFF: u32 = 3929;
pub const F_TSTZRANGE_SUBDIFF: u32 = 3930;
pub const F_JSONB_OBJECT_KEYS: u32 = 3931;
pub const F_JSONB_EACH_TEXT: u32 = 3932;
pub const F_TSRANGE_TIMESTAMP_TIMESTAMP: u32 = 3933;
pub const F_TSRANGE_TIMESTAMP_TIMESTAMP_TEXT: u32 = 3934;
pub const F_PG_SLEEP_FOR: u32 = 3935;
pub const F_PG_SLEEP_UNTIL: u32 = 3936;
pub const F_TSTZRANGE_TIMESTAMPTZ_TIMESTAMPTZ: u32 = 3937;
pub const F_TSTZRANGE_TIMESTAMPTZ_TIMESTAMPTZ_TEXT: u32 = 3938;
pub const F_MXID_AGE: u32 = 3939;
pub const F_JSONB_EXTRACT_PATH_TEXT: u32 = 3940;
pub const F_DATERANGE_DATE_DATE: u32 = 3941;
pub const F_DATERANGE_DATE_DATE_TEXT: u32 = 3942;
pub const F_ACLDEFAULT: u32 = 3943;
pub const F_TIME_SUPPORT: u32 = 3944;
pub const F_INT8RANGE_INT8_INT8: u32 = 3945;
pub const F_INT8RANGE_INT8_INT8_TEXT: u32 = 3946;
pub const F_JSON_OBJECT_FIELD: u32 = 3947;
pub const F_JSON_OBJECT_FIELD_TEXT: u32 = 3948;
pub const F_JSON_ARRAY_ELEMENT: u32 = 3949;
pub const F_JSON_ARRAY_ELEMENT_TEXT: u32 = 3950;
pub const F_JSON_EXTRACT_PATH: u32 = 3951;
pub const F_BRIN_SUMMARIZE_NEW_VALUES: u32 = 3952;
pub const F_JSON_EXTRACT_PATH_TEXT: u32 = 3953;
pub const F_PG_GET_OBJECT_ADDRESS: u32 = 3954;
pub const F_JSON_ARRAY_ELEMENTS: u32 = 3955;
pub const F_JSON_ARRAY_LENGTH: u32 = 3956;
pub const F_JSON_OBJECT_KEYS: u32 = 3957;
pub const F_JSON_EACH: u32 = 3958;
pub const F_JSON_EACH_TEXT: u32 = 3959;
pub const F_JSON_POPULATE_RECORD: u32 = 3960;
pub const F_JSON_POPULATE_RECORDSET: u32 = 3961;
pub const F_JSON_TYPEOF: u32 = 3968;
pub const F_JSON_ARRAY_ELEMENTS_TEXT: u32 = 3969;
pub const F_ORDERED_SET_TRANSITION: u32 = 3970;
pub const F_ORDERED_SET_TRANSITION_MULTI: u32 = 3971;
pub const F_PERCENTILE_DISC_FLOAT8_ANYELEMENT: u32 = 3972;
pub const F_PERCENTILE_DISC_FINAL: u32 = 3973;
pub const F_PERCENTILE_CONT_FLOAT8_FLOAT8: u32 = 3974;
pub const F_PERCENTILE_CONT_FLOAT8_FINAL: u32 = 3975;
pub const F_PERCENTILE_CONT_FLOAT8_INTERVAL: u32 = 3976;
pub const F_PERCENTILE_CONT_INTERVAL_FINAL: u32 = 3977;
pub const F_PERCENTILE_DISC__FLOAT8_ANYELEMENT: u32 = 3978;
pub const F_PERCENTILE_DISC_MULTI_FINAL: u32 = 3979;
pub const F_PERCENTILE_CONT__FLOAT8_FLOAT8: u32 = 3980;
pub const F_PERCENTILE_CONT_FLOAT8_MULTI_FINAL: u32 = 3981;
pub const F_PERCENTILE_CONT__FLOAT8_INTERVAL: u32 = 3982;
pub const F_PERCENTILE_CONT_INTERVAL_MULTI_FINAL: u32 = 3983;
pub const F_MODE: u32 = 3984;
pub const F_MODE_FINAL: u32 = 3985;
pub const F_RANK_ANY: u32 = 3986;
pub const F_RANK_FINAL: u32 = 3987;
pub const F_PERCENT_RANK_ANY: u32 = 3988;
pub const F_PERCENT_RANK_FINAL: u32 = 3989;
pub const F_CUME_DIST_ANY: u32 = 3990;
pub const F_CUME_DIST_FINAL: u32 = 3991;
pub const F_DENSE_RANK_ANY: u32 = 3992;
pub const F_DENSE_RANK_FINAL: u32 = 3993;
pub const F_GENERATE_SERIES_INT4_SUPPORT: u32 = 3994;
pub const F_GENERATE_SERIES_INT8_SUPPORT: u32 = 3995;
pub const F_ARRAY_UNNEST_SUPPORT: u32 = 3996;
pub const F_GIST_BOX_DISTANCE: u32 = 3998;
pub const F_BRIN_SUMMARIZE_RANGE: u32 = 3999;
pub const F_JSONPATH_IN: u32 = 4001;
pub const F_JSONPATH_RECV: u32 = 4002;
pub const F_JSONPATH_OUT: u32 = 4003;
pub const F_JSONPATH_SEND: u32 = 4004;
pub const F_JSONB_PATH_EXISTS: u32 = 4005;
pub const F_JSONB_PATH_QUERY: u32 = 4006;
pub const F_JSONB_PATH_QUERY_ARRAY: u32 = 4007;
pub const F_JSONB_PATH_QUERY_FIRST: u32 = 4008;
pub const F_JSONB_PATH_MATCH: u32 = 4009;
pub const F_JSONB_PATH_EXISTS_OPR: u32 = 4010;
pub const F_JSONB_PATH_MATCH_OPR: u32 = 4011;
pub const F_BRIN_DESUMMARIZE_RANGE: u32 = 4014;
pub const F_SPG_QUAD_CONFIG: u32 = 4018;
pub const F_SPG_QUAD_CHOOSE: u32 = 4019;
pub const F_SPG_QUAD_PICKSPLIT: u32 = 4020;
pub const F_SPG_QUAD_INNER_CONSISTENT: u32 = 4021;
pub const F_SPG_QUAD_LEAF_CONSISTENT: u32 = 4022;
pub const F_SPG_KD_CONFIG: u32 = 4023;
pub const F_SPG_KD_CHOOSE: u32 = 4024;
pub const F_SPG_KD_PICKSPLIT: u32 = 4025;
pub const F_SPG_KD_INNER_CONSISTENT: u32 = 4026;
pub const F_SPG_TEXT_CONFIG: u32 = 4027;
pub const F_SPG_TEXT_CHOOSE: u32 = 4028;
pub const F_SPG_TEXT_PICKSPLIT: u32 = 4029;
pub const F_SPG_TEXT_INNER_CONSISTENT: u32 = 4030;
pub const F_SPG_TEXT_LEAF_CONSISTENT: u32 = 4031;
pub const F_PG_SEQUENCE_LAST_VALUE: u32 = 4032;
pub const F_JSONB_NE: u32 = 4038;
pub const F_JSONB_LT: u32 = 4039;
pub const F_JSONB_GT: u32 = 4040;
pub const F_JSONB_LE: u32 = 4041;
pub const F_JSONB_GE: u32 = 4042;
pub const F_JSONB_EQ: u32 = 4043;
pub const F_JSONB_CMP: u32 = 4044;
pub const F_JSONB_HASH: u32 = 4045;
pub const F_JSONB_CONTAINS: u32 = 4046;
pub const F_JSONB_EXISTS: u32 = 4047;
pub const F_JSONB_EXISTS_ANY: u32 = 4048;
pub const F_JSONB_EXISTS_ALL: u32 = 4049;
pub const F_JSONB_CONTAINED: u32 = 4050;
pub const F_ARRAY_AGG_ARRAY_TRANSFN: u32 = 4051;
pub const F_ARRAY_AGG_ARRAY_FINALFN: u32 = 4052;
pub const F_ARRAY_AGG_ANYARRAY: u32 = 4053;
pub const F_RANGE_MERGE_ANYRANGE_ANYRANGE: u32 = 4057;
pub const F_INET_MERGE: u32 = 4063;
pub const F_BOUND_BOX: u32 = 4067;
pub const F_INET_SAME_FAMILY: u32 = 4071;
pub const F_BINARY_UPGRADE_SET_RECORD_INIT_PRIVS: u32 = 4083;
pub const F_REGNAMESPACEIN: u32 = 4084;
pub const F_REGNAMESPACEOUT: u32 = 4085;
pub const F_TO_REGNAMESPACE: u32 = 4086;
pub const F_REGNAMESPACERECV: u32 = 4087;
pub const F_REGNAMESPACESEND: u32 = 4088;
pub const F_BOX_POINT: u32 = 4091;
pub const F_REGROLEOUT: u32 = 4092;
pub const F_TO_REGROLE: u32 = 4093;
pub const F_REGROLERECV: u32 = 4094;
pub const F_REGROLESEND: u32 = 4095;
pub const F_REGROLEIN: u32 = 4098;
pub const F_PG_ROTATE_LOGFILE_OLD: u32 = 4099;
pub const F_PG_READ_FILE_OLD: u32 = 4100;
pub const F_BINARY_UPGRADE_SET_MISSING_VALUE: u32 = 4101;
pub const F_BRIN_INCLUSION_OPCINFO: u32 = 4105;
pub const F_BRIN_INCLUSION_ADD_VALUE: u32 = 4106;
pub const F_BRIN_INCLUSION_CONSISTENT: u32 = 4107;
pub const F_BRIN_INCLUSION_UNION: u32 = 4108;
pub const F_MACADDR8_IN: u32 = 4110;
pub const F_MACADDR8_OUT: u32 = 4111;
pub const F_TRUNC_MACADDR8: u32 = 4112;
pub const F_MACADDR8_EQ: u32 = 4113;
pub const F_MACADDR8_LT: u32 = 4114;
pub const F_MACADDR8_LE: u32 = 4115;
pub const F_MACADDR8_GT: u32 = 4116;
pub const F_MACADDR8_GE: u32 = 4117;
pub const F_MACADDR8_NE: u32 = 4118;
pub const F_MACADDR8_CMP: u32 = 4119;
pub const F_MACADDR8_NOT: u32 = 4120;
pub const F_MACADDR8_AND: u32 = 4121;
pub const F_MACADDR8_OR: u32 = 4122;
pub const F_MACADDR8: u32 = 4123;
pub const F_MACADDR: u32 = 4124;
pub const F_MACADDR8_SET7BIT: u32 = 4125;
pub const F_IN_RANGE_INT8_INT8_INT8_BOOL_BOOL: u32 = 4126;
pub const F_IN_RANGE_INT4_INT4_INT8_BOOL_BOOL: u32 = 4127;
pub const F_IN_RANGE_INT4_INT4_INT4_BOOL_BOOL: u32 = 4128;
pub const F_IN_RANGE_INT4_INT4_INT2_BOOL_BOOL: u32 = 4129;
pub const F_IN_RANGE_INT2_INT2_INT8_BOOL_BOOL: u32 = 4130;
pub const F_IN_RANGE_INT2_INT2_INT4_BOOL_BOOL: u32 = 4131;
pub const F_IN_RANGE_INT2_INT2_INT2_BOOL_BOOL: u32 = 4132;
pub const F_IN_RANGE_DATE_DATE_INTERVAL_BOOL_BOOL: u32 = 4133;
pub const F_IN_RANGE_TIMESTAMP_TIMESTAMP_INTERVAL_BOOL_BOOL: u32 = 4134;
pub const F_IN_RANGE_TIMESTAMPTZ_TIMESTAMPTZ_INTERVAL_BOOL_BOOL: u32 = 4135;
pub const F_IN_RANGE_INTERVAL_INTERVAL_INTERVAL_BOOL_BOOL: u32 = 4136;
pub const F_IN_RANGE_TIME_TIME_INTERVAL_BOOL_BOOL: u32 = 4137;
pub const F_IN_RANGE_TIMETZ_TIMETZ_INTERVAL_BOOL_BOOL: u32 = 4138;
pub const F_IN_RANGE_FLOAT8_FLOAT8_FLOAT8_BOOL_BOOL: u32 = 4139;
pub const F_IN_RANGE_FLOAT4_FLOAT4_FLOAT8_BOOL_BOOL: u32 = 4140;
pub const F_IN_RANGE_NUMERIC_NUMERIC_NUMERIC_BOOL_BOOL: u32 = 4141;
pub const F_PG_LSN_LARGER: u32 = 4187;
pub const F_PG_LSN_SMALLER: u32 = 4188;
pub const F_MAX_PG_LSN: u32 = 4189;
pub const F_MIN_PG_LSN: u32 = 4190;
pub const F_REGCOLLATIONIN: u32 = 4193;
pub const F_REGCOLLATIONOUT: u32 = 4194;
pub const F_TO_REGCOLLATION: u32 = 4195;
pub const F_REGCOLLATIONRECV: u32 = 4196;
pub const F_REGCOLLATIONSEND: u32 = 4197;
pub const F_TS_HEADLINE_REGCONFIG_JSONB_TSQUERY_TEXT: u32 = 4201;
pub const F_TS_HEADLINE_REGCONFIG_JSONB_TSQUERY: u32 = 4202;
pub const F_TS_HEADLINE_JSONB_TSQUERY_TEXT: u32 = 4203;
pub const F_TS_HEADLINE_JSONB_TSQUERY: u32 = 4204;
pub const F_TS_HEADLINE_REGCONFIG_JSON_TSQUERY_TEXT: u32 = 4205;
pub const F_TS_HEADLINE_REGCONFIG_JSON_TSQUERY: u32 = 4206;
pub const F_TS_HEADLINE_JSON_TSQUERY_TEXT: u32 = 4207;
pub const F_TS_HEADLINE_JSON_TSQUERY: u32 = 4208;
pub const F_TO_TSVECTOR_JSONB: u32 = 4209;
pub const F_TO_TSVECTOR_JSON: u32 = 4210;
pub const F_TO_TSVECTOR_REGCONFIG_JSONB: u32 = 4211;
pub const F_TO_TSVECTOR_REGCONFIG_JSON: u32 = 4212;
pub const F_JSONB_TO_TSVECTOR_JSONB_JSONB: u32 = 4213;
pub const F_JSONB_TO_TSVECTOR_REGCONFIG_JSONB_JSONB: u32 = 4214;
pub const F_JSON_TO_TSVECTOR_JSON_JSONB: u32 = 4215;
pub const F_JSON_TO_TSVECTOR_REGCONFIG_JSON_JSONB: u32 = 4216;
pub const F_PG_COPY_PHYSICAL_REPLICATION_SLOT_NAME_NAME_BOOL: u32 = 4220;
pub const F_PG_COPY_PHYSICAL_REPLICATION_SLOT_NAME_NAME: u32 = 4221;
pub const F_PG_COPY_LOGICAL_REPLICATION_SLOT_NAME_NAME_BOOL_NAME: u32 = 4222;
pub const F_PG_COPY_LOGICAL_REPLICATION_SLOT_NAME_NAME_BOOL: u32 = 4223;
pub const F_PG_COPY_LOGICAL_REPLICATION_SLOT_NAME_NAME: u32 = 4224;
pub const F_ANYCOMPATIBLEMULTIRANGE_IN: u32 = 4226;
pub const F_ANYCOMPATIBLEMULTIRANGE_OUT: u32 = 4227;
pub const F_RANGE_MERGE_ANYMULTIRANGE: u32 = 4228;
pub const F_ANYMULTIRANGE_IN: u32 = 4229;
pub const F_ANYMULTIRANGE_OUT: u32 = 4230;
pub const F_MULTIRANGE_IN: u32 = 4231;
pub const F_MULTIRANGE_OUT: u32 = 4232;
pub const F_MULTIRANGE_RECV: u32 = 4233;
pub const F_MULTIRANGE_SEND: u32 = 4234;
pub const F_LOWER_ANYMULTIRANGE: u32 = 4235;
pub const F_UPPER_ANYMULTIRANGE: u32 = 4236;
pub const F_ISEMPTY_ANYMULTIRANGE: u32 = 4237;
pub const F_LOWER_INC_ANYMULTIRANGE: u32 = 4238;
pub const F_UPPER_INC_ANYMULTIRANGE: u32 = 4239;
pub const F_LOWER_INF_ANYMULTIRANGE: u32 = 4240;
pub const F_UPPER_INF_ANYMULTIRANGE: u32 = 4241;
pub const F_MULTIRANGE_TYPANALYZE: u32 = 4242;
pub const F_MULTIRANGESEL: u32 = 4243;
pub const F_MULTIRANGE_EQ: u32 = 4244;
pub const F_MULTIRANGE_NE: u32 = 4245;
pub const F_RANGE_OVERLAPS_MULTIRANGE: u32 = 4246;
pub const F_MULTIRANGE_OVERLAPS_RANGE: u32 = 4247;
pub const F_MULTIRANGE_OVERLAPS_MULTIRANGE: u32 = 4248;
pub const F_MULTIRANGE_CONTAINS_ELEM: u32 = 4249;
pub const F_MULTIRANGE_CONTAINS_RANGE: u32 = 4250;
pub const F_MULTIRANGE_CONTAINS_MULTIRANGE: u32 = 4251;
pub const F_ELEM_CONTAINED_BY_MULTIRANGE: u32 = 4252;
pub const F_RANGE_CONTAINED_BY_MULTIRANGE: u32 = 4253;
pub const F_MULTIRANGE_CONTAINED_BY_MULTIRANGE: u32 = 4254;
pub const F_RANGE_ADJACENT_MULTIRANGE: u32 = 4255;
pub const F_MULTIRANGE_ADJACENT_MULTIRANGE: u32 = 4256;
pub const F_MULTIRANGE_ADJACENT_RANGE: u32 = 4257;
pub const F_RANGE_BEFORE_MULTIRANGE: u32 = 4258;
pub const F_MULTIRANGE_BEFORE_RANGE: u32 = 4259;
pub const F_MULTIRANGE_BEFORE_MULTIRANGE: u32 = 4260;
pub const F_RANGE_AFTER_MULTIRANGE: u32 = 4261;
pub const F_MULTIRANGE_AFTER_RANGE: u32 = 4262;
pub const F_MULTIRANGE_AFTER_MULTIRANGE: u32 = 4263;
pub const F_RANGE_OVERLEFT_MULTIRANGE: u32 = 4264;
pub const F_MULTIRANGE_OVERLEFT_RANGE: u32 = 4265;
pub const F_MULTIRANGE_OVERLEFT_MULTIRANGE: u32 = 4266;
pub const F_RANGE_OVERRIGHT_MULTIRANGE: u32 = 4267;
pub const F_MULTIRANGE_OVERRIGHT_RANGE: u32 = 4268;
pub const F_MULTIRANGE_OVERRIGHT_MULTIRANGE: u32 = 4269;
pub const F_MULTIRANGE_UNION: u32 = 4270;
pub const F_MULTIRANGE_MINUS: u32 = 4271;
pub const F_MULTIRANGE_INTERSECT: u32 = 4272;
pub const F_MULTIRANGE_CMP: u32 = 4273;
pub const F_MULTIRANGE_LT: u32 = 4274;
pub const F_MULTIRANGE_LE: u32 = 4275;
pub const F_MULTIRANGE_GE: u32 = 4276;
pub const F_MULTIRANGE_GT: u32 = 4277;
pub const F_HASH_MULTIRANGE: u32 = 4278;
pub const F_HASH_MULTIRANGE_EXTENDED: u32 = 4279;
pub const F_INT4MULTIRANGE_: u32 = 4280;
pub const F_INT4MULTIRANGE_INT4RANGE: u32 = 4281;
pub const F_INT4MULTIRANGE__INT4RANGE: u32 = 4282;
pub const F_NUMMULTIRANGE_: u32 = 4283;
pub const F_NUMMULTIRANGE_NUMRANGE: u32 = 4284;
pub const F_NUMMULTIRANGE__NUMRANGE: u32 = 4285;
pub const F_TSMULTIRANGE_: u32 = 4286;
pub const F_TSMULTIRANGE_TSRANGE: u32 = 4287;
pub const F_TSMULTIRANGE__TSRANGE: u32 = 4288;
pub const F_TSTZMULTIRANGE_: u32 = 4289;
pub const F_TSTZMULTIRANGE_TSTZRANGE: u32 = 4290;
pub const F_TSTZMULTIRANGE__TSTZRANGE: u32 = 4291;
pub const F_DATEMULTIRANGE_: u32 = 4292;
pub const F_DATEMULTIRANGE_DATERANGE: u32 = 4293;
pub const F_DATEMULTIRANGE__DATERANGE: u32 = 4294;
pub const F_INT8MULTIRANGE_: u32 = 4295;
pub const F_INT8MULTIRANGE_INT8RANGE: u32 = 4296;
pub const F_INT8MULTIRANGE__INT8RANGE: u32 = 4297;
pub const F_MULTIRANGE: u32 = 4298;
pub const F_RANGE_AGG_TRANSFN: u32 = 4299;
pub const F_RANGE_AGG_FINALFN: u32 = 4300;
pub const F_RANGE_AGG_ANYRANGE: u32 = 4301;
pub const F_KOI8R_TO_MIC: u32 = 4302;
pub const F_MIC_TO_KOI8R: u32 = 4303;
pub const F_ISO_TO_MIC: u32 = 4304;
pub const F_MIC_TO_ISO: u32 = 4305;
pub const F_WIN1251_TO_MIC: u32 = 4306;
pub const F_MIC_TO_WIN1251: u32 = 4307;
pub const F_WIN866_TO_MIC: u32 = 4308;
pub const F_MIC_TO_WIN866: u32 = 4309;
pub const F_KOI8R_TO_WIN1251: u32 = 4310;
pub const F_WIN1251_TO_KOI8R: u32 = 4311;
pub const F_KOI8R_TO_WIN866: u32 = 4312;
pub const F_WIN866_TO_KOI8R: u32 = 4313;
pub const F_WIN866_TO_WIN1251: u32 = 4314;
pub const F_WIN1251_TO_WIN866: u32 = 4315;
pub const F_ISO_TO_KOI8R: u32 = 4316;
pub const F_KOI8R_TO_ISO: u32 = 4317;
pub const F_ISO_TO_WIN1251: u32 = 4318;
pub const F_WIN1251_TO_ISO: u32 = 4319;
pub const F_ISO_TO_WIN866: u32 = 4320;
pub const F_WIN866_TO_ISO: u32 = 4321;
pub const F_EUC_CN_TO_MIC: u32 = 4322;
pub const F_MIC_TO_EUC_CN: u32 = 4323;
pub const F_EUC_JP_TO_SJIS: u32 = 4324;
pub const F_SJIS_TO_EUC_JP: u32 = 4325;
pub const F_EUC_JP_TO_MIC: u32 = 4326;
pub const F_SJIS_TO_MIC: u32 = 4327;
pub const F_MIC_TO_EUC_JP: u32 = 4328;
pub const F_MIC_TO_SJIS: u32 = 4329;
pub const F_EUC_KR_TO_MIC: u32 = 4330;
pub const F_MIC_TO_EUC_KR: u32 = 4331;
pub const F_EUC_TW_TO_BIG5: u32 = 4332;
pub const F_BIG5_TO_EUC_TW: u32 = 4333;
pub const F_EUC_TW_TO_MIC: u32 = 4334;
pub const F_BIG5_TO_MIC: u32 = 4335;
pub const F_MIC_TO_EUC_TW: u32 = 4336;
pub const F_MIC_TO_BIG5: u32 = 4337;
pub const F_LATIN2_TO_MIC: u32 = 4338;
pub const F_MIC_TO_LATIN2: u32 = 4339;
pub const F_WIN1250_TO_MIC: u32 = 4340;
pub const F_MIC_TO_WIN1250: u32 = 4341;
pub const F_LATIN2_TO_WIN1250: u32 = 4342;
pub const F_WIN1250_TO_LATIN2: u32 = 4343;
pub const F_LATIN1_TO_MIC: u32 = 4344;
pub const F_MIC_TO_LATIN1: u32 = 4345;
pub const F_LATIN3_TO_MIC: u32 = 4346;
pub const F_MIC_TO_LATIN3: u32 = 4347;
pub const F_LATIN4_TO_MIC: u32 = 4348;
pub const F_MIC_TO_LATIN4: u32 = 4349;
pub const F_NORMALIZE: u32 = 4350;
pub const F_IS_NORMALIZED: u32 = 4351;
pub const F_BIG5_TO_UTF8: u32 = 4352;
pub const F_UTF8_TO_BIG5: u32 = 4353;
pub const F_UTF8_TO_KOI8R: u32 = 4354;
pub const F_KOI8R_TO_UTF8: u32 = 4355;
pub const F_UTF8_TO_KOI8U: u32 = 4356;
pub const F_KOI8U_TO_UTF8: u32 = 4357;
pub const F_UTF8_TO_WIN: u32 = 4358;
pub const F_WIN_TO_UTF8: u32 = 4359;
pub const F_EUC_CN_TO_UTF8: u32 = 4360;
pub const F_UTF8_TO_EUC_CN: u32 = 4361;
pub const F_EUC_JP_TO_UTF8: u32 = 4362;
pub const F_UTF8_TO_EUC_JP: u32 = 4363;
pub const F_EUC_KR_TO_UTF8: u32 = 4364;
pub const F_UTF8_TO_EUC_KR: u32 = 4365;
pub const F_EUC_TW_TO_UTF8: u32 = 4366;
pub const F_UTF8_TO_EUC_TW: u32 = 4367;
pub const F_GB18030_TO_UTF8: u32 = 4368;
pub const F_UTF8_TO_GB18030: u32 = 4369;
pub const F_GBK_TO_UTF8: u32 = 4370;
pub const F_UTF8_TO_GBK: u32 = 4371;
pub const F_UTF8_TO_ISO8859: u32 = 4372;
pub const F_ISO8859_TO_UTF8: u32 = 4373;
pub const F_ISO8859_1_TO_UTF8: u32 = 4374;
pub const F_UTF8_TO_ISO8859_1: u32 = 4375;
pub const F_JOHAB_TO_UTF8: u32 = 4376;
pub const F_UTF8_TO_JOHAB: u32 = 4377;
pub const F_SJIS_TO_UTF8: u32 = 4378;
pub const F_UTF8_TO_SJIS: u32 = 4379;
pub const F_UHC_TO_UTF8: u32 = 4380;
pub const F_UTF8_TO_UHC: u32 = 4381;
pub const F_EUC_JIS_2004_TO_UTF8: u32 = 4382;
pub const F_UTF8_TO_EUC_JIS_2004: u32 = 4383;
pub const F_SHIFT_JIS_2004_TO_UTF8: u32 = 4384;
pub const F_UTF8_TO_SHIFT_JIS_2004: u32 = 4385;
pub const F_EUC_JIS_2004_TO_SHIFT_JIS_2004: u32 = 4386;
pub const F_SHIFT_JIS_2004_TO_EUC_JIS_2004: u32 = 4387;
pub const F_MULTIRANGE_INTERSECT_AGG_TRANSFN: u32 = 4388;
pub const F_RANGE_INTERSECT_AGG_ANYMULTIRANGE: u32 = 4389;
pub const F_BINARY_UPGRADE_SET_NEXT_MULTIRANGE_PG_TYPE_OID: Oid = Oid(4390);
pub const F_BINARY_UPGRADE_SET_NEXT_MULTIRANGE_ARRAY_PG_TYPE_OID: Oid = Oid(4391);
pub const F_RANGE_INTERSECT_AGG_TRANSFN: u32 = 4401;
pub const F_RANGE_INTERSECT_AGG_ANYRANGE: u32 = 4450;
pub const F_RANGE_CONTAINS_MULTIRANGE: u32 = 4541;
pub const F_MULTIRANGE_CONTAINED_BY_RANGE: u32 = 4542;
pub const F_PG_LOG_BACKEND_MEMORY_CONTEXTS: u32 = 4543;
pub const F_BINARY_UPGRADE_SET_NEXT_HEAP_RELFILENODE: u32 = 4545;
pub const F_BINARY_UPGRADE_SET_NEXT_INDEX_RELFILENODE: u32 = 4546;
pub const F_BINARY_UPGRADE_SET_NEXT_TOAST_RELFILENODE: u32 = 4547;
pub const F_BINARY_UPGRADE_SET_NEXT_PG_TABLESPACE_OID: Oid = Oid(4548);
pub const F_PG_EVENT_TRIGGER_TABLE_REWRITE_OID: Oid = Oid(4566);
pub const F_PG_EVENT_TRIGGER_TABLE_REWRITE_REASON: u32 = 4567;
pub const F_PG_EVENT_TRIGGER_DDL_COMMANDS: u32 = 4568;
pub const F_BRIN_BLOOM_OPCINFO: u32 = 4591;
pub const F_BRIN_BLOOM_ADD_VALUE: u32 = 4592;
pub const F_BRIN_BLOOM_CONSISTENT: u32 = 4593;
pub const F_BRIN_BLOOM_UNION: u32 = 4594;
pub const F_BRIN_BLOOM_OPTIONS: u32 = 4595;
pub const F_BRIN_BLOOM_SUMMARY_IN: u32 = 4596;
pub const F_BRIN_BLOOM_SUMMARY_OUT: u32 = 4597;
pub const F_BRIN_BLOOM_SUMMARY_RECV: u32 = 4598;
pub const F_BRIN_BLOOM_SUMMARY_SEND: u32 = 4599;
pub const F_BRIN_MINMAX_MULTI_OPCINFO: u32 = 4616;
pub const F_BRIN_MINMAX_MULTI_ADD_VALUE: u32 = 4617;
pub const F_BRIN_MINMAX_MULTI_CONSISTENT: u32 = 4618;
pub const F_BRIN_MINMAX_MULTI_UNION: u32 = 4619;
pub const F_BRIN_MINMAX_MULTI_OPTIONS: u32 = 4620;
pub const F_BRIN_MINMAX_MULTI_DISTANCE_INT2: u32 = 4621;
pub const F_BRIN_MINMAX_MULTI_DISTANCE_INT4: u32 = 4622;
pub const F_BRIN_MINMAX_MULTI_DISTANCE_INT8: u32 = 4623;
pub const F_BRIN_MINMAX_MULTI_DISTANCE_FLOAT4: u32 = 4624;
pub const F_BRIN_MINMAX_MULTI_DISTANCE_FLOAT8: u32 = 4625;
pub const F_BRIN_MINMAX_MULTI_DISTANCE_NUMERIC: u32 = 4626;
pub const F_BRIN_MINMAX_MULTI_DISTANCE_TID: u32 = 4627;
pub const F_BRIN_MINMAX_MULTI_DISTANCE_UUID: u32 = 4628;
pub const F_BRIN_MINMAX_MULTI_DISTANCE_DATE: u32 = 4629;
pub const F_BRIN_MINMAX_MULTI_DISTANCE_TIME: u32 = 4630;
pub const F_BRIN_MINMAX_MULTI_DISTANCE_INTERVAL: u32 = 4631;
pub const F_BRIN_MINMAX_MULTI_DISTANCE_TIMETZ: u32 = 4632;
pub const F_BRIN_MINMAX_MULTI_DISTANCE_PG_LSN: u32 = 4633;
pub const F_BRIN_MINMAX_MULTI_DISTANCE_MACADDR: u32 = 4634;
pub const F_BRIN_MINMAX_MULTI_DISTANCE_MACADDR8: u32 = 4635;
pub const F_BRIN_MINMAX_MULTI_DISTANCE_INET: u32 = 4636;
pub const F_BRIN_MINMAX_MULTI_DISTANCE_TIMESTAMP: u32 = 4637;
pub const F_BRIN_MINMAX_MULTI_SUMMARY_IN: u32 = 4638;
pub const F_BRIN_MINMAX_MULTI_SUMMARY_OUT: u32 = 4639;
pub const F_BRIN_MINMAX_MULTI_SUMMARY_RECV: u32 = 4640;
pub const F_BRIN_MINMAX_MULTI_SUMMARY_SEND: u32 = 4641;
pub const F_PHRASETO_TSQUERY_TEXT: u32 = 5001;
pub const F_TSQUERY_PHRASE_TSQUERY_TSQUERY: u32 = 5003;
pub const F_TSQUERY_PHRASE_TSQUERY_TSQUERY_INT4: u32 = 5004;
pub const F_PHRASETO_TSQUERY_REGCONFIG_TEXT: u32 = 5006;
pub const F_WEBSEARCH_TO_TSQUERY_REGCONFIG_TEXT: u32 = 5007;
pub const F_WEBSEARCH_TO_TSQUERY_TEXT: u32 = 5009;
pub const F_SPG_BBOX_QUAD_CONFIG: u32 = 5010;
pub const F_SPG_POLY_QUAD_COMPRESS: u32 = 5011;
pub const F_SPG_BOX_QUAD_CONFIG: u32 = 5012;
pub const F_SPG_BOX_QUAD_CHOOSE: u32 = 5013;
pub const F_SPG_BOX_QUAD_PICKSPLIT: u32 = 5014;
pub const F_SPG_BOX_QUAD_INNER_CONSISTENT: u32 = 5015;
pub const F_SPG_BOX_QUAD_LEAF_CONSISTENT: u32 = 5016;
pub const F_PG_MCV_LIST_IN: u32 = 5018;
pub const F_PG_MCV_LIST_OUT: u32 = 5019;
pub const F_PG_MCV_LIST_RECV: u32 = 5020;
pub const F_PG_MCV_LIST_SEND: u32 = 5021;
pub const F_PG_LSN_PLI: u32 = 5022;
pub const F_NUMERIC_PL_PG_LSN: u32 = 5023;
pub const F_PG_LSN_MII: u32 = 5024;
pub const F_SATISFIES_HASH_PARTITION: u32 = 5028;
pub const F_PG_LS_TMPDIR_: u32 = 5029;
pub const F_PG_LS_TMPDIR_OID: Oid = Oid(5030);
pub const F_PG_LS_ARCHIVE_STATUSDIR: u32 = 5031;
pub const F_NETWORK_SORTSUPPORT: u32 = 5033;
pub const F_XID8LT: u32 = 5034;
pub const F_XID8GT: u32 = 5035;
pub const F_XID8LE: u32 = 5036;
pub const F_XID8GE: u32 = 5037;
pub const F_MATCHINGSEL: u32 = 5040;
pub const F_MATCHINGJOINSEL: u32 = 5041;
pub const F_MIN_SCALE: u32 = 5042;
pub const F_TRIM_SCALE: u32 = 5043;
pub const F_GCD_INT4_INT4: u32 = 5044;
pub const F_GCD_INT8_INT8: u32 = 5045;
pub const F_LCM_INT4_INT4: u32 = 5046;
pub const F_LCM_INT8_INT8: u32 = 5047;
pub const F_GCD_NUMERIC_NUMERIC: u32 = 5048;
pub const F_LCM_NUMERIC_NUMERIC: u32 = 5049;
pub const F_BTVARSTREQUALIMAGE: u32 = 5050;
pub const F_BTEQUALIMAGE: u32 = 5051;
pub const F_PG_GET_SHMEM_ALLOCATIONS: u32 = 5052;
pub const F_PG_STAT_GET_INS_SINCE_VACUUM: u32 = 5053;
pub const F_JSONB_SET_LAX: u32 = 5054;
pub const F_PG_SNAPSHOT_IN: u32 = 5055;
pub const F_PG_SNAPSHOT_OUT: u32 = 5056;
pub const F_PG_SNAPSHOT_RECV: u32 = 5057;
pub const F_PG_SNAPSHOT_SEND: u32 = 5058;
pub const F_PG_CURRENT_XACT_ID: u32 = 5059;
pub const F_PG_CURRENT_XACT_ID_IF_ASSIGNED: u32 = 5060;
pub const F_PG_CURRENT_SNAPSHOT: u32 = 5061;
pub const F_PG_SNAPSHOT_XMIN: u32 = 5062;
pub const F_PG_SNAPSHOT_XMAX: u32 = 5063;
pub const F_PG_SNAPSHOT_XIP: u32 = 5064;
pub const F_PG_VISIBLE_IN_SNAPSHOT: u32 = 5065;
pub const F_PG_XACT_STATUS: u32 = 5066;
pub const F_XID8IN: u32 = 5070;
pub const F_XID: u32 = 5071;
pub const F_XID8OUT: u32 = 5081;
pub const F_XID8RECV: u32 = 5082;
pub const F_XID8SEND: u32 = 5083;
pub const F_XID8EQ: u32 = 5084;
pub const F_XID8NE: u32 = 5085;
pub const F_ANYCOMPATIBLE_IN: u32 = 5086;
pub const F_ANYCOMPATIBLE_OUT: u32 = 5087;
pub const F_ANYCOMPATIBLEARRAY_IN: u32 = 5088;
pub const F_ANYCOMPATIBLEARRAY_OUT: u32 = 5089;
pub const F_ANYCOMPATIBLEARRAY_RECV: u32 = 5090;
pub const F_ANYCOMPATIBLEARRAY_SEND: u32 = 5091;
pub const F_ANYCOMPATIBLENONARRAY_IN: u32 = 5092;
pub const F_ANYCOMPATIBLENONARRAY_OUT: u32 = 5093;
pub const F_ANYCOMPATIBLERANGE_IN: u32 = 5094;
pub const F_ANYCOMPATIBLERANGE_OUT: u32 = 5095;
pub const F_XID8CMP: u32 = 5096;
pub const F_XID8_LARGER: u32 = 5097;
pub const F_XID8_SMALLER: u32 = 5098;
pub const F_MAX_XID8: u32 = 5099;
pub const F_MIN_XID8: u32 = 5100;
pub const F_PG_REPLICATION_ORIGIN_CREATE: u32 = 6003;
pub const F_PG_REPLICATION_ORIGIN_DROP: u32 = 6004;
pub const F_PG_REPLICATION_ORIGIN_OID: Oid = Oid(6005);
pub const F_PG_REPLICATION_ORIGIN_SESSION_SETUP: u32 = 6006;
pub const F_PG_REPLICATION_ORIGIN_SESSION_RESET: u32 = 6007;
pub const F_PG_REPLICATION_ORIGIN_SESSION_IS_SETUP: u32 = 6008;
pub const F_PG_REPLICATION_ORIGIN_SESSION_PROGRESS: u32 = 6009;
pub const F_PG_REPLICATION_ORIGIN_XACT_SETUP: u32 = 6010;
pub const F_PG_REPLICATION_ORIGIN_XACT_RESET: u32 = 6011;
pub const F_PG_REPLICATION_ORIGIN_ADVANCE: u32 = 6012;
pub const F_PG_REPLICATION_ORIGIN_PROGRESS: u32 = 6013;
pub const F_PG_SHOW_REPLICATION_ORIGIN_STATUS: u32 = 6014;
pub const F_JSONB_SUBSCRIPT_HANDLER: u32 = 6098;
pub const F_PG_LSN: u32 = 6103;
pub const F_PG_STAT_GET_SUBSCRIPTION: u32 = 6118;
pub const F_PG_GET_PUBLICATION_TABLES: u32 = 6119;
pub const F_PG_GET_REPLICA_IDENTITY_INDEX: u32 = 6120;
pub const F_PG_RELATION_IS_PUBLISHABLE: u32 = 6121;
pub const F_MULTIRANGE_GIST_CONSISTENT: u32 = 6154;
pub const F_MULTIRANGE_GIST_COMPRESS: u32 = 6156;
pub const F_PG_GET_CATALOG_FOREIGN_KEYS: u32 = 6159;
pub const F_STRING_TO_TABLE_TEXT_TEXT: u32 = 6160;
pub const F_STRING_TO_TABLE_TEXT_TEXT_TEXT: u32 = 6161;
pub const F_BIT_COUNT_BIT: u32 = 6162;
pub const F_BIT_COUNT_BYTEA: u32 = 6163;
pub const F_BIT_XOR_INT2: u32 = 6164;
pub const F_BIT_XOR_INT4: u32 = 6165;
pub const F_BIT_XOR_INT8: u32 = 6166;
pub const F_BIT_XOR_BIT: u32 = 6167;
pub const F_PG_XACT_COMMIT_TIMESTAMP_ORIGIN: u32 = 6168;
pub const F_PG_STAT_GET_REPLICATION_SLOT: u32 = 6169;
pub const F_PG_STAT_RESET_REPLICATION_SLOT: u32 = 6170;
pub const F_TRIM_ARRAY: u32 = 6172;
pub const F_PG_GET_STATISTICSOBJDEF_EXPRESSIONS: u32 = 6173;
pub const F_PG_GET_STATISTICSOBJDEF_COLUMNS: u32 = 6174;
pub const F_DATE_BIN_INTERVAL_TIMESTAMP_TIMESTAMP: u32 = 6177;
pub const F_DATE_BIN_INTERVAL_TIMESTAMPTZ_TIMESTAMPTZ: u32 = 6178;
pub const F_ARRAY_SUBSCRIPT_HANDLER: u32 = 6179;
pub const F_RAW_ARRAY_SUBSCRIPT_HANDLER: u32 = 6180;
pub const F_TS_DEBUG_REGCONFIG_TEXT: u32 = 6183;
pub const F_TS_DEBUG_TEXT: u32 = 6184;
pub const F_PG_STAT_GET_DB_SESSION_TIME: u32 = 6185;
pub const F_PG_STAT_GET_DB_ACTIVE_TIME: u32 = 6186;
pub const F_PG_STAT_GET_DB_IDLE_IN_TRANSACTION_TIME: u32 = 6187;
pub const F_PG_STAT_GET_DB_SESSIONS: u32 = 6188;
pub const F_PG_STAT_GET_DB_SESSIONS_ABANDONED: u32 = 6189;
pub const F_PG_STAT_GET_DB_SESSIONS_FATAL: u32 = 6190;
pub const F_PG_STAT_GET_DB_SESSIONS_KILLED: u32 = 6191;
pub const F_HASH_RECORD: u32 = 6192;
pub const F_HASH_RECORD_EXTENDED: u32 = 6193;
pub const F_LTRIM_BYTEA_BYTEA: u32 = 6195;
pub const F_RTRIM_BYTEA_BYTEA: u32 = 6196;
pub const F_PG_GET_FUNCTION_SQLBODY: u32 = 6197;
pub const F_UNISTR: u32 = 6198;
pub const F_EXTRACT_TEXT_DATE: u32 = 6199;
pub const F_EXTRACT_TEXT_TIME: u32 = 6200;
pub const F_EXTRACT_TEXT_TIMETZ: u32 = 6201;
pub const F_EXTRACT_TEXT_TIMESTAMP: u32 = 6202;
pub const F_EXTRACT_TEXT_TIMESTAMPTZ: u32 = 6203;
pub const F_EXTRACT_TEXT_INTERVAL: u32 = 6204;
pub const F_HAS_PARAMETER_PRIVILEGE_NAME_TEXT_TEXT: u32 = 6205;
pub const F_HAS_PARAMETER_PRIVILEGE_OID_TEXT_TEXT: u32 = 6206;
pub const F_HAS_PARAMETER_PRIVILEGE_TEXT_TEXT: u32 = 6207;
pub const F_PG_GET_WAL_RESOURCE_MANAGERS: u32 = 6224;
pub const F_MULTIRANGE_AGG_TRANSFN: u32 = 6225;
pub const F_MULTIRANGE_AGG_FINALFN: u32 = 6226;
pub const F_RANGE_AGG_ANYMULTIRANGE: u32 = 6227;
pub const F_PG_STAT_HAVE_STATS: u32 = 6230;
pub const F_PG_STAT_GET_SUBSCRIPTION_STATS: u32 = 6231;
pub const F_PG_STAT_RESET_SUBSCRIPTION_STATS: u32 = 6232;
pub const F_WINDOW_ROW_NUMBER_SUPPORT: u32 = 6233;
pub const F_WINDOW_RANK_SUPPORT: u32 = 6234;
pub const F_WINDOW_DENSE_RANK_SUPPORT: u32 = 6235;
pub const F_INT8INC_SUPPORT: u32 = 6236;
pub const F_PG_SETTINGS_GET_FLAGS: u32 = 6240;
pub const F_PG_STOP_MAKING_PINNED_OBJECTS: u32 = 6241;
pub const F_TEXT_STARTS_WITH_SUPPORT: u32 = 6242;
pub const F_PG_STAT_GET_RECOVERY_PREFETCH: u32 = 6248;
pub const F_PG_DATABASE_COLLATION_ACTUAL_VERSION: u32 = 6249;
pub const F_PG_IDENT_FILE_MAPPINGS: u32 = 6250;
pub const F_REGEXP_REPLACE_TEXT_TEXT_TEXT_INT4_INT4_TEXT: u32 = 6251;
pub const F_REGEXP_REPLACE_TEXT_TEXT_TEXT_INT4_INT4: u32 = 6252;
pub const F_REGEXP_REPLACE_TEXT_TEXT_TEXT_INT4: u32 = 6253;
pub const F_REGEXP_COUNT_TEXT_TEXT: u32 = 6254;
pub const F_REGEXP_COUNT_TEXT_TEXT_INT4: u32 = 6255;
pub const F_REGEXP_COUNT_TEXT_TEXT_INT4_TEXT: u32 = 6256;
pub const F_REGEXP_INSTR_TEXT_TEXT: u32 = 6257;
pub const F_REGEXP_INSTR_TEXT_TEXT_INT4: u32 = 6258;
pub const F_REGEXP_INSTR_TEXT_TEXT_INT4_INT4: u32 = 6259;
pub const F_REGEXP_INSTR_TEXT_TEXT_INT4_INT4_INT4: u32 = 6260;
pub const F_REGEXP_INSTR_TEXT_TEXT_INT4_INT4_INT4_TEXT: u32 = 6261;
pub const F_REGEXP_INSTR_TEXT_TEXT_INT4_INT4_INT4_TEXT_INT4: u32 = 6262;
pub const F_REGEXP_LIKE_TEXT_TEXT: u32 = 6263;
pub const F_REGEXP_LIKE_TEXT_TEXT_TEXT: u32 = 6264;
pub const F_REGEXP_SUBSTR_TEXT_TEXT: u32 = 6265;
pub const F_REGEXP_SUBSTR_TEXT_TEXT_INT4: u32 = 6266;
pub const F_REGEXP_SUBSTR_TEXT_TEXT_INT4_INT4: u32 = 6267;
pub const F_REGEXP_SUBSTR_TEXT_TEXT_INT4_INT4_TEXT: u32 = 6268;
pub const F_REGEXP_SUBSTR_TEXT_TEXT_INT4_INT4_TEXT_INT4: u32 = 6269;
pub const F_PG_LS_LOGICALSNAPDIR: u32 = 6270;
pub const F_PG_LS_LOGICALMAPDIR: u32 = 6271;
pub const F_PG_LS_REPLSLOTDIR: u32 = 6272;
pub const NUMERIC_MAX_PRECISION: u32 = 1000;
pub const NUMERIC_MIN_SCALE: i32 = -1000;
pub const NUMERIC_MAX_SCALE: u32 = 1000;
pub const NUMERIC_MAX_DISPLAY_SCALE: u32 = 1000;
pub const NUMERIC_MIN_DISPLAY_SCALE: u32 = 0;
pub const NUMERIC_MAX_RESULT_SCALE: u32 = 2000;
pub const NUMERIC_MIN_SIG_DIGITS: u32 = 16;
pub const JsonbContainsStrategyNumber: u32 = 7;
pub const JsonbExistsStrategyNumber: u32 = 9;
pub const JsonbExistsAnyStrategyNumber: u32 = 10;
pub const JsonbExistsAllStrategyNumber: u32 = 11;
pub const JsonbJsonpathExistsStrategyNumber: u32 = 15;
pub const JsonbJsonpathPredicateStrategyNumber: u32 = 16;
pub const JGINFLAG_KEY: u32 = 1;
pub const JGINFLAG_NULL: u32 = 2;
pub const JGINFLAG_BOOL: u32 = 3;
pub const JGINFLAG_NUM: u32 = 4;
pub const JGINFLAG_STR: u32 = 5;
pub const JGINFLAG_HASHED: u32 = 16;
pub const JGIN_MAXLENGTH: u32 = 125;
pub const JENTRY_OFFLENMASK: u32 = 268435455;
pub const JENTRY_TYPEMASK: u32 = 1879048192;
pub const JENTRY_HAS_OFF: u32 = 2147483648;
pub const JENTRY_ISSTRING: u32 = 0;
pub const JENTRY_ISNUMERIC: u32 = 268435456;
pub const JENTRY_ISBOOL_FALSE: u32 = 536870912;
pub const JENTRY_ISBOOL_TRUE: u32 = 805306368;
pub const JENTRY_ISNULL: u32 = 1073741824;
pub const JENTRY_ISCONTAINER: u32 = 1342177280;
pub const JB_OFFSET_STRIDE: u32 = 32;
pub const JB_CMASK: u32 = 268435455;
pub const JB_FSCALAR: u32 = 268435456;
pub const JB_FOBJECT: u32 = 536870912;
pub const JB_FARRAY: u32 = 1073741824;
pub const ATTSTATSSLOT_VALUES: u32 = 1;
pub const ATTSTATSSLOT_NUMBERS: u32 = 2;
pub const FORMAT_PROC_INVALID_AS_NULL: u32 = 1;
pub const FORMAT_PROC_FORCE_QUALIFY: u32 = 2;
pub const FORMAT_OPERATOR_INVALID_AS_NULL: u32 = 1;
pub const FORMAT_OPERATOR_FORCE_QUALIFY: u32 = 2;
pub const CATCACHE_MAXKEYS: u32 = 4;
pub const CT_MAGIC: u32 = 1462113538;
pub const CL_MAGIC: u32 = 1383485699;
pub const RULE_INDEXDEF_PRETTY: u32 = 1;
pub const RULE_INDEXDEF_KEYS_ONLY: u32 = 2;
pub const DEFAULT_EQ_SEL: f64 = 0.005;
pub const DEFAULT_INEQ_SEL: f64 = 0.3333333333333333;
pub const DEFAULT_RANGE_INEQ_SEL: f64 = 0.005;
pub const DEFAULT_MULTIRANGE_INEQ_SEL: f64 = 0.005;
pub const DEFAULT_MATCH_SEL: f64 = 0.005;
pub const DEFAULT_MATCHING_SEL: f64 = 0.01;
pub const DEFAULT_NUM_DISTINCT: u32 = 200;
pub const DEFAULT_UNK_SEL: f64 = 0.005;
pub const DEFAULT_NOT_UNK_SEL: f64 = 0.995;
pub const SELFLAG_USED_DEFAULT: u32 = 1;
pub const RANGE_EMPTY_LITERAL: &::core::ffi::CStr = c"empty";
pub const RANGE_EMPTY: u32 = 1;
pub const RANGE_LB_INC: u32 = 2;
pub const RANGE_UB_INC: u32 = 4;
pub const RANGE_LB_INF: u32 = 8;
pub const RANGE_UB_INF: u32 = 16;
pub const RANGE_LB_NULL: u32 = 32;
pub const RANGE_UB_NULL: u32 = 64;
pub const RANGE_CONTAIN_EMPTY: u32 = 128;
pub const RANGESTRAT_BEFORE: u32 = 1;
pub const RANGESTRAT_OVERLEFT: u32 = 2;
pub const RANGESTRAT_OVERLAPS: u32 = 3;
pub const RANGESTRAT_OVERRIGHT: u32 = 4;
pub const RANGESTRAT_AFTER: u32 = 5;
pub const RANGESTRAT_ADJACENT: u32 = 6;
pub const RANGESTRAT_CONTAINS: u32 = 7;
pub const RANGESTRAT_CONTAINED_BY: u32 = 8;
pub const RANGESTRAT_CONTAINS_ELEM: u32 = 16;
pub const RANGESTRAT_EQ: u32 = 18;
pub type pg_int64 = ::core::ffi::c_long;
pub type va_list = __builtin_va_list;
pub type __uid_t = ::core::ffi::c_uint;
pub type __gid_t = ::core::ffi::c_uint;
pub type __ino_t = ::core::ffi::c_ulong;
pub type __mode_t = ::core::ffi::c_uint;
pub type __off_t = ::core::ffi::c_long;
pub type __off64_t = ::core::ffi::c_long;
pub type __pid_t = ::core::ffi::c_int;
pub type __time_t = ::core::ffi::c_long;
pub type __syscall_slong_t = ::core::ffi::c_long;
pub type __socklen_t = ::core::ffi::c_uint;
pub type __sig_atomic_t = ::core::ffi::c_int;
pub type FILE = _IO_FILE;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_marker {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_codecvt {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_wide_data {
    _unused: [u8; 0],
}
pub type _IO_lock_t = ::core::ffi::c_void;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_FILE {
    pub _flags: ::core::ffi::c_int,
    pub _IO_read_ptr: *mut ::core::ffi::c_char,
    pub _IO_read_end: *mut ::core::ffi::c_char,
    pub _IO_read_base: *mut ::core::ffi::c_char,
    pub _IO_write_base: *mut ::core::ffi::c_char,
    pub _IO_write_ptr: *mut ::core::ffi::c_char,
    pub _IO_write_end: *mut ::core::ffi::c_char,
    pub _IO_buf_base: *mut ::core::ffi::c_char,
    pub _IO_buf_end: *mut ::core::ffi::c_char,
    pub _IO_save_base: *mut ::core::ffi::c_char,
    pub _IO_backup_base: *mut ::core::ffi::c_char,
    pub _IO_save_end: *mut ::core::ffi::c_char,
    pub _markers: *mut _IO_marker,
    pub _chain: *mut _IO_FILE,
    pub _fileno: ::core::ffi::c_int,
    pub _flags2: ::core::ffi::c_int,
    pub _old_offset: __off_t,
    pub _cur_column: ::core::ffi::c_ushort,
    pub _vtable_offset: ::core::ffi::c_schar,
    pub _shortbuf: [::core::ffi::c_char; 1usize],
    pub _lock: *mut _IO_lock_t,
    pub _offset: __off64_t,
    pub _codecvt: *mut _IO_codecvt,
    pub _wide_data: *mut _IO_wide_data,
    pub _freeres_list: *mut _IO_FILE,
    pub _freeres_buf: *mut ::core::ffi::c_void,
    pub __pad5: usize,
    pub _mode: ::core::ffi::c_int,
    pub _unused2: [::core::ffi::c_char; 20usize],
}
impl Default for _IO_FILE {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type off_t = __off_t;
pub type gid_t = __gid_t;
pub type mode_t = __mode_t;
pub type uid_t = __uid_t;
pub type pid_t = __pid_t;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __sigset_t {
    pub __val: [::core::ffi::c_ulong; 16usize],
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct timespec {
    pub tv_sec: __time_t,
    pub tv_nsec: __syscall_slong_t,
}
pub type pg_funcptr_t = ::core::option::Option<unsafe extern "C-unwind" fn()>;
pub type Pointer = *mut ::core::ffi::c_char;
pub type int8 = ::core::ffi::c_schar;
pub type int16 = ::core::ffi::c_short;
pub type int32 = ::core::ffi::c_int;
pub type uint8 = ::core::ffi::c_uchar;
pub type uint16 = ::core::ffi::c_ushort;
pub type uint32 = ::core::ffi::c_uint;
pub type bits8 = uint8;
pub type bits16 = uint16;
pub type bits32 = uint32;
pub type int64 = ::core::ffi::c_long;
pub type uint64 = ::core::ffi::c_ulong;
pub type int128 = i128;
pub type uint128 = u128;
pub type Size = usize;
pub type Index = ::core::ffi::c_uint;
pub type Offset = ::core::ffi::c_int;
pub type float4 = f32;
pub type float8 = f64;
pub type regproc = Oid;
pub type RegProcedure = regproc;
pub type LocalTransactionId = uint32;
pub type SubTransactionId = uint32;
pub type MultiXactOffset = uint32;
pub type CommandId = uint32;
#[repr(C)]
#[derive(Debug, Default)]
pub struct varlena {
    pub vl_len_: [::core::ffi::c_char; 4usize],
    pub vl_dat: __IncompleteArrayField<::core::ffi::c_char>,
}
pub type bytea = varlena;
pub type text = varlena;
pub type BpChar = varlena;
pub type VarChar = varlena;
#[repr(C)]
#[derive(Debug)]
pub struct int2vector {
    pub vl_len_: int32,
    pub ndim: ::core::ffi::c_int,
    pub dataoffset: int32,
    pub elemtype: Oid,
    pub dim1: ::core::ffi::c_int,
    pub lbound1: ::core::ffi::c_int,
    pub values: __IncompleteArrayField<int16>,
}
impl Default for int2vector {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct oidvector {
    pub vl_len_: int32,
    pub ndim: ::core::ffi::c_int,
    pub dataoffset: int32,
    pub elemtype: Oid,
    pub dim1: ::core::ffi::c_int,
    pub lbound1: ::core::ffi::c_int,
    pub values: __IncompleteArrayField<Oid>,
}
impl Default for oidvector {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nameData {
    pub data: [::core::ffi::c_char; 64usize],
}
impl Default for nameData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type NameData = nameData;
pub type Name = *mut NameData;
#[repr(C)]
#[derive(Copy, Clone)]
pub union PGAlignedBlock {
    pub data: [::core::ffi::c_char; 8192usize],
    pub force_align_d: f64,
    pub force_align_i64: int64,
}
impl Default for PGAlignedBlock {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union PGAlignedXLogBlock {
    pub data: [::core::ffi::c_char; 8192usize],
    pub force_align_d: f64,
    pub force_align_i64: int64,
}
impl Default for PGAlignedXLogBlock {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type pgsocket = ::core::ffi::c_int;
pub type qsort_arg_comparator = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        a: *const ::core::ffi::c_void,
        b: *const ::core::ffi::c_void,
        arg: *mut ::core::ffi::c_void,
    ) -> ::core::ffi::c_int,
>;
pub type pqsigfunc = ::core::option::Option<unsafe extern "C-unwind" fn(signo: ::core::ffi::c_int)>;
pub type __jmp_buf = [::core::ffi::c_long; 8usize];
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __jmp_buf_tag {
    pub __jmpbuf: __jmp_buf,
    pub __mask_was_saved: ::core::ffi::c_int,
    pub __saved_mask: __sigset_t,
}
pub type sigjmp_buf = [__jmp_buf_tag; 1usize];
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ErrorContextCallback {
    pub previous: *mut ErrorContextCallback,
    pub callback:
        ::core::option::Option<unsafe extern "C-unwind" fn(arg: *mut ::core::ffi::c_void)>,
    pub arg: *mut ::core::ffi::c_void,
}
impl Default for ErrorContextCallback {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ErrorData {
    pub elevel: ::core::ffi::c_int,
    pub output_to_server: bool,
    pub output_to_client: bool,
    pub hide_stmt: bool,
    pub hide_ctx: bool,
    pub filename: *const ::core::ffi::c_char,
    pub lineno: ::core::ffi::c_int,
    pub funcname: *const ::core::ffi::c_char,
    pub domain: *const ::core::ffi::c_char,
    pub context_domain: *const ::core::ffi::c_char,
    pub sqlerrcode: ::core::ffi::c_int,
    pub message: *mut ::core::ffi::c_char,
    pub detail: *mut ::core::ffi::c_char,
    pub detail_log: *mut ::core::ffi::c_char,
    pub hint: *mut ::core::ffi::c_char,
    pub context: *mut ::core::ffi::c_char,
    pub backtrace: *mut ::core::ffi::c_char,
    pub message_id: *const ::core::ffi::c_char,
    pub schema_name: *mut ::core::ffi::c_char,
    pub table_name: *mut ::core::ffi::c_char,
    pub column_name: *mut ::core::ffi::c_char,
    pub datatype_name: *mut ::core::ffi::c_char,
    pub constraint_name: *mut ::core::ffi::c_char,
    pub cursorpos: ::core::ffi::c_int,
    pub internalpos: ::core::ffi::c_int,
    pub internalquery: *mut ::core::ffi::c_char,
    pub saved_errno: ::core::ffi::c_int,
    pub assoc_context: *mut MemoryContextData,
}
impl Default for ErrorData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type emit_log_hook_type =
    ::core::option::Option<unsafe extern "C-unwind" fn(edata: *mut ErrorData)>;
pub mod PGErrorVerbosity {
    pub type Type = ::core::ffi::c_uint;
    pub const PGERROR_TERSE: Type = 0;
    pub const PGERROR_DEFAULT: Type = 1;
    pub const PGERROR_VERBOSE: Type = 2;
}
pub type MemoryContext = *mut MemoryContextData;
pub type MemoryContextCallbackFunction =
    ::core::option::Option<unsafe extern "C-unwind" fn(arg: *mut ::core::ffi::c_void)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MemoryContextCallback {
    pub func: MemoryContextCallbackFunction,
    pub arg: *mut ::core::ffi::c_void,
    pub next: *mut MemoryContextCallback,
}
impl Default for MemoryContextCallback {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct varatt_external {
    pub va_rawsize: int32,
    pub va_extinfo: uint32,
    pub va_valueid: Oid,
    pub va_toastrelid: Oid,
}
impl Default for varatt_external {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct varatt_indirect {
    pub pointer: *mut varlena,
}
impl Default for varatt_indirect {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct varatt_expanded {
    pub eohptr: *mut ExpandedObjectHeader,
}
impl Default for varatt_expanded {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod vartag_external {
    pub type Type = ::core::ffi::c_uint;
    pub const VARTAG_INDIRECT: Type = 1;
    pub const VARTAG_EXPANDED_RO: Type = 2;
    pub const VARTAG_EXPANDED_RW: Type = 3;
    pub const VARTAG_ONDISK: Type = 18;
}
#[repr(C)]
pub union varattrib_4b {
    pub va_4byte: ::core::mem::ManuallyDrop<varattrib_4b__bindgen_ty_1>,
    pub va_compressed: ::core::mem::ManuallyDrop<varattrib_4b__bindgen_ty_2>,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct varattrib_4b__bindgen_ty_1 {
    pub va_header: uint32,
    pub va_data: __IncompleteArrayField<::core::ffi::c_char>,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct varattrib_4b__bindgen_ty_2 {
    pub va_header: uint32,
    pub va_tcinfo: uint32,
    pub va_data: __IncompleteArrayField<::core::ffi::c_char>,
}
impl Default for varattrib_4b {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct varattrib_1b {
    pub va_header: uint8,
    pub va_data: __IncompleteArrayField<::core::ffi::c_char>,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct varattrib_1b_e {
    pub va_header: uint8,
    pub va_tag: uint8,
    pub va_data: __IncompleteArrayField<::core::ffi::c_char>,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NullableDatum {
    pub value: Datum,
    pub isnull: bool,
}
impl Default for NullableDatum {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type AttrNumber = int16;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FormData_pg_attribute {
    pub attrelid: Oid,
    pub attname: NameData,
    pub atttypid: Oid,
    pub attstattarget: int32,
    pub attlen: int16,
    pub attnum: int16,
    pub attndims: int32,
    pub attcacheoff: int32,
    pub atttypmod: int32,
    pub attbyval: bool,
    pub attalign: ::core::ffi::c_char,
    pub attstorage: ::core::ffi::c_char,
    pub attcompression: ::core::ffi::c_char,
    pub attnotnull: bool,
    pub atthasdef: bool,
    pub atthasmissing: bool,
    pub attidentity: ::core::ffi::c_char,
    pub attgenerated: ::core::ffi::c_char,
    pub attisdropped: bool,
    pub attislocal: bool,
    pub attinhcount: int32,
    pub attcollation: Oid,
}
impl Default for FormData_pg_attribute {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Form_pg_attribute = *mut FormData_pg_attribute;
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum NodeTag {
    T_Invalid = 0,
    T_IndexInfo = 1,
    T_ExprContext = 2,
    T_ProjectionInfo = 3,
    T_JunkFilter = 4,
    T_OnConflictSetState = 5,
    T_MergeActionState = 6,
    T_ResultRelInfo = 7,
    T_EState = 8,
    T_TupleTableSlot = 9,
    T_Plan = 10,
    T_Result = 11,
    T_ProjectSet = 12,
    T_ModifyTable = 13,
    T_Append = 14,
    T_MergeAppend = 15,
    T_RecursiveUnion = 16,
    T_BitmapAnd = 17,
    T_BitmapOr = 18,
    T_Scan = 19,
    T_SeqScan = 20,
    T_SampleScan = 21,
    T_IndexScan = 22,
    T_IndexOnlyScan = 23,
    T_BitmapIndexScan = 24,
    T_BitmapHeapScan = 25,
    T_TidScan = 26,
    T_TidRangeScan = 27,
    T_SubqueryScan = 28,
    T_FunctionScan = 29,
    T_ValuesScan = 30,
    T_TableFuncScan = 31,
    T_CteScan = 32,
    T_NamedTuplestoreScan = 33,
    T_WorkTableScan = 34,
    T_ForeignScan = 35,
    T_CustomScan = 36,
    T_Join = 37,
    T_NestLoop = 38,
    T_MergeJoin = 39,
    T_HashJoin = 40,
    T_Material = 41,
    T_Memoize = 42,
    T_Sort = 43,
    T_IncrementalSort = 44,
    T_Group = 45,
    T_Agg = 46,
    T_WindowAgg = 47,
    T_Unique = 48,
    T_Gather = 49,
    T_GatherMerge = 50,
    T_Hash = 51,
    T_SetOp = 52,
    T_LockRows = 53,
    T_Limit = 54,
    T_NestLoopParam = 55,
    T_PlanRowMark = 56,
    T_PartitionPruneInfo = 57,
    T_PartitionedRelPruneInfo = 58,
    T_PartitionPruneStepOp = 59,
    T_PartitionPruneStepCombine = 60,
    T_PlanInvalItem = 61,
    T_PlanState = 62,
    T_ResultState = 63,
    T_ProjectSetState = 64,
    T_ModifyTableState = 65,
    T_AppendState = 66,
    T_MergeAppendState = 67,
    T_RecursiveUnionState = 68,
    T_BitmapAndState = 69,
    T_BitmapOrState = 70,
    T_ScanState = 71,
    T_SeqScanState = 72,
    T_SampleScanState = 73,
    T_IndexScanState = 74,
    T_IndexOnlyScanState = 75,
    T_BitmapIndexScanState = 76,
    T_BitmapHeapScanState = 77,
    T_TidScanState = 78,
    T_TidRangeScanState = 79,
    T_SubqueryScanState = 80,
    T_FunctionScanState = 81,
    T_TableFuncScanState = 82,
    T_ValuesScanState = 83,
    T_CteScanState = 84,
    T_NamedTuplestoreScanState = 85,
    T_WorkTableScanState = 86,
    T_ForeignScanState = 87,
    T_CustomScanState = 88,
    T_JoinState = 89,
    T_NestLoopState = 90,
    T_MergeJoinState = 91,
    T_HashJoinState = 92,
    T_MaterialState = 93,
    T_MemoizeState = 94,
    T_SortState = 95,
    T_IncrementalSortState = 96,
    T_GroupState = 97,
    T_AggState = 98,
    T_WindowAggState = 99,
    T_UniqueState = 100,
    T_GatherState = 101,
    T_GatherMergeState = 102,
    T_HashState = 103,
    T_SetOpState = 104,
    T_LockRowsState = 105,
    T_LimitState = 106,
    T_Alias = 107,
    T_RangeVar = 108,
    T_TableFunc = 109,
    T_Var = 110,
    T_Const = 111,
    T_Param = 112,
    T_Aggref = 113,
    T_GroupingFunc = 114,
    T_WindowFunc = 115,
    T_SubscriptingRef = 116,
    T_FuncExpr = 117,
    T_NamedArgExpr = 118,
    T_OpExpr = 119,
    T_DistinctExpr = 120,
    T_NullIfExpr = 121,
    T_ScalarArrayOpExpr = 122,
    T_BoolExpr = 123,
    T_SubLink = 124,
    T_SubPlan = 125,
    T_AlternativeSubPlan = 126,
    T_FieldSelect = 127,
    T_FieldStore = 128,
    T_RelabelType = 129,
    T_CoerceViaIO = 130,
    T_ArrayCoerceExpr = 131,
    T_ConvertRowtypeExpr = 132,
    T_CollateExpr = 133,
    T_CaseExpr = 134,
    T_CaseWhen = 135,
    T_CaseTestExpr = 136,
    T_ArrayExpr = 137,
    T_RowExpr = 138,
    T_RowCompareExpr = 139,
    T_CoalesceExpr = 140,
    T_MinMaxExpr = 141,
    T_SQLValueFunction = 142,
    T_XmlExpr = 143,
    T_NullTest = 144,
    T_BooleanTest = 145,
    T_CoerceToDomain = 146,
    T_CoerceToDomainValue = 147,
    T_SetToDefault = 148,
    T_CurrentOfExpr = 149,
    T_NextValueExpr = 150,
    T_InferenceElem = 151,
    T_TargetEntry = 152,
    T_RangeTblRef = 153,
    T_JoinExpr = 154,
    T_FromExpr = 155,
    T_OnConflictExpr = 156,
    T_IntoClause = 157,
    T_ExprState = 158,
    T_WindowFuncExprState = 159,
    T_SetExprState = 160,
    T_SubPlanState = 161,
    T_DomainConstraintState = 162,
    T_PlannerInfo = 163,
    T_PlannerGlobal = 164,
    T_RelOptInfo = 165,
    T_IndexOptInfo = 166,
    T_ForeignKeyOptInfo = 167,
    T_ParamPathInfo = 168,
    T_Path = 169,
    T_IndexPath = 170,
    T_BitmapHeapPath = 171,
    T_BitmapAndPath = 172,
    T_BitmapOrPath = 173,
    T_TidPath = 174,
    T_TidRangePath = 175,
    T_SubqueryScanPath = 176,
    T_ForeignPath = 177,
    T_CustomPath = 178,
    T_NestPath = 179,
    T_MergePath = 180,
    T_HashPath = 181,
    T_AppendPath = 182,
    T_MergeAppendPath = 183,
    T_GroupResultPath = 184,
    T_MaterialPath = 185,
    T_MemoizePath = 186,
    T_UniquePath = 187,
    T_GatherPath = 188,
    T_GatherMergePath = 189,
    T_ProjectionPath = 190,
    T_ProjectSetPath = 191,
    T_SortPath = 192,
    T_IncrementalSortPath = 193,
    T_GroupPath = 194,
    T_UpperUniquePath = 195,
    T_AggPath = 196,
    T_GroupingSetsPath = 197,
    T_MinMaxAggPath = 198,
    T_WindowAggPath = 199,
    T_SetOpPath = 200,
    T_RecursiveUnionPath = 201,
    T_LockRowsPath = 202,
    T_ModifyTablePath = 203,
    T_LimitPath = 204,
    T_EquivalenceClass = 205,
    T_EquivalenceMember = 206,
    T_PathKey = 207,
    T_PathKeyInfo = 208,
    T_PathTarget = 209,
    T_RestrictInfo = 210,
    T_IndexClause = 211,
    T_PlaceHolderVar = 212,
    T_SpecialJoinInfo = 213,
    T_AppendRelInfo = 214,
    T_RowIdentityVarInfo = 215,
    T_PlaceHolderInfo = 216,
    T_MinMaxAggInfo = 217,
    T_PlannerParamItem = 218,
    T_RollupData = 219,
    T_GroupingSetData = 220,
    T_StatisticExtInfo = 221,
    T_MergeAction = 222,
    T_AllocSetContext = 223,
    T_SlabContext = 224,
    T_GenerationContext = 225,
    T_Integer = 226,
    T_Float = 227,
    T_Boolean = 228,
    T_String = 229,
    T_BitString = 230,
    T_List = 231,
    T_IntList = 232,
    T_OidList = 233,
    T_ExtensibleNode = 234,
    T_RawStmt = 235,
    T_Query = 236,
    T_PlannedStmt = 237,
    T_InsertStmt = 238,
    T_DeleteStmt = 239,
    T_UpdateStmt = 240,
    T_MergeStmt = 241,
    T_SelectStmt = 242,
    T_ReturnStmt = 243,
    T_PLAssignStmt = 244,
    T_AlterTableStmt = 245,
    T_AlterTableCmd = 246,
    T_AlterDomainStmt = 247,
    T_SetOperationStmt = 248,
    T_GrantStmt = 249,
    T_GrantRoleStmt = 250,
    T_AlterDefaultPrivilegesStmt = 251,
    T_ClosePortalStmt = 252,
    T_ClusterStmt = 253,
    T_CopyStmt = 254,
    T_CreateStmt = 255,
    T_DefineStmt = 256,
    T_DropStmt = 257,
    T_TruncateStmt = 258,
    T_CommentStmt = 259,
    T_FetchStmt = 260,
    T_IndexStmt = 261,
    T_CreateFunctionStmt = 262,
    T_AlterFunctionStmt = 263,
    T_DoStmt = 264,
    T_RenameStmt = 265,
    T_RuleStmt = 266,
    T_NotifyStmt = 267,
    T_ListenStmt = 268,
    T_UnlistenStmt = 269,
    T_TransactionStmt = 270,
    T_ViewStmt = 271,
    T_LoadStmt = 272,
    T_CreateDomainStmt = 273,
    T_CreatedbStmt = 274,
    T_DropdbStmt = 275,
    T_VacuumStmt = 276,
    T_ExplainStmt = 277,
    T_CreateTableAsStmt = 278,
    T_CreateSeqStmt = 279,
    T_AlterSeqStmt = 280,
    T_VariableSetStmt = 281,
    T_VariableShowStmt = 282,
    T_DiscardStmt = 283,
    T_CreateTrigStmt = 284,
    T_CreatePLangStmt = 285,
    T_CreateRoleStmt = 286,
    T_AlterRoleStmt = 287,
    T_DropRoleStmt = 288,
    T_LockStmt = 289,
    T_ConstraintsSetStmt = 290,
    T_ReindexStmt = 291,
    T_CheckPointStmt = 292,
    T_CreateSchemaStmt = 293,
    T_AlterDatabaseStmt = 294,
    T_AlterDatabaseRefreshCollStmt = 295,
    T_AlterDatabaseSetStmt = 296,
    T_AlterRoleSetStmt = 297,
    T_CreateConversionStmt = 298,
    T_CreateCastStmt = 299,
    T_CreateOpClassStmt = 300,
    T_CreateOpFamilyStmt = 301,
    T_AlterOpFamilyStmt = 302,
    T_PrepareStmt = 303,
    T_ExecuteStmt = 304,
    T_DeallocateStmt = 305,
    T_DeclareCursorStmt = 306,
    T_CreateTableSpaceStmt = 307,
    T_DropTableSpaceStmt = 308,
    T_AlterObjectDependsStmt = 309,
    T_AlterObjectSchemaStmt = 310,
    T_AlterOwnerStmt = 311,
    T_AlterOperatorStmt = 312,
    T_AlterTypeStmt = 313,
    T_DropOwnedStmt = 314,
    T_ReassignOwnedStmt = 315,
    T_CompositeTypeStmt = 316,
    T_CreateEnumStmt = 317,
    T_CreateRangeStmt = 318,
    T_AlterEnumStmt = 319,
    T_AlterTSDictionaryStmt = 320,
    T_AlterTSConfigurationStmt = 321,
    T_CreateFdwStmt = 322,
    T_AlterFdwStmt = 323,
    T_CreateForeignServerStmt = 324,
    T_AlterForeignServerStmt = 325,
    T_CreateUserMappingStmt = 326,
    T_AlterUserMappingStmt = 327,
    T_DropUserMappingStmt = 328,
    T_AlterTableSpaceOptionsStmt = 329,
    T_AlterTableMoveAllStmt = 330,
    T_SecLabelStmt = 331,
    T_CreateForeignTableStmt = 332,
    T_ImportForeignSchemaStmt = 333,
    T_CreateExtensionStmt = 334,
    T_AlterExtensionStmt = 335,
    T_AlterExtensionContentsStmt = 336,
    T_CreateEventTrigStmt = 337,
    T_AlterEventTrigStmt = 338,
    T_RefreshMatViewStmt = 339,
    T_ReplicaIdentityStmt = 340,
    T_AlterSystemStmt = 341,
    T_CreatePolicyStmt = 342,
    T_AlterPolicyStmt = 343,
    T_CreateTransformStmt = 344,
    T_CreateAmStmt = 345,
    T_CreatePublicationStmt = 346,
    T_AlterPublicationStmt = 347,
    T_CreateSubscriptionStmt = 348,
    T_AlterSubscriptionStmt = 349,
    T_DropSubscriptionStmt = 350,
    T_CreateStatsStmt = 351,
    T_AlterCollationStmt = 352,
    T_CallStmt = 353,
    T_AlterStatsStmt = 354,
    T_A_Expr = 355,
    T_ColumnRef = 356,
    T_ParamRef = 357,
    T_A_Const = 358,
    T_FuncCall = 359,
    T_A_Star = 360,
    T_A_Indices = 361,
    T_A_Indirection = 362,
    T_A_ArrayExpr = 363,
    T_ResTarget = 364,
    T_MultiAssignRef = 365,
    T_TypeCast = 366,
    T_CollateClause = 367,
    T_SortBy = 368,
    T_WindowDef = 369,
    T_RangeSubselect = 370,
    T_RangeFunction = 371,
    T_RangeTableSample = 372,
    T_RangeTableFunc = 373,
    T_RangeTableFuncCol = 374,
    T_TypeName = 375,
    T_ColumnDef = 376,
    T_IndexElem = 377,
    T_StatsElem = 378,
    T_Constraint = 379,
    T_DefElem = 380,
    T_RangeTblEntry = 381,
    T_RangeTblFunction = 382,
    T_TableSampleClause = 383,
    T_WithCheckOption = 384,
    T_SortGroupClause = 385,
    T_GroupingSet = 386,
    T_WindowClause = 387,
    T_ObjectWithArgs = 388,
    T_AccessPriv = 389,
    T_CreateOpClassItem = 390,
    T_TableLikeClause = 391,
    T_FunctionParameter = 392,
    T_LockingClause = 393,
    T_RowMarkClause = 394,
    T_XmlSerialize = 395,
    T_WithClause = 396,
    T_InferClause = 397,
    T_OnConflictClause = 398,
    T_CTESearchClause = 399,
    T_CTECycleClause = 400,
    T_CommonTableExpr = 401,
    T_MergeWhenClause = 402,
    T_RoleSpec = 403,
    T_TriggerTransition = 404,
    T_PartitionElem = 405,
    T_PartitionSpec = 406,
    T_PartitionBoundSpec = 407,
    T_PartitionRangeDatum = 408,
    T_PartitionCmd = 409,
    T_VacuumRelation = 410,
    T_PublicationObjSpec = 411,
    T_PublicationTable = 412,
    T_IdentifySystemCmd = 413,
    T_BaseBackupCmd = 414,
    T_CreateReplicationSlotCmd = 415,
    T_DropReplicationSlotCmd = 416,
    T_ReadReplicationSlotCmd = 417,
    T_StartReplicationCmd = 418,
    T_TimeLineHistoryCmd = 419,
    T_TriggerData = 420,
    T_EventTriggerData = 421,
    T_ReturnSetInfo = 422,
    T_WindowObjectData = 423,
    T_TIDBitmap = 424,
    T_InlineCodeBlock = 425,
    T_FdwRoutine = 426,
    T_IndexAmRoutine = 427,
    T_TableAmRoutine = 428,
    T_TsmRoutine = 429,
    T_ForeignKeyCacheInfo = 430,
    T_CallContext = 431,
    T_SupportRequestSimplify = 432,
    T_SupportRequestSelectivity = 433,
    T_SupportRequestCost = 434,
    T_SupportRequestRows = 435,
    T_SupportRequestIndexCondition = 436,
    T_SupportRequestWFuncMonotonic = 437,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Node {
    pub type_: NodeTag,
}
impl Default for Node {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Selectivity = f64;
pub type Cost = f64;
pub type Cardinality = f64;
pub mod CmdType {
    pub type Type = ::core::ffi::c_uint;
    pub const CMD_UNKNOWN: Type = 0;
    pub const CMD_SELECT: Type = 1;
    pub const CMD_UPDATE: Type = 2;
    pub const CMD_INSERT: Type = 3;
    pub const CMD_DELETE: Type = 4;
    pub const CMD_MERGE: Type = 5;
    pub const CMD_UTILITY: Type = 6;
    pub const CMD_NOTHING: Type = 7;
}
pub mod JoinType {
    pub type Type = ::core::ffi::c_uint;
    pub const JOIN_INNER: Type = 0;
    pub const JOIN_LEFT: Type = 1;
    pub const JOIN_FULL: Type = 2;
    pub const JOIN_RIGHT: Type = 3;
    pub const JOIN_SEMI: Type = 4;
    pub const JOIN_ANTI: Type = 5;
    pub const JOIN_UNIQUE_OUTER: Type = 6;
    pub const JOIN_UNIQUE_INNER: Type = 7;
}
pub mod AggStrategy {
    pub type Type = ::core::ffi::c_uint;
    pub const AGG_PLAIN: Type = 0;
    pub const AGG_SORTED: Type = 1;
    pub const AGG_HASHED: Type = 2;
    pub const AGG_MIXED: Type = 3;
}
pub mod AggSplit {
    pub type Type = ::core::ffi::c_uint;
    pub const AGGSPLIT_SIMPLE: Type = 0;
    pub const AGGSPLIT_INITIAL_SERIAL: Type = 6;
    pub const AGGSPLIT_FINAL_DESERIAL: Type = 9;
}
pub mod SetOpCmd {
    pub type Type = ::core::ffi::c_uint;
    pub const SETOPCMD_INTERSECT: Type = 0;
    pub const SETOPCMD_INTERSECT_ALL: Type = 1;
    pub const SETOPCMD_EXCEPT: Type = 2;
    pub const SETOPCMD_EXCEPT_ALL: Type = 3;
}
pub mod SetOpStrategy {
    pub type Type = ::core::ffi::c_uint;
    pub const SETOP_SORTED: Type = 0;
    pub const SETOP_HASHED: Type = 1;
}
pub mod OnConflictAction {
    pub type Type = ::core::ffi::c_uint;
    pub const ONCONFLICT_NONE: Type = 0;
    pub const ONCONFLICT_NOTHING: Type = 1;
    pub const ONCONFLICT_UPDATE: Type = 2;
}
pub mod LimitOption {
    pub type Type = ::core::ffi::c_uint;
    pub const LIMIT_OPTION_COUNT: Type = 0;
    pub const LIMIT_OPTION_WITH_TIES: Type = 1;
    pub const LIMIT_OPTION_DEFAULT: Type = 2;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union ListCell {
    pub ptr_value: *mut ::core::ffi::c_void,
    pub int_value: ::core::ffi::c_int,
    pub oid_value: Oid,
}
impl Default for ListCell {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
pub struct List {
    pub type_: NodeTag,
    pub length: ::core::ffi::c_int,
    pub max_length: ::core::ffi::c_int,
    pub elements: *mut ListCell,
    pub initial_elements: __IncompleteArrayField<ListCell>,
}
impl Default for List {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ForEachState {
    pub l: *const List,
    pub i: ::core::ffi::c_int,
}
impl Default for ForEachState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ForBothState {
    pub l1: *const List,
    pub l2: *const List,
    pub i: ::core::ffi::c_int,
}
impl Default for ForBothState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ForBothCellState {
    pub l1: *const List,
    pub l2: *const List,
    pub i1: ::core::ffi::c_int,
    pub i2: ::core::ffi::c_int,
}
impl Default for ForBothCellState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ForThreeState {
    pub l1: *const List,
    pub l2: *const List,
    pub l3: *const List,
    pub i: ::core::ffi::c_int,
}
impl Default for ForThreeState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ForFourState {
    pub l1: *const List,
    pub l2: *const List,
    pub l3: *const List,
    pub l4: *const List,
    pub i: ::core::ffi::c_int,
}
impl Default for ForFourState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ForFiveState {
    pub l1: *const List,
    pub l2: *const List,
    pub l3: *const List,
    pub l4: *const List,
    pub l5: *const List,
    pub i: ::core::ffi::c_int,
}
impl Default for ForFiveState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type list_sort_comparator = ::core::option::Option<
    unsafe extern "C-unwind" fn(a: *const ListCell, b: *const ListCell) -> ::core::ffi::c_int,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AttrDefault {
    pub adnum: AttrNumber,
    pub adbin: *mut ::core::ffi::c_char,
}
impl Default for AttrDefault {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ConstrCheck {
    pub ccname: *mut ::core::ffi::c_char,
    pub ccbin: *mut ::core::ffi::c_char,
    pub ccvalid: bool,
    pub ccnoinherit: bool,
}
impl Default for ConstrCheck {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TupleConstr {
    pub defval: *mut AttrDefault,
    pub check: *mut ConstrCheck,
    pub missing: *mut AttrMissing,
    pub num_defval: uint16,
    pub num_check: uint16,
    pub has_not_null: bool,
    pub has_generated_stored: bool,
}
impl Default for TupleConstr {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct TupleDescData {
    pub natts: ::core::ffi::c_int,
    pub tdtypeid: Oid,
    pub tdtypmod: int32,
    pub tdrefcount: ::core::ffi::c_int,
    pub constr: *mut TupleConstr,
    pub attrs: __IncompleteArrayField<FormData_pg_attribute>,
}
impl Default for TupleDescData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type TupleDesc = *mut TupleDescData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AttrMap {
    pub attnums: *mut AttrNumber,
    pub maplen: ::core::ffi::c_int,
}
impl Default for AttrMap {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type BlockNumber = uint32;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct BlockIdData {
    pub bi_hi: uint16,
    pub bi_lo: uint16,
}
pub type BlockId = *mut BlockIdData;
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Default, Copy, Clone)]
pub struct ItemIdData {
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
impl ItemIdData {
    #[inline]
    pub fn lp_off(&self) -> ::core::ffi::c_uint {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 15u8) as u32) }
    }
    #[inline]
    pub fn set_lp_off(&mut self, val: ::core::ffi::c_uint) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 15u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lp_off_raw(this: *const Self) -> ::core::ffi::c_uint {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                15u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_lp_off_raw(this: *mut Self, val: ::core::ffi::c_uint) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                15u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn lp_flags(&self) -> ::core::ffi::c_uint {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(15usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_lp_flags(&mut self, val: ::core::ffi::c_uint) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(15usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lp_flags_raw(this: *const Self) -> ::core::ffi::c_uint {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                15usize,
                2u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_lp_flags_raw(this: *mut Self, val: ::core::ffi::c_uint) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                15usize,
                2u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn lp_len(&self) -> ::core::ffi::c_uint {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(17usize, 15u8) as u32) }
    }
    #[inline]
    pub fn set_lp_len(&mut self, val: ::core::ffi::c_uint) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(17usize, 15u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lp_len_raw(this: *const Self) -> ::core::ffi::c_uint {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                17usize,
                15u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_lp_len_raw(this: *mut Self, val: ::core::ffi::c_uint) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                17usize,
                15u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        lp_off: ::core::ffi::c_uint,
        lp_flags: ::core::ffi::c_uint,
        lp_len: ::core::ffi::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 15u8, {
            let lp_off: u32 = unsafe { ::core::mem::transmute(lp_off) };
            lp_off as u64
        });
        __bindgen_bitfield_unit.set(15usize, 2u8, {
            let lp_flags: u32 = unsafe { ::core::mem::transmute(lp_flags) };
            lp_flags as u64
        });
        __bindgen_bitfield_unit.set(17usize, 15u8, {
            let lp_len: u32 = unsafe { ::core::mem::transmute(lp_len) };
            lp_len as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type ItemId = *mut ItemIdData;
pub type ItemOffset = uint16;
pub type ItemLength = uint16;
pub type OffsetNumber = uint16;
#[repr(C, packed(2))]
#[derive(Debug, Default, Copy, Clone)]
pub struct ItemPointerData {
    pub ip_blkid: BlockIdData,
    pub ip_posid: OffsetNumber,
}
pub type ItemPointer = *mut ItemPointerData;
pub type HeapTupleHeader = *mut HeapTupleHeaderData;
pub type MinimalTuple = *mut MinimalTupleData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HeapTupleData {
    pub t_len: uint32,
    pub t_self: ItemPointerData,
    pub t_tableOid: Oid,
    pub t_data: HeapTupleHeader,
}
impl Default for HeapTupleData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type HeapTuple = *mut HeapTupleData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct iovec {
    pub iov_base: *mut ::core::ffi::c_void,
    pub iov_len: usize,
}
impl Default for iovec {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type XLogRecPtr = uint64;
pub type XLogSegNo = uint64;
pub type TimeLineID = uint32;
pub type RepOriginId = uint16;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct FullTransactionId {
    pub value: uint64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VariableCacheData {
    pub nextOid: Oid,
    pub oidCount: uint32,
    pub nextXid: FullTransactionId,
    pub oldestXid: TransactionId,
    pub xidVacLimit: TransactionId,
    pub xidWarnLimit: TransactionId,
    pub xidStopLimit: TransactionId,
    pub xidWrapLimit: TransactionId,
    pub oldestXidDB: Oid,
    pub oldestCommitTsXid: TransactionId,
    pub newestCommitTsXid: TransactionId,
    pub latestCompletedXid: FullTransactionId,
    pub xactCompletionCount: uint64,
    pub oldestClogXid: TransactionId,
}
impl Default for VariableCacheData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type VariableCache = *mut VariableCacheData;
pub type Item = Pointer;
pub type Page = Pointer;
pub type LocationIndex = uint16;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct PageXLogRecPtr {
    pub xlogid: uint32,
    pub xrecoff: uint32,
}
#[repr(C)]
#[derive(Debug)]
pub struct PageHeaderData {
    pub pd_lsn: PageXLogRecPtr,
    pub pd_checksum: uint16,
    pub pd_flags: uint16,
    pub pd_lower: LocationIndex,
    pub pd_upper: LocationIndex,
    pub pd_special: LocationIndex,
    pub pd_pagesize_version: uint16,
    pub pd_prune_xid: TransactionId,
    pub pd_linp: __IncompleteArrayField<ItemIdData>,
}
impl Default for PageHeaderData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type PageHeader = *mut PageHeaderData;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct HeapTupleFields {
    pub t_xmin: TransactionId,
    pub t_xmax: TransactionId,
    pub t_field3: HeapTupleFields__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union HeapTupleFields__bindgen_ty_1 {
    pub t_cid: CommandId,
    pub t_xvac: TransactionId,
}
impl Default for HeapTupleFields__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for HeapTupleFields {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DatumTupleFields {
    pub datum_len_: int32,
    pub datum_typmod: int32,
    pub datum_typeid: Oid,
}
impl Default for DatumTupleFields {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
pub struct HeapTupleHeaderData {
    pub t_choice: HeapTupleHeaderData__bindgen_ty_1,
    pub t_ctid: ItemPointerData,
    pub t_infomask2: uint16,
    pub t_infomask: uint16,
    pub t_hoff: uint8,
    pub t_bits: __IncompleteArrayField<bits8>,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union HeapTupleHeaderData__bindgen_ty_1 {
    pub t_heap: HeapTupleFields,
    pub t_datum: DatumTupleFields,
}
impl Default for HeapTupleHeaderData__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for HeapTupleHeaderData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct MinimalTupleData {
    pub t_len: uint32,
    pub mt_padding: [::core::ffi::c_char; 6usize],
    pub t_infomask2: uint16,
    pub t_infomask: uint16,
    pub t_hoff: uint8,
    pub t_bits: __IncompleteArrayField<bits8>,
}
pub type Buffer = ::core::ffi::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BufferAccessStrategyData {
    _unused: [u8; 0],
}
pub type BufferAccessStrategy = *mut BufferAccessStrategyData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TupleTableSlot {
    pub type_: NodeTag,
    pub tts_flags: uint16,
    pub tts_nvalid: AttrNumber,
    pub tts_ops: *const TupleTableSlotOps,
    pub tts_tupleDescriptor: TupleDesc,
    pub tts_values: *mut Datum,
    pub tts_isnull: *mut bool,
    pub tts_mcxt: MemoryContext,
    pub tts_tid: ItemPointerData,
    pub tts_tableOid: Oid,
}
impl Default for TupleTableSlot {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct TupleTableSlotOps {
    pub base_slot_size: usize,
    pub init: ::core::option::Option<unsafe extern "C-unwind" fn(slot: *mut TupleTableSlot)>,
    pub release: ::core::option::Option<unsafe extern "C-unwind" fn(slot: *mut TupleTableSlot)>,
    pub clear: ::core::option::Option<unsafe extern "C-unwind" fn(slot: *mut TupleTableSlot)>,
    pub getsomeattrs: ::core::option::Option<
        unsafe extern "C-unwind" fn(slot: *mut TupleTableSlot, natts: ::core::ffi::c_int),
    >,
    pub getsysattr: ::core::option::Option<
        unsafe extern "C-unwind" fn(
            slot: *mut TupleTableSlot,
            attnum: ::core::ffi::c_int,
            isnull: *mut bool,
        ) -> Datum,
    >,
    pub materialize: ::core::option::Option<unsafe extern "C-unwind" fn(slot: *mut TupleTableSlot)>,
    pub copyslot: ::core::option::Option<
        unsafe extern "C-unwind" fn(dstslot: *mut TupleTableSlot, srcslot: *mut TupleTableSlot),
    >,
    pub get_heap_tuple:
        ::core::option::Option<unsafe extern "C-unwind" fn(slot: *mut TupleTableSlot) -> HeapTuple>,
    pub get_minimal_tuple: ::core::option::Option<
        unsafe extern "C-unwind" fn(slot: *mut TupleTableSlot) -> MinimalTuple,
    >,
    pub copy_heap_tuple:
        ::core::option::Option<unsafe extern "C-unwind" fn(slot: *mut TupleTableSlot) -> HeapTuple>,
    pub copy_minimal_tuple: ::core::option::Option<
        unsafe extern "C-unwind" fn(slot: *mut TupleTableSlot) -> MinimalTuple,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VirtualTupleTableSlot {
    pub base: TupleTableSlot,
    pub data: *mut ::core::ffi::c_char,
}
impl Default for VirtualTupleTableSlot {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HeapTupleTableSlot {
    pub base: TupleTableSlot,
    pub tuple: HeapTuple,
    pub off: uint32,
    pub tupdata: HeapTupleData,
}
impl Default for HeapTupleTableSlot {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BufferHeapTupleTableSlot {
    pub base: HeapTupleTableSlot,
    pub buffer: Buffer,
}
impl Default for BufferHeapTupleTableSlot {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MinimalTupleTableSlot {
    pub base: TupleTableSlot,
    pub tuple: HeapTuple,
    pub mintuple: MinimalTuple,
    pub minhdr: HeapTupleData,
    pub off: uint32,
}
impl Default for MinimalTupleTableSlot {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type bitmapword = uint64;
pub type signedbitmapword = int64;
#[repr(C)]
#[derive(Debug, Default)]
pub struct Bitmapset {
    pub nwords: ::core::ffi::c_int,
    pub words: __IncompleteArrayField<bitmapword>,
}
pub mod BMS_Comparison {
    pub type Type = ::core::ffi::c_uint;
    pub const BMS_EQUAL: Type = 0;
    pub const BMS_SUBSET1: Type = 1;
    pub const BMS_SUBSET2: Type = 2;
    pub const BMS_DIFFERENT: Type = 3;
}
pub mod BMS_Membership {
    pub type Type = ::core::ffi::c_uint;
    pub const BMS_EMPTY_SET: Type = 0;
    pub const BMS_SINGLETON: Type = 1;
    pub const BMS_MULTIPLE: Type = 2;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TupleConversionMap {
    pub indesc: TupleDesc,
    pub outdesc: TupleDesc,
    pub attrMap: *mut AttrMap,
    pub invalues: *mut Datum,
    pub inisnull: *mut bool,
    pub outvalues: *mut Datum,
    pub outisnull: *mut bool,
}
impl Default for TupleConversionMap {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type instr_time = timespec;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct BufferUsage {
    pub shared_blks_hit: int64,
    pub shared_blks_read: int64,
    pub shared_blks_dirtied: int64,
    pub shared_blks_written: int64,
    pub local_blks_hit: int64,
    pub local_blks_read: int64,
    pub local_blks_dirtied: int64,
    pub local_blks_written: int64,
    pub temp_blks_read: int64,
    pub temp_blks_written: int64,
    pub blk_read_time: instr_time,
    pub blk_write_time: instr_time,
    pub temp_blk_read_time: instr_time,
    pub temp_blk_write_time: instr_time,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct WalUsage {
    pub wal_records: int64,
    pub wal_fpi: int64,
    pub wal_bytes: uint64,
}
pub mod InstrumentOption {
    pub type Type = ::core::ffi::c_uint;
    pub const INSTRUMENT_TIMER: Type = 1;
    pub const INSTRUMENT_BUFFERS: Type = 2;
    pub const INSTRUMENT_ROWS: Type = 4;
    pub const INSTRUMENT_WAL: Type = 8;
    pub const INSTRUMENT_ALL: Type = 2147483647;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct Instrumentation {
    pub need_timer: bool,
    pub need_bufusage: bool,
    pub need_walusage: bool,
    pub async_mode: bool,
    pub running: bool,
    pub starttime: instr_time,
    pub counter: instr_time,
    pub firsttuple: f64,
    pub tuplecount: f64,
    pub bufusage_start: BufferUsage,
    pub walusage_start: WalUsage,
    pub startup: f64,
    pub total: f64,
    pub ntuples: f64,
    pub ntuples2: f64,
    pub nloops: f64,
    pub nfiltered1: f64,
    pub nfiltered2: f64,
    pub bufusage: BufferUsage,
    pub walusage: WalUsage,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct WorkerInstrumentation {
    pub num_workers: ::core::ffi::c_int,
    pub instrument: __IncompleteArrayField<Instrumentation>,
}
pub type fmNodePtr = *mut Node;
pub type fmAggrefPtr = *mut Aggref;
pub type fmExprContextCallbackFunction =
    ::core::option::Option<unsafe extern "C-unwind" fn(arg: Datum)>;
pub type fmStringInfo = *mut StringInfoData;
pub type FunctionCallInfo = *mut FunctionCallInfoBaseData;
pub type PGFunction =
    ::core::option::Option<unsafe extern "C-unwind" fn(fcinfo: FunctionCallInfo) -> Datum>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FmgrInfo {
    pub fn_addr: PGFunction,
    pub fn_oid: Oid,
    pub fn_nargs: ::core::ffi::c_short,
    pub fn_strict: bool,
    pub fn_retset: bool,
    pub fn_stats: ::core::ffi::c_uchar,
    pub fn_extra: *mut ::core::ffi::c_void,
    pub fn_mcxt: MemoryContext,
    pub fn_expr: fmNodePtr,
}
impl Default for FmgrInfo {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct FunctionCallInfoBaseData {
    pub flinfo: *mut FmgrInfo,
    pub context: fmNodePtr,
    pub resultinfo: fmNodePtr,
    pub fncollation: Oid,
    pub isnull: bool,
    pub nargs: ::core::ffi::c_short,
    pub args: __IncompleteArrayField<NullableDatum>,
}
impl Default for FunctionCallInfoBaseData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct Pg_finfo_record {
    pub api_version: ::core::ffi::c_int,
}
pub type PGFInfoFunction =
    ::core::option::Option<unsafe extern "C-unwind" fn() -> *const Pg_finfo_record>;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct Pg_magic_struct {
    pub len: ::core::ffi::c_int,
    pub version: ::core::ffi::c_int,
    pub funcmaxargs: ::core::ffi::c_int,
    pub indexmaxkeys: ::core::ffi::c_int,
    pub namedatalen: ::core::ffi::c_int,
    pub float8byval: ::core::ffi::c_int,
    pub abi_extra: [::core::ffi::c_char; 32usize],
}
pub type PGModuleMagicFunction =
    ::core::option::Option<unsafe extern "C-unwind" fn() -> *const Pg_magic_struct>;
pub mod FmgrHookEventType {
    pub type Type = ::core::ffi::c_uint;
    pub const FHET_START: Type = 0;
    pub const FHET_END: Type = 1;
    pub const FHET_ABORT: Type = 2;
}
pub type needs_fmgr_hook_type =
    ::core::option::Option<unsafe extern "C-unwind" fn(fn_oid: Oid) -> bool>;
pub type fmgr_hook_type = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        event: FmgrHookEventType::Type,
        flinfo: *mut FmgrInfo,
        arg: *mut Datum,
    ),
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dlist_node {
    pub prev: *mut dlist_node,
    pub next: *mut dlist_node,
}
impl Default for dlist_node {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dlist_head {
    pub head: dlist_node,
}
impl Default for dlist_head {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dlist_iter {
    pub cur: *mut dlist_node,
    pub end: *mut dlist_node,
}
impl Default for dlist_iter {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dlist_mutable_iter {
    pub cur: *mut dlist_node,
    pub next: *mut dlist_node,
    pub end: *mut dlist_node,
}
impl Default for dlist_mutable_iter {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct slist_node {
    pub next: *mut slist_node,
}
impl Default for slist_node {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct slist_head {
    pub head: slist_node,
}
impl Default for slist_head {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct slist_iter {
    pub cur: *mut slist_node,
}
impl Default for slist_iter {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct slist_mutable_iter {
    pub cur: *mut slist_node,
    pub next: *mut slist_node,
    pub prev: *mut slist_node,
}
impl Default for slist_mutable_iter {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StringInfoData {
    pub data: *mut ::core::ffi::c_char,
    pub len: ::core::ffi::c_int,
    pub maxlen: ::core::ffi::c_int,
    pub cursor: ::core::ffi::c_int,
}
impl Default for StringInfoData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type StringInfo = *mut StringInfoData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pairingheap_node {
    pub first_child: *mut pairingheap_node,
    pub next_sibling: *mut pairingheap_node,
    pub prev_or_parent: *mut pairingheap_node,
}
impl Default for pairingheap_node {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type pairingheap_comparator = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        a: *const pairingheap_node,
        b: *const pairingheap_node,
        arg: *mut ::core::ffi::c_void,
    ) -> ::core::ffi::c_int,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pairingheap {
    pub ph_compare: pairingheap_comparator,
    pub ph_arg: *mut ::core::ffi::c_void,
    pub ph_root: *mut pairingheap_node,
}
impl Default for pairingheap {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ParamExternData {
    pub value: Datum,
    pub isnull: bool,
    pub pflags: uint16,
    pub ptype: Oid,
}
impl Default for ParamExternData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type ParamListInfo = *mut ParamListInfoData;
pub type ParamFetchHook = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        params: ParamListInfo,
        paramid: ::core::ffi::c_int,
        speculative: bool,
        workspace: *mut ParamExternData,
    ) -> *mut ParamExternData,
>;
pub type ParamCompileHook = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        params: ParamListInfo,
        param: *mut Param,
        state: *mut ExprState,
        resv: *mut Datum,
        resnull: *mut bool,
    ),
>;
pub type ParserSetupHook = ::core::option::Option<
    unsafe extern "C-unwind" fn(pstate: *mut ParseState, arg: *mut ::core::ffi::c_void),
>;
#[repr(C)]
#[derive(Debug)]
pub struct ParamListInfoData {
    pub paramFetch: ParamFetchHook,
    pub paramFetchArg: *mut ::core::ffi::c_void,
    pub paramCompile: ParamCompileHook,
    pub paramCompileArg: *mut ::core::ffi::c_void,
    pub parserSetup: ParserSetupHook,
    pub parserSetupArg: *mut ::core::ffi::c_void,
    pub paramValuesStr: *mut ::core::ffi::c_char,
    pub numParams: ::core::ffi::c_int,
    pub params: __IncompleteArrayField<ParamExternData>,
}
impl Default for ParamListInfoData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ParamExecData {
    pub execPlan: *mut ::core::ffi::c_void,
    pub value: Datum,
    pub isnull: bool,
}
impl Default for ParamExecData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ParamsErrorCbData {
    pub portalName: *const ::core::ffi::c_char,
    pub params: ParamListInfo,
}
impl Default for ParamsErrorCbData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod ScanDirection {
    pub type Type = ::core::ffi::c_int;
    pub const BackwardScanDirection: Type = -1;
    pub const NoMovementScanDirection: Type = 0;
    pub const ForwardScanDirection: Type = 1;
}
pub type StrategyNumber = uint16;
pub mod LockClauseStrength {
    pub type Type = ::core::ffi::c_uint;
    pub const LCS_NONE: Type = 0;
    pub const LCS_FORKEYSHARE: Type = 1;
    pub const LCS_FORSHARE: Type = 2;
    pub const LCS_FORNOKEYUPDATE: Type = 3;
    pub const LCS_FORUPDATE: Type = 4;
}
pub mod LockWaitPolicy {
    pub type Type = ::core::ffi::c_uint;
    pub const LockWaitBlock: Type = 0;
    pub const LockWaitSkip: Type = 1;
    pub const LockWaitError: Type = 2;
}
pub mod LockTupleMode {
    pub type Type = ::core::ffi::c_uint;
    pub const LockTupleKeyShare: Type = 0;
    pub const LockTupleShare: Type = 1;
    pub const LockTupleNoKeyExclusive: Type = 2;
    pub const LockTupleExclusive: Type = 3;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Alias {
    pub type_: NodeTag,
    pub aliasname: *mut ::core::ffi::c_char,
    pub colnames: *mut List,
}
impl Default for Alias {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod OnCommitAction {
    pub type Type = ::core::ffi::c_uint;
    pub const ONCOMMIT_NOOP: Type = 0;
    pub const ONCOMMIT_PRESERVE_ROWS: Type = 1;
    pub const ONCOMMIT_DELETE_ROWS: Type = 2;
    pub const ONCOMMIT_DROP: Type = 3;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RangeVar {
    pub type_: NodeTag,
    pub catalogname: *mut ::core::ffi::c_char,
    pub schemaname: *mut ::core::ffi::c_char,
    pub relname: *mut ::core::ffi::c_char,
    pub inh: bool,
    pub relpersistence: ::core::ffi::c_char,
    pub alias: *mut Alias,
    pub location: ::core::ffi::c_int,
}
impl Default for RangeVar {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TableFunc {
    pub type_: NodeTag,
    pub ns_uris: *mut List,
    pub ns_names: *mut List,
    pub docexpr: *mut Node,
    pub rowexpr: *mut Node,
    pub colnames: *mut List,
    pub coltypes: *mut List,
    pub coltypmods: *mut List,
    pub colcollations: *mut List,
    pub colexprs: *mut List,
    pub coldefexprs: *mut List,
    pub notnulls: *mut Bitmapset,
    pub ordinalitycol: ::core::ffi::c_int,
    pub location: ::core::ffi::c_int,
}
impl Default for TableFunc {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IntoClause {
    pub type_: NodeTag,
    pub rel: *mut RangeVar,
    pub colNames: *mut List,
    pub accessMethod: *mut ::core::ffi::c_char,
    pub options: *mut List,
    pub onCommit: OnCommitAction::Type,
    pub tableSpaceName: *mut ::core::ffi::c_char,
    pub viewQuery: *mut Node,
    pub skipData: bool,
}
impl Default for IntoClause {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Expr {
    pub type_: NodeTag,
}
impl Default for Expr {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Var {
    pub xpr: Expr,
    pub varno: ::core::ffi::c_int,
    pub varattno: AttrNumber,
    pub vartype: Oid,
    pub vartypmod: int32,
    pub varcollid: Oid,
    pub varlevelsup: Index,
    pub varnosyn: Index,
    pub varattnosyn: AttrNumber,
    pub location: ::core::ffi::c_int,
}
impl Default for Var {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Const {
    pub xpr: Expr,
    pub consttype: Oid,
    pub consttypmod: int32,
    pub constcollid: Oid,
    pub constlen: ::core::ffi::c_int,
    pub constvalue: Datum,
    pub constisnull: bool,
    pub constbyval: bool,
    pub location: ::core::ffi::c_int,
}
impl Default for Const {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod ParamKind {
    pub type Type = ::core::ffi::c_uint;
    pub const PARAM_EXTERN: Type = 0;
    pub const PARAM_EXEC: Type = 1;
    pub const PARAM_SUBLINK: Type = 2;
    pub const PARAM_MULTIEXPR: Type = 3;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Param {
    pub xpr: Expr,
    pub paramkind: ParamKind::Type,
    pub paramid: ::core::ffi::c_int,
    pub paramtype: Oid,
    pub paramtypmod: int32,
    pub paramcollid: Oid,
    pub location: ::core::ffi::c_int,
}
impl Default for Param {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Aggref {
    pub xpr: Expr,
    pub aggfnoid: Oid,
    pub aggtype: Oid,
    pub aggcollid: Oid,
    pub inputcollid: Oid,
    pub aggtranstype: Oid,
    pub aggargtypes: *mut List,
    pub aggdirectargs: *mut List,
    pub args: *mut List,
    pub aggorder: *mut List,
    pub aggdistinct: *mut List,
    pub aggfilter: *mut Expr,
    pub aggstar: bool,
    pub aggvariadic: bool,
    pub aggkind: ::core::ffi::c_char,
    pub agglevelsup: Index,
    pub aggsplit: AggSplit::Type,
    pub aggno: ::core::ffi::c_int,
    pub aggtransno: ::core::ffi::c_int,
    pub location: ::core::ffi::c_int,
}
impl Default for Aggref {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GroupingFunc {
    pub xpr: Expr,
    pub args: *mut List,
    pub refs: *mut List,
    pub cols: *mut List,
    pub agglevelsup: Index,
    pub location: ::core::ffi::c_int,
}
impl Default for GroupingFunc {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WindowFunc {
    pub xpr: Expr,
    pub winfnoid: Oid,
    pub wintype: Oid,
    pub wincollid: Oid,
    pub inputcollid: Oid,
    pub args: *mut List,
    pub aggfilter: *mut Expr,
    pub winref: Index,
    pub winstar: bool,
    pub winagg: bool,
    pub location: ::core::ffi::c_int,
}
impl Default for WindowFunc {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SubscriptingRef {
    pub xpr: Expr,
    pub refcontainertype: Oid,
    pub refelemtype: Oid,
    pub refrestype: Oid,
    pub reftypmod: int32,
    pub refcollid: Oid,
    pub refupperindexpr: *mut List,
    pub reflowerindexpr: *mut List,
    pub refexpr: *mut Expr,
    pub refassgnexpr: *mut Expr,
}
impl Default for SubscriptingRef {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod CoercionContext {
    pub type Type = ::core::ffi::c_uint;
    pub const COERCION_IMPLICIT: Type = 0;
    pub const COERCION_ASSIGNMENT: Type = 1;
    pub const COERCION_PLPGSQL: Type = 2;
    pub const COERCION_EXPLICIT: Type = 3;
}
pub mod CoercionForm {
    pub type Type = ::core::ffi::c_uint;
    pub const COERCE_EXPLICIT_CALL: Type = 0;
    pub const COERCE_EXPLICIT_CAST: Type = 1;
    pub const COERCE_IMPLICIT_CAST: Type = 2;
    pub const COERCE_SQL_SYNTAX: Type = 3;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FuncExpr {
    pub xpr: Expr,
    pub funcid: Oid,
    pub funcresulttype: Oid,
    pub funcretset: bool,
    pub funcvariadic: bool,
    pub funcformat: CoercionForm::Type,
    pub funccollid: Oid,
    pub inputcollid: Oid,
    pub args: *mut List,
    pub location: ::core::ffi::c_int,
}
impl Default for FuncExpr {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NamedArgExpr {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub name: *mut ::core::ffi::c_char,
    pub argnumber: ::core::ffi::c_int,
    pub location: ::core::ffi::c_int,
}
impl Default for NamedArgExpr {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OpExpr {
    pub xpr: Expr,
    pub opno: Oid,
    pub opfuncid: Oid,
    pub opresulttype: Oid,
    pub opretset: bool,
    pub opcollid: Oid,
    pub inputcollid: Oid,
    pub args: *mut List,
    pub location: ::core::ffi::c_int,
}
impl Default for OpExpr {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type DistinctExpr = OpExpr;
pub type NullIfExpr = OpExpr;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ScalarArrayOpExpr {
    pub xpr: Expr,
    pub opno: Oid,
    pub opfuncid: Oid,
    pub hashfuncid: Oid,
    pub negfuncid: Oid,
    pub useOr: bool,
    pub inputcollid: Oid,
    pub args: *mut List,
    pub location: ::core::ffi::c_int,
}
impl Default for ScalarArrayOpExpr {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod BoolExprType {
    pub type Type = ::core::ffi::c_uint;
    pub const AND_EXPR: Type = 0;
    pub const OR_EXPR: Type = 1;
    pub const NOT_EXPR: Type = 2;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BoolExpr {
    pub xpr: Expr,
    pub boolop: BoolExprType::Type,
    pub args: *mut List,
    pub location: ::core::ffi::c_int,
}
impl Default for BoolExpr {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod SubLinkType {
    pub type Type = ::core::ffi::c_uint;
    pub const EXISTS_SUBLINK: Type = 0;
    pub const ALL_SUBLINK: Type = 1;
    pub const ANY_SUBLINK: Type = 2;
    pub const ROWCOMPARE_SUBLINK: Type = 3;
    pub const EXPR_SUBLINK: Type = 4;
    pub const MULTIEXPR_SUBLINK: Type = 5;
    pub const ARRAY_SUBLINK: Type = 6;
    pub const CTE_SUBLINK: Type = 7;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SubLink {
    pub xpr: Expr,
    pub subLinkType: SubLinkType::Type,
    pub subLinkId: ::core::ffi::c_int,
    pub testexpr: *mut Node,
    pub operName: *mut List,
    pub subselect: *mut Node,
    pub location: ::core::ffi::c_int,
}
impl Default for SubLink {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SubPlan {
    pub xpr: Expr,
    pub subLinkType: SubLinkType::Type,
    pub testexpr: *mut Node,
    pub paramIds: *mut List,
    pub plan_id: ::core::ffi::c_int,
    pub plan_name: *mut ::core::ffi::c_char,
    pub firstColType: Oid,
    pub firstColTypmod: int32,
    pub firstColCollation: Oid,
    pub useHashTable: bool,
    pub unknownEqFalse: bool,
    pub parallel_safe: bool,
    pub setParam: *mut List,
    pub parParam: *mut List,
    pub args: *mut List,
    pub startup_cost: Cost,
    pub per_call_cost: Cost,
}
impl Default for SubPlan {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlternativeSubPlan {
    pub xpr: Expr,
    pub subplans: *mut List,
}
impl Default for AlternativeSubPlan {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FieldSelect {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub fieldnum: AttrNumber,
    pub resulttype: Oid,
    pub resulttypmod: int32,
    pub resultcollid: Oid,
}
impl Default for FieldSelect {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FieldStore {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub newvals: *mut List,
    pub fieldnums: *mut List,
    pub resulttype: Oid,
}
impl Default for FieldStore {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RelabelType {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub resulttype: Oid,
    pub resulttypmod: int32,
    pub resultcollid: Oid,
    pub relabelformat: CoercionForm::Type,
    pub location: ::core::ffi::c_int,
}
impl Default for RelabelType {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CoerceViaIO {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub resulttype: Oid,
    pub resultcollid: Oid,
    pub coerceformat: CoercionForm::Type,
    pub location: ::core::ffi::c_int,
}
impl Default for CoerceViaIO {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ArrayCoerceExpr {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub elemexpr: *mut Expr,
    pub resulttype: Oid,
    pub resulttypmod: int32,
    pub resultcollid: Oid,
    pub coerceformat: CoercionForm::Type,
    pub location: ::core::ffi::c_int,
}
impl Default for ArrayCoerceExpr {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ConvertRowtypeExpr {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub resulttype: Oid,
    pub convertformat: CoercionForm::Type,
    pub location: ::core::ffi::c_int,
}
impl Default for ConvertRowtypeExpr {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CollateExpr {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub collOid: Oid,
    pub location: ::core::ffi::c_int,
}
impl Default for CollateExpr {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CaseExpr {
    pub xpr: Expr,
    pub casetype: Oid,
    pub casecollid: Oid,
    pub arg: *mut Expr,
    pub args: *mut List,
    pub defresult: *mut Expr,
    pub location: ::core::ffi::c_int,
}
impl Default for CaseExpr {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CaseWhen {
    pub xpr: Expr,
    pub expr: *mut Expr,
    pub result: *mut Expr,
    pub location: ::core::ffi::c_int,
}
impl Default for CaseWhen {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CaseTestExpr {
    pub xpr: Expr,
    pub typeId: Oid,
    pub typeMod: int32,
    pub collation: Oid,
}
impl Default for CaseTestExpr {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ArrayExpr {
    pub xpr: Expr,
    pub array_typeid: Oid,
    pub array_collid: Oid,
    pub element_typeid: Oid,
    pub elements: *mut List,
    pub multidims: bool,
    pub location: ::core::ffi::c_int,
}
impl Default for ArrayExpr {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RowExpr {
    pub xpr: Expr,
    pub args: *mut List,
    pub row_typeid: Oid,
    pub row_format: CoercionForm::Type,
    pub colnames: *mut List,
    pub location: ::core::ffi::c_int,
}
impl Default for RowExpr {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod RowCompareType {
    pub type Type = ::core::ffi::c_uint;
    pub const ROWCOMPARE_LT: Type = 1;
    pub const ROWCOMPARE_LE: Type = 2;
    pub const ROWCOMPARE_EQ: Type = 3;
    pub const ROWCOMPARE_GE: Type = 4;
    pub const ROWCOMPARE_GT: Type = 5;
    pub const ROWCOMPARE_NE: Type = 6;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RowCompareExpr {
    pub xpr: Expr,
    pub rctype: RowCompareType::Type,
    pub opnos: *mut List,
    pub opfamilies: *mut List,
    pub inputcollids: *mut List,
    pub largs: *mut List,
    pub rargs: *mut List,
}
impl Default for RowCompareExpr {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CoalesceExpr {
    pub xpr: Expr,
    pub coalescetype: Oid,
    pub coalescecollid: Oid,
    pub args: *mut List,
    pub location: ::core::ffi::c_int,
}
impl Default for CoalesceExpr {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod MinMaxOp {
    pub type Type = ::core::ffi::c_uint;
    pub const IS_GREATEST: Type = 0;
    pub const IS_LEAST: Type = 1;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MinMaxExpr {
    pub xpr: Expr,
    pub minmaxtype: Oid,
    pub minmaxcollid: Oid,
    pub inputcollid: Oid,
    pub op: MinMaxOp::Type,
    pub args: *mut List,
    pub location: ::core::ffi::c_int,
}
impl Default for MinMaxExpr {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod SQLValueFunctionOp {
    pub type Type = ::core::ffi::c_uint;
    pub const SVFOP_CURRENT_DATE: Type = 0;
    pub const SVFOP_CURRENT_TIME: Type = 1;
    pub const SVFOP_CURRENT_TIME_N: Type = 2;
    pub const SVFOP_CURRENT_TIMESTAMP: Type = 3;
    pub const SVFOP_CURRENT_TIMESTAMP_N: Type = 4;
    pub const SVFOP_LOCALTIME: Type = 5;
    pub const SVFOP_LOCALTIME_N: Type = 6;
    pub const SVFOP_LOCALTIMESTAMP: Type = 7;
    pub const SVFOP_LOCALTIMESTAMP_N: Type = 8;
    pub const SVFOP_CURRENT_ROLE: Type = 9;
    pub const SVFOP_CURRENT_USER: Type = 10;
    pub const SVFOP_USER: Type = 11;
    pub const SVFOP_SESSION_USER: Type = 12;
    pub const SVFOP_CURRENT_CATALOG: Type = 13;
    pub const SVFOP_CURRENT_SCHEMA: Type = 14;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SQLValueFunction {
    pub xpr: Expr,
    pub op: SQLValueFunctionOp::Type,
    pub type_: Oid,
    pub typmod: int32,
    pub location: ::core::ffi::c_int,
}
impl Default for SQLValueFunction {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod XmlExprOp {
    pub type Type = ::core::ffi::c_uint;
    pub const IS_XMLCONCAT: Type = 0;
    pub const IS_XMLELEMENT: Type = 1;
    pub const IS_XMLFOREST: Type = 2;
    pub const IS_XMLPARSE: Type = 3;
    pub const IS_XMLPI: Type = 4;
    pub const IS_XMLROOT: Type = 5;
    pub const IS_XMLSERIALIZE: Type = 6;
    pub const IS_DOCUMENT: Type = 7;
}
pub mod XmlOptionType {
    pub type Type = ::core::ffi::c_uint;
    pub const XMLOPTION_DOCUMENT: Type = 0;
    pub const XMLOPTION_CONTENT: Type = 1;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct XmlExpr {
    pub xpr: Expr,
    pub op: XmlExprOp::Type,
    pub name: *mut ::core::ffi::c_char,
    pub named_args: *mut List,
    pub arg_names: *mut List,
    pub args: *mut List,
    pub xmloption: XmlOptionType::Type,
    pub type_: Oid,
    pub typmod: int32,
    pub location: ::core::ffi::c_int,
}
impl Default for XmlExpr {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod NullTestType {
    pub type Type = ::core::ffi::c_uint;
    pub const IS_NULL: Type = 0;
    pub const IS_NOT_NULL: Type = 1;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NullTest {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub nulltesttype: NullTestType::Type,
    pub argisrow: bool,
    pub location: ::core::ffi::c_int,
}
impl Default for NullTest {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod BoolTestType {
    pub type Type = ::core::ffi::c_uint;
    pub const IS_TRUE: Type = 0;
    pub const IS_NOT_TRUE: Type = 1;
    pub const IS_FALSE: Type = 2;
    pub const IS_NOT_FALSE: Type = 3;
    pub const IS_UNKNOWN: Type = 4;
    pub const IS_NOT_UNKNOWN: Type = 5;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BooleanTest {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub booltesttype: BoolTestType::Type,
    pub location: ::core::ffi::c_int,
}
impl Default for BooleanTest {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CoerceToDomain {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub resulttype: Oid,
    pub resulttypmod: int32,
    pub resultcollid: Oid,
    pub coercionformat: CoercionForm::Type,
    pub location: ::core::ffi::c_int,
}
impl Default for CoerceToDomain {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CoerceToDomainValue {
    pub xpr: Expr,
    pub typeId: Oid,
    pub typeMod: int32,
    pub collation: Oid,
    pub location: ::core::ffi::c_int,
}
impl Default for CoerceToDomainValue {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SetToDefault {
    pub xpr: Expr,
    pub typeId: Oid,
    pub typeMod: int32,
    pub collation: Oid,
    pub location: ::core::ffi::c_int,
}
impl Default for SetToDefault {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CurrentOfExpr {
    pub xpr: Expr,
    pub cvarno: Index,
    pub cursor_name: *mut ::core::ffi::c_char,
    pub cursor_param: ::core::ffi::c_int,
}
impl Default for CurrentOfExpr {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NextValueExpr {
    pub xpr: Expr,
    pub seqid: Oid,
    pub typeId: Oid,
}
impl Default for NextValueExpr {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct InferenceElem {
    pub xpr: Expr,
    pub expr: *mut Node,
    pub infercollid: Oid,
    pub inferopclass: Oid,
}
impl Default for InferenceElem {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TargetEntry {
    pub xpr: Expr,
    pub expr: *mut Expr,
    pub resno: AttrNumber,
    pub resname: *mut ::core::ffi::c_char,
    pub ressortgroupref: Index,
    pub resorigtbl: Oid,
    pub resorigcol: AttrNumber,
    pub resjunk: bool,
}
impl Default for TargetEntry {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RangeTblRef {
    pub type_: NodeTag,
    pub rtindex: ::core::ffi::c_int,
}
impl Default for RangeTblRef {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct JoinExpr {
    pub type_: NodeTag,
    pub jointype: JoinType::Type,
    pub isNatural: bool,
    pub larg: *mut Node,
    pub rarg: *mut Node,
    pub usingClause: *mut List,
    pub join_using_alias: *mut Alias,
    pub quals: *mut Node,
    pub alias: *mut Alias,
    pub rtindex: ::core::ffi::c_int,
}
impl Default for JoinExpr {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FromExpr {
    pub type_: NodeTag,
    pub fromlist: *mut List,
    pub quals: *mut Node,
}
impl Default for FromExpr {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OnConflictExpr {
    pub type_: NodeTag,
    pub action: OnConflictAction::Type,
    pub arbiterElems: *mut List,
    pub arbiterWhere: *mut Node,
    pub constraint: Oid,
    pub onConflictSet: *mut List,
    pub onConflictWhere: *mut Node,
    pub exclRelIndex: ::core::ffi::c_int,
    pub exclRelTlist: *mut List,
}
impl Default for OnConflictExpr {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Integer {
    pub type_: NodeTag,
    pub ival: ::core::ffi::c_int,
}
impl Default for Integer {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Float {
    pub type_: NodeTag,
    pub fval: *mut ::core::ffi::c_char,
}
impl Default for Float {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Boolean {
    pub type_: NodeTag,
    pub boolval: bool,
}
impl Default for Boolean {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct String {
    pub type_: NodeTag,
    pub sval: *mut ::core::ffi::c_char,
}
impl Default for String {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BitString {
    pub type_: NodeTag,
    pub bsval: *mut ::core::ffi::c_char,
}
impl Default for BitString {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type PartitionBoundInfo = *mut PartitionBoundInfoData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionKeyData {
    _unused: [u8; 0],
}
pub type PartitionKey = *mut PartitionKeyData;
pub type PartitionDesc = *mut PartitionDescData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionDirectoryData {
    _unused: [u8; 0],
}
pub type PartitionDirectory = *mut PartitionDirectoryData;
pub mod OverridingKind {
    pub type Type = ::core::ffi::c_uint;
    pub const OVERRIDING_NOT_SET: Type = 0;
    pub const OVERRIDING_USER_VALUE: Type = 1;
    pub const OVERRIDING_SYSTEM_VALUE: Type = 2;
}
pub mod QuerySource {
    pub type Type = ::core::ffi::c_uint;
    pub const QSRC_ORIGINAL: Type = 0;
    pub const QSRC_PARSER: Type = 1;
    pub const QSRC_INSTEAD_RULE: Type = 2;
    pub const QSRC_QUAL_INSTEAD_RULE: Type = 3;
    pub const QSRC_NON_INSTEAD_RULE: Type = 4;
}
pub mod SortByDir {
    pub type Type = ::core::ffi::c_uint;
    pub const SORTBY_DEFAULT: Type = 0;
    pub const SORTBY_ASC: Type = 1;
    pub const SORTBY_DESC: Type = 2;
    pub const SORTBY_USING: Type = 3;
}
pub mod SortByNulls {
    pub type Type = ::core::ffi::c_uint;
    pub const SORTBY_NULLS_DEFAULT: Type = 0;
    pub const SORTBY_NULLS_FIRST: Type = 1;
    pub const SORTBY_NULLS_LAST: Type = 2;
}
pub mod SetQuantifier {
    pub type Type = ::core::ffi::c_uint;
    pub const SET_QUANTIFIER_DEFAULT: Type = 0;
    pub const SET_QUANTIFIER_ALL: Type = 1;
    pub const SET_QUANTIFIER_DISTINCT: Type = 2;
}
pub type AclMode = uint32;
#[doc = "\tQuery Tree"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Query {
    pub type_: NodeTag,
    pub commandType: CmdType::Type,
    pub querySource: QuerySource::Type,
    pub queryId: uint64,
    pub canSetTag: bool,
    pub utilityStmt: *mut Node,
    pub resultRelation: ::core::ffi::c_int,
    pub hasAggs: bool,
    pub hasWindowFuncs: bool,
    pub hasTargetSRFs: bool,
    pub hasSubLinks: bool,
    pub hasDistinctOn: bool,
    pub hasRecursive: bool,
    pub hasModifyingCTE: bool,
    pub hasForUpdate: bool,
    pub hasRowSecurity: bool,
    pub isReturn: bool,
    pub cteList: *mut List,
    pub rtable: *mut List,
    pub jointree: *mut FromExpr,
    pub mergeActionList: *mut List,
    pub mergeUseOuterJoin: bool,
    pub targetList: *mut List,
    pub override_: OverridingKind::Type,
    pub onConflict: *mut OnConflictExpr,
    pub returningList: *mut List,
    pub groupClause: *mut List,
    pub groupDistinct: bool,
    pub groupingSets: *mut List,
    pub havingQual: *mut Node,
    pub windowClause: *mut List,
    pub distinctClause: *mut List,
    pub sortClause: *mut List,
    pub limitOffset: *mut Node,
    pub limitCount: *mut Node,
    pub limitOption: LimitOption::Type,
    pub rowMarks: *mut List,
    pub setOperations: *mut Node,
    pub constraintDeps: *mut List,
    pub withCheckOptions: *mut List,
    pub stmt_location: ::core::ffi::c_int,
    pub stmt_len: ::core::ffi::c_int,
}
impl Default for Query {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[doc = "\tSupporting data structures for Parse Trees\n\n\tMost of these node types appear in raw parsetrees output by the grammar,\n\tand get transformed to something else by the analyzer.  A few of them\n\tare used as-is in transformed querytrees."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TypeName {
    pub type_: NodeTag,
    pub names: *mut List,
    pub typeOid: Oid,
    pub setof: bool,
    pub pct_type: bool,
    pub typmods: *mut List,
    pub typemod: int32,
    pub arrayBounds: *mut List,
    pub location: ::core::ffi::c_int,
}
impl Default for TypeName {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ColumnRef {
    pub type_: NodeTag,
    pub fields: *mut List,
    pub location: ::core::ffi::c_int,
}
impl Default for ColumnRef {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ParamRef {
    pub type_: NodeTag,
    pub number: ::core::ffi::c_int,
    pub location: ::core::ffi::c_int,
}
impl Default for ParamRef {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod A_Expr_Kind {
    pub type Type = ::core::ffi::c_uint;
    pub const AEXPR_OP: Type = 0;
    pub const AEXPR_OP_ANY: Type = 1;
    pub const AEXPR_OP_ALL: Type = 2;
    pub const AEXPR_DISTINCT: Type = 3;
    pub const AEXPR_NOT_DISTINCT: Type = 4;
    pub const AEXPR_NULLIF: Type = 5;
    pub const AEXPR_IN: Type = 6;
    pub const AEXPR_LIKE: Type = 7;
    pub const AEXPR_ILIKE: Type = 8;
    pub const AEXPR_SIMILAR: Type = 9;
    pub const AEXPR_BETWEEN: Type = 10;
    pub const AEXPR_NOT_BETWEEN: Type = 11;
    pub const AEXPR_BETWEEN_SYM: Type = 12;
    pub const AEXPR_NOT_BETWEEN_SYM: Type = 13;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct A_Expr {
    pub type_: NodeTag,
    pub kind: A_Expr_Kind::Type,
    pub name: *mut List,
    pub lexpr: *mut Node,
    pub rexpr: *mut Node,
    pub location: ::core::ffi::c_int,
}
impl Default for A_Expr {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct A_Const {
    pub type_: NodeTag,
    pub val: ValUnion,
    pub isnull: bool,
    pub location: ::core::ffi::c_int,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union ValUnion {
    pub node: Node,
    pub ival: Integer,
    pub fval: Float,
    pub boolval: Boolean,
    pub sval: String,
    pub bsval: BitString,
}
impl Default for ValUnion {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for A_Const {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TypeCast {
    pub type_: NodeTag,
    pub arg: *mut Node,
    pub typeName: *mut TypeName,
    pub location: ::core::ffi::c_int,
}
impl Default for TypeCast {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CollateClause {
    pub type_: NodeTag,
    pub arg: *mut Node,
    pub collname: *mut List,
    pub location: ::core::ffi::c_int,
}
impl Default for CollateClause {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod RoleSpecType {
    pub type Type = ::core::ffi::c_uint;
    pub const ROLESPEC_CSTRING: Type = 0;
    pub const ROLESPEC_CURRENT_ROLE: Type = 1;
    pub const ROLESPEC_CURRENT_USER: Type = 2;
    pub const ROLESPEC_SESSION_USER: Type = 3;
    pub const ROLESPEC_PUBLIC: Type = 4;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RoleSpec {
    pub type_: NodeTag,
    pub roletype: RoleSpecType::Type,
    pub rolename: *mut ::core::ffi::c_char,
    pub location: ::core::ffi::c_int,
}
impl Default for RoleSpec {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FuncCall {
    pub type_: NodeTag,
    pub funcname: *mut List,
    pub args: *mut List,
    pub agg_order: *mut List,
    pub agg_filter: *mut Node,
    pub over: *mut WindowDef,
    pub agg_within_group: bool,
    pub agg_star: bool,
    pub agg_distinct: bool,
    pub func_variadic: bool,
    pub funcformat: CoercionForm::Type,
    pub location: ::core::ffi::c_int,
}
impl Default for FuncCall {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct A_Star {
    pub type_: NodeTag,
}
impl Default for A_Star {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct A_Indices {
    pub type_: NodeTag,
    pub is_slice: bool,
    pub lidx: *mut Node,
    pub uidx: *mut Node,
}
impl Default for A_Indices {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct A_Indirection {
    pub type_: NodeTag,
    pub arg: *mut Node,
    pub indirection: *mut List,
}
impl Default for A_Indirection {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct A_ArrayExpr {
    pub type_: NodeTag,
    pub elements: *mut List,
    pub location: ::core::ffi::c_int,
}
impl Default for A_ArrayExpr {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ResTarget {
    pub type_: NodeTag,
    pub name: *mut ::core::ffi::c_char,
    pub indirection: *mut List,
    pub val: *mut Node,
    pub location: ::core::ffi::c_int,
}
impl Default for ResTarget {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MultiAssignRef {
    pub type_: NodeTag,
    pub source: *mut Node,
    pub colno: ::core::ffi::c_int,
    pub ncolumns: ::core::ffi::c_int,
}
impl Default for MultiAssignRef {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SortBy {
    pub type_: NodeTag,
    pub node: *mut Node,
    pub sortby_dir: SortByDir::Type,
    pub sortby_nulls: SortByNulls::Type,
    pub useOp: *mut List,
    pub location: ::core::ffi::c_int,
}
impl Default for SortBy {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WindowDef {
    pub type_: NodeTag,
    pub name: *mut ::core::ffi::c_char,
    pub refname: *mut ::core::ffi::c_char,
    pub partitionClause: *mut List,
    pub orderClause: *mut List,
    pub frameOptions: ::core::ffi::c_int,
    pub startOffset: *mut Node,
    pub endOffset: *mut Node,
    pub location: ::core::ffi::c_int,
}
impl Default for WindowDef {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RangeSubselect {
    pub type_: NodeTag,
    pub lateral: bool,
    pub subquery: *mut Node,
    pub alias: *mut Alias,
}
impl Default for RangeSubselect {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RangeFunction {
    pub type_: NodeTag,
    pub lateral: bool,
    pub ordinality: bool,
    pub is_rowsfrom: bool,
    pub functions: *mut List,
    pub alias: *mut Alias,
    pub coldeflist: *mut List,
}
impl Default for RangeFunction {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RangeTableFunc {
    pub type_: NodeTag,
    pub lateral: bool,
    pub docexpr: *mut Node,
    pub rowexpr: *mut Node,
    pub namespaces: *mut List,
    pub columns: *mut List,
    pub alias: *mut Alias,
    pub location: ::core::ffi::c_int,
}
impl Default for RangeTableFunc {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RangeTableFuncCol {
    pub type_: NodeTag,
    pub colname: *mut ::core::ffi::c_char,
    pub typeName: *mut TypeName,
    pub for_ordinality: bool,
    pub is_not_null: bool,
    pub colexpr: *mut Node,
    pub coldefexpr: *mut Node,
    pub location: ::core::ffi::c_int,
}
impl Default for RangeTableFuncCol {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RangeTableSample {
    pub type_: NodeTag,
    pub relation: *mut Node,
    pub method: *mut List,
    pub args: *mut List,
    pub repeatable: *mut Node,
    pub location: ::core::ffi::c_int,
}
impl Default for RangeTableSample {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ColumnDef {
    pub type_: NodeTag,
    pub colname: *mut ::core::ffi::c_char,
    pub typeName: *mut TypeName,
    pub compression: *mut ::core::ffi::c_char,
    pub inhcount: ::core::ffi::c_int,
    pub is_local: bool,
    pub is_not_null: bool,
    pub is_from_type: bool,
    pub storage: ::core::ffi::c_char,
    pub raw_default: *mut Node,
    pub cooked_default: *mut Node,
    pub identity: ::core::ffi::c_char,
    pub identitySequence: *mut RangeVar,
    pub generated: ::core::ffi::c_char,
    pub collClause: *mut CollateClause,
    pub collOid: Oid,
    pub constraints: *mut List,
    pub fdwoptions: *mut List,
    pub location: ::core::ffi::c_int,
}
impl Default for ColumnDef {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TableLikeClause {
    pub type_: NodeTag,
    pub relation: *mut RangeVar,
    pub options: bits32,
    pub relationOid: Oid,
}
impl Default for TableLikeClause {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod TableLikeOption {
    pub type Type = ::core::ffi::c_uint;
    pub const CREATE_TABLE_LIKE_COMMENTS: Type = 1;
    pub const CREATE_TABLE_LIKE_COMPRESSION: Type = 2;
    pub const CREATE_TABLE_LIKE_CONSTRAINTS: Type = 4;
    pub const CREATE_TABLE_LIKE_DEFAULTS: Type = 8;
    pub const CREATE_TABLE_LIKE_GENERATED: Type = 16;
    pub const CREATE_TABLE_LIKE_IDENTITY: Type = 32;
    pub const CREATE_TABLE_LIKE_INDEXES: Type = 64;
    pub const CREATE_TABLE_LIKE_STATISTICS: Type = 128;
    pub const CREATE_TABLE_LIKE_STORAGE: Type = 256;
    pub const CREATE_TABLE_LIKE_ALL: Type = 2147483647;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexElem {
    pub type_: NodeTag,
    pub name: *mut ::core::ffi::c_char,
    pub expr: *mut Node,
    pub indexcolname: *mut ::core::ffi::c_char,
    pub collation: *mut List,
    pub opclass: *mut List,
    pub opclassopts: *mut List,
    pub ordering: SortByDir::Type,
    pub nulls_ordering: SortByNulls::Type,
}
impl Default for IndexElem {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod DefElemAction {
    pub type Type = ::core::ffi::c_uint;
    pub const DEFELEM_UNSPEC: Type = 0;
    pub const DEFELEM_SET: Type = 1;
    pub const DEFELEM_ADD: Type = 2;
    pub const DEFELEM_DROP: Type = 3;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DefElem {
    pub type_: NodeTag,
    pub defnamespace: *mut ::core::ffi::c_char,
    pub defname: *mut ::core::ffi::c_char,
    pub arg: *mut Node,
    pub defaction: DefElemAction::Type,
    pub location: ::core::ffi::c_int,
}
impl Default for DefElem {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LockingClause {
    pub type_: NodeTag,
    pub lockedRels: *mut List,
    pub strength: LockClauseStrength::Type,
    pub waitPolicy: LockWaitPolicy::Type,
}
impl Default for LockingClause {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct XmlSerialize {
    pub type_: NodeTag,
    pub xmloption: XmlOptionType::Type,
    pub expr: *mut Node,
    pub typeName: *mut TypeName,
    pub location: ::core::ffi::c_int,
}
impl Default for XmlSerialize {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionElem {
    pub type_: NodeTag,
    pub name: *mut ::core::ffi::c_char,
    pub expr: *mut Node,
    pub collation: *mut List,
    pub opclass: *mut List,
    pub location: ::core::ffi::c_int,
}
impl Default for PartitionElem {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionSpec {
    pub type_: NodeTag,
    pub strategy: *mut ::core::ffi::c_char,
    pub partParams: *mut List,
    pub location: ::core::ffi::c_int,
}
impl Default for PartitionSpec {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionBoundSpec {
    pub type_: NodeTag,
    pub strategy: ::core::ffi::c_char,
    pub is_default: bool,
    pub modulus: ::core::ffi::c_int,
    pub remainder: ::core::ffi::c_int,
    pub listdatums: *mut List,
    pub lowerdatums: *mut List,
    pub upperdatums: *mut List,
    pub location: ::core::ffi::c_int,
}
impl Default for PartitionBoundSpec {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod PartitionRangeDatumKind {
    pub type Type = ::core::ffi::c_int;
    pub const PARTITION_RANGE_DATUM_MINVALUE: Type = -1;
    pub const PARTITION_RANGE_DATUM_VALUE: Type = 0;
    pub const PARTITION_RANGE_DATUM_MAXVALUE: Type = 1;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionRangeDatum {
    pub type_: NodeTag,
    pub kind: PartitionRangeDatumKind::Type,
    pub value: *mut Node,
    pub location: ::core::ffi::c_int,
}
impl Default for PartitionRangeDatum {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionCmd {
    pub type_: NodeTag,
    pub name: *mut RangeVar,
    pub bound: *mut PartitionBoundSpec,
    pub concurrent: bool,
}
impl Default for PartitionCmd {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod RTEKind {
    pub type Type = ::core::ffi::c_uint;
    pub const RTE_RELATION: Type = 0;
    pub const RTE_SUBQUERY: Type = 1;
    pub const RTE_JOIN: Type = 2;
    pub const RTE_FUNCTION: Type = 3;
    pub const RTE_TABLEFUNC: Type = 4;
    pub const RTE_VALUES: Type = 5;
    pub const RTE_CTE: Type = 6;
    pub const RTE_NAMEDTUPLESTORE: Type = 7;
    pub const RTE_RESULT: Type = 8;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RangeTblEntry {
    pub type_: NodeTag,
    pub rtekind: RTEKind::Type,
    pub relid: Oid,
    pub relkind: ::core::ffi::c_char,
    pub rellockmode: ::core::ffi::c_int,
    pub tablesample: *mut TableSampleClause,
    pub subquery: *mut Query,
    pub security_barrier: bool,
    pub jointype: JoinType::Type,
    pub joinmergedcols: ::core::ffi::c_int,
    pub joinaliasvars: *mut List,
    pub joinleftcols: *mut List,
    pub joinrightcols: *mut List,
    pub join_using_alias: *mut Alias,
    pub functions: *mut List,
    pub funcordinality: bool,
    pub tablefunc: *mut TableFunc,
    pub values_lists: *mut List,
    pub ctename: *mut ::core::ffi::c_char,
    pub ctelevelsup: Index,
    pub self_reference: bool,
    pub coltypes: *mut List,
    pub coltypmods: *mut List,
    pub colcollations: *mut List,
    pub enrname: *mut ::core::ffi::c_char,
    pub enrtuples: Cardinality,
    pub alias: *mut Alias,
    pub eref: *mut Alias,
    pub lateral: bool,
    pub inh: bool,
    pub inFromCl: bool,
    pub requiredPerms: AclMode,
    pub checkAsUser: Oid,
    pub selectedCols: *mut Bitmapset,
    pub insertedCols: *mut Bitmapset,
    pub updatedCols: *mut Bitmapset,
    pub extraUpdatedCols: *mut Bitmapset,
    pub securityQuals: *mut List,
}
impl Default for RangeTblEntry {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RangeTblFunction {
    pub type_: NodeTag,
    pub funcexpr: *mut Node,
    pub funccolcount: ::core::ffi::c_int,
    pub funccolnames: *mut List,
    pub funccoltypes: *mut List,
    pub funccoltypmods: *mut List,
    pub funccolcollations: *mut List,
    pub funcparams: *mut Bitmapset,
}
impl Default for RangeTblFunction {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TableSampleClause {
    pub type_: NodeTag,
    pub tsmhandler: Oid,
    pub args: *mut List,
    pub repeatable: *mut Expr,
}
impl Default for TableSampleClause {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod WCOKind {
    pub type Type = ::core::ffi::c_uint;
    pub const WCO_VIEW_CHECK: Type = 0;
    pub const WCO_RLS_INSERT_CHECK: Type = 1;
    pub const WCO_RLS_UPDATE_CHECK: Type = 2;
    pub const WCO_RLS_CONFLICT_CHECK: Type = 3;
    pub const WCO_RLS_MERGE_UPDATE_CHECK: Type = 4;
    pub const WCO_RLS_MERGE_DELETE_CHECK: Type = 5;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WithCheckOption {
    pub type_: NodeTag,
    pub kind: WCOKind::Type,
    pub relname: *mut ::core::ffi::c_char,
    pub polname: *mut ::core::ffi::c_char,
    pub qual: *mut Node,
    pub cascaded: bool,
}
impl Default for WithCheckOption {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SortGroupClause {
    pub type_: NodeTag,
    pub tleSortGroupRef: Index,
    pub eqop: Oid,
    pub sortop: Oid,
    pub nulls_first: bool,
    pub hashable: bool,
}
impl Default for SortGroupClause {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod GroupingSetKind {
    pub type Type = ::core::ffi::c_uint;
    pub const GROUPING_SET_EMPTY: Type = 0;
    pub const GROUPING_SET_SIMPLE: Type = 1;
    pub const GROUPING_SET_ROLLUP: Type = 2;
    pub const GROUPING_SET_CUBE: Type = 3;
    pub const GROUPING_SET_SETS: Type = 4;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GroupingSet {
    pub type_: NodeTag,
    pub kind: GroupingSetKind::Type,
    pub content: *mut List,
    pub location: ::core::ffi::c_int,
}
impl Default for GroupingSet {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WindowClause {
    pub type_: NodeTag,
    pub name: *mut ::core::ffi::c_char,
    pub refname: *mut ::core::ffi::c_char,
    pub partitionClause: *mut List,
    pub orderClause: *mut List,
    pub frameOptions: ::core::ffi::c_int,
    pub startOffset: *mut Node,
    pub endOffset: *mut Node,
    pub runCondition: *mut List,
    pub startInRangeFunc: Oid,
    pub endInRangeFunc: Oid,
    pub inRangeColl: Oid,
    pub inRangeAsc: bool,
    pub inRangeNullsFirst: bool,
    pub winref: Index,
    pub copiedOrder: bool,
}
impl Default for WindowClause {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RowMarkClause {
    pub type_: NodeTag,
    pub rti: Index,
    pub strength: LockClauseStrength::Type,
    pub waitPolicy: LockWaitPolicy::Type,
    pub pushedDown: bool,
}
impl Default for RowMarkClause {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WithClause {
    pub type_: NodeTag,
    pub ctes: *mut List,
    pub recursive: bool,
    pub location: ::core::ffi::c_int,
}
impl Default for WithClause {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct InferClause {
    pub type_: NodeTag,
    pub indexElems: *mut List,
    pub whereClause: *mut Node,
    pub conname: *mut ::core::ffi::c_char,
    pub location: ::core::ffi::c_int,
}
impl Default for InferClause {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OnConflictClause {
    pub type_: NodeTag,
    pub action: OnConflictAction::Type,
    pub infer: *mut InferClause,
    pub targetList: *mut List,
    pub whereClause: *mut Node,
    pub location: ::core::ffi::c_int,
}
impl Default for OnConflictClause {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod CTEMaterialize {
    pub type Type = ::core::ffi::c_uint;
    pub const CTEMaterializeDefault: Type = 0;
    pub const CTEMaterializeAlways: Type = 1;
    pub const CTEMaterializeNever: Type = 2;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CTESearchClause {
    pub type_: NodeTag,
    pub search_col_list: *mut List,
    pub search_breadth_first: bool,
    pub search_seq_column: *mut ::core::ffi::c_char,
    pub location: ::core::ffi::c_int,
}
impl Default for CTESearchClause {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CTECycleClause {
    pub type_: NodeTag,
    pub cycle_col_list: *mut List,
    pub cycle_mark_column: *mut ::core::ffi::c_char,
    pub cycle_mark_value: *mut Node,
    pub cycle_mark_default: *mut Node,
    pub cycle_path_column: *mut ::core::ffi::c_char,
    pub location: ::core::ffi::c_int,
    pub cycle_mark_type: Oid,
    pub cycle_mark_typmod: ::core::ffi::c_int,
    pub cycle_mark_collation: Oid,
    pub cycle_mark_neop: Oid,
}
impl Default for CTECycleClause {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CommonTableExpr {
    pub type_: NodeTag,
    pub ctename: *mut ::core::ffi::c_char,
    pub aliascolnames: *mut List,
    pub ctematerialized: CTEMaterialize::Type,
    pub ctequery: *mut Node,
    pub search_clause: *mut CTESearchClause,
    pub cycle_clause: *mut CTECycleClause,
    pub location: ::core::ffi::c_int,
    pub cterecursive: bool,
    pub cterefcount: ::core::ffi::c_int,
    pub ctecolnames: *mut List,
    pub ctecoltypes: *mut List,
    pub ctecoltypmods: *mut List,
    pub ctecolcollations: *mut List,
}
impl Default for CommonTableExpr {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MergeWhenClause {
    pub type_: NodeTag,
    pub matched: bool,
    pub commandType: CmdType::Type,
    pub override_: OverridingKind::Type,
    pub condition: *mut Node,
    pub targetList: *mut List,
    pub values: *mut List,
}
impl Default for MergeWhenClause {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MergeAction {
    pub type_: NodeTag,
    pub matched: bool,
    pub commandType: CmdType::Type,
    pub override_: OverridingKind::Type,
    pub qual: *mut Node,
    pub targetList: *mut List,
    pub updateColnos: *mut List,
}
impl Default for MergeAction {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TriggerTransition {
    pub type_: NodeTag,
    pub name: *mut ::core::ffi::c_char,
    pub isNew: bool,
    pub isTable: bool,
}
impl Default for TriggerTransition {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[doc = "\t\tRaw Grammar Output Statements"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RawStmt {
    pub type_: NodeTag,
    pub stmt: *mut Node,
    pub stmt_location: ::core::ffi::c_int,
    pub stmt_len: ::core::ffi::c_int,
}
impl Default for RawStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[doc = "\t\tOptimizable Statements"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct InsertStmt {
    pub type_: NodeTag,
    pub relation: *mut RangeVar,
    pub cols: *mut List,
    pub selectStmt: *mut Node,
    pub onConflictClause: *mut OnConflictClause,
    pub returningList: *mut List,
    pub withClause: *mut WithClause,
    pub override_: OverridingKind::Type,
}
impl Default for InsertStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DeleteStmt {
    pub type_: NodeTag,
    pub relation: *mut RangeVar,
    pub usingClause: *mut List,
    pub whereClause: *mut Node,
    pub returningList: *mut List,
    pub withClause: *mut WithClause,
}
impl Default for DeleteStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct UpdateStmt {
    pub type_: NodeTag,
    pub relation: *mut RangeVar,
    pub targetList: *mut List,
    pub whereClause: *mut Node,
    pub fromClause: *mut List,
    pub returningList: *mut List,
    pub withClause: *mut WithClause,
}
impl Default for UpdateStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MergeStmt {
    pub type_: NodeTag,
    pub relation: *mut RangeVar,
    pub sourceRelation: *mut Node,
    pub joinCondition: *mut Node,
    pub mergeWhenClauses: *mut List,
    pub withClause: *mut WithClause,
}
impl Default for MergeStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod SetOperation {
    pub type Type = ::core::ffi::c_uint;
    pub const SETOP_NONE: Type = 0;
    pub const SETOP_UNION: Type = 1;
    pub const SETOP_INTERSECT: Type = 2;
    pub const SETOP_EXCEPT: Type = 3;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SelectStmt {
    pub type_: NodeTag,
    pub distinctClause: *mut List,
    pub intoClause: *mut IntoClause,
    pub targetList: *mut List,
    pub fromClause: *mut List,
    pub whereClause: *mut Node,
    pub groupClause: *mut List,
    pub groupDistinct: bool,
    pub havingClause: *mut Node,
    pub windowClause: *mut List,
    pub valuesLists: *mut List,
    pub sortClause: *mut List,
    pub limitOffset: *mut Node,
    pub limitCount: *mut Node,
    pub limitOption: LimitOption::Type,
    pub lockingClause: *mut List,
    pub withClause: *mut WithClause,
    pub op: SetOperation::Type,
    pub all: bool,
    pub larg: *mut SelectStmt,
    pub rarg: *mut SelectStmt,
}
impl Default for SelectStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SetOperationStmt {
    pub type_: NodeTag,
    pub op: SetOperation::Type,
    pub all: bool,
    pub larg: *mut Node,
    pub rarg: *mut Node,
    pub colTypes: *mut List,
    pub colTypmods: *mut List,
    pub colCollations: *mut List,
    pub groupClauses: *mut List,
}
impl Default for SetOperationStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ReturnStmt {
    pub type_: NodeTag,
    pub returnval: *mut Node,
}
impl Default for ReturnStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PLAssignStmt {
    pub type_: NodeTag,
    pub name: *mut ::core::ffi::c_char,
    pub indirection: *mut List,
    pub nnames: ::core::ffi::c_int,
    pub val: *mut SelectStmt,
    pub location: ::core::ffi::c_int,
}
impl Default for PLAssignStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod ObjectType {
    #[doc = "\t\tOther Statements (no optimizations required)\n\n\t\tThese are not touched by parser/analyze.c except to put them into\n\t\tthe utilityStmt field of a Query.  This is eventually passed to\n\t\tProcessUtility (by-passing rewriting and planning).  Some of the\n\t\tstatements do need attention from parse analysis, and this is\n\t\tdone by routines in parser/parse_utilcmd.c after ProcessUtility\n\t\treceives the command for execution.\n\t\tDECLARE CURSOR, EXPLAIN, and CREATE TABLE AS are special cases:\n\t\tthey contain optimizable statements, which get processed normally\n\t\tby parser/analyze.c."]
    pub type Type = ::core::ffi::c_uint;
    pub const OBJECT_ACCESS_METHOD: Type = 0;
    pub const OBJECT_AGGREGATE: Type = 1;
    pub const OBJECT_AMOP: Type = 2;
    pub const OBJECT_AMPROC: Type = 3;
    pub const OBJECT_ATTRIBUTE: Type = 4;
    pub const OBJECT_CAST: Type = 5;
    pub const OBJECT_COLUMN: Type = 6;
    pub const OBJECT_COLLATION: Type = 7;
    pub const OBJECT_CONVERSION: Type = 8;
    pub const OBJECT_DATABASE: Type = 9;
    pub const OBJECT_DEFAULT: Type = 10;
    pub const OBJECT_DEFACL: Type = 11;
    pub const OBJECT_DOMAIN: Type = 12;
    pub const OBJECT_DOMCONSTRAINT: Type = 13;
    pub const OBJECT_EVENT_TRIGGER: Type = 14;
    pub const OBJECT_EXTENSION: Type = 15;
    pub const OBJECT_FDW: Type = 16;
    pub const OBJECT_FOREIGN_SERVER: Type = 17;
    pub const OBJECT_FOREIGN_TABLE: Type = 18;
    pub const OBJECT_FUNCTION: Type = 19;
    pub const OBJECT_INDEX: Type = 20;
    pub const OBJECT_LANGUAGE: Type = 21;
    pub const OBJECT_LARGEOBJECT: Type = 22;
    pub const OBJECT_MATVIEW: Type = 23;
    pub const OBJECT_OPCLASS: Type = 24;
    pub const OBJECT_OPERATOR: Type = 25;
    pub const OBJECT_OPFAMILY: Type = 26;
    pub const OBJECT_PARAMETER_ACL: Type = 27;
    pub const OBJECT_POLICY: Type = 28;
    pub const OBJECT_PROCEDURE: Type = 29;
    pub const OBJECT_PUBLICATION: Type = 30;
    pub const OBJECT_PUBLICATION_NAMESPACE: Type = 31;
    pub const OBJECT_PUBLICATION_REL: Type = 32;
    pub const OBJECT_ROLE: Type = 33;
    pub const OBJECT_ROUTINE: Type = 34;
    pub const OBJECT_RULE: Type = 35;
    pub const OBJECT_SCHEMA: Type = 36;
    pub const OBJECT_SEQUENCE: Type = 37;
    pub const OBJECT_SUBSCRIPTION: Type = 38;
    pub const OBJECT_STATISTIC_EXT: Type = 39;
    pub const OBJECT_TABCONSTRAINT: Type = 40;
    pub const OBJECT_TABLE: Type = 41;
    pub const OBJECT_TABLESPACE: Type = 42;
    pub const OBJECT_TRANSFORM: Type = 43;
    pub const OBJECT_TRIGGER: Type = 44;
    pub const OBJECT_TSCONFIGURATION: Type = 45;
    pub const OBJECT_TSDICTIONARY: Type = 46;
    pub const OBJECT_TSPARSER: Type = 47;
    pub const OBJECT_TSTEMPLATE: Type = 48;
    pub const OBJECT_TYPE: Type = 49;
    pub const OBJECT_USER_MAPPING: Type = 50;
    pub const OBJECT_VIEW: Type = 51;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateSchemaStmt {
    pub type_: NodeTag,
    pub schemaname: *mut ::core::ffi::c_char,
    pub authrole: *mut RoleSpec,
    pub schemaElts: *mut List,
    pub if_not_exists: bool,
}
impl Default for CreateSchemaStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod DropBehavior {
    pub type Type = ::core::ffi::c_uint;
    pub const DROP_RESTRICT: Type = 0;
    pub const DROP_CASCADE: Type = 1;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterTableStmt {
    pub type_: NodeTag,
    pub relation: *mut RangeVar,
    pub cmds: *mut List,
    pub objtype: ObjectType::Type,
    pub missing_ok: bool,
}
impl Default for AlterTableStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod AlterTableType {
    pub type Type = ::core::ffi::c_uint;
    pub const AT_AddColumn: Type = 0;
    pub const AT_AddColumnRecurse: Type = 1;
    pub const AT_AddColumnToView: Type = 2;
    pub const AT_ColumnDefault: Type = 3;
    pub const AT_CookedColumnDefault: Type = 4;
    pub const AT_DropNotNull: Type = 5;
    pub const AT_SetNotNull: Type = 6;
    pub const AT_DropExpression: Type = 7;
    pub const AT_CheckNotNull: Type = 8;
    pub const AT_SetStatistics: Type = 9;
    pub const AT_SetOptions: Type = 10;
    pub const AT_ResetOptions: Type = 11;
    pub const AT_SetStorage: Type = 12;
    pub const AT_SetCompression: Type = 13;
    pub const AT_DropColumn: Type = 14;
    pub const AT_DropColumnRecurse: Type = 15;
    pub const AT_AddIndex: Type = 16;
    pub const AT_ReAddIndex: Type = 17;
    pub const AT_AddConstraint: Type = 18;
    pub const AT_AddConstraintRecurse: Type = 19;
    pub const AT_ReAddConstraint: Type = 20;
    pub const AT_ReAddDomainConstraint: Type = 21;
    pub const AT_AlterConstraint: Type = 22;
    pub const AT_ValidateConstraint: Type = 23;
    pub const AT_ValidateConstraintRecurse: Type = 24;
    pub const AT_AddIndexConstraint: Type = 25;
    pub const AT_DropConstraint: Type = 26;
    pub const AT_DropConstraintRecurse: Type = 27;
    pub const AT_ReAddComment: Type = 28;
    pub const AT_AlterColumnType: Type = 29;
    pub const AT_AlterColumnGenericOptions: Type = 30;
    pub const AT_ChangeOwner: Type = 31;
    pub const AT_ClusterOn: Type = 32;
    pub const AT_DropCluster: Type = 33;
    pub const AT_SetLogged: Type = 34;
    pub const AT_SetUnLogged: Type = 35;
    pub const AT_DropOids: Type = 36;
    pub const AT_SetAccessMethod: Type = 37;
    pub const AT_SetTableSpace: Type = 38;
    pub const AT_SetRelOptions: Type = 39;
    pub const AT_ResetRelOptions: Type = 40;
    pub const AT_ReplaceRelOptions: Type = 41;
    pub const AT_EnableTrig: Type = 42;
    pub const AT_EnableAlwaysTrig: Type = 43;
    pub const AT_EnableReplicaTrig: Type = 44;
    pub const AT_DisableTrig: Type = 45;
    pub const AT_EnableTrigAll: Type = 46;
    pub const AT_DisableTrigAll: Type = 47;
    pub const AT_EnableTrigUser: Type = 48;
    pub const AT_DisableTrigUser: Type = 49;
    pub const AT_EnableRule: Type = 50;
    pub const AT_EnableAlwaysRule: Type = 51;
    pub const AT_EnableReplicaRule: Type = 52;
    pub const AT_DisableRule: Type = 53;
    pub const AT_AddInherit: Type = 54;
    pub const AT_DropInherit: Type = 55;
    pub const AT_AddOf: Type = 56;
    pub const AT_DropOf: Type = 57;
    pub const AT_ReplicaIdentity: Type = 58;
    pub const AT_EnableRowSecurity: Type = 59;
    pub const AT_DisableRowSecurity: Type = 60;
    pub const AT_ForceRowSecurity: Type = 61;
    pub const AT_NoForceRowSecurity: Type = 62;
    pub const AT_GenericOptions: Type = 63;
    pub const AT_AttachPartition: Type = 64;
    pub const AT_DetachPartition: Type = 65;
    pub const AT_DetachPartitionFinalize: Type = 66;
    pub const AT_AddIdentity: Type = 67;
    pub const AT_SetIdentity: Type = 68;
    pub const AT_DropIdentity: Type = 69;
    pub const AT_ReAddStatistics: Type = 70;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ReplicaIdentityStmt {
    pub type_: NodeTag,
    pub identity_type: ::core::ffi::c_char,
    pub name: *mut ::core::ffi::c_char,
}
impl Default for ReplicaIdentityStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterTableCmd {
    pub type_: NodeTag,
    pub subtype: AlterTableType::Type,
    pub name: *mut ::core::ffi::c_char,
    pub num: int16,
    pub newowner: *mut RoleSpec,
    pub def: *mut Node,
    pub behavior: DropBehavior::Type,
    pub missing_ok: bool,
    pub recurse: bool,
}
impl Default for AlterTableCmd {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterCollationStmt {
    pub type_: NodeTag,
    pub collname: *mut List,
}
impl Default for AlterCollationStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterDomainStmt {
    pub type_: NodeTag,
    pub subtype: ::core::ffi::c_char,
    pub typeName: *mut List,
    pub name: *mut ::core::ffi::c_char,
    pub def: *mut Node,
    pub behavior: DropBehavior::Type,
    pub missing_ok: bool,
}
impl Default for AlterDomainStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod GrantTargetType {
    pub type Type = ::core::ffi::c_uint;
    pub const ACL_TARGET_OBJECT: Type = 0;
    pub const ACL_TARGET_ALL_IN_SCHEMA: Type = 1;
    pub const ACL_TARGET_DEFAULTS: Type = 2;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GrantStmt {
    pub type_: NodeTag,
    pub is_grant: bool,
    pub targtype: GrantTargetType::Type,
    pub objtype: ObjectType::Type,
    pub objects: *mut List,
    pub privileges: *mut List,
    pub grantees: *mut List,
    pub grant_option: bool,
    pub grantor: *mut RoleSpec,
    pub behavior: DropBehavior::Type,
}
impl Default for GrantStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ObjectWithArgs {
    pub type_: NodeTag,
    pub objname: *mut List,
    pub objargs: *mut List,
    pub objfuncargs: *mut List,
    pub args_unspecified: bool,
}
impl Default for ObjectWithArgs {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AccessPriv {
    pub type_: NodeTag,
    pub priv_name: *mut ::core::ffi::c_char,
    pub cols: *mut List,
}
impl Default for AccessPriv {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GrantRoleStmt {
    pub type_: NodeTag,
    pub granted_roles: *mut List,
    pub grantee_roles: *mut List,
    pub is_grant: bool,
    pub admin_opt: bool,
    pub grantor: *mut RoleSpec,
    pub behavior: DropBehavior::Type,
}
impl Default for GrantRoleStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterDefaultPrivilegesStmt {
    pub type_: NodeTag,
    pub options: *mut List,
    pub action: *mut GrantStmt,
}
impl Default for AlterDefaultPrivilegesStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CopyStmt {
    pub type_: NodeTag,
    pub relation: *mut RangeVar,
    pub query: *mut Node,
    pub attlist: *mut List,
    pub is_from: bool,
    pub is_program: bool,
    pub filename: *mut ::core::ffi::c_char,
    pub options: *mut List,
    pub whereClause: *mut Node,
}
impl Default for CopyStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod VariableSetKind {
    pub type Type = ::core::ffi::c_uint;
    pub const VAR_SET_VALUE: Type = 0;
    pub const VAR_SET_DEFAULT: Type = 1;
    pub const VAR_SET_CURRENT: Type = 2;
    pub const VAR_SET_MULTI: Type = 3;
    pub const VAR_RESET: Type = 4;
    pub const VAR_RESET_ALL: Type = 5;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VariableSetStmt {
    pub type_: NodeTag,
    pub kind: VariableSetKind::Type,
    pub name: *mut ::core::ffi::c_char,
    pub args: *mut List,
    pub is_local: bool,
}
impl Default for VariableSetStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VariableShowStmt {
    pub type_: NodeTag,
    pub name: *mut ::core::ffi::c_char,
}
impl Default for VariableShowStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateStmt {
    pub type_: NodeTag,
    pub relation: *mut RangeVar,
    pub tableElts: *mut List,
    pub inhRelations: *mut List,
    pub partbound: *mut PartitionBoundSpec,
    pub partspec: *mut PartitionSpec,
    pub ofTypename: *mut TypeName,
    pub constraints: *mut List,
    pub options: *mut List,
    pub oncommit: OnCommitAction::Type,
    pub tablespacename: *mut ::core::ffi::c_char,
    pub accessMethod: *mut ::core::ffi::c_char,
    pub if_not_exists: bool,
}
impl Default for CreateStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod ConstrType {
    pub type Type = ::core::ffi::c_uint;
    pub const CONSTR_NULL: Type = 0;
    pub const CONSTR_NOTNULL: Type = 1;
    pub const CONSTR_DEFAULT: Type = 2;
    pub const CONSTR_IDENTITY: Type = 3;
    pub const CONSTR_GENERATED: Type = 4;
    pub const CONSTR_CHECK: Type = 5;
    pub const CONSTR_PRIMARY: Type = 6;
    pub const CONSTR_UNIQUE: Type = 7;
    pub const CONSTR_EXCLUSION: Type = 8;
    pub const CONSTR_FOREIGN: Type = 9;
    pub const CONSTR_ATTR_DEFERRABLE: Type = 10;
    pub const CONSTR_ATTR_NOT_DEFERRABLE: Type = 11;
    pub const CONSTR_ATTR_DEFERRED: Type = 12;
    pub const CONSTR_ATTR_IMMEDIATE: Type = 13;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Constraint {
    pub type_: NodeTag,
    pub contype: ConstrType::Type,
    pub conname: *mut ::core::ffi::c_char,
    pub deferrable: bool,
    pub initdeferred: bool,
    pub location: ::core::ffi::c_int,
    pub is_no_inherit: bool,
    pub raw_expr: *mut Node,
    pub cooked_expr: *mut ::core::ffi::c_char,
    pub generated_when: ::core::ffi::c_char,
    pub nulls_not_distinct: bool,
    pub keys: *mut List,
    pub including: *mut List,
    pub exclusions: *mut List,
    pub options: *mut List,
    pub indexname: *mut ::core::ffi::c_char,
    pub indexspace: *mut ::core::ffi::c_char,
    pub reset_default_tblspc: bool,
    pub access_method: *mut ::core::ffi::c_char,
    pub where_clause: *mut Node,
    pub pktable: *mut RangeVar,
    pub fk_attrs: *mut List,
    pub pk_attrs: *mut List,
    pub fk_matchtype: ::core::ffi::c_char,
    pub fk_upd_action: ::core::ffi::c_char,
    pub fk_del_action: ::core::ffi::c_char,
    pub fk_del_set_cols: *mut List,
    pub old_conpfeqop: *mut List,
    pub old_pktable_oid: Oid,
    pub skip_validation: bool,
    pub initially_valid: bool,
}
impl Default for Constraint {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateTableSpaceStmt {
    pub type_: NodeTag,
    pub tablespacename: *mut ::core::ffi::c_char,
    pub owner: *mut RoleSpec,
    pub location: *mut ::core::ffi::c_char,
    pub options: *mut List,
}
impl Default for CreateTableSpaceStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DropTableSpaceStmt {
    pub type_: NodeTag,
    pub tablespacename: *mut ::core::ffi::c_char,
    pub missing_ok: bool,
}
impl Default for DropTableSpaceStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterTableSpaceOptionsStmt {
    pub type_: NodeTag,
    pub tablespacename: *mut ::core::ffi::c_char,
    pub options: *mut List,
    pub isReset: bool,
}
impl Default for AlterTableSpaceOptionsStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterTableMoveAllStmt {
    pub type_: NodeTag,
    pub orig_tablespacename: *mut ::core::ffi::c_char,
    pub objtype: ObjectType::Type,
    pub roles: *mut List,
    pub new_tablespacename: *mut ::core::ffi::c_char,
    pub nowait: bool,
}
impl Default for AlterTableMoveAllStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateExtensionStmt {
    pub type_: NodeTag,
    pub extname: *mut ::core::ffi::c_char,
    pub if_not_exists: bool,
    pub options: *mut List,
}
impl Default for CreateExtensionStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterExtensionStmt {
    pub type_: NodeTag,
    pub extname: *mut ::core::ffi::c_char,
    pub options: *mut List,
}
impl Default for AlterExtensionStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterExtensionContentsStmt {
    pub type_: NodeTag,
    pub extname: *mut ::core::ffi::c_char,
    pub action: ::core::ffi::c_int,
    pub objtype: ObjectType::Type,
    pub object: *mut Node,
}
impl Default for AlterExtensionContentsStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateFdwStmt {
    pub type_: NodeTag,
    pub fdwname: *mut ::core::ffi::c_char,
    pub func_options: *mut List,
    pub options: *mut List,
}
impl Default for CreateFdwStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterFdwStmt {
    pub type_: NodeTag,
    pub fdwname: *mut ::core::ffi::c_char,
    pub func_options: *mut List,
    pub options: *mut List,
}
impl Default for AlterFdwStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateForeignServerStmt {
    pub type_: NodeTag,
    pub servername: *mut ::core::ffi::c_char,
    pub servertype: *mut ::core::ffi::c_char,
    pub version: *mut ::core::ffi::c_char,
    pub fdwname: *mut ::core::ffi::c_char,
    pub if_not_exists: bool,
    pub options: *mut List,
}
impl Default for CreateForeignServerStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterForeignServerStmt {
    pub type_: NodeTag,
    pub servername: *mut ::core::ffi::c_char,
    pub version: *mut ::core::ffi::c_char,
    pub options: *mut List,
    pub has_version: bool,
}
impl Default for AlterForeignServerStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateForeignTableStmt {
    pub base: CreateStmt,
    pub servername: *mut ::core::ffi::c_char,
    pub options: *mut List,
}
impl Default for CreateForeignTableStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateUserMappingStmt {
    pub type_: NodeTag,
    pub user: *mut RoleSpec,
    pub servername: *mut ::core::ffi::c_char,
    pub if_not_exists: bool,
    pub options: *mut List,
}
impl Default for CreateUserMappingStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterUserMappingStmt {
    pub type_: NodeTag,
    pub user: *mut RoleSpec,
    pub servername: *mut ::core::ffi::c_char,
    pub options: *mut List,
}
impl Default for AlterUserMappingStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DropUserMappingStmt {
    pub type_: NodeTag,
    pub user: *mut RoleSpec,
    pub servername: *mut ::core::ffi::c_char,
    pub missing_ok: bool,
}
impl Default for DropUserMappingStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod ImportForeignSchemaType {
    pub type Type = ::core::ffi::c_uint;
    pub const FDW_IMPORT_SCHEMA_ALL: Type = 0;
    pub const FDW_IMPORT_SCHEMA_LIMIT_TO: Type = 1;
    pub const FDW_IMPORT_SCHEMA_EXCEPT: Type = 2;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ImportForeignSchemaStmt {
    pub type_: NodeTag,
    pub server_name: *mut ::core::ffi::c_char,
    pub remote_schema: *mut ::core::ffi::c_char,
    pub local_schema: *mut ::core::ffi::c_char,
    pub list_type: ImportForeignSchemaType::Type,
    pub table_list: *mut List,
    pub options: *mut List,
}
impl Default for ImportForeignSchemaStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreatePolicyStmt {
    pub type_: NodeTag,
    pub policy_name: *mut ::core::ffi::c_char,
    pub table: *mut RangeVar,
    pub cmd_name: *mut ::core::ffi::c_char,
    pub permissive: bool,
    pub roles: *mut List,
    pub qual: *mut Node,
    pub with_check: *mut Node,
}
impl Default for CreatePolicyStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterPolicyStmt {
    pub type_: NodeTag,
    pub policy_name: *mut ::core::ffi::c_char,
    pub table: *mut RangeVar,
    pub roles: *mut List,
    pub qual: *mut Node,
    pub with_check: *mut Node,
}
impl Default for AlterPolicyStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateAmStmt {
    pub type_: NodeTag,
    pub amname: *mut ::core::ffi::c_char,
    pub handler_name: *mut List,
    pub amtype: ::core::ffi::c_char,
}
impl Default for CreateAmStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateTrigStmt {
    pub type_: NodeTag,
    pub replace: bool,
    pub isconstraint: bool,
    pub trigname: *mut ::core::ffi::c_char,
    pub relation: *mut RangeVar,
    pub funcname: *mut List,
    pub args: *mut List,
    pub row: bool,
    pub timing: int16,
    pub events: int16,
    pub columns: *mut List,
    pub whenClause: *mut Node,
    pub transitionRels: *mut List,
    pub deferrable: bool,
    pub initdeferred: bool,
    pub constrrel: *mut RangeVar,
}
impl Default for CreateTrigStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateEventTrigStmt {
    pub type_: NodeTag,
    pub trigname: *mut ::core::ffi::c_char,
    pub eventname: *mut ::core::ffi::c_char,
    pub whenclause: *mut List,
    pub funcname: *mut List,
}
impl Default for CreateEventTrigStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterEventTrigStmt {
    pub type_: NodeTag,
    pub trigname: *mut ::core::ffi::c_char,
    pub tgenabled: ::core::ffi::c_char,
}
impl Default for AlterEventTrigStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreatePLangStmt {
    pub type_: NodeTag,
    pub replace: bool,
    pub plname: *mut ::core::ffi::c_char,
    pub plhandler: *mut List,
    pub plinline: *mut List,
    pub plvalidator: *mut List,
    pub pltrusted: bool,
}
impl Default for CreatePLangStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod RoleStmtType {
    pub type Type = ::core::ffi::c_uint;
    pub const ROLESTMT_ROLE: Type = 0;
    pub const ROLESTMT_USER: Type = 1;
    pub const ROLESTMT_GROUP: Type = 2;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateRoleStmt {
    pub type_: NodeTag,
    pub stmt_type: RoleStmtType::Type,
    pub role: *mut ::core::ffi::c_char,
    pub options: *mut List,
}
impl Default for CreateRoleStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterRoleStmt {
    pub type_: NodeTag,
    pub role: *mut RoleSpec,
    pub options: *mut List,
    pub action: ::core::ffi::c_int,
}
impl Default for AlterRoleStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterRoleSetStmt {
    pub type_: NodeTag,
    pub role: *mut RoleSpec,
    pub database: *mut ::core::ffi::c_char,
    pub setstmt: *mut VariableSetStmt,
}
impl Default for AlterRoleSetStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DropRoleStmt {
    pub type_: NodeTag,
    pub roles: *mut List,
    pub missing_ok: bool,
}
impl Default for DropRoleStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateSeqStmt {
    pub type_: NodeTag,
    pub sequence: *mut RangeVar,
    pub options: *mut List,
    pub ownerId: Oid,
    pub for_identity: bool,
    pub if_not_exists: bool,
}
impl Default for CreateSeqStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterSeqStmt {
    pub type_: NodeTag,
    pub sequence: *mut RangeVar,
    pub options: *mut List,
    pub for_identity: bool,
    pub missing_ok: bool,
}
impl Default for AlterSeqStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DefineStmt {
    pub type_: NodeTag,
    pub kind: ObjectType::Type,
    pub oldstyle: bool,
    pub defnames: *mut List,
    pub args: *mut List,
    pub definition: *mut List,
    pub if_not_exists: bool,
    pub replace: bool,
}
impl Default for DefineStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateDomainStmt {
    pub type_: NodeTag,
    pub domainname: *mut List,
    pub typeName: *mut TypeName,
    pub collClause: *mut CollateClause,
    pub constraints: *mut List,
}
impl Default for CreateDomainStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateOpClassStmt {
    pub type_: NodeTag,
    pub opclassname: *mut List,
    pub opfamilyname: *mut List,
    pub amname: *mut ::core::ffi::c_char,
    pub datatype: *mut TypeName,
    pub items: *mut List,
    pub isDefault: bool,
}
impl Default for CreateOpClassStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateOpClassItem {
    pub type_: NodeTag,
    pub itemtype: ::core::ffi::c_int,
    pub name: *mut ObjectWithArgs,
    pub number: ::core::ffi::c_int,
    pub order_family: *mut List,
    pub class_args: *mut List,
    pub storedtype: *mut TypeName,
}
impl Default for CreateOpClassItem {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateOpFamilyStmt {
    pub type_: NodeTag,
    pub opfamilyname: *mut List,
    pub amname: *mut ::core::ffi::c_char,
}
impl Default for CreateOpFamilyStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterOpFamilyStmt {
    pub type_: NodeTag,
    pub opfamilyname: *mut List,
    pub amname: *mut ::core::ffi::c_char,
    pub isDrop: bool,
    pub items: *mut List,
}
impl Default for AlterOpFamilyStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DropStmt {
    pub type_: NodeTag,
    pub objects: *mut List,
    pub removeType: ObjectType::Type,
    pub behavior: DropBehavior::Type,
    pub missing_ok: bool,
    pub concurrent: bool,
}
impl Default for DropStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TruncateStmt {
    pub type_: NodeTag,
    pub relations: *mut List,
    pub restart_seqs: bool,
    pub behavior: DropBehavior::Type,
}
impl Default for TruncateStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CommentStmt {
    pub type_: NodeTag,
    pub objtype: ObjectType::Type,
    pub object: *mut Node,
    pub comment: *mut ::core::ffi::c_char,
}
impl Default for CommentStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SecLabelStmt {
    pub type_: NodeTag,
    pub objtype: ObjectType::Type,
    pub object: *mut Node,
    pub provider: *mut ::core::ffi::c_char,
    pub label: *mut ::core::ffi::c_char,
}
impl Default for SecLabelStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DeclareCursorStmt {
    pub type_: NodeTag,
    pub portalname: *mut ::core::ffi::c_char,
    pub options: ::core::ffi::c_int,
    pub query: *mut Node,
}
impl Default for DeclareCursorStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ClosePortalStmt {
    pub type_: NodeTag,
    pub portalname: *mut ::core::ffi::c_char,
}
impl Default for ClosePortalStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod FetchDirection {
    pub type Type = ::core::ffi::c_uint;
    pub const FETCH_FORWARD: Type = 0;
    pub const FETCH_BACKWARD: Type = 1;
    pub const FETCH_ABSOLUTE: Type = 2;
    pub const FETCH_RELATIVE: Type = 3;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FetchStmt {
    pub type_: NodeTag,
    pub direction: FetchDirection::Type,
    pub howMany: ::core::ffi::c_long,
    pub portalname: *mut ::core::ffi::c_char,
    pub ismove: bool,
}
impl Default for FetchStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexStmt {
    pub type_: NodeTag,
    pub idxname: *mut ::core::ffi::c_char,
    pub relation: *mut RangeVar,
    pub accessMethod: *mut ::core::ffi::c_char,
    pub tableSpace: *mut ::core::ffi::c_char,
    pub indexParams: *mut List,
    pub indexIncludingParams: *mut List,
    pub options: *mut List,
    pub whereClause: *mut Node,
    pub excludeOpNames: *mut List,
    pub idxcomment: *mut ::core::ffi::c_char,
    pub indexOid: Oid,
    pub oldNode: Oid,
    pub oldCreateSubid: SubTransactionId,
    pub oldFirstRelfilenodeSubid: SubTransactionId,
    pub unique: bool,
    pub nulls_not_distinct: bool,
    pub primary: bool,
    pub isconstraint: bool,
    pub deferrable: bool,
    pub initdeferred: bool,
    pub transformed: bool,
    pub concurrent: bool,
    pub if_not_exists: bool,
    pub reset_default_tblspc: bool,
}
impl Default for IndexStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateStatsStmt {
    pub type_: NodeTag,
    pub defnames: *mut List,
    pub stat_types: *mut List,
    pub exprs: *mut List,
    pub relations: *mut List,
    pub stxcomment: *mut ::core::ffi::c_char,
    pub transformed: bool,
    pub if_not_exists: bool,
}
impl Default for CreateStatsStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StatsElem {
    pub type_: NodeTag,
    pub name: *mut ::core::ffi::c_char,
    pub expr: *mut Node,
}
impl Default for StatsElem {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterStatsStmt {
    pub type_: NodeTag,
    pub defnames: *mut List,
    pub stxstattarget: ::core::ffi::c_int,
    pub missing_ok: bool,
}
impl Default for AlterStatsStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateFunctionStmt {
    pub type_: NodeTag,
    pub is_procedure: bool,
    pub replace: bool,
    pub funcname: *mut List,
    pub parameters: *mut List,
    pub returnType: *mut TypeName,
    pub options: *mut List,
    pub sql_body: *mut Node,
}
impl Default for CreateFunctionStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod FunctionParameterMode {
    pub type Type = ::core::ffi::c_uint;
    pub const FUNC_PARAM_IN: Type = 105;
    pub const FUNC_PARAM_OUT: Type = 111;
    pub const FUNC_PARAM_INOUT: Type = 98;
    pub const FUNC_PARAM_VARIADIC: Type = 118;
    pub const FUNC_PARAM_TABLE: Type = 116;
    pub const FUNC_PARAM_DEFAULT: Type = 100;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FunctionParameter {
    pub type_: NodeTag,
    pub name: *mut ::core::ffi::c_char,
    pub argType: *mut TypeName,
    pub mode: FunctionParameterMode::Type,
    pub defexpr: *mut Node,
}
impl Default for FunctionParameter {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterFunctionStmt {
    pub type_: NodeTag,
    pub objtype: ObjectType::Type,
    pub func: *mut ObjectWithArgs,
    pub actions: *mut List,
}
impl Default for AlterFunctionStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DoStmt {
    pub type_: NodeTag,
    pub args: *mut List,
}
impl Default for DoStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct InlineCodeBlock {
    pub type_: NodeTag,
    pub source_text: *mut ::core::ffi::c_char,
    pub langOid: Oid,
    pub langIsTrusted: bool,
    pub atomic: bool,
}
impl Default for InlineCodeBlock {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CallStmt {
    pub type_: NodeTag,
    pub funccall: *mut FuncCall,
    pub funcexpr: *mut FuncExpr,
    pub outargs: *mut List,
}
impl Default for CallStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CallContext {
    pub type_: NodeTag,
    pub atomic: bool,
}
impl Default for CallContext {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RenameStmt {
    pub type_: NodeTag,
    pub renameType: ObjectType::Type,
    pub relationType: ObjectType::Type,
    pub relation: *mut RangeVar,
    pub object: *mut Node,
    pub subname: *mut ::core::ffi::c_char,
    pub newname: *mut ::core::ffi::c_char,
    pub behavior: DropBehavior::Type,
    pub missing_ok: bool,
}
impl Default for RenameStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterObjectDependsStmt {
    pub type_: NodeTag,
    pub objectType: ObjectType::Type,
    pub relation: *mut RangeVar,
    pub object: *mut Node,
    pub extname: *mut String,
    pub remove: bool,
}
impl Default for AlterObjectDependsStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterObjectSchemaStmt {
    pub type_: NodeTag,
    pub objectType: ObjectType::Type,
    pub relation: *mut RangeVar,
    pub object: *mut Node,
    pub newschema: *mut ::core::ffi::c_char,
    pub missing_ok: bool,
}
impl Default for AlterObjectSchemaStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterOwnerStmt {
    pub type_: NodeTag,
    pub objectType: ObjectType::Type,
    pub relation: *mut RangeVar,
    pub object: *mut Node,
    pub newowner: *mut RoleSpec,
}
impl Default for AlterOwnerStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterOperatorStmt {
    pub type_: NodeTag,
    pub opername: *mut ObjectWithArgs,
    pub options: *mut List,
}
impl Default for AlterOperatorStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterTypeStmt {
    pub type_: NodeTag,
    pub typeName: *mut List,
    pub options: *mut List,
}
impl Default for AlterTypeStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RuleStmt {
    pub type_: NodeTag,
    pub relation: *mut RangeVar,
    pub rulename: *mut ::core::ffi::c_char,
    pub whereClause: *mut Node,
    pub event: CmdType::Type,
    pub instead: bool,
    pub actions: *mut List,
    pub replace: bool,
}
impl Default for RuleStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NotifyStmt {
    pub type_: NodeTag,
    pub conditionname: *mut ::core::ffi::c_char,
    pub payload: *mut ::core::ffi::c_char,
}
impl Default for NotifyStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ListenStmt {
    pub type_: NodeTag,
    pub conditionname: *mut ::core::ffi::c_char,
}
impl Default for ListenStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct UnlistenStmt {
    pub type_: NodeTag,
    pub conditionname: *mut ::core::ffi::c_char,
}
impl Default for UnlistenStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod TransactionStmtKind {
    pub type Type = ::core::ffi::c_uint;
    pub const TRANS_STMT_BEGIN: Type = 0;
    pub const TRANS_STMT_START: Type = 1;
    pub const TRANS_STMT_COMMIT: Type = 2;
    pub const TRANS_STMT_ROLLBACK: Type = 3;
    pub const TRANS_STMT_SAVEPOINT: Type = 4;
    pub const TRANS_STMT_RELEASE: Type = 5;
    pub const TRANS_STMT_ROLLBACK_TO: Type = 6;
    pub const TRANS_STMT_PREPARE: Type = 7;
    pub const TRANS_STMT_COMMIT_PREPARED: Type = 8;
    pub const TRANS_STMT_ROLLBACK_PREPARED: Type = 9;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TransactionStmt {
    pub type_: NodeTag,
    pub kind: TransactionStmtKind::Type,
    pub options: *mut List,
    pub savepoint_name: *mut ::core::ffi::c_char,
    pub gid: *mut ::core::ffi::c_char,
    pub chain: bool,
}
impl Default for TransactionStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CompositeTypeStmt {
    pub type_: NodeTag,
    pub typevar: *mut RangeVar,
    pub coldeflist: *mut List,
}
impl Default for CompositeTypeStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateEnumStmt {
    pub type_: NodeTag,
    pub typeName: *mut List,
    pub vals: *mut List,
}
impl Default for CreateEnumStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateRangeStmt {
    pub type_: NodeTag,
    pub typeName: *mut List,
    pub params: *mut List,
}
impl Default for CreateRangeStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterEnumStmt {
    pub type_: NodeTag,
    pub typeName: *mut List,
    pub oldVal: *mut ::core::ffi::c_char,
    pub newVal: *mut ::core::ffi::c_char,
    pub newValNeighbor: *mut ::core::ffi::c_char,
    pub newValIsAfter: bool,
    pub skipIfNewValExists: bool,
}
impl Default for AlterEnumStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod ViewCheckOption {
    pub type Type = ::core::ffi::c_uint;
    pub const NO_CHECK_OPTION: Type = 0;
    pub const LOCAL_CHECK_OPTION: Type = 1;
    pub const CASCADED_CHECK_OPTION: Type = 2;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ViewStmt {
    pub type_: NodeTag,
    pub view: *mut RangeVar,
    pub aliases: *mut List,
    pub query: *mut Node,
    pub replace: bool,
    pub options: *mut List,
    pub withCheckOption: ViewCheckOption::Type,
}
impl Default for ViewStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LoadStmt {
    pub type_: NodeTag,
    pub filename: *mut ::core::ffi::c_char,
}
impl Default for LoadStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreatedbStmt {
    pub type_: NodeTag,
    pub dbname: *mut ::core::ffi::c_char,
    pub options: *mut List,
}
impl Default for CreatedbStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterDatabaseStmt {
    pub type_: NodeTag,
    pub dbname: *mut ::core::ffi::c_char,
    pub options: *mut List,
}
impl Default for AlterDatabaseStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterDatabaseRefreshCollStmt {
    pub type_: NodeTag,
    pub dbname: *mut ::core::ffi::c_char,
}
impl Default for AlterDatabaseRefreshCollStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterDatabaseSetStmt {
    pub type_: NodeTag,
    pub dbname: *mut ::core::ffi::c_char,
    pub setstmt: *mut VariableSetStmt,
}
impl Default for AlterDatabaseSetStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DropdbStmt {
    pub type_: NodeTag,
    pub dbname: *mut ::core::ffi::c_char,
    pub missing_ok: bool,
    pub options: *mut List,
}
impl Default for DropdbStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterSystemStmt {
    pub type_: NodeTag,
    pub setstmt: *mut VariableSetStmt,
}
impl Default for AlterSystemStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ClusterStmt {
    pub type_: NodeTag,
    pub relation: *mut RangeVar,
    pub indexname: *mut ::core::ffi::c_char,
    pub params: *mut List,
}
impl Default for ClusterStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VacuumStmt {
    pub type_: NodeTag,
    pub options: *mut List,
    pub rels: *mut List,
    pub is_vacuumcmd: bool,
}
impl Default for VacuumStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VacuumRelation {
    pub type_: NodeTag,
    pub relation: *mut RangeVar,
    pub oid: Oid,
    pub va_cols: *mut List,
}
impl Default for VacuumRelation {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExplainStmt {
    pub type_: NodeTag,
    pub query: *mut Node,
    pub options: *mut List,
}
impl Default for ExplainStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateTableAsStmt {
    pub type_: NodeTag,
    pub query: *mut Node,
    pub into: *mut IntoClause,
    pub objtype: ObjectType::Type,
    pub is_select_into: bool,
    pub if_not_exists: bool,
}
impl Default for CreateTableAsStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RefreshMatViewStmt {
    pub type_: NodeTag,
    pub concurrent: bool,
    pub skipData: bool,
    pub relation: *mut RangeVar,
}
impl Default for RefreshMatViewStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CheckPointStmt {
    pub type_: NodeTag,
}
impl Default for CheckPointStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod DiscardMode {
    pub type Type = ::core::ffi::c_uint;
    pub const DISCARD_ALL: Type = 0;
    pub const DISCARD_PLANS: Type = 1;
    pub const DISCARD_SEQUENCES: Type = 2;
    pub const DISCARD_TEMP: Type = 3;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DiscardStmt {
    pub type_: NodeTag,
    pub target: DiscardMode::Type,
}
impl Default for DiscardStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LockStmt {
    pub type_: NodeTag,
    pub relations: *mut List,
    pub mode: ::core::ffi::c_int,
    pub nowait: bool,
}
impl Default for LockStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ConstraintsSetStmt {
    pub type_: NodeTag,
    pub constraints: *mut List,
    pub deferred: bool,
}
impl Default for ConstraintsSetStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod ReindexObjectType {
    pub type Type = ::core::ffi::c_uint;
    pub const REINDEX_OBJECT_INDEX: Type = 0;
    pub const REINDEX_OBJECT_TABLE: Type = 1;
    pub const REINDEX_OBJECT_SCHEMA: Type = 2;
    pub const REINDEX_OBJECT_SYSTEM: Type = 3;
    pub const REINDEX_OBJECT_DATABASE: Type = 4;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ReindexStmt {
    pub type_: NodeTag,
    pub kind: ReindexObjectType::Type,
    pub relation: *mut RangeVar,
    pub name: *const ::core::ffi::c_char,
    pub params: *mut List,
}
impl Default for ReindexStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateConversionStmt {
    pub type_: NodeTag,
    pub conversion_name: *mut List,
    pub for_encoding_name: *mut ::core::ffi::c_char,
    pub to_encoding_name: *mut ::core::ffi::c_char,
    pub func_name: *mut List,
    pub def: bool,
}
impl Default for CreateConversionStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateCastStmt {
    pub type_: NodeTag,
    pub sourcetype: *mut TypeName,
    pub targettype: *mut TypeName,
    pub func: *mut ObjectWithArgs,
    pub context: CoercionContext::Type,
    pub inout: bool,
}
impl Default for CreateCastStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateTransformStmt {
    pub type_: NodeTag,
    pub replace: bool,
    pub type_name: *mut TypeName,
    pub lang: *mut ::core::ffi::c_char,
    pub fromsql: *mut ObjectWithArgs,
    pub tosql: *mut ObjectWithArgs,
}
impl Default for CreateTransformStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PrepareStmt {
    pub type_: NodeTag,
    pub name: *mut ::core::ffi::c_char,
    pub argtypes: *mut List,
    pub query: *mut Node,
}
impl Default for PrepareStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExecuteStmt {
    pub type_: NodeTag,
    pub name: *mut ::core::ffi::c_char,
    pub params: *mut List,
}
impl Default for ExecuteStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DeallocateStmt {
    pub type_: NodeTag,
    pub name: *mut ::core::ffi::c_char,
}
impl Default for DeallocateStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DropOwnedStmt {
    pub type_: NodeTag,
    pub roles: *mut List,
    pub behavior: DropBehavior::Type,
}
impl Default for DropOwnedStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ReassignOwnedStmt {
    pub type_: NodeTag,
    pub roles: *mut List,
    pub newrole: *mut RoleSpec,
}
impl Default for ReassignOwnedStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterTSDictionaryStmt {
    pub type_: NodeTag,
    pub dictname: *mut List,
    pub options: *mut List,
}
impl Default for AlterTSDictionaryStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod AlterTSConfigType {
    pub type Type = ::core::ffi::c_uint;
    pub const ALTER_TSCONFIG_ADD_MAPPING: Type = 0;
    pub const ALTER_TSCONFIG_ALTER_MAPPING_FOR_TOKEN: Type = 1;
    pub const ALTER_TSCONFIG_REPLACE_DICT: Type = 2;
    pub const ALTER_TSCONFIG_REPLACE_DICT_FOR_TOKEN: Type = 3;
    pub const ALTER_TSCONFIG_DROP_MAPPING: Type = 4;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterTSConfigurationStmt {
    pub type_: NodeTag,
    pub kind: AlterTSConfigType::Type,
    pub cfgname: *mut List,
    pub tokentype: *mut List,
    pub dicts: *mut List,
    pub override_: bool,
    pub replace: bool,
    pub missing_ok: bool,
}
impl Default for AlterTSConfigurationStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PublicationTable {
    pub type_: NodeTag,
    pub relation: *mut RangeVar,
    pub whereClause: *mut Node,
    pub columns: *mut List,
}
impl Default for PublicationTable {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod PublicationObjSpecType {
    pub type Type = ::core::ffi::c_uint;
    pub const PUBLICATIONOBJ_TABLE: Type = 0;
    pub const PUBLICATIONOBJ_TABLES_IN_SCHEMA: Type = 1;
    pub const PUBLICATIONOBJ_TABLES_IN_CUR_SCHEMA: Type = 2;
    pub const PUBLICATIONOBJ_CONTINUATION: Type = 3;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PublicationObjSpec {
    pub type_: NodeTag,
    pub pubobjtype: PublicationObjSpecType::Type,
    pub name: *mut ::core::ffi::c_char,
    pub pubtable: *mut PublicationTable,
    pub location: ::core::ffi::c_int,
}
impl Default for PublicationObjSpec {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreatePublicationStmt {
    pub type_: NodeTag,
    pub pubname: *mut ::core::ffi::c_char,
    pub options: *mut List,
    pub pubobjects: *mut List,
    pub for_all_tables: bool,
}
impl Default for CreatePublicationStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod AlterPublicationAction {
    pub type Type = ::core::ffi::c_uint;
    pub const AP_AddObjects: Type = 0;
    pub const AP_DropObjects: Type = 1;
    pub const AP_SetObjects: Type = 2;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterPublicationStmt {
    pub type_: NodeTag,
    pub pubname: *mut ::core::ffi::c_char,
    pub options: *mut List,
    pub pubobjects: *mut List,
    pub for_all_tables: bool,
    pub action: AlterPublicationAction::Type,
}
impl Default for AlterPublicationStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateSubscriptionStmt {
    pub type_: NodeTag,
    pub subname: *mut ::core::ffi::c_char,
    pub conninfo: *mut ::core::ffi::c_char,
    pub publication: *mut List,
    pub options: *mut List,
}
impl Default for CreateSubscriptionStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod AlterSubscriptionType {
    pub type Type = ::core::ffi::c_uint;
    pub const ALTER_SUBSCRIPTION_OPTIONS: Type = 0;
    pub const ALTER_SUBSCRIPTION_CONNECTION: Type = 1;
    pub const ALTER_SUBSCRIPTION_SET_PUBLICATION: Type = 2;
    pub const ALTER_SUBSCRIPTION_ADD_PUBLICATION: Type = 3;
    pub const ALTER_SUBSCRIPTION_DROP_PUBLICATION: Type = 4;
    pub const ALTER_SUBSCRIPTION_REFRESH: Type = 5;
    pub const ALTER_SUBSCRIPTION_ENABLED: Type = 6;
    pub const ALTER_SUBSCRIPTION_SKIP: Type = 7;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterSubscriptionStmt {
    pub type_: NodeTag,
    pub kind: AlterSubscriptionType::Type,
    pub subname: *mut ::core::ffi::c_char,
    pub conninfo: *mut ::core::ffi::c_char,
    pub publication: *mut List,
    pub options: *mut List,
}
impl Default for AlterSubscriptionStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DropSubscriptionStmt {
    pub type_: NodeTag,
    pub subname: *mut ::core::ffi::c_char,
    pub missing_ok: bool,
    pub behavior: DropBehavior::Type,
}
impl Default for DropSubscriptionStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PlannedStmt {
    pub type_: NodeTag,
    pub commandType: CmdType::Type,
    pub queryId: uint64,
    pub hasReturning: bool,
    pub hasModifyingCTE: bool,
    pub canSetTag: bool,
    pub transientPlan: bool,
    pub dependsOnRole: bool,
    pub parallelModeNeeded: bool,
    pub jitFlags: ::core::ffi::c_int,
    pub planTree: *mut Plan,
    pub rtable: *mut List,
    pub resultRelations: *mut List,
    pub appendRelations: *mut List,
    pub subplans: *mut List,
    pub rewindPlanIDs: *mut Bitmapset,
    pub rowMarks: *mut List,
    pub relationOids: *mut List,
    pub invalItems: *mut List,
    pub paramExecTypes: *mut List,
    pub utilityStmt: *mut Node,
    pub stmt_location: ::core::ffi::c_int,
    pub stmt_len: ::core::ffi::c_int,
}
impl Default for PlannedStmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Plan {
    pub type_: NodeTag,
    pub startup_cost: Cost,
    pub total_cost: Cost,
    pub plan_rows: Cardinality,
    pub plan_width: ::core::ffi::c_int,
    pub parallel_aware: bool,
    pub parallel_safe: bool,
    pub async_capable: bool,
    pub plan_node_id: ::core::ffi::c_int,
    pub targetlist: *mut List,
    pub qual: *mut List,
    pub lefttree: *mut Plan,
    pub righttree: *mut Plan,
    pub initPlan: *mut List,
    pub extParam: *mut Bitmapset,
    pub allParam: *mut Bitmapset,
}
impl Default for Plan {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Result {
    pub plan: Plan,
    pub resconstantqual: *mut Node,
}
impl Default for Result {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ProjectSet {
    pub plan: Plan,
}
impl Default for ProjectSet {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ModifyTable {
    pub plan: Plan,
    pub operation: CmdType::Type,
    pub canSetTag: bool,
    pub nominalRelation: Index,
    pub rootRelation: Index,
    pub partColsUpdated: bool,
    pub resultRelations: *mut List,
    pub updateColnosLists: *mut List,
    pub withCheckOptionLists: *mut List,
    pub returningLists: *mut List,
    pub fdwPrivLists: *mut List,
    pub fdwDirectModifyPlans: *mut Bitmapset,
    pub rowMarks: *mut List,
    pub epqParam: ::core::ffi::c_int,
    pub onConflictAction: OnConflictAction::Type,
    pub arbiterIndexes: *mut List,
    pub onConflictSet: *mut List,
    pub onConflictCols: *mut List,
    pub onConflictWhere: *mut Node,
    pub exclRelRTI: Index,
    pub exclRelTlist: *mut List,
    pub mergeActionLists: *mut List,
}
impl Default for ModifyTable {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Append {
    pub plan: Plan,
    pub apprelids: *mut Bitmapset,
    pub appendplans: *mut List,
    pub nasyncplans: ::core::ffi::c_int,
    pub first_partial_plan: ::core::ffi::c_int,
    pub part_prune_info: *mut PartitionPruneInfo,
}
impl Default for Append {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MergeAppend {
    pub plan: Plan,
    pub apprelids: *mut Bitmapset,
    pub mergeplans: *mut List,
    pub numCols: ::core::ffi::c_int,
    pub sortColIdx: *mut AttrNumber,
    pub sortOperators: *mut Oid,
    pub collations: *mut Oid,
    pub nullsFirst: *mut bool,
    pub part_prune_info: *mut PartitionPruneInfo,
}
impl Default for MergeAppend {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RecursiveUnion {
    pub plan: Plan,
    pub wtParam: ::core::ffi::c_int,
    pub numCols: ::core::ffi::c_int,
    pub dupColIdx: *mut AttrNumber,
    pub dupOperators: *mut Oid,
    pub dupCollations: *mut Oid,
    pub numGroups: ::core::ffi::c_long,
}
impl Default for RecursiveUnion {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BitmapAnd {
    pub plan: Plan,
    pub bitmapplans: *mut List,
}
impl Default for BitmapAnd {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BitmapOr {
    pub plan: Plan,
    pub isshared: bool,
    pub bitmapplans: *mut List,
}
impl Default for BitmapOr {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Scan {
    pub plan: Plan,
    pub scanrelid: Index,
}
impl Default for Scan {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SeqScan {
    pub scan: Scan,
}
impl Default for SeqScan {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SampleScan {
    pub scan: Scan,
    pub tablesample: *mut TableSampleClause,
}
impl Default for SampleScan {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexScan {
    pub scan: Scan,
    pub indexid: Oid,
    pub indexqual: *mut List,
    pub indexqualorig: *mut List,
    pub indexorderby: *mut List,
    pub indexorderbyorig: *mut List,
    pub indexorderbyops: *mut List,
    pub indexorderdir: ScanDirection::Type,
}
impl Default for IndexScan {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexOnlyScan {
    pub scan: Scan,
    pub indexid: Oid,
    pub indexqual: *mut List,
    pub recheckqual: *mut List,
    pub indexorderby: *mut List,
    pub indextlist: *mut List,
    pub indexorderdir: ScanDirection::Type,
}
impl Default for IndexOnlyScan {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BitmapIndexScan {
    pub scan: Scan,
    pub indexid: Oid,
    pub isshared: bool,
    pub indexqual: *mut List,
    pub indexqualorig: *mut List,
}
impl Default for BitmapIndexScan {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BitmapHeapScan {
    pub scan: Scan,
    pub bitmapqualorig: *mut List,
}
impl Default for BitmapHeapScan {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TidScan {
    pub scan: Scan,
    pub tidquals: *mut List,
}
impl Default for TidScan {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TidRangeScan {
    pub scan: Scan,
    pub tidrangequals: *mut List,
}
impl Default for TidRangeScan {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod SubqueryScanStatus {
    pub type Type = ::core::ffi::c_uint;
    pub const SUBQUERY_SCAN_UNKNOWN: Type = 0;
    pub const SUBQUERY_SCAN_TRIVIAL: Type = 1;
    pub const SUBQUERY_SCAN_NONTRIVIAL: Type = 2;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SubqueryScan {
    pub scan: Scan,
    pub subplan: *mut Plan,
    pub scanstatus: SubqueryScanStatus::Type,
}
impl Default for SubqueryScan {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FunctionScan {
    pub scan: Scan,
    pub functions: *mut List,
    pub funcordinality: bool,
}
impl Default for FunctionScan {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ValuesScan {
    pub scan: Scan,
    pub values_lists: *mut List,
}
impl Default for ValuesScan {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TableFuncScan {
    pub scan: Scan,
    pub tablefunc: *mut TableFunc,
}
impl Default for TableFuncScan {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CteScan {
    pub scan: Scan,
    pub ctePlanId: ::core::ffi::c_int,
    pub cteParam: ::core::ffi::c_int,
}
impl Default for CteScan {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NamedTuplestoreScan {
    pub scan: Scan,
    pub enrname: *mut ::core::ffi::c_char,
}
impl Default for NamedTuplestoreScan {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WorkTableScan {
    pub scan: Scan,
    pub wtParam: ::core::ffi::c_int,
}
impl Default for WorkTableScan {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ForeignScan {
    pub scan: Scan,
    pub operation: CmdType::Type,
    pub resultRelation: Index,
    pub fs_server: Oid,
    pub fdw_exprs: *mut List,
    pub fdw_private: *mut List,
    pub fdw_scan_tlist: *mut List,
    pub fdw_recheck_quals: *mut List,
    pub fs_relids: *mut Bitmapset,
    pub fsSystemCol: bool,
}
impl Default for ForeignScan {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CustomScan {
    pub scan: Scan,
    pub flags: uint32,
    pub custom_plans: *mut List,
    pub custom_exprs: *mut List,
    pub custom_private: *mut List,
    pub custom_scan_tlist: *mut List,
    pub custom_relids: *mut Bitmapset,
    pub methods: *const CustomScanMethods,
}
impl Default for CustomScan {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Join {
    pub plan: Plan,
    pub jointype: JoinType::Type,
    pub inner_unique: bool,
    pub joinqual: *mut List,
}
impl Default for Join {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NestLoop {
    pub join: Join,
    pub nestParams: *mut List,
}
impl Default for NestLoop {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NestLoopParam {
    pub type_: NodeTag,
    pub paramno: ::core::ffi::c_int,
    pub paramval: *mut Var,
}
impl Default for NestLoopParam {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MergeJoin {
    pub join: Join,
    pub skip_mark_restore: bool,
    pub mergeclauses: *mut List,
    pub mergeFamilies: *mut Oid,
    pub mergeCollations: *mut Oid,
    pub mergeStrategies: *mut ::core::ffi::c_int,
    pub mergeNullsFirst: *mut bool,
}
impl Default for MergeJoin {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HashJoin {
    pub join: Join,
    pub hashclauses: *mut List,
    pub hashoperators: *mut List,
    pub hashcollations: *mut List,
    pub hashkeys: *mut List,
}
impl Default for HashJoin {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Material {
    pub plan: Plan,
}
impl Default for Material {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Memoize {
    pub plan: Plan,
    pub numKeys: ::core::ffi::c_int,
    pub hashOperators: *mut Oid,
    pub collations: *mut Oid,
    pub param_exprs: *mut List,
    pub singlerow: bool,
    pub binary_mode: bool,
    pub est_entries: uint32,
    pub keyparamids: *mut Bitmapset,
}
impl Default for Memoize {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Sort {
    pub plan: Plan,
    pub numCols: ::core::ffi::c_int,
    pub sortColIdx: *mut AttrNumber,
    pub sortOperators: *mut Oid,
    pub collations: *mut Oid,
    pub nullsFirst: *mut bool,
}
impl Default for Sort {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IncrementalSort {
    pub sort: Sort,
    pub nPresortedCols: ::core::ffi::c_int,
}
impl Default for IncrementalSort {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Group {
    pub plan: Plan,
    pub numCols: ::core::ffi::c_int,
    pub grpColIdx: *mut AttrNumber,
    pub grpOperators: *mut Oid,
    pub grpCollations: *mut Oid,
}
impl Default for Group {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Agg {
    pub plan: Plan,
    pub aggstrategy: AggStrategy::Type,
    pub aggsplit: AggSplit::Type,
    pub numCols: ::core::ffi::c_int,
    pub grpColIdx: *mut AttrNumber,
    pub grpOperators: *mut Oid,
    pub grpCollations: *mut Oid,
    pub numGroups: ::core::ffi::c_long,
    pub transitionSpace: uint64,
    pub aggParams: *mut Bitmapset,
    pub groupingSets: *mut List,
    pub chain: *mut List,
}
impl Default for Agg {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WindowAgg {
    pub plan: Plan,
    pub winref: Index,
    pub partNumCols: ::core::ffi::c_int,
    pub partColIdx: *mut AttrNumber,
    pub partOperators: *mut Oid,
    pub partCollations: *mut Oid,
    pub ordNumCols: ::core::ffi::c_int,
    pub ordColIdx: *mut AttrNumber,
    pub ordOperators: *mut Oid,
    pub ordCollations: *mut Oid,
    pub frameOptions: ::core::ffi::c_int,
    pub startOffset: *mut Node,
    pub endOffset: *mut Node,
    pub runCondition: *mut List,
    pub runConditionOrig: *mut List,
    pub startInRangeFunc: Oid,
    pub endInRangeFunc: Oid,
    pub inRangeColl: Oid,
    pub inRangeAsc: bool,
    pub inRangeNullsFirst: bool,
    pub topWindow: bool,
}
impl Default for WindowAgg {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Unique {
    pub plan: Plan,
    pub numCols: ::core::ffi::c_int,
    pub uniqColIdx: *mut AttrNumber,
    pub uniqOperators: *mut Oid,
    pub uniqCollations: *mut Oid,
}
impl Default for Unique {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Gather {
    pub plan: Plan,
    pub num_workers: ::core::ffi::c_int,
    pub rescan_param: ::core::ffi::c_int,
    pub single_copy: bool,
    pub invisible: bool,
    pub initParam: *mut Bitmapset,
}
impl Default for Gather {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GatherMerge {
    pub plan: Plan,
    pub num_workers: ::core::ffi::c_int,
    pub rescan_param: ::core::ffi::c_int,
    pub numCols: ::core::ffi::c_int,
    pub sortColIdx: *mut AttrNumber,
    pub sortOperators: *mut Oid,
    pub collations: *mut Oid,
    pub nullsFirst: *mut bool,
    pub initParam: *mut Bitmapset,
}
impl Default for GatherMerge {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Hash {
    pub plan: Plan,
    pub hashkeys: *mut List,
    pub skewTable: Oid,
    pub skewColumn: AttrNumber,
    pub skewInherit: bool,
    pub rows_total: Cardinality,
}
impl Default for Hash {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SetOp {
    pub plan: Plan,
    pub cmd: SetOpCmd::Type,
    pub strategy: SetOpStrategy::Type,
    pub numCols: ::core::ffi::c_int,
    pub dupColIdx: *mut AttrNumber,
    pub dupOperators: *mut Oid,
    pub dupCollations: *mut Oid,
    pub flagColIdx: AttrNumber,
    pub firstFlag: ::core::ffi::c_int,
    pub numGroups: ::core::ffi::c_long,
}
impl Default for SetOp {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LockRows {
    pub plan: Plan,
    pub rowMarks: *mut List,
    pub epqParam: ::core::ffi::c_int,
}
impl Default for LockRows {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Limit {
    pub plan: Plan,
    pub limitOffset: *mut Node,
    pub limitCount: *mut Node,
    pub limitOption: LimitOption::Type,
    pub uniqNumCols: ::core::ffi::c_int,
    pub uniqColIdx: *mut AttrNumber,
    pub uniqOperators: *mut Oid,
    pub uniqCollations: *mut Oid,
}
impl Default for Limit {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod RowMarkType {
    pub type Type = ::core::ffi::c_uint;
    pub const ROW_MARK_EXCLUSIVE: Type = 0;
    pub const ROW_MARK_NOKEYEXCLUSIVE: Type = 1;
    pub const ROW_MARK_SHARE: Type = 2;
    pub const ROW_MARK_KEYSHARE: Type = 3;
    pub const ROW_MARK_REFERENCE: Type = 4;
    pub const ROW_MARK_COPY: Type = 5;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PlanRowMark {
    pub type_: NodeTag,
    pub rti: Index,
    pub prti: Index,
    pub rowmarkId: Index,
    pub markType: RowMarkType::Type,
    pub allMarkTypes: ::core::ffi::c_int,
    pub strength: LockClauseStrength::Type,
    pub waitPolicy: LockWaitPolicy::Type,
    pub isParent: bool,
}
impl Default for PlanRowMark {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionPruneInfo {
    pub type_: NodeTag,
    pub prune_infos: *mut List,
    pub other_subplans: *mut Bitmapset,
}
impl Default for PartitionPruneInfo {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionedRelPruneInfo {
    pub type_: NodeTag,
    pub rtindex: Index,
    pub present_parts: *mut Bitmapset,
    pub nparts: ::core::ffi::c_int,
    pub subplan_map: *mut ::core::ffi::c_int,
    pub subpart_map: *mut ::core::ffi::c_int,
    pub relid_map: *mut Oid,
    pub initial_pruning_steps: *mut List,
    pub exec_pruning_steps: *mut List,
    pub execparamids: *mut Bitmapset,
}
impl Default for PartitionedRelPruneInfo {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionPruneStep {
    pub type_: NodeTag,
    pub step_id: ::core::ffi::c_int,
}
impl Default for PartitionPruneStep {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionPruneStepOp {
    pub step: PartitionPruneStep,
    pub opstrategy: StrategyNumber,
    pub exprs: *mut List,
    pub cmpfns: *mut List,
    pub nullkeys: *mut Bitmapset,
}
impl Default for PartitionPruneStepOp {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod PartitionPruneCombineOp {
    pub type Type = ::core::ffi::c_uint;
    pub const PARTPRUNE_COMBINE_UNION: Type = 0;
    pub const PARTPRUNE_COMBINE_INTERSECT: Type = 1;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionPruneStepCombine {
    pub step: PartitionPruneStep,
    pub combineOp: PartitionPruneCombineOp::Type,
    pub source_stepids: *mut List,
}
impl Default for PartitionPruneStepCombine {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PlanInvalItem {
    pub type_: NodeTag,
    pub cacheId: ::core::ffi::c_int,
    pub hashValue: uint32,
}
impl Default for PlanInvalItem {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod MonotonicFunction {
    pub type Type = ::core::ffi::c_uint;
    pub const MONOTONICFUNC_NONE: Type = 0;
    pub const MONOTONICFUNC_INCREASING: Type = 1;
    pub const MONOTONICFUNC_DECREASING: Type = 2;
    pub const MONOTONICFUNC_BOTH: Type = 3;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct pg_atomic_flag {
    pub value: ::core::ffi::c_char,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct pg_atomic_uint32 {
    pub value: uint32,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct pg_atomic_uint64 {
    pub value: uint64,
}
pub type dsm_handle = uint32;
pub mod dsm_op {
    pub type Type = ::core::ffi::c_uint;
    pub const DSM_OP_CREATE: Type = 0;
    pub const DSM_OP_ATTACH: Type = 1;
    pub const DSM_OP_DETACH: Type = 2;
    pub const DSM_OP_DESTROY: Type = 3;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dsm_segment {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PGShmemHeader {
    _unused: [u8; 0],
}
pub type on_dsm_detach_callback =
    ::core::option::Option<unsafe extern "C-unwind" fn(arg1: *mut dsm_segment, arg: Datum)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dsa_area {
    _unused: [u8; 0],
}
pub type dsa_pointer = uint64;
pub type dsa_pointer_atomic = pg_atomic_uint64;
pub type dsa_handle = dsm_handle;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TIDBitmap {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TBMIterator {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TBMSharedIterator {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct TBMIterateResult {
    pub blockno: BlockNumber,
    pub ntuples: ::core::ffi::c_int,
    pub recheck: bool,
    pub offsets: __IncompleteArrayField<OffsetNumber>,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct proclist_node {
    pub next: ::core::ffi::c_int,
    pub prev: ::core::ffi::c_int,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct proclist_head {
    pub head: ::core::ffi::c_int,
    pub tail: ::core::ffi::c_int,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct proclist_mutable_iter {
    pub cur: ::core::ffi::c_int,
    pub next: ::core::ffi::c_int,
}
pub type slock_t = ::core::ffi::c_uchar;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SpinDelayStatus {
    pub spins: ::core::ffi::c_int,
    pub delays: ::core::ffi::c_int,
    pub cur_delay: ::core::ffi::c_int,
    pub file: *const ::core::ffi::c_char,
    pub line: ::core::ffi::c_int,
    pub func: *const ::core::ffi::c_char,
}
impl Default for SpinDelayStatus {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ConditionVariable {
    pub mutex: slock_t,
    pub wakeup: proclist_head,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union ConditionVariableMinimallyPadded {
    pub cv: ConditionVariable,
    pub pad: [::core::ffi::c_char; 16usize],
}
impl Default for ConditionVariableMinimallyPadded {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type HashValueFunc = ::core::option::Option<
    unsafe extern "C-unwind" fn(key: *const ::core::ffi::c_void, keysize: Size) -> uint32,
>;
pub type HashCompareFunc = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        key1: *const ::core::ffi::c_void,
        key2: *const ::core::ffi::c_void,
        keysize: Size,
    ) -> ::core::ffi::c_int,
>;
pub type HashCopyFunc = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        dest: *mut ::core::ffi::c_void,
        src: *const ::core::ffi::c_void,
        keysize: Size,
    ) -> *mut ::core::ffi::c_void,
>;
pub type HashAllocFunc =
    ::core::option::Option<unsafe extern "C-unwind" fn(request: Size) -> *mut ::core::ffi::c_void>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HASHELEMENT {
    pub link: *mut HASHELEMENT,
    pub hashvalue: uint32,
}
impl Default for HASHELEMENT {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HASHHDR {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HTAB {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HASHCTL {
    pub num_partitions: ::core::ffi::c_long,
    pub ssize: ::core::ffi::c_long,
    pub dsize: ::core::ffi::c_long,
    pub max_dsize: ::core::ffi::c_long,
    pub keysize: Size,
    pub entrysize: Size,
    pub hash: HashValueFunc,
    pub match_: HashCompareFunc,
    pub keycopy: HashCopyFunc,
    pub alloc: HashAllocFunc,
    pub hcxt: MemoryContext,
    pub hctl: *mut HASHHDR,
}
impl Default for HASHCTL {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod HASHACTION {
    pub type Type = ::core::ffi::c_uint;
    pub const HASH_FIND: Type = 0;
    pub const HASH_ENTER: Type = 1;
    pub const HASH_REMOVE: Type = 2;
    pub const HASH_ENTER_NULL: Type = 3;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HASH_SEQ_STATUS {
    pub hashp: *mut HTAB,
    pub curBucket: uint32,
    pub curEntry: *mut HASHELEMENT,
}
impl Default for HASH_SEQ_STATUS {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod EphemeralNameRelationType {
    pub type Type = ::core::ffi::c_uint;
    pub const ENR_NAMED_TUPLESTORE: Type = 0;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct EphemeralNamedRelationMetadataData {
    pub name: *mut ::core::ffi::c_char,
    pub reliddesc: Oid,
    pub tupdesc: TupleDesc,
    pub enrtype: EphemeralNameRelationType::Type,
    pub enrtuples: f64,
}
impl Default for EphemeralNamedRelationMetadataData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type EphemeralNamedRelationMetadata = *mut EphemeralNamedRelationMetadataData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct EphemeralNamedRelationData {
    pub md: EphemeralNamedRelationMetadataData,
    pub reldata: *mut ::core::ffi::c_void,
}
impl Default for EphemeralNamedRelationData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type EphemeralNamedRelation = *mut EphemeralNamedRelationData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct QueryEnvironment {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Trigger {
    pub tgoid: Oid,
    pub tgname: *mut ::core::ffi::c_char,
    pub tgfoid: Oid,
    pub tgtype: int16,
    pub tgenabled: ::core::ffi::c_char,
    pub tgisinternal: bool,
    pub tgisclone: bool,
    pub tgconstrrelid: Oid,
    pub tgconstrindid: Oid,
    pub tgconstraint: Oid,
    pub tgdeferrable: bool,
    pub tginitdeferred: bool,
    pub tgnargs: int16,
    pub tgnattr: int16,
    pub tgattr: *mut int16,
    pub tgargs: *mut *mut ::core::ffi::c_char,
    pub tgqual: *mut ::core::ffi::c_char,
    pub tgoldtable: *mut ::core::ffi::c_char,
    pub tgnewtable: *mut ::core::ffi::c_char,
}
impl Default for Trigger {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TriggerDesc {
    pub triggers: *mut Trigger,
    pub numtriggers: ::core::ffi::c_int,
    pub trig_insert_before_row: bool,
    pub trig_insert_after_row: bool,
    pub trig_insert_instead_row: bool,
    pub trig_insert_before_statement: bool,
    pub trig_insert_after_statement: bool,
    pub trig_update_before_row: bool,
    pub trig_update_after_row: bool,
    pub trig_update_instead_row: bool,
    pub trig_update_before_statement: bool,
    pub trig_update_after_statement: bool,
    pub trig_delete_before_row: bool,
    pub trig_delete_after_row: bool,
    pub trig_delete_instead_row: bool,
    pub trig_delete_before_statement: bool,
    pub trig_delete_after_statement: bool,
    pub trig_truncate_before_statement: bool,
    pub trig_truncate_after_statement: bool,
    pub trig_insert_new_table: bool,
    pub trig_update_old_table: bool,
    pub trig_update_new_table: bool,
    pub trig_delete_old_table: bool,
}
impl Default for TriggerDesc {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dirent {
    pub d_ino: __ino_t,
    pub d_off: __off_t,
    pub d_reclen: ::core::ffi::c_ushort,
    pub d_type: ::core::ffi::c_uchar,
    pub d_name: [::core::ffi::c_char; 256usize],
}
impl Default for dirent {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __dirstream {
    _unused: [u8; 0],
}
pub type DIR = __dirstream;
pub mod RecoveryInitSyncMethod {
    pub type Type = ::core::ffi::c_uint;
    pub const RECOVERY_INIT_SYNC_METHOD_FSYNC: Type = 0;
    pub const RECOVERY_INIT_SYNC_METHOD_SYNCFS: Type = 1;
}
pub type File = ::core::ffi::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FileSet {
    pub creator_pid: pid_t,
    pub number: uint32,
    pub ntablespaces: ::core::ffi::c_int,
    pub tablespaces: [Oid; 8usize],
}
impl Default for FileSet {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SharedFileSet {
    pub fs: FileSet,
    pub mutex: slock_t,
    pub refcnt: ::core::ffi::c_int,
}
impl Default for SharedFileSet {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SharedTuplestore {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SharedTuplestoreAccessor {
    _unused: [u8; 0],
}
pub type Timestamp = int64;
pub type TimestampTz = int64;
pub type TimeOffset = int64;
pub type fsec_t = int32;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct Interval {
    pub time: TimeOffset,
    pub day: int32,
    pub month: int32,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct pg_itm {
    pub tm_usec: ::core::ffi::c_int,
    pub tm_sec: ::core::ffi::c_int,
    pub tm_min: ::core::ffi::c_int,
    pub tm_hour: int64,
    pub tm_mday: ::core::ffi::c_int,
    pub tm_mon: ::core::ffi::c_int,
    pub tm_year: ::core::ffi::c_int,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct pg_itm_in {
    pub tm_usec: int64,
    pub tm_mday: ::core::ffi::c_int,
    pub tm_mon: ::core::ffi::c_int,
    pub tm_year: ::core::ffi::c_int,
}
pub mod SnapshotType {
    pub type Type = ::core::ffi::c_uint;
    pub const SNAPSHOT_MVCC: Type = 0;
    pub const SNAPSHOT_SELF: Type = 1;
    pub const SNAPSHOT_ANY: Type = 2;
    pub const SNAPSHOT_TOAST: Type = 3;
    pub const SNAPSHOT_DIRTY: Type = 4;
    pub const SNAPSHOT_HISTORIC_MVCC: Type = 5;
    pub const SNAPSHOT_NON_VACUUMABLE: Type = 6;
}
pub type Snapshot = *mut SnapshotData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SnapshotData {
    pub snapshot_type: SnapshotType::Type,
    pub xmin: TransactionId,
    pub xmax: TransactionId,
    pub xip: *mut TransactionId,
    pub xcnt: uint32,
    pub subxip: *mut TransactionId,
    pub subxcnt: int32,
    pub suboverflowed: bool,
    pub takenDuringRecovery: bool,
    pub copied: bool,
    pub curcid: CommandId,
    pub speculativeToken: uint32,
    pub vistest: *mut GlobalVisState,
    pub active_count: uint32,
    pub regd_count: uint32,
    pub ph_node: pairingheap_node,
    pub whenTaken: TimestampTz,
    pub lsn: XLogRecPtr,
    pub snapXactCompletionCount: uint64,
}
impl Default for SnapshotData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Relation = *mut RelationData;
pub type RelationPtr = *mut Relation;
pub mod IndexAttrBitmapKind {
    pub type Type = ::core::ffi::c_uint;
    pub const INDEX_ATTR_BITMAP_ALL: Type = 0;
    pub const INDEX_ATTR_BITMAP_KEY: Type = 1;
    pub const INDEX_ATTR_BITMAP_PRIMARY_KEY: Type = 2;
    pub const INDEX_ATTR_BITMAP_IDENTITY_KEY: Type = 3;
}
pub type SortSupport = *mut SortSupportData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SortSupportData {
    pub ssup_cxt: MemoryContext,
    pub ssup_collation: Oid,
    pub ssup_reverse: bool,
    pub ssup_nulls_first: bool,
    pub ssup_attno: AttrNumber,
    pub ssup_extra: *mut ::core::ffi::c_void,
    pub comparator: ::core::option::Option<
        unsafe extern "C-unwind" fn(x: Datum, y: Datum, ssup: SortSupport) -> ::core::ffi::c_int,
    >,
    pub abbreviate: bool,
    pub abbrev_converter: ::core::option::Option<
        unsafe extern "C-unwind" fn(original: Datum, ssup: SortSupport) -> Datum,
    >,
    pub abbrev_abort: ::core::option::Option<
        unsafe extern "C-unwind" fn(memtupcount: ::core::ffi::c_int, ssup: SortSupport) -> bool,
    >,
    pub abbrev_full_comparator: ::core::option::Option<
        unsafe extern "C-unwind" fn(x: Datum, y: Datum, ssup: SortSupport) -> ::core::ffi::c_int,
    >,
}
impl Default for SortSupportData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct IndexTupleData {
    pub t_tid: ItemPointerData,
    pub t_info: ::core::ffi::c_ushort,
}
pub type IndexTuple = *mut IndexTupleData;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct IndexAttributeBitMapData {
    pub bits: [bits8; 4usize],
}
pub type IndexAttributeBitMap = *mut IndexAttributeBitMapData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Tuplesortstate {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Sharedsort {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SortCoordinateData {
    pub isWorker: bool,
    pub nParticipants: ::core::ffi::c_int,
    pub sharedsort: *mut Sharedsort,
}
impl Default for SortCoordinateData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type SortCoordinate = *mut SortCoordinateData;
pub mod TuplesortMethod {
    pub type Type = ::core::ffi::c_uint;
    pub const SORT_TYPE_STILL_IN_PROGRESS: Type = 0;
    pub const SORT_TYPE_TOP_N_HEAPSORT: Type = 1;
    pub const SORT_TYPE_QUICKSORT: Type = 2;
    pub const SORT_TYPE_EXTERNAL_SORT: Type = 4;
    pub const SORT_TYPE_EXTERNAL_MERGE: Type = 8;
}
pub mod TuplesortSpaceType {
    pub type Type = ::core::ffi::c_uint;
    pub const SORT_SPACE_TYPE_DISK: Type = 0;
    pub const SORT_SPACE_TYPE_MEMORY: Type = 1;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TuplesortInstrumentation {
    pub sortMethod: TuplesortMethod::Type,
    pub spaceType: TuplesortSpaceType::Type,
    pub spaceUsed: int64,
}
impl Default for TuplesortInstrumentation {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Tuplestorestate {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ParallelHashJoinState {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CopyMultiInsertBuffer {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LogicalTapeSet {
    _unused: [u8; 0],
}
pub type ExprStateEvalFunc = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        expression: *mut ExprState,
        econtext: *mut ExprContext,
        isNull: *mut bool,
    ) -> Datum,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExprState {
    pub type_: NodeTag,
    pub flags: uint8,
    pub resnull: bool,
    pub resvalue: Datum,
    pub resultslot: *mut TupleTableSlot,
    pub steps: *mut ExprEvalStep,
    pub evalfunc: ExprStateEvalFunc,
    pub expr: *mut Expr,
    pub evalfunc_private: *mut ::core::ffi::c_void,
    pub steps_len: ::core::ffi::c_int,
    pub steps_alloc: ::core::ffi::c_int,
    pub parent: *mut PlanState,
    pub ext_params: ParamListInfo,
    pub innermost_caseval: *mut Datum,
    pub innermost_casenull: *mut bool,
    pub innermost_domainval: *mut Datum,
    pub innermost_domainnull: *mut bool,
}
impl Default for ExprState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexInfo {
    pub type_: NodeTag,
    pub ii_NumIndexAttrs: ::core::ffi::c_int,
    pub ii_NumIndexKeyAttrs: ::core::ffi::c_int,
    pub ii_IndexAttrNumbers: [AttrNumber; 32usize],
    pub ii_Expressions: *mut List,
    pub ii_ExpressionsState: *mut List,
    pub ii_Predicate: *mut List,
    pub ii_PredicateState: *mut ExprState,
    pub ii_ExclusionOps: *mut Oid,
    pub ii_ExclusionProcs: *mut Oid,
    pub ii_ExclusionStrats: *mut uint16,
    pub ii_UniqueOps: *mut Oid,
    pub ii_UniqueProcs: *mut Oid,
    pub ii_UniqueStrats: *mut uint16,
    pub ii_OpclassOptions: *mut Datum,
    pub ii_Unique: bool,
    pub ii_NullsNotDistinct: bool,
    pub ii_ReadyForInserts: bool,
    pub ii_CheckedUnchanged: bool,
    pub ii_IndexUnchanged: bool,
    pub ii_Concurrent: bool,
    pub ii_BrokenHotChain: bool,
    pub ii_ParallelWorkers: ::core::ffi::c_int,
    pub ii_Am: Oid,
    pub ii_AmCache: *mut ::core::ffi::c_void,
    pub ii_Context: MemoryContext,
}
impl Default for IndexInfo {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type ExprContextCallbackFunction =
    ::core::option::Option<unsafe extern "C-unwind" fn(arg: Datum)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExprContext_CB {
    pub next: *mut ExprContext_CB,
    pub function: ExprContextCallbackFunction,
    pub arg: Datum,
}
impl Default for ExprContext_CB {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExprContext {
    pub type_: NodeTag,
    pub ecxt_scantuple: *mut TupleTableSlot,
    pub ecxt_innertuple: *mut TupleTableSlot,
    pub ecxt_outertuple: *mut TupleTableSlot,
    pub ecxt_per_query_memory: MemoryContext,
    pub ecxt_per_tuple_memory: MemoryContext,
    pub ecxt_param_exec_vals: *mut ParamExecData,
    pub ecxt_param_list_info: ParamListInfo,
    pub ecxt_aggvalues: *mut Datum,
    pub ecxt_aggnulls: *mut bool,
    pub caseValue_datum: Datum,
    pub caseValue_isNull: bool,
    pub domainValue_datum: Datum,
    pub domainValue_isNull: bool,
    pub ecxt_estate: *mut EState,
    pub ecxt_callbacks: *mut ExprContext_CB,
}
impl Default for ExprContext {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod ExprDoneCond {
    pub type Type = ::core::ffi::c_uint;
    pub const ExprSingleResult: Type = 0;
    pub const ExprMultipleResult: Type = 1;
    pub const ExprEndResult: Type = 2;
}
pub mod SetFunctionReturnMode {
    pub type Type = ::core::ffi::c_uint;
    pub const SFRM_ValuePerCall: Type = 1;
    pub const SFRM_Materialize: Type = 2;
    pub const SFRM_Materialize_Random: Type = 4;
    pub const SFRM_Materialize_Preferred: Type = 8;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ReturnSetInfo {
    pub type_: NodeTag,
    pub econtext: *mut ExprContext,
    pub expectedDesc: TupleDesc,
    pub allowedModes: ::core::ffi::c_int,
    pub returnMode: SetFunctionReturnMode::Type,
    pub isDone: ExprDoneCond::Type,
    pub setResult: *mut Tuplestorestate,
    pub setDesc: TupleDesc,
}
impl Default for ReturnSetInfo {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ProjectionInfo {
    pub type_: NodeTag,
    pub pi_state: ExprState,
    pub pi_exprContext: *mut ExprContext,
}
impl Default for ProjectionInfo {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct JunkFilter {
    pub type_: NodeTag,
    pub jf_targetList: *mut List,
    pub jf_cleanTupType: TupleDesc,
    pub jf_cleanMap: *mut AttrNumber,
    pub jf_resultSlot: *mut TupleTableSlot,
}
impl Default for JunkFilter {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OnConflictSetState {
    pub type_: NodeTag,
    pub oc_Existing: *mut TupleTableSlot,
    pub oc_ProjSlot: *mut TupleTableSlot,
    pub oc_ProjInfo: *mut ProjectionInfo,
    pub oc_WhereClause: *mut ExprState,
}
impl Default for OnConflictSetState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MergeActionState {
    pub type_: NodeTag,
    pub mas_action: *mut MergeAction,
    pub mas_proj: *mut ProjectionInfo,
    pub mas_whenqual: *mut ExprState,
}
impl Default for MergeActionState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ResultRelInfo {
    pub type_: NodeTag,
    pub ri_RangeTableIndex: Index,
    pub ri_RelationDesc: Relation,
    pub ri_NumIndices: ::core::ffi::c_int,
    pub ri_IndexRelationDescs: RelationPtr,
    pub ri_IndexRelationInfo: *mut *mut IndexInfo,
    pub ri_RowIdAttNo: AttrNumber,
    pub ri_projectNew: *mut ProjectionInfo,
    pub ri_newTupleSlot: *mut TupleTableSlot,
    pub ri_oldTupleSlot: *mut TupleTableSlot,
    pub ri_projectNewInfoValid: bool,
    pub ri_needLockTagTuple: bool,
    pub ri_TrigDesc: *mut TriggerDesc,
    pub ri_TrigFunctions: *mut FmgrInfo,
    pub ri_TrigWhenExprs: *mut *mut ExprState,
    pub ri_TrigInstrument: *mut Instrumentation,
    pub ri_ReturningSlot: *mut TupleTableSlot,
    pub ri_TrigOldSlot: *mut TupleTableSlot,
    pub ri_TrigNewSlot: *mut TupleTableSlot,
    pub ri_FdwRoutine: *mut FdwRoutine,
    pub ri_FdwState: *mut ::core::ffi::c_void,
    pub ri_usesFdwDirectModify: bool,
    pub ri_NumSlots: ::core::ffi::c_int,
    pub ri_NumSlotsInitialized: ::core::ffi::c_int,
    pub ri_BatchSize: ::core::ffi::c_int,
    pub ri_Slots: *mut *mut TupleTableSlot,
    pub ri_PlanSlots: *mut *mut TupleTableSlot,
    pub ri_WithCheckOptions: *mut List,
    pub ri_WithCheckOptionExprs: *mut List,
    pub ri_ConstraintExprs: *mut *mut ExprState,
    pub ri_GeneratedExprs: *mut *mut ExprState,
    pub ri_NumGeneratedNeeded: ::core::ffi::c_int,
    pub ri_returningList: *mut List,
    pub ri_projectReturning: *mut ProjectionInfo,
    pub ri_onConflictArbiterIndexes: *mut List,
    pub ri_onConflict: *mut OnConflictSetState,
    pub ri_matchedMergeAction: *mut List,
    pub ri_notMatchedMergeAction: *mut List,
    pub ri_PartitionCheckExpr: *mut ExprState,
    pub ri_RootResultRelInfo: *mut ResultRelInfo,
    pub ri_RootToPartitionMap: *mut TupleConversionMap,
    pub ri_PartitionTupleSlot: *mut TupleTableSlot,
    pub ri_ChildToRootMap: *mut TupleConversionMap,
    pub ri_ChildToRootMapValid: bool,
    pub ri_CopyMultiInsertBuffer: *mut CopyMultiInsertBuffer,
    pub ri_ancestorResultRels: *mut List,
}
impl Default for ResultRelInfo {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ResultRelInfoExtra {
    pub rinfo: *mut ResultRelInfo,
    pub ri_extraUpdatedCols: *mut Bitmapset,
}
impl Default for ResultRelInfoExtra {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AsyncRequest {
    pub requestor: *mut PlanState,
    pub requestee: *mut PlanState,
    pub request_index: ::core::ffi::c_int,
    pub callback_pending: bool,
    pub request_complete: bool,
    pub result: *mut TupleTableSlot,
}
impl Default for AsyncRequest {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct EState {
    pub type_: NodeTag,
    pub es_direction: ScanDirection::Type,
    pub es_snapshot: Snapshot,
    pub es_crosscheck_snapshot: Snapshot,
    pub es_range_table: *mut List,
    pub es_range_table_size: Index,
    pub es_relations: *mut Relation,
    pub es_rowmarks: *mut *mut ExecRowMark,
    pub es_plannedstmt: *mut PlannedStmt,
    pub es_sourceText: *const ::core::ffi::c_char,
    pub es_junkFilter: *mut JunkFilter,
    pub es_output_cid: CommandId,
    pub es_result_relations: *mut *mut ResultRelInfo,
    pub es_opened_result_relations: *mut List,
    pub es_partition_directory: PartitionDirectory,
    pub es_tuple_routing_result_relations: *mut List,
    pub es_trig_target_relations: *mut List,
    pub es_param_list_info: ParamListInfo,
    pub es_param_exec_vals: *mut ParamExecData,
    pub es_queryEnv: *mut QueryEnvironment,
    pub es_query_cxt: MemoryContext,
    pub es_tupleTable: *mut List,
    pub es_processed: uint64,
    pub es_top_eflags: ::core::ffi::c_int,
    pub es_instrument: ::core::ffi::c_int,
    pub es_finished: bool,
    pub es_exprcontexts: *mut List,
    pub es_subplanstates: *mut List,
    pub es_auxmodifytables: *mut List,
    pub es_per_tuple_exprcontext: *mut ExprContext,
    pub es_epq_active: *mut EPQState,
    pub es_use_parallel_mode: bool,
    pub es_query_dsa: *mut dsa_area,
    pub es_jit_flags: ::core::ffi::c_int,
    pub es_jit: *mut JitContext,
    pub es_jit_worker_instr: *mut JitInstrumentation,
    pub es_insert_pending_result_relations: *mut List,
    pub es_insert_pending_modifytables: *mut List,
    pub es_resultrelinfo_extra: *mut List,
}
impl Default for EState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExecRowMark {
    pub relation: Relation,
    pub relid: Oid,
    pub rti: Index,
    pub prti: Index,
    pub rowmarkId: Index,
    pub markType: RowMarkType::Type,
    pub strength: LockClauseStrength::Type,
    pub waitPolicy: LockWaitPolicy::Type,
    pub ermActive: bool,
    pub curCtid: ItemPointerData,
    pub ermExtra: *mut ::core::ffi::c_void,
}
impl Default for ExecRowMark {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExecAuxRowMark {
    pub rowmark: *mut ExecRowMark,
    pub ctidAttNo: AttrNumber,
    pub toidAttNo: AttrNumber,
    pub wholeAttNo: AttrNumber,
}
impl Default for ExecAuxRowMark {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type TupleHashEntry = *mut TupleHashEntryData;
pub type TupleHashTable = *mut TupleHashTableData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TupleHashEntryData {
    pub firstTuple: MinimalTuple,
    pub additional: *mut ::core::ffi::c_void,
    pub status: uint32,
    pub hash: uint32,
}
impl Default for TupleHashEntryData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tuplehash_hash {
    pub size: uint64,
    pub members: uint32,
    pub sizemask: uint32,
    pub grow_threshold: uint32,
    pub data: *mut TupleHashEntryData,
    pub ctx: MemoryContext,
    pub private_data: *mut ::core::ffi::c_void,
}
impl Default for tuplehash_hash {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod tuplehash_status {
    pub type Type = ::core::ffi::c_uint;
    pub const tuplehash_SH_EMPTY: Type = 0;
    pub const tuplehash_SH_IN_USE: Type = 1;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct tuplehash_iterator {
    pub cur: uint32,
    pub end: uint32,
    pub done: bool,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TupleHashTableData {
    pub hashtab: *mut tuplehash_hash,
    pub numCols: ::core::ffi::c_int,
    pub keyColIdx: *mut AttrNumber,
    pub tab_hash_funcs: *mut FmgrInfo,
    pub tab_eq_func: *mut ExprState,
    pub tab_collations: *mut Oid,
    pub tablecxt: MemoryContext,
    pub tempcxt: MemoryContext,
    pub entrysize: Size,
    pub tableslot: *mut TupleTableSlot,
    pub inputslot: *mut TupleTableSlot,
    pub in_hash_funcs: *mut FmgrInfo,
    pub cur_eq_func: *mut ExprState,
    pub hash_iv: uint32,
    pub exprcontext: *mut ExprContext,
}
impl Default for TupleHashTableData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type TupleHashIterator = tuplehash_iterator;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WindowFuncExprState {
    pub type_: NodeTag,
    pub wfunc: *mut WindowFunc,
    pub args: *mut List,
    pub aggfilter: *mut ExprState,
    pub wfuncno: ::core::ffi::c_int,
}
impl Default for WindowFuncExprState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SetExprState {
    pub type_: NodeTag,
    pub expr: *mut Expr,
    pub args: *mut List,
    pub elidedFuncState: *mut ExprState,
    pub func: FmgrInfo,
    pub funcResultStore: *mut Tuplestorestate,
    pub funcResultSlot: *mut TupleTableSlot,
    pub funcResultDesc: TupleDesc,
    pub funcReturnsTuple: bool,
    pub funcReturnsSet: bool,
    pub setArgsValid: bool,
    pub shutdown_reg: bool,
    pub fcinfo: FunctionCallInfo,
}
impl Default for SetExprState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SubPlanState {
    pub type_: NodeTag,
    pub subplan: *mut SubPlan,
    pub planstate: *mut PlanState,
    pub parent: *mut PlanState,
    pub testexpr: *mut ExprState,
    pub args: *mut List,
    pub curTuple: HeapTuple,
    pub curArray: Datum,
    pub descRight: TupleDesc,
    pub projLeft: *mut ProjectionInfo,
    pub projRight: *mut ProjectionInfo,
    pub hashtable: TupleHashTable,
    pub hashnulls: TupleHashTable,
    pub havehashrows: bool,
    pub havenullrows: bool,
    pub hashtablecxt: MemoryContext,
    pub hashtempcxt: MemoryContext,
    pub innerecontext: *mut ExprContext,
    pub numCols: ::core::ffi::c_int,
    pub keyColIdx: *mut AttrNumber,
    pub tab_eq_funcoids: *mut Oid,
    pub tab_collations: *mut Oid,
    pub tab_hash_funcs: *mut FmgrInfo,
    pub tab_eq_funcs: *mut FmgrInfo,
    pub lhs_hash_funcs: *mut FmgrInfo,
    pub cur_eq_funcs: *mut FmgrInfo,
    pub cur_eq_comp: *mut ExprState,
}
impl Default for SubPlanState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod DomainConstraintType {
    pub type Type = ::core::ffi::c_uint;
    pub const DOM_CONSTRAINT_NOTNULL: Type = 0;
    pub const DOM_CONSTRAINT_CHECK: Type = 1;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DomainConstraintState {
    pub type_: NodeTag,
    pub constrainttype: DomainConstraintType::Type,
    pub name: *mut ::core::ffi::c_char,
    pub check_expr: *mut Expr,
    pub check_exprstate: *mut ExprState,
}
impl Default for DomainConstraintState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type ExecProcNodeMtd = ::core::option::Option<
    unsafe extern "C-unwind" fn(pstate: *mut PlanState) -> *mut TupleTableSlot,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PlanState {
    pub type_: NodeTag,
    pub plan: *mut Plan,
    pub state: *mut EState,
    pub ExecProcNode: ExecProcNodeMtd,
    pub ExecProcNodeReal: ExecProcNodeMtd,
    pub instrument: *mut Instrumentation,
    pub worker_instrument: *mut WorkerInstrumentation,
    pub worker_jit_instrument: *mut SharedJitInstrumentation,
    pub qual: *mut ExprState,
    pub lefttree: *mut PlanState,
    pub righttree: *mut PlanState,
    pub initPlan: *mut List,
    pub subPlan: *mut List,
    pub chgParam: *mut Bitmapset,
    pub ps_ResultTupleDesc: TupleDesc,
    pub ps_ResultTupleSlot: *mut TupleTableSlot,
    pub ps_ExprContext: *mut ExprContext,
    pub ps_ProjInfo: *mut ProjectionInfo,
    pub async_capable: bool,
    pub scandesc: TupleDesc,
    pub scanops: *const TupleTableSlotOps,
    pub outerops: *const TupleTableSlotOps,
    pub innerops: *const TupleTableSlotOps,
    pub resultops: *const TupleTableSlotOps,
    pub scanopsfixed: bool,
    pub outeropsfixed: bool,
    pub inneropsfixed: bool,
    pub resultopsfixed: bool,
    pub scanopsset: bool,
    pub outeropsset: bool,
    pub inneropsset: bool,
    pub resultopsset: bool,
}
impl Default for PlanState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct EPQState {
    pub parentestate: *mut EState,
    pub epqParam: ::core::ffi::c_int,
    pub epqExtra: *mut EPQStateExtra,
    pub relsubs_slot: *mut *mut TupleTableSlot,
    pub plan: *mut Plan,
    pub arowMarks: *mut List,
    pub origslot: *mut TupleTableSlot,
    pub recheckestate: *mut EState,
    pub relsubs_rowmark: *mut *mut ExecAuxRowMark,
    pub relsubs_done: *mut bool,
    pub recheckplanstate: *mut PlanState,
}
impl Default for EPQState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct EPQStateExtra {
    pub resultRelations: *mut List,
    pub tuple_table: *mut List,
    pub relsubs_blocked: *mut bool,
}
impl Default for EPQStateExtra {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ResultState {
    pub ps: PlanState,
    pub resconstantqual: *mut ExprState,
    pub rs_done: bool,
    pub rs_checkqual: bool,
}
impl Default for ResultState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ProjectSetState {
    pub ps: PlanState,
    pub elems: *mut *mut Node,
    pub elemdone: *mut ExprDoneCond::Type,
    pub nelems: ::core::ffi::c_int,
    pub pending_srf_tuples: bool,
    pub argcontext: MemoryContext,
}
impl Default for ProjectSetState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ModifyTableState {
    pub ps: PlanState,
    pub operation: CmdType::Type,
    pub canSetTag: bool,
    pub mt_done: bool,
    pub mt_nrels: ::core::ffi::c_int,
    pub resultRelInfo: *mut ResultRelInfo,
    pub rootResultRelInfo: *mut ResultRelInfo,
    pub mt_epqstate: EPQState,
    pub fireBSTriggers: bool,
    pub mt_resultOidAttno: ::core::ffi::c_int,
    pub mt_lastResultOid: Oid,
    pub mt_lastResultIndex: ::core::ffi::c_int,
    pub mt_resultOidHash: *mut HTAB,
    pub mt_root_tuple_slot: *mut TupleTableSlot,
    pub mt_partition_tuple_routing: *mut PartitionTupleRouting,
    pub mt_transition_capture: *mut TransitionCaptureState,
    pub mt_oc_transition_capture: *mut TransitionCaptureState,
    pub mt_merge_subcommands: ::core::ffi::c_int,
    pub mt_merge_inserted: f64,
    pub mt_merge_updated: f64,
    pub mt_merge_deleted: f64,
}
impl Default for ModifyTableState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ParallelAppendState {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionPruneState {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AppendState {
    pub ps: PlanState,
    pub appendplans: *mut *mut PlanState,
    pub as_nplans: ::core::ffi::c_int,
    pub as_whichplan: ::core::ffi::c_int,
    pub as_begun: bool,
    pub as_asyncplans: *mut Bitmapset,
    pub as_nasyncplans: ::core::ffi::c_int,
    pub as_asyncrequests: *mut *mut AsyncRequest,
    pub as_asyncresults: *mut *mut TupleTableSlot,
    pub as_nasyncresults: ::core::ffi::c_int,
    pub as_syncdone: bool,
    pub as_nasyncremain: ::core::ffi::c_int,
    pub as_needrequest: *mut Bitmapset,
    pub as_eventset: *mut WaitEventSet,
    pub as_first_partial_plan: ::core::ffi::c_int,
    pub as_pstate: *mut ParallelAppendState,
    pub pstate_len: Size,
    pub as_prune_state: *mut PartitionPruneState,
    pub as_valid_subplans: *mut Bitmapset,
    pub as_valid_asyncplans: *mut Bitmapset,
    pub choose_next_subplan:
        ::core::option::Option<unsafe extern "C-unwind" fn(arg1: *mut AppendState) -> bool>,
}
impl Default for AppendState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MergeAppendState {
    pub ps: PlanState,
    pub mergeplans: *mut *mut PlanState,
    pub ms_nplans: ::core::ffi::c_int,
    pub ms_nkeys: ::core::ffi::c_int,
    pub ms_sortkeys: SortSupport,
    pub ms_slots: *mut *mut TupleTableSlot,
    pub ms_heap: *mut binaryheap,
    pub ms_initialized: bool,
    pub ms_prune_state: *mut PartitionPruneState,
    pub ms_valid_subplans: *mut Bitmapset,
}
impl Default for MergeAppendState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RecursiveUnionState {
    pub ps: PlanState,
    pub recursing: bool,
    pub intermediate_empty: bool,
    pub working_table: *mut Tuplestorestate,
    pub intermediate_table: *mut Tuplestorestate,
    pub eqfuncoids: *mut Oid,
    pub hashfunctions: *mut FmgrInfo,
    pub tempContext: MemoryContext,
    pub hashtable: TupleHashTable,
    pub tableContext: MemoryContext,
}
impl Default for RecursiveUnionState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BitmapAndState {
    pub ps: PlanState,
    pub bitmapplans: *mut *mut PlanState,
    pub nplans: ::core::ffi::c_int,
}
impl Default for BitmapAndState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BitmapOrState {
    pub ps: PlanState,
    pub bitmapplans: *mut *mut PlanState,
    pub nplans: ::core::ffi::c_int,
}
impl Default for BitmapOrState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ScanState {
    pub ps: PlanState,
    pub ss_currentRelation: Relation,
    pub ss_currentScanDesc: *mut TableScanDescData,
    pub ss_ScanTupleSlot: *mut TupleTableSlot,
}
impl Default for ScanState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SeqScanState {
    pub ss: ScanState,
    pub pscan_len: Size,
}
impl Default for SeqScanState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SampleScanState {
    pub ss: ScanState,
    pub args: *mut List,
    pub repeatable: *mut ExprState,
    pub tsmroutine: *mut TsmRoutine,
    pub tsm_state: *mut ::core::ffi::c_void,
    pub use_bulkread: bool,
    pub use_pagemode: bool,
    pub begun: bool,
    pub seed: uint32,
    pub donetuples: int64,
    pub haveblock: bool,
    pub done: bool,
}
impl Default for SampleScanState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexRuntimeKeyInfo {
    pub scan_key: *mut ScanKeyData,
    pub key_expr: *mut ExprState,
    pub key_toastable: bool,
}
impl Default for IndexRuntimeKeyInfo {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexArrayKeyInfo {
    pub scan_key: *mut ScanKeyData,
    pub array_expr: *mut ExprState,
    pub next_elem: ::core::ffi::c_int,
    pub num_elems: ::core::ffi::c_int,
    pub elem_values: *mut Datum,
    pub elem_nulls: *mut bool,
}
impl Default for IndexArrayKeyInfo {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexScanState {
    pub ss: ScanState,
    pub indexqualorig: *mut ExprState,
    pub indexorderbyorig: *mut List,
    pub iss_ScanKeys: *mut ScanKeyData,
    pub iss_NumScanKeys: ::core::ffi::c_int,
    pub iss_OrderByKeys: *mut ScanKeyData,
    pub iss_NumOrderByKeys: ::core::ffi::c_int,
    pub iss_RuntimeKeys: *mut IndexRuntimeKeyInfo,
    pub iss_NumRuntimeKeys: ::core::ffi::c_int,
    pub iss_RuntimeKeysReady: bool,
    pub iss_RuntimeContext: *mut ExprContext,
    pub iss_RelationDesc: Relation,
    pub iss_ScanDesc: *mut IndexScanDescData,
    pub iss_ReorderQueue: *mut pairingheap,
    pub iss_ReachedEnd: bool,
    pub iss_OrderByValues: *mut Datum,
    pub iss_OrderByNulls: *mut bool,
    pub iss_SortSupport: SortSupport,
    pub iss_OrderByTypByVals: *mut bool,
    pub iss_OrderByTypLens: *mut int16,
    pub iss_PscanLen: Size,
}
impl Default for IndexScanState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexOnlyScanState {
    pub ss: ScanState,
    pub recheckqual: *mut ExprState,
    pub ioss_ScanKeys: *mut ScanKeyData,
    pub ioss_NumScanKeys: ::core::ffi::c_int,
    pub ioss_OrderByKeys: *mut ScanKeyData,
    pub ioss_NumOrderByKeys: ::core::ffi::c_int,
    pub ioss_RuntimeKeys: *mut IndexRuntimeKeyInfo,
    pub ioss_NumRuntimeKeys: ::core::ffi::c_int,
    pub ioss_RuntimeKeysReady: bool,
    pub ioss_RuntimeContext: *mut ExprContext,
    pub ioss_RelationDesc: Relation,
    pub ioss_ScanDesc: *mut IndexScanDescData,
    pub ioss_TableSlot: *mut TupleTableSlot,
    pub ioss_VMBuffer: Buffer,
    pub ioss_PscanLen: Size,
    pub ioss_NameCStringAttNums: *mut AttrNumber,
    pub ioss_NameCStringCount: ::core::ffi::c_int,
}
impl Default for IndexOnlyScanState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BitmapIndexScanState {
    pub ss: ScanState,
    pub biss_result: *mut TIDBitmap,
    pub biss_ScanKeys: *mut ScanKeyData,
    pub biss_NumScanKeys: ::core::ffi::c_int,
    pub biss_RuntimeKeys: *mut IndexRuntimeKeyInfo,
    pub biss_NumRuntimeKeys: ::core::ffi::c_int,
    pub biss_ArrayKeys: *mut IndexArrayKeyInfo,
    pub biss_NumArrayKeys: ::core::ffi::c_int,
    pub biss_RuntimeKeysReady: bool,
    pub biss_RuntimeContext: *mut ExprContext,
    pub biss_RelationDesc: Relation,
    pub biss_ScanDesc: *mut IndexScanDescData,
}
impl Default for BitmapIndexScanState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod SharedBitmapState {
    pub type Type = ::core::ffi::c_uint;
    pub const BM_INITIAL: Type = 0;
    pub const BM_INPROGRESS: Type = 1;
    pub const BM_FINISHED: Type = 2;
}
#[repr(C)]
#[derive(Debug)]
pub struct ParallelBitmapHeapState {
    pub tbmiterator: dsa_pointer,
    pub prefetch_iterator: dsa_pointer,
    pub mutex: slock_t,
    pub prefetch_pages: ::core::ffi::c_int,
    pub prefetch_target: ::core::ffi::c_int,
    pub state: SharedBitmapState::Type,
    pub cv: ConditionVariable,
    pub phs_snapshot_data: __IncompleteArrayField<::core::ffi::c_char>,
}
impl Default for ParallelBitmapHeapState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BitmapHeapScanState {
    pub ss: ScanState,
    pub bitmapqualorig: *mut ExprState,
    pub tbm: *mut TIDBitmap,
    pub tbmiterator: *mut TBMIterator,
    pub tbmres: *mut TBMIterateResult,
    pub can_skip_fetch: bool,
    pub return_empty_tuples: ::core::ffi::c_int,
    pub vmbuffer: Buffer,
    pub pvmbuffer: Buffer,
    pub exact_pages: ::core::ffi::c_long,
    pub lossy_pages: ::core::ffi::c_long,
    pub prefetch_iterator: *mut TBMIterator,
    pub prefetch_pages: ::core::ffi::c_int,
    pub prefetch_target: ::core::ffi::c_int,
    pub prefetch_maximum: ::core::ffi::c_int,
    pub pscan_len: Size,
    pub initialized: bool,
    pub shared_tbmiterator: *mut TBMSharedIterator,
    pub shared_prefetch_iterator: *mut TBMSharedIterator,
    pub pstate: *mut ParallelBitmapHeapState,
}
impl Default for BitmapHeapScanState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TidScanState {
    pub ss: ScanState,
    pub tss_tidexprs: *mut List,
    pub tss_isCurrentOf: bool,
    pub tss_NumTids: ::core::ffi::c_int,
    pub tss_TidPtr: ::core::ffi::c_int,
    pub tss_TidList: *mut ItemPointerData,
    pub tss_htup: HeapTupleData,
}
impl Default for TidScanState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TidRangeScanState {
    pub ss: ScanState,
    pub trss_tidexprs: *mut List,
    pub trss_mintid: ItemPointerData,
    pub trss_maxtid: ItemPointerData,
    pub trss_inScan: bool,
}
impl Default for TidRangeScanState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SubqueryScanState {
    pub ss: ScanState,
    pub subplan: *mut PlanState,
}
impl Default for SubqueryScanState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FunctionScanPerFuncState {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FunctionScanState {
    pub ss: ScanState,
    pub eflags: ::core::ffi::c_int,
    pub ordinality: bool,
    pub simple: bool,
    pub ordinal: int64,
    pub nfuncs: ::core::ffi::c_int,
    pub funcstates: *mut FunctionScanPerFuncState,
    pub argcontext: MemoryContext,
}
impl Default for FunctionScanState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ValuesScanState {
    pub ss: ScanState,
    pub rowcontext: *mut ExprContext,
    pub exprlists: *mut *mut List,
    pub exprstatelists: *mut *mut List,
    pub array_len: ::core::ffi::c_int,
    pub curr_idx: ::core::ffi::c_int,
}
impl Default for ValuesScanState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TableFuncScanState {
    pub ss: ScanState,
    pub docexpr: *mut ExprState,
    pub rowexpr: *mut ExprState,
    pub colexprs: *mut List,
    pub coldefexprs: *mut List,
    pub ns_names: *mut List,
    pub ns_uris: *mut List,
    pub notnulls: *mut Bitmapset,
    pub opaque: *mut ::core::ffi::c_void,
    pub routine: *mut TableFuncRoutine,
    pub in_functions: *mut FmgrInfo,
    pub typioparams: *mut Oid,
    pub ordinal: int64,
    pub perTableCxt: MemoryContext,
    pub tupstore: *mut Tuplestorestate,
}
impl Default for TableFuncScanState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CteScanState {
    pub ss: ScanState,
    pub eflags: ::core::ffi::c_int,
    pub readptr: ::core::ffi::c_int,
    pub cteplanstate: *mut PlanState,
    pub leader: *mut CteScanState,
    pub cte_table: *mut Tuplestorestate,
    pub eof_cte: bool,
}
impl Default for CteScanState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NamedTuplestoreScanState {
    pub ss: ScanState,
    pub readptr: ::core::ffi::c_int,
    pub tupdesc: TupleDesc,
    pub relation: *mut Tuplestorestate,
}
impl Default for NamedTuplestoreScanState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WorkTableScanState {
    pub ss: ScanState,
    pub rustate: *mut RecursiveUnionState,
}
impl Default for WorkTableScanState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ForeignScanState {
    pub ss: ScanState,
    pub fdw_recheck_quals: *mut ExprState,
    pub pscan_len: Size,
    pub resultRelInfo: *mut ResultRelInfo,
    pub fdwroutine: *mut FdwRoutine,
    pub fdw_state: *mut ::core::ffi::c_void,
}
impl Default for ForeignScanState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CustomScanState {
    pub ss: ScanState,
    pub flags: uint32,
    pub custom_ps: *mut List,
    pub pscan_len: Size,
    pub methods: *const CustomExecMethods,
}
impl Default for CustomScanState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct JoinState {
    pub ps: PlanState,
    pub jointype: JoinType::Type,
    pub single_match: bool,
    pub joinqual: *mut ExprState,
}
impl Default for JoinState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NestLoopState {
    pub js: JoinState,
    pub nl_NeedNewOuter: bool,
    pub nl_MatchedOuter: bool,
    pub nl_NullInnerTupleSlot: *mut TupleTableSlot,
}
impl Default for NestLoopState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MergeJoinClauseData {
    _unused: [u8; 0],
}
pub type MergeJoinClause = *mut MergeJoinClauseData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MergeJoinState {
    pub js: JoinState,
    pub mj_NumClauses: ::core::ffi::c_int,
    pub mj_Clauses: MergeJoinClause,
    pub mj_JoinState: ::core::ffi::c_int,
    pub mj_SkipMarkRestore: bool,
    pub mj_ExtraMarks: bool,
    pub mj_ConstFalseJoin: bool,
    pub mj_FillOuter: bool,
    pub mj_FillInner: bool,
    pub mj_MatchedOuter: bool,
    pub mj_MatchedInner: bool,
    pub mj_OuterTupleSlot: *mut TupleTableSlot,
    pub mj_InnerTupleSlot: *mut TupleTableSlot,
    pub mj_MarkedTupleSlot: *mut TupleTableSlot,
    pub mj_NullOuterTupleSlot: *mut TupleTableSlot,
    pub mj_NullInnerTupleSlot: *mut TupleTableSlot,
    pub mj_OuterEContext: *mut ExprContext,
    pub mj_InnerEContext: *mut ExprContext,
}
impl Default for MergeJoinState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HashJoinTupleData {
    _unused: [u8; 0],
}
pub type HashJoinTuple = *mut HashJoinTupleData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HashJoinTableData {
    _unused: [u8; 0],
}
pub type HashJoinTable = *mut HashJoinTableData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HashJoinState {
    pub js: JoinState,
    pub hashclauses: *mut ExprState,
    pub hj_OuterHashKeys: *mut List,
    pub hj_HashOperators: *mut List,
    pub hj_Collations: *mut List,
    pub hj_HashTable: HashJoinTable,
    pub hj_CurHashValue: uint32,
    pub hj_CurBucketNo: ::core::ffi::c_int,
    pub hj_CurSkewBucketNo: ::core::ffi::c_int,
    pub hj_CurTuple: HashJoinTuple,
    pub hj_OuterTupleSlot: *mut TupleTableSlot,
    pub hj_HashTupleSlot: *mut TupleTableSlot,
    pub hj_NullOuterTupleSlot: *mut TupleTableSlot,
    pub hj_NullInnerTupleSlot: *mut TupleTableSlot,
    pub hj_FirstOuterTupleSlot: *mut TupleTableSlot,
    pub hj_JoinState: ::core::ffi::c_int,
    pub hj_MatchedOuter: bool,
    pub hj_OuterNotEmpty: bool,
}
impl Default for HashJoinState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MaterialState {
    pub ss: ScanState,
    pub eflags: ::core::ffi::c_int,
    pub eof_underlying: bool,
    pub tuplestorestate: *mut Tuplestorestate,
}
impl Default for MaterialState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MemoizeEntry {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MemoizeTuple {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MemoizeKey {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct MemoizeInstrumentation {
    pub cache_hits: uint64,
    pub cache_misses: uint64,
    pub cache_evictions: uint64,
    pub cache_overflows: uint64,
    pub mem_peak: uint64,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct SharedMemoizeInfo {
    pub num_workers: ::core::ffi::c_int,
    pub sinstrument: __IncompleteArrayField<MemoizeInstrumentation>,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MemoizeState {
    pub ss: ScanState,
    pub mstatus: ::core::ffi::c_int,
    pub nkeys: ::core::ffi::c_int,
    pub hashtable: *mut memoize_hash,
    pub hashkeydesc: TupleDesc,
    pub tableslot: *mut TupleTableSlot,
    pub probeslot: *mut TupleTableSlot,
    pub cache_eq_expr: *mut ExprState,
    pub param_exprs: *mut *mut ExprState,
    pub hashfunctions: *mut FmgrInfo,
    pub collations: *mut Oid,
    pub mem_used: uint64,
    pub mem_limit: uint64,
    pub tableContext: MemoryContext,
    pub lru_list: dlist_head,
    pub last_tuple: *mut MemoizeTuple,
    pub entry: *mut MemoizeEntry,
    pub singlerow: bool,
    pub binary_mode: bool,
    pub stats: MemoizeInstrumentation,
    pub shared_info: *mut SharedMemoizeInfo,
    pub keyparamids: *mut Bitmapset,
}
impl Default for MemoizeState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PresortedKeyData {
    pub flinfo: FmgrInfo,
    pub fcinfo: FunctionCallInfo,
    pub attno: OffsetNumber,
}
impl Default for PresortedKeyData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct SharedSortInfo {
    pub num_workers: ::core::ffi::c_int,
    pub sinstrument: __IncompleteArrayField<TuplesortInstrumentation>,
}
impl Default for SharedSortInfo {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SortState {
    pub ss: ScanState,
    pub randomAccess: bool,
    pub bounded: bool,
    pub bound: int64,
    pub sort_Done: bool,
    pub bounded_Done: bool,
    pub bound_Done: int64,
    pub tuplesortstate: *mut ::core::ffi::c_void,
    pub am_worker: bool,
    pub datumSort: bool,
    pub shared_info: *mut SharedSortInfo,
}
impl Default for SortState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct IncrementalSortGroupInfo {
    pub groupCount: int64,
    pub maxDiskSpaceUsed: int64,
    pub totalDiskSpaceUsed: int64,
    pub maxMemorySpaceUsed: int64,
    pub totalMemorySpaceUsed: int64,
    pub sortMethods: bits32,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct IncrementalSortInfo {
    pub fullsortGroupInfo: IncrementalSortGroupInfo,
    pub prefixsortGroupInfo: IncrementalSortGroupInfo,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct SharedIncrementalSortInfo {
    pub num_workers: ::core::ffi::c_int,
    pub sinfo: __IncompleteArrayField<IncrementalSortInfo>,
}
pub mod IncrementalSortExecutionStatus {
    pub type Type = ::core::ffi::c_uint;
    pub const INCSORT_LOADFULLSORT: Type = 0;
    pub const INCSORT_LOADPREFIXSORT: Type = 1;
    pub const INCSORT_READFULLSORT: Type = 2;
    pub const INCSORT_READPREFIXSORT: Type = 3;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IncrementalSortState {
    pub ss: ScanState,
    pub bounded: bool,
    pub bound: int64,
    pub outerNodeDone: bool,
    pub bound_Done: int64,
    pub execution_status: IncrementalSortExecutionStatus::Type,
    pub n_fullsort_remaining: int64,
    pub fullsort_state: *mut Tuplesortstate,
    pub prefixsort_state: *mut Tuplesortstate,
    pub presorted_keys: *mut PresortedKeyData,
    pub incsort_info: IncrementalSortInfo,
    pub group_pivot: *mut TupleTableSlot,
    pub transfer_tuple: *mut TupleTableSlot,
    pub am_worker: bool,
    pub shared_info: *mut SharedIncrementalSortInfo,
}
impl Default for IncrementalSortState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GroupState {
    pub ss: ScanState,
    pub eqfunction: *mut ExprState,
    pub grp_done: bool,
}
impl Default for GroupState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct AggregateInstrumentation {
    pub hash_mem_peak: Size,
    pub hash_disk_used: uint64,
    pub hash_batches_used: ::core::ffi::c_int,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct SharedAggInfo {
    pub num_workers: ::core::ffi::c_int,
    pub sinstrument: __IncompleteArrayField<AggregateInstrumentation>,
}
pub type AggStatePerAgg = *mut AggStatePerAggData;
pub type AggStatePerTrans = *mut AggStatePerTransData;
pub type AggStatePerGroup = *mut AggStatePerGroupData;
pub type AggStatePerPhase = *mut AggStatePerPhaseData;
pub type AggStatePerHash = *mut AggStatePerHashData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AggState {
    pub ss: ScanState,
    pub aggs: *mut List,
    pub numaggs: ::core::ffi::c_int,
    pub numtrans: ::core::ffi::c_int,
    pub aggstrategy: AggStrategy::Type,
    pub aggsplit: AggSplit::Type,
    pub phase: AggStatePerPhase,
    pub numphases: ::core::ffi::c_int,
    pub current_phase: ::core::ffi::c_int,
    pub peragg: AggStatePerAgg,
    pub pertrans: AggStatePerTrans,
    pub hashcontext: *mut ExprContext,
    pub aggcontexts: *mut *mut ExprContext,
    pub tmpcontext: *mut ExprContext,
    pub curaggcontext: *mut ExprContext,
    pub curperagg: AggStatePerAgg,
    pub curpertrans: AggStatePerTrans,
    pub input_done: bool,
    pub agg_done: bool,
    pub projected_set: ::core::ffi::c_int,
    pub current_set: ::core::ffi::c_int,
    pub grouped_cols: *mut Bitmapset,
    pub all_grouped_cols: *mut List,
    pub colnos_needed: *mut Bitmapset,
    pub max_colno_needed: ::core::ffi::c_int,
    pub all_cols_needed: bool,
    pub maxsets: ::core::ffi::c_int,
    pub phases: AggStatePerPhase,
    pub sort_in: *mut Tuplesortstate,
    pub sort_out: *mut Tuplesortstate,
    pub sort_slot: *mut TupleTableSlot,
    pub pergroups: *mut AggStatePerGroup,
    pub grp_firstTuple: HeapTuple,
    pub table_filled: bool,
    pub num_hashes: ::core::ffi::c_int,
    pub hash_metacxt: MemoryContext,
    pub hash_tapeset: *mut LogicalTapeSet,
    pub hash_spills: *mut HashAggSpill,
    pub hash_spill_rslot: *mut TupleTableSlot,
    pub hash_spill_wslot: *mut TupleTableSlot,
    pub hash_batches: *mut List,
    pub hash_ever_spilled: bool,
    pub hash_spill_mode: bool,
    pub hash_mem_limit: Size,
    pub hash_ngroups_limit: uint64,
    pub hash_planned_partitions: ::core::ffi::c_int,
    pub hashentrysize: f64,
    pub hash_mem_peak: Size,
    pub hash_ngroups_current: uint64,
    pub hash_disk_used: uint64,
    pub hash_batches_used: ::core::ffi::c_int,
    pub perhash: AggStatePerHash,
    pub hash_pergroup: *mut AggStatePerGroup,
    pub all_pergroups: *mut AggStatePerGroup,
    pub combinedproj: *mut ProjectionInfo,
    pub shared_info: *mut SharedAggInfo,
}
impl Default for AggState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WindowStatePerFuncData {
    _unused: [u8; 0],
}
pub type WindowStatePerFunc = *mut WindowStatePerFuncData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WindowStatePerAggData {
    _unused: [u8; 0],
}
pub type WindowStatePerAgg = *mut WindowStatePerAggData;
pub mod WindowAggStatus {
    pub type Type = ::core::ffi::c_uint;
    pub const WINDOWAGG_DONE: Type = 0;
    pub const WINDOWAGG_RUN: Type = 1;
    pub const WINDOWAGG_PASSTHROUGH: Type = 2;
    pub const WINDOWAGG_PASSTHROUGH_STRICT: Type = 3;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WindowAggState {
    pub ss: ScanState,
    pub funcs: *mut List,
    pub numfuncs: ::core::ffi::c_int,
    pub numaggs: ::core::ffi::c_int,
    pub perfunc: WindowStatePerFunc,
    pub peragg: WindowStatePerAgg,
    pub partEqfunction: *mut ExprState,
    pub ordEqfunction: *mut ExprState,
    pub buffer: *mut Tuplestorestate,
    pub current_ptr: ::core::ffi::c_int,
    pub framehead_ptr: ::core::ffi::c_int,
    pub frametail_ptr: ::core::ffi::c_int,
    pub grouptail_ptr: ::core::ffi::c_int,
    pub spooled_rows: int64,
    pub currentpos: int64,
    pub frameheadpos: int64,
    pub frametailpos: int64,
    pub agg_winobj: *mut WindowObjectData,
    pub aggregatedbase: int64,
    pub aggregatedupto: int64,
    pub status: WindowAggStatus::Type,
    pub frameOptions: ::core::ffi::c_int,
    pub startOffset: *mut ExprState,
    pub endOffset: *mut ExprState,
    pub startOffsetValue: Datum,
    pub endOffsetValue: Datum,
    pub startInRangeFunc: FmgrInfo,
    pub endInRangeFunc: FmgrInfo,
    pub inRangeColl: Oid,
    pub inRangeAsc: bool,
    pub inRangeNullsFirst: bool,
    pub currentgroup: int64,
    pub frameheadgroup: int64,
    pub frametailgroup: int64,
    pub groupheadpos: int64,
    pub grouptailpos: int64,
    pub partcontext: MemoryContext,
    pub aggcontext: MemoryContext,
    pub curaggcontext: MemoryContext,
    pub tmpcontext: *mut ExprContext,
    pub runcondition: *mut ExprState,
    pub use_pass_through: bool,
    pub top_window: bool,
    pub all_first: bool,
    pub partition_spooled: bool,
    pub more_partitions: bool,
    pub framehead_valid: bool,
    pub frametail_valid: bool,
    pub grouptail_valid: bool,
    pub first_part_slot: *mut TupleTableSlot,
    pub framehead_slot: *mut TupleTableSlot,
    pub frametail_slot: *mut TupleTableSlot,
    pub agg_row_slot: *mut TupleTableSlot,
    pub temp_slot_1: *mut TupleTableSlot,
    pub temp_slot_2: *mut TupleTableSlot,
}
impl Default for WindowAggState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct UniqueState {
    pub ps: PlanState,
    pub eqfunction: *mut ExprState,
}
impl Default for UniqueState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GatherState {
    pub ps: PlanState,
    pub initialized: bool,
    pub need_to_scan_locally: bool,
    pub tuples_needed: int64,
    pub funnel_slot: *mut TupleTableSlot,
    pub pei: *mut ParallelExecutorInfo,
    pub nworkers_launched: ::core::ffi::c_int,
    pub nreaders: ::core::ffi::c_int,
    pub nextreader: ::core::ffi::c_int,
    pub reader: *mut *mut TupleQueueReader,
}
impl Default for GatherState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GMReaderTupleBuffer {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GatherMergeState {
    pub ps: PlanState,
    pub initialized: bool,
    pub gm_initialized: bool,
    pub need_to_scan_locally: bool,
    pub tuples_needed: int64,
    pub tupDesc: TupleDesc,
    pub gm_nkeys: ::core::ffi::c_int,
    pub gm_sortkeys: SortSupport,
    pub pei: *mut ParallelExecutorInfo,
    pub nworkers_launched: ::core::ffi::c_int,
    pub nreaders: ::core::ffi::c_int,
    pub gm_slots: *mut *mut TupleTableSlot,
    pub reader: *mut *mut TupleQueueReader,
    pub gm_tuple_buffers: *mut GMReaderTupleBuffer,
    pub gm_heap: *mut binaryheap,
}
impl Default for GatherMergeState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct HashInstrumentation {
    pub nbuckets: ::core::ffi::c_int,
    pub nbuckets_original: ::core::ffi::c_int,
    pub nbatch: ::core::ffi::c_int,
    pub nbatch_original: ::core::ffi::c_int,
    pub space_peak: Size,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct SharedHashInfo {
    pub num_workers: ::core::ffi::c_int,
    pub hinstrument: __IncompleteArrayField<HashInstrumentation>,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HashState {
    pub ps: PlanState,
    pub hashtable: HashJoinTable,
    pub hashkeys: *mut List,
    pub shared_info: *mut SharedHashInfo,
    pub hinstrument: *mut HashInstrumentation,
    pub parallel_state: *mut ParallelHashJoinState,
}
impl Default for HashState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SetOpStatePerGroupData {
    _unused: [u8; 0],
}
pub type SetOpStatePerGroup = *mut SetOpStatePerGroupData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SetOpState {
    pub ps: PlanState,
    pub eqfunction: *mut ExprState,
    pub eqfuncoids: *mut Oid,
    pub hashfunctions: *mut FmgrInfo,
    pub setop_done: bool,
    pub numOutput: ::core::ffi::c_long,
    pub pergroup: SetOpStatePerGroup,
    pub grp_firstTuple: HeapTuple,
    pub hashtable: TupleHashTable,
    pub tableContext: MemoryContext,
    pub table_filled: bool,
    pub hashiter: TupleHashIterator,
}
impl Default for SetOpState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LockRowsState {
    pub ps: PlanState,
    pub lr_arowMarks: *mut List,
    pub lr_epqstate: EPQState,
}
impl Default for LockRowsState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod LimitStateCond {
    pub type Type = ::core::ffi::c_uint;
    pub const LIMIT_INITIAL: Type = 0;
    pub const LIMIT_RESCAN: Type = 1;
    pub const LIMIT_EMPTY: Type = 2;
    pub const LIMIT_INWINDOW: Type = 3;
    pub const LIMIT_WINDOWEND_TIES: Type = 4;
    pub const LIMIT_SUBPLANEOF: Type = 5;
    pub const LIMIT_WINDOWEND: Type = 6;
    pub const LIMIT_WINDOWSTART: Type = 7;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LimitState {
    pub ps: PlanState,
    pub limitOffset: *mut ExprState,
    pub limitCount: *mut ExprState,
    pub limitOption: LimitOption::Type,
    pub offset: int64,
    pub count: int64,
    pub noCount: bool,
    pub lstate: LimitStateCond::Type,
    pub position: int64,
    pub subSlot: *mut TupleTableSlot,
    pub eqfunction: *mut ExprState,
    pub last_slot: *mut TupleTableSlot,
}
impl Default for LimitState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod CommandTag {
    pub type Type = ::core::ffi::c_uint;
    pub const CMDTAG_UNKNOWN: Type = 0;
    pub const CMDTAG_ALTER_ACCESS_METHOD: Type = 1;
    pub const CMDTAG_ALTER_AGGREGATE: Type = 2;
    pub const CMDTAG_ALTER_CAST: Type = 3;
    pub const CMDTAG_ALTER_COLLATION: Type = 4;
    pub const CMDTAG_ALTER_CONSTRAINT: Type = 5;
    pub const CMDTAG_ALTER_CONVERSION: Type = 6;
    pub const CMDTAG_ALTER_DATABASE: Type = 7;
    pub const CMDTAG_ALTER_DEFAULT_PRIVILEGES: Type = 8;
    pub const CMDTAG_ALTER_DOMAIN: Type = 9;
    pub const CMDTAG_ALTER_EVENT_TRIGGER: Type = 10;
    pub const CMDTAG_ALTER_EXTENSION: Type = 11;
    pub const CMDTAG_ALTER_FOREIGN_DATA_WRAPPER: Type = 12;
    pub const CMDTAG_ALTER_FOREIGN_TABLE: Type = 13;
    pub const CMDTAG_ALTER_FUNCTION: Type = 14;
    pub const CMDTAG_ALTER_INDEX: Type = 15;
    pub const CMDTAG_ALTER_LANGUAGE: Type = 16;
    pub const CMDTAG_ALTER_LARGE_OBJECT: Type = 17;
    pub const CMDTAG_ALTER_MATERIALIZED_VIEW: Type = 18;
    pub const CMDTAG_ALTER_OPERATOR: Type = 19;
    pub const CMDTAG_ALTER_OPERATOR_CLASS: Type = 20;
    pub const CMDTAG_ALTER_OPERATOR_FAMILY: Type = 21;
    pub const CMDTAG_ALTER_POLICY: Type = 22;
    pub const CMDTAG_ALTER_PROCEDURE: Type = 23;
    pub const CMDTAG_ALTER_PUBLICATION: Type = 24;
    pub const CMDTAG_ALTER_ROLE: Type = 25;
    pub const CMDTAG_ALTER_ROUTINE: Type = 26;
    pub const CMDTAG_ALTER_RULE: Type = 27;
    pub const CMDTAG_ALTER_SCHEMA: Type = 28;
    pub const CMDTAG_ALTER_SEQUENCE: Type = 29;
    pub const CMDTAG_ALTER_SERVER: Type = 30;
    pub const CMDTAG_ALTER_STATISTICS: Type = 31;
    pub const CMDTAG_ALTER_SUBSCRIPTION: Type = 32;
    pub const CMDTAG_ALTER_SYSTEM: Type = 33;
    pub const CMDTAG_ALTER_TABLE: Type = 34;
    pub const CMDTAG_ALTER_TABLESPACE: Type = 35;
    pub const CMDTAG_ALTER_TEXT_SEARCH_CONFIGURATION: Type = 36;
    pub const CMDTAG_ALTER_TEXT_SEARCH_DICTIONARY: Type = 37;
    pub const CMDTAG_ALTER_TEXT_SEARCH_PARSER: Type = 38;
    pub const CMDTAG_ALTER_TEXT_SEARCH_TEMPLATE: Type = 39;
    pub const CMDTAG_ALTER_TRANSFORM: Type = 40;
    pub const CMDTAG_ALTER_TRIGGER: Type = 41;
    pub const CMDTAG_ALTER_TYPE: Type = 42;
    pub const CMDTAG_ALTER_USER_MAPPING: Type = 43;
    pub const CMDTAG_ALTER_VIEW: Type = 44;
    pub const CMDTAG_ANALYZE: Type = 45;
    pub const CMDTAG_BEGIN: Type = 46;
    pub const CMDTAG_CALL: Type = 47;
    pub const CMDTAG_CHECKPOINT: Type = 48;
    pub const CMDTAG_CLOSE: Type = 49;
    pub const CMDTAG_CLOSE_CURSOR: Type = 50;
    pub const CMDTAG_CLOSE_CURSOR_ALL: Type = 51;
    pub const CMDTAG_CLUSTER: Type = 52;
    pub const CMDTAG_COMMENT: Type = 53;
    pub const CMDTAG_COMMIT: Type = 54;
    pub const CMDTAG_COMMIT_PREPARED: Type = 55;
    pub const CMDTAG_COPY: Type = 56;
    pub const CMDTAG_COPY_FROM: Type = 57;
    pub const CMDTAG_CREATE_ACCESS_METHOD: Type = 58;
    pub const CMDTAG_CREATE_AGGREGATE: Type = 59;
    pub const CMDTAG_CREATE_CAST: Type = 60;
    pub const CMDTAG_CREATE_COLLATION: Type = 61;
    pub const CMDTAG_CREATE_CONSTRAINT: Type = 62;
    pub const CMDTAG_CREATE_CONVERSION: Type = 63;
    pub const CMDTAG_CREATE_DATABASE: Type = 64;
    pub const CMDTAG_CREATE_DOMAIN: Type = 65;
    pub const CMDTAG_CREATE_EVENT_TRIGGER: Type = 66;
    pub const CMDTAG_CREATE_EXTENSION: Type = 67;
    pub const CMDTAG_CREATE_FOREIGN_DATA_WRAPPER: Type = 68;
    pub const CMDTAG_CREATE_FOREIGN_TABLE: Type = 69;
    pub const CMDTAG_CREATE_FUNCTION: Type = 70;
    pub const CMDTAG_CREATE_INDEX: Type = 71;
    pub const CMDTAG_CREATE_LANGUAGE: Type = 72;
    pub const CMDTAG_CREATE_MATERIALIZED_VIEW: Type = 73;
    pub const CMDTAG_CREATE_OPERATOR: Type = 74;
    pub const CMDTAG_CREATE_OPERATOR_CLASS: Type = 75;
    pub const CMDTAG_CREATE_OPERATOR_FAMILY: Type = 76;
    pub const CMDTAG_CREATE_POLICY: Type = 77;
    pub const CMDTAG_CREATE_PROCEDURE: Type = 78;
    pub const CMDTAG_CREATE_PUBLICATION: Type = 79;
    pub const CMDTAG_CREATE_ROLE: Type = 80;
    pub const CMDTAG_CREATE_ROUTINE: Type = 81;
    pub const CMDTAG_CREATE_RULE: Type = 82;
    pub const CMDTAG_CREATE_SCHEMA: Type = 83;
    pub const CMDTAG_CREATE_SEQUENCE: Type = 84;
    pub const CMDTAG_CREATE_SERVER: Type = 85;
    pub const CMDTAG_CREATE_STATISTICS: Type = 86;
    pub const CMDTAG_CREATE_SUBSCRIPTION: Type = 87;
    pub const CMDTAG_CREATE_TABLE: Type = 88;
    pub const CMDTAG_CREATE_TABLE_AS: Type = 89;
    pub const CMDTAG_CREATE_TABLESPACE: Type = 90;
    pub const CMDTAG_CREATE_TEXT_SEARCH_CONFIGURATION: Type = 91;
    pub const CMDTAG_CREATE_TEXT_SEARCH_DICTIONARY: Type = 92;
    pub const CMDTAG_CREATE_TEXT_SEARCH_PARSER: Type = 93;
    pub const CMDTAG_CREATE_TEXT_SEARCH_TEMPLATE: Type = 94;
    pub const CMDTAG_CREATE_TRANSFORM: Type = 95;
    pub const CMDTAG_CREATE_TRIGGER: Type = 96;
    pub const CMDTAG_CREATE_TYPE: Type = 97;
    pub const CMDTAG_CREATE_USER_MAPPING: Type = 98;
    pub const CMDTAG_CREATE_VIEW: Type = 99;
    pub const CMDTAG_DEALLOCATE: Type = 100;
    pub const CMDTAG_DEALLOCATE_ALL: Type = 101;
    pub const CMDTAG_DECLARE_CURSOR: Type = 102;
    pub const CMDTAG_DELETE: Type = 103;
    pub const CMDTAG_DISCARD: Type = 104;
    pub const CMDTAG_DISCARD_ALL: Type = 105;
    pub const CMDTAG_DISCARD_PLANS: Type = 106;
    pub const CMDTAG_DISCARD_SEQUENCES: Type = 107;
    pub const CMDTAG_DISCARD_TEMP: Type = 108;
    pub const CMDTAG_DO: Type = 109;
    pub const CMDTAG_DROP_ACCESS_METHOD: Type = 110;
    pub const CMDTAG_DROP_AGGREGATE: Type = 111;
    pub const CMDTAG_DROP_CAST: Type = 112;
    pub const CMDTAG_DROP_COLLATION: Type = 113;
    pub const CMDTAG_DROP_CONSTRAINT: Type = 114;
    pub const CMDTAG_DROP_CONVERSION: Type = 115;
    pub const CMDTAG_DROP_DATABASE: Type = 116;
    pub const CMDTAG_DROP_DOMAIN: Type = 117;
    pub const CMDTAG_DROP_EVENT_TRIGGER: Type = 118;
    pub const CMDTAG_DROP_EXTENSION: Type = 119;
    pub const CMDTAG_DROP_FOREIGN_DATA_WRAPPER: Type = 120;
    pub const CMDTAG_DROP_FOREIGN_TABLE: Type = 121;
    pub const CMDTAG_DROP_FUNCTION: Type = 122;
    pub const CMDTAG_DROP_INDEX: Type = 123;
    pub const CMDTAG_DROP_LANGUAGE: Type = 124;
    pub const CMDTAG_DROP_MATERIALIZED_VIEW: Type = 125;
    pub const CMDTAG_DROP_OPERATOR: Type = 126;
    pub const CMDTAG_DROP_OPERATOR_CLASS: Type = 127;
    pub const CMDTAG_DROP_OPERATOR_FAMILY: Type = 128;
    pub const CMDTAG_DROP_OWNED: Type = 129;
    pub const CMDTAG_DROP_POLICY: Type = 130;
    pub const CMDTAG_DROP_PROCEDURE: Type = 131;
    pub const CMDTAG_DROP_PUBLICATION: Type = 132;
    pub const CMDTAG_DROP_ROLE: Type = 133;
    pub const CMDTAG_DROP_ROUTINE: Type = 134;
    pub const CMDTAG_DROP_RULE: Type = 135;
    pub const CMDTAG_DROP_SCHEMA: Type = 136;
    pub const CMDTAG_DROP_SEQUENCE: Type = 137;
    pub const CMDTAG_DROP_SERVER: Type = 138;
    pub const CMDTAG_DROP_STATISTICS: Type = 139;
    pub const CMDTAG_DROP_SUBSCRIPTION: Type = 140;
    pub const CMDTAG_DROP_TABLE: Type = 141;
    pub const CMDTAG_DROP_TABLESPACE: Type = 142;
    pub const CMDTAG_DROP_TEXT_SEARCH_CONFIGURATION: Type = 143;
    pub const CMDTAG_DROP_TEXT_SEARCH_DICTIONARY: Type = 144;
    pub const CMDTAG_DROP_TEXT_SEARCH_PARSER: Type = 145;
    pub const CMDTAG_DROP_TEXT_SEARCH_TEMPLATE: Type = 146;
    pub const CMDTAG_DROP_TRANSFORM: Type = 147;
    pub const CMDTAG_DROP_TRIGGER: Type = 148;
    pub const CMDTAG_DROP_TYPE: Type = 149;
    pub const CMDTAG_DROP_USER_MAPPING: Type = 150;
    pub const CMDTAG_DROP_VIEW: Type = 151;
    pub const CMDTAG_EXECUTE: Type = 152;
    pub const CMDTAG_EXPLAIN: Type = 153;
    pub const CMDTAG_FETCH: Type = 154;
    pub const CMDTAG_GRANT: Type = 155;
    pub const CMDTAG_GRANT_ROLE: Type = 156;
    pub const CMDTAG_IMPORT_FOREIGN_SCHEMA: Type = 157;
    pub const CMDTAG_INSERT: Type = 158;
    pub const CMDTAG_LISTEN: Type = 159;
    pub const CMDTAG_LOAD: Type = 160;
    pub const CMDTAG_LOCK_TABLE: Type = 161;
    pub const CMDTAG_MERGE: Type = 162;
    pub const CMDTAG_MOVE: Type = 163;
    pub const CMDTAG_NOTIFY: Type = 164;
    pub const CMDTAG_PREPARE: Type = 165;
    pub const CMDTAG_PREPARE_TRANSACTION: Type = 166;
    pub const CMDTAG_REASSIGN_OWNED: Type = 167;
    pub const CMDTAG_REFRESH_MATERIALIZED_VIEW: Type = 168;
    pub const CMDTAG_REINDEX: Type = 169;
    pub const CMDTAG_RELEASE: Type = 170;
    pub const CMDTAG_RESET: Type = 171;
    pub const CMDTAG_REVOKE: Type = 172;
    pub const CMDTAG_REVOKE_ROLE: Type = 173;
    pub const CMDTAG_ROLLBACK: Type = 174;
    pub const CMDTAG_ROLLBACK_PREPARED: Type = 175;
    pub const CMDTAG_SAVEPOINT: Type = 176;
    pub const CMDTAG_SECURITY_LABEL: Type = 177;
    pub const CMDTAG_SELECT: Type = 178;
    pub const CMDTAG_SELECT_FOR_KEY_SHARE: Type = 179;
    pub const CMDTAG_SELECT_FOR_NO_KEY_UPDATE: Type = 180;
    pub const CMDTAG_SELECT_FOR_SHARE: Type = 181;
    pub const CMDTAG_SELECT_FOR_UPDATE: Type = 182;
    pub const CMDTAG_SELECT_INTO: Type = 183;
    pub const CMDTAG_SET: Type = 184;
    pub const CMDTAG_SET_CONSTRAINTS: Type = 185;
    pub const CMDTAG_SHOW: Type = 186;
    pub const CMDTAG_START_TRANSACTION: Type = 187;
    pub const CMDTAG_TRUNCATE_TABLE: Type = 188;
    pub const CMDTAG_UNLISTEN: Type = 189;
    pub const CMDTAG_UPDATE: Type = 190;
    pub const CMDTAG_VACUUM: Type = 191;
    pub const COMMAND_TAG_NEXTTAG: Type = 192;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct QueryCompletion {
    pub commandTag: CommandTag::Type,
    pub nprocessed: uint64,
}
impl Default for QueryCompletion {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod CommandDest {
    pub type Type = ::core::ffi::c_uint;
    pub const DestNone: Type = 0;
    pub const DestDebug: Type = 1;
    pub const DestRemote: Type = 2;
    pub const DestRemoteExecute: Type = 3;
    pub const DestRemoteSimple: Type = 4;
    pub const DestSPI: Type = 5;
    pub const DestTuplestore: Type = 6;
    pub const DestIntoRel: Type = 7;
    pub const DestCopyOut: Type = 8;
    pub const DestSQLFunction: Type = 9;
    pub const DestTransientRel: Type = 10;
    pub const DestTupleQueue: Type = 11;
}
pub type DestReceiver = _DestReceiver;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _DestReceiver {
    pub receiveSlot: ::core::option::Option<
        unsafe extern "C-unwind" fn(slot: *mut TupleTableSlot, self_: *mut DestReceiver) -> bool,
    >,
    pub rStartup: ::core::option::Option<
        unsafe extern "C-unwind" fn(
            self_: *mut DestReceiver,
            operation: ::core::ffi::c_int,
            typeinfo: TupleDesc,
        ),
    >,
    pub rShutdown: ::core::option::Option<unsafe extern "C-unwind" fn(self_: *mut DestReceiver)>,
    pub rDestroy: ::core::option::Option<unsafe extern "C-unwind" fn(self_: *mut DestReceiver)>,
    pub mydest: CommandDest::Type,
}
impl Default for _DestReceiver {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct QueryDesc {
    pub operation: CmdType::Type,
    pub plannedstmt: *mut PlannedStmt,
    pub sourceText: *const ::core::ffi::c_char,
    pub snapshot: Snapshot,
    pub crosscheck_snapshot: Snapshot,
    pub dest: *mut DestReceiver,
    pub params: ParamListInfo,
    pub queryEnv: *mut QueryEnvironment,
    pub instrument_options: ::core::ffi::c_int,
    pub tupDesc: TupleDesc,
    pub estate: *mut EState,
    pub planstate: *mut PlanState,
    pub already_executed: bool,
    pub totaltime: *mut Instrumentation,
}
impl Default for QueryDesc {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct MemoryContextCounters {
    pub nblocks: Size,
    pub freechunks: Size,
    pub totalspace: Size,
    pub freespace: Size,
}
pub type MemoryStatsPrintFunc = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        context: MemoryContext,
        passthru: *mut ::core::ffi::c_void,
        stats_string: *const ::core::ffi::c_char,
        print_to_stderr: bool,
    ),
>;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct MemoryContextMethods {
    pub alloc: ::core::option::Option<
        unsafe extern "C-unwind" fn(context: MemoryContext, size: Size) -> *mut ::core::ffi::c_void,
    >,
    pub free_p: ::core::option::Option<
        unsafe extern "C-unwind" fn(context: MemoryContext, pointer: *mut ::core::ffi::c_void),
    >,
    pub realloc: ::core::option::Option<
        unsafe extern "C-unwind" fn(
            context: MemoryContext,
            pointer: *mut ::core::ffi::c_void,
            size: Size,
        ) -> *mut ::core::ffi::c_void,
    >,
    pub reset: ::core::option::Option<unsafe extern "C-unwind" fn(context: MemoryContext)>,
    pub delete_context: ::core::option::Option<unsafe extern "C-unwind" fn(context: MemoryContext)>,
    pub get_chunk_space: ::core::option::Option<
        unsafe extern "C-unwind" fn(
            context: MemoryContext,
            pointer: *mut ::core::ffi::c_void,
        ) -> Size,
    >,
    pub is_empty:
        ::core::option::Option<unsafe extern "C-unwind" fn(context: MemoryContext) -> bool>,
    pub stats: ::core::option::Option<
        unsafe extern "C-unwind" fn(
            context: MemoryContext,
            printfunc: MemoryStatsPrintFunc,
            passthru: *mut ::core::ffi::c_void,
            totals: *mut MemoryContextCounters,
            print_to_stderr: bool,
        ),
    >,
    pub check: ::core::option::Option<unsafe extern "C-unwind" fn(context: MemoryContext)>,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MemoryContextData {
    pub type_: NodeTag,
    pub isReset: bool,
    pub allowInCritSection: bool,
    pub mem_allocated: Size,
    pub methods: *const MemoryContextMethods,
    pub parent: MemoryContext,
    pub firstchild: MemoryContext,
    pub prevchild: MemoryContext,
    pub nextchild: MemoryContext,
    pub name: *const ::core::ffi::c_char,
    pub ident: *const ::core::ffi::c_char,
    pub reset_cbs: *mut MemoryContextCallback,
}
impl Default for MemoryContextData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type ExecutorStart_hook_type = ::core::option::Option<
    unsafe extern "C-unwind" fn(queryDesc: *mut QueryDesc, eflags: ::core::ffi::c_int),
>;
pub type ExecutorRun_hook_type = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        queryDesc: *mut QueryDesc,
        direction: ScanDirection::Type,
        count: uint64,
        execute_once: bool,
    ),
>;
pub type ExecutorFinish_hook_type =
    ::core::option::Option<unsafe extern "C-unwind" fn(queryDesc: *mut QueryDesc)>;
pub type ExecutorEnd_hook_type =
    ::core::option::Option<unsafe extern "C-unwind" fn(queryDesc: *mut QueryDesc)>;
pub type ExecutorCheckPerms_hook_type =
    ::core::option::Option<unsafe extern "C-unwind" fn(arg1: *mut List, arg2: bool) -> bool>;
pub type ExecScanAccessMtd = ::core::option::Option<
    unsafe extern "C-unwind" fn(node: *mut ScanState) -> *mut TupleTableSlot,
>;
pub type ExecScanRecheckMtd = ::core::option::Option<
    unsafe extern "C-unwind" fn(node: *mut ScanState, slot: *mut TupleTableSlot) -> bool,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TupOutputState {
    pub slot: *mut TupleTableSlot,
    pub dest: *mut DestReceiver,
}
impl Default for TupOutputState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AttInMetadata {
    pub tupdesc: TupleDesc,
    pub attinfuncs: *mut FmgrInfo,
    pub attioparams: *mut Oid,
    pub atttypmods: *mut int32,
}
impl Default for AttInMetadata {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FuncCallContext {
    pub call_cntr: uint64,
    pub max_calls: uint64,
    pub user_fctx: *mut ::core::ffi::c_void,
    pub attinmeta: *mut AttInMetadata,
    pub multi_call_memory_ctx: MemoryContext,
    pub tuple_desc: TupleDesc,
}
impl Default for FuncCallContext {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod TypeFuncClass {
    pub type Type = ::core::ffi::c_uint;
    pub const TYPEFUNC_SCALAR: Type = 0;
    pub const TYPEFUNC_COMPOSITE: Type = 1;
    pub const TYPEFUNC_COMPOSITE_DOMAIN: Type = 2;
    pub const TYPEFUNC_RECORD: Type = 3;
    pub const TYPEFUNC_OTHER: Type = 4;
}
pub type sig_atomic_t = __sig_atomic_t;
pub mod _bindgen_ty_13 {
    pub type Type = ::core::ffi::c_uint;
    pub const SIGEV_SIGNAL: Type = 0;
    pub const SIGEV_NONE: Type = 1;
    pub const SIGEV_THREAD: Type = 2;
    pub const SIGEV_THREAD_ID: Type = 4;
}
pub type socklen_t = __socklen_t;
pub type pg_time_t = int64;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pg_tm {
    pub tm_sec: ::core::ffi::c_int,
    pub tm_min: ::core::ffi::c_int,
    pub tm_hour: ::core::ffi::c_int,
    pub tm_mday: ::core::ffi::c_int,
    pub tm_mon: ::core::ffi::c_int,
    pub tm_year: ::core::ffi::c_int,
    pub tm_wday: ::core::ffi::c_int,
    pub tm_yday: ::core::ffi::c_int,
    pub tm_isdst: ::core::ffi::c_int,
    pub tm_gmtoff: ::core::ffi::c_long,
    pub tm_zone: *const ::core::ffi::c_char,
}
impl Default for pg_tm {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pg_tz {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pg_tzenum {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Port {
    _unused: [u8; 0],
}
pub type pg_stack_base_t = *mut ::core::ffi::c_char;
pub mod BackendType {
    pub type Type = ::core::ffi::c_uint;
    pub const B_INVALID: Type = 0;
    pub const B_AUTOVAC_LAUNCHER: Type = 1;
    pub const B_AUTOVAC_WORKER: Type = 2;
    pub const B_BACKEND: Type = 3;
    pub const B_BG_WORKER: Type = 4;
    pub const B_BG_WRITER: Type = 5;
    pub const B_CHECKPOINTER: Type = 6;
    pub const B_STARTUP: Type = 7;
    pub const B_WAL_RECEIVER: Type = 8;
    pub const B_WAL_SENDER: Type = 9;
    pub const B_WAL_WRITER: Type = 10;
    pub const B_ARCHIVER: Type = 11;
    pub const B_LOGGER: Type = 12;
}
pub mod ProcessingMode {
    #[doc = "\t  pmod.h --\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t *\n\t\t\tPOSTGRES processing mode definitions.                            *"]
    pub type Type = ::core::ffi::c_uint;
    pub const BootstrapProcessing: Type = 0;
    pub const InitProcessing: Type = 1;
    pub const NormalProcessing: Type = 2;
}
pub mod AuxProcType {
    pub type Type = ::core::ffi::c_int;
    pub const NotAnAuxProcess: Type = -1;
    pub const StartupProcess: Type = 0;
    pub const BgWriterProcess: Type = 1;
    pub const ArchiverProcess: Type = 2;
    pub const CheckpointerProcess: Type = 3;
    pub const WalWriterProcess: Type = 4;
    pub const WalReceiverProcess: Type = 5;
    pub const NUM_AUXPROCTYPES: Type = 6;
}
pub type shmem_request_hook_type = ::core::option::Option<unsafe extern "C-unwind" fn()>;
pub type ArchiveCheckConfiguredCB = ::core::option::Option<unsafe extern "C-unwind" fn() -> bool>;
pub type ArchiveFileCB = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        file: *const ::core::ffi::c_char,
        path: *const ::core::ffi::c_char,
    ) -> bool,
>;
pub type ArchiveShutdownCB = ::core::option::Option<unsafe extern "C-unwind" fn()>;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ArchiveModuleCallbacks {
    pub check_configured_cb: ArchiveCheckConfiguredCB,
    pub archive_file_cb: ArchiveFileCB,
    pub shutdown_cb: ArchiveShutdownCB,
}
pub type ArchiveModuleInit =
    ::core::option::Option<unsafe extern "C-unwind" fn(cb: *mut ArchiveModuleCallbacks)>;
pub mod ProgressCommandType {
    pub type Type = ::core::ffi::c_uint;
    pub const PROGRESS_COMMAND_INVALID: Type = 0;
    pub const PROGRESS_COMMAND_VACUUM: Type = 1;
    pub const PROGRESS_COMMAND_ANALYZE: Type = 2;
    pub const PROGRESS_COMMAND_CLUSTER: Type = 3;
    pub const PROGRESS_COMMAND_CREATE_INDEX: Type = 4;
    pub const PROGRESS_COMMAND_BASEBACKUP: Type = 5;
    pub const PROGRESS_COMMAND_COPY: Type = 6;
}
pub type sa_family_t = ::core::ffi::c_ushort;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sockaddr_storage {
    pub ss_family: sa_family_t,
    pub __ss_padding: [::core::ffi::c_char; 118usize],
    pub __ss_align: ::core::ffi::c_ulong,
}
impl Default for sockaddr_storage {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SockAddr {
    pub addr: sockaddr_storage,
    pub salen: socklen_t,
}
impl Default for SockAddr {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type ProtocolVersion = uint32;
pub type MsgType = ProtocolVersion;
pub type PacketLen = uint32;
pub type AuthRequest = uint32;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct CancelRequestPacket {
    pub cancelRequestCode: MsgType,
    pub backendPID: uint32,
    pub cancelAuthCode: uint32,
}
pub mod BackendState {
    pub type Type = ::core::ffi::c_uint;
    pub const STATE_UNDEFINED: Type = 0;
    pub const STATE_IDLE: Type = 1;
    pub const STATE_RUNNING: Type = 2;
    pub const STATE_IDLEINTRANSACTION: Type = 3;
    pub const STATE_FASTPATH: Type = 4;
    pub const STATE_IDLEINTRANSACTION_ABORTED: Type = 5;
    pub const STATE_DISABLED: Type = 6;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgBackendSSLStatus {
    pub ssl_bits: ::core::ffi::c_int,
    pub ssl_version: [::core::ffi::c_char; 64usize],
    pub ssl_cipher: [::core::ffi::c_char; 64usize],
    pub ssl_client_dn: [::core::ffi::c_char; 64usize],
    pub ssl_client_serial: [::core::ffi::c_char; 64usize],
    pub ssl_issuer_dn: [::core::ffi::c_char; 64usize],
}
impl Default for PgBackendSSLStatus {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgBackendGSSStatus {
    pub gss_princ: [::core::ffi::c_char; 64usize],
    pub gss_auth: bool,
    pub gss_enc: bool,
}
impl Default for PgBackendGSSStatus {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgBackendStatus {
    pub st_changecount: ::core::ffi::c_int,
    pub st_procpid: ::core::ffi::c_int,
    pub st_backendType: BackendType::Type,
    pub st_proc_start_timestamp: TimestampTz,
    pub st_xact_start_timestamp: TimestampTz,
    pub st_activity_start_timestamp: TimestampTz,
    pub st_state_start_timestamp: TimestampTz,
    pub st_databaseid: Oid,
    pub st_userid: Oid,
    pub st_clientaddr: SockAddr,
    pub st_clienthostname: *mut ::core::ffi::c_char,
    pub st_ssl: bool,
    pub st_sslstatus: *mut PgBackendSSLStatus,
    pub st_gss: bool,
    pub st_gssstatus: *mut PgBackendGSSStatus,
    pub st_state: BackendState::Type,
    pub st_appname: *mut ::core::ffi::c_char,
    pub st_activity_raw: *mut ::core::ffi::c_char,
    pub st_progress_command: ProgressCommandType::Type,
    pub st_progress_command_target: Oid,
    pub st_progress_param: [int64; 20usize],
    pub st_query_id: uint64,
}
impl Default for PgBackendStatus {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LocalPgBackendStatus {
    pub backendStatus: PgBackendStatus,
    pub backend_xid: TransactionId,
    pub backend_xmin: TransactionId,
}
impl Default for LocalPgBackendStatus {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod WaitEventActivity {
    pub type Type = ::core::ffi::c_uint;
    pub const WAIT_EVENT_ARCHIVER_MAIN: Type = 83886080;
    pub const WAIT_EVENT_AUTOVACUUM_MAIN: Type = 83886081;
    pub const WAIT_EVENT_BGWRITER_HIBERNATE: Type = 83886082;
    pub const WAIT_EVENT_BGWRITER_MAIN: Type = 83886083;
    pub const WAIT_EVENT_CHECKPOINTER_MAIN: Type = 83886084;
    pub const WAIT_EVENT_LOGICAL_APPLY_MAIN: Type = 83886085;
    pub const WAIT_EVENT_LOGICAL_LAUNCHER_MAIN: Type = 83886086;
    pub const WAIT_EVENT_RECOVERY_WAL_STREAM: Type = 83886087;
    pub const WAIT_EVENT_SYSLOGGER_MAIN: Type = 83886088;
    pub const WAIT_EVENT_WAL_RECEIVER_MAIN: Type = 83886089;
    pub const WAIT_EVENT_WAL_SENDER_MAIN: Type = 83886090;
    pub const WAIT_EVENT_WAL_WRITER_MAIN: Type = 83886091;
}
pub mod WaitEventClient {
    pub type Type = ::core::ffi::c_uint;
    pub const WAIT_EVENT_CLIENT_READ: Type = 100663296;
    pub const WAIT_EVENT_CLIENT_WRITE: Type = 100663297;
    pub const WAIT_EVENT_GSS_OPEN_SERVER: Type = 100663298;
    pub const WAIT_EVENT_LIBPQWALRECEIVER_CONNECT: Type = 100663299;
    pub const WAIT_EVENT_LIBPQWALRECEIVER_RECEIVE: Type = 100663300;
    pub const WAIT_EVENT_SSL_OPEN_SERVER: Type = 100663301;
    pub const WAIT_EVENT_WAL_SENDER_WAIT_WAL: Type = 100663302;
    pub const WAIT_EVENT_WAL_SENDER_WRITE_DATA: Type = 100663303;
}
pub mod WaitEventIPC {
    pub type Type = ::core::ffi::c_uint;
    pub const WAIT_EVENT_APPEND_READY: Type = 134217728;
    pub const WAIT_EVENT_ARCHIVE_CLEANUP_COMMAND: Type = 134217729;
    pub const WAIT_EVENT_ARCHIVE_COMMAND: Type = 134217730;
    pub const WAIT_EVENT_BACKEND_TERMINATION: Type = 134217731;
    pub const WAIT_EVENT_BACKUP_WAIT_WAL_ARCHIVE: Type = 134217732;
    pub const WAIT_EVENT_BGWORKER_SHUTDOWN: Type = 134217733;
    pub const WAIT_EVENT_BGWORKER_STARTUP: Type = 134217734;
    pub const WAIT_EVENT_BTREE_PAGE: Type = 134217735;
    pub const WAIT_EVENT_BUFFER_IO: Type = 134217736;
    pub const WAIT_EVENT_CHECKPOINT_DONE: Type = 134217737;
    pub const WAIT_EVENT_CHECKPOINT_START: Type = 134217738;
    pub const WAIT_EVENT_EXECUTE_GATHER: Type = 134217739;
    pub const WAIT_EVENT_HASH_BATCH_ALLOCATE: Type = 134217740;
    pub const WAIT_EVENT_HASH_BATCH_ELECT: Type = 134217741;
    pub const WAIT_EVENT_HASH_BATCH_LOAD: Type = 134217742;
    pub const WAIT_EVENT_HASH_BUILD_ALLOCATE: Type = 134217743;
    pub const WAIT_EVENT_HASH_BUILD_ELECT: Type = 134217744;
    pub const WAIT_EVENT_HASH_BUILD_HASH_INNER: Type = 134217745;
    pub const WAIT_EVENT_HASH_BUILD_HASH_OUTER: Type = 134217746;
    pub const WAIT_EVENT_HASH_GROW_BATCHES_ALLOCATE: Type = 134217747;
    pub const WAIT_EVENT_HASH_GROW_BATCHES_DECIDE: Type = 134217748;
    pub const WAIT_EVENT_HASH_GROW_BATCHES_ELECT: Type = 134217749;
    pub const WAIT_EVENT_HASH_GROW_BATCHES_FINISH: Type = 134217750;
    pub const WAIT_EVENT_HASH_GROW_BATCHES_REPARTITION: Type = 134217751;
    pub const WAIT_EVENT_HASH_GROW_BUCKETS_ALLOCATE: Type = 134217752;
    pub const WAIT_EVENT_HASH_GROW_BUCKETS_ELECT: Type = 134217753;
    pub const WAIT_EVENT_HASH_GROW_BUCKETS_REINSERT: Type = 134217754;
    pub const WAIT_EVENT_LOGICAL_SYNC_DATA: Type = 134217755;
    pub const WAIT_EVENT_LOGICAL_SYNC_STATE_CHANGE: Type = 134217756;
    pub const WAIT_EVENT_MQ_INTERNAL: Type = 134217757;
    pub const WAIT_EVENT_MQ_PUT_MESSAGE: Type = 134217758;
    pub const WAIT_EVENT_MQ_RECEIVE: Type = 134217759;
    pub const WAIT_EVENT_MQ_SEND: Type = 134217760;
    pub const WAIT_EVENT_PARALLEL_BITMAP_SCAN: Type = 134217761;
    pub const WAIT_EVENT_PARALLEL_CREATE_INDEX_SCAN: Type = 134217762;
    pub const WAIT_EVENT_PARALLEL_FINISH: Type = 134217763;
    pub const WAIT_EVENT_PROCARRAY_GROUP_UPDATE: Type = 134217764;
    pub const WAIT_EVENT_PROC_SIGNAL_BARRIER: Type = 134217765;
    pub const WAIT_EVENT_PROMOTE: Type = 134217766;
    pub const WAIT_EVENT_RECOVERY_CONFLICT_SNAPSHOT: Type = 134217767;
    pub const WAIT_EVENT_RECOVERY_CONFLICT_TABLESPACE: Type = 134217768;
    pub const WAIT_EVENT_RECOVERY_END_COMMAND: Type = 134217769;
    pub const WAIT_EVENT_RECOVERY_PAUSE: Type = 134217770;
    pub const WAIT_EVENT_REPLICATION_ORIGIN_DROP: Type = 134217771;
    pub const WAIT_EVENT_REPLICATION_SLOT_DROP: Type = 134217772;
    pub const WAIT_EVENT_RESTORE_COMMAND: Type = 134217773;
    pub const WAIT_EVENT_SAFE_SNAPSHOT: Type = 134217774;
    pub const WAIT_EVENT_SYNC_REP: Type = 134217775;
    pub const WAIT_EVENT_WAL_RECEIVER_EXIT: Type = 134217776;
    pub const WAIT_EVENT_WAL_RECEIVER_WAIT_START: Type = 134217777;
    pub const WAIT_EVENT_XACT_GROUP_UPDATE: Type = 134217778;
}
pub mod WaitEventTimeout {
    pub type Type = ::core::ffi::c_uint;
    pub const WAIT_EVENT_BASE_BACKUP_THROTTLE: Type = 150994944;
    pub const WAIT_EVENT_CHECKPOINT_WRITE_DELAY: Type = 150994945;
    pub const WAIT_EVENT_PG_SLEEP: Type = 150994946;
    pub const WAIT_EVENT_RECOVERY_APPLY_DELAY: Type = 150994947;
    pub const WAIT_EVENT_RECOVERY_RETRIEVE_RETRY_INTERVAL: Type = 150994948;
    pub const WAIT_EVENT_REGISTER_SYNC_REQUEST: Type = 150994949;
    pub const WAIT_EVENT_VACUUM_DELAY: Type = 150994950;
    pub const WAIT_EVENT_VACUUM_TRUNCATE: Type = 150994951;
}
pub mod WaitEventIO {
    pub type Type = ::core::ffi::c_uint;
    pub const WAIT_EVENT_BASEBACKUP_READ: Type = 167772160;
    pub const WAIT_EVENT_BASEBACKUP_SYNC: Type = 167772161;
    pub const WAIT_EVENT_BASEBACKUP_WRITE: Type = 167772162;
    pub const WAIT_EVENT_BUFFILE_READ: Type = 167772163;
    pub const WAIT_EVENT_BUFFILE_WRITE: Type = 167772164;
    pub const WAIT_EVENT_BUFFILE_TRUNCATE: Type = 167772165;
    pub const WAIT_EVENT_CONTROL_FILE_READ: Type = 167772166;
    pub const WAIT_EVENT_CONTROL_FILE_SYNC: Type = 167772167;
    pub const WAIT_EVENT_CONTROL_FILE_SYNC_UPDATE: Type = 167772168;
    pub const WAIT_EVENT_CONTROL_FILE_WRITE: Type = 167772169;
    pub const WAIT_EVENT_CONTROL_FILE_WRITE_UPDATE: Type = 167772170;
    pub const WAIT_EVENT_COPY_FILE_READ: Type = 167772171;
    pub const WAIT_EVENT_COPY_FILE_WRITE: Type = 167772172;
    pub const WAIT_EVENT_DATA_FILE_EXTEND: Type = 167772173;
    pub const WAIT_EVENT_DATA_FILE_FLUSH: Type = 167772174;
    pub const WAIT_EVENT_DATA_FILE_IMMEDIATE_SYNC: Type = 167772175;
    pub const WAIT_EVENT_DATA_FILE_PREFETCH: Type = 167772176;
    pub const WAIT_EVENT_DATA_FILE_READ: Type = 167772177;
    pub const WAIT_EVENT_DATA_FILE_SYNC: Type = 167772178;
    pub const WAIT_EVENT_DATA_FILE_TRUNCATE: Type = 167772179;
    pub const WAIT_EVENT_DATA_FILE_WRITE: Type = 167772180;
    pub const WAIT_EVENT_DSM_FILL_ZERO_WRITE: Type = 167772181;
    pub const WAIT_EVENT_LOCK_FILE_ADDTODATADIR_READ: Type = 167772182;
    pub const WAIT_EVENT_LOCK_FILE_ADDTODATADIR_SYNC: Type = 167772183;
    pub const WAIT_EVENT_LOCK_FILE_ADDTODATADIR_WRITE: Type = 167772184;
    pub const WAIT_EVENT_LOCK_FILE_CREATE_READ: Type = 167772185;
    pub const WAIT_EVENT_LOCK_FILE_CREATE_SYNC: Type = 167772186;
    pub const WAIT_EVENT_LOCK_FILE_CREATE_WRITE: Type = 167772187;
    pub const WAIT_EVENT_LOCK_FILE_RECHECKDATADIR_READ: Type = 167772188;
    pub const WAIT_EVENT_LOGICAL_REWRITE_CHECKPOINT_SYNC: Type = 167772189;
    pub const WAIT_EVENT_LOGICAL_REWRITE_MAPPING_SYNC: Type = 167772190;
    pub const WAIT_EVENT_LOGICAL_REWRITE_MAPPING_WRITE: Type = 167772191;
    pub const WAIT_EVENT_LOGICAL_REWRITE_SYNC: Type = 167772192;
    pub const WAIT_EVENT_LOGICAL_REWRITE_TRUNCATE: Type = 167772193;
    pub const WAIT_EVENT_LOGICAL_REWRITE_WRITE: Type = 167772194;
    pub const WAIT_EVENT_RELATION_MAP_READ: Type = 167772195;
    pub const WAIT_EVENT_RELATION_MAP_SYNC: Type = 167772196;
    pub const WAIT_EVENT_RELATION_MAP_WRITE: Type = 167772197;
    pub const WAIT_EVENT_REORDER_BUFFER_READ: Type = 167772198;
    pub const WAIT_EVENT_REORDER_BUFFER_WRITE: Type = 167772199;
    pub const WAIT_EVENT_REORDER_LOGICAL_MAPPING_READ: Type = 167772200;
    pub const WAIT_EVENT_REPLICATION_SLOT_READ: Type = 167772201;
    pub const WAIT_EVENT_REPLICATION_SLOT_RESTORE_SYNC: Type = 167772202;
    pub const WAIT_EVENT_REPLICATION_SLOT_SYNC: Type = 167772203;
    pub const WAIT_EVENT_REPLICATION_SLOT_WRITE: Type = 167772204;
    pub const WAIT_EVENT_SLRU_FLUSH_SYNC: Type = 167772205;
    pub const WAIT_EVENT_SLRU_READ: Type = 167772206;
    pub const WAIT_EVENT_SLRU_SYNC: Type = 167772207;
    pub const WAIT_EVENT_SLRU_WRITE: Type = 167772208;
    pub const WAIT_EVENT_SNAPBUILD_READ: Type = 167772209;
    pub const WAIT_EVENT_SNAPBUILD_SYNC: Type = 167772210;
    pub const WAIT_EVENT_SNAPBUILD_WRITE: Type = 167772211;
    pub const WAIT_EVENT_TIMELINE_HISTORY_FILE_SYNC: Type = 167772212;
    pub const WAIT_EVENT_TIMELINE_HISTORY_FILE_WRITE: Type = 167772213;
    pub const WAIT_EVENT_TIMELINE_HISTORY_READ: Type = 167772214;
    pub const WAIT_EVENT_TIMELINE_HISTORY_SYNC: Type = 167772215;
    pub const WAIT_EVENT_TIMELINE_HISTORY_WRITE: Type = 167772216;
    pub const WAIT_EVENT_TWOPHASE_FILE_READ: Type = 167772217;
    pub const WAIT_EVENT_TWOPHASE_FILE_SYNC: Type = 167772218;
    pub const WAIT_EVENT_TWOPHASE_FILE_WRITE: Type = 167772219;
    pub const WAIT_EVENT_VERSION_FILE_WRITE: Type = 167772220;
    pub const WAIT_EVENT_WALSENDER_TIMELINE_HISTORY_READ: Type = 167772221;
    pub const WAIT_EVENT_WAL_BOOTSTRAP_SYNC: Type = 167772222;
    pub const WAIT_EVENT_WAL_BOOTSTRAP_WRITE: Type = 167772223;
    pub const WAIT_EVENT_WAL_COPY_READ: Type = 167772224;
    pub const WAIT_EVENT_WAL_COPY_SYNC: Type = 167772225;
    pub const WAIT_EVENT_WAL_COPY_WRITE: Type = 167772226;
    pub const WAIT_EVENT_WAL_INIT_SYNC: Type = 167772227;
    pub const WAIT_EVENT_WAL_INIT_WRITE: Type = 167772228;
    pub const WAIT_EVENT_WAL_READ: Type = 167772229;
    pub const WAIT_EVENT_WAL_SYNC: Type = 167772230;
    pub const WAIT_EVENT_WAL_SYNC_METHOD_ASSIGN: Type = 167772231;
    pub const WAIT_EVENT_WAL_WRITE: Type = 167772232;
    pub const WAIT_EVENT_VERSION_FILE_SYNC: Type = 167772233;
}
pub mod PgStat_Kind {
    pub type Type = ::core::ffi::c_uint;
    pub const PGSTAT_KIND_INVALID: Type = 0;
    pub const PGSTAT_KIND_DATABASE: Type = 1;
    pub const PGSTAT_KIND_RELATION: Type = 2;
    pub const PGSTAT_KIND_FUNCTION: Type = 3;
    pub const PGSTAT_KIND_REPLSLOT: Type = 4;
    pub const PGSTAT_KIND_SUBSCRIPTION: Type = 5;
    pub const PGSTAT_KIND_ARCHIVER: Type = 6;
    pub const PGSTAT_KIND_BGWRITER: Type = 7;
    pub const PGSTAT_KIND_CHECKPOINTER: Type = 8;
    pub const PGSTAT_KIND_SLRU: Type = 9;
    pub const PGSTAT_KIND_WAL: Type = 10;
}
pub mod TrackFunctionsLevel {
    pub type Type = ::core::ffi::c_uint;
    pub const TRACK_FUNC_OFF: Type = 0;
    pub const TRACK_FUNC_PL: Type = 1;
    pub const TRACK_FUNC_ALL: Type = 2;
}
pub mod PgStat_FetchConsistency {
    pub type Type = ::core::ffi::c_uint;
    pub const PGSTAT_FETCH_CONSISTENCY_NONE: Type = 0;
    pub const PGSTAT_FETCH_CONSISTENCY_CACHE: Type = 1;
    pub const PGSTAT_FETCH_CONSISTENCY_SNAPSHOT: Type = 2;
}
pub mod SessionEndType {
    pub type Type = ::core::ffi::c_uint;
    pub const DISCONNECT_NOT_YET: Type = 0;
    pub const DISCONNECT_NORMAL: Type = 1;
    pub const DISCONNECT_CLIENT_EOF: Type = 2;
    pub const DISCONNECT_FATAL: Type = 3;
    pub const DISCONNECT_KILLED: Type = 4;
}
pub type PgStat_Counter = int64;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct PgStat_FunctionCounts {
    pub f_numcalls: PgStat_Counter,
    pub f_total_time: instr_time,
    pub f_self_time: instr_time,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct PgStat_BackendFunctionEntry {
    pub f_counts: PgStat_FunctionCounts,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_FunctionCallUsage {
    pub fs: *mut PgStat_FunctionCounts,
    pub save_f_total_time: instr_time,
    pub save_total: instr_time,
    pub f_start: instr_time,
}
impl Default for PgStat_FunctionCallUsage {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct PgStat_BackendSubEntry {
    pub apply_error_count: PgStat_Counter,
    pub sync_error_count: PgStat_Counter,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct PgStat_TableCounts {
    pub t_numscans: PgStat_Counter,
    pub t_tuples_returned: PgStat_Counter,
    pub t_tuples_fetched: PgStat_Counter,
    pub t_tuples_inserted: PgStat_Counter,
    pub t_tuples_updated: PgStat_Counter,
    pub t_tuples_deleted: PgStat_Counter,
    pub t_tuples_hot_updated: PgStat_Counter,
    pub t_truncdropped: bool,
    pub t_delta_live_tuples: PgStat_Counter,
    pub t_delta_dead_tuples: PgStat_Counter,
    pub t_changed_tuples: PgStat_Counter,
    pub t_blocks_fetched: PgStat_Counter,
    pub t_blocks_hit: PgStat_Counter,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_TableStatus {
    pub t_id: Oid,
    pub t_shared: bool,
    pub trans: *mut PgStat_TableXactStatus,
    pub t_counts: PgStat_TableCounts,
    pub relation: Relation,
}
impl Default for PgStat_TableStatus {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_TableXactStatus {
    pub tuples_inserted: PgStat_Counter,
    pub tuples_updated: PgStat_Counter,
    pub tuples_deleted: PgStat_Counter,
    pub truncdropped: bool,
    pub inserted_pre_truncdrop: PgStat_Counter,
    pub updated_pre_truncdrop: PgStat_Counter,
    pub deleted_pre_truncdrop: PgStat_Counter,
    pub nest_level: ::core::ffi::c_int,
    pub upper: *mut PgStat_TableXactStatus,
    pub parent: *mut PgStat_TableStatus,
    pub next: *mut PgStat_TableXactStatus,
}
impl Default for PgStat_TableXactStatus {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_ArchiverStats {
    pub archived_count: PgStat_Counter,
    pub last_archived_wal: [::core::ffi::c_char; 41usize],
    pub last_archived_timestamp: TimestampTz,
    pub failed_count: PgStat_Counter,
    pub last_failed_wal: [::core::ffi::c_char; 41usize],
    pub last_failed_timestamp: TimestampTz,
    pub stat_reset_timestamp: TimestampTz,
}
impl Default for PgStat_ArchiverStats {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct PgStat_BgWriterStats {
    pub buf_written_clean: PgStat_Counter,
    pub maxwritten_clean: PgStat_Counter,
    pub buf_alloc: PgStat_Counter,
    pub stat_reset_timestamp: TimestampTz,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct PgStat_CheckpointerStats {
    pub timed_checkpoints: PgStat_Counter,
    pub requested_checkpoints: PgStat_Counter,
    pub checkpoint_write_time: PgStat_Counter,
    pub checkpoint_sync_time: PgStat_Counter,
    pub buf_written_checkpoints: PgStat_Counter,
    pub buf_written_backend: PgStat_Counter,
    pub buf_fsync_backend: PgStat_Counter,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct PgStat_StatDBEntry {
    pub n_xact_commit: PgStat_Counter,
    pub n_xact_rollback: PgStat_Counter,
    pub n_blocks_fetched: PgStat_Counter,
    pub n_blocks_hit: PgStat_Counter,
    pub n_tuples_returned: PgStat_Counter,
    pub n_tuples_fetched: PgStat_Counter,
    pub n_tuples_inserted: PgStat_Counter,
    pub n_tuples_updated: PgStat_Counter,
    pub n_tuples_deleted: PgStat_Counter,
    pub last_autovac_time: TimestampTz,
    pub n_conflict_tablespace: PgStat_Counter,
    pub n_conflict_lock: PgStat_Counter,
    pub n_conflict_snapshot: PgStat_Counter,
    pub n_conflict_bufferpin: PgStat_Counter,
    pub n_conflict_startup_deadlock: PgStat_Counter,
    pub n_temp_files: PgStat_Counter,
    pub n_temp_bytes: PgStat_Counter,
    pub n_deadlocks: PgStat_Counter,
    pub n_checksum_failures: PgStat_Counter,
    pub last_checksum_failure: TimestampTz,
    pub n_block_read_time: PgStat_Counter,
    pub n_block_write_time: PgStat_Counter,
    pub n_sessions: PgStat_Counter,
    pub total_session_time: PgStat_Counter,
    pub total_active_time: PgStat_Counter,
    pub total_idle_in_xact_time: PgStat_Counter,
    pub n_sessions_abandoned: PgStat_Counter,
    pub n_sessions_fatal: PgStat_Counter,
    pub n_sessions_killed: PgStat_Counter,
    pub stat_reset_timestamp: TimestampTz,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct PgStat_StatFuncEntry {
    pub f_numcalls: PgStat_Counter,
    pub f_total_time: PgStat_Counter,
    pub f_self_time: PgStat_Counter,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_StatReplSlotEntry {
    pub slotname_unused: NameData,
    pub spill_txns: PgStat_Counter,
    pub spill_count: PgStat_Counter,
    pub spill_bytes: PgStat_Counter,
    pub stream_txns: PgStat_Counter,
    pub stream_count: PgStat_Counter,
    pub stream_bytes: PgStat_Counter,
    pub total_txns: PgStat_Counter,
    pub total_bytes: PgStat_Counter,
    pub stat_reset_timestamp: TimestampTz,
}
impl Default for PgStat_StatReplSlotEntry {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct PgStat_SLRUStats {
    pub blocks_zeroed: PgStat_Counter,
    pub blocks_hit: PgStat_Counter,
    pub blocks_read: PgStat_Counter,
    pub blocks_written: PgStat_Counter,
    pub blocks_exists: PgStat_Counter,
    pub flush: PgStat_Counter,
    pub truncate: PgStat_Counter,
    pub stat_reset_timestamp: TimestampTz,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct PgStat_StatSubEntry {
    pub apply_error_count: PgStat_Counter,
    pub sync_error_count: PgStat_Counter,
    pub stat_reset_timestamp: TimestampTz,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct PgStat_StatTabEntry {
    pub numscans: PgStat_Counter,
    pub tuples_returned: PgStat_Counter,
    pub tuples_fetched: PgStat_Counter,
    pub tuples_inserted: PgStat_Counter,
    pub tuples_updated: PgStat_Counter,
    pub tuples_deleted: PgStat_Counter,
    pub tuples_hot_updated: PgStat_Counter,
    pub n_live_tuples: PgStat_Counter,
    pub n_dead_tuples: PgStat_Counter,
    pub changes_since_analyze: PgStat_Counter,
    pub inserts_since_vacuum: PgStat_Counter,
    pub blocks_fetched: PgStat_Counter,
    pub blocks_hit: PgStat_Counter,
    pub vacuum_timestamp: TimestampTz,
    pub vacuum_count: PgStat_Counter,
    pub autovac_vacuum_timestamp: TimestampTz,
    pub autovac_vacuum_count: PgStat_Counter,
    pub analyze_timestamp: TimestampTz,
    pub analyze_count: PgStat_Counter,
    pub autovac_analyze_timestamp: TimestampTz,
    pub autovac_analyze_count: PgStat_Counter,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct PgStat_WalStats {
    pub wal_records: PgStat_Counter,
    pub wal_fpi: PgStat_Counter,
    pub wal_bytes: uint64,
    pub wal_buffers_full: PgStat_Counter,
    pub wal_write: PgStat_Counter,
    pub wal_sync: PgStat_Counter,
    pub wal_write_time: PgStat_Counter,
    pub wal_sync_time: PgStat_Counter,
    pub stat_reset_timestamp: TimestampTz,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ScanKeyData {
    pub sk_flags: ::core::ffi::c_int,
    pub sk_attno: AttrNumber,
    pub sk_strategy: StrategyNumber,
    pub sk_subtype: Oid,
    pub sk_collation: Oid,
    pub sk_func: FmgrInfo,
    pub sk_argument: Datum,
}
impl Default for ScanKeyData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type ScanKey = *mut ScanKeyData;
pub type LOCKMASK = ::core::ffi::c_int;
pub type LOCKMODE = ::core::ffi::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xl_standby_lock {
    pub xid: TransactionId,
    pub dbOid: Oid,
    pub relOid: Oid,
}
impl Default for xl_standby_lock {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct IndexBuildResult {
    pub heap_tuples: f64,
    pub index_tuples: f64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexVacuumInfo {
    pub index: Relation,
    pub analyze_only: bool,
    pub report_progress: bool,
    pub estimated_count: bool,
    pub message_level: ::core::ffi::c_int,
    pub num_heap_tuples: f64,
    pub strategy: BufferAccessStrategy,
}
impl Default for IndexVacuumInfo {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct IndexBulkDeleteResult {
    pub num_pages: BlockNumber,
    pub estimated_count: bool,
    pub num_index_tuples: f64,
    pub tuples_removed: f64,
    pub pages_newly_deleted: BlockNumber,
    pub pages_deleted: BlockNumber,
    pub pages_free: BlockNumber,
}
pub type IndexBulkDeleteCallback = ::core::option::Option<
    unsafe extern "C-unwind" fn(itemptr: ItemPointer, state: *mut ::core::ffi::c_void) -> bool,
>;
pub type IndexScanDesc = *mut IndexScanDescData;
pub type SysScanDesc = *mut SysScanDescData;
pub type ParallelIndexScanDesc = *mut ParallelIndexScanDescData;
pub mod IndexUniqueCheck {
    pub type Type = ::core::ffi::c_uint;
    pub const UNIQUE_CHECK_NO: Type = 0;
    pub const UNIQUE_CHECK_YES: Type = 1;
    pub const UNIQUE_CHECK_PARTIAL: Type = 2;
    pub const UNIQUE_CHECK_EXISTING: Type = 3;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct IndexOrderByDistance {
    pub value: f64,
    pub isnull: bool,
}
pub mod IndexAMProperty {
    pub type Type = ::core::ffi::c_uint;
    pub const AMPROP_UNKNOWN: Type = 0;
    pub const AMPROP_ASC: Type = 1;
    pub const AMPROP_DESC: Type = 2;
    pub const AMPROP_NULLS_FIRST: Type = 3;
    pub const AMPROP_NULLS_LAST: Type = 4;
    pub const AMPROP_ORDERABLE: Type = 5;
    pub const AMPROP_DISTANCE_ORDERABLE: Type = 6;
    pub const AMPROP_RETURNABLE: Type = 7;
    pub const AMPROP_SEARCH_ARRAY: Type = 8;
    pub const AMPROP_SEARCH_NULLS: Type = 9;
    pub const AMPROP_CLUSTERABLE: Type = 10;
    pub const AMPROP_INDEX_SCAN: Type = 11;
    pub const AMPROP_BITMAP_SCAN: Type = 12;
    pub const AMPROP_BACKWARD_SCAN: Type = 13;
    pub const AMPROP_CAN_ORDER: Type = 14;
    pub const AMPROP_CAN_UNIQUE: Type = 15;
    pub const AMPROP_CAN_MULTI_COL: Type = 16;
    pub const AMPROP_CAN_EXCLUDE: Type = 17;
    pub const AMPROP_CAN_INCLUDE: Type = 18;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OpFamilyMember {
    pub is_func: bool,
    pub object: Oid,
    pub number: ::core::ffi::c_int,
    pub lefttype: Oid,
    pub righttype: Oid,
    pub sortfamily: Oid,
    pub ref_is_hard: bool,
    pub ref_is_family: bool,
    pub refobjid: Oid,
}
impl Default for OpFamilyMember {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type ambuild_function = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        heapRelation: Relation,
        indexRelation: Relation,
        indexInfo: *mut IndexInfo,
    ) -> *mut IndexBuildResult,
>;
pub type ambuildempty_function =
    ::core::option::Option<unsafe extern "C-unwind" fn(indexRelation: Relation)>;
pub type aminsert_function = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        indexRelation: Relation,
        values: *mut Datum,
        isnull: *mut bool,
        heap_tid: ItemPointer,
        heapRelation: Relation,
        checkUnique: IndexUniqueCheck::Type,
        indexUnchanged: bool,
        indexInfo: *mut IndexInfo,
    ) -> bool,
>;
pub type ambulkdelete_function = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        info: *mut IndexVacuumInfo,
        stats: *mut IndexBulkDeleteResult,
        callback: IndexBulkDeleteCallback,
        callback_state: *mut ::core::ffi::c_void,
    ) -> *mut IndexBulkDeleteResult,
>;
pub type amvacuumcleanup_function = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        info: *mut IndexVacuumInfo,
        stats: *mut IndexBulkDeleteResult,
    ) -> *mut IndexBulkDeleteResult,
>;
pub type amcanreturn_function = ::core::option::Option<
    unsafe extern "C-unwind" fn(indexRelation: Relation, attno: ::core::ffi::c_int) -> bool,
>;
pub type amcostestimate_function = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        root: *mut PlannerInfo,
        path: *mut IndexPath,
        loop_count: f64,
        indexStartupCost: *mut Cost,
        indexTotalCost: *mut Cost,
        indexSelectivity: *mut Selectivity,
        indexCorrelation: *mut f64,
        indexPages: *mut f64,
    ),
>;
pub type amoptions_function = ::core::option::Option<
    unsafe extern "C-unwind" fn(reloptions: Datum, validate: bool) -> *mut bytea,
>;
pub type amproperty_function = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        index_oid: Oid,
        attno: ::core::ffi::c_int,
        prop: IndexAMProperty::Type,
        propname: *const ::core::ffi::c_char,
        res: *mut bool,
        isnull: *mut bool,
    ) -> bool,
>;
pub type ambuildphasename_function = ::core::option::Option<
    unsafe extern "C-unwind" fn(phasenum: int64) -> *mut ::core::ffi::c_char,
>;
pub type amvalidate_function =
    ::core::option::Option<unsafe extern "C-unwind" fn(opclassoid: Oid) -> bool>;
pub type amadjustmembers_function = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        opfamilyoid: Oid,
        opclassoid: Oid,
        operators: *mut List,
        functions: *mut List,
    ),
>;
pub type ambeginscan_function = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        indexRelation: Relation,
        nkeys: ::core::ffi::c_int,
        norderbys: ::core::ffi::c_int,
    ) -> IndexScanDesc,
>;
pub type amrescan_function = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        scan: IndexScanDesc,
        keys: ScanKey,
        nkeys: ::core::ffi::c_int,
        orderbys: ScanKey,
        norderbys: ::core::ffi::c_int,
    ),
>;
pub type amgettuple_function = ::core::option::Option<
    unsafe extern "C-unwind" fn(scan: IndexScanDesc, direction: ScanDirection::Type) -> bool,
>;
pub type amgetbitmap_function = ::core::option::Option<
    unsafe extern "C-unwind" fn(scan: IndexScanDesc, tbm: *mut TIDBitmap) -> int64,
>;
pub type amendscan_function =
    ::core::option::Option<unsafe extern "C-unwind" fn(scan: IndexScanDesc)>;
pub type ammarkpos_function =
    ::core::option::Option<unsafe extern "C-unwind" fn(scan: IndexScanDesc)>;
pub type amrestrpos_function =
    ::core::option::Option<unsafe extern "C-unwind" fn(scan: IndexScanDesc)>;
pub type amestimateparallelscan_function =
    ::core::option::Option<unsafe extern "C-unwind" fn() -> Size>;
pub type aminitparallelscan_function =
    ::core::option::Option<unsafe extern "C-unwind" fn(target: *mut ::core::ffi::c_void)>;
pub type amparallelrescan_function =
    ::core::option::Option<unsafe extern "C-unwind" fn(scan: IndexScanDesc)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexAmRoutine {
    pub type_: NodeTag,
    pub amstrategies: uint16,
    pub amsupport: uint16,
    pub amoptsprocnum: uint16,
    pub amcanorder: bool,
    pub amcanorderbyop: bool,
    pub amcanbackward: bool,
    pub amcanunique: bool,
    pub amcanmulticol: bool,
    pub amoptionalkey: bool,
    pub amsearcharray: bool,
    pub amsearchnulls: bool,
    pub amstorage: bool,
    pub amclusterable: bool,
    pub ampredlocks: bool,
    pub amcanparallel: bool,
    pub amcaninclude: bool,
    pub amusemaintenanceworkmem: bool,
    pub amparallelvacuumoptions: uint8,
    pub amkeytype: Oid,
    pub ambuild: ambuild_function,
    pub ambuildempty: ambuildempty_function,
    pub aminsert: aminsert_function,
    pub ambulkdelete: ambulkdelete_function,
    pub amvacuumcleanup: amvacuumcleanup_function,
    pub amcanreturn: amcanreturn_function,
    pub amcostestimate: amcostestimate_function,
    pub amoptions: amoptions_function,
    pub amproperty: amproperty_function,
    pub ambuildphasename: ambuildphasename_function,
    pub amvalidate: amvalidate_function,
    pub amadjustmembers: amadjustmembers_function,
    pub ambeginscan: ambeginscan_function,
    pub amrescan: amrescan_function,
    pub amgettuple: amgettuple_function,
    pub amgetbitmap: amgetbitmap_function,
    pub amendscan: amendscan_function,
    pub ammarkpos: ammarkpos_function,
    pub amrestrpos: amrestrpos_function,
    pub amestimateparallelscan: amestimateparallelscan_function,
    pub aminitparallelscan: aminitparallelscan_function,
    pub amparallelrescan: amparallelrescan_function,
}
impl Default for IndexAmRoutine {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type RmgrId = uint8;
pub mod RmgrIds {
    pub type Type = ::core::ffi::c_uint;
    pub const RM_XLOG_ID: Type = 0;
    pub const RM_XACT_ID: Type = 1;
    pub const RM_SMGR_ID: Type = 2;
    pub const RM_CLOG_ID: Type = 3;
    pub const RM_DBASE_ID: Type = 4;
    pub const RM_TBLSPC_ID: Type = 5;
    pub const RM_MULTIXACT_ID: Type = 6;
    pub const RM_RELMAP_ID: Type = 7;
    pub const RM_STANDBY_ID: Type = 8;
    pub const RM_HEAP2_ID: Type = 9;
    pub const RM_HEAP_ID: Type = 10;
    pub const RM_BTREE_ID: Type = 11;
    pub const RM_HASH_ID: Type = 12;
    pub const RM_GIN_ID: Type = 13;
    pub const RM_GIST_ID: Type = 14;
    pub const RM_SEQ_ID: Type = 15;
    pub const RM_SPGIST_ID: Type = 16;
    pub const RM_BRIN_ID: Type = 17;
    pub const RM_COMMIT_TS_ID: Type = 18;
    pub const RM_REPLORIGIN_ID: Type = 19;
    pub const RM_GENERIC_ID: Type = 20;
    pub const RM_LOGICALMSG_ID: Type = 21;
    pub const RM_NEXT_ID: Type = 22;
}
pub type pg_crc32c = uint32;
pub mod ForkNumber {
    pub type Type = ::core::ffi::c_int;
    pub const InvalidForkNumber: Type = -1;
    pub const MAIN_FORKNUM: Type = 0;
    pub const FSM_FORKNUM: Type = 1;
    pub const VISIBILITYMAP_FORKNUM: Type = 2;
    pub const INIT_FORKNUM: Type = 3;
}
pub type BackendId = ::core::ffi::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RelFileNode {
    pub spcNode: Oid,
    pub dbNode: Oid,
    pub relNode: Oid,
}
impl Default for RelFileNode {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RelFileNodeBackend {
    pub node: RelFileNode,
    pub backend: BackendId,
}
impl Default for RelFileNodeBackend {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct XLogRecord {
    pub xl_tot_len: uint32,
    pub xl_xid: TransactionId,
    pub xl_prev: XLogRecPtr,
    pub xl_info: uint8,
    pub xl_rmid: RmgrId,
    pub xl_crc: pg_crc32c,
}
impl Default for XLogRecord {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct XLogRecordBlockHeader {
    pub id: uint8,
    pub fork_flags: uint8,
    pub data_length: uint16,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct XLogRecordBlockImageHeader {
    pub length: uint16,
    pub hole_offset: uint16,
    pub bimg_info: uint8,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct XLogRecordBlockCompressHeader {
    pub hole_length: uint16,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct XLogRecordDataHeaderShort {
    pub id: uint8,
    pub data_length: uint8,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct XLogRecordDataHeaderLong {
    pub id: uint8,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct WALOpenSegment {
    pub ws_file: ::core::ffi::c_int,
    pub ws_segno: XLogSegNo,
    pub ws_tli: TimeLineID,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WALSegmentContext {
    pub ws_dir: [::core::ffi::c_char; 1024usize],
    pub ws_segsize: ::core::ffi::c_int,
}
impl Default for WALSegmentContext {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type XLogPageReadCB = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        xlogreader: *mut XLogReaderState,
        targetPagePtr: XLogRecPtr,
        reqLen: ::core::ffi::c_int,
        targetRecPtr: XLogRecPtr,
        readBuf: *mut ::core::ffi::c_char,
    ) -> ::core::ffi::c_int,
>;
pub type WALSegmentOpenCB = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        xlogreader: *mut XLogReaderState,
        nextSegNo: XLogSegNo,
        tli_p: *mut TimeLineID,
    ),
>;
pub type WALSegmentCloseCB =
    ::core::option::Option<unsafe extern "C-unwind" fn(xlogreader: *mut XLogReaderState)>;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct XLogReaderRoutine {
    pub page_read: XLogPageReadCB,
    pub segment_open: WALSegmentOpenCB,
    pub segment_close: WALSegmentCloseCB,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DecodedBkpBlock {
    pub in_use: bool,
    pub rnode: RelFileNode,
    pub forknum: ForkNumber::Type,
    pub blkno: BlockNumber,
    pub prefetch_buffer: Buffer,
    pub flags: uint8,
    pub has_image: bool,
    pub apply_image: bool,
    pub bkp_image: *mut ::core::ffi::c_char,
    pub hole_offset: uint16,
    pub hole_length: uint16,
    pub bimg_len: uint16,
    pub bimg_info: uint8,
    pub has_data: bool,
    pub data: *mut ::core::ffi::c_char,
    pub data_len: uint16,
    pub data_bufsz: uint16,
}
impl Default for DecodedBkpBlock {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct DecodedXLogRecord {
    pub size: usize,
    pub oversized: bool,
    pub next: *mut DecodedXLogRecord,
    pub lsn: XLogRecPtr,
    pub next_lsn: XLogRecPtr,
    pub header: XLogRecord,
    pub record_origin: RepOriginId,
    pub toplevel_xid: TransactionId,
    pub main_data: *mut ::core::ffi::c_char,
    pub main_data_len: uint32,
    pub max_block_id: ::core::ffi::c_int,
    pub blocks: __IncompleteArrayField<DecodedBkpBlock>,
}
impl Default for DecodedXLogRecord {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct XLogReaderState {
    pub routine: XLogReaderRoutine,
    pub system_identifier: uint64,
    pub private_data: *mut ::core::ffi::c_void,
    pub ReadRecPtr: XLogRecPtr,
    pub EndRecPtr: XLogRecPtr,
    pub abortedRecPtr: XLogRecPtr,
    pub missingContrecPtr: XLogRecPtr,
    pub overwrittenRecPtr: XLogRecPtr,
    pub DecodeRecPtr: XLogRecPtr,
    pub NextRecPtr: XLogRecPtr,
    pub PrevRecPtr: XLogRecPtr,
    pub record: *mut DecodedXLogRecord,
    pub decode_buffer: *mut ::core::ffi::c_char,
    pub decode_buffer_size: usize,
    pub free_decode_buffer: bool,
    pub decode_buffer_head: *mut ::core::ffi::c_char,
    pub decode_buffer_tail: *mut ::core::ffi::c_char,
    pub decode_queue_head: *mut DecodedXLogRecord,
    pub decode_queue_tail: *mut DecodedXLogRecord,
    pub readBuf: *mut ::core::ffi::c_char,
    pub readLen: uint32,
    pub segcxt: WALSegmentContext,
    pub seg: WALOpenSegment,
    pub segoff: uint32,
    pub latestPagePtr: XLogRecPtr,
    pub latestPageTLI: TimeLineID,
    pub currRecPtr: XLogRecPtr,
    pub currTLI: TimeLineID,
    pub currTLIValidUntil: XLogRecPtr,
    pub nextTLI: TimeLineID,
    pub readRecordBuf: *mut ::core::ffi::c_char,
    pub readRecordBufSize: uint32,
    pub errormsg_buf: *mut ::core::ffi::c_char,
    pub errormsg_deferred: bool,
    pub nonblocking: bool,
}
impl Default for XLogReaderState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod XLogPageReadResult {
    pub type Type = ::core::ffi::c_int;
    pub const XLREAD_SUCCESS: Type = 0;
    pub const XLREAD_FAIL: Type = -1;
    pub const XLREAD_WOULDBLOCK: Type = -2;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct WALReadError {
    pub wre_errno: ::core::ffi::c_int,
    pub wre_off: ::core::ffi::c_int,
    pub wre_req: ::core::ffi::c_int,
    pub wre_read: ::core::ffi::c_int,
    pub wre_seg: WALOpenSegment,
}
pub mod ArchiveMode {
    pub type Type = ::core::ffi::c_uint;
    pub const ARCHIVE_MODE_OFF: Type = 0;
    pub const ARCHIVE_MODE_ON: Type = 1;
    pub const ARCHIVE_MODE_ALWAYS: Type = 2;
}
pub mod WalLevel {
    pub type Type = ::core::ffi::c_uint;
    pub const WAL_LEVEL_MINIMAL: Type = 0;
    pub const WAL_LEVEL_REPLICA: Type = 1;
    pub const WAL_LEVEL_LOGICAL: Type = 2;
}
pub mod WalCompression {
    pub type Type = ::core::ffi::c_uint;
    pub const WAL_COMPRESSION_NONE: Type = 0;
    pub const WAL_COMPRESSION_PGLZ: Type = 1;
    pub const WAL_COMPRESSION_LZ4: Type = 2;
    pub const WAL_COMPRESSION_ZSTD: Type = 3;
}
pub mod RecoveryState {
    pub type Type = ::core::ffi::c_uint;
    pub const RECOVERY_STATE_CRASH: Type = 0;
    pub const RECOVERY_STATE_ARCHIVE: Type = 1;
    pub const RECOVERY_STATE_DONE: Type = 2;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct CheckpointStatsData {
    pub ckpt_start_t: TimestampTz,
    pub ckpt_write_t: TimestampTz,
    pub ckpt_sync_t: TimestampTz,
    pub ckpt_sync_end_t: TimestampTz,
    pub ckpt_end_t: TimestampTz,
    pub ckpt_bufs_written: ::core::ffi::c_int,
    pub ckpt_segs_added: ::core::ffi::c_int,
    pub ckpt_segs_removed: ::core::ffi::c_int,
    pub ckpt_segs_recycled: ::core::ffi::c_int,
    pub ckpt_sync_rels: ::core::ffi::c_int,
    pub ckpt_longest_sync: uint64,
    pub ckpt_agg_sync_time: uint64,
}
pub mod WALAvailability {
    pub type Type = ::core::ffi::c_uint;
    pub const WALAVAIL_INVALID_LSN: Type = 0;
    pub const WALAVAIL_RESERVED: Type = 1;
    pub const WALAVAIL_EXTENDED: Type = 2;
    pub const WALAVAIL_UNRESERVED: Type = 3;
    pub const WALAVAIL_REMOVED: Type = 4;
}
pub mod SessionBackupState {
    pub type Type = ::core::ffi::c_uint;
    pub const SESSION_BACKUP_NONE: Type = 0;
    pub const SESSION_BACKUP_RUNNING: Type = 1;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct XLogPageHeaderData {
    pub xlp_magic: uint16,
    pub xlp_info: uint16,
    pub xlp_tli: TimeLineID,
    pub xlp_pageaddr: XLogRecPtr,
    pub xlp_rem_len: uint32,
}
pub type XLogPageHeader = *mut XLogPageHeaderData;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct XLogLongPageHeaderData {
    pub std: XLogPageHeaderData,
    pub xlp_sysid: uint64,
    pub xlp_seg_size: uint32,
    pub xlp_xlog_blcksz: uint32,
}
pub type XLogLongPageHeader = *mut XLogLongPageHeaderData;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct xl_parameter_change {
    pub MaxConnections: ::core::ffi::c_int,
    pub max_worker_processes: ::core::ffi::c_int,
    pub max_wal_senders: ::core::ffi::c_int,
    pub max_prepared_xacts: ::core::ffi::c_int,
    pub max_locks_per_xact: ::core::ffi::c_int,
    pub wal_level: ::core::ffi::c_int,
    pub wal_log_hints: bool,
    pub track_commit_timestamp: bool,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xl_restore_point {
    pub rp_time: TimestampTz,
    pub rp_name: [::core::ffi::c_char; 64usize],
}
impl Default for xl_restore_point {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct xl_overwrite_contrecord {
    pub overwritten_lsn: XLogRecPtr,
    pub overwrite_time: TimestampTz,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct xl_end_of_recovery {
    pub end_time: TimestampTz,
    pub ThisTimeLineID: TimeLineID,
    pub PrevTimeLineID: TimeLineID,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct XLogRecData {
    pub next: *mut XLogRecData,
    pub data: *mut ::core::ffi::c_char,
    pub len: uint32,
}
impl Default for XLogRecData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod RecoveryTargetAction {
    pub type Type = ::core::ffi::c_uint;
    pub const RECOVERY_TARGET_ACTION_PAUSE: Type = 0;
    pub const RECOVERY_TARGET_ACTION_PROMOTE: Type = 1;
    pub const RECOVERY_TARGET_ACTION_SHUTDOWN: Type = 2;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct XLogRecordBuffer {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RmgrData {
    pub rm_name: *const ::core::ffi::c_char,
    pub rm_redo: ::core::option::Option<unsafe extern "C-unwind" fn(record: *mut XLogReaderState)>,
    pub rm_desc: ::core::option::Option<
        unsafe extern "C-unwind" fn(buf: StringInfo, record: *mut XLogReaderState),
    >,
    pub rm_identify: ::core::option::Option<
        unsafe extern "C-unwind" fn(info: uint8) -> *const ::core::ffi::c_char,
    >,
    pub rm_startup: ::core::option::Option<unsafe extern "C-unwind" fn()>,
    pub rm_cleanup: ::core::option::Option<unsafe extern "C-unwind" fn()>,
    pub rm_mask: ::core::option::Option<
        unsafe extern "C-unwind" fn(pagedata: *mut ::core::ffi::c_char, blkno: BlockNumber),
    >,
    pub rm_decode: ::core::option::Option<
        unsafe extern "C-unwind" fn(ctx: *mut LogicalDecodingContext, buf: *mut XLogRecordBuffer),
    >,
}
impl Default for RmgrData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FormData_pg_class {
    pub oid: Oid,
    pub relname: NameData,
    pub relnamespace: Oid,
    pub reltype: Oid,
    pub reloftype: Oid,
    pub relowner: Oid,
    pub relam: Oid,
    pub relfilenode: Oid,
    pub reltablespace: Oid,
    pub relpages: int32,
    pub reltuples: float4,
    pub relallvisible: int32,
    pub reltoastrelid: Oid,
    pub relhasindex: bool,
    pub relisshared: bool,
    pub relpersistence: ::core::ffi::c_char,
    pub relkind: ::core::ffi::c_char,
    pub relnatts: int16,
    pub relchecks: int16,
    pub relhasrules: bool,
    pub relhastriggers: bool,
    pub relhassubclass: bool,
    pub relrowsecurity: bool,
    pub relforcerowsecurity: bool,
    pub relispopulated: bool,
    pub relreplident: ::core::ffi::c_char,
    pub relispartition: bool,
    pub relrewrite: Oid,
    pub relfrozenxid: TransactionId,
    pub relminmxid: TransactionId,
}
impl Default for FormData_pg_class {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Form_pg_class = *mut FormData_pg_class;
#[repr(C)]
#[derive(Debug)]
pub struct FormData_pg_index {
    pub indexrelid: Oid,
    pub indrelid: Oid,
    pub indnatts: int16,
    pub indnkeyatts: int16,
    pub indisunique: bool,
    pub indnullsnotdistinct: bool,
    pub indisprimary: bool,
    pub indisexclusion: bool,
    pub indimmediate: bool,
    pub indisclustered: bool,
    pub indisvalid: bool,
    pub indcheckxmin: bool,
    pub indisready: bool,
    pub indislive: bool,
    pub indisreplident: bool,
    pub indkey: int2vector,
}
impl Default for FormData_pg_index {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Form_pg_index = *mut FormData_pg_index;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ObjectAddress {
    pub classId: Oid,
    pub objectId: Oid,
    pub objectSubId: int32,
}
impl Default for ObjectAddress {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FormData_pg_publication {
    pub oid: Oid,
    pub pubname: NameData,
    pub pubowner: Oid,
    pub puballtables: bool,
    pub pubinsert: bool,
    pub pubupdate: bool,
    pub pubdelete: bool,
    pub pubtruncate: bool,
    pub pubviaroot: bool,
}
impl Default for FormData_pg_publication {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Form_pg_publication = *mut FormData_pg_publication;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct PublicationActions {
    pub pubinsert: bool,
    pub pubupdate: bool,
    pub pubdelete: bool,
    pub pubtruncate: bool,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct PublicationDesc {
    pub pubactions: PublicationActions,
    pub rf_valid_for_update: bool,
    pub rf_valid_for_delete: bool,
    pub cols_valid_for_update: bool,
    pub cols_valid_for_delete: bool,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Publication {
    pub oid: Oid,
    pub name: *mut ::core::ffi::c_char,
    pub alltables: bool,
    pub pubviaroot: bool,
    pub pubactions: PublicationActions,
}
impl Default for Publication {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PublicationRelInfo {
    pub relation: Relation,
    pub whereClause: *mut Node,
    pub columns: *mut List,
}
impl Default for PublicationRelInfo {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod PublicationPartOpt {
    pub type Type = ::core::ffi::c_uint;
    pub const PUBLICATION_PART_ROOT: Type = 0;
    pub const PUBLICATION_PART_LEAF: Type = 1;
    pub const PUBLICATION_PART_ALL: Type = 2;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RewriteRule {
    pub ruleId: Oid,
    pub event: CmdType::Type,
    pub qual: *mut Node,
    pub actions: *mut List,
    pub enabled: ::core::ffi::c_char,
    pub isInstead: bool,
}
impl Default for RewriteRule {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RuleLock {
    pub numLocks: ::core::ffi::c_int,
    pub rules: *mut *mut RewriteRule,
}
impl Default for RuleLock {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SMgrRelationData {
    pub smgr_rnode: RelFileNodeBackend,
    pub smgr_owner: *mut *mut SMgrRelationData,
    pub smgr_targblock: BlockNumber,
    pub smgr_cached_nblocks: [BlockNumber; 4usize],
    pub smgr_which: ::core::ffi::c_int,
    pub md_num_open_segs: [::core::ffi::c_int; 4usize],
    pub md_seg_fds: [*mut _MdfdVec; 4usize],
    pub node: dlist_node,
}
impl Default for SMgrRelationData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type SMgrRelation = *mut SMgrRelationData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LockRelId {
    pub relId: Oid,
    pub dbId: Oid,
}
impl Default for LockRelId {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LockInfoData {
    pub lockRelId: LockRelId,
}
impl Default for LockInfoData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type LockInfo = *mut LockInfoData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RelationData {
    pub rd_node: RelFileNode,
    pub rd_smgr: SMgrRelation,
    pub rd_refcnt: ::core::ffi::c_int,
    pub rd_backend: BackendId,
    pub rd_islocaltemp: bool,
    pub rd_isnailed: bool,
    pub rd_isvalid: bool,
    pub rd_indexvalid: bool,
    pub rd_statvalid: bool,
    pub rd_createSubid: SubTransactionId,
    pub rd_newRelfilenodeSubid: SubTransactionId,
    pub rd_firstRelfilenodeSubid: SubTransactionId,
    pub rd_droppedSubid: SubTransactionId,
    pub rd_rel: Form_pg_class,
    pub rd_att: TupleDesc,
    pub rd_id: Oid,
    pub rd_lockInfo: LockInfoData,
    pub rd_rules: *mut RuleLock,
    pub rd_rulescxt: MemoryContext,
    pub trigdesc: *mut TriggerDesc,
    pub rd_rsdesc: *mut RowSecurityDesc,
    pub rd_fkeylist: *mut List,
    pub rd_fkeyvalid: bool,
    pub rd_partkey: PartitionKey,
    pub rd_partkeycxt: MemoryContext,
    pub rd_partdesc: PartitionDesc,
    pub rd_pdcxt: MemoryContext,
    pub rd_partdesc_nodetached: PartitionDesc,
    pub rd_pddcxt: MemoryContext,
    pub rd_partdesc_nodetached_xmin: TransactionId,
    pub rd_partcheck: *mut List,
    pub rd_partcheckvalid: bool,
    pub rd_partcheckcxt: MemoryContext,
    pub rd_indexlist: *mut List,
    pub rd_pkindex: Oid,
    pub rd_replidindex: Oid,
    pub rd_statlist: *mut List,
    pub rd_indexattr: *mut Bitmapset,
    pub rd_keyattr: *mut Bitmapset,
    pub rd_pkattr: *mut Bitmapset,
    pub rd_idattr: *mut Bitmapset,
    pub rd_pubdesc: *mut PublicationDesc,
    pub rd_options: *mut bytea,
    pub rd_amhandler: Oid,
    pub rd_tableam: *const TableAmRoutine,
    pub rd_index: Form_pg_index,
    pub rd_indextuple: *mut HeapTupleData,
    pub rd_indexcxt: MemoryContext,
    pub rd_indam: *mut IndexAmRoutine,
    pub rd_opfamily: *mut Oid,
    pub rd_opcintype: *mut Oid,
    pub rd_support: *mut RegProcedure,
    pub rd_supportinfo: *mut FmgrInfo,
    pub rd_indoption: *mut int16,
    pub rd_indexprs: *mut List,
    pub rd_indpred: *mut List,
    pub rd_exclops: *mut Oid,
    pub rd_exclprocs: *mut Oid,
    pub rd_exclstrats: *mut uint16,
    pub rd_indcollation: *mut Oid,
    pub rd_opcoptions: *mut *mut bytea,
    pub rd_amcache: *mut ::core::ffi::c_void,
    pub rd_fdwroutine: *mut FdwRoutine,
    pub rd_toastoid: Oid,
    pub pgstat_enabled: bool,
    pub pgstat_info: *mut PgStat_TableStatus,
}
impl Default for RelationData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ForeignKeyCacheInfo {
    pub type_: NodeTag,
    pub conoid: Oid,
    pub conrelid: Oid,
    pub confrelid: Oid,
    pub nkeys: ::core::ffi::c_int,
    pub conkey: [AttrNumber; 32usize],
    pub confkey: [AttrNumber; 32usize],
    pub conpfeqop: [Oid; 32usize],
}
impl Default for ForeignKeyCacheInfo {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct AutoVacOpts {
    pub enabled: bool,
    pub vacuum_threshold: ::core::ffi::c_int,
    pub vacuum_ins_threshold: ::core::ffi::c_int,
    pub analyze_threshold: ::core::ffi::c_int,
    pub vacuum_cost_limit: ::core::ffi::c_int,
    pub freeze_min_age: ::core::ffi::c_int,
    pub freeze_max_age: ::core::ffi::c_int,
    pub freeze_table_age: ::core::ffi::c_int,
    pub multixact_freeze_min_age: ::core::ffi::c_int,
    pub multixact_freeze_max_age: ::core::ffi::c_int,
    pub multixact_freeze_table_age: ::core::ffi::c_int,
    pub log_min_duration: ::core::ffi::c_int,
    pub vacuum_cost_delay: float8,
    pub vacuum_scale_factor: float8,
    pub vacuum_ins_scale_factor: float8,
    pub analyze_scale_factor: float8,
}
pub mod StdRdOptIndexCleanup {
    pub type Type = ::core::ffi::c_uint;
    pub const STDRD_OPTION_VACUUM_INDEX_CLEANUP_AUTO: Type = 0;
    pub const STDRD_OPTION_VACUUM_INDEX_CLEANUP_OFF: Type = 1;
    pub const STDRD_OPTION_VACUUM_INDEX_CLEANUP_ON: Type = 2;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdRdOptions {
    pub vl_len_: int32,
    pub fillfactor: ::core::ffi::c_int,
    pub toast_tuple_target: ::core::ffi::c_int,
    pub autovacuum: AutoVacOpts,
    pub user_catalog_table: bool,
    pub parallel_workers: ::core::ffi::c_int,
    pub vacuum_index_cleanup: StdRdOptIndexCleanup::Type,
    pub vacuum_truncate: bool,
}
impl Default for StdRdOptions {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod ViewOptCheckOption {
    pub type Type = ::core::ffi::c_uint;
    pub const VIEW_OPTION_CHECK_OPTION_NOT_SET: Type = 0;
    pub const VIEW_OPTION_CHECK_OPTION_LOCAL: Type = 1;
    pub const VIEW_OPTION_CHECK_OPTION_CASCADED: Type = 2;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ViewOptions {
    pub vl_len_: int32,
    pub security_barrier: bool,
    pub security_invoker: bool,
    pub check_option: ViewOptCheckOption::Type,
}
impl Default for ViewOptions {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GenericXLogState {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct GinStatsData {
    pub nPendingPages: BlockNumber,
    pub nTotalPages: BlockNumber,
    pub nEntryPages: BlockNumber,
    pub nDataPages: BlockNumber,
    pub nEntries: int64,
    pub ginVersion: int32,
}
pub type GinTernaryValue = ::core::ffi::c_char;
pub type GistNSN = XLogRecPtr;
pub type PageGistNSN = PageXLogRecPtr;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct GISTPageOpaqueData {
    pub nsn: PageGistNSN,
    pub rightlink: BlockNumber,
    pub flags: uint16,
    pub gist_page_id: uint16,
}
pub type GISTPageOpaque = *mut GISTPageOpaqueData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GIST_SPLITVEC {
    pub spl_left: *mut OffsetNumber,
    pub spl_nleft: ::core::ffi::c_int,
    pub spl_ldatum: Datum,
    pub spl_ldatum_exists: bool,
    pub spl_right: *mut OffsetNumber,
    pub spl_nright: ::core::ffi::c_int,
    pub spl_rdatum: Datum,
    pub spl_rdatum_exists: bool,
}
impl Default for GIST_SPLITVEC {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GISTENTRY {
    pub key: Datum,
    pub rel: Relation,
    pub page: Page,
    pub offset: OffsetNumber,
    pub leafkey: bool,
}
impl Default for GISTENTRY {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct GISTDeletedPageContents {
    pub deleteXid: FullTransactionId,
}
#[repr(C)]
#[derive(Debug)]
pub struct GistEntryVector {
    pub n: int32,
    pub vector: __IncompleteArrayField<GISTENTRY>,
}
impl Default for GistEntryVector {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TableScanDescData {
    pub rs_rd: Relation,
    pub rs_snapshot: *mut SnapshotData,
    pub rs_nkeys: ::core::ffi::c_int,
    pub rs_key: *mut ScanKeyData,
    pub rs_mintid: ItemPointerData,
    pub rs_maxtid: ItemPointerData,
    pub rs_flags: uint32,
    pub rs_parallel: *mut ParallelTableScanDescData,
}
impl Default for TableScanDescData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type TableScanDesc = *mut TableScanDescData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ParallelTableScanDescData {
    pub phs_relid: Oid,
    pub phs_syncscan: bool,
    pub phs_snapshot_any: bool,
    pub phs_snapshot_off: Size,
}
impl Default for ParallelTableScanDescData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type ParallelTableScanDesc = *mut ParallelTableScanDescData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ParallelBlockTableScanDescData {
    pub base: ParallelTableScanDescData,
    pub phs_nblocks: BlockNumber,
    pub phs_mutex: slock_t,
    pub phs_startblock: BlockNumber,
    pub phs_nallocated: pg_atomic_uint64,
}
impl Default for ParallelBlockTableScanDescData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type ParallelBlockTableScanDesc = *mut ParallelBlockTableScanDescData;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ParallelBlockTableScanWorkerData {
    pub phsw_nallocated: uint64,
    pub phsw_chunk_remaining: uint32,
    pub phsw_chunk_size: uint32,
}
pub type ParallelBlockTableScanWorker = *mut ParallelBlockTableScanWorkerData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexFetchTableData {
    pub rel: Relation,
}
impl Default for IndexFetchTableData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexScanDescData {
    pub heapRelation: Relation,
    pub indexRelation: Relation,
    pub xs_snapshot: *mut SnapshotData,
    pub numberOfKeys: ::core::ffi::c_int,
    pub numberOfOrderBys: ::core::ffi::c_int,
    pub keyData: *mut ScanKeyData,
    pub orderByData: *mut ScanKeyData,
    pub xs_want_itup: bool,
    pub xs_temp_snap: bool,
    pub kill_prior_tuple: bool,
    pub ignore_killed_tuples: bool,
    pub xactStartedInRecovery: bool,
    pub opaque: *mut ::core::ffi::c_void,
    pub xs_itup: IndexTuple,
    pub xs_itupdesc: *mut TupleDescData,
    pub xs_hitup: HeapTuple,
    pub xs_hitupdesc: *mut TupleDescData,
    pub xs_heaptid: ItemPointerData,
    pub xs_heap_continue: bool,
    pub xs_heapfetch: *mut IndexFetchTableData,
    pub xs_recheck: bool,
    pub xs_orderbyvals: *mut Datum,
    pub xs_orderbynulls: *mut bool,
    pub xs_recheckorderby: bool,
    pub parallel_scan: *mut ParallelIndexScanDescData,
}
impl Default for IndexScanDescData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct ParallelIndexScanDescData {
    pub ps_relid: Oid,
    pub ps_indexid: Oid,
    pub ps_offset: Size,
    pub ps_snapshot_data: __IncompleteArrayField<::core::ffi::c_char>,
}
impl Default for ParallelIndexScanDescData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SysScanDescData {
    pub heap_rel: Relation,
    pub irel: Relation,
    pub scan: *mut TableScanDescData,
    pub iscan: *mut IndexScanDescData,
    pub snapshot: *mut SnapshotData,
    pub slot: *mut TupleTableSlot,
}
impl Default for SysScanDescData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SharedInvalCatcacheMsg {
    pub id: int8,
    pub dbId: Oid,
    pub hashValue: uint32,
}
impl Default for SharedInvalCatcacheMsg {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SharedInvalCatalogMsg {
    pub id: int8,
    pub dbId: Oid,
    pub catId: Oid,
}
impl Default for SharedInvalCatalogMsg {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SharedInvalRelcacheMsg {
    pub id: int8,
    pub dbId: Oid,
    pub relId: Oid,
}
impl Default for SharedInvalRelcacheMsg {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SharedInvalSmgrMsg {
    pub id: int8,
    pub backend_hi: int8,
    pub backend_lo: uint16,
    pub rnode: RelFileNode,
}
impl Default for SharedInvalSmgrMsg {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SharedInvalRelmapMsg {
    pub id: int8,
    pub dbId: Oid,
}
impl Default for SharedInvalRelmapMsg {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SharedInvalSnapshotMsg {
    pub id: int8,
    pub dbId: Oid,
    pub relId: Oid,
}
impl Default for SharedInvalSnapshotMsg {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union SharedInvalidationMessage {
    pub id: int8,
    pub cc: SharedInvalCatcacheMsg,
    pub cat: SharedInvalCatalogMsg,
    pub rc: SharedInvalRelcacheMsg,
    pub sm: SharedInvalSmgrMsg,
    pub rm: SharedInvalRelmapMsg,
    pub sn: SharedInvalSnapshotMsg,
}
impl Default for SharedInvalidationMessage {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod SyncCommitLevel {
    pub type Type = ::core::ffi::c_uint;
    pub const SYNCHRONOUS_COMMIT_OFF: Type = 0;
    pub const SYNCHRONOUS_COMMIT_LOCAL_FLUSH: Type = 1;
    pub const SYNCHRONOUS_COMMIT_REMOTE_WRITE: Type = 2;
    pub const SYNCHRONOUS_COMMIT_REMOTE_FLUSH: Type = 3;
    pub const SYNCHRONOUS_COMMIT_REMOTE_APPLY: Type = 4;
}
pub mod XactEvent {
    pub type Type = ::core::ffi::c_uint;
    pub const XACT_EVENT_COMMIT: Type = 0;
    pub const XACT_EVENT_PARALLEL_COMMIT: Type = 1;
    pub const XACT_EVENT_ABORT: Type = 2;
    pub const XACT_EVENT_PARALLEL_ABORT: Type = 3;
    pub const XACT_EVENT_PREPARE: Type = 4;
    pub const XACT_EVENT_PRE_COMMIT: Type = 5;
    pub const XACT_EVENT_PARALLEL_PRE_COMMIT: Type = 6;
    pub const XACT_EVENT_PRE_PREPARE: Type = 7;
}
pub type XactCallback = ::core::option::Option<
    unsafe extern "C-unwind" fn(event: XactEvent::Type, arg: *mut ::core::ffi::c_void),
>;
pub mod SubXactEvent {
    pub type Type = ::core::ffi::c_uint;
    pub const SUBXACT_EVENT_START_SUB: Type = 0;
    pub const SUBXACT_EVENT_COMMIT_SUB: Type = 1;
    pub const SUBXACT_EVENT_ABORT_SUB: Type = 2;
    pub const SUBXACT_EVENT_PRE_COMMIT_SUB: Type = 3;
}
pub type SubXactCallback = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        event: SubXactEvent::Type,
        mySubid: SubTransactionId,
        parentSubid: SubTransactionId,
        arg: *mut ::core::ffi::c_void,
    ),
>;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct SavedTransactionCharacteristics {
    pub save_XactIsoLevel: ::core::ffi::c_int,
    pub save_XactReadOnly: bool,
    pub save_XactDeferrable: bool,
}
#[repr(C)]
#[derive(Debug)]
pub struct xl_xact_assignment {
    pub xtop: TransactionId,
    pub nsubxacts: ::core::ffi::c_int,
    pub xsub: __IncompleteArrayField<TransactionId>,
}
impl Default for xl_xact_assignment {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct xl_xact_xinfo {
    pub xinfo: uint32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xl_xact_dbinfo {
    pub dbId: Oid,
    pub tsId: Oid,
}
impl Default for xl_xact_dbinfo {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct xl_xact_subxacts {
    pub nsubxacts: ::core::ffi::c_int,
    pub subxacts: __IncompleteArrayField<TransactionId>,
}
impl Default for xl_xact_subxacts {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct xl_xact_relfilenodes {
    pub nrels: ::core::ffi::c_int,
    pub xnodes: __IncompleteArrayField<RelFileNode>,
}
impl Default for xl_xact_relfilenodes {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xl_xact_stats_item {
    pub kind: ::core::ffi::c_int,
    pub dboid: Oid,
    pub objoid: Oid,
}
impl Default for xl_xact_stats_item {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct xl_xact_stats_items {
    pub nitems: ::core::ffi::c_int,
    pub items: __IncompleteArrayField<xl_xact_stats_item>,
}
impl Default for xl_xact_stats_items {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
pub struct xl_xact_invals {
    pub nmsgs: ::core::ffi::c_int,
    pub msgs: __IncompleteArrayField<SharedInvalidationMessage>,
}
impl Default for xl_xact_invals {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xl_xact_twophase {
    pub xid: TransactionId,
}
impl Default for xl_xact_twophase {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct xl_xact_origin {
    pub origin_lsn: XLogRecPtr,
    pub origin_timestamp: TimestampTz,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct xl_xact_commit {
    pub xact_time: TimestampTz,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct xl_xact_abort {
    pub xact_time: TimestampTz,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xl_xact_prepare {
    pub magic: uint32,
    pub total_len: uint32,
    pub xid: TransactionId,
    pub database: Oid,
    pub prepared_at: TimestampTz,
    pub owner: Oid,
    pub nsubxacts: int32,
    pub ncommitrels: int32,
    pub nabortrels: int32,
    pub ncommitstats: int32,
    pub nabortstats: int32,
    pub ninvalmsgs: int32,
    pub initfileinval: bool,
    pub gidlen: uint16,
    pub origin_lsn: XLogRecPtr,
    pub origin_timestamp: TimestampTz,
}
impl Default for xl_xact_prepare {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xl_xact_parsed_commit {
    pub xact_time: TimestampTz,
    pub xinfo: uint32,
    pub dbId: Oid,
    pub tsId: Oid,
    pub nsubxacts: ::core::ffi::c_int,
    pub subxacts: *mut TransactionId,
    pub nrels: ::core::ffi::c_int,
    pub xnodes: *mut RelFileNode,
    pub nstats: ::core::ffi::c_int,
    pub stats: *mut xl_xact_stats_item,
    pub nmsgs: ::core::ffi::c_int,
    pub msgs: *mut SharedInvalidationMessage,
    pub twophase_xid: TransactionId,
    pub twophase_gid: [::core::ffi::c_char; 200usize],
    pub nabortrels: ::core::ffi::c_int,
    pub abortnodes: *mut RelFileNode,
    pub nabortstats: ::core::ffi::c_int,
    pub abortstats: *mut xl_xact_stats_item,
    pub origin_lsn: XLogRecPtr,
    pub origin_timestamp: TimestampTz,
}
impl Default for xl_xact_parsed_commit {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type xl_xact_parsed_prepare = xl_xact_parsed_commit;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xl_xact_parsed_abort {
    pub xact_time: TimestampTz,
    pub xinfo: uint32,
    pub dbId: Oid,
    pub tsId: Oid,
    pub nsubxacts: ::core::ffi::c_int,
    pub subxacts: *mut TransactionId,
    pub nrels: ::core::ffi::c_int,
    pub xnodes: *mut RelFileNode,
    pub nstats: ::core::ffi::c_int,
    pub stats: *mut xl_xact_stats_item,
    pub twophase_xid: TransactionId,
    pub twophase_gid: [::core::ffi::c_char; 200usize],
    pub origin_lsn: XLogRecPtr,
    pub origin_timestamp: TimestampTz,
}
impl Default for xl_xact_parsed_abort {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type EOM_get_flat_size_method =
    ::core::option::Option<unsafe extern "C-unwind" fn(eohptr: *mut ExpandedObjectHeader) -> Size>;
pub type EOM_flatten_into_method = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        eohptr: *mut ExpandedObjectHeader,
        result: *mut ::core::ffi::c_void,
        allocated_size: Size,
    ),
>;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ExpandedObjectMethods {
    pub get_flat_size: EOM_get_flat_size_method,
    pub flatten_into: EOM_flatten_into_method,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExpandedObjectHeader {
    pub vl_len_: int32,
    pub eoh_methods: *const ExpandedObjectMethods,
    pub eoh_context: MemoryContext,
    pub eoh_rw_ptr: [::core::ffi::c_char; 10usize],
    pub eoh_ro_ptr: [::core::ffi::c_char; 10usize],
}
impl Default for ExpandedObjectHeader {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ArrayType {
    pub vl_len_: int32,
    pub ndim: ::core::ffi::c_int,
    pub dataoffset: int32,
    pub elemtype: Oid,
}
impl Default for ArrayType {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExpandedArrayHeader {
    pub hdr: ExpandedObjectHeader,
    pub ea_magic: ::core::ffi::c_int,
    pub ndims: ::core::ffi::c_int,
    pub dims: *mut ::core::ffi::c_int,
    pub lbound: *mut ::core::ffi::c_int,
    pub element_type: Oid,
    pub typlen: int16,
    pub typbyval: bool,
    pub typalign: ::core::ffi::c_char,
    pub dvalues: *mut Datum,
    pub dnulls: *mut bool,
    pub dvalueslen: ::core::ffi::c_int,
    pub nelems: ::core::ffi::c_int,
    pub flat_size: Size,
    pub fvalue: *mut ArrayType,
    pub fstartptr: *mut ::core::ffi::c_char,
    pub fendptr: *mut ::core::ffi::c_char,
}
impl Default for ExpandedArrayHeader {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union AnyArrayType {
    pub flt: ArrayType,
    pub xpn: ExpandedArrayHeader,
}
impl Default for AnyArrayType {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ArrayBuildState {
    pub mcontext: MemoryContext,
    pub dvalues: *mut Datum,
    pub dnulls: *mut bool,
    pub alen: ::core::ffi::c_int,
    pub nelems: ::core::ffi::c_int,
    pub element_type: Oid,
    pub typlen: int16,
    pub typbyval: bool,
    pub typalign: ::core::ffi::c_char,
    pub private_cxt: bool,
}
impl Default for ArrayBuildState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ArrayBuildStateArr {
    pub mcontext: MemoryContext,
    pub data: *mut ::core::ffi::c_char,
    pub nullbitmap: *mut bits8,
    pub abytes: ::core::ffi::c_int,
    pub nbytes: ::core::ffi::c_int,
    pub aitems: ::core::ffi::c_int,
    pub nitems: ::core::ffi::c_int,
    pub ndims: ::core::ffi::c_int,
    pub dims: [::core::ffi::c_int; 6usize],
    pub lbs: [::core::ffi::c_int; 6usize],
    pub array_type: Oid,
    pub element_type: Oid,
    pub private_cxt: bool,
}
impl Default for ArrayBuildStateArr {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ArrayBuildStateAny {
    pub scalarstate: *mut ArrayBuildState,
    pub arraystate: *mut ArrayBuildStateArr,
}
impl Default for ArrayBuildStateAny {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ArrayMetaState {
    pub element_type: Oid,
    pub typlen: int16,
    pub typbyval: bool,
    pub typalign: ::core::ffi::c_char,
    pub typdelim: ::core::ffi::c_char,
    pub typioparam: Oid,
    pub typiofunc: Oid,
    pub proc_: FmgrInfo,
}
impl Default for ArrayMetaState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ArrayMapState {
    pub inp_extra: ArrayMetaState,
    pub ret_extra: ArrayMetaState,
}
impl Default for ArrayMapState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ArrayIteratorData {
    _unused: [u8; 0],
}
pub type ArrayIterator = *mut ArrayIteratorData;
pub mod GucContext {
    pub type Type = ::core::ffi::c_uint;
    pub const PGC_INTERNAL: Type = 0;
    pub const PGC_POSTMASTER: Type = 1;
    pub const PGC_SIGHUP: Type = 2;
    pub const PGC_SU_BACKEND: Type = 3;
    pub const PGC_BACKEND: Type = 4;
    pub const PGC_SUSET: Type = 5;
    pub const PGC_USERSET: Type = 6;
}
pub mod GucSource {
    pub type Type = ::core::ffi::c_uint;
    pub const PGC_S_DEFAULT: Type = 0;
    pub const PGC_S_DYNAMIC_DEFAULT: Type = 1;
    pub const PGC_S_ENV_VAR: Type = 2;
    pub const PGC_S_FILE: Type = 3;
    pub const PGC_S_ARGV: Type = 4;
    pub const PGC_S_GLOBAL: Type = 5;
    pub const PGC_S_DATABASE: Type = 6;
    pub const PGC_S_USER: Type = 7;
    pub const PGC_S_DATABASE_USER: Type = 8;
    pub const PGC_S_CLIENT: Type = 9;
    pub const PGC_S_OVERRIDE: Type = 10;
    pub const PGC_S_INTERACTIVE: Type = 11;
    pub const PGC_S_TEST: Type = 12;
    pub const PGC_S_SESSION: Type = 13;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ConfigVariable {
    pub name: *mut ::core::ffi::c_char,
    pub value: *mut ::core::ffi::c_char,
    pub errmsg: *mut ::core::ffi::c_char,
    pub filename: *mut ::core::ffi::c_char,
    pub sourceline: ::core::ffi::c_int,
    pub ignore: bool,
    pub applied: bool,
    pub next: *mut ConfigVariable,
}
impl Default for ConfigVariable {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct config_enum_entry {
    pub name: *const ::core::ffi::c_char,
    pub val: ::core::ffi::c_int,
    pub hidden: bool,
}
impl Default for config_enum_entry {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type GucBoolCheckHook = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        newval: *mut bool,
        extra: *mut *mut ::core::ffi::c_void,
        source: GucSource::Type,
    ) -> bool,
>;
pub type GucIntCheckHook = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        newval: *mut ::core::ffi::c_int,
        extra: *mut *mut ::core::ffi::c_void,
        source: GucSource::Type,
    ) -> bool,
>;
pub type GucRealCheckHook = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        newval: *mut f64,
        extra: *mut *mut ::core::ffi::c_void,
        source: GucSource::Type,
    ) -> bool,
>;
pub type GucStringCheckHook = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        newval: *mut *mut ::core::ffi::c_char,
        extra: *mut *mut ::core::ffi::c_void,
        source: GucSource::Type,
    ) -> bool,
>;
pub type GucEnumCheckHook = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        newval: *mut ::core::ffi::c_int,
        extra: *mut *mut ::core::ffi::c_void,
        source: GucSource::Type,
    ) -> bool,
>;
pub type GucBoolAssignHook = ::core::option::Option<
    unsafe extern "C-unwind" fn(newval: bool, extra: *mut ::core::ffi::c_void),
>;
pub type GucIntAssignHook = ::core::option::Option<
    unsafe extern "C-unwind" fn(newval: ::core::ffi::c_int, extra: *mut ::core::ffi::c_void),
>;
pub type GucRealAssignHook = ::core::option::Option<
    unsafe extern "C-unwind" fn(newval: f64, extra: *mut ::core::ffi::c_void),
>;
pub type GucStringAssignHook = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        newval: *const ::core::ffi::c_char,
        extra: *mut ::core::ffi::c_void,
    ),
>;
pub type GucEnumAssignHook = ::core::option::Option<
    unsafe extern "C-unwind" fn(newval: ::core::ffi::c_int, extra: *mut ::core::ffi::c_void),
>;
pub type GucShowHook =
    ::core::option::Option<unsafe extern "C-unwind" fn() -> *const ::core::ffi::c_char>;
pub mod GucAction {
    pub type Type = ::core::ffi::c_uint;
    pub const GUC_ACTION_SET: Type = 0;
    pub const GUC_ACTION_LOCAL: Type = 1;
    pub const GUC_ACTION_SAVE: Type = 2;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BulkInsertStateData {
    _unused: [u8; 0],
}
pub mod ScanOptions {
    pub type Type = ::core::ffi::c_uint;
    pub const SO_TYPE_SEQSCAN: Type = 1;
    pub const SO_TYPE_BITMAPSCAN: Type = 2;
    pub const SO_TYPE_SAMPLESCAN: Type = 4;
    pub const SO_TYPE_TIDSCAN: Type = 8;
    pub const SO_TYPE_TIDRANGESCAN: Type = 16;
    pub const SO_TYPE_ANALYZE: Type = 32;
    pub const SO_ALLOW_STRAT: Type = 64;
    pub const SO_ALLOW_SYNC: Type = 128;
    pub const SO_ALLOW_PAGEMODE: Type = 256;
    pub const SO_TEMP_SNAPSHOT: Type = 512;
}
pub mod TM_Result {
    pub type Type = ::core::ffi::c_uint;
    pub const TM_Ok: Type = 0;
    pub const TM_Invisible: Type = 1;
    pub const TM_SelfModified: Type = 2;
    pub const TM_Updated: Type = 3;
    pub const TM_Deleted: Type = 4;
    pub const TM_BeingModified: Type = 5;
    pub const TM_WouldBlock: Type = 6;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TM_FailureData {
    pub ctid: ItemPointerData,
    pub xmax: TransactionId,
    pub cmax: CommandId,
    pub traversed: bool,
}
impl Default for TM_FailureData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct TM_IndexDelete {
    pub tid: ItemPointerData,
    pub id: int16,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct TM_IndexStatus {
    pub idxoffnum: OffsetNumber,
    pub knowndeletable: bool,
    pub promising: bool,
    pub freespace: int16,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TM_IndexDeleteOp {
    pub irel: Relation,
    pub iblknum: BlockNumber,
    pub bottomup: bool,
    pub bottomupfreespace: ::core::ffi::c_int,
    pub ndeltids: ::core::ffi::c_int,
    pub deltids: *mut TM_IndexDelete,
    pub status: *mut TM_IndexStatus,
}
impl Default for TM_IndexDeleteOp {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type IndexBuildCallback = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        index: Relation,
        tid: ItemPointer,
        values: *mut Datum,
        isnull: *mut bool,
        tupleIsAlive: bool,
        state: *mut ::core::ffi::c_void,
    ),
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TableAmRoutine {
    pub type_: NodeTag,
    pub slot_callbacks: ::core::option::Option<
        unsafe extern "C-unwind" fn(rel: Relation) -> *const TupleTableSlotOps,
    >,
    pub scan_begin: ::core::option::Option<
        unsafe extern "C-unwind" fn(
            rel: Relation,
            snapshot: Snapshot,
            nkeys: ::core::ffi::c_int,
            key: *mut ScanKeyData,
            pscan: ParallelTableScanDesc,
            flags: uint32,
        ) -> TableScanDesc,
    >,
    pub scan_end: ::core::option::Option<unsafe extern "C-unwind" fn(scan: TableScanDesc)>,
    pub scan_rescan: ::core::option::Option<
        unsafe extern "C-unwind" fn(
            scan: TableScanDesc,
            key: *mut ScanKeyData,
            set_params: bool,
            allow_strat: bool,
            allow_sync: bool,
            allow_pagemode: bool,
        ),
    >,
    pub scan_getnextslot: ::core::option::Option<
        unsafe extern "C-unwind" fn(
            scan: TableScanDesc,
            direction: ScanDirection::Type,
            slot: *mut TupleTableSlot,
        ) -> bool,
    >,
    pub scan_set_tidrange: ::core::option::Option<
        unsafe extern "C-unwind" fn(scan: TableScanDesc, mintid: ItemPointer, maxtid: ItemPointer),
    >,
    pub scan_getnextslot_tidrange: ::core::option::Option<
        unsafe extern "C-unwind" fn(
            scan: TableScanDesc,
            direction: ScanDirection::Type,
            slot: *mut TupleTableSlot,
        ) -> bool,
    >,
    pub parallelscan_estimate:
        ::core::option::Option<unsafe extern "C-unwind" fn(rel: Relation) -> Size>,
    pub parallelscan_initialize: ::core::option::Option<
        unsafe extern "C-unwind" fn(rel: Relation, pscan: ParallelTableScanDesc) -> Size,
    >,
    pub parallelscan_reinitialize: ::core::option::Option<
        unsafe extern "C-unwind" fn(rel: Relation, pscan: ParallelTableScanDesc),
    >,
    pub index_fetch_begin: ::core::option::Option<
        unsafe extern "C-unwind" fn(rel: Relation) -> *mut IndexFetchTableData,
    >,
    pub index_fetch_reset:
        ::core::option::Option<unsafe extern "C-unwind" fn(data: *mut IndexFetchTableData)>,
    pub index_fetch_end:
        ::core::option::Option<unsafe extern "C-unwind" fn(data: *mut IndexFetchTableData)>,
    pub index_fetch_tuple: ::core::option::Option<
        unsafe extern "C-unwind" fn(
            scan: *mut IndexFetchTableData,
            tid: ItemPointer,
            snapshot: Snapshot,
            slot: *mut TupleTableSlot,
            call_again: *mut bool,
            all_dead: *mut bool,
        ) -> bool,
    >,
    pub tuple_fetch_row_version: ::core::option::Option<
        unsafe extern "C-unwind" fn(
            rel: Relation,
            tid: ItemPointer,
            snapshot: Snapshot,
            slot: *mut TupleTableSlot,
        ) -> bool,
    >,
    pub tuple_tid_valid: ::core::option::Option<
        unsafe extern "C-unwind" fn(scan: TableScanDesc, tid: ItemPointer) -> bool,
    >,
    pub tuple_get_latest_tid:
        ::core::option::Option<unsafe extern "C-unwind" fn(scan: TableScanDesc, tid: ItemPointer)>,
    pub tuple_satisfies_snapshot: ::core::option::Option<
        unsafe extern "C-unwind" fn(
            rel: Relation,
            slot: *mut TupleTableSlot,
            snapshot: Snapshot,
        ) -> bool,
    >,
    pub index_delete_tuples: ::core::option::Option<
        unsafe extern "C-unwind" fn(
            rel: Relation,
            delstate: *mut TM_IndexDeleteOp,
        ) -> TransactionId,
    >,
    pub tuple_insert: ::core::option::Option<
        unsafe extern "C-unwind" fn(
            rel: Relation,
            slot: *mut TupleTableSlot,
            cid: CommandId,
            options: ::core::ffi::c_int,
            bistate: *mut BulkInsertStateData,
        ),
    >,
    pub tuple_insert_speculative: ::core::option::Option<
        unsafe extern "C-unwind" fn(
            rel: Relation,
            slot: *mut TupleTableSlot,
            cid: CommandId,
            options: ::core::ffi::c_int,
            bistate: *mut BulkInsertStateData,
            specToken: uint32,
        ),
    >,
    pub tuple_complete_speculative: ::core::option::Option<
        unsafe extern "C-unwind" fn(
            rel: Relation,
            slot: *mut TupleTableSlot,
            specToken: uint32,
            succeeded: bool,
        ),
    >,
    pub multi_insert: ::core::option::Option<
        unsafe extern "C-unwind" fn(
            rel: Relation,
            slots: *mut *mut TupleTableSlot,
            nslots: ::core::ffi::c_int,
            cid: CommandId,
            options: ::core::ffi::c_int,
            bistate: *mut BulkInsertStateData,
        ),
    >,
    pub tuple_delete: ::core::option::Option<
        unsafe extern "C-unwind" fn(
            rel: Relation,
            tid: ItemPointer,
            cid: CommandId,
            snapshot: Snapshot,
            crosscheck: Snapshot,
            wait: bool,
            tmfd: *mut TM_FailureData,
            changingPart: bool,
        ) -> TM_Result::Type,
    >,
    pub tuple_update: ::core::option::Option<
        unsafe extern "C-unwind" fn(
            rel: Relation,
            otid: ItemPointer,
            slot: *mut TupleTableSlot,
            cid: CommandId,
            snapshot: Snapshot,
            crosscheck: Snapshot,
            wait: bool,
            tmfd: *mut TM_FailureData,
            lockmode: *mut LockTupleMode::Type,
            update_indexes: *mut bool,
        ) -> TM_Result::Type,
    >,
    pub tuple_lock: ::core::option::Option<
        unsafe extern "C-unwind" fn(
            rel: Relation,
            tid: ItemPointer,
            snapshot: Snapshot,
            slot: *mut TupleTableSlot,
            cid: CommandId,
            mode: LockTupleMode::Type,
            wait_policy: LockWaitPolicy::Type,
            flags: uint8,
            tmfd: *mut TM_FailureData,
        ) -> TM_Result::Type,
    >,
    pub finish_bulk_insert: ::core::option::Option<
        unsafe extern "C-unwind" fn(rel: Relation, options: ::core::ffi::c_int),
    >,
    pub relation_set_new_filenode: ::core::option::Option<
        unsafe extern "C-unwind" fn(
            rel: Relation,
            newrnode: *const RelFileNode,
            persistence: ::core::ffi::c_char,
            freezeXid: *mut TransactionId,
            minmulti: *mut MultiXactId,
        ),
    >,
    pub relation_nontransactional_truncate:
        ::core::option::Option<unsafe extern "C-unwind" fn(rel: Relation)>,
    pub relation_copy_data: ::core::option::Option<
        unsafe extern "C-unwind" fn(rel: Relation, newrnode: *const RelFileNode),
    >,
    pub relation_copy_for_cluster: ::core::option::Option<
        unsafe extern "C-unwind" fn(
            OldTable: Relation,
            NewTable: Relation,
            OldIndex: Relation,
            use_sort: bool,
            OldestXmin: TransactionId,
            xid_cutoff: *mut TransactionId,
            multi_cutoff: *mut MultiXactId,
            num_tuples: *mut f64,
            tups_vacuumed: *mut f64,
            tups_recently_dead: *mut f64,
        ),
    >,
    pub relation_vacuum: ::core::option::Option<
        unsafe extern "C-unwind" fn(
            rel: Relation,
            params: *mut VacuumParams,
            bstrategy: BufferAccessStrategy,
        ),
    >,
    pub scan_analyze_next_block: ::core::option::Option<
        unsafe extern "C-unwind" fn(
            scan: TableScanDesc,
            blockno: BlockNumber,
            bstrategy: BufferAccessStrategy,
        ) -> bool,
    >,
    pub scan_analyze_next_tuple: ::core::option::Option<
        unsafe extern "C-unwind" fn(
            scan: TableScanDesc,
            OldestXmin: TransactionId,
            liverows: *mut f64,
            deadrows: *mut f64,
            slot: *mut TupleTableSlot,
        ) -> bool,
    >,
    pub index_build_range_scan: ::core::option::Option<
        unsafe extern "C-unwind" fn(
            table_rel: Relation,
            index_rel: Relation,
            index_info: *mut IndexInfo,
            allow_sync: bool,
            anyvisible: bool,
            progress: bool,
            start_blockno: BlockNumber,
            numblocks: BlockNumber,
            callback: IndexBuildCallback,
            callback_state: *mut ::core::ffi::c_void,
            scan: TableScanDesc,
        ) -> f64,
    >,
    pub index_validate_scan: ::core::option::Option<
        unsafe extern "C-unwind" fn(
            table_rel: Relation,
            index_rel: Relation,
            index_info: *mut IndexInfo,
            snapshot: Snapshot,
            state: *mut ValidateIndexState,
        ),
    >,
    pub relation_size: ::core::option::Option<
        unsafe extern "C-unwind" fn(rel: Relation, forkNumber: ForkNumber::Type) -> uint64,
    >,
    pub relation_needs_toast_table:
        ::core::option::Option<unsafe extern "C-unwind" fn(rel: Relation) -> bool>,
    pub relation_toast_am:
        ::core::option::Option<unsafe extern "C-unwind" fn(rel: Relation) -> Oid>,
    pub relation_fetch_toast_slice: ::core::option::Option<
        unsafe extern "C-unwind" fn(
            toastrel: Relation,
            valueid: Oid,
            attrsize: int32,
            sliceoffset: int32,
            slicelength: int32,
            result: *mut varlena,
        ),
    >,
    pub relation_estimate_size: ::core::option::Option<
        unsafe extern "C-unwind" fn(
            rel: Relation,
            attr_widths: *mut int32,
            pages: *mut BlockNumber,
            tuples: *mut f64,
            allvisfrac: *mut f64,
        ),
    >,
    pub scan_bitmap_next_block: ::core::option::Option<
        unsafe extern "C-unwind" fn(scan: TableScanDesc, tbmres: *mut TBMIterateResult) -> bool,
    >,
    pub scan_bitmap_next_tuple: ::core::option::Option<
        unsafe extern "C-unwind" fn(
            scan: TableScanDesc,
            tbmres: *mut TBMIterateResult,
            slot: *mut TupleTableSlot,
        ) -> bool,
    >,
    pub scan_sample_next_block: ::core::option::Option<
        unsafe extern "C-unwind" fn(scan: TableScanDesc, scanstate: *mut SampleScanState) -> bool,
    >,
    pub scan_sample_next_tuple: ::core::option::Option<
        unsafe extern "C-unwind" fn(
            scan: TableScanDesc,
            scanstate: *mut SampleScanState,
            slot: *mut TupleTableSlot,
        ) -> bool,
    >,
}
impl Default for TableAmRoutine {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SHM_QUEUE {
    pub prev: *mut SHM_QUEUE,
    pub next: *mut SHM_QUEUE,
}
impl Default for SHM_QUEUE {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ShmemIndexEnt {
    pub key: [::core::ffi::c_char; 48usize],
    pub location: *mut ::core::ffi::c_void,
    pub size: Size,
    pub allocated_size: Size,
}
impl Default for ShmemIndexEnt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct shm_toc {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct shm_toc_estimator {
    pub space_for_chunks: Size,
    pub number_of_keys: Size,
}
pub type BulkInsertState = *mut BulkInsertStateData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HeapScanDescData {
    pub rs_base: TableScanDescData,
    pub rs_nblocks: BlockNumber,
    pub rs_startblock: BlockNumber,
    pub rs_numblocks: BlockNumber,
    pub rs_inited: bool,
    pub rs_cblock: BlockNumber,
    pub rs_cbuf: Buffer,
    pub rs_strategy: BufferAccessStrategy,
    pub rs_ctup: HeapTupleData,
    pub rs_parallelworkerdata: *mut ParallelBlockTableScanWorkerData,
    pub rs_cindex: ::core::ffi::c_int,
    pub rs_ntuples: ::core::ffi::c_int,
    pub rs_vistuples: [OffsetNumber; 291usize],
}
impl Default for HeapScanDescData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type HeapScanDesc = *mut HeapScanDescData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexFetchHeapData {
    pub xs_base: IndexFetchTableData,
    pub xs_cbuf: Buffer,
}
impl Default for IndexFetchHeapData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod HTSV_Result {
    pub type Type = ::core::ffi::c_uint;
    pub const HEAPTUPLE_DEAD: Type = 0;
    pub const HEAPTUPLE_LIVE: Type = 1;
    pub const HEAPTUPLE_RECENTLY_DEAD: Type = 2;
    pub const HEAPTUPLE_INSERT_IN_PROGRESS: Type = 3;
    pub const HEAPTUPLE_DELETE_IN_PROGRESS: Type = 4;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GlobalVisState {
    _unused: [u8; 0],
}
pub mod SyncRequestType {
    pub type Type = ::core::ffi::c_uint;
    pub const SYNC_REQUEST: Type = 0;
    pub const SYNC_UNLINK_REQUEST: Type = 1;
    pub const SYNC_FORGET_REQUEST: Type = 2;
    pub const SYNC_FILTER_REQUEST: Type = 3;
}
pub mod SyncRequestHandler {
    pub type Type = ::core::ffi::c_uint;
    pub const SYNC_HANDLER_MD: Type = 0;
    pub const SYNC_HANDLER_CLOG: Type = 1;
    pub const SYNC_HANDLER_COMMIT_TS: Type = 2;
    pub const SYNC_HANDLER_MULTIXACT_OFFSET: Type = 3;
    pub const SYNC_HANDLER_MULTIXACT_MEMBER: Type = 4;
    pub const SYNC_HANDLER_NONE: Type = 5;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FileTag {
    pub handler: int16,
    pub forknum: int16,
    pub rnode: RelFileNode,
    pub segno: uint32,
}
impl Default for FileTag {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod MultiXactStatus {
    pub type Type = ::core::ffi::c_uint;
    pub const MultiXactStatusForKeyShare: Type = 0;
    pub const MultiXactStatusForShare: Type = 1;
    pub const MultiXactStatusForNoKeyUpdate: Type = 2;
    pub const MultiXactStatusForUpdate: Type = 3;
    pub const MultiXactStatusNoKeyUpdate: Type = 4;
    pub const MultiXactStatusUpdate: Type = 5;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MultiXactMember {
    pub xid: TransactionId,
    pub status: MultiXactStatus::Type,
}
impl Default for MultiXactMember {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
pub struct xl_multixact_create {
    pub mid: MultiXactId,
    pub moff: MultiXactOffset,
    pub nmembers: int32,
    pub members: __IncompleteArrayField<MultiXactMember>,
}
impl Default for xl_multixact_create {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
pub struct xl_multixact_truncate {
    pub oldestMultiDB: Oid,
    pub startTruncOff: MultiXactId,
    pub endTruncOff: MultiXactId,
    pub startTruncMemb: MultiXactOffset,
    pub endTruncMemb: MultiXactOffset,
}
impl Default for xl_multixact_truncate {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod LWLockWaitState {
    pub type Type = ::core::ffi::c_uint;
    pub const LW_WS_NOT_WAITING: Type = 0;
    pub const LW_WS_WAITING: Type = 1;
    pub const LW_WS_PENDING_WAKEUP: Type = 2;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct LWLock {
    pub tranche: uint16,
    pub state: pg_atomic_uint32,
    pub waiters: proclist_head,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union LWLockPadded {
    pub lock: LWLock,
    pub pad: [::core::ffi::c_char; 128usize],
}
impl Default for LWLockPadded {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NamedLWLockTranche {
    pub trancheId: ::core::ffi::c_int,
    pub trancheName: *mut ::core::ffi::c_char,
}
impl Default for NamedLWLockTranche {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod LWLockMode {
    pub type Type = ::core::ffi::c_uint;
    pub const LW_EXCLUSIVE: Type = 0;
    pub const LW_SHARED: Type = 1;
    pub const LW_WAIT_UNTIL_FREE: Type = 2;
}
pub mod BuiltinTrancheIds {
    pub type Type = ::core::ffi::c_uint;
    pub const LWTRANCHE_XACT_BUFFER: Type = 48;
    pub const LWTRANCHE_COMMITTS_BUFFER: Type = 49;
    pub const LWTRANCHE_SUBTRANS_BUFFER: Type = 50;
    pub const LWTRANCHE_MULTIXACTOFFSET_BUFFER: Type = 51;
    pub const LWTRANCHE_MULTIXACTMEMBER_BUFFER: Type = 52;
    pub const LWTRANCHE_NOTIFY_BUFFER: Type = 53;
    pub const LWTRANCHE_SERIAL_BUFFER: Type = 54;
    pub const LWTRANCHE_WAL_INSERT: Type = 55;
    pub const LWTRANCHE_BUFFER_CONTENT: Type = 56;
    pub const LWTRANCHE_REPLICATION_ORIGIN_STATE: Type = 57;
    pub const LWTRANCHE_REPLICATION_SLOT_IO: Type = 58;
    pub const LWTRANCHE_LOCK_FASTPATH: Type = 59;
    pub const LWTRANCHE_BUFFER_MAPPING: Type = 60;
    pub const LWTRANCHE_LOCK_MANAGER: Type = 61;
    pub const LWTRANCHE_PREDICATE_LOCK_MANAGER: Type = 62;
    pub const LWTRANCHE_PARALLEL_HASH_JOIN: Type = 63;
    pub const LWTRANCHE_PARALLEL_QUERY_DSA: Type = 64;
    pub const LWTRANCHE_PER_SESSION_DSA: Type = 65;
    pub const LWTRANCHE_PER_SESSION_RECORD_TYPE: Type = 66;
    pub const LWTRANCHE_PER_SESSION_RECORD_TYPMOD: Type = 67;
    pub const LWTRANCHE_SHARED_TUPLESTORE: Type = 68;
    pub const LWTRANCHE_SHARED_TIDBITMAP: Type = 69;
    pub const LWTRANCHE_PARALLEL_APPEND: Type = 70;
    pub const LWTRANCHE_PER_XACT_PREDICATE_LIST: Type = 71;
    pub const LWTRANCHE_PGSTATS_DSA: Type = 72;
    pub const LWTRANCHE_PGSTATS_HASH: Type = 73;
    pub const LWTRANCHE_PGSTATS_DATA: Type = 74;
    pub const LWTRANCHE_FIRST_USER_DEFINED: Type = 75;
}
pub type LWLockId = *mut LWLock;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PROC_QUEUE {
    pub links: SHM_QUEUE,
    pub size: ::core::ffi::c_int,
}
impl Default for PROC_QUEUE {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct VirtualTransactionId {
    pub backendId: BackendId,
    pub localTransactionId: LocalTransactionId,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LockMethodData {
    pub numLockModes: ::core::ffi::c_int,
    pub conflictTab: *const LOCKMASK,
    pub lockModeNames: *const *const ::core::ffi::c_char,
    pub trace_flag: *const bool,
}
impl Default for LockMethodData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type LockMethod = *const LockMethodData;
pub type LOCKMETHODID = uint16;
pub mod LockTagType {
    pub type Type = ::core::ffi::c_uint;
    pub const LOCKTAG_RELATION: Type = 0;
    pub const LOCKTAG_RELATION_EXTEND: Type = 1;
    pub const LOCKTAG_DATABASE_FROZEN_IDS: Type = 2;
    pub const LOCKTAG_PAGE: Type = 3;
    pub const LOCKTAG_TUPLE: Type = 4;
    pub const LOCKTAG_TRANSACTION: Type = 5;
    pub const LOCKTAG_VIRTUALTRANSACTION: Type = 6;
    pub const LOCKTAG_SPECULATIVE_TOKEN: Type = 7;
    pub const LOCKTAG_OBJECT: Type = 8;
    pub const LOCKTAG_USERLOCK: Type = 9;
    pub const LOCKTAG_ADVISORY: Type = 10;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct LOCKTAG {
    pub locktag_field1: uint32,
    pub locktag_field2: uint32,
    pub locktag_field3: uint32,
    pub locktag_field4: uint16,
    pub locktag_type: uint8,
    pub locktag_lockmethodid: uint8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LOCK {
    pub tag: LOCKTAG,
    pub grantMask: LOCKMASK,
    pub waitMask: LOCKMASK,
    pub procLocks: SHM_QUEUE,
    pub waitProcs: PROC_QUEUE,
    pub requested: [::core::ffi::c_int; 10usize],
    pub nRequested: ::core::ffi::c_int,
    pub granted: [::core::ffi::c_int; 10usize],
    pub nGranted: ::core::ffi::c_int,
}
impl Default for LOCK {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PROCLOCKTAG {
    pub myLock: *mut LOCK,
    pub myProc: *mut PGPROC,
}
impl Default for PROCLOCKTAG {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PROCLOCK {
    pub tag: PROCLOCKTAG,
    pub groupLeader: *mut PGPROC,
    pub holdMask: LOCKMASK,
    pub releaseMask: LOCKMASK,
    pub lockLink: SHM_QUEUE,
    pub procLink: SHM_QUEUE,
}
impl Default for PROCLOCK {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct LOCALLOCKTAG {
    pub lock: LOCKTAG,
    pub mode: LOCKMODE,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LOCALLOCKOWNER {
    pub owner: *mut ResourceOwnerData,
    pub nLocks: int64,
}
impl Default for LOCALLOCKOWNER {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LOCALLOCK {
    pub tag: LOCALLOCKTAG,
    pub hashcode: uint32,
    pub lock: *mut LOCK,
    pub proclock: *mut PROCLOCK,
    pub nLocks: int64,
    pub numLockOwners: ::core::ffi::c_int,
    pub maxLockOwners: ::core::ffi::c_int,
    pub lockOwners: *mut LOCALLOCKOWNER,
    pub holdsStrongLockCount: bool,
    pub lockCleared: bool,
}
impl Default for LOCALLOCK {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct LockInstanceData {
    pub locktag: LOCKTAG,
    pub holdMask: LOCKMASK,
    pub waitLockMode: LOCKMODE,
    pub backend: BackendId,
    pub lxid: LocalTransactionId,
    pub waitStart: TimestampTz,
    pub pid: ::core::ffi::c_int,
    pub leaderPid: ::core::ffi::c_int,
    pub fastpath: bool,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LockData {
    pub nelements: ::core::ffi::c_int,
    pub locks: *mut LockInstanceData,
}
impl Default for LockData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct BlockedProcData {
    pub pid: ::core::ffi::c_int,
    pub first_lock: ::core::ffi::c_int,
    pub num_locks: ::core::ffi::c_int,
    pub first_waiter: ::core::ffi::c_int,
    pub num_waiters: ::core::ffi::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlockedProcsData {
    pub procs: *mut BlockedProcData,
    pub locks: *mut LockInstanceData,
    pub waiter_pids: *mut ::core::ffi::c_int,
    pub nprocs: ::core::ffi::c_int,
    pub maxprocs: ::core::ffi::c_int,
    pub nlocks: ::core::ffi::c_int,
    pub maxlocks: ::core::ffi::c_int,
    pub npids: ::core::ffi::c_int,
    pub maxpids: ::core::ffi::c_int,
}
impl Default for BlockedProcsData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod LockAcquireResult {
    pub type Type = ::core::ffi::c_uint;
    pub const LOCKACQUIRE_NOT_AVAIL: Type = 0;
    pub const LOCKACQUIRE_OK: Type = 1;
    pub const LOCKACQUIRE_ALREADY_HELD: Type = 2;
    pub const LOCKACQUIRE_ALREADY_CLEAR: Type = 3;
}
pub mod DeadLockState {
    pub type Type = ::core::ffi::c_uint;
    pub const DS_NOT_YET_CHECKED: Type = 0;
    pub const DS_NO_DEADLOCK: Type = 1;
    pub const DS_SOFT_DEADLOCK: Type = 2;
    pub const DS_HARD_DEADLOCK: Type = 3;
    pub const DS_BLOCKED_BY_AUTOVACUUM: Type = 4;
}
pub mod relopt_type {
    pub type Type = ::core::ffi::c_uint;
    pub const RELOPT_TYPE_BOOL: Type = 0;
    pub const RELOPT_TYPE_INT: Type = 1;
    pub const RELOPT_TYPE_REAL: Type = 2;
    pub const RELOPT_TYPE_ENUM: Type = 3;
    pub const RELOPT_TYPE_STRING: Type = 4;
}
pub mod relopt_kind {
    pub type Type = ::core::ffi::c_uint;
    pub const RELOPT_KIND_LOCAL: Type = 0;
    pub const RELOPT_KIND_HEAP: Type = 1;
    pub const RELOPT_KIND_TOAST: Type = 2;
    pub const RELOPT_KIND_BTREE: Type = 4;
    pub const RELOPT_KIND_HASH: Type = 8;
    pub const RELOPT_KIND_GIN: Type = 16;
    pub const RELOPT_KIND_GIST: Type = 32;
    pub const RELOPT_KIND_ATTRIBUTE: Type = 64;
    pub const RELOPT_KIND_TABLESPACE: Type = 128;
    pub const RELOPT_KIND_SPGIST: Type = 256;
    pub const RELOPT_KIND_VIEW: Type = 512;
    pub const RELOPT_KIND_BRIN: Type = 1024;
    pub const RELOPT_KIND_PARTITIONED: Type = 2048;
    pub const RELOPT_KIND_LAST_DEFAULT: Type = 2048;
    pub const RELOPT_KIND_MAX: Type = 1073741824;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct relopt_gen {
    pub name: *const ::core::ffi::c_char,
    pub desc: *const ::core::ffi::c_char,
    pub kinds: bits32,
    pub lockmode: LOCKMODE,
    pub namelen: ::core::ffi::c_int,
    pub type_: relopt_type::Type,
}
impl Default for relopt_gen {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct relopt_value {
    pub gen: *mut relopt_gen,
    pub isset: bool,
    pub values: relopt_value__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union relopt_value__bindgen_ty_1 {
    pub bool_val: bool,
    pub int_val: ::core::ffi::c_int,
    pub real_val: f64,
    pub enum_val: ::core::ffi::c_int,
    pub string_val: *mut ::core::ffi::c_char,
}
impl Default for relopt_value__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for relopt_value {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct relopt_bool {
    pub gen: relopt_gen,
    pub default_val: bool,
}
impl Default for relopt_bool {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct relopt_int {
    pub gen: relopt_gen,
    pub default_val: ::core::ffi::c_int,
    pub min: ::core::ffi::c_int,
    pub max: ::core::ffi::c_int,
}
impl Default for relopt_int {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct relopt_real {
    pub gen: relopt_gen,
    pub default_val: f64,
    pub min: f64,
    pub max: f64,
}
impl Default for relopt_real {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct relopt_enum_elt_def {
    pub string_val: *const ::core::ffi::c_char,
    pub symbol_val: ::core::ffi::c_int,
}
impl Default for relopt_enum_elt_def {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct relopt_enum {
    pub gen: relopt_gen,
    pub members: *mut relopt_enum_elt_def,
    pub default_val: ::core::ffi::c_int,
    pub detailmsg: *const ::core::ffi::c_char,
}
impl Default for relopt_enum {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type validate_string_relopt =
    ::core::option::Option<unsafe extern "C-unwind" fn(value: *const ::core::ffi::c_char)>;
pub type fill_string_relopt = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        value: *const ::core::ffi::c_char,
        ptr: *mut ::core::ffi::c_void,
    ) -> Size,
>;
pub type relopts_validator = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        parsed_options: *mut ::core::ffi::c_void,
        vals: *mut relopt_value,
        nvals: ::core::ffi::c_int,
    ),
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct relopt_string {
    pub gen: relopt_gen,
    pub default_len: ::core::ffi::c_int,
    pub default_isnull: bool,
    pub validate_cb: validate_string_relopt,
    pub fill_cb: fill_string_relopt,
    pub default_val: *mut ::core::ffi::c_char,
}
impl Default for relopt_string {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct relopt_parse_elt {
    pub optname: *const ::core::ffi::c_char,
    pub opttype: relopt_type::Type,
    pub offset: ::core::ffi::c_int,
}
impl Default for relopt_parse_elt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct local_relopt {
    pub option: *mut relopt_gen,
    pub offset: ::core::ffi::c_int,
}
impl Default for local_relopt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct local_relopts {
    pub options: *mut List,
    pub validators: *mut List,
    pub relopt_struct_size: Size,
}
impl Default for local_relopts {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
pub struct CheckPoint {
    pub redo: XLogRecPtr,
    pub ThisTimeLineID: TimeLineID,
    pub PrevTimeLineID: TimeLineID,
    pub fullPageWrites: bool,
    pub nextXid: FullTransactionId,
    pub nextOid: Oid,
    pub nextMulti: MultiXactId,
    pub nextMultiOffset: MultiXactOffset,
    pub oldestXid: TransactionId,
    pub oldestXidDB: Oid,
    pub oldestMulti: MultiXactId,
    pub oldestMultiDB: Oid,
    pub time: pg_time_t,
    pub oldestCommitTsXid: TransactionId,
    pub newestCommitTsXid: TransactionId,
    pub oldestActiveXid: TransactionId,
}
impl Default for CheckPoint {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod DBState {
    pub type Type = ::core::ffi::c_uint;
    pub const DB_STARTUP: Type = 0;
    pub const DB_SHUTDOWNED: Type = 1;
    pub const DB_SHUTDOWNED_IN_RECOVERY: Type = 2;
    pub const DB_SHUTDOWNING: Type = 3;
    pub const DB_IN_CRASH_RECOVERY: Type = 4;
    pub const DB_IN_ARCHIVE_RECOVERY: Type = 5;
    pub const DB_IN_PRODUCTION: Type = 6;
}
#[repr(C)]
pub struct ControlFileData {
    pub system_identifier: uint64,
    pub pg_control_version: uint32,
    pub catalog_version_no: uint32,
    pub state: DBState::Type,
    pub time: pg_time_t,
    pub checkPoint: XLogRecPtr,
    pub checkPointCopy: CheckPoint,
    pub unloggedLSN: XLogRecPtr,
    pub minRecoveryPoint: XLogRecPtr,
    pub minRecoveryPointTLI: TimeLineID,
    pub backupStartPoint: XLogRecPtr,
    pub backupEndPoint: XLogRecPtr,
    pub backupEndRequired: bool,
    pub wal_level: ::core::ffi::c_int,
    pub wal_log_hints: bool,
    pub MaxConnections: ::core::ffi::c_int,
    pub max_worker_processes: ::core::ffi::c_int,
    pub max_wal_senders: ::core::ffi::c_int,
    pub max_prepared_xacts: ::core::ffi::c_int,
    pub max_locks_per_xact: ::core::ffi::c_int,
    pub track_commit_timestamp: bool,
    pub maxAlign: uint32,
    pub floatFormat: f64,
    pub blcksz: uint32,
    pub relseg_size: uint32,
    pub xlog_blcksz: uint32,
    pub xlog_seg_size: uint32,
    pub nameDataLen: uint32,
    pub indexMaxKeys: uint32,
    pub toast_max_chunk_size: uint32,
    pub loblksize: uint32,
    pub float8ByVal: bool,
    pub data_checksum_version: uint32,
    pub mock_authentication_nonce: [::core::ffi::c_char; 32usize],
    pub crc: pg_crc32c,
}
impl Default for ControlFileData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod RecoveryTargetType {
    pub type Type = ::core::ffi::c_uint;
    pub const RECOVERY_TARGET_UNSET: Type = 0;
    pub const RECOVERY_TARGET_XID: Type = 1;
    pub const RECOVERY_TARGET_TIME: Type = 2;
    pub const RECOVERY_TARGET_NAME: Type = 3;
    pub const RECOVERY_TARGET_LSN: Type = 4;
    pub const RECOVERY_TARGET_IMMEDIATE: Type = 5;
}
pub mod RecoveryTargetTimeLineGoal {
    pub type Type = ::core::ffi::c_uint;
    pub const RECOVERY_TARGET_TIMELINE_CONTROLFILE: Type = 0;
    pub const RECOVERY_TARGET_TIMELINE_LATEST: Type = 1;
    pub const RECOVERY_TARGET_TIMELINE_NUMERIC: Type = 2;
}
pub mod RecoveryPauseState {
    pub type Type = ::core::ffi::c_uint;
    pub const RECOVERY_NOT_PAUSED: Type = 0;
    pub const RECOVERY_PAUSE_REQUESTED: Type = 1;
    pub const RECOVERY_PAUSED: Type = 2;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct EndOfWalRecoveryInfo {
    pub lastRec: XLogRecPtr,
    pub lastRecTLI: TimeLineID,
    pub endOfLog: XLogRecPtr,
    pub endOfLogTLI: TimeLineID,
    pub lastPageBeginPtr: XLogRecPtr,
    pub lastPage: *mut ::core::ffi::c_char,
    pub abortedRecPtr: XLogRecPtr,
    pub missingContrecPtr: XLogRecPtr,
    pub recoveryStopReason: *mut ::core::ffi::c_char,
    pub standby_signal_file_found: bool,
    pub recovery_signal_file_found: bool,
}
impl Default for EndOfWalRecoveryInfo {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type ResourceOwner = *mut ResourceOwnerData;
pub mod ResourceReleasePhase {
    pub type Type = ::core::ffi::c_uint;
    pub const RESOURCE_RELEASE_BEFORE_LOCKS: Type = 0;
    pub const RESOURCE_RELEASE_LOCKS: Type = 1;
    pub const RESOURCE_RELEASE_AFTER_LOCKS: Type = 2;
}
pub type ResourceReleaseCallback = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        phase: ResourceReleasePhase::Type,
        isCommit: bool,
        isTopLevel: bool,
        arg: *mut ::core::ffi::c_void,
    ),
>;
pub type Block = *mut ::core::ffi::c_void;
pub mod BufferAccessStrategyType {
    pub type Type = ::core::ffi::c_uint;
    pub const BAS_NORMAL: Type = 0;
    pub const BAS_BULKREAD: Type = 1;
    pub const BAS_BULKWRITE: Type = 2;
    pub const BAS_VACUUM: Type = 3;
}
pub mod ReadBufferMode {
    pub type Type = ::core::ffi::c_uint;
    pub const RBM_NORMAL: Type = 0;
    pub const RBM_ZERO_AND_LOCK: Type = 1;
    pub const RBM_ZERO_AND_CLEANUP_LOCK: Type = 2;
    pub const RBM_ZERO_ON_ERROR: Type = 3;
    pub const RBM_NORMAL_NO_LOG: Type = 4;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct PrefetchBufferResult {
    pub recent_buffer: Buffer,
    pub initiated_io: bool,
}
pub mod HotStandbyState {
    pub type Type = ::core::ffi::c_uint;
    pub const STANDBY_DISABLED: Type = 0;
    pub const STANDBY_INITIALIZED: Type = 1;
    pub const STANDBY_SNAPSHOT_PENDING: Type = 2;
    pub const STANDBY_SNAPSHOT_READY: Type = 3;
}
pub mod XLogRedoAction {
    pub type Type = ::core::ffi::c_uint;
    pub const BLK_NEEDS_REDO: Type = 0;
    pub const BLK_DONE: Type = 1;
    pub const BLK_RESTORED: Type = 2;
    pub const BLK_NOTFOUND: Type = 3;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ReadLocalXLogPageNoWaitPrivate {
    pub end_of_wal: bool,
}
pub mod DependencyType {
    pub type Type = ::core::ffi::c_uint;
    pub const DEPENDENCY_NORMAL: Type = 110;
    pub const DEPENDENCY_AUTO: Type = 97;
    pub const DEPENDENCY_INTERNAL: Type = 105;
    pub const DEPENDENCY_PARTITION_PRI: Type = 80;
    pub const DEPENDENCY_PARTITION_SEC: Type = 83;
    pub const DEPENDENCY_EXTENSION: Type = 101;
    pub const DEPENDENCY_AUTO_EXTENSION: Type = 120;
}
pub mod SharedDependencyType {
    pub type Type = ::core::ffi::c_uint;
    pub const SHARED_DEPENDENCY_OWNER: Type = 111;
    pub const SHARED_DEPENDENCY_ACL: Type = 97;
    pub const SHARED_DEPENDENCY_POLICY: Type = 114;
    pub const SHARED_DEPENDENCY_TABLESPACE: Type = 116;
    pub const SHARED_DEPENDENCY_INVALID: Type = 0;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ObjectAddresses {
    _unused: [u8; 0],
}
pub mod ObjectClass {
    pub type Type = ::core::ffi::c_uint;
    pub const OCLASS_CLASS: Type = 0;
    pub const OCLASS_PROC: Type = 1;
    pub const OCLASS_TYPE: Type = 2;
    pub const OCLASS_CAST: Type = 3;
    pub const OCLASS_COLLATION: Type = 4;
    pub const OCLASS_CONSTRAINT: Type = 5;
    pub const OCLASS_CONVERSION: Type = 6;
    pub const OCLASS_DEFAULT: Type = 7;
    pub const OCLASS_LANGUAGE: Type = 8;
    pub const OCLASS_LARGEOBJECT: Type = 9;
    pub const OCLASS_OPERATOR: Type = 10;
    pub const OCLASS_OPCLASS: Type = 11;
    pub const OCLASS_OPFAMILY: Type = 12;
    pub const OCLASS_AM: Type = 13;
    pub const OCLASS_AMOP: Type = 14;
    pub const OCLASS_AMPROC: Type = 15;
    pub const OCLASS_REWRITE: Type = 16;
    pub const OCLASS_TRIGGER: Type = 17;
    pub const OCLASS_SCHEMA: Type = 18;
    pub const OCLASS_STATISTIC_EXT: Type = 19;
    pub const OCLASS_TSPARSER: Type = 20;
    pub const OCLASS_TSDICT: Type = 21;
    pub const OCLASS_TSTEMPLATE: Type = 22;
    pub const OCLASS_TSCONFIG: Type = 23;
    pub const OCLASS_ROLE: Type = 24;
    pub const OCLASS_DATABASE: Type = 25;
    pub const OCLASS_TBLSPACE: Type = 26;
    pub const OCLASS_FDW: Type = 27;
    pub const OCLASS_FOREIGN_SERVER: Type = 28;
    pub const OCLASS_USER_MAPPING: Type = 29;
    pub const OCLASS_DEFACL: Type = 30;
    pub const OCLASS_EXTENSION: Type = 31;
    pub const OCLASS_EVENT_TRIGGER: Type = 32;
    pub const OCLASS_PARAMETER_ACL: Type = 33;
    pub const OCLASS_POLICY: Type = 34;
    pub const OCLASS_PUBLICATION: Type = 35;
    pub const OCLASS_PUBLICATION_NAMESPACE: Type = 36;
    pub const OCLASS_PUBLICATION_REL: Type = 37;
    pub const OCLASS_SUBSCRIPTION: Type = 38;
    pub const OCLASS_TRANSFORM: Type = 39;
}
pub mod IndexStateFlagsAction {
    pub type Type = ::core::ffi::c_uint;
    pub const INDEX_CREATE_SET_READY: Type = 0;
    pub const INDEX_CREATE_SET_VALID: Type = 1;
    pub const INDEX_DROP_CLEAR_VALID: Type = 2;
    pub const INDEX_DROP_SET_DEAD: Type = 3;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ReindexParams {
    pub options: bits32,
    pub tablespaceOid: Oid,
}
impl Default for ReindexParams {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ValidateIndexState {
    pub tuplesort: *mut Tuplesortstate,
    pub htups: f64,
    pub itups: f64,
    pub tups_inserted: f64,
}
impl Default for ValidateIndexState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type CatalogIndexState = *mut ResultRelInfo;
#[repr(C)]
#[derive(Debug)]
pub struct _FuncCandidateList {
    pub next: *mut _FuncCandidateList,
    pub pathpos: ::core::ffi::c_int,
    pub oid: Oid,
    pub nominalnargs: ::core::ffi::c_int,
    pub nargs: ::core::ffi::c_int,
    pub nvargs: ::core::ffi::c_int,
    pub ndargs: ::core::ffi::c_int,
    pub argnumbers: *mut ::core::ffi::c_int,
    pub args: __IncompleteArrayField<Oid>,
}
impl Default for _FuncCandidateList {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type FuncCandidateList = *mut _FuncCandidateList;
pub mod TempNamespaceStatus {
    pub type Type = ::core::ffi::c_uint;
    pub const TEMP_NAMESPACE_NOT_TEMP: Type = 0;
    pub const TEMP_NAMESPACE_IDLE: Type = 1;
    pub const TEMP_NAMESPACE_IN_USE: Type = 2;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OverrideSearchPath {
    pub schemas: *mut List,
    pub addCatalog: bool,
    pub addTemp: bool,
    pub generation: uint64,
}
impl Default for OverrideSearchPath {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod RVROption {
    pub type Type = ::core::ffi::c_uint;
    pub const RVR_MISSING_OK: Type = 1;
    pub const RVR_NOWAIT: Type = 2;
    pub const RVR_SKIP_LOCKED: Type = 4;
}
pub type RangeVarGetRelidCallback = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        relation: *const RangeVar,
        relId: Oid,
        oldRelId: Oid,
        callback_arg: *mut ::core::ffi::c_void,
    ),
>;
pub mod ObjectAccessType {
    pub type Type = ::core::ffi::c_uint;
    pub const OAT_POST_CREATE: Type = 0;
    pub const OAT_DROP: Type = 1;
    pub const OAT_POST_ALTER: Type = 2;
    pub const OAT_NAMESPACE_SEARCH: Type = 3;
    pub const OAT_FUNCTION_EXECUTE: Type = 4;
    pub const OAT_TRUNCATE: Type = 5;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ObjectAccessPostCreate {
    pub is_internal: bool,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ObjectAccessDrop {
    pub dropflags: ::core::ffi::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ObjectAccessPostAlter {
    pub auxiliary_id: Oid,
    pub is_internal: bool,
}
impl Default for ObjectAccessPostAlter {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ObjectAccessNamespaceSearch {
    pub ereport_on_violation: bool,
    pub result: bool,
}
pub type object_access_hook_type = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        access: ObjectAccessType::Type,
        classId: Oid,
        objectId: Oid,
        subId: ::core::ffi::c_int,
        arg: *mut ::core::ffi::c_void,
    ),
>;
pub type object_access_hook_type_str = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        access: ObjectAccessType::Type,
        classId: Oid,
        objectStr: *const ::core::ffi::c_char,
        subId: ::core::ffi::c_int,
        arg: *mut ::core::ffi::c_void,
    ),
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FormData_pg_am {
    pub oid: Oid,
    pub amname: NameData,
    pub amhandler: regproc,
    pub amtype: ::core::ffi::c_char,
}
impl Default for FormData_pg_am {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Form_pg_am = *mut FormData_pg_am;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FormData_pg_amop {
    pub oid: Oid,
    pub amopfamily: Oid,
    pub amoplefttype: Oid,
    pub amoprighttype: Oid,
    pub amopstrategy: int16,
    pub amoppurpose: ::core::ffi::c_char,
    pub amopopr: Oid,
    pub amopmethod: Oid,
    pub amopsortfamily: Oid,
}
impl Default for FormData_pg_amop {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Form_pg_amop = *mut FormData_pg_amop;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FormData_pg_amproc {
    pub oid: Oid,
    pub amprocfamily: Oid,
    pub amproclefttype: Oid,
    pub amprocrighttype: Oid,
    pub amprocnum: int16,
    pub amproc: regproc,
}
impl Default for FormData_pg_amproc {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Form_pg_amproc = *mut FormData_pg_amproc;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FormData_pg_authid {
    pub oid: Oid,
    pub rolname: NameData,
    pub rolsuper: bool,
    pub rolinherit: bool,
    pub rolcreaterole: bool,
    pub rolcreatedb: bool,
    pub rolcanlogin: bool,
    pub rolreplication: bool,
    pub rolbypassrls: bool,
    pub rolconnlimit: int32,
}
impl Default for FormData_pg_authid {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Form_pg_authid = *mut FormData_pg_authid;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FormData_pg_collation {
    pub oid: Oid,
    pub collname: NameData,
    pub collnamespace: Oid,
    pub collowner: Oid,
    pub collprovider: ::core::ffi::c_char,
    pub collisdeterministic: bool,
    pub collencoding: int32,
}
impl Default for FormData_pg_collation {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Form_pg_collation = *mut FormData_pg_collation;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FormData_pg_database {
    pub oid: Oid,
    pub datname: NameData,
    pub datdba: Oid,
    pub encoding: int32,
    pub datlocprovider: ::core::ffi::c_char,
    pub datistemplate: bool,
    pub datallowconn: bool,
    pub datconnlimit: int32,
    pub datfrozenxid: TransactionId,
    pub datminmxid: TransactionId,
    pub dattablespace: Oid,
}
impl Default for FormData_pg_database {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Form_pg_database = *mut FormData_pg_database;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FormData_pg_enum {
    pub oid: Oid,
    pub enumtypid: Oid,
    pub enumsortorder: float4,
    pub enumlabel: NameData,
}
impl Default for FormData_pg_enum {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Form_pg_enum = *mut FormData_pg_enum;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FormData_pg_extension {
    pub oid: Oid,
    pub extname: NameData,
    pub extowner: Oid,
    pub extnamespace: Oid,
    pub extrelocatable: bool,
}
impl Default for FormData_pg_extension {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Form_pg_extension = *mut FormData_pg_extension;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FormData_pg_foreign_data_wrapper {
    pub oid: Oid,
    pub fdwname: NameData,
    pub fdwowner: Oid,
    pub fdwhandler: Oid,
    pub fdwvalidator: Oid,
}
impl Default for FormData_pg_foreign_data_wrapper {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Form_pg_foreign_data_wrapper = *mut FormData_pg_foreign_data_wrapper;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FormData_pg_foreign_server {
    pub oid: Oid,
    pub srvname: NameData,
    pub srvowner: Oid,
    pub srvfdw: Oid,
}
impl Default for FormData_pg_foreign_server {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Form_pg_foreign_server = *mut FormData_pg_foreign_server;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FormData_pg_foreign_table {
    pub ftrelid: Oid,
    pub ftserver: Oid,
}
impl Default for FormData_pg_foreign_table {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Form_pg_foreign_table = *mut FormData_pg_foreign_table;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FormData_pg_operator {
    pub oid: Oid,
    pub oprname: NameData,
    pub oprnamespace: Oid,
    pub oprowner: Oid,
    pub oprkind: ::core::ffi::c_char,
    pub oprcanmerge: bool,
    pub oprcanhash: bool,
    pub oprleft: Oid,
    pub oprright: Oid,
    pub oprresult: Oid,
    pub oprcom: Oid,
    pub oprnegate: Oid,
    pub oprcode: regproc,
    pub oprrest: regproc,
    pub oprjoin: regproc,
}
impl Default for FormData_pg_operator {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Form_pg_operator = *mut FormData_pg_operator;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FormData_pg_opclass {
    pub oid: Oid,
    pub opcmethod: Oid,
    pub opcname: NameData,
    pub opcnamespace: Oid,
    pub opcowner: Oid,
    pub opcfamily: Oid,
    pub opcintype: Oid,
    pub opcdefault: bool,
    pub opckeytype: Oid,
}
impl Default for FormData_pg_opclass {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Form_pg_opclass = *mut FormData_pg_opclass;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FormData_pg_opfamily {
    pub oid: Oid,
    pub opfmethod: Oid,
    pub opfname: NameData,
    pub opfnamespace: Oid,
    pub opfowner: Oid,
}
impl Default for FormData_pg_opfamily {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Form_pg_opfamily = *mut FormData_pg_opfamily;
#[repr(C)]
#[derive(Debug)]
pub struct FormData_pg_proc {
    pub oid: Oid,
    pub proname: NameData,
    pub pronamespace: Oid,
    pub proowner: Oid,
    pub prolang: Oid,
    pub procost: float4,
    pub prorows: float4,
    pub provariadic: Oid,
    pub prosupport: regproc,
    pub prokind: ::core::ffi::c_char,
    pub prosecdef: bool,
    pub proleakproof: bool,
    pub proisstrict: bool,
    pub proretset: bool,
    pub provolatile: ::core::ffi::c_char,
    pub proparallel: ::core::ffi::c_char,
    pub pronargs: int16,
    pub pronargdefaults: int16,
    pub prorettype: Oid,
    pub proargtypes: oidvector,
}
impl Default for FormData_pg_proc {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Form_pg_proc = *mut FormData_pg_proc;
pub mod ParseExprKind {
    pub type Type = ::core::ffi::c_uint;
    pub const EXPR_KIND_NONE: Type = 0;
    pub const EXPR_KIND_OTHER: Type = 1;
    pub const EXPR_KIND_JOIN_ON: Type = 2;
    pub const EXPR_KIND_JOIN_USING: Type = 3;
    pub const EXPR_KIND_FROM_SUBSELECT: Type = 4;
    pub const EXPR_KIND_FROM_FUNCTION: Type = 5;
    pub const EXPR_KIND_WHERE: Type = 6;
    pub const EXPR_KIND_HAVING: Type = 7;
    pub const EXPR_KIND_FILTER: Type = 8;
    pub const EXPR_KIND_WINDOW_PARTITION: Type = 9;
    pub const EXPR_KIND_WINDOW_ORDER: Type = 10;
    pub const EXPR_KIND_WINDOW_FRAME_RANGE: Type = 11;
    pub const EXPR_KIND_WINDOW_FRAME_ROWS: Type = 12;
    pub const EXPR_KIND_WINDOW_FRAME_GROUPS: Type = 13;
    pub const EXPR_KIND_SELECT_TARGET: Type = 14;
    pub const EXPR_KIND_INSERT_TARGET: Type = 15;
    pub const EXPR_KIND_UPDATE_SOURCE: Type = 16;
    pub const EXPR_KIND_UPDATE_TARGET: Type = 17;
    pub const EXPR_KIND_MERGE_WHEN: Type = 18;
    pub const EXPR_KIND_GROUP_BY: Type = 19;
    pub const EXPR_KIND_ORDER_BY: Type = 20;
    pub const EXPR_KIND_DISTINCT_ON: Type = 21;
    pub const EXPR_KIND_LIMIT: Type = 22;
    pub const EXPR_KIND_OFFSET: Type = 23;
    pub const EXPR_KIND_RETURNING: Type = 24;
    pub const EXPR_KIND_VALUES: Type = 25;
    pub const EXPR_KIND_VALUES_SINGLE: Type = 26;
    pub const EXPR_KIND_CHECK_CONSTRAINT: Type = 27;
    pub const EXPR_KIND_DOMAIN_CHECK: Type = 28;
    pub const EXPR_KIND_COLUMN_DEFAULT: Type = 29;
    pub const EXPR_KIND_FUNCTION_DEFAULT: Type = 30;
    pub const EXPR_KIND_INDEX_EXPRESSION: Type = 31;
    pub const EXPR_KIND_INDEX_PREDICATE: Type = 32;
    pub const EXPR_KIND_STATS_EXPRESSION: Type = 33;
    pub const EXPR_KIND_ALTER_COL_TRANSFORM: Type = 34;
    pub const EXPR_KIND_EXECUTE_PARAMETER: Type = 35;
    pub const EXPR_KIND_TRIGGER_WHEN: Type = 36;
    pub const EXPR_KIND_POLICY: Type = 37;
    pub const EXPR_KIND_PARTITION_BOUND: Type = 38;
    pub const EXPR_KIND_PARTITION_EXPRESSION: Type = 39;
    pub const EXPR_KIND_CALL_ARGUMENT: Type = 40;
    pub const EXPR_KIND_COPY_WHERE: Type = 41;
    pub const EXPR_KIND_GENERATED_COLUMN: Type = 42;
    pub const EXPR_KIND_CYCLE_MARK: Type = 43;
}
pub type PreParseColumnRefHook = ::core::option::Option<
    unsafe extern "C-unwind" fn(pstate: *mut ParseState, cref: *mut ColumnRef) -> *mut Node,
>;
pub type PostParseColumnRefHook = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        pstate: *mut ParseState,
        cref: *mut ColumnRef,
        var: *mut Node,
    ) -> *mut Node,
>;
pub type ParseParamRefHook = ::core::option::Option<
    unsafe extern "C-unwind" fn(pstate: *mut ParseState, pref: *mut ParamRef) -> *mut Node,
>;
pub type CoerceParamHook = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        pstate: *mut ParseState,
        param: *mut Param,
        targetTypeId: Oid,
        targetTypeMod: int32,
        location: ::core::ffi::c_int,
    ) -> *mut Node,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ParseState {
    pub parentParseState: *mut ParseState,
    pub p_sourcetext: *const ::core::ffi::c_char,
    pub p_rtable: *mut List,
    pub p_joinexprs: *mut List,
    pub p_joinlist: *mut List,
    pub p_namespace: *mut List,
    pub p_lateral_active: bool,
    pub p_ctenamespace: *mut List,
    pub p_future_ctes: *mut List,
    pub p_parent_cte: *mut CommonTableExpr,
    pub p_target_relation: Relation,
    pub p_target_nsitem: *mut ParseNamespaceItem,
    pub p_is_insert: bool,
    pub p_windowdefs: *mut List,
    pub p_expr_kind: ParseExprKind::Type,
    pub p_next_resno: ::core::ffi::c_int,
    pub p_multiassign_exprs: *mut List,
    pub p_locking_clause: *mut List,
    pub p_locked_from_parent: bool,
    pub p_resolve_unknowns: bool,
    pub p_queryEnv: *mut QueryEnvironment,
    pub p_hasAggs: bool,
    pub p_hasWindowFuncs: bool,
    pub p_hasTargetSRFs: bool,
    pub p_hasSubLinks: bool,
    pub p_hasModifyingCTE: bool,
    pub p_last_srf: *mut Node,
    pub p_pre_columnref_hook: PreParseColumnRefHook,
    pub p_post_columnref_hook: PostParseColumnRefHook,
    pub p_paramref_hook: ParseParamRefHook,
    pub p_coerce_param_hook: CoerceParamHook,
    pub p_ref_hook_state: *mut ::core::ffi::c_void,
}
impl Default for ParseState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ParseNamespaceItem {
    pub p_names: *mut Alias,
    pub p_rte: *mut RangeTblEntry,
    pub p_rtindex: ::core::ffi::c_int,
    pub p_nscolumns: *mut ParseNamespaceColumn,
    pub p_rel_visible: bool,
    pub p_cols_visible: bool,
    pub p_lateral_only: bool,
    pub p_lateral_ok: bool,
}
impl Default for ParseNamespaceItem {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ParseNamespaceColumn {
    pub p_varno: Index,
    pub p_varattno: AttrNumber,
    pub p_vartype: Oid,
    pub p_vartypmod: int32,
    pub p_varcollid: Oid,
    pub p_varnosyn: Index,
    pub p_varattnosyn: AttrNumber,
    pub p_dontexpand: bool,
}
impl Default for ParseNamespaceColumn {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ParseCallbackState {
    pub pstate: *mut ParseState,
    pub location: ::core::ffi::c_int,
    pub errcallback: ErrorContextCallback,
}
impl Default for ParseCallbackState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AclItem {
    pub ai_grantee: Oid,
    pub ai_grantor: Oid,
    pub ai_privs: AclMode,
}
impl Default for AclItem {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Acl = ArrayType;
pub mod AclMaskHow {
    pub type Type = ::core::ffi::c_uint;
    pub const ACLMASK_ALL: Type = 0;
    pub const ACLMASK_ANY: Type = 1;
}
pub mod AclResult {
    pub type Type = ::core::ffi::c_uint;
    pub const ACLCHECK_OK: Type = 0;
    pub const ACLCHECK_NO_PRIV: Type = 1;
    pub const ACLCHECK_NOT_OWNER: Type = 2;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FormData_pg_namespace {
    pub oid: Oid,
    pub nspname: NameData,
    pub nspowner: Oid,
}
impl Default for FormData_pg_namespace {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Form_pg_namespace = *mut FormData_pg_namespace;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FormData_pg_seclabel {
    pub objoid: Oid,
    pub classoid: Oid,
    pub objsubid: int32,
}
impl Default for FormData_pg_seclabel {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct FormData_pg_statistic_ext {
    pub oid: Oid,
    pub stxrelid: Oid,
    pub stxname: NameData,
    pub stxnamespace: Oid,
    pub stxowner: Oid,
    pub stxstattarget: int32,
    pub stxkeys: int2vector,
}
impl Default for FormData_pg_statistic_ext {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Form_pg_statistic_ext = *mut FormData_pg_statistic_ext;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FormData_pg_tablespace {
    pub oid: Oid,
    pub spcname: NameData,
    pub spcowner: Oid,
}
impl Default for FormData_pg_tablespace {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Form_pg_tablespace = *mut FormData_pg_tablespace;
#[repr(C)]
#[derive(Debug)]
pub struct FormData_pg_trigger {
    pub oid: Oid,
    pub tgrelid: Oid,
    pub tgparentid: Oid,
    pub tgname: NameData,
    pub tgfoid: Oid,
    pub tgtype: int16,
    pub tgenabled: ::core::ffi::c_char,
    pub tgisinternal: bool,
    pub tgconstrrelid: Oid,
    pub tgconstrindid: Oid,
    pub tgconstraint: Oid,
    pub tgdeferrable: bool,
    pub tginitdeferred: bool,
    pub tgnargs: int16,
    pub tgattr: int2vector,
}
impl Default for FormData_pg_trigger {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Form_pg_trigger = *mut FormData_pg_trigger;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FormData_pg_type {
    pub oid: Oid,
    pub typname: NameData,
    pub typnamespace: Oid,
    pub typowner: Oid,
    pub typlen: int16,
    pub typbyval: bool,
    pub typtype: ::core::ffi::c_char,
    pub typcategory: ::core::ffi::c_char,
    pub typispreferred: bool,
    pub typisdefined: bool,
    pub typdelim: ::core::ffi::c_char,
    pub typrelid: Oid,
    pub typsubscript: regproc,
    pub typelem: Oid,
    pub typarray: Oid,
    pub typinput: regproc,
    pub typoutput: regproc,
    pub typreceive: regproc,
    pub typsend: regproc,
    pub typmodin: regproc,
    pub typmodout: regproc,
    pub typanalyze: regproc,
    pub typalign: ::core::ffi::c_char,
    pub typstorage: ::core::ffi::c_char,
    pub typnotnull: bool,
    pub typbasetype: Oid,
    pub typtypmod: int32,
    pub typndims: int32,
    pub typcollation: Oid,
}
impl Default for FormData_pg_type {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Form_pg_type = *mut FormData_pg_type;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FormData_pg_user_mapping {
    pub oid: Oid,
    pub umuser: Oid,
    pub umserver: Oid,
}
impl Default for FormData_pg_user_mapping {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Form_pg_user_mapping = *mut FormData_pg_user_mapping;
pub mod CopyHeaderChoice {
    pub type Type = ::core::ffi::c_uint;
    pub const COPY_HEADER_FALSE: Type = 0;
    pub const COPY_HEADER_TRUE: Type = 1;
    pub const COPY_HEADER_MATCH: Type = 2;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CopyFormatOptions {
    pub file_encoding: ::core::ffi::c_int,
    pub binary: bool,
    pub freeze: bool,
    pub csv_mode: bool,
    pub header_line: CopyHeaderChoice::Type,
    pub null_print: *mut ::core::ffi::c_char,
    pub null_print_len: ::core::ffi::c_int,
    pub null_print_client: *mut ::core::ffi::c_char,
    pub delim: *mut ::core::ffi::c_char,
    pub quote: *mut ::core::ffi::c_char,
    pub escape: *mut ::core::ffi::c_char,
    pub force_quote: *mut List,
    pub force_quote_all: bool,
    pub force_quote_flags: *mut bool,
    pub force_notnull: *mut List,
    pub force_notnull_flags: *mut bool,
    pub force_null: *mut List,
    pub force_null_flags: *mut bool,
    pub convert_selectively: bool,
    pub convert_select: *mut List,
}
impl Default for CopyFormatOptions {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CopyFromStateData {
    _unused: [u8; 0],
}
pub type CopyFromState = *mut CopyFromStateData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CopyToStateData {
    _unused: [u8; 0],
}
pub type CopyToState = *mut CopyToStateData;
pub type copy_data_source_cb = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        outbuf: *mut ::core::ffi::c_void,
        minread: ::core::ffi::c_int,
        maxread: ::core::ffi::c_int,
    ) -> ::core::ffi::c_int,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FormData_pg_event_trigger {
    pub oid: Oid,
    pub evtname: NameData,
    pub evtevent: NameData,
    pub evtowner: Oid,
    pub evtfoid: Oid,
    pub evtenabled: ::core::ffi::c_char,
}
impl Default for FormData_pg_event_trigger {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Form_pg_event_trigger = *mut FormData_pg_event_trigger;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct InternalGrant {
    pub is_grant: bool,
    pub objtype: ObjectType::Type,
    pub objects: *mut List,
    pub all_privs: bool,
    pub privileges: AclMode,
    pub col_privs: *mut List,
    pub grantees: *mut List,
    pub grant_option: bool,
    pub behavior: DropBehavior::Type,
}
impl Default for InternalGrant {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod CollectedCommandType {
    pub type Type = ::core::ffi::c_uint;
    pub const SCT_Simple: Type = 0;
    pub const SCT_AlterTable: Type = 1;
    pub const SCT_Grant: Type = 2;
    pub const SCT_AlterOpFamily: Type = 3;
    pub const SCT_AlterDefaultPrivileges: Type = 4;
    pub const SCT_CreateOpClass: Type = 5;
    pub const SCT_AlterTSConfig: Type = 6;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CollectedATSubcmd {
    pub address: ObjectAddress,
    pub parsetree: *mut Node,
}
impl Default for CollectedATSubcmd {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct CollectedCommand {
    pub type_: CollectedCommandType::Type,
    pub in_extension: bool,
    pub parsetree: *mut Node,
    pub d: CollectedCommand__bindgen_ty_1,
    pub parent: *mut CollectedCommand,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union CollectedCommand__bindgen_ty_1 {
    pub simple: CollectedCommand__bindgen_ty_1__bindgen_ty_1,
    pub alterTable: CollectedCommand__bindgen_ty_1__bindgen_ty_2,
    pub grant: CollectedCommand__bindgen_ty_1__bindgen_ty_3,
    pub opfam: CollectedCommand__bindgen_ty_1__bindgen_ty_4,
    pub createopc: CollectedCommand__bindgen_ty_1__bindgen_ty_5,
    pub atscfg: CollectedCommand__bindgen_ty_1__bindgen_ty_6,
    pub defprivs: CollectedCommand__bindgen_ty_1__bindgen_ty_7,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CollectedCommand__bindgen_ty_1__bindgen_ty_1 {
    pub address: ObjectAddress,
    pub secondaryObject: ObjectAddress,
}
impl Default for CollectedCommand__bindgen_ty_1__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CollectedCommand__bindgen_ty_1__bindgen_ty_2 {
    pub objectId: Oid,
    pub classId: Oid,
    pub subcmds: *mut List,
}
impl Default for CollectedCommand__bindgen_ty_1__bindgen_ty_2 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CollectedCommand__bindgen_ty_1__bindgen_ty_3 {
    pub istmt: *mut InternalGrant,
}
impl Default for CollectedCommand__bindgen_ty_1__bindgen_ty_3 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CollectedCommand__bindgen_ty_1__bindgen_ty_4 {
    pub address: ObjectAddress,
    pub operators: *mut List,
    pub procedures: *mut List,
}
impl Default for CollectedCommand__bindgen_ty_1__bindgen_ty_4 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CollectedCommand__bindgen_ty_1__bindgen_ty_5 {
    pub address: ObjectAddress,
    pub operators: *mut List,
    pub procedures: *mut List,
}
impl Default for CollectedCommand__bindgen_ty_1__bindgen_ty_5 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CollectedCommand__bindgen_ty_1__bindgen_ty_6 {
    pub address: ObjectAddress,
    pub dictIds: *mut Oid,
    pub ndicts: ::core::ffi::c_int,
}
impl Default for CollectedCommand__bindgen_ty_1__bindgen_ty_6 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CollectedCommand__bindgen_ty_1__bindgen_ty_7 {
    pub objtype: ObjectType::Type,
}
impl Default for CollectedCommand__bindgen_ty_1__bindgen_ty_7 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for CollectedCommand__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for CollectedCommand {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct EventTriggerData {
    pub type_: NodeTag,
    pub event: *const ::core::ffi::c_char,
    pub parsetree: *mut Node,
    pub tag: CommandTag::Type,
}
impl Default for EventTriggerData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod ExplainFormat {
    pub type Type = ::core::ffi::c_uint;
    pub const EXPLAIN_FORMAT_TEXT: Type = 0;
    pub const EXPLAIN_FORMAT_XML: Type = 1;
    pub const EXPLAIN_FORMAT_JSON: Type = 2;
    pub const EXPLAIN_FORMAT_YAML: Type = 3;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExplainWorkersState {
    pub num_workers: ::core::ffi::c_int,
    pub worker_inited: *mut bool,
    pub worker_str: *mut StringInfoData,
    pub worker_state_save: *mut ::core::ffi::c_int,
    pub prev_str: StringInfo,
}
impl Default for ExplainWorkersState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExplainState {
    pub str_: StringInfo,
    pub verbose: bool,
    pub analyze: bool,
    pub costs: bool,
    pub buffers: bool,
    pub wal: bool,
    pub timing: bool,
    pub summary: bool,
    pub settings: bool,
    pub format: ExplainFormat::Type,
    pub indent: ::core::ffi::c_int,
    pub grouping_stack: *mut List,
    pub pstmt: *mut PlannedStmt,
    pub rtable: *mut List,
    pub rtable_names: *mut List,
    pub deparse_cxt: *mut List,
    pub printed_subplans: *mut Bitmapset,
    pub hide_workers: bool,
    pub workers_state: *mut ExplainWorkersState,
}
impl Default for ExplainState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type ExplainOneQuery_hook_type = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        query: *mut Query,
        cursorOptions: ::core::ffi::c_int,
        into: *mut IntoClause,
        es: *mut ExplainState,
        queryString: *const ::core::ffi::c_char,
        params: ParamListInfo,
        queryEnv: *mut QueryEnvironment,
    ),
>;
pub type explain_get_index_name_hook_type =
    ::core::option::Option<unsafe extern "C-unwind" fn(indexId: Oid) -> *const ::core::ffi::c_char>;
pub mod PlanCacheMode {
    pub type Type = ::core::ffi::c_uint;
    pub const PLAN_CACHE_MODE_AUTO: Type = 0;
    pub const PLAN_CACHE_MODE_FORCE_GENERIC_PLAN: Type = 1;
    pub const PLAN_CACHE_MODE_FORCE_CUSTOM_PLAN: Type = 2;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CachedPlanSource {
    pub magic: ::core::ffi::c_int,
    pub raw_parse_tree: *mut RawStmt,
    pub query_string: *const ::core::ffi::c_char,
    pub commandTag: CommandTag::Type,
    pub param_types: *mut Oid,
    pub num_params: ::core::ffi::c_int,
    pub parserSetup: ParserSetupHook,
    pub parserSetupArg: *mut ::core::ffi::c_void,
    pub cursor_options: ::core::ffi::c_int,
    pub fixed_result: bool,
    pub resultDesc: TupleDesc,
    pub context: MemoryContext,
    pub query_list: *mut List,
    pub relationOids: *mut List,
    pub invalItems: *mut List,
    pub search_path: *mut OverrideSearchPath,
    pub query_context: MemoryContext,
    pub rewriteRoleId: Oid,
    pub rewriteRowSecurity: bool,
    pub dependsOnRLS: bool,
    pub gplan: *mut CachedPlan,
    pub is_oneshot: bool,
    pub is_complete: bool,
    pub is_saved: bool,
    pub is_valid: bool,
    pub generation: ::core::ffi::c_int,
    pub node: dlist_node,
    pub generic_cost: f64,
    pub total_custom_cost: f64,
    pub num_custom_plans: int64,
    pub num_generic_plans: int64,
}
impl Default for CachedPlanSource {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CachedPlan {
    pub magic: ::core::ffi::c_int,
    pub stmt_list: *mut List,
    pub is_oneshot: bool,
    pub is_saved: bool,
    pub is_valid: bool,
    pub planRoleId: Oid,
    pub dependsOnRole: bool,
    pub saved_xmin: TransactionId,
    pub generation: ::core::ffi::c_int,
    pub refcount: ::core::ffi::c_int,
    pub context: MemoryContext,
}
impl Default for CachedPlan {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CachedExpression {
    pub magic: ::core::ffi::c_int,
    pub expr: *mut Node,
    pub is_valid: bool,
    pub relationOids: *mut List,
    pub invalItems: *mut List,
    pub context: MemoryContext,
    pub node: dlist_node,
}
impl Default for CachedExpression {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PreparedStatement {
    pub stmt_name: [::core::ffi::c_char; 64usize],
    pub plansource: *mut CachedPlanSource,
    pub from_sql: bool,
    pub prepare_time: TimestampTz,
}
impl Default for PreparedStatement {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type check_object_relabel_type = ::core::option::Option<
    unsafe extern "C-unwind" fn(object: *const ObjectAddress, seclabel: *const ::core::ffi::c_char),
>;
#[repr(C)]
#[derive(Debug)]
pub struct xl_tblspc_create_rec {
    pub ts_id: Oid,
    pub ts_path: __IncompleteArrayField<::core::ffi::c_char>,
}
impl Default for xl_tblspc_create_rec {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xl_tblspc_drop_rec {
    pub ts_id: Oid,
}
impl Default for xl_tblspc_drop_rec {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct TableSpaceOpts {
    pub vl_len_: int32,
    pub random_page_cost: float8,
    pub seq_page_cost: float8,
    pub effective_io_concurrency: ::core::ffi::c_int,
    pub maintenance_io_concurrency: ::core::ffi::c_int,
}
pub type TriggerEvent = uint32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TriggerData {
    pub type_: NodeTag,
    pub tg_event: TriggerEvent,
    pub tg_relation: Relation,
    pub tg_trigtuple: HeapTuple,
    pub tg_newtuple: HeapTuple,
    pub tg_trigger: *mut Trigger,
    pub tg_trigslot: *mut TupleTableSlot,
    pub tg_newslot: *mut TupleTableSlot,
    pub tg_oldtable: *mut Tuplestorestate,
    pub tg_newtable: *mut Tuplestorestate,
    pub tg_updatedcols: *const Bitmapset,
}
impl Default for TriggerData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AfterTriggersTableData {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TransitionCaptureState {
    pub tcs_delete_old_table: bool,
    pub tcs_update_old_table: bool,
    pub tcs_update_new_table: bool,
    pub tcs_insert_new_table: bool,
    pub tcs_original_insert_tuple: *mut TupleTableSlot,
    pub tcs_private: *mut AfterTriggersTableData,
}
impl Default for TransitionCaptureState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod PasswordType {
    pub type Type = ::core::ffi::c_uint;
    pub const PASSWORD_TYPE_PLAINTEXT: Type = 0;
    pub const PASSWORD_TYPE_MD5: Type = 1;
    pub const PASSWORD_TYPE_SCRAM_SHA_256: Type = 2;
}
pub type check_password_hook_type = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        username: *const ::core::ffi::c_char,
        shadow_pass: *const ::core::ffi::c_char,
        password_type: PasswordType::Type,
        validuntil_time: Datum,
        validuntil_null: bool,
    ),
>;
pub type bgworker_main_type = ::core::option::Option<unsafe extern "C-unwind" fn(main_arg: Datum)>;
pub mod BgWorkerStartTime {
    pub type Type = ::core::ffi::c_uint;
    pub const BgWorkerStart_PostmasterStart: Type = 0;
    pub const BgWorkerStart_ConsistentState: Type = 1;
    pub const BgWorkerStart_RecoveryFinished: Type = 2;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BackgroundWorker {
    pub bgw_name: [::core::ffi::c_char; 96usize],
    pub bgw_type: [::core::ffi::c_char; 96usize],
    pub bgw_flags: ::core::ffi::c_int,
    pub bgw_start_time: BgWorkerStartTime::Type,
    pub bgw_restart_time: ::core::ffi::c_int,
    pub bgw_library_name: [::core::ffi::c_char; 96usize],
    pub bgw_function_name: [::core::ffi::c_char; 96usize],
    pub bgw_main_arg: Datum,
    pub bgw_extra: [::core::ffi::c_char; 128usize],
    pub bgw_notify_pid: pid_t,
}
impl Default for BackgroundWorker {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod BgwHandleStatus {
    pub type Type = ::core::ffi::c_uint;
    pub const BGWH_STARTED: Type = 0;
    pub const BGWH_NOT_YET_STARTED: Type = 1;
    pub const BGWH_STOPPED: Type = 2;
    pub const BGWH_POSTMASTER_DIED: Type = 3;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BackgroundWorkerHandle {
    _unused: [u8; 0],
}
pub type XidStatus = ::core::ffi::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xl_clog_truncate {
    pub pageno: ::core::ffi::c_int,
    pub oldestXact: TransactionId,
    pub oldestXactDb: Oid,
}
impl Default for xl_clog_truncate {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct Latch {
    pub is_set: sig_atomic_t,
    pub maybe_sleeping: sig_atomic_t,
    pub is_shared: bool,
    pub owner_pid: ::core::ffi::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WaitEvent {
    pub pos: ::core::ffi::c_int,
    pub events: uint32,
    pub fd: pgsocket,
    pub user_data: *mut ::core::ffi::c_void,
}
impl Default for WaitEvent {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PGSemaphoreData {
    _unused: [u8; 0],
}
pub type PGSemaphore = *mut PGSemaphoreData;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct XidCacheStatus {
    pub count: uint8,
    pub overflowed: bool,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct XidCache {
    pub xids: [TransactionId; 64usize],
}
impl Default for XidCache {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod ProcWaitStatus {
    pub type Type = ::core::ffi::c_uint;
    pub const PROC_WAIT_STATUS_OK: Type = 0;
    pub const PROC_WAIT_STATUS_WAITING: Type = 1;
    pub const PROC_WAIT_STATUS_ERROR: Type = 2;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PGPROC {
    pub links: SHM_QUEUE,
    pub procgloballist: *mut *mut PGPROC,
    pub sem: PGSemaphore,
    pub waitStatus: ProcWaitStatus::Type,
    pub procLatch: Latch,
    pub xid: TransactionId,
    pub xmin: TransactionId,
    pub lxid: LocalTransactionId,
    pub pid: ::core::ffi::c_int,
    pub pgxactoff: ::core::ffi::c_int,
    pub pgprocno: ::core::ffi::c_int,
    pub backendId: BackendId,
    pub databaseId: Oid,
    pub roleId: Oid,
    pub tempNamespaceId: Oid,
    pub isBackgroundWorker: bool,
    pub recoveryConflictPending: bool,
    pub lwWaiting: uint8,
    pub lwWaitMode: uint8,
    pub lwWaitLink: proclist_node,
    pub cvWaitLink: proclist_node,
    pub waitLock: *mut LOCK,
    pub waitProcLock: *mut PROCLOCK,
    pub waitLockMode: LOCKMODE,
    pub heldLocks: LOCKMASK,
    pub waitStart: pg_atomic_uint64,
    pub delayChkptFlags: ::core::ffi::c_int,
    pub statusFlags: uint8,
    pub waitLSN: XLogRecPtr,
    pub syncRepState: ::core::ffi::c_int,
    pub syncRepLinks: SHM_QUEUE,
    pub myProcLocks: [SHM_QUEUE; 16usize],
    pub subxidStatus: XidCacheStatus,
    pub subxids: XidCache,
    pub procArrayGroupMember: bool,
    pub procArrayGroupNext: pg_atomic_uint32,
    pub procArrayGroupMemberXid: TransactionId,
    pub wait_event_info: uint32,
    pub clogGroupMember: bool,
    pub clogGroupNext: pg_atomic_uint32,
    pub clogGroupMemberXid: TransactionId,
    pub clogGroupMemberXidStatus: XidStatus,
    pub clogGroupMemberPage: ::core::ffi::c_int,
    pub clogGroupMemberLsn: XLogRecPtr,
    pub fpInfoLock: LWLock,
    pub fpLockBits: uint64,
    pub fpRelId: [Oid; 16usize],
    pub fpVXIDLock: bool,
    pub fpLocalTransactionId: LocalTransactionId,
    pub lockGroupLeader: *mut PGPROC,
    pub lockGroupMembers: dlist_head,
    pub lockGroupLink: dlist_node,
}
impl Default for PGPROC {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PROC_HDR {
    pub allProcs: *mut PGPROC,
    pub xids: *mut TransactionId,
    pub subxidStates: *mut XidCacheStatus,
    pub statusFlags: *mut uint8,
    pub allProcCount: uint32,
    pub freeProcs: *mut PGPROC,
    pub autovacFreeProcs: *mut PGPROC,
    pub bgworkerFreeProcs: *mut PGPROC,
    pub walsenderFreeProcs: *mut PGPROC,
    pub procArrayGroupFirst: pg_atomic_uint32,
    pub clogGroupFirst: pg_atomic_uint32,
    pub walwriterLatch: *mut Latch,
    pub checkpointerLatch: *mut Latch,
    pub spins_per_delay: ::core::ffi::c_int,
    pub startupBufferPinWaitBufId: ::core::ffi::c_int,
}
impl Default for PROC_HDR {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct shm_mq {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct shm_mq_handle {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct shm_mq_iovec {
    pub data: *const ::core::ffi::c_char,
    pub len: Size,
}
impl Default for shm_mq_iovec {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod shm_mq_result {
    pub type Type = ::core::ffi::c_uint;
    pub const SHM_MQ_SUCCESS: Type = 0;
    pub const SHM_MQ_WOULD_BLOCK: Type = 1;
    pub const SHM_MQ_DETACHED: Type = 2;
}
pub type parallel_worker_main_type =
    ::core::option::Option<unsafe extern "C-unwind" fn(seg: *mut dsm_segment, toc: *mut shm_toc)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ParallelWorkerInfo {
    pub bgwhandle: *mut BackgroundWorkerHandle,
    pub error_mqh: *mut shm_mq_handle,
    pub pid: int32,
}
impl Default for ParallelWorkerInfo {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ParallelContext {
    pub node: dlist_node,
    pub subid: SubTransactionId,
    pub nworkers: ::core::ffi::c_int,
    pub nworkers_to_launch: ::core::ffi::c_int,
    pub nworkers_launched: ::core::ffi::c_int,
    pub library_name: *mut ::core::ffi::c_char,
    pub function_name: *mut ::core::ffi::c_char,
    pub error_context_stack: *mut ErrorContextCallback,
    pub estimator: shm_toc_estimator,
    pub seg: *mut dsm_segment,
    pub private_memory: *mut ::core::ffi::c_void,
    pub toc: *mut shm_toc,
    pub worker: *mut ParallelWorkerInfo,
    pub nknown_attached_workers: ::core::ffi::c_int,
    pub known_attached_workers: *mut bool,
}
impl Default for ParallelContext {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ParallelWorkerContext {
    pub seg: *mut dsm_segment,
    pub toc: *mut shm_toc,
}
impl Default for ParallelWorkerContext {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FormData_pg_statistic {
    pub starelid: Oid,
    pub staattnum: int16,
    pub stainherit: bool,
    pub stanullfrac: float4,
    pub stawidth: int32,
    pub stadistinct: float4,
    pub stakind1: int16,
    pub stakind2: int16,
    pub stakind3: int16,
    pub stakind4: int16,
    pub stakind5: int16,
    pub staop1: Oid,
    pub staop2: Oid,
    pub staop3: Oid,
    pub staop4: Oid,
    pub staop5: Oid,
    pub stacoll1: Oid,
    pub stacoll2: Oid,
    pub stacoll3: Oid,
    pub stacoll4: Oid,
    pub stacoll5: Oid,
}
impl Default for FormData_pg_statistic {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Form_pg_statistic = *mut FormData_pg_statistic;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ParallelVacuumState {
    _unused: [u8; 0],
}
pub type VacAttrStatsP = *mut VacAttrStats;
pub type AnalyzeAttrFetchFunc = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        stats: VacAttrStatsP,
        rownum: ::core::ffi::c_int,
        isNull: *mut bool,
    ) -> Datum,
>;
pub type AnalyzeAttrComputeStatsFunc = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        stats: VacAttrStatsP,
        fetchfunc: AnalyzeAttrFetchFunc,
        samplerows: ::core::ffi::c_int,
        totalrows: f64,
    ),
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VacAttrStats {
    pub attr: Form_pg_attribute,
    pub attrtypid: Oid,
    pub attrtypmod: int32,
    pub attrtype: Form_pg_type,
    pub attrcollid: Oid,
    pub anl_context: MemoryContext,
    pub compute_stats: AnalyzeAttrComputeStatsFunc,
    pub minrows: ::core::ffi::c_int,
    pub extra_data: *mut ::core::ffi::c_void,
    pub stats_valid: bool,
    pub stanullfrac: float4,
    pub stawidth: int32,
    pub stadistinct: float4,
    pub stakind: [int16; 5usize],
    pub staop: [Oid; 5usize],
    pub stacoll: [Oid; 5usize],
    pub numnumbers: [::core::ffi::c_int; 5usize],
    pub stanumbers: [*mut float4; 5usize],
    pub numvalues: [::core::ffi::c_int; 5usize],
    pub stavalues: [*mut Datum; 5usize],
    pub statypid: [Oid; 5usize],
    pub statyplen: [int16; 5usize],
    pub statypbyval: [bool; 5usize],
    pub statypalign: [::core::ffi::c_char; 5usize],
    pub tupattnum: ::core::ffi::c_int,
    pub rows: *mut HeapTuple,
    pub tupDesc: TupleDesc,
    pub exprvals: *mut Datum,
    pub exprnulls: *mut bool,
    pub rowstride: ::core::ffi::c_int,
}
impl Default for VacAttrStats {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod VacOptValue {
    pub type Type = ::core::ffi::c_uint;
    pub const VACOPTVALUE_UNSPECIFIED: Type = 0;
    pub const VACOPTVALUE_AUTO: Type = 1;
    pub const VACOPTVALUE_DISABLED: Type = 2;
    pub const VACOPTVALUE_ENABLED: Type = 3;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VacuumParams {
    pub options: bits32,
    pub freeze_min_age: ::core::ffi::c_int,
    pub freeze_table_age: ::core::ffi::c_int,
    pub multixact_freeze_min_age: ::core::ffi::c_int,
    pub multixact_freeze_table_age: ::core::ffi::c_int,
    pub is_wraparound: bool,
    pub log_min_duration: ::core::ffi::c_int,
    pub index_cleanup: VacOptValue::Type,
    pub truncate: VacOptValue::Type,
    pub nworkers: ::core::ffi::c_int,
}
impl Default for VacuumParams {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct VacDeadItems {
    pub max_items: ::core::ffi::c_int,
    pub num_items: ::core::ffi::c_int,
    pub items: __IncompleteArrayField<ItemPointerData>,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ConfigData {
    pub name: *mut ::core::ffi::c_char,
    pub setting: *mut ::core::ffi::c_char,
}
impl Default for ConfigData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AggStatePerTransData {
    pub aggref: *mut Aggref,
    pub aggshared: bool,
    pub numInputs: ::core::ffi::c_int,
    pub numTransInputs: ::core::ffi::c_int,
    pub transfn_oid: Oid,
    pub serialfn_oid: Oid,
    pub deserialfn_oid: Oid,
    pub aggtranstype: Oid,
    pub transfn: FmgrInfo,
    pub serialfn: FmgrInfo,
    pub deserialfn: FmgrInfo,
    pub aggCollation: Oid,
    pub numSortCols: ::core::ffi::c_int,
    pub numDistinctCols: ::core::ffi::c_int,
    pub sortColIdx: *mut AttrNumber,
    pub sortOperators: *mut Oid,
    pub sortCollations: *mut Oid,
    pub sortNullsFirst: *mut bool,
    pub equalfnOne: FmgrInfo,
    pub equalfnMulti: *mut ExprState,
    pub initValue: Datum,
    pub initValueIsNull: bool,
    pub inputtypeLen: int16,
    pub transtypeLen: int16,
    pub inputtypeByVal: bool,
    pub transtypeByVal: bool,
    pub sortslot: *mut TupleTableSlot,
    pub uniqslot: *mut TupleTableSlot,
    pub sortdesc: TupleDesc,
    pub sortstates: *mut *mut Tuplesortstate,
    pub transfn_fcinfo: FunctionCallInfo,
    pub serialfn_fcinfo: FunctionCallInfo,
    pub deserialfn_fcinfo: FunctionCallInfo,
}
impl Default for AggStatePerTransData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AggStatePerAggData {
    pub aggref: *mut Aggref,
    pub transno: ::core::ffi::c_int,
    pub finalfn_oid: Oid,
    pub finalfn: FmgrInfo,
    pub numFinalArgs: ::core::ffi::c_int,
    pub aggdirectargs: *mut List,
    pub resulttypeLen: int16,
    pub resulttypeByVal: bool,
    pub shareable: bool,
}
impl Default for AggStatePerAggData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AggStatePerGroupData {
    pub transValue: Datum,
    pub transValueIsNull: bool,
    pub noTransValue: bool,
}
impl Default for AggStatePerGroupData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AggStatePerPhaseData {
    pub aggstrategy: AggStrategy::Type,
    pub numsets: ::core::ffi::c_int,
    pub gset_lengths: *mut ::core::ffi::c_int,
    pub grouped_cols: *mut *mut Bitmapset,
    pub eqfunctions: *mut *mut ExprState,
    pub aggnode: *mut Agg,
    pub sortnode: *mut Sort,
    pub evaltrans: *mut ExprState,
    pub evaltrans_cache: [[*mut ExprState; 2usize]; 2usize],
}
impl Default for AggStatePerPhaseData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AggStatePerHashData {
    pub hashtable: TupleHashTable,
    pub hashiter: TupleHashIterator,
    pub hashslot: *mut TupleTableSlot,
    pub hashfunctions: *mut FmgrInfo,
    pub eqfuncoids: *mut Oid,
    pub numCols: ::core::ffi::c_int,
    pub numhashGrpCols: ::core::ffi::c_int,
    pub largestGrpColIdx: ::core::ffi::c_int,
    pub hashGrpColIdxInput: *mut AttrNumber,
    pub hashGrpColIdxHash: *mut AttrNumber,
    pub aggnode: *mut Agg,
}
impl Default for AggStatePerHashData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ScalarArrayOpExprHashTable {
    _unused: [u8; 0],
}
pub type ExecEvalSubroutine = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        state: *mut ExprState,
        op: *mut ExprEvalStep,
        econtext: *mut ExprContext,
    ),
>;
pub type ExecEvalBoolSubroutine = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        state: *mut ExprState,
        op: *mut ExprEvalStep,
        econtext: *mut ExprContext,
    ) -> bool,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExprEvalRowtypeCache {
    pub cacheptr: *mut ::core::ffi::c_void,
    pub tupdesc_id: uint64,
}
impl Default for ExprEvalRowtypeCache {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod ExprEvalOp {
    pub type Type = ::core::ffi::c_uint;
    pub const EEOP_DONE: Type = 0;
    pub const EEOP_INNER_FETCHSOME: Type = 1;
    pub const EEOP_OUTER_FETCHSOME: Type = 2;
    pub const EEOP_SCAN_FETCHSOME: Type = 3;
    pub const EEOP_INNER_VAR: Type = 4;
    pub const EEOP_OUTER_VAR: Type = 5;
    pub const EEOP_SCAN_VAR: Type = 6;
    pub const EEOP_INNER_SYSVAR: Type = 7;
    pub const EEOP_OUTER_SYSVAR: Type = 8;
    pub const EEOP_SCAN_SYSVAR: Type = 9;
    pub const EEOP_WHOLEROW: Type = 10;
    pub const EEOP_ASSIGN_INNER_VAR: Type = 11;
    pub const EEOP_ASSIGN_OUTER_VAR: Type = 12;
    pub const EEOP_ASSIGN_SCAN_VAR: Type = 13;
    pub const EEOP_ASSIGN_TMP: Type = 14;
    pub const EEOP_ASSIGN_TMP_MAKE_RO: Type = 15;
    pub const EEOP_CONST: Type = 16;
    pub const EEOP_FUNCEXPR: Type = 17;
    pub const EEOP_FUNCEXPR_STRICT: Type = 18;
    pub const EEOP_FUNCEXPR_FUSAGE: Type = 19;
    pub const EEOP_FUNCEXPR_STRICT_FUSAGE: Type = 20;
    pub const EEOP_BOOL_AND_STEP_FIRST: Type = 21;
    pub const EEOP_BOOL_AND_STEP: Type = 22;
    pub const EEOP_BOOL_AND_STEP_LAST: Type = 23;
    pub const EEOP_BOOL_OR_STEP_FIRST: Type = 24;
    pub const EEOP_BOOL_OR_STEP: Type = 25;
    pub const EEOP_BOOL_OR_STEP_LAST: Type = 26;
    pub const EEOP_BOOL_NOT_STEP: Type = 27;
    pub const EEOP_QUAL: Type = 28;
    pub const EEOP_JUMP: Type = 29;
    pub const EEOP_JUMP_IF_NULL: Type = 30;
    pub const EEOP_JUMP_IF_NOT_NULL: Type = 31;
    pub const EEOP_JUMP_IF_NOT_TRUE: Type = 32;
    pub const EEOP_NULLTEST_ISNULL: Type = 33;
    pub const EEOP_NULLTEST_ISNOTNULL: Type = 34;
    pub const EEOP_NULLTEST_ROWISNULL: Type = 35;
    pub const EEOP_NULLTEST_ROWISNOTNULL: Type = 36;
    pub const EEOP_BOOLTEST_IS_TRUE: Type = 37;
    pub const EEOP_BOOLTEST_IS_NOT_TRUE: Type = 38;
    pub const EEOP_BOOLTEST_IS_FALSE: Type = 39;
    pub const EEOP_BOOLTEST_IS_NOT_FALSE: Type = 40;
    pub const EEOP_PARAM_EXEC: Type = 41;
    pub const EEOP_PARAM_EXTERN: Type = 42;
    pub const EEOP_PARAM_CALLBACK: Type = 43;
    pub const EEOP_CASE_TESTVAL: Type = 44;
    pub const EEOP_MAKE_READONLY: Type = 45;
    pub const EEOP_IOCOERCE: Type = 46;
    pub const EEOP_DISTINCT: Type = 47;
    pub const EEOP_NOT_DISTINCT: Type = 48;
    pub const EEOP_NULLIF: Type = 49;
    pub const EEOP_SQLVALUEFUNCTION: Type = 50;
    pub const EEOP_CURRENTOFEXPR: Type = 51;
    pub const EEOP_NEXTVALUEEXPR: Type = 52;
    pub const EEOP_ARRAYEXPR: Type = 53;
    pub const EEOP_ARRAYCOERCE: Type = 54;
    pub const EEOP_ROW: Type = 55;
    pub const EEOP_ROWCOMPARE_STEP: Type = 56;
    pub const EEOP_ROWCOMPARE_FINAL: Type = 57;
    pub const EEOP_MINMAX: Type = 58;
    pub const EEOP_FIELDSELECT: Type = 59;
    pub const EEOP_FIELDSTORE_DEFORM: Type = 60;
    pub const EEOP_FIELDSTORE_FORM: Type = 61;
    pub const EEOP_SBSREF_SUBSCRIPTS: Type = 62;
    pub const EEOP_SBSREF_OLD: Type = 63;
    pub const EEOP_SBSREF_ASSIGN: Type = 64;
    pub const EEOP_SBSREF_FETCH: Type = 65;
    pub const EEOP_DOMAIN_TESTVAL: Type = 66;
    pub const EEOP_DOMAIN_NOTNULL: Type = 67;
    pub const EEOP_DOMAIN_CHECK: Type = 68;
    pub const EEOP_CONVERT_ROWTYPE: Type = 69;
    pub const EEOP_SCALARARRAYOP: Type = 70;
    pub const EEOP_HASHED_SCALARARRAYOP: Type = 71;
    pub const EEOP_XMLEXPR: Type = 72;
    pub const EEOP_AGGREF: Type = 73;
    pub const EEOP_GROUPING_FUNC: Type = 74;
    pub const EEOP_WINDOW_FUNC: Type = 75;
    pub const EEOP_SUBPLAN: Type = 76;
    pub const EEOP_AGG_STRICT_DESERIALIZE: Type = 77;
    pub const EEOP_AGG_DESERIALIZE: Type = 78;
    pub const EEOP_AGG_STRICT_INPUT_CHECK_ARGS: Type = 79;
    pub const EEOP_AGG_STRICT_INPUT_CHECK_NULLS: Type = 80;
    pub const EEOP_AGG_PLAIN_PERGROUP_NULLCHECK: Type = 81;
    pub const EEOP_AGG_PLAIN_TRANS_INIT_STRICT_BYVAL: Type = 82;
    pub const EEOP_AGG_PLAIN_TRANS_STRICT_BYVAL: Type = 83;
    pub const EEOP_AGG_PLAIN_TRANS_BYVAL: Type = 84;
    pub const EEOP_AGG_PLAIN_TRANS_INIT_STRICT_BYREF: Type = 85;
    pub const EEOP_AGG_PLAIN_TRANS_STRICT_BYREF: Type = 86;
    pub const EEOP_AGG_PLAIN_TRANS_BYREF: Type = 87;
    pub const EEOP_AGG_ORDERED_TRANS_DATUM: Type = 88;
    pub const EEOP_AGG_ORDERED_TRANS_TUPLE: Type = 89;
    pub const EEOP_LAST: Type = 90;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct ExprEvalStep {
    pub opcode: isize,
    pub resvalue: *mut Datum,
    pub resnull: *mut bool,
    pub d: ExprEvalStep__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union ExprEvalStep__bindgen_ty_1 {
    pub fetch: ExprEvalStep__bindgen_ty_1__bindgen_ty_1,
    pub var: ExprEvalStep__bindgen_ty_1__bindgen_ty_2,
    pub wholerow: ExprEvalStep__bindgen_ty_1__bindgen_ty_3,
    pub assign_var: ExprEvalStep__bindgen_ty_1__bindgen_ty_4,
    pub assign_tmp: ExprEvalStep__bindgen_ty_1__bindgen_ty_5,
    pub constval: ExprEvalStep__bindgen_ty_1__bindgen_ty_6,
    pub func: ExprEvalStep__bindgen_ty_1__bindgen_ty_7,
    pub boolexpr: ExprEvalStep__bindgen_ty_1__bindgen_ty_8,
    pub qualexpr: ExprEvalStep__bindgen_ty_1__bindgen_ty_9,
    pub jump: ExprEvalStep__bindgen_ty_1__bindgen_ty_10,
    pub nulltest_row: ExprEvalStep__bindgen_ty_1__bindgen_ty_11,
    pub param: ExprEvalStep__bindgen_ty_1__bindgen_ty_12,
    pub cparam: ExprEvalStep__bindgen_ty_1__bindgen_ty_13,
    pub casetest: ExprEvalStep__bindgen_ty_1__bindgen_ty_14,
    pub make_readonly: ExprEvalStep__bindgen_ty_1__bindgen_ty_15,
    pub iocoerce: ExprEvalStep__bindgen_ty_1__bindgen_ty_16,
    pub sqlvaluefunction: ExprEvalStep__bindgen_ty_1__bindgen_ty_17,
    pub nextvalueexpr: ExprEvalStep__bindgen_ty_1__bindgen_ty_18,
    pub arrayexpr: ExprEvalStep__bindgen_ty_1__bindgen_ty_19,
    pub arraycoerce: ExprEvalStep__bindgen_ty_1__bindgen_ty_20,
    pub row: ExprEvalStep__bindgen_ty_1__bindgen_ty_21,
    pub rowcompare_step: ExprEvalStep__bindgen_ty_1__bindgen_ty_22,
    pub rowcompare_final: ExprEvalStep__bindgen_ty_1__bindgen_ty_23,
    pub minmax: ExprEvalStep__bindgen_ty_1__bindgen_ty_24,
    pub fieldselect: ExprEvalStep__bindgen_ty_1__bindgen_ty_25,
    pub fieldstore: ExprEvalStep__bindgen_ty_1__bindgen_ty_26,
    pub sbsref_subscript: ExprEvalStep__bindgen_ty_1__bindgen_ty_27,
    pub sbsref: ExprEvalStep__bindgen_ty_1__bindgen_ty_28,
    pub domaincheck: ExprEvalStep__bindgen_ty_1__bindgen_ty_29,
    pub convert_rowtype: ExprEvalStep__bindgen_ty_1__bindgen_ty_30,
    pub scalararrayop: ExprEvalStep__bindgen_ty_1__bindgen_ty_31,
    pub hashedscalararrayop: ExprEvalStep__bindgen_ty_1__bindgen_ty_32,
    pub xmlexpr: ExprEvalStep__bindgen_ty_1__bindgen_ty_33,
    pub aggref: ExprEvalStep__bindgen_ty_1__bindgen_ty_34,
    pub grouping_func: ExprEvalStep__bindgen_ty_1__bindgen_ty_35,
    pub window_func: ExprEvalStep__bindgen_ty_1__bindgen_ty_36,
    pub subplan: ExprEvalStep__bindgen_ty_1__bindgen_ty_37,
    pub agg_deserialize: ExprEvalStep__bindgen_ty_1__bindgen_ty_38,
    pub agg_strict_input_check: ExprEvalStep__bindgen_ty_1__bindgen_ty_39,
    pub agg_plain_pergroup_nullcheck: ExprEvalStep__bindgen_ty_1__bindgen_ty_40,
    pub agg_trans: ExprEvalStep__bindgen_ty_1__bindgen_ty_41,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExprEvalStep__bindgen_ty_1__bindgen_ty_1 {
    pub last_var: ::core::ffi::c_int,
    pub fixed: bool,
    pub known_desc: TupleDesc,
    pub kind: *const TupleTableSlotOps,
}
impl Default for ExprEvalStep__bindgen_ty_1__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExprEvalStep__bindgen_ty_1__bindgen_ty_2 {
    pub attnum: ::core::ffi::c_int,
    pub vartype: Oid,
}
impl Default for ExprEvalStep__bindgen_ty_1__bindgen_ty_2 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExprEvalStep__bindgen_ty_1__bindgen_ty_3 {
    pub var: *mut Var,
    pub first: bool,
    pub slow: bool,
    pub tupdesc: TupleDesc,
    pub junkFilter: *mut JunkFilter,
}
impl Default for ExprEvalStep__bindgen_ty_1__bindgen_ty_3 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ExprEvalStep__bindgen_ty_1__bindgen_ty_4 {
    pub resultnum: ::core::ffi::c_int,
    pub attnum: ::core::ffi::c_int,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ExprEvalStep__bindgen_ty_1__bindgen_ty_5 {
    pub resultnum: ::core::ffi::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExprEvalStep__bindgen_ty_1__bindgen_ty_6 {
    pub value: Datum,
    pub isnull: bool,
}
impl Default for ExprEvalStep__bindgen_ty_1__bindgen_ty_6 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExprEvalStep__bindgen_ty_1__bindgen_ty_7 {
    pub finfo: *mut FmgrInfo,
    pub fcinfo_data: FunctionCallInfo,
    pub fn_addr: PGFunction,
    pub nargs: ::core::ffi::c_int,
    pub make_ro: bool,
}
impl Default for ExprEvalStep__bindgen_ty_1__bindgen_ty_7 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExprEvalStep__bindgen_ty_1__bindgen_ty_8 {
    pub anynull: *mut bool,
    pub jumpdone: ::core::ffi::c_int,
}
impl Default for ExprEvalStep__bindgen_ty_1__bindgen_ty_8 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ExprEvalStep__bindgen_ty_1__bindgen_ty_9 {
    pub jumpdone: ::core::ffi::c_int,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ExprEvalStep__bindgen_ty_1__bindgen_ty_10 {
    pub jumpdone: ::core::ffi::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExprEvalStep__bindgen_ty_1__bindgen_ty_11 {
    pub rowcache: ExprEvalRowtypeCache,
}
impl Default for ExprEvalStep__bindgen_ty_1__bindgen_ty_11 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExprEvalStep__bindgen_ty_1__bindgen_ty_12 {
    pub paramid: ::core::ffi::c_int,
    pub paramtype: Oid,
}
impl Default for ExprEvalStep__bindgen_ty_1__bindgen_ty_12 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExprEvalStep__bindgen_ty_1__bindgen_ty_13 {
    pub paramfunc: ExecEvalSubroutine,
    pub paramarg: *mut ::core::ffi::c_void,
    pub paramid: ::core::ffi::c_int,
    pub paramtype: Oid,
}
impl Default for ExprEvalStep__bindgen_ty_1__bindgen_ty_13 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExprEvalStep__bindgen_ty_1__bindgen_ty_14 {
    pub value: *mut Datum,
    pub isnull: *mut bool,
}
impl Default for ExprEvalStep__bindgen_ty_1__bindgen_ty_14 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExprEvalStep__bindgen_ty_1__bindgen_ty_15 {
    pub value: *mut Datum,
    pub isnull: *mut bool,
}
impl Default for ExprEvalStep__bindgen_ty_1__bindgen_ty_15 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExprEvalStep__bindgen_ty_1__bindgen_ty_16 {
    pub finfo_out: *mut FmgrInfo,
    pub fcinfo_data_out: FunctionCallInfo,
    pub finfo_in: *mut FmgrInfo,
    pub fcinfo_data_in: FunctionCallInfo,
}
impl Default for ExprEvalStep__bindgen_ty_1__bindgen_ty_16 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExprEvalStep__bindgen_ty_1__bindgen_ty_17 {
    pub svf: *mut SQLValueFunction,
}
impl Default for ExprEvalStep__bindgen_ty_1__bindgen_ty_17 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExprEvalStep__bindgen_ty_1__bindgen_ty_18 {
    pub seqid: Oid,
    pub seqtypid: Oid,
}
impl Default for ExprEvalStep__bindgen_ty_1__bindgen_ty_18 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExprEvalStep__bindgen_ty_1__bindgen_ty_19 {
    pub elemvalues: *mut Datum,
    pub elemnulls: *mut bool,
    pub nelems: ::core::ffi::c_int,
    pub elemtype: Oid,
    pub elemlength: int16,
    pub elembyval: bool,
    pub elemalign: ::core::ffi::c_char,
    pub multidims: bool,
}
impl Default for ExprEvalStep__bindgen_ty_1__bindgen_ty_19 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExprEvalStep__bindgen_ty_1__bindgen_ty_20 {
    pub elemexprstate: *mut ExprState,
    pub resultelemtype: Oid,
    pub amstate: *mut ArrayMapState,
}
impl Default for ExprEvalStep__bindgen_ty_1__bindgen_ty_20 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExprEvalStep__bindgen_ty_1__bindgen_ty_21 {
    pub tupdesc: TupleDesc,
    pub elemvalues: *mut Datum,
    pub elemnulls: *mut bool,
}
impl Default for ExprEvalStep__bindgen_ty_1__bindgen_ty_21 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExprEvalStep__bindgen_ty_1__bindgen_ty_22 {
    pub finfo: *mut FmgrInfo,
    pub fcinfo_data: FunctionCallInfo,
    pub fn_addr: PGFunction,
    pub jumpnull: ::core::ffi::c_int,
    pub jumpdone: ::core::ffi::c_int,
}
impl Default for ExprEvalStep__bindgen_ty_1__bindgen_ty_22 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExprEvalStep__bindgen_ty_1__bindgen_ty_23 {
    pub rctype: RowCompareType::Type,
}
impl Default for ExprEvalStep__bindgen_ty_1__bindgen_ty_23 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExprEvalStep__bindgen_ty_1__bindgen_ty_24 {
    pub values: *mut Datum,
    pub nulls: *mut bool,
    pub nelems: ::core::ffi::c_int,
    pub op: MinMaxOp::Type,
    pub finfo: *mut FmgrInfo,
    pub fcinfo_data: FunctionCallInfo,
}
impl Default for ExprEvalStep__bindgen_ty_1__bindgen_ty_24 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExprEvalStep__bindgen_ty_1__bindgen_ty_25 {
    pub fieldnum: AttrNumber,
    pub resulttype: Oid,
    pub rowcache: ExprEvalRowtypeCache,
}
impl Default for ExprEvalStep__bindgen_ty_1__bindgen_ty_25 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExprEvalStep__bindgen_ty_1__bindgen_ty_26 {
    pub fstore: *mut FieldStore,
    pub rowcache: *mut ExprEvalRowtypeCache,
    pub values: *mut Datum,
    pub nulls: *mut bool,
    pub ncolumns: ::core::ffi::c_int,
}
impl Default for ExprEvalStep__bindgen_ty_1__bindgen_ty_26 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExprEvalStep__bindgen_ty_1__bindgen_ty_27 {
    pub subscriptfunc: ExecEvalBoolSubroutine,
    pub state: *mut SubscriptingRefState,
    pub jumpdone: ::core::ffi::c_int,
}
impl Default for ExprEvalStep__bindgen_ty_1__bindgen_ty_27 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExprEvalStep__bindgen_ty_1__bindgen_ty_28 {
    pub subscriptfunc: ExecEvalSubroutine,
    pub state: *mut SubscriptingRefState,
}
impl Default for ExprEvalStep__bindgen_ty_1__bindgen_ty_28 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExprEvalStep__bindgen_ty_1__bindgen_ty_29 {
    pub constraintname: *mut ::core::ffi::c_char,
    pub checkvalue: *mut Datum,
    pub checknull: *mut bool,
    pub resulttype: Oid,
}
impl Default for ExprEvalStep__bindgen_ty_1__bindgen_ty_29 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExprEvalStep__bindgen_ty_1__bindgen_ty_30 {
    pub inputtype: Oid,
    pub outputtype: Oid,
    pub incache: *mut ExprEvalRowtypeCache,
    pub outcache: *mut ExprEvalRowtypeCache,
    pub map: *mut TupleConversionMap,
}
impl Default for ExprEvalStep__bindgen_ty_1__bindgen_ty_30 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExprEvalStep__bindgen_ty_1__bindgen_ty_31 {
    pub element_type: Oid,
    pub useOr: bool,
    pub typlen: int16,
    pub typbyval: bool,
    pub typalign: ::core::ffi::c_char,
    pub finfo: *mut FmgrInfo,
    pub fcinfo_data: FunctionCallInfo,
    pub fn_addr: PGFunction,
}
impl Default for ExprEvalStep__bindgen_ty_1__bindgen_ty_31 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExprEvalStep__bindgen_ty_1__bindgen_ty_32 {
    pub has_nulls: bool,
    pub inclause: bool,
    pub elements_tab: *mut ScalarArrayOpExprHashTable,
    pub finfo: *mut FmgrInfo,
    pub fcinfo_data: FunctionCallInfo,
    pub saop: *mut ScalarArrayOpExpr,
}
impl Default for ExprEvalStep__bindgen_ty_1__bindgen_ty_32 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExprEvalStep__bindgen_ty_1__bindgen_ty_33 {
    pub xexpr: *mut XmlExpr,
    pub named_argvalue: *mut Datum,
    pub named_argnull: *mut bool,
    pub argvalue: *mut Datum,
    pub argnull: *mut bool,
}
impl Default for ExprEvalStep__bindgen_ty_1__bindgen_ty_33 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ExprEvalStep__bindgen_ty_1__bindgen_ty_34 {
    pub aggno: ::core::ffi::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExprEvalStep__bindgen_ty_1__bindgen_ty_35 {
    pub clauses: *mut List,
}
impl Default for ExprEvalStep__bindgen_ty_1__bindgen_ty_35 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExprEvalStep__bindgen_ty_1__bindgen_ty_36 {
    pub wfstate: *mut WindowFuncExprState,
}
impl Default for ExprEvalStep__bindgen_ty_1__bindgen_ty_36 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExprEvalStep__bindgen_ty_1__bindgen_ty_37 {
    pub sstate: *mut SubPlanState,
}
impl Default for ExprEvalStep__bindgen_ty_1__bindgen_ty_37 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExprEvalStep__bindgen_ty_1__bindgen_ty_38 {
    pub fcinfo_data: FunctionCallInfo,
    pub jumpnull: ::core::ffi::c_int,
}
impl Default for ExprEvalStep__bindgen_ty_1__bindgen_ty_38 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExprEvalStep__bindgen_ty_1__bindgen_ty_39 {
    pub args: *mut NullableDatum,
    pub nulls: *mut bool,
    pub nargs: ::core::ffi::c_int,
    pub jumpnull: ::core::ffi::c_int,
}
impl Default for ExprEvalStep__bindgen_ty_1__bindgen_ty_39 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ExprEvalStep__bindgen_ty_1__bindgen_ty_40 {
    pub setoff: ::core::ffi::c_int,
    pub jumpnull: ::core::ffi::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExprEvalStep__bindgen_ty_1__bindgen_ty_41 {
    pub pertrans: AggStatePerTrans,
    pub aggcontext: *mut ExprContext,
    pub setno: ::core::ffi::c_int,
    pub transno: ::core::ffi::c_int,
    pub setoff: ::core::ffi::c_int,
}
impl Default for ExprEvalStep__bindgen_ty_1__bindgen_ty_41 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for ExprEvalStep__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for ExprEvalStep {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SubscriptingRefState {
    pub isassignment: bool,
    pub workspace: *mut ::core::ffi::c_void,
    pub numupper: ::core::ffi::c_int,
    pub upperprovided: *mut bool,
    pub upperindex: *mut Datum,
    pub upperindexnull: *mut bool,
    pub numlower: ::core::ffi::c_int,
    pub lowerprovided: *mut bool,
    pub lowerindex: *mut Datum,
    pub lowerindexnull: *mut bool,
    pub replacevalue: Datum,
    pub replacenull: bool,
    pub prevvalue: Datum,
    pub prevnull: bool,
}
impl Default for SubscriptingRefState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct SubscriptExecSteps {
    pub sbs_check_subscripts: ExecEvalBoolSubroutine,
    pub sbs_fetch: ExecEvalSubroutine,
    pub sbs_assign: ExecEvalSubroutine,
    pub sbs_fetch_old: ExecEvalSubroutine,
}
pub mod RawParseMode {
    pub type Type = ::core::ffi::c_uint;
    pub const RAW_PARSE_DEFAULT: Type = 0;
    pub const RAW_PARSE_TYPE_NAME: Type = 1;
    pub const RAW_PARSE_PLPGSQL_EXPR: Type = 2;
    pub const RAW_PARSE_PLPGSQL_ASSIGN1: Type = 3;
    pub const RAW_PARSE_PLPGSQL_ASSIGN2: Type = 4;
    pub const RAW_PARSE_PLPGSQL_ASSIGN3: Type = 5;
}
pub mod BackslashQuoteType {
    pub type Type = ::core::ffi::c_uint;
    pub const BACKSLASH_QUOTE_OFF: Type = 0;
    pub const BACKSLASH_QUOTE_ON: Type = 1;
    pub const BACKSLASH_QUOTE_SAFE_ENCODING: Type = 2;
}
pub mod PortalStrategy {
    pub type Type = ::core::ffi::c_uint;
    pub const PORTAL_ONE_SELECT: Type = 0;
    pub const PORTAL_ONE_RETURNING: Type = 1;
    pub const PORTAL_ONE_MOD_WITH: Type = 2;
    pub const PORTAL_UTIL_SELECT: Type = 3;
    pub const PORTAL_MULTI_QUERY: Type = 4;
}
pub mod PortalStatus {
    pub type Type = ::core::ffi::c_uint;
    pub const PORTAL_NEW: Type = 0;
    pub const PORTAL_DEFINED: Type = 1;
    pub const PORTAL_READY: Type = 2;
    pub const PORTAL_ACTIVE: Type = 3;
    pub const PORTAL_DONE: Type = 4;
    pub const PORTAL_FAILED: Type = 5;
}
pub type Portal = *mut PortalData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PortalData {
    pub name: *const ::core::ffi::c_char,
    pub prepStmtName: *const ::core::ffi::c_char,
    pub portalContext: MemoryContext,
    pub resowner: ResourceOwner,
    pub cleanup: ::core::option::Option<unsafe extern "C-unwind" fn(portal: Portal)>,
    pub createSubid: SubTransactionId,
    pub activeSubid: SubTransactionId,
    pub createLevel: ::core::ffi::c_int,
    pub sourceText: *const ::core::ffi::c_char,
    pub commandTag: CommandTag::Type,
    pub qc: QueryCompletion,
    pub stmts: *mut List,
    pub cplan: *mut CachedPlan,
    pub portalParams: ParamListInfo,
    pub queryEnv: *mut QueryEnvironment,
    pub strategy: PortalStrategy::Type,
    pub cursorOptions: ::core::ffi::c_int,
    pub run_once: bool,
    pub status: PortalStatus::Type,
    pub portalPinned: bool,
    pub autoHeld: bool,
    pub queryDesc: *mut QueryDesc,
    pub tupDesc: TupleDesc,
    pub formats: *mut int16,
    pub portalSnapshot: Snapshot,
    pub holdStore: *mut Tuplestorestate,
    pub holdContext: MemoryContext,
    pub holdSnapshot: Snapshot,
    pub atStart: bool,
    pub atEnd: bool,
    pub portalPos: uint64,
    pub creation_time: TimestampTz,
    pub visible: bool,
}
impl Default for PortalData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SPITupleTable {
    pub tupdesc: TupleDesc,
    pub vals: *mut HeapTuple,
    pub numvals: uint64,
    pub alloced: uint64,
    pub tuptabcxt: MemoryContext,
    pub next: slist_node,
    pub subid: SubTransactionId,
}
impl Default for SPITupleTable {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SPIPrepareOptions {
    pub parserSetup: ParserSetupHook,
    pub parserSetupArg: *mut ::core::ffi::c_void,
    pub parseMode: RawParseMode::Type,
    pub cursorOptions: ::core::ffi::c_int,
}
impl Default for SPIPrepareOptions {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SPIExecuteOptions {
    pub params: ParamListInfo,
    pub read_only: bool,
    pub allow_nonatomic: bool,
    pub must_return_tuples: bool,
    pub tcount: uint64,
    pub dest: *mut DestReceiver,
    pub owner: ResourceOwner,
}
impl Default for SPIExecuteOptions {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SPIParseOpenOptions {
    pub params: ParamListInfo,
    pub cursorOptions: ::core::ffi::c_int,
    pub read_only: bool,
}
impl Default for SPIParseOpenOptions {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _SPI_plan {
    _unused: [u8; 0],
}
pub type SPIPlanPtr = *mut _SPI_plan;
pub type Relids = *mut Bitmapset;
pub mod CostSelector {
    pub type Type = ::core::ffi::c_uint;
    pub const STARTUP_COST: Type = 0;
    pub const TOTAL_COST: Type = 1;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct QualCost {
    pub startup: Cost,
    pub per_tuple: Cost,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct AggClauseCosts {
    pub transCost: QualCost,
    pub finalCost: QualCost,
    pub transitionSpace: Size,
}
pub mod UpperRelationKind {
    pub type Type = ::core::ffi::c_uint;
    pub const UPPERREL_SETOP: Type = 0;
    pub const UPPERREL_PARTIAL_GROUP_AGG: Type = 1;
    pub const UPPERREL_GROUP_AGG: Type = 2;
    pub const UPPERREL_WINDOW: Type = 3;
    pub const UPPERREL_PARTIAL_DISTINCT: Type = 4;
    pub const UPPERREL_DISTINCT: Type = 5;
    pub const UPPERREL_ORDERED: Type = 6;
    pub const UPPERREL_FINAL: Type = 7;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PlannerGlobal {
    pub type_: NodeTag,
    pub boundParams: ParamListInfo,
    pub subplans: *mut List,
    pub subroots: *mut List,
    pub rewindPlanIDs: *mut Bitmapset,
    pub finalrtable: *mut List,
    pub finalrowmarks: *mut List,
    pub resultRelations: *mut List,
    pub appendRelations: *mut List,
    pub relationOids: *mut List,
    pub invalItems: *mut List,
    pub paramExecTypes: *mut List,
    pub lastPHId: Index,
    pub lastRowMarkId: Index,
    pub lastPlanNodeId: ::core::ffi::c_int,
    pub transientPlan: bool,
    pub dependsOnRole: bool,
    pub parallelModeOK: bool,
    pub parallelModeNeeded: bool,
    pub maxParallelHazard: ::core::ffi::c_char,
    pub partition_directory: PartitionDirectory,
}
impl Default for PlannerGlobal {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PlannerInfo {
    pub type_: NodeTag,
    pub parse: *mut Query,
    pub glob: *mut PlannerGlobal,
    pub query_level: Index,
    pub parent_root: *mut PlannerInfo,
    pub plan_params: *mut List,
    pub outer_params: *mut Bitmapset,
    pub simple_rel_array: *mut *mut RelOptInfo,
    pub simple_rel_array_size: ::core::ffi::c_int,
    pub simple_rte_array: *mut *mut RangeTblEntry,
    pub append_rel_array: *mut *mut AppendRelInfo,
    pub all_baserels: Relids,
    pub nullable_baserels: Relids,
    pub join_rel_list: *mut List,
    pub join_rel_hash: *mut HTAB,
    pub join_rel_level: *mut *mut List,
    pub join_cur_level: ::core::ffi::c_int,
    pub init_plans: *mut List,
    pub cte_plan_ids: *mut List,
    pub multiexpr_params: *mut List,
    pub eq_classes: *mut List,
    pub ec_merging_done: bool,
    pub canon_pathkeys: *mut List,
    pub left_join_clauses: *mut List,
    pub right_join_clauses: *mut List,
    pub full_join_clauses: *mut List,
    pub join_info_list: *mut List,
    pub all_result_relids: Relids,
    pub leaf_result_relids: Relids,
    pub append_rel_list: *mut List,
    pub row_identity_vars: *mut List,
    pub rowMarks: *mut List,
    pub placeholder_list: *mut List,
    pub fkey_list: *mut List,
    pub query_pathkeys: *mut List,
    pub group_pathkeys: *mut List,
    pub window_pathkeys: *mut List,
    pub distinct_pathkeys: *mut List,
    pub sort_pathkeys: *mut List,
    pub part_schemes: *mut List,
    pub initial_rels: *mut List,
    pub upper_rels: [*mut List; 8usize],
    pub upper_targets: [*mut PathTarget; 8usize],
    pub processed_tlist: *mut List,
    pub update_colnos: *mut List,
    pub grouping_map: *mut AttrNumber,
    pub minmax_aggs: *mut List,
    pub planner_cxt: MemoryContext,
    pub total_table_pages: Cardinality,
    pub tuple_fraction: Selectivity,
    pub limit_tuples: Cardinality,
    pub qual_security_level: Index,
    pub hasJoinRTEs: bool,
    pub hasLateralRTEs: bool,
    pub hasHavingQual: bool,
    pub hasPseudoConstantQuals: bool,
    pub hasAlternativeSubPlans: bool,
    pub hasRecursion: bool,
    pub agginfos: *mut List,
    pub aggtransinfos: *mut List,
    pub numOrderedAggs: ::core::ffi::c_int,
    pub hasNonPartialAggs: bool,
    pub hasNonSerialAggs: bool,
    pub wt_param_id: ::core::ffi::c_int,
    pub non_recursive_path: *mut Path,
    pub curOuterRels: Relids,
    pub curOuterParams: *mut List,
    pub isAltSubplan: *mut bool,
    pub isUsedSubplan: *mut bool,
    pub join_search_private: *mut ::core::ffi::c_void,
    pub partColsUpdated: bool,
}
impl Default for PlannerInfo {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionSchemeData {
    pub strategy: ::core::ffi::c_char,
    pub partnatts: int16,
    pub partopfamily: *mut Oid,
    pub partopcintype: *mut Oid,
    pub partcollation: *mut Oid,
    pub parttyplen: *mut int16,
    pub parttypbyval: *mut bool,
    pub partsupfunc: *mut FmgrInfo,
}
impl Default for PartitionSchemeData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type PartitionScheme = *mut PartitionSchemeData;
pub mod RelOptKind {
    pub type Type = ::core::ffi::c_uint;
    pub const RELOPT_BASEREL: Type = 0;
    pub const RELOPT_JOINREL: Type = 1;
    pub const RELOPT_OTHER_MEMBER_REL: Type = 2;
    pub const RELOPT_OTHER_JOINREL: Type = 3;
    pub const RELOPT_UPPER_REL: Type = 4;
    pub const RELOPT_OTHER_UPPER_REL: Type = 5;
    pub const RELOPT_DEADREL: Type = 6;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RelOptInfo {
    pub type_: NodeTag,
    pub reloptkind: RelOptKind::Type,
    pub relids: Relids,
    pub rows: Cardinality,
    pub consider_startup: bool,
    pub consider_param_startup: bool,
    pub consider_parallel: bool,
    pub reltarget: *mut PathTarget,
    pub pathlist: *mut List,
    pub ppilist: *mut List,
    pub partial_pathlist: *mut List,
    pub cheapest_startup_path: *mut Path,
    pub cheapest_total_path: *mut Path,
    pub cheapest_unique_path: *mut Path,
    pub cheapest_parameterized_paths: *mut List,
    pub direct_lateral_relids: Relids,
    pub lateral_relids: Relids,
    pub relid: Index,
    pub reltablespace: Oid,
    pub rtekind: RTEKind::Type,
    pub min_attr: AttrNumber,
    pub max_attr: AttrNumber,
    pub attr_needed: *mut Relids,
    pub attr_widths: *mut int32,
    pub lateral_vars: *mut List,
    pub lateral_referencers: Relids,
    pub indexlist: *mut List,
    pub statlist: *mut List,
    pub pages: BlockNumber,
    pub tuples: Cardinality,
    pub allvisfrac: f64,
    pub eclass_indexes: *mut Bitmapset,
    pub subroot: *mut PlannerInfo,
    pub subplan_params: *mut List,
    pub rel_parallel_workers: ::core::ffi::c_int,
    pub amflags: uint32,
    pub serverid: Oid,
    pub userid: Oid,
    pub useridiscurrent: bool,
    pub fdwroutine: *mut FdwRoutine,
    pub fdw_private: *mut ::core::ffi::c_void,
    pub unique_for_rels: *mut List,
    pub non_unique_for_rels: *mut List,
    pub baserestrictinfo: *mut List,
    pub baserestrictcost: QualCost,
    pub baserestrict_min_security: Index,
    pub joininfo: *mut List,
    pub has_eclass_joins: bool,
    pub consider_partitionwise_join: bool,
    pub top_parent_relids: Relids,
    pub part_scheme: PartitionScheme,
    pub nparts: ::core::ffi::c_int,
    pub boundinfo: *mut PartitionBoundInfoData,
    pub partbounds_merged: bool,
    pub partition_qual: *mut List,
    pub part_rels: *mut *mut RelOptInfo,
    pub live_parts: *mut Bitmapset,
    pub all_partrels: Relids,
    pub partexprs: *mut *mut List,
    pub nullable_partexprs: *mut *mut List,
}
impl Default for RelOptInfo {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexOptInfo {
    pub type_: NodeTag,
    pub indexoid: Oid,
    pub reltablespace: Oid,
    pub rel: *mut RelOptInfo,
    pub pages: BlockNumber,
    pub tuples: Cardinality,
    pub tree_height: ::core::ffi::c_int,
    pub ncolumns: ::core::ffi::c_int,
    pub nkeycolumns: ::core::ffi::c_int,
    pub indexkeys: *mut ::core::ffi::c_int,
    pub indexcollations: *mut Oid,
    pub opfamily: *mut Oid,
    pub opcintype: *mut Oid,
    pub sortopfamily: *mut Oid,
    pub reverse_sort: *mut bool,
    pub nulls_first: *mut bool,
    pub opclassoptions: *mut *mut bytea,
    pub canreturn: *mut bool,
    pub relam: Oid,
    pub indexprs: *mut List,
    pub indpred: *mut List,
    pub indextlist: *mut List,
    pub indrestrictinfo: *mut List,
    pub predOK: bool,
    pub unique: bool,
    pub immediate: bool,
    pub hypothetical: bool,
    pub amcanorderbyop: bool,
    pub amoptionalkey: bool,
    pub amsearcharray: bool,
    pub amsearchnulls: bool,
    pub amhasgettuple: bool,
    pub amhasgetbitmap: bool,
    pub amcanparallel: bool,
    pub amcanmarkpos: bool,
    pub amcostestimate: ::core::option::Option<unsafe extern "C-unwind" fn()>,
}
impl Default for IndexOptInfo {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ForeignKeyOptInfo {
    pub type_: NodeTag,
    pub con_relid: Index,
    pub ref_relid: Index,
    pub nkeys: ::core::ffi::c_int,
    pub conkey: [AttrNumber; 32usize],
    pub confkey: [AttrNumber; 32usize],
    pub conpfeqop: [Oid; 32usize],
    pub nmatched_ec: ::core::ffi::c_int,
    pub nconst_ec: ::core::ffi::c_int,
    pub nmatched_rcols: ::core::ffi::c_int,
    pub nmatched_ri: ::core::ffi::c_int,
    pub eclass: [*mut EquivalenceClass; 32usize],
    pub fk_eclass_member: [*mut EquivalenceMember; 32usize],
    pub rinfos: [*mut List; 32usize],
}
impl Default for ForeignKeyOptInfo {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StatisticExtInfo {
    pub type_: NodeTag,
    pub statOid: Oid,
    pub inherit: bool,
    pub rel: *mut RelOptInfo,
    pub kind: ::core::ffi::c_char,
    pub keys: *mut Bitmapset,
    pub exprs: *mut List,
}
impl Default for StatisticExtInfo {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct EquivalenceClass {
    pub type_: NodeTag,
    pub ec_opfamilies: *mut List,
    pub ec_collation: Oid,
    pub ec_members: *mut List,
    pub ec_sources: *mut List,
    pub ec_derives: *mut List,
    pub ec_relids: Relids,
    pub ec_has_const: bool,
    pub ec_has_volatile: bool,
    pub ec_below_outer_join: bool,
    pub ec_broken: bool,
    pub ec_sortref: Index,
    pub ec_min_security: Index,
    pub ec_max_security: Index,
    pub ec_merged: *mut EquivalenceClass,
}
impl Default for EquivalenceClass {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct EquivalenceMember {
    pub type_: NodeTag,
    pub em_expr: *mut Expr,
    pub em_relids: Relids,
    pub em_nullable_relids: Relids,
    pub em_is_const: bool,
    pub em_is_child: bool,
    pub em_datatype: Oid,
}
impl Default for EquivalenceMember {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PathKey {
    pub type_: NodeTag,
    pub pk_eclass: *mut EquivalenceClass,
    pub pk_opfamily: Oid,
    pub pk_strategy: ::core::ffi::c_int,
    pub pk_nulls_first: bool,
}
impl Default for PathKey {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod VolatileFunctionStatus {
    pub type Type = ::core::ffi::c_uint;
    pub const VOLATILITY_UNKNOWN: Type = 0;
    pub const VOLATILITY_VOLATILE: Type = 1;
    pub const VOLATILITY_NOVOLATILE: Type = 2;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PathTarget {
    pub type_: NodeTag,
    pub exprs: *mut List,
    pub sortgrouprefs: *mut Index,
    pub cost: QualCost,
    pub width: ::core::ffi::c_int,
    pub has_volatile_expr: VolatileFunctionStatus::Type,
}
impl Default for PathTarget {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ParamPathInfo {
    pub type_: NodeTag,
    pub ppi_req_outer: Relids,
    pub ppi_rows: Cardinality,
    pub ppi_clauses: *mut List,
}
impl Default for ParamPathInfo {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Path {
    pub type_: NodeTag,
    pub pathtype: NodeTag,
    pub parent: *mut RelOptInfo,
    pub pathtarget: *mut PathTarget,
    pub param_info: *mut ParamPathInfo,
    pub parallel_aware: bool,
    pub parallel_safe: bool,
    pub parallel_workers: ::core::ffi::c_int,
    pub rows: Cardinality,
    pub startup_cost: Cost,
    pub total_cost: Cost,
    pub pathkeys: *mut List,
}
impl Default for Path {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexPath {
    pub path: Path,
    pub indexinfo: *mut IndexOptInfo,
    pub indexclauses: *mut List,
    pub indexorderbys: *mut List,
    pub indexorderbycols: *mut List,
    pub indexscandir: ScanDirection::Type,
    pub indextotalcost: Cost,
    pub indexselectivity: Selectivity,
}
impl Default for IndexPath {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexClause {
    pub type_: NodeTag,
    pub rinfo: *mut RestrictInfo,
    pub indexquals: *mut List,
    pub lossy: bool,
    pub indexcol: AttrNumber,
    pub indexcols: *mut List,
}
impl Default for IndexClause {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BitmapHeapPath {
    pub path: Path,
    pub bitmapqual: *mut Path,
}
impl Default for BitmapHeapPath {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BitmapAndPath {
    pub path: Path,
    pub bitmapquals: *mut List,
    pub bitmapselectivity: Selectivity,
}
impl Default for BitmapAndPath {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BitmapOrPath {
    pub path: Path,
    pub bitmapquals: *mut List,
    pub bitmapselectivity: Selectivity,
}
impl Default for BitmapOrPath {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TidPath {
    pub path: Path,
    pub tidquals: *mut List,
}
impl Default for TidPath {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TidRangePath {
    pub path: Path,
    pub tidrangequals: *mut List,
}
impl Default for TidRangePath {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SubqueryScanPath {
    pub path: Path,
    pub subpath: *mut Path,
}
impl Default for SubqueryScanPath {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ForeignPath {
    pub path: Path,
    pub fdw_outerpath: *mut Path,
    pub fdw_private: *mut List,
}
impl Default for ForeignPath {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CustomPath {
    pub path: Path,
    pub flags: uint32,
    pub custom_paths: *mut List,
    pub custom_private: *mut List,
    pub methods: *const CustomPathMethods,
}
impl Default for CustomPath {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AppendPath {
    pub path: Path,
    pub subpaths: *mut List,
    pub first_partial_path: ::core::ffi::c_int,
    pub limit_tuples: Cardinality,
}
impl Default for AppendPath {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MergeAppendPath {
    pub path: Path,
    pub subpaths: *mut List,
    pub limit_tuples: Cardinality,
}
impl Default for MergeAppendPath {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GroupResultPath {
    pub path: Path,
    pub quals: *mut List,
}
impl Default for GroupResultPath {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MaterialPath {
    pub path: Path,
    pub subpath: *mut Path,
}
impl Default for MaterialPath {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MemoizePath {
    pub path: Path,
    pub subpath: *mut Path,
    pub hash_operators: *mut List,
    pub param_exprs: *mut List,
    pub singlerow: bool,
    pub binary_mode: bool,
    pub calls: Cardinality,
    pub est_entries: uint32,
}
impl Default for MemoizePath {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod UniquePathMethod {
    pub type Type = ::core::ffi::c_uint;
    pub const UNIQUE_PATH_NOOP: Type = 0;
    pub const UNIQUE_PATH_HASH: Type = 1;
    pub const UNIQUE_PATH_SORT: Type = 2;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct UniquePath {
    pub path: Path,
    pub subpath: *mut Path,
    pub umethod: UniquePathMethod::Type,
    pub in_operators: *mut List,
    pub uniq_exprs: *mut List,
}
impl Default for UniquePath {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GatherPath {
    pub path: Path,
    pub subpath: *mut Path,
    pub single_copy: bool,
    pub num_workers: ::core::ffi::c_int,
}
impl Default for GatherPath {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GatherMergePath {
    pub path: Path,
    pub subpath: *mut Path,
    pub num_workers: ::core::ffi::c_int,
}
impl Default for GatherMergePath {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct JoinPath {
    pub path: Path,
    pub jointype: JoinType::Type,
    pub inner_unique: bool,
    pub outerjoinpath: *mut Path,
    pub innerjoinpath: *mut Path,
    pub joinrestrictinfo: *mut List,
}
impl Default for JoinPath {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NestPath {
    pub jpath: JoinPath,
}
impl Default for NestPath {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MergePath {
    pub jpath: JoinPath,
    pub path_mergeclauses: *mut List,
    pub outersortkeys: *mut List,
    pub innersortkeys: *mut List,
    pub skip_mark_restore: bool,
    pub materialize_inner: bool,
}
impl Default for MergePath {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HashPath {
    pub jpath: JoinPath,
    pub path_hashclauses: *mut List,
    pub num_batches: ::core::ffi::c_int,
    pub inner_rows_total: Cardinality,
}
impl Default for HashPath {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ProjectionPath {
    pub path: Path,
    pub subpath: *mut Path,
    pub dummypp: bool,
}
impl Default for ProjectionPath {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ProjectSetPath {
    pub path: Path,
    pub subpath: *mut Path,
}
impl Default for ProjectSetPath {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SortPath {
    pub path: Path,
    pub subpath: *mut Path,
}
impl Default for SortPath {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IncrementalSortPath {
    pub spath: SortPath,
    pub nPresortedCols: ::core::ffi::c_int,
}
impl Default for IncrementalSortPath {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GroupPath {
    pub path: Path,
    pub subpath: *mut Path,
    pub groupClause: *mut List,
    pub qual: *mut List,
}
impl Default for GroupPath {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct UpperUniquePath {
    pub path: Path,
    pub subpath: *mut Path,
    pub numkeys: ::core::ffi::c_int,
}
impl Default for UpperUniquePath {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AggPath {
    pub path: Path,
    pub subpath: *mut Path,
    pub aggstrategy: AggStrategy::Type,
    pub aggsplit: AggSplit::Type,
    pub numGroups: Cardinality,
    pub transitionSpace: uint64,
    pub groupClause: *mut List,
    pub qual: *mut List,
}
impl Default for AggPath {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GroupingSetData {
    pub type_: NodeTag,
    pub set: *mut List,
    pub numGroups: Cardinality,
}
impl Default for GroupingSetData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RollupData {
    pub type_: NodeTag,
    pub groupClause: *mut List,
    pub gsets: *mut List,
    pub gsets_data: *mut List,
    pub numGroups: Cardinality,
    pub hashable: bool,
    pub is_hashed: bool,
}
impl Default for RollupData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GroupingSetsPath {
    pub path: Path,
    pub subpath: *mut Path,
    pub aggstrategy: AggStrategy::Type,
    pub rollups: *mut List,
    pub qual: *mut List,
    pub transitionSpace: uint64,
}
impl Default for GroupingSetsPath {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MinMaxAggPath {
    pub path: Path,
    pub mmaggregates: *mut List,
    pub quals: *mut List,
}
impl Default for MinMaxAggPath {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WindowAggPath {
    pub path: Path,
    pub subpath: *mut Path,
    pub winclause: *mut WindowClause,
    pub qual: *mut List,
    pub topwindow: bool,
}
impl Default for WindowAggPath {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SetOpPath {
    pub path: Path,
    pub subpath: *mut Path,
    pub cmd: SetOpCmd::Type,
    pub strategy: SetOpStrategy::Type,
    pub distinctList: *mut List,
    pub flagColIdx: AttrNumber,
    pub firstFlag: ::core::ffi::c_int,
    pub numGroups: Cardinality,
}
impl Default for SetOpPath {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RecursiveUnionPath {
    pub path: Path,
    pub leftpath: *mut Path,
    pub rightpath: *mut Path,
    pub distinctList: *mut List,
    pub wtParam: ::core::ffi::c_int,
    pub numGroups: Cardinality,
}
impl Default for RecursiveUnionPath {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LockRowsPath {
    pub path: Path,
    pub subpath: *mut Path,
    pub rowMarks: *mut List,
    pub epqParam: ::core::ffi::c_int,
}
impl Default for LockRowsPath {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ModifyTablePath {
    pub path: Path,
    pub subpath: *mut Path,
    pub operation: CmdType::Type,
    pub canSetTag: bool,
    pub nominalRelation: Index,
    pub rootRelation: Index,
    pub partColsUpdated: bool,
    pub resultRelations: *mut List,
    pub updateColnosLists: *mut List,
    pub withCheckOptionLists: *mut List,
    pub returningLists: *mut List,
    pub rowMarks: *mut List,
    pub onconflict: *mut OnConflictExpr,
    pub epqParam: ::core::ffi::c_int,
    pub mergeActionLists: *mut List,
}
impl Default for ModifyTablePath {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LimitPath {
    pub path: Path,
    pub subpath: *mut Path,
    pub limitOffset: *mut Node,
    pub limitCount: *mut Node,
    pub limitOption: LimitOption::Type,
}
impl Default for LimitPath {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RestrictInfo {
    pub type_: NodeTag,
    pub clause: *mut Expr,
    pub is_pushed_down: bool,
    pub outerjoin_delayed: bool,
    pub can_join: bool,
    pub pseudoconstant: bool,
    pub leakproof: bool,
    pub has_volatile: VolatileFunctionStatus::Type,
    pub security_level: Index,
    pub clause_relids: Relids,
    pub required_relids: Relids,
    pub outer_relids: Relids,
    pub nullable_relids: Relids,
    pub left_relids: Relids,
    pub right_relids: Relids,
    pub orclause: *mut Expr,
    pub parent_ec: *mut EquivalenceClass,
    pub eval_cost: QualCost,
    pub norm_selec: Selectivity,
    pub outer_selec: Selectivity,
    pub mergeopfamilies: *mut List,
    pub left_ec: *mut EquivalenceClass,
    pub right_ec: *mut EquivalenceClass,
    pub left_em: *mut EquivalenceMember,
    pub right_em: *mut EquivalenceMember,
    pub scansel_cache: *mut List,
    pub outer_is_left: bool,
    pub hashjoinoperator: Oid,
    pub left_bucketsize: Selectivity,
    pub right_bucketsize: Selectivity,
    pub left_mcvfreq: Selectivity,
    pub right_mcvfreq: Selectivity,
    pub left_hasheqoperator: Oid,
    pub right_hasheqoperator: Oid,
}
impl Default for RestrictInfo {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MergeScanSelCache {
    pub opfamily: Oid,
    pub collation: Oid,
    pub strategy: ::core::ffi::c_int,
    pub nulls_first: bool,
    pub leftstartsel: Selectivity,
    pub leftendsel: Selectivity,
    pub rightstartsel: Selectivity,
    pub rightendsel: Selectivity,
}
impl Default for MergeScanSelCache {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PlaceHolderVar {
    pub xpr: Expr,
    pub phexpr: *mut Expr,
    pub phrels: Relids,
    pub phid: Index,
    pub phlevelsup: Index,
}
impl Default for PlaceHolderVar {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SpecialJoinInfo {
    pub type_: NodeTag,
    pub min_lefthand: Relids,
    pub min_righthand: Relids,
    pub syn_lefthand: Relids,
    pub syn_righthand: Relids,
    pub jointype: JoinType::Type,
    pub lhs_strict: bool,
    pub delay_upper_joins: bool,
    pub semi_can_btree: bool,
    pub semi_can_hash: bool,
    pub semi_operators: *mut List,
    pub semi_rhs_exprs: *mut List,
}
impl Default for SpecialJoinInfo {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AppendRelInfo {
    pub type_: NodeTag,
    pub parent_relid: Index,
    pub child_relid: Index,
    pub parent_reltype: Oid,
    pub child_reltype: Oid,
    pub translated_vars: *mut List,
    pub num_child_cols: ::core::ffi::c_int,
    pub parent_colnos: *mut AttrNumber,
    pub parent_reloid: Oid,
}
impl Default for AppendRelInfo {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RowIdentityVarInfo {
    pub type_: NodeTag,
    pub rowidvar: *mut Var,
    pub rowidwidth: int32,
    pub rowidname: *mut ::core::ffi::c_char,
    pub rowidrels: Relids,
}
impl Default for RowIdentityVarInfo {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PlaceHolderInfo {
    pub type_: NodeTag,
    pub phid: Index,
    pub ph_var: *mut PlaceHolderVar,
    pub ph_eval_at: Relids,
    pub ph_lateral: Relids,
    pub ph_needed: Relids,
    pub ph_width: int32,
}
impl Default for PlaceHolderInfo {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MinMaxAggInfo {
    pub type_: NodeTag,
    pub aggfnoid: Oid,
    pub aggsortop: Oid,
    pub target: *mut Expr,
    pub subroot: *mut PlannerInfo,
    pub path: *mut Path,
    pub pathcost: Cost,
    pub param: *mut Param,
}
impl Default for MinMaxAggInfo {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PlannerParamItem {
    pub type_: NodeTag,
    pub item: *mut Node,
    pub paramId: ::core::ffi::c_int,
}
impl Default for PlannerParamItem {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct SemiAntiJoinFactors {
    pub outer_match_frac: Selectivity,
    pub match_count: Selectivity,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct JoinPathExtraData {
    pub restrictlist: *mut List,
    pub mergeclause_list: *mut List,
    pub inner_unique: bool,
    pub sjinfo: *mut SpecialJoinInfo,
    pub semifactors: SemiAntiJoinFactors,
    pub param_source_rels: Relids,
}
impl Default for JoinPathExtraData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod PartitionwiseAggregateType {
    pub type Type = ::core::ffi::c_uint;
    pub const PARTITIONWISE_AGGREGATE_NONE: Type = 0;
    pub const PARTITIONWISE_AGGREGATE_FULL: Type = 1;
    pub const PARTITIONWISE_AGGREGATE_PARTIAL: Type = 2;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GroupPathExtraData {
    pub flags: ::core::ffi::c_int,
    pub partial_costs_set: bool,
    pub agg_partial_costs: AggClauseCosts,
    pub agg_final_costs: AggClauseCosts,
    pub target_parallel_safe: bool,
    pub havingQual: *mut Node,
    pub targetList: *mut List,
    pub patype: PartitionwiseAggregateType::Type,
}
impl Default for GroupPathExtraData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct FinalPathExtraData {
    pub limit_needed: bool,
    pub limit_tuples: Cardinality,
    pub count_est: int64,
    pub offset_est: int64,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct JoinCostWorkspace {
    pub startup_cost: Cost,
    pub total_cost: Cost,
    pub run_cost: Cost,
    pub inner_run_cost: Cost,
    pub inner_rescan_run_cost: Cost,
    pub outer_rows: Cardinality,
    pub inner_rows: Cardinality,
    pub outer_skip_rows: Cardinality,
    pub inner_skip_rows: Cardinality,
    pub numbuckets: ::core::ffi::c_int,
    pub numbatches: ::core::ffi::c_int,
    pub inner_rows_total: Cardinality,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AggInfo {
    pub representative_aggref: *mut Aggref,
    pub transno: ::core::ffi::c_int,
    pub shareable: bool,
    pub finalfn_oid: Oid,
}
impl Default for AggInfo {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AggTransInfo {
    pub args: *mut List,
    pub aggfilter: *mut Expr,
    pub transfn_oid: Oid,
    pub serialfn_oid: Oid,
    pub deserialfn_oid: Oid,
    pub combinefn_oid: Oid,
    pub aggtranstype: Oid,
    pub aggtranstypmod: int32,
    pub transtypeLen: ::core::ffi::c_int,
    pub transtypeByVal: bool,
    pub aggtransspace: int32,
    pub initValue: Datum,
    pub initValueIsNull: bool,
}
impl Default for AggTransInfo {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type GetForeignRelSize_function = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        root: *mut PlannerInfo,
        baserel: *mut RelOptInfo,
        foreigntableid: Oid,
    ),
>;
pub type GetForeignPaths_function = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        root: *mut PlannerInfo,
        baserel: *mut RelOptInfo,
        foreigntableid: Oid,
    ),
>;
pub type GetForeignPlan_function = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        root: *mut PlannerInfo,
        baserel: *mut RelOptInfo,
        foreigntableid: Oid,
        best_path: *mut ForeignPath,
        tlist: *mut List,
        scan_clauses: *mut List,
        outer_plan: *mut Plan,
    ) -> *mut ForeignScan,
>;
pub type BeginForeignScan_function = ::core::option::Option<
    unsafe extern "C-unwind" fn(node: *mut ForeignScanState, eflags: ::core::ffi::c_int),
>;
pub type IterateForeignScan_function = ::core::option::Option<
    unsafe extern "C-unwind" fn(node: *mut ForeignScanState) -> *mut TupleTableSlot,
>;
pub type RecheckForeignScan_function = ::core::option::Option<
    unsafe extern "C-unwind" fn(node: *mut ForeignScanState, slot: *mut TupleTableSlot) -> bool,
>;
pub type ReScanForeignScan_function =
    ::core::option::Option<unsafe extern "C-unwind" fn(node: *mut ForeignScanState)>;
pub type EndForeignScan_function =
    ::core::option::Option<unsafe extern "C-unwind" fn(node: *mut ForeignScanState)>;
pub type GetForeignJoinPaths_function = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        root: *mut PlannerInfo,
        joinrel: *mut RelOptInfo,
        outerrel: *mut RelOptInfo,
        innerrel: *mut RelOptInfo,
        jointype: JoinType::Type,
        extra: *mut JoinPathExtraData,
    ),
>;
pub type GetForeignUpperPaths_function = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        root: *mut PlannerInfo,
        stage: UpperRelationKind::Type,
        input_rel: *mut RelOptInfo,
        output_rel: *mut RelOptInfo,
        extra: *mut ::core::ffi::c_void,
    ),
>;
pub type AddForeignUpdateTargets_function = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        root: *mut PlannerInfo,
        rtindex: Index,
        target_rte: *mut RangeTblEntry,
        target_relation: Relation,
    ),
>;
pub type PlanForeignModify_function = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        root: *mut PlannerInfo,
        plan: *mut ModifyTable,
        resultRelation: Index,
        subplan_index: ::core::ffi::c_int,
    ) -> *mut List,
>;
pub type BeginForeignModify_function = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        mtstate: *mut ModifyTableState,
        rinfo: *mut ResultRelInfo,
        fdw_private: *mut List,
        subplan_index: ::core::ffi::c_int,
        eflags: ::core::ffi::c_int,
    ),
>;
pub type ExecForeignInsert_function = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        estate: *mut EState,
        rinfo: *mut ResultRelInfo,
        slot: *mut TupleTableSlot,
        planSlot: *mut TupleTableSlot,
    ) -> *mut TupleTableSlot,
>;
pub type ExecForeignBatchInsert_function = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        estate: *mut EState,
        rinfo: *mut ResultRelInfo,
        slots: *mut *mut TupleTableSlot,
        planSlots: *mut *mut TupleTableSlot,
        numSlots: *mut ::core::ffi::c_int,
    ) -> *mut *mut TupleTableSlot,
>;
pub type GetForeignModifyBatchSize_function = ::core::option::Option<
    unsafe extern "C-unwind" fn(rinfo: *mut ResultRelInfo) -> ::core::ffi::c_int,
>;
pub type ExecForeignUpdate_function = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        estate: *mut EState,
        rinfo: *mut ResultRelInfo,
        slot: *mut TupleTableSlot,
        planSlot: *mut TupleTableSlot,
    ) -> *mut TupleTableSlot,
>;
pub type ExecForeignDelete_function = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        estate: *mut EState,
        rinfo: *mut ResultRelInfo,
        slot: *mut TupleTableSlot,
        planSlot: *mut TupleTableSlot,
    ) -> *mut TupleTableSlot,
>;
pub type EndForeignModify_function = ::core::option::Option<
    unsafe extern "C-unwind" fn(estate: *mut EState, rinfo: *mut ResultRelInfo),
>;
pub type BeginForeignInsert_function = ::core::option::Option<
    unsafe extern "C-unwind" fn(mtstate: *mut ModifyTableState, rinfo: *mut ResultRelInfo),
>;
pub type EndForeignInsert_function = ::core::option::Option<
    unsafe extern "C-unwind" fn(estate: *mut EState, rinfo: *mut ResultRelInfo),
>;
pub type IsForeignRelUpdatable_function =
    ::core::option::Option<unsafe extern "C-unwind" fn(rel: Relation) -> ::core::ffi::c_int>;
pub type PlanDirectModify_function = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        root: *mut PlannerInfo,
        plan: *mut ModifyTable,
        resultRelation: Index,
        subplan_index: ::core::ffi::c_int,
    ) -> bool,
>;
pub type BeginDirectModify_function = ::core::option::Option<
    unsafe extern "C-unwind" fn(node: *mut ForeignScanState, eflags: ::core::ffi::c_int),
>;
pub type IterateDirectModify_function = ::core::option::Option<
    unsafe extern "C-unwind" fn(node: *mut ForeignScanState) -> *mut TupleTableSlot,
>;
pub type EndDirectModify_function =
    ::core::option::Option<unsafe extern "C-unwind" fn(node: *mut ForeignScanState)>;
pub type GetForeignRowMarkType_function = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        rte: *mut RangeTblEntry,
        strength: LockClauseStrength::Type,
    ) -> RowMarkType::Type,
>;
pub type RefetchForeignRow_function = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        estate: *mut EState,
        erm: *mut ExecRowMark,
        rowid: Datum,
        slot: *mut TupleTableSlot,
        updated: *mut bool,
    ),
>;
pub type ExplainForeignScan_function = ::core::option::Option<
    unsafe extern "C-unwind" fn(node: *mut ForeignScanState, es: *mut ExplainState),
>;
pub type ExplainForeignModify_function = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        mtstate: *mut ModifyTableState,
        rinfo: *mut ResultRelInfo,
        fdw_private: *mut List,
        subplan_index: ::core::ffi::c_int,
        es: *mut ExplainState,
    ),
>;
pub type ExplainDirectModify_function = ::core::option::Option<
    unsafe extern "C-unwind" fn(node: *mut ForeignScanState, es: *mut ExplainState),
>;
pub type AcquireSampleRowsFunc = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        relation: Relation,
        elevel: ::core::ffi::c_int,
        rows: *mut HeapTuple,
        targrows: ::core::ffi::c_int,
        totalrows: *mut f64,
        totaldeadrows: *mut f64,
    ) -> ::core::ffi::c_int,
>;
pub type AnalyzeForeignTable_function = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        relation: Relation,
        func: *mut AcquireSampleRowsFunc,
        totalpages: *mut BlockNumber,
    ) -> bool,
>;
pub type ImportForeignSchema_function = ::core::option::Option<
    unsafe extern "C-unwind" fn(stmt: *mut ImportForeignSchemaStmt, serverOid: Oid) -> *mut List,
>;
pub type ExecForeignTruncate_function = ::core::option::Option<
    unsafe extern "C-unwind" fn(rels: *mut List, behavior: DropBehavior::Type, restart_seqs: bool),
>;
pub type EstimateDSMForeignScan_function = ::core::option::Option<
    unsafe extern "C-unwind" fn(node: *mut ForeignScanState, pcxt: *mut ParallelContext) -> Size,
>;
pub type InitializeDSMForeignScan_function = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        node: *mut ForeignScanState,
        pcxt: *mut ParallelContext,
        coordinate: *mut ::core::ffi::c_void,
    ),
>;
pub type ReInitializeDSMForeignScan_function = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        node: *mut ForeignScanState,
        pcxt: *mut ParallelContext,
        coordinate: *mut ::core::ffi::c_void,
    ),
>;
pub type InitializeWorkerForeignScan_function = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        node: *mut ForeignScanState,
        toc: *mut shm_toc,
        coordinate: *mut ::core::ffi::c_void,
    ),
>;
pub type ShutdownForeignScan_function =
    ::core::option::Option<unsafe extern "C-unwind" fn(node: *mut ForeignScanState)>;
pub type IsForeignScanParallelSafe_function = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        root: *mut PlannerInfo,
        rel: *mut RelOptInfo,
        rte: *mut RangeTblEntry,
    ) -> bool,
>;
pub type ReparameterizeForeignPathByChild_function = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        root: *mut PlannerInfo,
        fdw_private: *mut List,
        child_rel: *mut RelOptInfo,
    ) -> *mut List,
>;
pub type IsForeignPathAsyncCapable_function =
    ::core::option::Option<unsafe extern "C-unwind" fn(path: *mut ForeignPath) -> bool>;
pub type ForeignAsyncRequest_function =
    ::core::option::Option<unsafe extern "C-unwind" fn(areq: *mut AsyncRequest)>;
pub type ForeignAsyncConfigureWait_function =
    ::core::option::Option<unsafe extern "C-unwind" fn(areq: *mut AsyncRequest)>;
pub type ForeignAsyncNotify_function =
    ::core::option::Option<unsafe extern "C-unwind" fn(areq: *mut AsyncRequest)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FdwRoutine {
    pub type_: NodeTag,
    pub GetForeignRelSize: GetForeignRelSize_function,
    pub GetForeignPaths: GetForeignPaths_function,
    pub GetForeignPlan: GetForeignPlan_function,
    pub BeginForeignScan: BeginForeignScan_function,
    pub IterateForeignScan: IterateForeignScan_function,
    pub ReScanForeignScan: ReScanForeignScan_function,
    pub EndForeignScan: EndForeignScan_function,
    pub GetForeignJoinPaths: GetForeignJoinPaths_function,
    pub GetForeignUpperPaths: GetForeignUpperPaths_function,
    pub AddForeignUpdateTargets: AddForeignUpdateTargets_function,
    pub PlanForeignModify: PlanForeignModify_function,
    pub BeginForeignModify: BeginForeignModify_function,
    pub ExecForeignInsert: ExecForeignInsert_function,
    pub ExecForeignBatchInsert: ExecForeignBatchInsert_function,
    pub GetForeignModifyBatchSize: GetForeignModifyBatchSize_function,
    pub ExecForeignUpdate: ExecForeignUpdate_function,
    pub ExecForeignDelete: ExecForeignDelete_function,
    pub EndForeignModify: EndForeignModify_function,
    pub BeginForeignInsert: BeginForeignInsert_function,
    pub EndForeignInsert: EndForeignInsert_function,
    pub IsForeignRelUpdatable: IsForeignRelUpdatable_function,
    pub PlanDirectModify: PlanDirectModify_function,
    pub BeginDirectModify: BeginDirectModify_function,
    pub IterateDirectModify: IterateDirectModify_function,
    pub EndDirectModify: EndDirectModify_function,
    pub GetForeignRowMarkType: GetForeignRowMarkType_function,
    pub RefetchForeignRow: RefetchForeignRow_function,
    pub RecheckForeignScan: RecheckForeignScan_function,
    pub ExplainForeignScan: ExplainForeignScan_function,
    pub ExplainForeignModify: ExplainForeignModify_function,
    pub ExplainDirectModify: ExplainDirectModify_function,
    pub AnalyzeForeignTable: AnalyzeForeignTable_function,
    pub ImportForeignSchema: ImportForeignSchema_function,
    pub ExecForeignTruncate: ExecForeignTruncate_function,
    pub IsForeignScanParallelSafe: IsForeignScanParallelSafe_function,
    pub EstimateDSMForeignScan: EstimateDSMForeignScan_function,
    pub InitializeDSMForeignScan: InitializeDSMForeignScan_function,
    pub ReInitializeDSMForeignScan: ReInitializeDSMForeignScan_function,
    pub InitializeWorkerForeignScan: InitializeWorkerForeignScan_function,
    pub ShutdownForeignScan: ShutdownForeignScan_function,
    pub ReparameterizeForeignPathByChild: ReparameterizeForeignPathByChild_function,
    pub IsForeignPathAsyncCapable: IsForeignPathAsyncCapable_function,
    pub ForeignAsyncRequest: ForeignAsyncRequest_function,
    pub ForeignAsyncConfigureWait: ForeignAsyncConfigureWait_function,
    pub ForeignAsyncNotify: ForeignAsyncNotify_function,
}
impl Default for FdwRoutine {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ForeignDataWrapper {
    pub fdwid: Oid,
    pub owner: Oid,
    pub fdwname: *mut ::core::ffi::c_char,
    pub fdwhandler: Oid,
    pub fdwvalidator: Oid,
    pub options: *mut List,
}
impl Default for ForeignDataWrapper {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ForeignServer {
    pub serverid: Oid,
    pub fdwid: Oid,
    pub owner: Oid,
    pub servername: *mut ::core::ffi::c_char,
    pub servertype: *mut ::core::ffi::c_char,
    pub serverversion: *mut ::core::ffi::c_char,
    pub options: *mut List,
}
impl Default for ForeignServer {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct UserMapping {
    pub umid: Oid,
    pub userid: Oid,
    pub serverid: Oid,
    pub options: *mut List,
}
impl Default for UserMapping {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ForeignTable {
    pub relid: Oid,
    pub serverid: Oid,
    pub options: *mut List,
}
impl Default for ForeignTable {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct JitInstrumentation {
    pub created_functions: usize,
    pub generation_counter: instr_time,
    pub inlining_counter: instr_time,
    pub optimization_counter: instr_time,
    pub emission_counter: instr_time,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct SharedJitInstrumentation {
    pub num_workers: ::core::ffi::c_int,
    pub jit_instr: __IncompleteArrayField<JitInstrumentation>,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct JitContext {
    pub flags: ::core::ffi::c_int,
    pub resowner: ResourceOwner,
    pub instr: JitInstrumentation,
}
impl Default for JitContext {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type JitProviderInit =
    ::core::option::Option<unsafe extern "C-unwind" fn(cb: *mut JitProviderCallbacks)>;
pub type JitProviderResetAfterErrorCB = ::core::option::Option<unsafe extern "C-unwind" fn()>;
pub type JitProviderReleaseContextCB =
    ::core::option::Option<unsafe extern "C-unwind" fn(context: *mut JitContext)>;
pub type JitProviderCompileExprCB =
    ::core::option::Option<unsafe extern "C-unwind" fn(state: *mut ExprState) -> bool>;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct JitProviderCallbacks {
    pub reset_after_error: JitProviderResetAfterErrorCB,
    pub release_context: JitProviderReleaseContextCB,
    pub compile_expr: JitProviderCompileExprCB,
}
pub type pg_wchar = ::core::ffi::c_uint;
pub mod pg_enc {
    pub type Type = ::core::ffi::c_uint;
    pub const PG_SQL_ASCII: Type = 0;
    pub const PG_EUC_JP: Type = 1;
    pub const PG_EUC_CN: Type = 2;
    pub const PG_EUC_KR: Type = 3;
    pub const PG_EUC_TW: Type = 4;
    pub const PG_EUC_JIS_2004: Type = 5;
    pub const PG_UTF8: Type = 6;
    pub const PG_MULE_INTERNAL: Type = 7;
    pub const PG_LATIN1: Type = 8;
    pub const PG_LATIN2: Type = 9;
    pub const PG_LATIN3: Type = 10;
    pub const PG_LATIN4: Type = 11;
    pub const PG_LATIN5: Type = 12;
    pub const PG_LATIN6: Type = 13;
    pub const PG_LATIN7: Type = 14;
    pub const PG_LATIN8: Type = 15;
    pub const PG_LATIN9: Type = 16;
    pub const PG_LATIN10: Type = 17;
    pub const PG_WIN1256: Type = 18;
    pub const PG_WIN1258: Type = 19;
    pub const PG_WIN866: Type = 20;
    pub const PG_WIN874: Type = 21;
    pub const PG_KOI8R: Type = 22;
    pub const PG_WIN1251: Type = 23;
    pub const PG_WIN1252: Type = 24;
    pub const PG_ISO_8859_5: Type = 25;
    pub const PG_ISO_8859_6: Type = 26;
    pub const PG_ISO_8859_7: Type = 27;
    pub const PG_ISO_8859_8: Type = 28;
    pub const PG_WIN1250: Type = 29;
    pub const PG_WIN1253: Type = 30;
    pub const PG_WIN1254: Type = 31;
    pub const PG_WIN1255: Type = 32;
    pub const PG_WIN1257: Type = 33;
    pub const PG_KOI8U: Type = 34;
    pub const PG_SJIS: Type = 35;
    pub const PG_BIG5: Type = 36;
    pub const PG_GBK: Type = 37;
    pub const PG_UHC: Type = 38;
    pub const PG_GB18030: Type = 39;
    pub const PG_JOHAB: Type = 40;
    pub const PG_SHIFT_JIS_2004: Type = 41;
    pub const _PG_LAST_ENCODING_: Type = 42;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pg_enc2name {
    pub name: *const ::core::ffi::c_char,
    pub encoding: pg_enc::Type,
}
impl Default for pg_enc2name {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pg_enc2gettext {
    pub encoding: pg_enc::Type,
    pub name: *const ::core::ffi::c_char,
}
impl Default for pg_enc2gettext {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type mb2wchar_with_len_converter = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        from: *const ::core::ffi::c_uchar,
        to: *mut pg_wchar,
        len: ::core::ffi::c_int,
    ) -> ::core::ffi::c_int,
>;
pub type wchar2mb_with_len_converter = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        from: *const pg_wchar,
        to: *mut ::core::ffi::c_uchar,
        len: ::core::ffi::c_int,
    ) -> ::core::ffi::c_int,
>;
pub type mblen_converter = ::core::option::Option<
    unsafe extern "C-unwind" fn(mbstr: *const ::core::ffi::c_uchar) -> ::core::ffi::c_int,
>;
pub type mbdisplaylen_converter = ::core::option::Option<
    unsafe extern "C-unwind" fn(mbstr: *const ::core::ffi::c_uchar) -> ::core::ffi::c_int,
>;
pub type mbcharacter_incrementer = ::core::option::Option<
    unsafe extern "C-unwind" fn(mbstr: *mut ::core::ffi::c_uchar, len: ::core::ffi::c_int) -> bool,
>;
pub type mbchar_verifier = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        mbstr: *const ::core::ffi::c_uchar,
        len: ::core::ffi::c_int,
    ) -> ::core::ffi::c_int,
>;
pub type mbstr_verifier = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        mbstr: *const ::core::ffi::c_uchar,
        len: ::core::ffi::c_int,
    ) -> ::core::ffi::c_int,
>;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct pg_wchar_tbl {
    pub mb2wchar_with_len: mb2wchar_with_len_converter,
    pub wchar2mb_with_len: wchar2mb_with_len_converter,
    pub mblen: mblen_converter,
    pub dsplen: mbdisplaylen_converter,
    pub mbverifychar: mbchar_verifier,
    pub mbverifystr: mbstr_verifier,
    pub maxmblen: ::core::ffi::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pg_mb_radix_tree {
    pub chars16: *const uint16,
    pub chars32: *const uint32,
    pub b1root: uint32,
    pub b1_lower: uint8,
    pub b1_upper: uint8,
    pub b2root: uint32,
    pub b2_1_lower: uint8,
    pub b2_1_upper: uint8,
    pub b2_2_lower: uint8,
    pub b2_2_upper: uint8,
    pub b3root: uint32,
    pub b3_1_lower: uint8,
    pub b3_1_upper: uint8,
    pub b3_2_lower: uint8,
    pub b3_2_upper: uint8,
    pub b3_3_lower: uint8,
    pub b3_3_upper: uint8,
    pub b4root: uint32,
    pub b4_1_lower: uint8,
    pub b4_1_upper: uint8,
    pub b4_2_lower: uint8,
    pub b4_2_upper: uint8,
    pub b4_3_lower: uint8,
    pub b4_3_upper: uint8,
    pub b4_4_lower: uint8,
    pub b4_4_upper: uint8,
}
impl Default for pg_mb_radix_tree {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct pg_utf_to_local_combined {
    pub utf1: uint32,
    pub utf2: uint32,
    pub code: uint32,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct pg_local_to_utf_combined {
    pub code: uint32,
    pub utf1: uint32,
    pub utf2: uint32,
}
pub type utf_local_conversion_func =
    ::core::option::Option<unsafe extern "C-unwind" fn(code: uint32) -> uint32>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExtensibleNode {
    pub type_: NodeTag,
    pub extnodename: *const ::core::ffi::c_char,
}
impl Default for ExtensibleNode {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExtensibleNodeMethods {
    pub extnodename: *const ::core::ffi::c_char,
    pub node_size: Size,
    pub nodeCopy: ::core::option::Option<
        unsafe extern "C-unwind" fn(newnode: *mut ExtensibleNode, oldnode: *const ExtensibleNode),
    >,
    pub nodeEqual: ::core::option::Option<
        unsafe extern "C-unwind" fn(a: *const ExtensibleNode, b: *const ExtensibleNode) -> bool,
    >,
    pub nodeOut: ::core::option::Option<
        unsafe extern "C-unwind" fn(str_: *mut StringInfoData, node: *const ExtensibleNode),
    >,
    pub nodeRead: ::core::option::Option<unsafe extern "C-unwind" fn(node: *mut ExtensibleNode)>,
}
impl Default for ExtensibleNodeMethods {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CustomPathMethods {
    pub CustomName: *const ::core::ffi::c_char,
    pub PlanCustomPath: ::core::option::Option<
        unsafe extern "C-unwind" fn(
            root: *mut PlannerInfo,
            rel: *mut RelOptInfo,
            best_path: *mut CustomPath,
            tlist: *mut List,
            clauses: *mut List,
            custom_plans: *mut List,
        ) -> *mut Plan,
    >,
    pub ReparameterizeCustomPathByChild: ::core::option::Option<
        unsafe extern "C-unwind" fn(
            root: *mut PlannerInfo,
            custom_private: *mut List,
            child_rel: *mut RelOptInfo,
        ) -> *mut List,
    >,
}
impl Default for CustomPathMethods {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CustomScanMethods {
    pub CustomName: *const ::core::ffi::c_char,
    pub CreateCustomScanState:
        ::core::option::Option<unsafe extern "C-unwind" fn(cscan: *mut CustomScan) -> *mut Node>,
}
impl Default for CustomScanMethods {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CustomExecMethods {
    pub CustomName: *const ::core::ffi::c_char,
    pub BeginCustomScan: ::core::option::Option<
        unsafe extern "C-unwind" fn(
            node: *mut CustomScanState,
            estate: *mut EState,
            eflags: ::core::ffi::c_int,
        ),
    >,
    pub ExecCustomScan: ::core::option::Option<
        unsafe extern "C-unwind" fn(node: *mut CustomScanState) -> *mut TupleTableSlot,
    >,
    pub EndCustomScan:
        ::core::option::Option<unsafe extern "C-unwind" fn(node: *mut CustomScanState)>,
    pub ReScanCustomScan:
        ::core::option::Option<unsafe extern "C-unwind" fn(node: *mut CustomScanState)>,
    pub MarkPosCustomScan:
        ::core::option::Option<unsafe extern "C-unwind" fn(node: *mut CustomScanState)>,
    pub RestrPosCustomScan:
        ::core::option::Option<unsafe extern "C-unwind" fn(node: *mut CustomScanState)>,
    pub EstimateDSMCustomScan: ::core::option::Option<
        unsafe extern "C-unwind" fn(node: *mut CustomScanState, pcxt: *mut ParallelContext) -> Size,
    >,
    pub InitializeDSMCustomScan: ::core::option::Option<
        unsafe extern "C-unwind" fn(
            node: *mut CustomScanState,
            pcxt: *mut ParallelContext,
            coordinate: *mut ::core::ffi::c_void,
        ),
    >,
    pub ReInitializeDSMCustomScan: ::core::option::Option<
        unsafe extern "C-unwind" fn(
            node: *mut CustomScanState,
            pcxt: *mut ParallelContext,
            coordinate: *mut ::core::ffi::c_void,
        ),
    >,
    pub InitializeWorkerCustomScan: ::core::option::Option<
        unsafe extern "C-unwind" fn(
            node: *mut CustomScanState,
            toc: *mut shm_toc,
            coordinate: *mut ::core::ffi::c_void,
        ),
    >,
    pub ShutdownCustomScan:
        ::core::option::Option<unsafe extern "C-unwind" fn(node: *mut CustomScanState)>,
    pub ExplainCustomScan: ::core::option::Option<
        unsafe extern "C-unwind" fn(
            node: *mut CustomScanState,
            ancestors: *mut List,
            es: *mut ExplainState,
        ),
    >,
}
impl Default for CustomExecMethods {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type check_function_callback = ::core::option::Option<
    unsafe extern "C-unwind" fn(func_id: Oid, context: *mut ::core::ffi::c_void) -> bool,
>;
pub mod ReplicationKind {
    pub type Type = ::core::ffi::c_uint;
    pub const REPLICATION_KIND_PHYSICAL: Type = 0;
    pub const REPLICATION_KIND_LOGICAL: Type = 1;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IdentifySystemCmd {
    pub type_: NodeTag,
}
impl Default for IdentifySystemCmd {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BaseBackupCmd {
    pub type_: NodeTag,
    pub options: *mut List,
}
impl Default for BaseBackupCmd {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateReplicationSlotCmd {
    pub type_: NodeTag,
    pub slotname: *mut ::core::ffi::c_char,
    pub kind: ReplicationKind::Type,
    pub plugin: *mut ::core::ffi::c_char,
    pub temporary: bool,
    pub options: *mut List,
}
impl Default for CreateReplicationSlotCmd {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DropReplicationSlotCmd {
    pub type_: NodeTag,
    pub slotname: *mut ::core::ffi::c_char,
    pub wait: bool,
}
impl Default for DropReplicationSlotCmd {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StartReplicationCmd {
    pub type_: NodeTag,
    pub kind: ReplicationKind::Type,
    pub slotname: *mut ::core::ffi::c_char,
    pub timeline: TimeLineID,
    pub startpoint: XLogRecPtr,
    pub options: *mut List,
}
impl Default for StartReplicationCmd {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ReadReplicationSlotCmd {
    pub type_: NodeTag,
    pub slotname: *mut ::core::ffi::c_char,
}
impl Default for ReadReplicationSlotCmd {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TimeLineHistoryCmd {
    pub type_: NodeTag,
    pub timeline: TimeLineID,
}
impl Default for TimeLineHistoryCmd {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type SubscriptTransform = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        sbsref: *mut SubscriptingRef,
        indirection: *mut List,
        pstate: *mut ParseState,
        isSlice: bool,
        isAssignment: bool,
    ),
>;
pub type SubscriptExecSetup = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        sbsref: *const SubscriptingRef,
        sbsrefstate: *mut SubscriptingRefState,
        methods: *mut SubscriptExecSteps,
    ),
>;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct SubscriptRoutines {
    pub transform: SubscriptTransform,
    pub exec_setup: SubscriptExecSetup,
    pub fetch_strict: bool,
    pub fetch_leakproof: bool,
    pub store_leakproof: bool,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SupportRequestSimplify {
    pub type_: NodeTag,
    pub root: *mut PlannerInfo,
    pub fcall: *mut FuncExpr,
}
impl Default for SupportRequestSimplify {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SupportRequestSelectivity {
    pub type_: NodeTag,
    pub root: *mut PlannerInfo,
    pub funcid: Oid,
    pub args: *mut List,
    pub inputcollid: Oid,
    pub is_join: bool,
    pub varRelid: ::core::ffi::c_int,
    pub jointype: JoinType::Type,
    pub sjinfo: *mut SpecialJoinInfo,
    pub selectivity: Selectivity,
}
impl Default for SupportRequestSelectivity {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SupportRequestCost {
    pub type_: NodeTag,
    pub root: *mut PlannerInfo,
    pub funcid: Oid,
    pub node: *mut Node,
    pub startup: Cost,
    pub per_tuple: Cost,
}
impl Default for SupportRequestCost {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SupportRequestRows {
    pub type_: NodeTag,
    pub root: *mut PlannerInfo,
    pub funcid: Oid,
    pub node: *mut Node,
    pub rows: f64,
}
impl Default for SupportRequestRows {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SupportRequestIndexCondition {
    pub type_: NodeTag,
    pub root: *mut PlannerInfo,
    pub funcid: Oid,
    pub node: *mut Node,
    pub indexarg: ::core::ffi::c_int,
    pub index: *mut IndexOptInfo,
    pub indexcol: ::core::ffi::c_int,
    pub opfamily: Oid,
    pub indexcollation: Oid,
    pub lossy: bool,
}
impl Default for SupportRequestIndexCondition {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SupportRequestWFuncMonotonic {
    pub type_: NodeTag,
    pub window_func: *mut WindowFunc,
    pub window_clause: *mut WindowClause,
    pub monotonic: MonotonicFunction::Type,
}
impl Default for SupportRequestWFuncMonotonic {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WindowFuncLists {
    pub numWindowFuncs: ::core::ffi::c_int,
    pub maxWinRef: Index,
    pub windowFuncs: *mut *mut List,
}
impl Default for WindowFuncLists {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod ConstraintExclusionType {
    pub type Type = ::core::ffi::c_uint;
    pub const CONSTRAINT_EXCLUSION_OFF: Type = 0;
    pub const CONSTRAINT_EXCLUSION_ON: Type = 1;
    pub const CONSTRAINT_EXCLUSION_PARTITION: Type = 2;
}
pub mod ForceParallelMode {
    pub type Type = ::core::ffi::c_uint;
    pub const FORCE_PARALLEL_OFF: Type = 0;
    pub const FORCE_PARALLEL_ON: Type = 1;
    pub const FORCE_PARALLEL_REGRESS: Type = 2;
}
pub type set_rel_pathlist_hook_type = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        root: *mut PlannerInfo,
        rel: *mut RelOptInfo,
        rti: Index,
        rte: *mut RangeTblEntry,
    ),
>;
pub type set_join_pathlist_hook_type = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        root: *mut PlannerInfo,
        joinrel: *mut RelOptInfo,
        outerrel: *mut RelOptInfo,
        innerrel: *mut RelOptInfo,
        jointype: JoinType::Type,
        extra: *mut JoinPathExtraData,
    ),
>;
pub type join_search_hook_type = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        root: *mut PlannerInfo,
        levels_needed: ::core::ffi::c_int,
        initial_rels: *mut List,
    ) -> *mut RelOptInfo,
>;
pub type ec_matches_callback_type = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        root: *mut PlannerInfo,
        rel: *mut RelOptInfo,
        ec: *mut EquivalenceClass,
        em: *mut EquivalenceMember,
        arg: *mut ::core::ffi::c_void,
    ) -> bool,
>;
pub mod PathKeysComparison {
    pub type Type = ::core::ffi::c_uint;
    pub const PATHKEYS_EQUAL: Type = 0;
    pub const PATHKEYS_BETTER1: Type = 1;
    pub const PATHKEYS_BETTER2: Type = 2;
    pub const PATHKEYS_DIFFERENT: Type = 3;
}
pub type get_relation_info_hook_type = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        root: *mut PlannerInfo,
        relationObjectId: Oid,
        inhparent: bool,
        rel: *mut RelOptInfo,
    ),
>;
pub type query_pathkeys_callback = ::core::option::Option<
    unsafe extern "C-unwind" fn(root: *mut PlannerInfo, extra: *mut ::core::ffi::c_void),
>;
pub type planner_hook_type = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        parse: *mut Query,
        query_string: *const ::core::ffi::c_char,
        cursorOptions: ::core::ffi::c_int,
        boundParams: ParamListInfo,
    ) -> *mut PlannedStmt,
>;
pub type create_upper_paths_hook_type = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        root: *mut PlannerInfo,
        stage: UpperRelationKind::Type,
        input_rel: *mut RelOptInfo,
        output_rel: *mut RelOptInfo,
        extra: *mut ::core::ffi::c_void,
    ),
>;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct LocationLen {
    pub location: ::core::ffi::c_int,
    pub length: ::core::ffi::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct JumbleState {
    pub jumble: *mut ::core::ffi::c_uchar,
    pub jumble_len: Size,
    pub clocations: *mut LocationLen,
    pub clocations_buf_size: ::core::ffi::c_int,
    pub clocations_count: ::core::ffi::c_int,
    pub highest_extern_param_id: ::core::ffi::c_int,
}
impl Default for JumbleState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod ComputeQueryIdType {
    pub type Type = ::core::ffi::c_uint;
    pub const COMPUTE_QUERY_ID_OFF: Type = 0;
    pub const COMPUTE_QUERY_ID_ON: Type = 1;
    pub const COMPUTE_QUERY_ID_AUTO: Type = 2;
    pub const COMPUTE_QUERY_ID_REGRESS: Type = 3;
}
pub type post_parse_analyze_hook_type = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        pstate: *mut ParseState,
        query: *mut Query,
        jstate: *mut JumbleState,
    ),
>;
pub mod FuncDetailCode {
    pub type Type = ::core::ffi::c_uint;
    pub const FUNCDETAIL_NOTFOUND: Type = 0;
    pub const FUNCDETAIL_MULTIPLE: Type = 1;
    pub const FUNCDETAIL_NORMAL: Type = 2;
    pub const FUNCDETAIL_PROCEDURE: Type = 3;
    pub const FUNCDETAIL_AGGREGATE: Type = 4;
    pub const FUNCDETAIL_WINDOWFUNC: Type = 5;
    pub const FUNCDETAIL_COERCION: Type = 6;
}
pub type Operator = HeapTuple;
pub type Type = HeapTuple;
pub type TYPCATEGORY = ::core::ffi::c_char;
pub mod CoercionPathType {
    pub type Type = ::core::ffi::c_uint;
    pub const COERCION_PATH_NONE: Type = 0;
    pub const COERCION_PATH_FUNC: Type = 1;
    pub const COERCION_PATH_RELABELTYPE: Type = 2;
    pub const COERCION_PATH_ARRAYCOERCE: Type = 3;
    pub const COERCION_PATH_COERCEVIAIO: Type = 4;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionBoundInfoData {
    pub strategy: ::core::ffi::c_char,
    pub ndatums: ::core::ffi::c_int,
    pub datums: *mut *mut Datum,
    pub kind: *mut *mut PartitionRangeDatumKind::Type,
    pub interleaved_parts: *mut Bitmapset,
    pub nindexes: ::core::ffi::c_int,
    pub indexes: *mut ::core::ffi::c_int,
    pub null_index: ::core::ffi::c_int,
    pub default_index: ::core::ffi::c_int,
}
impl Default for PartitionBoundInfoData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionDescData {
    pub nparts: ::core::ffi::c_int,
    pub detached_exist: bool,
    pub oids: *mut Oid,
    pub is_leaf: *mut bool,
    pub boundinfo: PartitionBoundInfo,
}
impl Default for PartitionDescData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionPruneContext {
    pub strategy: ::core::ffi::c_char,
    pub partnatts: ::core::ffi::c_int,
    pub nparts: ::core::ffi::c_int,
    pub boundinfo: PartitionBoundInfo,
    pub partcollation: *mut Oid,
    pub partsupfunc: *mut FmgrInfo,
    pub stepcmpfuncs: *mut FmgrInfo,
    pub ppccontext: MemoryContext,
    pub planstate: *mut PlanState,
    pub exprcontext: *mut ExprContext,
    pub exprstates: *mut *mut ExprState,
}
impl Default for PartitionPruneContext {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExpandedRecordHeader {
    pub hdr: ExpandedObjectHeader,
    pub er_magic: ::core::ffi::c_int,
    pub flags: ::core::ffi::c_int,
    pub er_decltypeid: Oid,
    pub er_typeid: Oid,
    pub er_typmod: int32,
    pub er_tupdesc: TupleDesc,
    pub er_tupdesc_id: uint64,
    pub dvalues: *mut Datum,
    pub dnulls: *mut bool,
    pub nfields: ::core::ffi::c_int,
    pub flat_size: Size,
    pub data_len: Size,
    pub hoff: ::core::ffi::c_int,
    pub hasnull: bool,
    pub fvalue: HeapTuple,
    pub fstartptr: *mut ::core::ffi::c_char,
    pub fendptr: *mut ::core::ffi::c_char,
    pub er_short_term_cxt: MemoryContext,
    pub er_dummy_header: *mut ExpandedRecordHeader,
    pub er_domaininfo: *mut ::core::ffi::c_void,
    pub er_mcb: MemoryContextCallback,
}
impl Default for ExpandedRecordHeader {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExpandedRecordFieldInfo {
    pub fnumber: ::core::ffi::c_int,
    pub ftypeid: Oid,
    pub ftypmod: int32,
    pub fcollation: Oid,
}
impl Default for ExpandedRecordFieldInfo {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DomainConstraintCache {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TypeCacheEnumData {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TypeCacheEntry {
    pub type_id: Oid,
    pub type_id_hash: uint32,
    pub typlen: int16,
    pub typbyval: bool,
    pub typalign: ::core::ffi::c_char,
    pub typstorage: ::core::ffi::c_char,
    pub typtype: ::core::ffi::c_char,
    pub typrelid: Oid,
    pub typsubscript: Oid,
    pub typelem: Oid,
    pub typcollation: Oid,
    pub btree_opf: Oid,
    pub btree_opintype: Oid,
    pub hash_opf: Oid,
    pub hash_opintype: Oid,
    pub eq_opr: Oid,
    pub lt_opr: Oid,
    pub gt_opr: Oid,
    pub cmp_proc: Oid,
    pub hash_proc: Oid,
    pub hash_extended_proc: Oid,
    pub eq_opr_finfo: FmgrInfo,
    pub cmp_proc_finfo: FmgrInfo,
    pub hash_proc_finfo: FmgrInfo,
    pub hash_extended_proc_finfo: FmgrInfo,
    pub tupDesc: TupleDesc,
    pub tupDesc_identifier: uint64,
    pub rngelemtype: *mut TypeCacheEntry,
    pub rng_collation: Oid,
    pub rng_cmp_proc_finfo: FmgrInfo,
    pub rng_canonical_finfo: FmgrInfo,
    pub rng_subdiff_finfo: FmgrInfo,
    pub rngtype: *mut TypeCacheEntry,
    pub domainBaseType: Oid,
    pub domainBaseTypmod: int32,
    pub domainData: *mut DomainConstraintCache,
    pub flags: ::core::ffi::c_int,
    pub enumData: *mut TypeCacheEnumData,
    pub nextDomain: *mut TypeCacheEntry,
}
impl Default for TypeCacheEntry {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DomainConstraintRef {
    pub constraints: *mut List,
    pub refctx: MemoryContext,
    pub tcache: *mut TypeCacheEntry,
    pub need_exprstate: bool,
    pub dcc: *mut DomainConstraintCache,
    pub callback: MemoryContextCallback,
}
impl Default for DomainConstraintRef {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SharedRecordTypmodRegistry {
    _unused: [u8; 0],
}
pub mod PLpgSQL_nsitem_type {
    pub type Type = ::core::ffi::c_uint;
    pub const PLPGSQL_NSTYPE_LABEL: Type = 0;
    pub const PLPGSQL_NSTYPE_VAR: Type = 1;
    pub const PLPGSQL_NSTYPE_REC: Type = 2;
}
pub mod PLpgSQL_label_type {
    pub type Type = ::core::ffi::c_uint;
    pub const PLPGSQL_LABEL_BLOCK: Type = 0;
    pub const PLPGSQL_LABEL_LOOP: Type = 1;
    pub const PLPGSQL_LABEL_OTHER: Type = 2;
}
pub mod PLpgSQL_datum_type {
    pub type Type = ::core::ffi::c_uint;
    pub const PLPGSQL_DTYPE_VAR: Type = 0;
    pub const PLPGSQL_DTYPE_ROW: Type = 1;
    pub const PLPGSQL_DTYPE_REC: Type = 2;
    pub const PLPGSQL_DTYPE_RECFIELD: Type = 3;
    pub const PLPGSQL_DTYPE_PROMISE: Type = 4;
}
pub mod PLpgSQL_promise_type {
    pub type Type = ::core::ffi::c_uint;
    pub const PLPGSQL_PROMISE_NONE: Type = 0;
    pub const PLPGSQL_PROMISE_TG_NAME: Type = 1;
    pub const PLPGSQL_PROMISE_TG_WHEN: Type = 2;
    pub const PLPGSQL_PROMISE_TG_LEVEL: Type = 3;
    pub const PLPGSQL_PROMISE_TG_OP: Type = 4;
    pub const PLPGSQL_PROMISE_TG_RELID: Type = 5;
    pub const PLPGSQL_PROMISE_TG_TABLE_NAME: Type = 6;
    pub const PLPGSQL_PROMISE_TG_TABLE_SCHEMA: Type = 7;
    pub const PLPGSQL_PROMISE_TG_NARGS: Type = 8;
    pub const PLPGSQL_PROMISE_TG_ARGV: Type = 9;
    pub const PLPGSQL_PROMISE_TG_EVENT: Type = 10;
    pub const PLPGSQL_PROMISE_TG_TAG: Type = 11;
}
pub mod PLpgSQL_type_type {
    pub type Type = ::core::ffi::c_uint;
    pub const PLPGSQL_TTYPE_SCALAR: Type = 0;
    pub const PLPGSQL_TTYPE_REC: Type = 1;
    pub const PLPGSQL_TTYPE_PSEUDO: Type = 2;
}
pub mod PLpgSQL_stmt_type {
    pub type Type = ::core::ffi::c_uint;
    pub const PLPGSQL_STMT_BLOCK: Type = 0;
    pub const PLPGSQL_STMT_ASSIGN: Type = 1;
    pub const PLPGSQL_STMT_IF: Type = 2;
    pub const PLPGSQL_STMT_CASE: Type = 3;
    pub const PLPGSQL_STMT_LOOP: Type = 4;
    pub const PLPGSQL_STMT_WHILE: Type = 5;
    pub const PLPGSQL_STMT_FORI: Type = 6;
    pub const PLPGSQL_STMT_FORS: Type = 7;
    pub const PLPGSQL_STMT_FORC: Type = 8;
    pub const PLPGSQL_STMT_FOREACH_A: Type = 9;
    pub const PLPGSQL_STMT_EXIT: Type = 10;
    pub const PLPGSQL_STMT_RETURN: Type = 11;
    pub const PLPGSQL_STMT_RETURN_NEXT: Type = 12;
    pub const PLPGSQL_STMT_RETURN_QUERY: Type = 13;
    pub const PLPGSQL_STMT_RAISE: Type = 14;
    pub const PLPGSQL_STMT_ASSERT: Type = 15;
    pub const PLPGSQL_STMT_EXECSQL: Type = 16;
    pub const PLPGSQL_STMT_DYNEXECUTE: Type = 17;
    pub const PLPGSQL_STMT_DYNFORS: Type = 18;
    pub const PLPGSQL_STMT_GETDIAG: Type = 19;
    pub const PLPGSQL_STMT_OPEN: Type = 20;
    pub const PLPGSQL_STMT_FETCH: Type = 21;
    pub const PLPGSQL_STMT_CLOSE: Type = 22;
    pub const PLPGSQL_STMT_PERFORM: Type = 23;
    pub const PLPGSQL_STMT_CALL: Type = 24;
    pub const PLPGSQL_STMT_COMMIT: Type = 25;
    pub const PLPGSQL_STMT_ROLLBACK: Type = 26;
}
pub mod _bindgen_ty_25 {
    pub type Type = ::core::ffi::c_uint;
    pub const PLPGSQL_RC_OK: Type = 0;
    pub const PLPGSQL_RC_EXIT: Type = 1;
    pub const PLPGSQL_RC_RETURN: Type = 2;
    pub const PLPGSQL_RC_CONTINUE: Type = 3;
}
pub mod PLpgSQL_getdiag_kind {
    pub type Type = ::core::ffi::c_uint;
    pub const PLPGSQL_GETDIAG_ROW_COUNT: Type = 0;
    pub const PLPGSQL_GETDIAG_CONTEXT: Type = 1;
    pub const PLPGSQL_GETDIAG_ERROR_CONTEXT: Type = 2;
    pub const PLPGSQL_GETDIAG_ERROR_DETAIL: Type = 3;
    pub const PLPGSQL_GETDIAG_ERROR_HINT: Type = 4;
    pub const PLPGSQL_GETDIAG_RETURNED_SQLSTATE: Type = 5;
    pub const PLPGSQL_GETDIAG_COLUMN_NAME: Type = 6;
    pub const PLPGSQL_GETDIAG_CONSTRAINT_NAME: Type = 7;
    pub const PLPGSQL_GETDIAG_DATATYPE_NAME: Type = 8;
    pub const PLPGSQL_GETDIAG_MESSAGE_TEXT: Type = 9;
    pub const PLPGSQL_GETDIAG_TABLE_NAME: Type = 10;
    pub const PLPGSQL_GETDIAG_SCHEMA_NAME: Type = 11;
}
pub mod PLpgSQL_raise_option_type {
    pub type Type = ::core::ffi::c_uint;
    pub const PLPGSQL_RAISEOPTION_ERRCODE: Type = 0;
    pub const PLPGSQL_RAISEOPTION_MESSAGE: Type = 1;
    pub const PLPGSQL_RAISEOPTION_DETAIL: Type = 2;
    pub const PLPGSQL_RAISEOPTION_HINT: Type = 3;
    pub const PLPGSQL_RAISEOPTION_COLUMN: Type = 4;
    pub const PLPGSQL_RAISEOPTION_CONSTRAINT: Type = 5;
    pub const PLPGSQL_RAISEOPTION_DATATYPE: Type = 6;
    pub const PLPGSQL_RAISEOPTION_TABLE: Type = 7;
    pub const PLPGSQL_RAISEOPTION_SCHEMA: Type = 8;
}
pub mod PLpgSQL_resolve_option {
    pub type Type = ::core::ffi::c_uint;
    pub const PLPGSQL_RESOLVE_ERROR: Type = 0;
    pub const PLPGSQL_RESOLVE_VARIABLE: Type = 1;
    pub const PLPGSQL_RESOLVE_COLUMN: Type = 2;
}
#[doc = " Node and structure definitions"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PLpgSQL_type {
    pub typname: *mut ::core::ffi::c_char,
    pub typoid: Oid,
    pub ttype: PLpgSQL_type_type::Type,
    pub typlen: int16,
    pub typbyval: bool,
    pub typtype: ::core::ffi::c_char,
    pub collation: Oid,
    pub typisarray: bool,
    pub atttypmod: int32,
    pub origtypname: *mut TypeName,
    pub tcache: *mut TypeCacheEntry,
    pub tupdesc_id: uint64,
}
impl Default for PLpgSQL_type {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PLpgSQL_expr {
    pub query: *mut ::core::ffi::c_char,
    pub parseMode: RawParseMode::Type,
    pub plan: SPIPlanPtr,
    pub paramnos: *mut Bitmapset,
    pub func: *mut PLpgSQL_function,
    pub ns: *mut PLpgSQL_nsitem,
    pub expr_simple_expr: *mut Expr,
    pub expr_simple_type: Oid,
    pub expr_simple_typmod: int32,
    pub expr_simple_mutable: bool,
    pub target_param: ::core::ffi::c_int,
    pub expr_rw_param: *mut Param,
    pub expr_simple_plansource: *mut CachedPlanSource,
    pub expr_simple_plan: *mut CachedPlan,
    pub expr_simple_plan_lxid: LocalTransactionId,
    pub expr_simple_state: *mut ExprState,
    pub expr_simple_in_use: bool,
    pub expr_simple_lxid: LocalTransactionId,
}
impl Default for PLpgSQL_expr {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PLpgSQL_datum {
    pub dtype: PLpgSQL_datum_type::Type,
    pub dno: ::core::ffi::c_int,
}
impl Default for PLpgSQL_datum {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PLpgSQL_variable {
    pub dtype: PLpgSQL_datum_type::Type,
    pub dno: ::core::ffi::c_int,
    pub refname: *mut ::core::ffi::c_char,
    pub lineno: ::core::ffi::c_int,
    pub isconst: bool,
    pub notnull: bool,
    pub default_val: *mut PLpgSQL_expr,
}
impl Default for PLpgSQL_variable {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PLpgSQL_var {
    pub dtype: PLpgSQL_datum_type::Type,
    pub dno: ::core::ffi::c_int,
    pub refname: *mut ::core::ffi::c_char,
    pub lineno: ::core::ffi::c_int,
    pub isconst: bool,
    pub notnull: bool,
    pub default_val: *mut PLpgSQL_expr,
    pub datatype: *mut PLpgSQL_type,
    pub cursor_explicit_expr: *mut PLpgSQL_expr,
    pub cursor_explicit_argrow: ::core::ffi::c_int,
    pub cursor_options: ::core::ffi::c_int,
    pub value: Datum,
    pub isnull: bool,
    pub freeval: bool,
    pub promise: PLpgSQL_promise_type::Type,
}
impl Default for PLpgSQL_var {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PLpgSQL_row {
    pub dtype: PLpgSQL_datum_type::Type,
    pub dno: ::core::ffi::c_int,
    pub refname: *mut ::core::ffi::c_char,
    pub lineno: ::core::ffi::c_int,
    pub isconst: bool,
    pub notnull: bool,
    pub default_val: *mut PLpgSQL_expr,
    pub rowtupdesc: TupleDesc,
    pub nfields: ::core::ffi::c_int,
    pub fieldnames: *mut *mut ::core::ffi::c_char,
    pub varnos: *mut ::core::ffi::c_int,
}
impl Default for PLpgSQL_row {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PLpgSQL_rec {
    pub dtype: PLpgSQL_datum_type::Type,
    pub dno: ::core::ffi::c_int,
    pub refname: *mut ::core::ffi::c_char,
    pub lineno: ::core::ffi::c_int,
    pub isconst: bool,
    pub notnull: bool,
    pub default_val: *mut PLpgSQL_expr,
    pub datatype: *mut PLpgSQL_type,
    pub rectypeid: Oid,
    pub firstfield: ::core::ffi::c_int,
    pub erh: *mut ExpandedRecordHeader,
}
impl Default for PLpgSQL_rec {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PLpgSQL_recfield {
    pub dtype: PLpgSQL_datum_type::Type,
    pub dno: ::core::ffi::c_int,
    pub fieldname: *mut ::core::ffi::c_char,
    pub recparentno: ::core::ffi::c_int,
    pub nextfield: ::core::ffi::c_int,
    pub rectupledescid: uint64,
    pub finfo: ExpandedRecordFieldInfo,
}
impl Default for PLpgSQL_recfield {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct PLpgSQL_nsitem {
    pub itemtype: PLpgSQL_nsitem_type::Type,
    pub itemno: ::core::ffi::c_int,
    pub prev: *mut PLpgSQL_nsitem,
    pub name: __IncompleteArrayField<::core::ffi::c_char>,
}
impl Default for PLpgSQL_nsitem {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PLpgSQL_stmt {
    pub cmd_type: PLpgSQL_stmt_type::Type,
    pub lineno: ::core::ffi::c_int,
    pub stmtid: ::core::ffi::c_uint,
}
impl Default for PLpgSQL_stmt {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PLpgSQL_condition {
    pub sqlerrstate: ::core::ffi::c_int,
    pub condname: *mut ::core::ffi::c_char,
    pub next: *mut PLpgSQL_condition,
}
impl Default for PLpgSQL_condition {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PLpgSQL_exception_block {
    pub sqlstate_varno: ::core::ffi::c_int,
    pub sqlerrm_varno: ::core::ffi::c_int,
    pub exc_list: *mut List,
}
impl Default for PLpgSQL_exception_block {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PLpgSQL_exception {
    pub lineno: ::core::ffi::c_int,
    pub conditions: *mut PLpgSQL_condition,
    pub action: *mut List,
}
impl Default for PLpgSQL_exception {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PLpgSQL_stmt_block {
    pub cmd_type: PLpgSQL_stmt_type::Type,
    pub lineno: ::core::ffi::c_int,
    pub stmtid: ::core::ffi::c_uint,
    pub label: *mut ::core::ffi::c_char,
    pub body: *mut List,
    pub n_initvars: ::core::ffi::c_int,
    pub initvarnos: *mut ::core::ffi::c_int,
    pub exceptions: *mut PLpgSQL_exception_block,
}
impl Default for PLpgSQL_stmt_block {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PLpgSQL_stmt_assign {
    pub cmd_type: PLpgSQL_stmt_type::Type,
    pub lineno: ::core::ffi::c_int,
    pub stmtid: ::core::ffi::c_uint,
    pub varno: ::core::ffi::c_int,
    pub expr: *mut PLpgSQL_expr,
}
impl Default for PLpgSQL_stmt_assign {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PLpgSQL_stmt_perform {
    pub cmd_type: PLpgSQL_stmt_type::Type,
    pub lineno: ::core::ffi::c_int,
    pub stmtid: ::core::ffi::c_uint,
    pub expr: *mut PLpgSQL_expr,
}
impl Default for PLpgSQL_stmt_perform {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PLpgSQL_stmt_call {
    pub cmd_type: PLpgSQL_stmt_type::Type,
    pub lineno: ::core::ffi::c_int,
    pub stmtid: ::core::ffi::c_uint,
    pub expr: *mut PLpgSQL_expr,
    pub is_call: bool,
    pub target: *mut PLpgSQL_variable,
}
impl Default for PLpgSQL_stmt_call {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PLpgSQL_stmt_commit {
    pub cmd_type: PLpgSQL_stmt_type::Type,
    pub lineno: ::core::ffi::c_int,
    pub stmtid: ::core::ffi::c_uint,
    pub chain: bool,
}
impl Default for PLpgSQL_stmt_commit {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PLpgSQL_stmt_rollback {
    pub cmd_type: PLpgSQL_stmt_type::Type,
    pub lineno: ::core::ffi::c_int,
    pub stmtid: ::core::ffi::c_uint,
    pub chain: bool,
}
impl Default for PLpgSQL_stmt_rollback {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PLpgSQL_diag_item {
    pub kind: PLpgSQL_getdiag_kind::Type,
    pub target: ::core::ffi::c_int,
}
impl Default for PLpgSQL_diag_item {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PLpgSQL_stmt_getdiag {
    pub cmd_type: PLpgSQL_stmt_type::Type,
    pub lineno: ::core::ffi::c_int,
    pub stmtid: ::core::ffi::c_uint,
    pub is_stacked: bool,
    pub diag_items: *mut List,
}
impl Default for PLpgSQL_stmt_getdiag {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PLpgSQL_stmt_if {
    pub cmd_type: PLpgSQL_stmt_type::Type,
    pub lineno: ::core::ffi::c_int,
    pub stmtid: ::core::ffi::c_uint,
    pub cond: *mut PLpgSQL_expr,
    pub then_body: *mut List,
    pub elsif_list: *mut List,
    pub else_body: *mut List,
}
impl Default for PLpgSQL_stmt_if {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PLpgSQL_if_elsif {
    pub lineno: ::core::ffi::c_int,
    pub cond: *mut PLpgSQL_expr,
    pub stmts: *mut List,
}
impl Default for PLpgSQL_if_elsif {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PLpgSQL_stmt_case {
    pub cmd_type: PLpgSQL_stmt_type::Type,
    pub lineno: ::core::ffi::c_int,
    pub stmtid: ::core::ffi::c_uint,
    pub t_expr: *mut PLpgSQL_expr,
    pub t_varno: ::core::ffi::c_int,
    pub case_when_list: *mut List,
    pub have_else: bool,
    pub else_stmts: *mut List,
}
impl Default for PLpgSQL_stmt_case {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PLpgSQL_case_when {
    pub lineno: ::core::ffi::c_int,
    pub expr: *mut PLpgSQL_expr,
    pub stmts: *mut List,
}
impl Default for PLpgSQL_case_when {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PLpgSQL_stmt_loop {
    pub cmd_type: PLpgSQL_stmt_type::Type,
    pub lineno: ::core::ffi::c_int,
    pub stmtid: ::core::ffi::c_uint,
    pub label: *mut ::core::ffi::c_char,
    pub body: *mut List,
}
impl Default for PLpgSQL_stmt_loop {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PLpgSQL_stmt_while {
    pub cmd_type: PLpgSQL_stmt_type::Type,
    pub lineno: ::core::ffi::c_int,
    pub stmtid: ::core::ffi::c_uint,
    pub label: *mut ::core::ffi::c_char,
    pub cond: *mut PLpgSQL_expr,
    pub body: *mut List,
}
impl Default for PLpgSQL_stmt_while {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PLpgSQL_stmt_fori {
    pub cmd_type: PLpgSQL_stmt_type::Type,
    pub lineno: ::core::ffi::c_int,
    pub stmtid: ::core::ffi::c_uint,
    pub label: *mut ::core::ffi::c_char,
    pub var: *mut PLpgSQL_var,
    pub lower: *mut PLpgSQL_expr,
    pub upper: *mut PLpgSQL_expr,
    pub step: *mut PLpgSQL_expr,
    pub reverse: ::core::ffi::c_int,
    pub body: *mut List,
}
impl Default for PLpgSQL_stmt_fori {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PLpgSQL_stmt_forq {
    pub cmd_type: PLpgSQL_stmt_type::Type,
    pub lineno: ::core::ffi::c_int,
    pub stmtid: ::core::ffi::c_uint,
    pub label: *mut ::core::ffi::c_char,
    pub var: *mut PLpgSQL_variable,
    pub body: *mut List,
}
impl Default for PLpgSQL_stmt_forq {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PLpgSQL_stmt_fors {
    pub cmd_type: PLpgSQL_stmt_type::Type,
    pub lineno: ::core::ffi::c_int,
    pub stmtid: ::core::ffi::c_uint,
    pub label: *mut ::core::ffi::c_char,
    pub var: *mut PLpgSQL_variable,
    pub body: *mut List,
    pub query: *mut PLpgSQL_expr,
}
impl Default for PLpgSQL_stmt_fors {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PLpgSQL_stmt_forc {
    pub cmd_type: PLpgSQL_stmt_type::Type,
    pub lineno: ::core::ffi::c_int,
    pub stmtid: ::core::ffi::c_uint,
    pub label: *mut ::core::ffi::c_char,
    pub var: *mut PLpgSQL_variable,
    pub body: *mut List,
    pub curvar: ::core::ffi::c_int,
    pub argquery: *mut PLpgSQL_expr,
}
impl Default for PLpgSQL_stmt_forc {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PLpgSQL_stmt_dynfors {
    pub cmd_type: PLpgSQL_stmt_type::Type,
    pub lineno: ::core::ffi::c_int,
    pub stmtid: ::core::ffi::c_uint,
    pub label: *mut ::core::ffi::c_char,
    pub var: *mut PLpgSQL_variable,
    pub body: *mut List,
    pub query: *mut PLpgSQL_expr,
    pub params: *mut List,
}
impl Default for PLpgSQL_stmt_dynfors {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PLpgSQL_stmt_foreach_a {
    pub cmd_type: PLpgSQL_stmt_type::Type,
    pub lineno: ::core::ffi::c_int,
    pub stmtid: ::core::ffi::c_uint,
    pub label: *mut ::core::ffi::c_char,
    pub varno: ::core::ffi::c_int,
    pub slice: ::core::ffi::c_int,
    pub expr: *mut PLpgSQL_expr,
    pub body: *mut List,
}
impl Default for PLpgSQL_stmt_foreach_a {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PLpgSQL_stmt_open {
    pub cmd_type: PLpgSQL_stmt_type::Type,
    pub lineno: ::core::ffi::c_int,
    pub stmtid: ::core::ffi::c_uint,
    pub curvar: ::core::ffi::c_int,
    pub cursor_options: ::core::ffi::c_int,
    pub argquery: *mut PLpgSQL_expr,
    pub query: *mut PLpgSQL_expr,
    pub dynquery: *mut PLpgSQL_expr,
    pub params: *mut List,
}
impl Default for PLpgSQL_stmt_open {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PLpgSQL_stmt_fetch {
    pub cmd_type: PLpgSQL_stmt_type::Type,
    pub lineno: ::core::ffi::c_int,
    pub stmtid: ::core::ffi::c_uint,
    pub target: *mut PLpgSQL_variable,
    pub curvar: ::core::ffi::c_int,
    pub direction: FetchDirection::Type,
    pub how_many: ::core::ffi::c_long,
    pub expr: *mut PLpgSQL_expr,
    pub is_move: bool,
    pub returns_multiple_rows: bool,
}
impl Default for PLpgSQL_stmt_fetch {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PLpgSQL_stmt_close {
    pub cmd_type: PLpgSQL_stmt_type::Type,
    pub lineno: ::core::ffi::c_int,
    pub stmtid: ::core::ffi::c_uint,
    pub curvar: ::core::ffi::c_int,
}
impl Default for PLpgSQL_stmt_close {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PLpgSQL_stmt_exit {
    pub cmd_type: PLpgSQL_stmt_type::Type,
    pub lineno: ::core::ffi::c_int,
    pub stmtid: ::core::ffi::c_uint,
    pub is_exit: bool,
    pub label: *mut ::core::ffi::c_char,
    pub cond: *mut PLpgSQL_expr,
}
impl Default for PLpgSQL_stmt_exit {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PLpgSQL_stmt_return {
    pub cmd_type: PLpgSQL_stmt_type::Type,
    pub lineno: ::core::ffi::c_int,
    pub stmtid: ::core::ffi::c_uint,
    pub expr: *mut PLpgSQL_expr,
    pub retvarno: ::core::ffi::c_int,
}
impl Default for PLpgSQL_stmt_return {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PLpgSQL_stmt_return_next {
    pub cmd_type: PLpgSQL_stmt_type::Type,
    pub lineno: ::core::ffi::c_int,
    pub stmtid: ::core::ffi::c_uint,
    pub expr: *mut PLpgSQL_expr,
    pub retvarno: ::core::ffi::c_int,
}
impl Default for PLpgSQL_stmt_return_next {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PLpgSQL_stmt_return_query {
    pub cmd_type: PLpgSQL_stmt_type::Type,
    pub lineno: ::core::ffi::c_int,
    pub stmtid: ::core::ffi::c_uint,
    pub query: *mut PLpgSQL_expr,
    pub dynquery: *mut PLpgSQL_expr,
    pub params: *mut List,
}
impl Default for PLpgSQL_stmt_return_query {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PLpgSQL_stmt_raise {
    pub cmd_type: PLpgSQL_stmt_type::Type,
    pub lineno: ::core::ffi::c_int,
    pub stmtid: ::core::ffi::c_uint,
    pub elog_level: ::core::ffi::c_int,
    pub condname: *mut ::core::ffi::c_char,
    pub message: *mut ::core::ffi::c_char,
    pub params: *mut List,
    pub options: *mut List,
}
impl Default for PLpgSQL_stmt_raise {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PLpgSQL_raise_option {
    pub opt_type: PLpgSQL_raise_option_type::Type,
    pub expr: *mut PLpgSQL_expr,
}
impl Default for PLpgSQL_raise_option {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PLpgSQL_stmt_assert {
    pub cmd_type: PLpgSQL_stmt_type::Type,
    pub lineno: ::core::ffi::c_int,
    pub stmtid: ::core::ffi::c_uint,
    pub cond: *mut PLpgSQL_expr,
    pub message: *mut PLpgSQL_expr,
}
impl Default for PLpgSQL_stmt_assert {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PLpgSQL_stmt_execsql {
    pub cmd_type: PLpgSQL_stmt_type::Type,
    pub lineno: ::core::ffi::c_int,
    pub stmtid: ::core::ffi::c_uint,
    pub sqlstmt: *mut PLpgSQL_expr,
    pub mod_stmt: bool,
    pub mod_stmt_set: bool,
    pub into: bool,
    pub strict: bool,
    pub target: *mut PLpgSQL_variable,
}
impl Default for PLpgSQL_stmt_execsql {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PLpgSQL_stmt_dynexecute {
    pub cmd_type: PLpgSQL_stmt_type::Type,
    pub lineno: ::core::ffi::c_int,
    pub stmtid: ::core::ffi::c_uint,
    pub query: *mut PLpgSQL_expr,
    pub into: bool,
    pub strict: bool,
    pub target: *mut PLpgSQL_variable,
    pub params: *mut List,
}
impl Default for PLpgSQL_stmt_dynexecute {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PLpgSQL_func_hashkey {
    pub funcOid: Oid,
    pub isTrigger: bool,
    pub isEventTrigger: bool,
    pub trigOid: Oid,
    pub inputCollation: Oid,
    pub argtypes: [Oid; 100usize],
}
impl Default for PLpgSQL_func_hashkey {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod PLpgSQL_trigtype {
    pub type Type = ::core::ffi::c_uint;
    pub const PLPGSQL_DML_TRIGGER: Type = 0;
    pub const PLPGSQL_EVENT_TRIGGER: Type = 1;
    pub const PLPGSQL_NOT_TRIGGER: Type = 2;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PLpgSQL_function {
    pub fn_signature: *mut ::core::ffi::c_char,
    pub fn_oid: Oid,
    pub fn_xmin: TransactionId,
    pub fn_tid: ItemPointerData,
    pub fn_is_trigger: PLpgSQL_trigtype::Type,
    pub fn_input_collation: Oid,
    pub fn_hashkey: *mut PLpgSQL_func_hashkey,
    pub fn_cxt: MemoryContext,
    pub fn_rettype: Oid,
    pub fn_rettyplen: ::core::ffi::c_int,
    pub fn_retbyval: bool,
    pub fn_retistuple: bool,
    pub fn_retisdomain: bool,
    pub fn_retset: bool,
    pub fn_readonly: bool,
    pub fn_prokind: ::core::ffi::c_char,
    pub fn_nargs: ::core::ffi::c_int,
    pub fn_argvarnos: [::core::ffi::c_int; 100usize],
    pub out_param_varno: ::core::ffi::c_int,
    pub found_varno: ::core::ffi::c_int,
    pub new_varno: ::core::ffi::c_int,
    pub old_varno: ::core::ffi::c_int,
    pub resolve_option: PLpgSQL_resolve_option::Type,
    pub print_strict_params: bool,
    pub extra_warnings: ::core::ffi::c_int,
    pub extra_errors: ::core::ffi::c_int,
    pub ndatums: ::core::ffi::c_int,
    pub datums: *mut *mut PLpgSQL_datum,
    pub copiable_size: Size,
    pub action: *mut PLpgSQL_stmt_block,
    pub nstatements: ::core::ffi::c_uint,
    pub requires_procedure_resowner: bool,
    pub cur_estate: *mut PLpgSQL_execstate,
    pub use_count: ::core::ffi::c_ulong,
}
impl Default for PLpgSQL_function {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PLpgSQL_execstate {
    pub func: *mut PLpgSQL_function,
    pub trigdata: *mut TriggerData,
    pub evtrigdata: *mut EventTriggerData,
    pub retval: Datum,
    pub retisnull: bool,
    pub rettype: Oid,
    pub fn_rettype: Oid,
    pub retistuple: bool,
    pub retisset: bool,
    pub readonly_func: bool,
    pub atomic: bool,
    pub exitlabel: *mut ::core::ffi::c_char,
    pub cur_error: *mut ErrorData,
    pub tuple_store: *mut Tuplestorestate,
    pub tuple_store_desc: TupleDesc,
    pub tuple_store_cxt: MemoryContext,
    pub tuple_store_owner: ResourceOwner,
    pub rsi: *mut ReturnSetInfo,
    pub found_varno: ::core::ffi::c_int,
    pub ndatums: ::core::ffi::c_int,
    pub datums: *mut *mut PLpgSQL_datum,
    pub datum_context: MemoryContext,
    pub paramLI: ParamListInfo,
    pub simple_eval_estate: *mut EState,
    pub simple_eval_resowner: ResourceOwner,
    pub procedure_resowner: ResourceOwner,
    pub cast_hash: *mut HTAB,
    pub cast_hash_context: MemoryContext,
    pub stmt_mcontext: MemoryContext,
    pub stmt_mcontext_parent: MemoryContext,
    pub eval_tuptable: *mut SPITupleTable,
    pub eval_processed: uint64,
    pub eval_econtext: *mut ExprContext,
    pub err_stmt: *mut PLpgSQL_stmt,
    pub err_var: *mut PLpgSQL_variable,
    pub err_text: *const ::core::ffi::c_char,
    pub plugin_info: *mut ::core::ffi::c_void,
}
impl Default for PLpgSQL_execstate {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct PLpgSQL_plugin {
    pub func_setup: ::core::option::Option<
        unsafe extern "C-unwind" fn(estate: *mut PLpgSQL_execstate, func: *mut PLpgSQL_function),
    >,
    pub func_beg: ::core::option::Option<
        unsafe extern "C-unwind" fn(estate: *mut PLpgSQL_execstate, func: *mut PLpgSQL_function),
    >,
    pub func_end: ::core::option::Option<
        unsafe extern "C-unwind" fn(estate: *mut PLpgSQL_execstate, func: *mut PLpgSQL_function),
    >,
    pub stmt_beg: ::core::option::Option<
        unsafe extern "C-unwind" fn(estate: *mut PLpgSQL_execstate, stmt: *mut PLpgSQL_stmt),
    >,
    pub stmt_end: ::core::option::Option<
        unsafe extern "C-unwind" fn(estate: *mut PLpgSQL_execstate, stmt: *mut PLpgSQL_stmt),
    >,
    pub error_callback:
        ::core::option::Option<unsafe extern "C-unwind" fn(arg: *mut ::core::ffi::c_void)>,
    pub assign_expr: ::core::option::Option<
        unsafe extern "C-unwind" fn(
            estate: *mut PLpgSQL_execstate,
            target: *mut PLpgSQL_datum,
            expr: *mut PLpgSQL_expr,
        ),
    >,
    pub assign_value: ::core::option::Option<
        unsafe extern "C-unwind" fn(
            estate: *mut PLpgSQL_execstate,
            target: *mut PLpgSQL_datum,
            value: Datum,
            isNull: bool,
            valtype: Oid,
            valtypmod: int32,
        ),
    >,
    pub eval_datum: ::core::option::Option<
        unsafe extern "C-unwind" fn(
            estate: *mut PLpgSQL_execstate,
            datum: *mut PLpgSQL_datum,
            typeId: *mut Oid,
            typetypmod: *mut int32,
            value: *mut Datum,
            isnull: *mut bool,
        ),
    >,
    pub cast_value: ::core::option::Option<
        unsafe extern "C-unwind" fn(
            estate: *mut PLpgSQL_execstate,
            value: Datum,
            isnull: *mut bool,
            valtype: Oid,
            valtypmod: int32,
            reqtype: Oid,
            reqtypmod: int32,
        ) -> Datum,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PLword {
    pub ident: *mut ::core::ffi::c_char,
    pub quoted: bool,
}
impl Default for PLword {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PLcword {
    pub idents: *mut List,
}
impl Default for PLcword {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PLwdatum {
    pub datum: *mut PLpgSQL_datum,
    pub ident: *mut ::core::ffi::c_char,
    pub quoted: bool,
    pub idents: *mut List,
}
impl Default for PLwdatum {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod IdentifierLookup {
    #[doc = " Global variable declarations"]
    pub type Type = ::core::ffi::c_uint;
    pub const IDENTIFIER_LOOKUP_NORMAL: Type = 0;
    pub const IDENTIFIER_LOOKUP_DECLARE: Type = 1;
    pub const IDENTIFIER_LOOKUP_EXPR: Type = 2;
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct PipeProtoHeader {
    pub nuls: [::core::ffi::c_char; 2usize],
    pub len: uint16,
    pub pid: int32,
    pub flags: bits8,
    pub data: __IncompleteArrayField<::core::ffi::c_char>,
}
#[repr(C)]
pub union PipeProtoChunk {
    pub proto: ::core::mem::ManuallyDrop<PipeProtoHeader>,
    pub filler: ::core::mem::ManuallyDrop<[::core::ffi::c_char; 4096usize]>,
}
impl Default for PipeProtoChunk {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ReorderBufferTupleBuf {
    pub node: slist_node,
    pub tuple: HeapTupleData,
    pub alloc_tuple_size: Size,
}
impl Default for ReorderBufferTupleBuf {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod ReorderBufferChangeType {
    pub type Type = ::core::ffi::c_uint;
    pub const REORDER_BUFFER_CHANGE_INSERT: Type = 0;
    pub const REORDER_BUFFER_CHANGE_UPDATE: Type = 1;
    pub const REORDER_BUFFER_CHANGE_DELETE: Type = 2;
    pub const REORDER_BUFFER_CHANGE_MESSAGE: Type = 3;
    pub const REORDER_BUFFER_CHANGE_INVALIDATION: Type = 4;
    pub const REORDER_BUFFER_CHANGE_INTERNAL_SNAPSHOT: Type = 5;
    pub const REORDER_BUFFER_CHANGE_INTERNAL_COMMAND_ID: Type = 6;
    pub const REORDER_BUFFER_CHANGE_INTERNAL_TUPLECID: Type = 7;
    pub const REORDER_BUFFER_CHANGE_INTERNAL_SPEC_INSERT: Type = 8;
    pub const REORDER_BUFFER_CHANGE_INTERNAL_SPEC_CONFIRM: Type = 9;
    pub const REORDER_BUFFER_CHANGE_INTERNAL_SPEC_ABORT: Type = 10;
    pub const REORDER_BUFFER_CHANGE_TRUNCATE: Type = 11;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct ReorderBufferChange {
    pub lsn: XLogRecPtr,
    pub action: ReorderBufferChangeType::Type,
    pub txn: *mut ReorderBufferTXN,
    pub origin_id: RepOriginId,
    pub data: ReorderBufferChange__bindgen_ty_1,
    pub node: dlist_node,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union ReorderBufferChange__bindgen_ty_1 {
    pub tp: ReorderBufferChange__bindgen_ty_1__bindgen_ty_1,
    pub truncate: ReorderBufferChange__bindgen_ty_1__bindgen_ty_2,
    pub msg: ReorderBufferChange__bindgen_ty_1__bindgen_ty_3,
    pub snapshot: Snapshot,
    pub command_id: CommandId,
    pub tuplecid: ReorderBufferChange__bindgen_ty_1__bindgen_ty_4,
    pub inval: ReorderBufferChange__bindgen_ty_1__bindgen_ty_5,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ReorderBufferChange__bindgen_ty_1__bindgen_ty_1 {
    pub relnode: RelFileNode,
    pub clear_toast_afterwards: bool,
    pub oldtuple: *mut ReorderBufferTupleBuf,
    pub newtuple: *mut ReorderBufferTupleBuf,
}
impl Default for ReorderBufferChange__bindgen_ty_1__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ReorderBufferChange__bindgen_ty_1__bindgen_ty_2 {
    pub nrelids: Size,
    pub cascade: bool,
    pub restart_seqs: bool,
    pub relids: *mut Oid,
}
impl Default for ReorderBufferChange__bindgen_ty_1__bindgen_ty_2 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ReorderBufferChange__bindgen_ty_1__bindgen_ty_3 {
    pub prefix: *mut ::core::ffi::c_char,
    pub message_size: Size,
    pub message: *mut ::core::ffi::c_char,
}
impl Default for ReorderBufferChange__bindgen_ty_1__bindgen_ty_3 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ReorderBufferChange__bindgen_ty_1__bindgen_ty_4 {
    pub node: RelFileNode,
    pub tid: ItemPointerData,
    pub cmin: CommandId,
    pub cmax: CommandId,
    pub combocid: CommandId,
}
impl Default for ReorderBufferChange__bindgen_ty_1__bindgen_ty_4 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ReorderBufferChange__bindgen_ty_1__bindgen_ty_5 {
    pub ninvalidations: uint32,
    pub invalidations: *mut SharedInvalidationMessage,
}
impl Default for ReorderBufferChange__bindgen_ty_1__bindgen_ty_5 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for ReorderBufferChange__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for ReorderBufferChange {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct ReorderBufferTXN {
    pub txn_flags: bits32,
    pub xid: TransactionId,
    pub toplevel_xid: TransactionId,
    pub gid: *mut ::core::ffi::c_char,
    pub first_lsn: XLogRecPtr,
    pub final_lsn: XLogRecPtr,
    pub end_lsn: XLogRecPtr,
    pub toptxn: *mut ReorderBufferTXN,
    pub restart_decoding_lsn: XLogRecPtr,
    pub origin_id: RepOriginId,
    pub origin_lsn: XLogRecPtr,
    pub xact_time: ReorderBufferTXN__bindgen_ty_1,
    pub base_snapshot: Snapshot,
    pub base_snapshot_lsn: XLogRecPtr,
    pub base_snapshot_node: dlist_node,
    pub snapshot_now: Snapshot,
    pub command_id: CommandId,
    pub nentries: uint64,
    pub nentries_mem: uint64,
    pub changes: dlist_head,
    pub tuplecids: dlist_head,
    pub ntuplecids: uint64,
    pub tuplecid_hash: *mut HTAB,
    pub toast_hash: *mut HTAB,
    pub subtxns: dlist_head,
    pub nsubtxns: uint32,
    pub ninvalidations: uint32,
    pub invalidations: *mut SharedInvalidationMessage,
    pub node: dlist_node,
    pub size: Size,
    pub total_size: Size,
    pub concurrent_abort: bool,
    pub output_plugin_private: *mut ::core::ffi::c_void,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union ReorderBufferTXN__bindgen_ty_1 {
    pub commit_time: TimestampTz,
    pub prepare_time: TimestampTz,
}
impl Default for ReorderBufferTXN__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for ReorderBufferTXN {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type ReorderBufferApplyChangeCB = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        rb: *mut ReorderBuffer,
        txn: *mut ReorderBufferTXN,
        relation: Relation,
        change: *mut ReorderBufferChange,
    ),
>;
pub type ReorderBufferApplyTruncateCB = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        rb: *mut ReorderBuffer,
        txn: *mut ReorderBufferTXN,
        nrelations: ::core::ffi::c_int,
        relations: *mut Relation,
        change: *mut ReorderBufferChange,
    ),
>;
pub type ReorderBufferBeginCB = ::core::option::Option<
    unsafe extern "C-unwind" fn(rb: *mut ReorderBuffer, txn: *mut ReorderBufferTXN),
>;
pub type ReorderBufferCommitCB = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        rb: *mut ReorderBuffer,
        txn: *mut ReorderBufferTXN,
        commit_lsn: XLogRecPtr,
    ),
>;
pub type ReorderBufferMessageCB = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        rb: *mut ReorderBuffer,
        txn: *mut ReorderBufferTXN,
        message_lsn: XLogRecPtr,
        transactional: bool,
        prefix: *const ::core::ffi::c_char,
        sz: Size,
        message: *const ::core::ffi::c_char,
    ),
>;
pub type ReorderBufferBeginPrepareCB = ::core::option::Option<
    unsafe extern "C-unwind" fn(rb: *mut ReorderBuffer, txn: *mut ReorderBufferTXN),
>;
pub type ReorderBufferPrepareCB = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        rb: *mut ReorderBuffer,
        txn: *mut ReorderBufferTXN,
        prepare_lsn: XLogRecPtr,
    ),
>;
pub type ReorderBufferCommitPreparedCB = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        rb: *mut ReorderBuffer,
        txn: *mut ReorderBufferTXN,
        commit_lsn: XLogRecPtr,
    ),
>;
pub type ReorderBufferRollbackPreparedCB = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        rb: *mut ReorderBuffer,
        txn: *mut ReorderBufferTXN,
        prepare_end_lsn: XLogRecPtr,
        prepare_time: TimestampTz,
    ),
>;
pub type ReorderBufferStreamStartCB = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        rb: *mut ReorderBuffer,
        txn: *mut ReorderBufferTXN,
        first_lsn: XLogRecPtr,
    ),
>;
pub type ReorderBufferStreamStopCB = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        rb: *mut ReorderBuffer,
        txn: *mut ReorderBufferTXN,
        last_lsn: XLogRecPtr,
    ),
>;
pub type ReorderBufferStreamAbortCB = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        rb: *mut ReorderBuffer,
        txn: *mut ReorderBufferTXN,
        abort_lsn: XLogRecPtr,
    ),
>;
pub type ReorderBufferStreamPrepareCB = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        rb: *mut ReorderBuffer,
        txn: *mut ReorderBufferTXN,
        prepare_lsn: XLogRecPtr,
    ),
>;
pub type ReorderBufferStreamCommitCB = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        rb: *mut ReorderBuffer,
        txn: *mut ReorderBufferTXN,
        commit_lsn: XLogRecPtr,
    ),
>;
pub type ReorderBufferStreamChangeCB = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        rb: *mut ReorderBuffer,
        txn: *mut ReorderBufferTXN,
        relation: Relation,
        change: *mut ReorderBufferChange,
    ),
>;
pub type ReorderBufferStreamMessageCB = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        rb: *mut ReorderBuffer,
        txn: *mut ReorderBufferTXN,
        message_lsn: XLogRecPtr,
        transactional: bool,
        prefix: *const ::core::ffi::c_char,
        sz: Size,
        message: *const ::core::ffi::c_char,
    ),
>;
pub type ReorderBufferStreamTruncateCB = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        rb: *mut ReorderBuffer,
        txn: *mut ReorderBufferTXN,
        nrelations: ::core::ffi::c_int,
        relations: *mut Relation,
        change: *mut ReorderBufferChange,
    ),
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ReorderBuffer {
    pub by_txn: *mut HTAB,
    pub toplevel_by_lsn: dlist_head,
    pub txns_by_base_snapshot_lsn: dlist_head,
    pub by_txn_last_xid: TransactionId,
    pub by_txn_last_txn: *mut ReorderBufferTXN,
    pub begin: ReorderBufferBeginCB,
    pub apply_change: ReorderBufferApplyChangeCB,
    pub apply_truncate: ReorderBufferApplyTruncateCB,
    pub commit: ReorderBufferCommitCB,
    pub message: ReorderBufferMessageCB,
    pub begin_prepare: ReorderBufferBeginCB,
    pub prepare: ReorderBufferPrepareCB,
    pub commit_prepared: ReorderBufferCommitPreparedCB,
    pub rollback_prepared: ReorderBufferRollbackPreparedCB,
    pub stream_start: ReorderBufferStreamStartCB,
    pub stream_stop: ReorderBufferStreamStopCB,
    pub stream_abort: ReorderBufferStreamAbortCB,
    pub stream_prepare: ReorderBufferStreamPrepareCB,
    pub stream_commit: ReorderBufferStreamCommitCB,
    pub stream_change: ReorderBufferStreamChangeCB,
    pub stream_message: ReorderBufferStreamMessageCB,
    pub stream_truncate: ReorderBufferStreamTruncateCB,
    pub private_data: *mut ::core::ffi::c_void,
    pub output_rewrites: bool,
    pub context: MemoryContext,
    pub change_context: MemoryContext,
    pub txn_context: MemoryContext,
    pub tup_context: MemoryContext,
    pub current_restart_decoding_lsn: XLogRecPtr,
    pub outbuf: *mut ::core::ffi::c_char,
    pub outbufsize: Size,
    pub size: Size,
    pub spillTxns: int64,
    pub spillCount: int64,
    pub spillBytes: int64,
    pub streamTxns: int64,
    pub streamCount: int64,
    pub streamBytes: int64,
    pub totalTxns: int64,
    pub totalBytes: int64,
}
impl Default for ReorderBuffer {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod OutputPluginOutputType {
    pub type Type = ::core::ffi::c_uint;
    pub const OUTPUT_PLUGIN_BINARY_OUTPUT: Type = 0;
    pub const OUTPUT_PLUGIN_TEXTUAL_OUTPUT: Type = 1;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OutputPluginOptions {
    pub output_type: OutputPluginOutputType::Type,
    pub receive_rewrites: bool,
}
impl Default for OutputPluginOptions {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type LogicalOutputPluginInit =
    ::core::option::Option<unsafe extern "C-unwind" fn(cb: *mut OutputPluginCallbacks)>;
pub type LogicalDecodeStartupCB = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        ctx: *mut LogicalDecodingContext,
        options: *mut OutputPluginOptions,
        is_init: bool,
    ),
>;
pub type LogicalDecodeBeginCB = ::core::option::Option<
    unsafe extern "C-unwind" fn(ctx: *mut LogicalDecodingContext, txn: *mut ReorderBufferTXN),
>;
pub type LogicalDecodeChangeCB = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        ctx: *mut LogicalDecodingContext,
        txn: *mut ReorderBufferTXN,
        relation: Relation,
        change: *mut ReorderBufferChange,
    ),
>;
pub type LogicalDecodeTruncateCB = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        ctx: *mut LogicalDecodingContext,
        txn: *mut ReorderBufferTXN,
        nrelations: ::core::ffi::c_int,
        relations: *mut Relation,
        change: *mut ReorderBufferChange,
    ),
>;
pub type LogicalDecodeCommitCB = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        ctx: *mut LogicalDecodingContext,
        txn: *mut ReorderBufferTXN,
        commit_lsn: XLogRecPtr,
    ),
>;
pub type LogicalDecodeMessageCB = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        ctx: *mut LogicalDecodingContext,
        txn: *mut ReorderBufferTXN,
        message_lsn: XLogRecPtr,
        transactional: bool,
        prefix: *const ::core::ffi::c_char,
        message_size: Size,
        message: *const ::core::ffi::c_char,
    ),
>;
pub type LogicalDecodeFilterByOriginCB = ::core::option::Option<
    unsafe extern "C-unwind" fn(ctx: *mut LogicalDecodingContext, origin_id: RepOriginId) -> bool,
>;
pub type LogicalDecodeShutdownCB =
    ::core::option::Option<unsafe extern "C-unwind" fn(ctx: *mut LogicalDecodingContext)>;
pub type LogicalDecodeFilterPrepareCB = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        ctx: *mut LogicalDecodingContext,
        xid: TransactionId,
        gid: *const ::core::ffi::c_char,
    ) -> bool,
>;
pub type LogicalDecodeBeginPrepareCB = ::core::option::Option<
    unsafe extern "C-unwind" fn(ctx: *mut LogicalDecodingContext, txn: *mut ReorderBufferTXN),
>;
pub type LogicalDecodePrepareCB = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        ctx: *mut LogicalDecodingContext,
        txn: *mut ReorderBufferTXN,
        prepare_lsn: XLogRecPtr,
    ),
>;
pub type LogicalDecodeCommitPreparedCB = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        ctx: *mut LogicalDecodingContext,
        txn: *mut ReorderBufferTXN,
        commit_lsn: XLogRecPtr,
    ),
>;
pub type LogicalDecodeRollbackPreparedCB = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        ctx: *mut LogicalDecodingContext,
        txn: *mut ReorderBufferTXN,
        prepare_end_lsn: XLogRecPtr,
        prepare_time: TimestampTz,
    ),
>;
pub type LogicalDecodeStreamStartCB = ::core::option::Option<
    unsafe extern "C-unwind" fn(ctx: *mut LogicalDecodingContext, txn: *mut ReorderBufferTXN),
>;
pub type LogicalDecodeStreamStopCB = ::core::option::Option<
    unsafe extern "C-unwind" fn(ctx: *mut LogicalDecodingContext, txn: *mut ReorderBufferTXN),
>;
pub type LogicalDecodeStreamAbortCB = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        ctx: *mut LogicalDecodingContext,
        txn: *mut ReorderBufferTXN,
        abort_lsn: XLogRecPtr,
    ),
>;
pub type LogicalDecodeStreamPrepareCB = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        ctx: *mut LogicalDecodingContext,
        txn: *mut ReorderBufferTXN,
        prepare_lsn: XLogRecPtr,
    ),
>;
pub type LogicalDecodeStreamCommitCB = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        ctx: *mut LogicalDecodingContext,
        txn: *mut ReorderBufferTXN,
        commit_lsn: XLogRecPtr,
    ),
>;
pub type LogicalDecodeStreamChangeCB = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        ctx: *mut LogicalDecodingContext,
        txn: *mut ReorderBufferTXN,
        relation: Relation,
        change: *mut ReorderBufferChange,
    ),
>;
pub type LogicalDecodeStreamMessageCB = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        ctx: *mut LogicalDecodingContext,
        txn: *mut ReorderBufferTXN,
        message_lsn: XLogRecPtr,
        transactional: bool,
        prefix: *const ::core::ffi::c_char,
        message_size: Size,
        message: *const ::core::ffi::c_char,
    ),
>;
pub type LogicalDecodeStreamTruncateCB = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        ctx: *mut LogicalDecodingContext,
        txn: *mut ReorderBufferTXN,
        nrelations: ::core::ffi::c_int,
        relations: *mut Relation,
        change: *mut ReorderBufferChange,
    ),
>;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct OutputPluginCallbacks {
    pub startup_cb: LogicalDecodeStartupCB,
    pub begin_cb: LogicalDecodeBeginCB,
    pub change_cb: LogicalDecodeChangeCB,
    pub truncate_cb: LogicalDecodeTruncateCB,
    pub commit_cb: LogicalDecodeCommitCB,
    pub message_cb: LogicalDecodeMessageCB,
    pub filter_by_origin_cb: LogicalDecodeFilterByOriginCB,
    pub shutdown_cb: LogicalDecodeShutdownCB,
    pub filter_prepare_cb: LogicalDecodeFilterPrepareCB,
    pub begin_prepare_cb: LogicalDecodeBeginPrepareCB,
    pub prepare_cb: LogicalDecodePrepareCB,
    pub commit_prepared_cb: LogicalDecodeCommitPreparedCB,
    pub rollback_prepared_cb: LogicalDecodeRollbackPreparedCB,
    pub stream_start_cb: LogicalDecodeStreamStartCB,
    pub stream_stop_cb: LogicalDecodeStreamStopCB,
    pub stream_abort_cb: LogicalDecodeStreamAbortCB,
    pub stream_prepare_cb: LogicalDecodeStreamPrepareCB,
    pub stream_commit_cb: LogicalDecodeStreamCommitCB,
    pub stream_change_cb: LogicalDecodeStreamChangeCB,
    pub stream_message_cb: LogicalDecodeStreamMessageCB,
    pub stream_truncate_cb: LogicalDecodeStreamTruncateCB,
}
pub mod LogicalRepMsgType {
    pub type Type = ::core::ffi::c_uint;
    pub const LOGICAL_REP_MSG_BEGIN: Type = 66;
    pub const LOGICAL_REP_MSG_COMMIT: Type = 67;
    pub const LOGICAL_REP_MSG_ORIGIN: Type = 79;
    pub const LOGICAL_REP_MSG_INSERT: Type = 73;
    pub const LOGICAL_REP_MSG_UPDATE: Type = 85;
    pub const LOGICAL_REP_MSG_DELETE: Type = 68;
    pub const LOGICAL_REP_MSG_TRUNCATE: Type = 84;
    pub const LOGICAL_REP_MSG_RELATION: Type = 82;
    pub const LOGICAL_REP_MSG_TYPE: Type = 89;
    pub const LOGICAL_REP_MSG_MESSAGE: Type = 77;
    pub const LOGICAL_REP_MSG_BEGIN_PREPARE: Type = 98;
    pub const LOGICAL_REP_MSG_PREPARE: Type = 80;
    pub const LOGICAL_REP_MSG_COMMIT_PREPARED: Type = 75;
    pub const LOGICAL_REP_MSG_ROLLBACK_PREPARED: Type = 114;
    pub const LOGICAL_REP_MSG_STREAM_START: Type = 83;
    pub const LOGICAL_REP_MSG_STREAM_STOP: Type = 69;
    pub const LOGICAL_REP_MSG_STREAM_COMMIT: Type = 99;
    pub const LOGICAL_REP_MSG_STREAM_ABORT: Type = 65;
    pub const LOGICAL_REP_MSG_STREAM_PREPARE: Type = 112;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LogicalRepTupleData {
    pub colvalues: *mut StringInfoData,
    pub colstatus: *mut ::core::ffi::c_char,
    pub ncols: ::core::ffi::c_int,
}
impl Default for LogicalRepTupleData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type LogicalRepRelId = uint32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LogicalRepRelation {
    pub remoteid: LogicalRepRelId,
    pub nspname: *mut ::core::ffi::c_char,
    pub relname: *mut ::core::ffi::c_char,
    pub natts: ::core::ffi::c_int,
    pub attnames: *mut *mut ::core::ffi::c_char,
    pub atttyps: *mut Oid,
    pub replident: ::core::ffi::c_char,
    pub relkind: ::core::ffi::c_char,
    pub attkeys: *mut Bitmapset,
}
impl Default for LogicalRepRelation {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LogicalRepTyp {
    pub remoteid: Oid,
    pub nspname: *mut ::core::ffi::c_char,
    pub typname: *mut ::core::ffi::c_char,
}
impl Default for LogicalRepTyp {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LogicalRepBeginData {
    pub final_lsn: XLogRecPtr,
    pub committime: TimestampTz,
    pub xid: TransactionId,
}
impl Default for LogicalRepBeginData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct LogicalRepCommitData {
    pub commit_lsn: XLogRecPtr,
    pub end_lsn: XLogRecPtr,
    pub committime: TimestampTz,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LogicalRepPreparedTxnData {
    pub prepare_lsn: XLogRecPtr,
    pub end_lsn: XLogRecPtr,
    pub prepare_time: TimestampTz,
    pub xid: TransactionId,
    pub gid: [::core::ffi::c_char; 200usize],
}
impl Default for LogicalRepPreparedTxnData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LogicalRepCommitPreparedTxnData {
    pub commit_lsn: XLogRecPtr,
    pub end_lsn: XLogRecPtr,
    pub commit_time: TimestampTz,
    pub xid: TransactionId,
    pub gid: [::core::ffi::c_char; 200usize],
}
impl Default for LogicalRepCommitPreparedTxnData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LogicalRepRollbackPreparedTxnData {
    pub prepare_end_lsn: XLogRecPtr,
    pub rollback_end_lsn: XLogRecPtr,
    pub prepare_time: TimestampTz,
    pub rollback_time: TimestampTz,
    pub xid: TransactionId,
    pub gid: [::core::ffi::c_char; 200usize],
}
impl Default for LogicalRepRollbackPreparedTxnData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod CRSSnapshotAction {
    pub type Type = ::core::ffi::c_uint;
    pub const CRS_EXPORT_SNAPSHOT: Type = 0;
    pub const CRS_NOEXPORT_SNAPSHOT: Type = 1;
    pub const CRS_USE_SNAPSHOT: Type = 2;
}
pub mod WalRcvState {
    pub type Type = ::core::ffi::c_uint;
    pub const WALRCV_STOPPED: Type = 0;
    pub const WALRCV_STARTING: Type = 1;
    pub const WALRCV_STREAMING: Type = 2;
    pub const WALRCV_WAITING: Type = 3;
    pub const WALRCV_RESTARTING: Type = 4;
    pub const WALRCV_STOPPING: Type = 5;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WalRcvData {
    pub pid: pid_t,
    pub walRcvState: WalRcvState::Type,
    pub walRcvStoppedCV: ConditionVariable,
    pub startTime: pg_time_t,
    pub receiveStart: XLogRecPtr,
    pub receiveStartTLI: TimeLineID,
    pub flushedUpto: XLogRecPtr,
    pub receivedTLI: TimeLineID,
    pub latestChunkStart: XLogRecPtr,
    pub lastMsgSendTime: TimestampTz,
    pub lastMsgReceiptTime: TimestampTz,
    pub latestWalEnd: XLogRecPtr,
    pub latestWalEndTime: TimestampTz,
    pub conninfo: [::core::ffi::c_char; 1024usize],
    pub sender_host: [::core::ffi::c_char; 1025usize],
    pub sender_port: ::core::ffi::c_int,
    pub slotname: [::core::ffi::c_char; 64usize],
    pub is_temp_slot: bool,
    pub ready_to_display: bool,
    pub latch: *mut Latch,
    pub mutex: slock_t,
    pub writtenUpto: pg_atomic_uint64,
    pub force_reply: sig_atomic_t,
}
impl Default for WalRcvData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct WalRcvStreamOptions {
    pub logical: bool,
    pub slotname: *mut ::core::ffi::c_char,
    pub startpoint: XLogRecPtr,
    pub proto: WalRcvStreamOptions__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union WalRcvStreamOptions__bindgen_ty_1 {
    pub physical: WalRcvStreamOptions__bindgen_ty_1__bindgen_ty_1,
    pub logical: WalRcvStreamOptions__bindgen_ty_1__bindgen_ty_2,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct WalRcvStreamOptions__bindgen_ty_1__bindgen_ty_1 {
    pub startpointTLI: TimeLineID,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WalRcvStreamOptions__bindgen_ty_1__bindgen_ty_2 {
    pub proto_version: uint32,
    pub publication_names: *mut List,
    pub binary: bool,
    pub streaming: bool,
    pub twophase: bool,
}
impl Default for WalRcvStreamOptions__bindgen_ty_1__bindgen_ty_2 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for WalRcvStreamOptions__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for WalRcvStreamOptions {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WalReceiverConn {
    _unused: [u8; 0],
}
pub mod WalRcvExecStatus {
    pub type Type = ::core::ffi::c_uint;
    pub const WALRCV_ERROR: Type = 0;
    pub const WALRCV_OK_COMMAND: Type = 1;
    pub const WALRCV_OK_TUPLES: Type = 2;
    pub const WALRCV_OK_COPY_IN: Type = 3;
    pub const WALRCV_OK_COPY_OUT: Type = 4;
    pub const WALRCV_OK_COPY_BOTH: Type = 5;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WalRcvExecResult {
    pub status: WalRcvExecStatus::Type,
    pub sqlstate: ::core::ffi::c_int,
    pub err: *mut ::core::ffi::c_char,
    pub tuplestore: *mut Tuplestorestate,
    pub tupledesc: TupleDesc,
}
impl Default for WalRcvExecResult {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type walrcv_connect_fn = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        conninfo: *const ::core::ffi::c_char,
        logical: bool,
        appname: *const ::core::ffi::c_char,
        err: *mut *mut ::core::ffi::c_char,
    ) -> *mut WalReceiverConn,
>;
pub type walrcv_check_conninfo_fn =
    ::core::option::Option<unsafe extern "C-unwind" fn(conninfo: *const ::core::ffi::c_char)>;
pub type walrcv_get_conninfo_fn = ::core::option::Option<
    unsafe extern "C-unwind" fn(conn: *mut WalReceiverConn) -> *mut ::core::ffi::c_char,
>;
pub type walrcv_get_senderinfo_fn = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        conn: *mut WalReceiverConn,
        sender_host: *mut *mut ::core::ffi::c_char,
        sender_port: *mut ::core::ffi::c_int,
    ),
>;
pub type walrcv_identify_system_fn = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        conn: *mut WalReceiverConn,
        primary_tli: *mut TimeLineID,
    ) -> *mut ::core::ffi::c_char,
>;
pub type walrcv_server_version_fn = ::core::option::Option<
    unsafe extern "C-unwind" fn(conn: *mut WalReceiverConn) -> ::core::ffi::c_int,
>;
pub type walrcv_readtimelinehistoryfile_fn = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        conn: *mut WalReceiverConn,
        tli: TimeLineID,
        filename: *mut *mut ::core::ffi::c_char,
        content: *mut *mut ::core::ffi::c_char,
        size: *mut ::core::ffi::c_int,
    ),
>;
pub type walrcv_startstreaming_fn = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        conn: *mut WalReceiverConn,
        options: *const WalRcvStreamOptions,
    ) -> bool,
>;
pub type walrcv_endstreaming_fn = ::core::option::Option<
    unsafe extern "C-unwind" fn(conn: *mut WalReceiverConn, next_tli: *mut TimeLineID),
>;
pub type walrcv_receive_fn = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        conn: *mut WalReceiverConn,
        buffer: *mut *mut ::core::ffi::c_char,
        wait_fd: *mut pgsocket,
    ) -> ::core::ffi::c_int,
>;
pub type walrcv_send_fn = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        conn: *mut WalReceiverConn,
        buffer: *const ::core::ffi::c_char,
        nbytes: ::core::ffi::c_int,
    ),
>;
pub type walrcv_create_slot_fn = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        conn: *mut WalReceiverConn,
        slotname: *const ::core::ffi::c_char,
        temporary: bool,
        two_phase: bool,
        snapshot_action: CRSSnapshotAction::Type,
        lsn: *mut XLogRecPtr,
    ) -> *mut ::core::ffi::c_char,
>;
pub type walrcv_get_backend_pid_fn =
    ::core::option::Option<unsafe extern "C-unwind" fn(conn: *mut WalReceiverConn) -> pid_t>;
pub type walrcv_exec_fn = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        conn: *mut WalReceiverConn,
        query: *const ::core::ffi::c_char,
        nRetTypes: ::core::ffi::c_int,
        retTypes: *const Oid,
    ) -> *mut WalRcvExecResult,
>;
pub type walrcv_disconnect_fn =
    ::core::option::Option<unsafe extern "C-unwind" fn(conn: *mut WalReceiverConn)>;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct WalReceiverFunctionsType {
    pub walrcv_connect: walrcv_connect_fn,
    pub walrcv_check_conninfo: walrcv_check_conninfo_fn,
    pub walrcv_get_conninfo: walrcv_get_conninfo_fn,
    pub walrcv_get_senderinfo: walrcv_get_senderinfo_fn,
    pub walrcv_identify_system: walrcv_identify_system_fn,
    pub walrcv_server_version: walrcv_server_version_fn,
    pub walrcv_readtimelinehistoryfile: walrcv_readtimelinehistoryfile_fn,
    pub walrcv_startstreaming: walrcv_startstreaming_fn,
    pub walrcv_endstreaming: walrcv_endstreaming_fn,
    pub walrcv_receive: walrcv_receive_fn,
    pub walrcv_send: walrcv_send_fn,
    pub walrcv_create_slot: walrcv_create_slot_fn,
    pub walrcv_get_backend_pid: walrcv_get_backend_pid_fn,
    pub walrcv_exec: walrcv_exec_fn,
    pub walrcv_disconnect: walrcv_disconnect_fn,
}
pub mod ReplicationSlotPersistency {
    pub type Type = ::core::ffi::c_uint;
    pub const RS_PERSISTENT: Type = 0;
    pub const RS_EPHEMERAL: Type = 1;
    pub const RS_TEMPORARY: Type = 2;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ReplicationSlotPersistentData {
    pub name: NameData,
    pub database: Oid,
    pub persistency: ReplicationSlotPersistency::Type,
    pub xmin: TransactionId,
    pub catalog_xmin: TransactionId,
    pub restart_lsn: XLogRecPtr,
    pub invalidated_at: XLogRecPtr,
    pub confirmed_flush: XLogRecPtr,
    pub two_phase_at: XLogRecPtr,
    pub two_phase: bool,
    pub plugin: NameData,
}
impl Default for ReplicationSlotPersistentData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ReplicationSlot {
    pub mutex: slock_t,
    pub in_use: bool,
    pub active_pid: pid_t,
    pub just_dirtied: bool,
    pub dirty: bool,
    pub effective_xmin: TransactionId,
    pub effective_catalog_xmin: TransactionId,
    pub data: ReplicationSlotPersistentData,
    pub io_in_progress_lock: LWLock,
    pub active_cv: ConditionVariable,
    pub candidate_catalog_xmin: TransactionId,
    pub candidate_xmin_lsn: XLogRecPtr,
    pub candidate_restart_valid: XLogRecPtr,
    pub candidate_restart_lsn: XLogRecPtr,
}
impl Default for ReplicationSlot {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ReplicationSlotCtlData {
    pub replication_slots: [ReplicationSlot; 1usize],
}
impl Default for ReplicationSlotCtlData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type LogicalOutputPluginWriterWrite = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        lr: *mut LogicalDecodingContext,
        Ptr: XLogRecPtr,
        xid: TransactionId,
        last_write: bool,
    ),
>;
pub type LogicalOutputPluginWriterPrepareWrite = LogicalOutputPluginWriterWrite;
pub type LogicalOutputPluginWriterUpdateProgress = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        lr: *mut LogicalDecodingContext,
        Ptr: XLogRecPtr,
        xid: TransactionId,
        skipped_xact: bool,
    ),
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LogicalDecodingContext {
    pub context: MemoryContext,
    pub slot: *mut ReplicationSlot,
    pub reader: *mut XLogReaderState,
    pub reorder: *mut ReorderBuffer,
    pub snapshot_builder: *mut SnapBuild,
    pub fast_forward: bool,
    pub callbacks: OutputPluginCallbacks,
    pub options: OutputPluginOptions,
    pub output_plugin_options: *mut List,
    pub prepare_write: LogicalOutputPluginWriterPrepareWrite,
    pub write: LogicalOutputPluginWriterWrite,
    pub update_progress: LogicalOutputPluginWriterUpdateProgress,
    pub out: StringInfo,
    pub output_plugin_private: *mut ::core::ffi::c_void,
    pub output_writer_private: *mut ::core::ffi::c_void,
    pub streaming: bool,
    pub twophase: bool,
    pub twophase_opt_given: bool,
    pub accept_writes: bool,
    pub prepared_write: bool,
    pub write_location: XLogRecPtr,
    pub write_xid: TransactionId,
    pub end_xact: bool,
    pub in_create: bool,
}
impl Default for LogicalDecodingContext {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RowSecurityPolicy {
    pub policy_name: *mut ::core::ffi::c_char,
    pub polcmd: ::core::ffi::c_char,
    pub roles: *mut ArrayType,
    pub permissive: bool,
    pub qual: *mut Expr,
    pub with_check_qual: *mut Expr,
    pub hassublinks: bool,
}
impl Default for RowSecurityPolicy {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RowSecurityDesc {
    pub rscxt: MemoryContext,
    pub policies: *mut List,
}
impl Default for RowSecurityDesc {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type row_security_policy_hook_type = ::core::option::Option<
    unsafe extern "C-unwind" fn(cmdtype: CmdType::Type, relation: Relation) -> *mut List,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MVNDistinctItem {
    pub ndistinct: f64,
    pub nattributes: ::core::ffi::c_int,
    pub attributes: *mut AttrNumber,
}
impl Default for MVNDistinctItem {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct MVNDistinct {
    pub magic: uint32,
    pub type_: uint32,
    pub nitems: uint32,
    pub items: __IncompleteArrayField<MVNDistinctItem>,
}
impl Default for MVNDistinct {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct MVDependency {
    pub degree: f64,
    pub nattributes: AttrNumber,
    pub attributes: __IncompleteArrayField<AttrNumber>,
}
#[repr(C)]
#[derive(Debug)]
pub struct MVDependencies {
    pub magic: uint32,
    pub type_: uint32,
    pub ndeps: uint32,
    pub deps: __IncompleteArrayField<*mut MVDependency>,
}
impl Default for MVDependencies {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MCVItem {
    pub frequency: f64,
    pub base_frequency: f64,
    pub isnull: *mut bool,
    pub values: *mut Datum,
}
impl Default for MCVItem {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct MCVList {
    pub magic: uint32,
    pub type_: uint32,
    pub nitems: uint32,
    pub ndimensions: AttrNumber,
    pub types: [Oid; 8usize],
    pub items: __IncompleteArrayField<MCVItem>,
}
impl Default for MCVList {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct buftag {
    pub rnode: RelFileNode,
    pub forkNum: ForkNumber::Type,
    pub blockNum: BlockNumber,
}
impl Default for buftag {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type BufferTag = buftag;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BufferDesc {
    pub tag: BufferTag,
    pub buf_id: ::core::ffi::c_int,
    pub state: pg_atomic_uint32,
    pub wait_backend_pgprocno: ::core::ffi::c_int,
    pub freeNext: ::core::ffi::c_int,
    pub content_lock: LWLock,
}
impl Default for BufferDesc {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union BufferDescPadded {
    pub bufferdesc: BufferDesc,
    pub pad: [::core::ffi::c_char; 64usize],
}
impl Default for BufferDescPadded {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PendingWriteback {
    pub tag: BufferTag,
}
impl Default for PendingWriteback {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WritebackContext {
    pub max_pending: *mut ::core::ffi::c_int,
    pub nr_pending: ::core::ffi::c_int,
    pub pending_writebacks: [PendingWriteback; 256usize],
}
impl Default for WritebackContext {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CkptSortItem {
    pub tsId: Oid,
    pub relNode: Oid,
    pub forkNum: ForkNumber::Type,
    pub blockNum: BlockNumber,
    pub buf_id: ::core::ffi::c_int,
}
impl Default for CkptSortItem {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BufFile {
    _unused: [u8; 0],
}
pub type pg_on_exit_callback =
    ::core::option::Option<unsafe extern "C-unwind" fn(code: ::core::ffi::c_int, arg: Datum)>;
pub type shmem_startup_hook_type = ::core::option::Option<unsafe extern "C-unwind" fn()>;
pub mod XLTW_Oper {
    pub type Type = ::core::ffi::c_uint;
    pub const XLTW_None: Type = 0;
    pub const XLTW_Update: Type = 1;
    pub const XLTW_Delete: Type = 2;
    pub const XLTW_Lock: Type = 3;
    pub const XLTW_LockUpdated: Type = 4;
    pub const XLTW_InsertIndex: Type = 5;
    pub const XLTW_InsertIndexUnique: Type = 6;
    pub const XLTW_FetchUpdated: Type = 7;
    pub const XLTW_RecheckExclusionConstr: Type = 8;
}
pub mod ProcSignalReason {
    pub type Type = ::core::ffi::c_uint;
    pub const PROCSIG_CATCHUP_INTERRUPT: Type = 0;
    pub const PROCSIG_NOTIFY_INTERRUPT: Type = 1;
    pub const PROCSIG_PARALLEL_MESSAGE: Type = 2;
    pub const PROCSIG_WALSND_INIT_STOPPING: Type = 3;
    pub const PROCSIG_BARRIER: Type = 4;
    pub const PROCSIG_LOG_MEMORY_CONTEXT: Type = 5;
    pub const PROCSIG_RECOVERY_CONFLICT_DATABASE: Type = 6;
    pub const PROCSIG_RECOVERY_CONFLICT_TABLESPACE: Type = 7;
    pub const PROCSIG_RECOVERY_CONFLICT_LOCK: Type = 8;
    pub const PROCSIG_RECOVERY_CONFLICT_SNAPSHOT: Type = 9;
    pub const PROCSIG_RECOVERY_CONFLICT_BUFFERPIN: Type = 10;
    pub const PROCSIG_RECOVERY_CONFLICT_STARTUP_DEADLOCK: Type = 11;
    pub const NUM_PROCSIGNALS: Type = 12;
}
pub mod ProcSignalBarrierType {
    pub type Type = ::core::ffi::c_uint;
    pub const PROCSIGNAL_BARRIER_SMGRRELEASE: Type = 0;
}
#[repr(C)]
#[derive(Debug)]
pub struct xl_standby_locks {
    pub nlocks: ::core::ffi::c_int,
    pub locks: __IncompleteArrayField<xl_standby_lock>,
}
impl Default for xl_standby_locks {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct xl_running_xacts {
    pub xcnt: ::core::ffi::c_int,
    pub subxcnt: ::core::ffi::c_int,
    pub subxid_overflow: bool,
    pub nextXid: TransactionId,
    pub oldestRunningXid: TransactionId,
    pub latestCompletedXid: TransactionId,
    pub xids: __IncompleteArrayField<TransactionId>,
}
impl Default for xl_running_xacts {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
pub struct xl_invalidations {
    pub dbId: Oid,
    pub tsId: Oid,
    pub relcacheInitFileInval: bool,
    pub nmsgs: ::core::ffi::c_int,
    pub msgs: __IncompleteArrayField<SharedInvalidationMessage>,
}
impl Default for xl_invalidations {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod subxids_array_status {
    pub type Type = ::core::ffi::c_uint;
    pub const SUBXIDS_IN_ARRAY: Type = 0;
    pub const SUBXIDS_MISSING: Type = 1;
    pub const SUBXIDS_IN_SUBTRANS: Type = 2;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RunningTransactionsData {
    pub xcnt: ::core::ffi::c_int,
    pub subxcnt: ::core::ffi::c_int,
    pub subxid_status: subxids_array_status::Type,
    pub nextXid: TransactionId,
    pub oldestRunningXid: TransactionId,
    pub latestCompletedXid: TransactionId,
    pub xids: *mut TransactionId,
}
impl Default for RunningTransactionsData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type RunningTransactions = *mut RunningTransactionsData;
pub mod LogStmtLevel {
    pub type Type = ::core::ffi::c_uint;
    pub const LOGSTMT_NONE: Type = 0;
    pub const LOGSTMT_DDL: Type = 1;
    pub const LOGSTMT_MOD: Type = 2;
    pub const LOGSTMT_ALL: Type = 3;
}
pub mod ProcessUtilityContext {
    pub type Type = ::core::ffi::c_uint;
    pub const PROCESS_UTILITY_TOPLEVEL: Type = 0;
    pub const PROCESS_UTILITY_QUERY: Type = 1;
    pub const PROCESS_UTILITY_QUERY_NONATOMIC: Type = 2;
    pub const PROCESS_UTILITY_SUBCOMMAND: Type = 3;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterTableUtilityContext {
    pub pstmt: *mut PlannedStmt,
    pub queryString: *const ::core::ffi::c_char,
    pub relid: Oid,
    pub params: ParamListInfo,
    pub queryEnv: *mut QueryEnvironment,
}
impl Default for AlterTableUtilityContext {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type ProcessUtility_hook_type = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        pstmt: *mut PlannedStmt,
        queryString: *const ::core::ffi::c_char,
        readOnlyTree: bool,
        context: ProcessUtilityContext::Type,
        params: ParamListInfo,
        queryEnv: *mut QueryEnvironment,
        dest: *mut DestReceiver,
        qc: *mut QueryCompletion,
    ),
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TSAnyCacheEntry {
    pub objId: Oid,
    pub isvalid: bool,
}
impl Default for TSAnyCacheEntry {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TSParserCacheEntry {
    pub prsId: Oid,
    pub isvalid: bool,
    pub startOid: Oid,
    pub tokenOid: Oid,
    pub endOid: Oid,
    pub headlineOid: Oid,
    pub lextypeOid: Oid,
    pub prsstart: FmgrInfo,
    pub prstoken: FmgrInfo,
    pub prsend: FmgrInfo,
    pub prsheadline: FmgrInfo,
}
impl Default for TSParserCacheEntry {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TSDictionaryCacheEntry {
    pub dictId: Oid,
    pub isvalid: bool,
    pub lexizeOid: Oid,
    pub lexize: FmgrInfo,
    pub dictCtx: MemoryContext,
    pub dictData: *mut ::core::ffi::c_void,
}
impl Default for TSDictionaryCacheEntry {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ListDictionary {
    pub len: ::core::ffi::c_int,
    pub dictIds: *mut Oid,
}
impl Default for ListDictionary {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TSConfigCacheEntry {
    pub cfgId: Oid,
    pub isvalid: bool,
    pub prsId: Oid,
    pub lenmap: ::core::ffi::c_int,
    pub map: *mut ListDictionary,
}
impl Default for TSConfigCacheEntry {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct WordEntry {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
impl WordEntry {
    #[inline]
    pub fn haspos(&self) -> uint32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_haspos(&mut self, val: uint32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn haspos_raw(this: *const Self) -> uint32 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_haspos_raw(this: *mut Self, val: uint32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn len(&self) -> uint32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(1usize, 11u8) as u32) }
    }
    #[inline]
    pub fn set_len(&mut self, val: uint32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(1usize, 11u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn len_raw(this: *const Self) -> uint32 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                1usize,
                11u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_len_raw(this: *mut Self, val: uint32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                1usize,
                11u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn pos(&self) -> uint32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(12usize, 20u8) as u32) }
    }
    #[inline]
    pub fn set_pos(&mut self, val: uint32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(12usize, 20u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn pos_raw(this: *const Self) -> uint32 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                12usize,
                20u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_pos_raw(this: *mut Self, val: uint32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                12usize,
                20u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        haspos: uint32,
        len: uint32,
        pos: uint32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let haspos: u32 = unsafe { ::core::mem::transmute(haspos) };
            haspos as u64
        });
        __bindgen_bitfield_unit.set(1usize, 11u8, {
            let len: u32 = unsafe { ::core::mem::transmute(len) };
            len as u64
        });
        __bindgen_bitfield_unit.set(12usize, 20u8, {
            let pos: u32 = unsafe { ::core::mem::transmute(pos) };
            pos as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type WordEntryPos = uint16;
#[repr(C)]
#[derive(Debug, Default)]
pub struct WordEntryPosVector {
    pub npos: uint16,
    pub pos: __IncompleteArrayField<WordEntryPos>,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct WordEntryPosVector1 {
    pub npos: uint16,
    pub pos: [WordEntryPos; 1usize],
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct TSVectorData {
    pub vl_len_: int32,
    pub size: int32,
    pub entries: __IncompleteArrayField<WordEntry>,
}
pub type TSVector = *mut TSVectorData;
pub type QueryItemType = int8;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct QueryOperand {
    pub type_: QueryItemType,
    pub weight: uint8,
    pub prefix: bool,
    pub valcrc: int32,
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
impl QueryOperand {
    #[inline]
    pub fn length(&self) -> uint32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 12u8) as u32) }
    }
    #[inline]
    pub fn set_length(&mut self, val: uint32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 12u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn length_raw(this: *const Self) -> uint32 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                12u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_length_raw(this: *mut Self, val: uint32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                12u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn distance(&self) -> uint32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(12usize, 20u8) as u32) }
    }
    #[inline]
    pub fn set_distance(&mut self, val: uint32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(12usize, 20u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn distance_raw(this: *const Self) -> uint32 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                12usize,
                20u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_distance_raw(this: *mut Self, val: uint32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                12usize,
                20u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(length: uint32, distance: uint32) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 12u8, {
            let length: u32 = unsafe { ::core::mem::transmute(length) };
            length as u64
        });
        __bindgen_bitfield_unit.set(12usize, 20u8, {
            let distance: u32 = unsafe { ::core::mem::transmute(distance) };
            distance as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct QueryOperator {
    pub type_: QueryItemType,
    pub oper: int8,
    pub distance: int16,
    pub left: uint32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union QueryItem {
    pub type_: QueryItemType,
    pub qoperator: QueryOperator,
    pub qoperand: QueryOperand,
}
impl Default for QueryItem {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct TSQueryData {
    pub vl_len_: int32,
    pub size: int32,
    pub data: __IncompleteArrayField<::core::ffi::c_char>,
}
pub type TSQuery = *mut TSQueryData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LexDescr {
    pub lexid: ::core::ffi::c_int,
    pub alias: *mut ::core::ffi::c_char,
    pub descr: *mut ::core::ffi::c_char,
}
impl Default for LexDescr {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HeadlineWordEntry {
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub pos: WordEntryPos,
    pub word: *mut ::core::ffi::c_char,
    pub item: *mut QueryOperand,
}
impl Default for HeadlineWordEntry {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl HeadlineWordEntry {
    #[inline]
    pub fn selected(&self) -> uint32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_selected(&mut self, val: uint32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn selected_raw(this: *const Self) -> uint32 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_selected_raw(this: *mut Self, val: uint32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn in_(&self) -> uint32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_in(&mut self, val: uint32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn in__raw(this: *const Self) -> uint32 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                1usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_in_raw(this: *mut Self, val: uint32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                1usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn replace(&self) -> uint32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_replace(&mut self, val: uint32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn replace_raw(this: *const Self) -> uint32 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                2usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_replace_raw(this: *mut Self, val: uint32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                2usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn repeated(&self) -> uint32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_repeated(&mut self, val: uint32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn repeated_raw(this: *const Self) -> uint32 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                3usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_repeated_raw(this: *mut Self, val: uint32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                3usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn skip(&self) -> uint32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_skip(&mut self, val: uint32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn skip_raw(this: *const Self) -> uint32 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                4usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_skip_raw(this: *mut Self, val: uint32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                4usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn unused(&self) -> uint32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(5usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_unused(&mut self, val: uint32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(5usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn unused_raw(this: *const Self) -> uint32 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                5usize,
                3u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_unused_raw(this: *mut Self, val: uint32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                5usize,
                3u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn type_(&self) -> uint32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(8usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_type(&mut self, val: uint32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(8usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn type__raw(this: *const Self) -> uint32 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                8usize,
                8u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_type_raw(this: *mut Self, val: uint32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                8usize,
                8u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn len(&self) -> uint32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(16usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_len(&mut self, val: uint32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(16usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn len_raw(this: *const Self) -> uint32 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                16usize,
                16u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_len_raw(this: *mut Self, val: uint32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                16usize,
                16u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        selected: uint32,
        in_: uint32,
        replace: uint32,
        repeated: uint32,
        skip: uint32,
        unused: uint32,
        type_: uint32,
        len: uint32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let selected: u32 = unsafe { ::core::mem::transmute(selected) };
            selected as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let in_: u32 = unsafe { ::core::mem::transmute(in_) };
            in_ as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let replace: u32 = unsafe { ::core::mem::transmute(replace) };
            replace as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let repeated: u32 = unsafe { ::core::mem::transmute(repeated) };
            repeated as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let skip: u32 = unsafe { ::core::mem::transmute(skip) };
            skip as u64
        });
        __bindgen_bitfield_unit.set(5usize, 3u8, {
            let unused: u32 = unsafe { ::core::mem::transmute(unused) };
            unused as u64
        });
        __bindgen_bitfield_unit.set(8usize, 8u8, {
            let type_: u32 = unsafe { ::core::mem::transmute(type_) };
            type_ as u64
        });
        __bindgen_bitfield_unit.set(16usize, 16u8, {
            let len: u32 = unsafe { ::core::mem::transmute(len) };
            len as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HeadlineParsedText {
    pub words: *mut HeadlineWordEntry,
    pub lenwords: int32,
    pub curwords: int32,
    pub vectorpos: int32,
    pub startsel: *mut ::core::ffi::c_char,
    pub stopsel: *mut ::core::ffi::c_char,
    pub fragdelim: *mut ::core::ffi::c_char,
    pub startsellen: int16,
    pub stopsellen: int16,
    pub fragdelimlen: int16,
}
impl Default for HeadlineParsedText {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StopList {
    pub len: ::core::ffi::c_int,
    pub stop: *mut *mut ::core::ffi::c_char,
}
impl Default for StopList {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TSLexeme {
    pub nvariant: uint16,
    pub flags: uint16,
    pub lexeme: *mut ::core::ffi::c_char,
}
impl Default for TSLexeme {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DictSubState {
    pub isend: bool,
    pub getnext: bool,
    pub private_state: *mut ::core::ffi::c_void,
}
impl Default for DictSubState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TSVectorParseStateData {
    _unused: [u8; 0],
}
pub type TSVectorParseState = *mut TSVectorParseStateData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TSQueryParserStateData {
    _unused: [u8; 0],
}
pub type TSQueryParserState = *mut TSQueryParserStateData;
pub type PushFunction = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        opaque: Datum,
        state: TSQueryParserState,
        token: *mut ::core::ffi::c_char,
        tokenlen: ::core::ffi::c_int,
        tokenweights: int16,
        prefix: bool,
    ),
>;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct ParsedWord {
    pub len: uint16,
    pub nvariant: uint16,
    pub pos: ParsedWord__bindgen_ty_1,
    pub flags: uint16,
    pub word: *mut ::core::ffi::c_char,
    pub alen: uint32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union ParsedWord__bindgen_ty_1 {
    pub pos: uint16,
    pub apos: *mut uint16,
}
impl Default for ParsedWord__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for ParsedWord {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ParsedText {
    pub words: *mut ParsedWord,
    pub lenwords: int32,
    pub curwords: int32,
    pub pos: int32,
}
impl Default for ParsedText {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub mod TSTernaryValue {
    pub type Type = ::core::ffi::c_uint;
    pub const TS_NO: Type = 0;
    pub const TS_YES: Type = 1;
    pub const TS_MAYBE: Type = 2;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExecPhraseData {
    pub npos: ::core::ffi::c_int,
    pub allocated: bool,
    pub negate: bool,
    pub pos: *mut WordEntryPos,
    pub width: ::core::ffi::c_int,
}
impl Default for ExecPhraseData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type TSExecuteCallback = ::core::option::Option<
    unsafe extern "C-unwind" fn(
        arg: *mut ::core::ffi::c_void,
        val: *mut QueryOperand,
        data: *mut ExecPhraseData,
    ) -> TSTernaryValue::Type,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct QTNode {
    pub valnode: *mut QueryItem,
    pub flags: uint32,
    pub nchild: int32,
    pub word: *mut ::core::ffi::c_char,
    pub sign: uint32,
    pub child: *mut *mut QTNode,
}
impl Default for QTNode {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type TSQuerySign = uint64;
pub type DateADT = int32;
pub type TimeADT = int64;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct TimeTzADT {
    pub time: TimeADT,
    pub zone: int32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tzEntry {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct datetkn {
    pub token: [::core::ffi::c_char; 11usize],
    pub type_: ::core::ffi::c_char,
    pub value: int32,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct TimeZoneAbbrevTable {
    pub tblsize: Size,
    pub numabbrevs: ::core::ffi::c_int,
    pub abbrevs: __IncompleteArrayField<datetkn>,
}
#[repr(C)]
#[derive(Debug)]
pub struct DynamicZoneAbbrev {
    pub tz: *mut pg_tz,
    pub zone: __IncompleteArrayField<::core::ffi::c_char>,
}
impl Default for DynamicZoneAbbrev {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct Point {
    pub x: float8,
    pub y: float8,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct LSEG {
    pub p: [Point; 2usize],
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct PATH {
    pub vl_len_: int32,
    pub npts: int32,
    pub closed: int32,
    pub dummy: int32,
    pub p: __IncompleteArrayField<Point>,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct LINE {
    pub A: float8,
    pub B: float8,
    pub C: float8,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct BOX {
    pub high: Point,
    pub low: Point,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct POLYGON {
    pub vl_len_: int32,
    pub npts: int32,
    pub boundbox: BOX,
    pub p: __IncompleteArrayField<Point>,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct CIRCLE {
    pub center: Point,
    pub radius: float8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NumericData {
    _unused: [u8; 0],
}
pub type Numeric = *mut NumericData;
pub mod JsonbIteratorToken {
    pub type Type = ::core::ffi::c_uint;
    pub const WJB_DONE: Type = 0;
    pub const WJB_KEY: Type = 1;
    pub const WJB_VALUE: Type = 2;
    pub const WJB_ELEM: Type = 3;
    pub const WJB_BEGIN_ARRAY: Type = 4;
    pub const WJB_END_ARRAY: Type = 5;
    pub const WJB_BEGIN_OBJECT: Type = 6;
    pub const WJB_END_OBJECT: Type = 7;
}
pub type JEntry = uint32;
#[repr(C)]
#[derive(Debug, Default)]
pub struct JsonbContainer {
    pub header: uint32,
    pub children: __IncompleteArrayField<JEntry>,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct Jsonb {
    pub vl_len_: int32,
    pub root: JsonbContainer,
}
pub mod jbvType {
    pub type Type = ::core::ffi::c_uint;
    pub const jbvNull: Type = 0;
    pub const jbvString: Type = 1;
    pub const jbvNumeric: Type = 2;
    pub const jbvBool: Type = 3;
    pub const jbvArray: Type = 16;
    pub const jbvObject: Type = 17;
    pub const jbvBinary: Type = 18;
    pub const jbvDatetime: Type = 32;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct JsonbValue {
    pub type_: jbvType::Type,
    pub val: JsonbValue__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union JsonbValue__bindgen_ty_1 {
    pub numeric: Numeric,
    pub boolean: bool,
    pub string: JsonbValue__bindgen_ty_1__bindgen_ty_1,
    pub array: JsonbValue__bindgen_ty_1__bindgen_ty_2,
    pub object: JsonbValue__bindgen_ty_1__bindgen_ty_3,
    pub binary: JsonbValue__bindgen_ty_1__bindgen_ty_4,
    pub datetime: JsonbValue__bindgen_ty_1__bindgen_ty_5,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct JsonbValue__bindgen_ty_1__bindgen_ty_1 {
    pub len: ::core::ffi::c_int,
    pub val: *mut ::core::ffi::c_char,
}
impl Default for JsonbValue__bindgen_ty_1__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct JsonbValue__bindgen_ty_1__bindgen_ty_2 {
    pub nElems: ::core::ffi::c_int,
    pub elems: *mut JsonbValue,
    pub rawScalar: bool,
}
impl Default for JsonbValue__bindgen_ty_1__bindgen_ty_2 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug,