using CleanCode.Settings;
using JetBrains.Application.Settings;
using JetBrains.ReSharper.Daemon.Stages.Dispatcher;
using JetBrains.ReSharper.Feature.Services.Daemon;
using JetBrains.ReSharper.Psi.CSharp.Tree;
using JetBrains.ReSharper.Psi.Tree;

namespace CleanCode.Features.MethodTooLong
{
    [ElementProblemAnalyzer(typeof(IMethodDeclaration), HighlightingTypes = new []
    {
        typeof(MethodTooLongHighlighting)
    })]
    public class MethodTooLongCheck : ElementProblemAnalyzer<IMethodDeclaration>
    {
        protected override void Run(IMethodDeclaration element, ElementProblemAnalyzerData data, IHighlightingConsumer consumer)
        {
            var maxStatements = data.SettingsStore.GetValue((CleanCodeSettings s) => s.MaximumMethodStatements);
            var maxDeclarations = data.SettingsStore.GetValue((CleanCodeSettings s) => s.MaximumDeclarationsInMethod);

            var statementCount = element.CountChildren<IStatement>();
            if (statementCount <= maxStatements)
            {
                var declarationCount = element.CountChildren<IDeclaration>();
                if (declarationCount <= maxDeclarations)
                    return;
            }

            var highlighting = new MethodTooLongHighlighting(element.GetNameDocumentRange());
            consumer.AddHighlighting(highlighting);
        }
    }
}