// Code generated by swaggo/swag. DO NOT EDIT.

package docs

import "github.com/swaggo/swag"

const docTemplate = `{
    "schemes": {{ marshal .Schemes }},
    "swagger": "2.0",
    "info": {
        "description": "{{escape .Description}}",
        "title": "{{.Title}}",
        "termsOfService": "http://swagger.io/terms/",
        "contact": {},
        "license": {
            "name": "Apache 2.0",
            "url": "http://www.apache.org/licenses/LICENSE-2.0.html"
        },
        "version": "{{.Version}}"
    },
    "host": "{{.Host}}",
    "basePath": "{{.BasePath}}",
    "paths": {
        "/apps/:key": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "通过 key 获取应用信息",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "App"
                ],
                "summary": "Search app by key",
                "parameters": [
                    {
                        "type": "string",
                        "description": "app key",
                        "name": "key",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/response.AppDTO"
                        }
                    }
                }
            }
        },
        "/apps/checkupdate": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取应用更新版本",
                "tags": [
                    "App"
                ],
                "summary": "Get app list update",
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/apps/detail/:appId/:version/:type": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "通过 appid 获取应用详情",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "App"
                ],
                "summary": "Search app detail by appid",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "app id",
                        "name": "appId",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "app 版本",
                        "name": "version",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "app 类型",
                        "name": "version",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/response.AppDetailDTO"
                        }
                    }
                }
            }
        },
        "/apps/details/:id": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "通过 id 获取应用详情",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "App"
                ],
                "summary": "Get app detail by id",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "id",
                        "name": "appId",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/response.AppDetailDTO"
                        }
                    }
                }
            }
        },
        "/apps/ingored": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取忽略的应用版本",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "App"
                ],
                "summary": "Get Ignore App",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/response.IgnoredApp"
                        }
                    }
                }
            }
        },
        "/apps/install": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "安装应用",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "App"
                ],
                "summary": "Install app",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.AppInstallCreate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/model.AppInstall"
                        }
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [
                        {
                            "db": "app_installs",
                            "input_column": "name",
                            "input_value": "name",
                            "isList": false,
                            "output_column": "app_id",
                            "output_value": "appId"
                        },
                        {
                            "db": "apps",
                            "info": "appId",
                            "isList": false,
                            "output_column": "key",
                            "output_value": "appKey"
                        }
                    ],
                    "bodyKeys": [
                        "name"
                    ],
                    "formatEN": "Install app [appKey]-[name]",
                    "formatZH": "安装应用 [appKey]-[name]",
                    "paramKeys": []
                }
            }
        },
        "/apps/installed/:appInstallId/versions": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "通过 install id 获取应用更新版本",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "App"
                ],
                "summary": "Search app update version by install id",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "request",
                        "name": "appInstallId",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/dto.AppVersion"
                            }
                        }
                    }
                }
            }
        },
        "/apps/installed/check": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "检查应用安装情况",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "App"
                ],
                "summary": "Check app installed",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.AppInstalledInfo"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/response.AppInstalledCheck"
                        }
                    }
                }
            }
        },
        "/apps/installed/conf": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "通过 key 获取应用默认配置",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "App"
                ],
                "summary": "Search default config by key",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.OperationWithNameAndType"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            }
        },
        "/apps/installed/conninfo/:key": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取应用连接信息",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "App"
                ],
                "summary": "Search app password by key",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.OperationWithNameAndType"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            }
        },
        "/apps/installed/delete/check/:appInstallId": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "删除前检查",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "App"
                ],
                "summary": "Check before delete",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "App install id",
                        "name": "appInstallId",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/dto.AppResource"
                            }
                        }
                    }
                }
            }
        },
        "/apps/installed/ignore": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "忽略应用升级版本",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "App"
                ],
                "summary": "ignore App Update",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.AppInstalledIgnoreUpgrade"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "installId"
                    ],
                    "formatEN": "Application param update [installId]",
                    "formatZH": "忽略应用 [installId] 版本升级",
                    "paramKeys": []
                }
            }
        },
        "/apps/installed/list": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取已安装应用列表",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "App"
                ],
                "summary": "List app installed",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/dto.AppInstallInfo"
                            }
                        }
                    }
                }
            }
        },
        "/apps/installed/loadport": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取应用端口",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "App"
                ],
                "summary": "Search app port by key",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.OperationWithNameAndType"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "integer"
                        }
                    }
                }
            }
        },
        "/apps/installed/op": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "操作已安装应用",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "App"
                ],
                "summary": "Operate installed app",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.AppInstalledOperate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [
                        {
                            "db": "app_installs",
                            "input_column": "id",
                            "input_value": "installId",
                            "isList": false,
                            "output_column": "app_id",
                            "output_value": "appId"
                        },
                        {
                            "db": "app_installs",
                            "input_column": "id",
                            "input_value": "installId",
                            "isList": false,
                            "output_column": "name",
                            "output_value": "appName"
                        },
                        {
                            "db": "apps",
                            "input_column": "id",
                            "input_value": "appId",
                            "isList": false,
                            "output_column": "key",
                            "output_value": "appKey"
                        }
                    ],
                    "bodyKeys": [
                        "installId",
                        "operate"
                    ],
                    "formatEN": "[operate] App [appKey][appName]",
                    "formatZH": "[operate] 应用 [appKey][appName]",
                    "paramKeys": []
                }
            }
        },
        "/apps/installed/params/:appInstallId": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "通过 install id 获取应用参数",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "App"
                ],
                "summary": "Search params by appInstallId",
                "parameters": [
                    {
                        "type": "string",
                        "description": "request",
                        "name": "appInstallId",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/response.AppParam"
                        }
                    }
                }
            }
        },
        "/apps/installed/params/update": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "修改应用参数",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "App"
                ],
                "summary": "Change app params",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.AppInstalledUpdate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "installId"
                    ],
                    "formatEN": "Application param update [installId]",
                    "formatZH": "应用参数修改 [installId]",
                    "paramKeys": []
                }
            }
        },
        "/apps/installed/port/change": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "修改应用端口",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "App"
                ],
                "summary": "Change app port",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.PortUpdate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "key",
                        "name",
                        "port"
                    ],
                    "formatEN": "Application port update [key]-[name] =\u003e [port]",
                    "formatZH": "应用端口修改 [key]-[name] =\u003e [port]",
                    "paramKeys": []
                }
            }
        },
        "/apps/installed/search": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "分页获取已安装应用列表",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "App"
                ],
                "summary": "Page app installed",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.AppInstalledSearch"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/apps/installed/sync": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "同步已安装应用列表",
                "tags": [
                    "App"
                ],
                "summary": "Sync app installed",
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [],
                    "formatEN": "Sync the list of installed apps",
                    "formatZH": "同步已安装应用列表",
                    "paramKeys": []
                }
            }
        },
        "/apps/search": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取应用列表",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "App"
                ],
                "summary": "List apps",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.AppSearch"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/apps/services/:key": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "通过 key 获取应用 service",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "App"
                ],
                "summary": "Search app service by key",
                "parameters": [
                    {
                        "type": "string",
                        "description": "request",
                        "name": "key",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/response.AppService"
                            }
                        }
                    }
                }
            }
        },
        "/apps/sync": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "同步应用列表",
                "tags": [
                    "App"
                ],
                "summary": "Sync app list",
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [],
                    "formatEN": "App store synchronization",
                    "formatZH": "应用商店同步",
                    "paramKeys": []
                }
            }
        },
        "/auth/captcha": {
            "get": {
                "description": "加载验证码",
                "tags": [
                    "Auth"
                ],
                "summary": "Load captcha",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/dto.CaptchaResponse"
                        }
                    }
                }
            }
        },
        "/auth/demo": {
            "get": {
                "description": "判断是否为demo环境",
                "tags": [
                    "Auth"
                ],
                "summary": "Check System isDemo",
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/auth/issafety": {
            "get": {
                "description": "获取系统安全登录状态",
                "tags": [
                    "Auth"
                ],
                "summary": "Load safety status",
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/auth/language": {
            "get": {
                "description": "获取系统语言设置",
                "tags": [
                    "Auth"
                ],
                "summary": "Load System Language",
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/auth/login": {
            "post": {
                "description": "用户登录",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Auth"
                ],
                "summary": "User login",
                "parameters": [
                    {
                        "type": "string",
                        "description": "安全入口 base64 加密串",
                        "name": "EntranceCode",
                        "in": "header",
                        "required": true
                    },
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.Login"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/dto.UserLoginInfo"
                        }
                    }
                }
            }
        },
        "/auth/logout": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "用户登出",
                "tags": [
                    "Auth"
                ],
                "summary": "User logout",
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/auth/mfalogin": {
            "post": {
                "description": "用户 mfa 登录",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Auth"
                ],
                "summary": "User login with mfa",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.MFALogin"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/dto.UserLoginInfo"
                        },
                        "headers": {
                            "EntranceCode": {
                                "type": "string",
                                "description": "安全入口"
                            }
                        }
                    }
                }
            }
        },
        "/containers": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "创建容器",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Container"
                ],
                "summary": "Create container",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.ContainerOperate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "name",
                        "image"
                    ],
                    "formatEN": "create container [name][image]",
                    "formatZH": "创建容器 [name][image]",
                    "paramKeys": []
                }
            }
        },
        "/containers/clean/log": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "清理容器日志",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Container"
                ],
                "summary": "Clean container log",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.OperationWithName"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "name"
                    ],
                    "formatEN": "clean container [name] logs",
                    "formatZH": "清理容器 [name] 日志",
                    "paramKeys": []
                }
            }
        },
        "/containers/compose": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "创建容器编排",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Container Compose"
                ],
                "summary": "Create compose",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.ComposeCreate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "name"
                    ],
                    "formatEN": "create compose [name]",
                    "formatZH": "创建 compose [name]",
                    "paramKeys": []
                }
            }
        },
        "/containers/compose/operate": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "容器编排操作",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Container Compose"
                ],
                "summary": "Operate compose",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.ComposeOperation"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "name",
                        "operation"
                    ],
                    "formatEN": "compose [operation] [name]",
                    "formatZH": "compose [operation] [name]",
                    "paramKeys": []
                }
            }
        },
        "/containers/compose/search": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取编排列表分页",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Container Compose"
                ],
                "summary": "Page composes",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.SearchWithPage"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/dto.PageResult"
                        }
                    }
                }
            }
        },
        "/containers/compose/search/log": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "docker-compose 日志",
                "tags": [
                    "Container Compose"
                ],
                "summary": "Container Compose logs",
                "parameters": [
                    {
                        "type": "string",
                        "description": "compose 文件地址",
                        "name": "compose",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "时间筛选",
                        "name": "since",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "是否追踪",
                        "name": "follow",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "显示行号",
                        "name": "tail",
                        "in": "query"
                    }
                ],
                "responses": {}
            }
        },
        "/containers/compose/test": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "测试 compose 是否可用",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Container Compose"
                ],
                "summary": "Test compose",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.ComposeCreate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "name"
                    ],
                    "formatEN": "check compose [name]",
                    "formatZH": "检测 compose [name] 格式",
                    "paramKeys": []
                }
            }
        },
        "/containers/compose/update": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "更新容器编排",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Container Compose"
                ],
                "summary": "Update compose",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.ComposeUpdate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "name"
                    ],
                    "formatEN": "update compose information [name]",
                    "formatZH": "更新 compose [name]",
                    "paramKeys": []
                }
            }
        },
        "/containers/daemonjson": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取 docker 配置信息",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Container Docker"
                ],
                "summary": "Load docker daemon.json",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/dto.DaemonJsonConf"
                        }
                    }
                }
            }
        },
        "/containers/daemonjson/file": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取 docker 配置信息(表单)",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Container Docker"
                ],
                "summary": "Load docker daemon.json",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            }
        },
        "/containers/daemonjson/update": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "修改 docker 日志配置",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Container Docker"
                ],
                "summary": "Update docker daemon.json log option",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.LogOption"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [],
                    "formatEN": "Updated the docker daemon.json log option",
                    "formatZH": "更新 docker daemon.json 日志配置",
                    "paramKeys": []
                }
            }
        },
        "/containers/daemonjson/update/byfile": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "上传替换 docker 配置文件",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Container Docker"
                ],
                "summary": "Update docker daemon.json by upload file",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.DaemonJsonUpdateByFile"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [],
                    "formatEN": "Updated the docker daemon.json configuration",
                    "formatZH": "更新 docker daemon.json 配置",
                    "paramKeys": []
                }
            }
        },
        "/containers/docker/operate": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "Docker 操作",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Container Docker"
                ],
                "summary": "Operate docker",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.DockerOperation"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "operation"
                    ],
                    "formatEN": "[operation] docker service",
                    "formatZH": "docker 服务 [operation]",
                    "paramKeys": []
                }
            }
        },
        "/containers/docker/status": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取 docker 服务状态",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Container Docker"
                ],
                "summary": "Load docker status",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            }
        },
        "/containers/image": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取镜像列表",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Container Image"
                ],
                "summary": "List images",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/dto.Options"
                            }
                        }
                    }
                }
            }
        },
        "/containers/image/build": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "构建镜像",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Container Image"
                ],
                "summary": "Build image",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.ImageBuild"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "string"
                        }
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "name"
                    ],
                    "formatEN": "build image [name]",
                    "formatZH": "构建镜像 [name]",
                    "paramKeys": []
                }
            }
        },
        "/containers/image/load": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "导入镜像",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Container Image"
                ],
                "summary": "Load image",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.ImageLoad"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "path"
                    ],
                    "formatEN": "load image from [path]",
                    "formatZH": "从 [path] 加载镜像",
                    "paramKeys": []
                }
            }
        },
        "/containers/image/pull": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "拉取镜像",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Container Image"
                ],
                "summary": "Pull image",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.ImagePull"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "string"
                        }
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [
                        {
                            "db": "image_repos",
                            "input_column": "id",
                            "input_value": "repoID",
                            "isList": false,
                            "output_column": "name",
                            "output_value": "reponame"
                        }
                    ],
                    "bodyKeys": [
                        "repoID",
                        "imageName"
                    ],
                    "formatEN": "image pull [reponame][imageName]",
                    "formatZH": "镜像拉取 [reponame][imageName]",
                    "paramKeys": []
                }
            }
        },
        "/containers/image/push": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "推送镜像",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Container Image"
                ],
                "summary": "Push image",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.ImagePush"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "string"
                        }
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [
                        {
                            "db": "image_repos",
                            "input_column": "id",
                            "input_value": "repoID",
                            "isList": false,
                            "output_column": "name",
                            "output_value": "reponame"
                        }
                    ],
                    "bodyKeys": [
                        "repoID",
                        "tagName",
                        "name"
                    ],
                    "formatEN": "push [tagName] to [reponame][name]",
                    "formatZH": "[tagName] 推送到 [reponame][name]",
                    "paramKeys": []
                }
            }
        },
        "/containers/image/remove": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "删除镜像",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Container Image"
                ],
                "summary": "Delete image",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.BatchDelete"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "names"
                    ],
                    "formatEN": "remove image [names]",
                    "formatZH": "移除镜像 [names]",
                    "paramKeys": []
                }
            }
        },
        "/containers/image/save": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "导出镜像",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Container Image"
                ],
                "summary": "Save image",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.ImageSave"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "tagName",
                        "path",
                        "name"
                    ],
                    "formatEN": "save [tagName] as [path]/[name]",
                    "formatZH": "保留 [tagName] 为 [path]/[name]",
                    "paramKeys": []
                }
            }
        },
        "/containers/image/search": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取镜像列表分页",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Container Image"
                ],
                "summary": "Page images",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.SearchWithPage"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/dto.PageResult"
                        }
                    }
                }
            }
        },
        "/containers/image/tag": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "Tag 镜像",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Container Image"
                ],
                "summary": "Tag image",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.ImageTag"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [
                        {
                            "db": "image_repos",
                            "input_column": "id",
                            "input_value": "repoID",
                            "isList": false,
                            "output_column": "name",
                            "output_value": "reponame"
                        }
                    ],
                    "bodyKeys": [
                        "repoID",
                        "targetName"
                    ],
                    "formatEN": "tag image [reponame][targetName]",
                    "formatZH": "tag 镜像 [reponame][targetName]",
                    "paramKeys": []
                }
            }
        },
        "/containers/info": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取容器表单信息",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Container"
                ],
                "summary": "Load container info",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.OperationWithName"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/dto.ContainerOperate"
                        }
                    }
                }
            }
        },
        "/containers/inspect": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "容器详情",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Container"
                ],
                "summary": "Container inspect",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.InspectReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            }
        },
        "/containers/limit": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取容器限制",
                "summary": "Load container limits",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/dto.ResourceLimit"
                        }
                    }
                }
            }
        },
        "/containers/list": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取容器名称",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Container"
                ],
                "summary": "List containers",
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/containers/list/stats": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取容器列表资源占用",
                "summary": "Load container stats",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/dto.ContainerListStats"
                            }
                        }
                    }
                }
            }
        },
        "/containers/load/log": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取容器操作日志",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Container"
                ],
                "summary": "Load container log",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.OperationWithNameAndType"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/containers/network": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取容器网络列表",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Container Network"
                ],
                "summary": "List networks",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/dto.Options"
                            }
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "创建容器网络",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Container Network"
                ],
                "summary": "Create network",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.NetworkCreate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "name"
                    ],
                    "formatEN": "create container network [name]",
                    "formatZH": "创建容器网络 name",
                    "paramKeys": []
                }
            }
        },
        "/containers/network/del": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "删除容器网络",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Container Network"
                ],
                "summary": "Delete network",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.BatchDelete"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "names"
                    ],
                    "formatEN": "delete container network [names]",
                    "formatZH": "删除容器网络 [names]",
                    "paramKeys": []
                }
            }
        },
        "/containers/network/search": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取容器网络列表分页",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Container Network"
                ],
                "summary": "Page networks",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.SearchWithPage"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/dto.PageResult"
                        }
                    }
                }
            }
        },
        "/containers/operate": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "容器操作",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Container"
                ],
                "summary": "Operate Container",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.ContainerOperation"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "name",
                        "operation",
                        "newName"
                    ],
                    "formatEN": "container [operation] [name] [newName]",
                    "formatZH": "容器 [name] 执行 [operation] [newName]",
                    "paramKeys": []
                }
            }
        },
        "/containers/prune": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "容器清理",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Container"
                ],
                "summary": "Clean container",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.ContainerPrune"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/dto.ContainerPruneReport"
                        }
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "pruneType"
                    ],
                    "formatEN": "clean container [pruneType]",
                    "formatZH": "清理容器 [pruneType]",
                    "paramKeys": []
                }
            }
        },
        "/containers/repo": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取镜像仓库列表",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Container Image-repo"
                ],
                "summary": "List image repos",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/dto.ImageRepoOption"
                            }
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "创建镜像仓库",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Container Image-repo"
                ],
                "summary": "Create image repo",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.ImageRepoDelete"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "name"
                    ],
                    "formatEN": "create image repo [name]",
                    "formatZH": "创建镜像仓库 [name]",
                    "paramKeys": []
                }
            }
        },
        "/containers/repo/del": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "删除镜像仓库",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Container Image-repo"
                ],
                "summary": "Delete image repo",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.ImageRepoDelete"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [
                        {
                            "db": "image_repos",
                            "input_column": "id",
                            "input_value": "ids",
                            "isList": true,
                            "output_column": "name",
                            "output_value": "names"
                        }
                    ],
                    "bodyKeys": [
                        "ids"
                    ],
                    "formatEN": "delete image repo [names]",
                    "formatZH": "删除镜像仓库 [names]",
                    "paramKeys": []
                }
            }
        },
        "/containers/repo/search": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取镜像仓库列表分页",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Container Image-repo"
                ],
                "summary": "Page image repos",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.SearchWithPage"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/dto.PageResult"
                        }
                    }
                }
            }
        },
        "/containers/repo/status": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取 docker 仓库状态",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Container Image-repo"
                ],
                "summary": "Load repo status",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.OperateByID"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/containers/repo/update": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "更新镜像仓库",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Container Image-repo"
                ],
                "summary": "Update image repo",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.ImageRepoUpdate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [
                        {
                            "db": "image_repos",
                            "input_column": "id",
                            "input_value": "id",
                            "isList": false,
                            "output_column": "name",
                            "output_value": "name"
                        }
                    ],
                    "bodyKeys": [
                        "id"
                    ],
                    "formatEN": "update image repo information [name]",
                    "formatZH": "更新镜像仓库 [name]",
                    "paramKeys": []
                }
            }
        },
        "/containers/search": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取容器列表分页",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Container"
                ],
                "summary": "Page containers",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.PageContainer"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/dto.PageResult"
                        }
                    }
                }
            }
        },
        "/containers/search/log": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "容器日志",
                "tags": [
                    "Container"
                ],
                "summary": "Container logs",
                "parameters": [
                    {
                        "type": "string",
                        "description": "容器名称",
                        "name": "container",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "时间筛选",
                        "name": "since",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "是否追踪",
                        "name": "follow",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "显示行号",
                        "name": "tail",
                        "in": "query"
                    }
                ],
                "responses": {}
            }
        },
        "/containers/stats/:id": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "容器监控信息",
                "tags": [
                    "Container"
                ],
                "summary": "Container stats",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "容器id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/dto.ContainerStats"
                        }
                    }
                }
            }
        },
        "/containers/template": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取容器编排模版列表",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Container Compose-template"
                ],
                "summary": "List compose templates",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/dto.ComposeTemplateInfo"
                            }
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "创建容器编排模版",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Container Compose-template"
                ],
                "summary": "Create compose template",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.ComposeTemplateCreate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "name"
                    ],
                    "formatEN": "create compose template [name]",
                    "formatZH": "创建 compose 模版 [name]",
                    "paramKeys": []
                }
            }
        },
        "/containers/template/del": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "删除容器编排模版",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Container Compose-template"
                ],
                "summary": "Delete compose template",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.BatchDelete"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [
                        {
                            "db": "compose_templates",
                            "input_column": "id",
                            "input_value": "ids",
                            "isList": true,
                            "output_column": "name",
                            "output_value": "names"
                        }
                    ],
                    "bodyKeys": [
                        "ids"
                    ],
                    "formatEN": "delete compose template [names]",
                    "formatZH": "删除 compose 模版 [names]",
                    "paramKeys": []
                }
            }
        },
        "/containers/template/search": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取容器编排模版列表分页",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Container Compose-template"
                ],
                "summary": "Page compose templates",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.SearchWithPage"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/dto.PageResult"
                        }
                    }
                }
            }
        },
        "/containers/template/update": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "更新容器编排模版",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Container Compose-template"
                ],
                "summary": "Update compose template",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.ComposeTemplateUpdate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [
                        {
                            "db": "compose_templates",
                            "input_column": "id",
                            "input_value": "id",
                            "isList": false,
                            "output_column": "name",
                            "output_value": "name"
                        }
                    ],
                    "bodyKeys": [
                        "id"
                    ],
                    "formatEN": "update compose template information [name]",
                    "formatZH": "更新 compose 模版 [name]",
                    "paramKeys": []
                }
            }
        },
        "/containers/update": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "更新容器",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Container"
                ],
                "summary": "Update container",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.ContainerOperate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "name",
                        "image"
                    ],
                    "formatEN": "update container [name][image]",
                    "formatZH": "更新容器 [name][image]",
                    "paramKeys": []
                }
            }
        },
        "/containers/upgrade": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "更新容器镜像",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Container"
                ],
                "summary": "Upgrade container",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.ContainerUpgrade"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "name",
                        "image"
                    ],
                    "formatEN": "upgrade container image [name][image]",
                    "formatZH": "更新容器镜像 [name][image]",
                    "paramKeys": []
                }
            }
        },
        "/containers/volume": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取容器存储卷列表",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Container Volume"
                ],
                "summary": "List volumes",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/dto.Options"
                            }
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "创建容器存储卷",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Container Volume"
                ],
                "summary": "Create volume",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.VolumeCreate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "name"
                    ],
                    "formatEN": "create container volume [name]",
                    "formatZH": "创建容器存储卷 [name]",
                    "paramKeys": []
                }
            }
        },
        "/containers/volume/del": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "删除容器存储卷",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Container Volume"
                ],
                "summary": "Delete volume",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.BatchDelete"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "names"
                    ],
                    "formatEN": "delete container volume [names]",
                    "formatZH": "删除容器存储卷 [names]",
                    "paramKeys": []
                }
            }
        },
        "/containers/volume/search": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取容器存储卷分页",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Container Volume"
                ],
                "summary": "Page volumes",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.SearchWithPage"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/dto.PageResult"
                        }
                    }
                }
            }
        },
        "/cronjob/record/log": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取计划任务记录日志",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Cronjob"
                ],
                "summary": "Load Cronjob record log",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.OperateByID"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/cronjobs": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "创建计划任务",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Cronjob"
                ],
                "summary": "Create cronjob",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.CronjobCreate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "type",
                        "name"
                    ],
                    "formatEN": "create cronjob [type][name]",
                    "formatZH": "创建计划任务 [type][name]",
                    "paramKeys": []
                }
            }
        },
        "/cronjobs/del": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "删除计划任务",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Cronjob"
                ],
                "summary": "Delete cronjob",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.CronjobBatchDelete"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [
                        {
                            "db": "cronjobs",
                            "input_column": "id",
                            "input_value": "ids",
                            "isList": true,
                            "output_column": "name",
                            "output_value": "names"
                        }
                    ],
                    "bodyKeys": [
                        "ids"
                    ],
                    "formatEN": "delete cronjob [names]",
                    "formatZH": "删除计划任务 [names]",
                    "paramKeys": []
                }
            }
        },
        "/cronjobs/download": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "下载计划任务记录",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Cronjob"
                ],
                "summary": "Download cronjob records",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.CronjobDownload"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [
                        {
                            "db": "job_records",
                            "input_column": "id",
                            "input_value": "recordID",
                            "isList": false,
                            "output_column": "file",
                            "output_value": "file"
                        }
                    ],
                    "bodyKeys": [
                        "recordID"
                    ],
                    "formatEN": "download the cronjob record [file]",
                    "formatZH": "下载计划任务记录 [file]",
                    "paramKeys": []
                }
            }
        },
        "/cronjobs/handle": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "手动执行计划任务",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Cronjob"
                ],
                "summary": "Handle cronjob once",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.OperateByID"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [
                        {
                            "db": "cronjobs",
                            "input_column": "id",
                            "input_value": "id",
                            "isList": false,
                            "output_column": "name",
                            "output_value": "name"
                        }
                    ],
                    "bodyKeys": [
                        "id"
                    ],
                    "formatEN": "manually execute the cronjob [name]",
                    "formatZH": "手动执行计划任务 [name]",
                    "paramKeys": []
                }
            }
        },
        "/cronjobs/records/clean": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "清空计划任务记录",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Cronjob"
                ],
                "summary": "Clean job records",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.CronjobClean"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [
                        {
                            "db": "cronjobs",
                            "input_column": "id",
                            "input_value": "id",
                            "isList": false,
                            "output_column": "name",
                            "output_value": "name"
                        }
                    ],
                    "bodyKeys": [
                        "id"
                    ],
                    "formatEN": "clean cronjob [name] records",
                    "formatZH": "清空计划任务记录 [name]",
                    "paramKeys": []
                }
            }
        },
        "/cronjobs/search": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取计划任务分页",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Cronjob"
                ],
                "summary": "Page cronjobs",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.SearchWithPage"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/dto.PageResult"
                        }
                    }
                }
            }
        },
        "/cronjobs/search/records": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取计划任务记录",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Cronjob"
                ],
                "summary": "Page job records",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.SearchRecord"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/dto.PageResult"
                        }
                    }
                }
            }
        },
        "/cronjobs/status": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "更新计划任务状态",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Cronjob"
                ],
                "summary": "Update cronjob status",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.CronjobUpdateStatus"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [
                        {
                            "db": "cronjobs",
                            "input_column": "id",
                            "input_value": "id",
                            "isList": false,
                            "output_column": "name",
                            "output_value": "name"
                        }
                    ],
                    "bodyKeys": [
                        "id",
                        "status"
                    ],
                    "formatEN": "change the status of cronjob [name] to [status].",
                    "formatZH": "修改计划任务 [name] 状态为 [status]",
                    "paramKeys": []
                }
            }
        },
        "/cronjobs/update": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "更新计划任务",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Cronjob"
                ],
                "summary": "Update cronjob",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.CronjobUpdate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [
                        {
                            "db": "cronjobs",
                            "input_column": "id",
                            "input_value": "id",
                            "isList": false,
                            "output_column": "name",
                            "output_value": "name"
                        }
                    ],
                    "bodyKeys": [
                        "id"
                    ],
                    "formatEN": "update cronjob [name]",
                    "formatZH": "更新计划任务 [name]",
                    "paramKeys": []
                }
            }
        },
        "/dashboard/base/:ioOption/:netOption": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取首页基础数据",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Dashboard"
                ],
                "summary": "Load dashboard base info",
                "parameters": [
                    {
                        "type": "string",
                        "description": "request",
                        "name": "ioOption",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "request",
                        "name": "netOption",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/dto.DashboardBase"
                        }
                    }
                }
            }
        },
        "/dashboard/current/:ioOption/:netOption": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取首页实时数据",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Dashboard"
                ],
                "summary": "Load dashboard current info",
                "parameters": [
                    {
                        "type": "string",
                        "description": "request",
                        "name": "ioOption",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "request",
                        "name": "netOption",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/dto.DashboardCurrent"
                        }
                    }
                }
            }
        },
        "/databases": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "创建 mysql 数据库",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Database Mysql"
                ],
                "summary": "Create mysql database",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.MysqlDBCreate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "name"
                    ],
                    "formatEN": "create mysql database [name]",
                    "formatZH": "创建 mysql 数据库 [name]",
                    "paramKeys": []
                }
            }
        },
        "/databases/baseinfo": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取 mysql 基础信息",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Database Mysql"
                ],
                "summary": "Load mysql base info",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.OperationWithNameAndType"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/dto.DBBaseInfo"
                        }
                    }
                }
            }
        },
        "/databases/change/access": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "修改 mysql 访问权限",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Database Mysql"
                ],
                "summary": "Change mysql access",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.ChangeDBInfo"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [
                        {
                            "db": "database_mysqls",
                            "input_column": "id",
                            "input_value": "id",
                            "isList": false,
                            "output_column": "name",
                            "output_value": "name"
                        }
                    ],
                    "bodyKeys": [
                        "id"
                    ],
                    "formatEN": "Update database [name] access",
                    "formatZH": "更新数据库 [name] 访问权限",
                    "paramKeys": []
                }
            }
        },
        "/databases/change/password": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "修改 mysql 密码",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Database Mysql"
                ],
                "summary": "Change mysql password",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.ChangeDBInfo"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [
                        {
                            "db": "database_mysqls",
                            "input_column": "id",
                            "input_value": "id",
                            "isList": false,
                            "output_column": "name",
                            "output_value": "name"
                        }
                    ],
                    "bodyKeys": [
                        "id"
                    ],
                    "formatEN": "Update database [name] password",
                    "formatZH": "更新数据库 [name] 密码",
                    "paramKeys": []
                }
            }
        },
        "/databases/conffile/update": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "上传替换 mysql 配置文件",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Database Mysql"
                ],
                "summary": "Update mysql conf by upload file",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.MysqlConfUpdateByFile"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [],
                    "formatEN": "update the mysql database configuration information",
                    "formatZH": "更新 mysql 数据库配置信息",
                    "paramKeys": []
                }
            }
        },
        "/databases/db": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "创建远程数据库",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Database"
                ],
                "summary": "Create database",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.DatabaseCreate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "name",
                        "type"
                    ],
                    "formatEN": "create database [name][type]",
                    "formatZH": "创建远程数据库 [name][type]",
                    "paramKeys": []
                }
            }
        },
        "/databases/db/:name": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取远程数据库",
                "tags": [
                    "Database"
                ],
                "summary": "Get databases",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/dto.DatabaseInfo"
                        }
                    }
                }
            }
        },
        "/databases/db/check": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "检测远程数据库连接性",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Database"
                ],
                "summary": "Check database",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.DatabaseCreate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "name",
                        "type"
                    ],
                    "formatEN": "check if database [name][type] is connectable",
                    "formatZH": "检测远程数据库 [name][type] 连接性",
                    "paramKeys": []
                }
            }
        },
        "/databases/db/del": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "删除远程数据库",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Database"
                ],
                "summary": "Delete database",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.DatabaseDelete"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [
                        {
                            "db": "databases",
                            "input_column": "id",
                            "input_value": "ids",
                            "isList": true,
                            "output_column": "name",
                            "output_value": "names"
                        }
                    ],
                    "bodyKeys": [
                        "ids"
                    ],
                    "formatEN": "delete database [names]",
                    "formatZH": "删除远程数据库 [names]",
                    "paramKeys": []
                }
            }
        },
        "/databases/db/list/:type": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取远程数据库列表",
                "tags": [
                    "Database"
                ],
                "summary": "List databases",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/dto.DatabaseOption"
                            }
                        }
                    }
                }
            }
        },
        "/databases/db/search": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取远程数据库列表分页",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Database"
                ],
                "summary": "Page databases",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.DatabaseSearch"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/dto.PageResult"
                        }
                    }
                }
            }
        },
        "/databases/db/update": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "更新远程数据库",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Database"
                ],
                "summary": "Update database",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.DatabaseUpdate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "name"
                    ],
                    "formatEN": "update database [name]",
                    "formatZH": "更新远程数据库 [name]",
                    "paramKeys": []
                }
            }
        },
        "/databases/del": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "删除 mysql 数据库",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Database Mysql"
                ],
                "summary": "Delete mysql database",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.MysqlDBDelete"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [
                        {
                            "db": "database_mysqls",
                            "input_column": "id",
                            "input_value": "id",
                            "isList": false,
                            "output_column": "name",
                            "output_value": "name"
                        }
                    ],
                    "bodyKeys": [
                        "id"
                    ],
                    "formatEN": "delete mysql database [name]",
                    "formatZH": "删除 mysql 数据库 [name]",
                    "paramKeys": []
                }
            }
        },
        "/databases/del/check": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "Mysql 数据库删除前检查",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Database Mysql"
                ],
                "summary": "Check before delete mysql database",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.MysqlDBDeleteCheck"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "type": "string"
                            }
                        }
                    }
                }
            }
        },
        "/databases/description/update": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "更新 mysql 数据库库描述信息",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Database Mysql"
                ],
                "summary": "Update mysql database description",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.UpdateDescription"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [
                        {
                            "db": "database_mysqls",
                            "input_column": "id",
                            "input_value": "id",
                            "isList": false,
                            "output_column": "name",
                            "output_value": "name"
                        }
                    ],
                    "bodyKeys": [
                        "id",
                        "description"
                    ],
                    "formatEN": "The description of the mysql database [name] is modified =\u003e [description]",
                    "formatZH": "mysql 数据库 [name] 描述信息修改 [description]",
                    "paramKeys": []
                }
            }
        },
        "/databases/load": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "从服务器获取",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Database Mysql"
                ],
                "summary": "Load mysql database from remote",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.MysqlLoadDB"
                        }
                    }
                ],
                "responses": {}
            }
        },
        "/databases/load/file": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取数据库文件",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Database"
                ],
                "summary": "Load Database file",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.OperationWithNameAndType"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/databases/options": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取 mysql 数据库列表",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Database Mysql"
                ],
                "summary": "List mysql database names",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.PageInfo"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/dto.MysqlOption"
                            }
                        }
                    }
                }
            }
        },
        "/databases/redis/backup/search": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取 redis 备份记录分页",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Database Redis"
                ],
                "summary": "Page redis backups",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.PageInfo"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/dto.PageResult"
                        }
                    }
                }
            }
        },
        "/databases/redis/conf": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取 redis 配置信息",
                "tags": [
                    "Database Redis"
                ],
                "summary": "Load redis conf",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/dto.RedisConf"
                        }
                    }
                }
            }
        },
        "/databases/redis/conf/update": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "更新 redis 配置信息",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Database Redis"
                ],
                "summary": "Update redis conf",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.RedisConfUpdate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [],
                    "formatEN": "update the redis database configuration information",
                    "formatZH": "更新 redis 数据库配置信息",
                    "paramKeys": []
                }
            }
        },
        "/databases/redis/conffile/update": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "上传更新 redis 配置信息",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Database Redis"
                ],
                "summary": "Update redis conf by file",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.RedisConfUpdateByFile"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [],
                    "formatEN": "update the redis database configuration information",
                    "formatZH": "更新 redis 数据库配置信息",
                    "paramKeys": []
                }
            }
        },
        "/databases/redis/password": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "更新 redis 密码",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Database Redis"
                ],
                "summary": "Change redis password",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.ChangeRedisPass"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [],
                    "formatEN": "change the password of the redis database",
                    "formatZH": "修改 redis 数据库密码",
                    "paramKeys": []
                }
            }
        },
        "/databases/redis/persistence/conf": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取 redis 持久化配置",
                "tags": [
                    "Database Redis"
                ],
                "summary": "Load redis persistence conf",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/dto.RedisPersistence"
                        }
                    }
                }
            }
        },
        "/databases/redis/persistence/update": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "更新 redis 持久化配置",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Database Redis"
                ],
                "summary": "Update redis persistence conf",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.RedisConfPersistenceUpdate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [],
                    "formatEN": "redis database persistence configuration update",
                    "formatZH": "redis 数据库持久化配置更新",
                    "paramKeys": []
                }
            }
        },
        "/databases/redis/status": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取 redis 状态信息",
                "tags": [
                    "Database Redis"
                ],
                "summary": "Load redis status info",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/dto.RedisStatus"
                        }
                    }
                }
            }
        },
        "/databases/remote": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取 mysql 远程访问权限",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Database Mysql"
                ],
                "summary": "Load mysql remote access",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.OperationWithNameAndType"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "boolean"
                        }
                    }
                }
            }
        },
        "/databases/search": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取 mysql 数据库列表分页",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Database Mysql"
                ],
                "summary": "Page mysql databases",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.MysqlDBSearch"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/dto.PageResult"
                        }
                    }
                }
            }
        },
        "/databases/status": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取 mysql 状态信息",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Database Mysql"
                ],
                "summary": "Load mysql status info",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.OperationWithNameAndType"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/dto.MysqlStatus"
                        }
                    }
                }
            }
        },
        "/databases/variables": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取 mysql 性能参数信息",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Database Mysql"
                ],
                "summary": "Load mysql variables info",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.OperationWithNameAndType"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/dto.MysqlVariables"
                        }
                    }
                }
            }
        },
        "/databases/variables/update": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "mysql 性能调优",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Database Mysql"
                ],
                "summary": "Update mysql variables",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.MysqlVariablesUpdate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [],
                    "formatEN": "adjust mysql database performance parameters",
                    "formatZH": "调整 mysql 数据库性能参数",
                    "paramKeys": []
                }
            }
        },
        "/db/remote/del/check": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "Mysql 远程数据库删除前检查",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Database"
                ],
                "summary": "Check before delete remote database",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.OperateByID"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "type": "string"
                            }
                        }
                    }
                }
            }
        },
        "/files": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "创建文件/文件夹",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "File"
                ],
                "summary": "Create file",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.FileCreate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "path"
                    ],
                    "formatEN": "Create dir or file [path]",
                    "formatZH": "创建文件/文件夹 [path]",
                    "paramKeys": []
                }
            }
        },
        "/files/batch/del": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "批量删除文件/文件夹",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "File"
                ],
                "summary": "Batch delete file",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.FileBatchDelete"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "paths"
                    ],
                    "formatEN": "Batch delete dir or file [paths]",
                    "formatZH": "批量删除文件/文件夹 [paths]",
                    "paramKeys": []
                }
            }
        },
        "/files/check": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "检测文件是否存在",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "File"
                ],
                "summary": "Check file exist",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.FilePathCheck"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "path"
                    ],
                    "formatEN": "Check whether file [path] exists",
                    "formatZH": "检测文件 [path] 是否存在",
                    "paramKeys": []
                }
            }
        },
        "/files/chunkdownload": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "分片下载下载文件",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "File"
                ],
                "summary": "Chunk Download file",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.FileDownload"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "name"
                    ],
                    "formatEN": "Download file [name]",
                    "formatZH": "下载文件 [name]",
                    "paramKeys": []
                }
            }
        },
        "/files/chunkupload": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "分片上传文件",
                "tags": [
                    "File"
                ],
                "summary": "ChunkUpload file",
                "parameters": [
                    {
                        "type": "file",
                        "description": "request",
                        "name": "file",
                        "in": "formData",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/files/compress": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "压缩文件",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "File"
                ],
                "summary": "Compress file",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.FileCompress"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "name"
                    ],
                    "formatEN": "Compress file [name]",
                    "formatZH": "压缩文件 [name]",
                    "paramKeys": []
                }
            }
        },
        "/files/content": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取文件内容",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "File"
                ],
                "summary": "Load file content",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.FileOption"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/response.FileInfo"
                        }
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "path"
                    ],
                    "formatEN": "Load file content [path]",
                    "formatZH": "获取文件内容 [path]",
                    "paramKeys": []
                }
            }
        },
        "/files/decompress": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "解压文件",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "File"
                ],
                "summary": "Decompress file",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.FileDeCompress"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "path"
                    ],
                    "formatEN": "Decompress file [path]",
                    "formatZH": "解压 [path]",
                    "paramKeys": []
                }
            }
        },
        "/files/del": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "删除文件/文件夹",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "File"
                ],
                "summary": "Delete file",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.FileDelete"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "path"
                    ],
                    "formatEN": "Delete dir or file [path]",
                    "formatZH": "删除文件/文件夹 [path]",
                    "paramKeys": []
                }
            }
        },
        "/files/download": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "下载文件",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "File"
                ],
                "summary": "Download file",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.FileDownload"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "name"
                    ],
                    "formatEN": "Download file [name]",
                    "formatZH": "下载文件 [name]",
                    "paramKeys": []
                }
            }
        },
        "/files/mode": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "修改文件权限",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "File"
                ],
                "summary": "Change file mode",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.FileCreate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "path",
                        "mode"
                    ],
                    "formatEN": "Change mode [paths] =\u003e [mode]",
                    "formatZH": "修改权限 [paths] =\u003e [mode]",
                    "paramKeys": []
                }
            }
        },
        "/files/move": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "移动文件",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "File"
                ],
                "summary": "Move file",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.FileMove"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "oldPaths",
                        "newPath"
                    ],
                    "formatEN": "Move [oldPaths] =\u003e [newPath]",
                    "formatZH": "移动文件 [oldPaths] =\u003e [newPath]",
                    "paramKeys": []
                }
            }
        },
        "/files/owner": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "修改文件用户/组",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "File"
                ],
                "summary": "Change file owner",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.FileRoleUpdate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "path",
                        "user",
                        "group"
                    ],
                    "formatEN": "Change owner [paths] =\u003e [user]/[group]",
                    "formatZH": "修改用户/组 [paths] =\u003e [user]/[group]",
                    "paramKeys": []
                }
            }
        },
        "/files/rename": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "修改文件名称",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "File"
                ],
                "summary": "Change file name",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.FileRename"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "oldName",
                        "newName"
                    ],
                    "formatEN": "Rename [oldName] =\u003e [newName]",
                    "formatZH": "重命名 [oldName] =\u003e [newName]",
                    "paramKeys": []
                }
            }
        },
        "/files/save": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "更新文件内容",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "File"
                ],
                "summary": "Update file content",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.FileEdit"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "path"
                    ],
                    "formatEN": "Update file content [path]",
                    "formatZH": "更新文件内容 [path]",
                    "paramKeys": []
                }
            }
        },
        "/files/search": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取文件列表",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "File"
                ],
                "summary": "List files",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.FileOption"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/response.FileInfo"
                        }
                    }
                }
            }
        },
        "/files/size": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取文件夹大小",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "File"
                ],
                "summary": "Load file size",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.DirSizeReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "path"
                    ],
                    "formatEN": "Load file size [path]",
                    "formatZH": "获取文件夹大小 [path]",
                    "paramKeys": []
                }
            }
        },
        "/files/tree": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "加载文件树",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "File"
                ],
                "summary": "Load files tree",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.FileOption"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/response.FileTree"
                            }
                        }
                    }
                }
            }
        },
        "/files/upload": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "上传文件",
                "tags": [
                    "File"
                ],
                "summary": "Upload file",
                "parameters": [
                    {
                        "type": "file",
                        "description": "request",
                        "name": "file",
                        "in": "formData",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "path"
                    ],
                    "formatEN": "Upload file [path]",
                    "formatZH": "上传文件 [path]",
                    "paramKeys": []
                }
            }
        },
        "/files/upload/search": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "分页获取上传文件",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "File"
                ],
                "summary": "Page file",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.SearchUploadWithPage"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/response.FileInfo"
                            }
                        }
                    }
                }
            }
        },
        "/files/wget": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "下载远端文件",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "File"
                ],
                "summary": "Wget file",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.FileWget"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "url",
                        "path",
                        "name"
                    ],
                    "formatEN": "Download url =\u003e [path]/[name]",
                    "formatZH": "下载 url =\u003e [path]/[name]",
                    "paramKeys": []
                }
            }
        },
        "/groups": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "创建系统组",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "System Group"
                ],
                "summary": "Create group",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.GroupCreate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "name",
                        "type"
                    ],
                    "formatEN": "create group [name][type]",
                    "formatZH": "创建组 [name][type]",
                    "paramKeys": []
                }
            }
        },
        "/groups/del": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "删除系统组",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "System Group"
                ],
                "summary": "Delete group",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.OperateByID"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [
                        {
                            "db": "groups",
                            "input_column": "id",
                            "input_value": "id",
                            "isList": false,
                            "output_column": "name",
                            "output_value": "name"
                        },
                        {
                            "db": "groups",
                            "input_column": "id",
                            "input_value": "id",
                            "isList": false,
                            "output_column": "type",
                            "output_value": "type"
                        }
                    ],
                    "bodyKeys": [
                        "id"
                    ],
                    "formatEN": "delete group [type][name]",
                    "formatZH": "删除组 [type][name]",
                    "paramKeys": []
                }
            }
        },
        "/groups/search": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "查询系统组",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "System Group"
                ],
                "summary": "List groups",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.GroupSearch"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/dto.GroupInfo"
                            }
                        }
                    }
                }
            }
        },
        "/groups/update": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "更新系统组",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "System Group"
                ],
                "summary": "Update group",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.GroupUpdate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "name",
                        "type"
                    ],
                    "formatEN": "update group [name][type]",
                    "formatZH": "更新组 [name][type]",
                    "paramKeys": []
                }
            }
        },
        "/host/conffile/update": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "上传文件更新 SSH 配置",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "SSH"
                ],
                "summary": "Update host SSH setting by file",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.SSHConf"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [],
                    "formatEN": "update SSH conf",
                    "formatZH": "修改 SSH 配置文件",
                    "paramKeys": []
                }
            }
        },
        "/host/ssh/conf": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取 SSH 配置文件",
                "tags": [
                    "SSH"
                ],
                "summary": "Load host SSH conf",
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/host/ssh/generate": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "生成 SSH 密钥",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "SSH"
                ],
                "summary": "Generate host SSH secret",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.GenerateSSH"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [],
                    "formatEN": "generate SSH secret",
                    "formatZH": "生成 SSH 密钥 ",
                    "paramKeys": []
                }
            }
        },
        "/host/ssh/log": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取 SSH 登录日志",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "SSH"
                ],
                "summary": "Load host SSH logs",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.SearchSSHLog"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/dto.SSHLog"
                        }
                    }
                }
            }
        },
        "/host/ssh/log/analysis": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "分析 SSH 登录日志",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "SSH"
                ],
                "summary": "Analysis host SSH logs",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.SearchForAnalysis"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/dto.SSHLogAnalysis"
                            }
                        }
                    }
                }
            }
        },
        "/host/ssh/operate": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "修改 SSH 服务状态",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "SSH"
                ],
                "summary": "Operate SSH",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.Operate"
                        }
                    }
                ],
                "responses": {},
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "operation"
                    ],
                    "formatEN": "[operation] SSH",
                    "formatZH": "[operation] SSH ",
                    "paramKeys": []
                }
            }
        },
        "/host/ssh/search": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "加载 SSH 配置信息",
                "tags": [
                    "SSH"
                ],
                "summary": "Load host SSH setting info",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/dto.SSHInfo"
                        }
                    }
                }
            }
        },
        "/host/ssh/secret": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取 SSH 密钥",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "SSH"
                ],
                "summary": "Load host SSH secret",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.GenerateLoad"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/host/ssh/update": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "更新 SSH 配置",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "SSH"
                ],
                "summary": "Update host SSH setting",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.SettingUpdate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "key",
                        "value"
                    ],
                    "formatEN": "update SSH setting [key] =\u003e [value]",
                    "formatZH": "修改 SSH 配置 [key] =\u003e [value]",
                    "paramKeys": []
                }
            }
        },
        "/host/tool": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取主机工具状态",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Host tool"
                ],
                "summary": "Get tool",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.HostToolReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/host/tool/config": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "操作主机工具配置文件",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Host tool"
                ],
                "summary": "Get tool config",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.HostToolConfig"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "operate"
                    ],
                    "formatEN": "[operate] tool config",
                    "formatZH": "[operate] 主机工具配置文件 ",
                    "paramKeys": []
                }
            }
        },
        "/host/tool/create": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "创建主机工具配置",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Host tool"
                ],
                "summary": "Create Host tool Config",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.HostToolCreate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "type"
                    ],
                    "formatEN": "create [type] config",
                    "formatZH": "创建 [type] 配置",
                    "paramKeys": []
                }
            }
        },
        "/host/tool/log": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取主机工具日志",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Host tool"
                ],
                "summary": "Get tool",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.HostToolLogReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/host/tool/operate": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "操作主机工具",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Host tool"
                ],
                "summary": "Operate tool",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.HostToolReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "operate",
                        "type"
                    ],
                    "formatEN": "[operate] [type]",
                    "formatZH": "[operate] [type] ",
                    "paramKeys": []
                }
            }
        },
        "/host/tool/supervisor/process": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取 Supervisor 进程配置",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Host tool"
                ],
                "summary": "Get Supervisor process config",
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "操作守护进程",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Host tool"
                ],
                "summary": "Create Supervisor process",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.SupervisorProcessConfig"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "operate"
                    ],
                    "formatEN": "[operate] process",
                    "formatZH": "[operate] 守护进程 ",
                    "paramKeys": []
                }
            }
        },
        "/host/tool/supervisor/process/file": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "操作 Supervisor 进程文件",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Host tool"
                ],
                "summary": "Get Supervisor process config",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.SupervisorProcessFileReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "operate"
                    ],
                    "formatEN": "[operate] Supervisor Process Config file",
                    "formatZH": "[operate] Supervisor 进程文件 ",
                    "paramKeys": []
                }
            }
        },
        "/hosts": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "创建主机",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Host"
                ],
                "summary": "Create host",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.HostOperate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "name",
                        "addr"
                    ],
                    "formatEN": "create host [name][addr]",
                    "formatZH": "创建主机 [name][addr]",
                    "paramKeys": []
                }
            }
        },
        "/hosts/command": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取快速命令列表",
                "tags": [
                    "Command"
                ],
                "summary": "List commands",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/dto.CommandInfo"
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "创建快速命令",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Command"
                ],
                "summary": "Create command",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.CommandOperate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "name",
                        "command"
                    ],
                    "formatEN": "create quick command [name][command]",
                    "formatZH": "创建快捷命令 [name][command]",
                    "paramKeys": []
                }
            }
        },
        "/hosts/command/del": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "删除快速命令",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Command"
                ],
                "summary": "Delete command",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.BatchDeleteReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [
                        {
                            "db": "commands",
                            "input_column": "id",
                            "input_value": "ids",
                            "isList": true,
                            "output_column": "name",
                            "output_value": "names"
                        }
                    ],
                    "bodyKeys": [
                        "ids"
                    ],
                    "formatEN": "delete quick command [names]",
                    "formatZH": "删除快捷命令 [names]",
                    "paramKeys": []
                }
            }
        },
        "/hosts/command/search": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取快速命令列表分页",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Command"
                ],
                "summary": "Page commands",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.SearchWithPage"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/dto.PageResult"
                        }
                    }
                }
            }
        },
        "/hosts/command/update": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "更新快速命令",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Command"
                ],
                "summary": "Update command",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.CommandOperate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "name"
                    ],
                    "formatEN": "update quick command [name]",
                    "formatZH": "更新快捷命令 [name]",
                    "paramKeys": []
                }
            }
        },
        "/hosts/del": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "删除主机",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Host"
                ],
                "summary": "Delete host",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.BatchDeleteReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [
                        {
                            "db": "hosts",
                            "input_column": "id",
                            "input_value": "ids",
                            "isList": true,
                            "output_column": "addr",
                            "output_value": "addrs"
                        }
                    ],
                    "bodyKeys": [
                        "ids"
                    ],
                    "formatEN": "delete host [addrs]",
                    "formatZH": "删除主机 [addrs]",
                    "paramKeys": []
                }
            }
        },
        "/hosts/firewall/base": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取防火墙基础信息",
                "tags": [
                    "Firewall"
                ],
                "summary": "Load firewall base info",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/dto.FirewallBaseInfo"
                        }
                    }
                }
            }
        },
        "/hosts/firewall/batch": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "批量删除防火墙规则",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Firewall"
                ],
                "summary": "Create group",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.BatchRuleOperate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/hosts/firewall/ip": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "创建防火墙 IP 规则",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Firewall"
                ],
                "summary": "Create group",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.AddrRuleOperate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "strategy",
                        "address"
                    ],
                    "formatEN": "create address rules [strategy][address]",
                    "formatZH": "添加 ip 规则 [strategy] [address]",
                    "paramKeys": []
                }
            }
        },
        "/hosts/firewall/operate": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "修改防火墙状态",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Firewall"
                ],
                "summary": "Page firewall status",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.FirewallOperation"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/dto.PageResult"
                        }
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "operation"
                    ],
                    "formatEN": "[operation] firewall",
                    "formatZH": "[operation] 防火墙",
                    "paramKeys": []
                }
            }
        },
        "/hosts/firewall/port": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "创建防火墙端口规则",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Firewall"
                ],
                "summary": "Create group",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.PortRuleOperate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "port",
                        "strategy"
                    ],
                    "formatEN": "create port rules [strategy][port]",
                    "formatZH": "添加端口规则 [strategy] [port]",
                    "paramKeys": []
                }
            }
        },
        "/hosts/firewall/search": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取防火墙规则列表分页",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Firewall"
                ],
                "summary": "Page firewall rules",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.SearchWithPage"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/dto.PageResult"
                        }
                    }
                }
            }
        },
        "/hosts/firewall/update/addr": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "更新 ip 防火墙规则",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Firewall"
                ],
                "summary": "Create group",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.AddrRuleUpdate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/hosts/firewall/update/description": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "更新防火墙描述",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Firewall"
                ],
                "summary": "Update rule description",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.UpdateFirewallDescription"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/hosts/firewall/update/port": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "更新端口防火墙规则",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Firewall"
                ],
                "summary": "Create group",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.PortRuleUpdate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/hosts/search": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取主机列表分页",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Host"
                ],
                "summary": "Page host",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.SearchHostWithPage"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/dto.HostTree"
                            }
                        }
                    }
                }
            }
        },
        "/hosts/test/byid/:id": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "测试主机连接",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Host"
                ],
                "summary": "Test host conn by host id",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "request",
                        "name": "id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "boolean"
                        }
                    }
                }
            }
        },
        "/hosts/test/byinfo": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "测试主机连接",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Host"
                ],
                "summary": "Test host conn by info",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.HostConnTest"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/hosts/tree": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "加载主机树",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Host"
                ],
                "summary": "Load host tree",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.SearchForTree"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/dto.HostTree"
                            }
                        }
                    }
                }
            }
        },
        "/hosts/update": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "更新主机",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Host"
                ],
                "summary": "Update host",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.HostOperate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "name",
                        "addr"
                    ],
                    "formatEN": "update host [name][addr]",
                    "formatZH": "更新主机信息 [name][addr]",
                    "paramKeys": []
                }
            }
        },
        "/hosts/update/group": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "切换分组",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Host"
                ],
                "summary": "Update host group",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.ChangeHostGroup"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [
                        {
                            "db": "hosts",
                            "input_column": "id",
                            "input_value": "id",
                            "isList": false,
                            "output_column": "addr",
                            "output_value": "addr"
                        }
                    ],
                    "bodyKeys": [
                        "id",
                        "group"
                    ],
                    "formatEN": "change host [addr] group =\u003e [group]",
                    "formatZH": "切换主机[addr]分组 =\u003e [group]",
                    "paramKeys": []
                }
            }
        },
        "/logs/clean": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "清空操作日志",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Logs"
                ],
                "summary": "Clean operation logs",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.CleanLog"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/dto.PageResult"
                        }
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "logType"
                    ],
                    "formatEN": "Clean the [logType] log information",
                    "formatZH": "清空 [logType] 日志信息",
                    "paramKeys": []
                }
            }
        },
        "/logs/login": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取系统登录日志列表分页",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Logs"
                ],
                "summary": "Page login logs",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.SearchLgLogWithPage"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/dto.PageResult"
                        }
                    }
                }
            }
        },
        "/logs/operation": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取系统操作日志列表分页",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Logs"
                ],
                "summary": "Page operation logs",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.SearchOpLogWithPage"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/dto.PageResult"
                        }
                    }
                }
            }
        },
        "/logs/system": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取系统日志",
                "tags": [
                    "Logs"
                ],
                "summary": "Load system logs",
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/logs/system/files": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取系统日志文件列表",
                "tags": [
                    "Logs"
                ],
                "summary": "Load system log files",
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/openResty": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取 OpenResty 配置信息",
                "tags": [
                    "OpenResty"
                ],
                "summary": "Load OpenResty conf",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/response.FileInfo"
                        }
                    }
                }
            }
        },
        "/openResty/file": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "上传更新 OpenResty 配置文件",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "OpenResty"
                ],
                "summary": "Update OpenResty conf by upload file",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.NginxConfigFileUpdate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [],
                    "formatEN": "Update nginx conf",
                    "formatZH": "更新 nginx 配置",
                    "paramKeys": []
                }
            }
        },
        "/openResty/scope": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取部分 OpenResty 配置信息",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "OpenResty"
                ],
                "summary": "Load partial OpenResty conf",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.NginxScopeReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/response.NginxParam"
                            }
                        }
                    }
                }
            }
        },
        "/openResty/status": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取 OpenResty 状态信息",
                "tags": [
                    "OpenResty"
                ],
                "summary": "Load OpenResty status info",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/response.NginxStatus"
                        }
                    }
                }
            }
        },
        "/openResty/update": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "更新 OpenResty 配置信息",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "OpenResty"
                ],
                "summary": "Update OpenResty conf",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.NginxConfigUpdate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [
                        {
                            "db": "websites",
                            "input_column": "id",
                            "input_value": "websiteId",
                            "isList": false,
                            "output_column": "primary_domain",
                            "output_value": "domain"
                        }
                    ],
                    "bodyKeys": [
                        "websiteId"
                    ],
                    "formatEN": "Update nginx conf [domain]",
                    "formatZH": "更新 nginx 配置 [domain]",
                    "paramKeys": []
                }
            }
        },
        "/process/stop": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "停止进程",
                "tags": [
                    "Process"
                ],
                "summary": "Stop Process",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.ProcessReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "PID"
                    ],
                    "formatEN": "结束进程 [PID]",
                    "formatZH": "结束进程 [PID]",
                    "paramKeys": []
                }
            }
        },
        "/runtimes": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "创建运行环境",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Runtime"
                ],
                "summary": "Create runtime",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.RuntimeCreate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "name"
                    ],
                    "formatEN": "Create runtime [name]",
                    "formatZH": "创建运行环境 [name]",
                    "paramKeys": []
                }
            }
        },
        "/runtimes/:id": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取运行环境",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Runtime"
                ],
                "summary": "Get runtime",
                "parameters": [
                    {
                        "type": "string",
                        "description": "request",
                        "name": "id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/runtimes/del": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "删除运行环境",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Website"
                ],
                "summary": "Delete runtime",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.RuntimeDelete"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "id"
                    ],
                    "formatEN": "Delete website [name]",
                    "formatZH": "删除网站 [name]",
                    "paramKeys": []
                }
            }
        },
        "/runtimes/node/modules": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取 Node 项目的 modules",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Runtime"
                ],
                "summary": "Get Node modules",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.NodeModuleReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/runtimes/node/modules/operate": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "操作 Node 项目 modules",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Runtime"
                ],
                "summary": "Operate Node modules",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.NodeModuleReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/runtimes/node/package": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取 Node 项目的 scripts",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Runtime"
                ],
                "summary": "Get Node package scripts",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.NodePackageReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/runtimes/operate": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "操作运行环境",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Runtime"
                ],
                "summary": "Operate runtime",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.RuntimeOperate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "id"
                    ],
                    "formatEN": "Operate runtime [name]",
                    "formatZH": "操作运行环境 [name]",
                    "paramKeys": []
                }
            }
        },
        "/runtimes/search": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取运行环境列表",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Runtime"
                ],
                "summary": "List runtimes",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.RuntimeSearch"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/runtimes/update": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "更新运行环境",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Runtime"
                ],
                "summary": "Update runtime",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.RuntimeUpdate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "name"
                    ],
                    "formatEN": "Update runtime [name]",
                    "formatZH": "更新运行环境 [name]",
                    "paramKeys": []
                }
            }
        },
        "/settings/backup": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "创建备份账号",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Backup Account"
                ],
                "summary": "Create backup account",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.BackupOperate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "type"
                    ],
                    "formatEN": "create backup account [type]",
                    "formatZH": "创建备份账号 [type]",
                    "paramKeys": []
                }
            }
        },
        "/settings/backup/": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "备份系统数据",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Backup Account"
                ],
                "summary": "Backup system data",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.CommonBackup"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "type",
                        "name",
                        "detailName"
                    ],
                    "formatEN": "backup [type] data [name][detailName]",
                    "formatZH": "备份 [type] 数据 [name][detailName]",
                    "paramKeys": []
                }
            }
        },
        "/settings/backup/del": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "删除备份账号",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Backup Account"
                ],
                "summary": "Delete backup account",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.BatchDeleteReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [
                        {
                            "db": "backup_accounts",
                            "input_column": "id",
                            "input_value": "id",
                            "isList": true,
                            "output_column": "type",
                            "output_value": "types"
                        }
                    ],
                    "bodyKeys": [
                        "id"
                    ],
                    "formatEN": "delete backup account [types]",
                    "formatZH": "删除备份账号 [types]",
                    "paramKeys": []
                }
            }
        },
        "/settings/backup/onedrive": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取 OneDrive 信息",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Backup Account"
                ],
                "summary": "Load OneDrive info",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            }
        },
        "/settings/backup/record/del": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "删除备份记录",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Backup Account"
                ],
                "summary": "Delete backup record",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.BatchDeleteReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [
                        {
                            "db": "backup_records",
                            "input_column": "id",
                            "input_value": "ids",
                            "isList": true,
                            "output_column": "file_name",
                            "output_value": "files"
                        }
                    ],
                    "bodyKeys": [
                        "ids"
                    ],
                    "formatEN": "delete backup records [files]",
                    "formatZH": "删除备份记录 [files]",
                    "paramKeys": []
                }
            }
        },
        "/settings/backup/record/download": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "下载备份记录",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Backup Account"
                ],
                "summary": "Download backup record",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.DownloadRecord"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "source",
                        "fileName"
                    ],
                    "formatEN": "download backup records [source][fileName]",
                    "formatZH": "下载备份记录 [source][fileName]",
                    "paramKeys": []
                }
            }
        },
        "/settings/backup/record/search": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取备份记录列表分页",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Backup Account"
                ],
                "summary": "Page backup records",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.RecordSearch"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/settings/backup/recover": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "恢复系统数据",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Backup Account"
                ],
                "summary": "Recover system data",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.CommonRecover"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "type",
                        "name",
                        "detailName",
                        "file"
                    ],
                    "formatEN": "recover [type] data [name][detailName] from [file]",
                    "formatZH": "从 [file] 恢复 [type] 数据 [name][detailName]",
                    "paramKeys": []
                }
            }
        },
        "/settings/backup/recover/byupload": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "从上传恢复系统数据",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Backup Account"
                ],
                "summary": "Recover system data by upload",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.CommonRecover"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "type",
                        "name",
                        "detailName",
                        "file"
                    ],
                    "formatEN": "recover [type] data [name][detailName] from [file]",
                    "formatZH": "从 [file] 恢复 [type] 数据 [name][detailName]",
                    "paramKeys": []
                }
            }
        },
        "/settings/backup/search": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取备份账号列表",
                "tags": [
                    "Backup Account"
                ],
                "summary": "List backup accounts",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/dto.BackupInfo"
                            }
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取 bucket 列表",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Backup Account"
                ],
                "summary": "List buckets",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.ForBuckets"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "type": "string"
                            }
                        }
                    }
                }
            }
        },
        "/settings/backup/search/files": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取备份账号内文件列表",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Backup Account"
                ],
                "summary": "List files from backup accounts",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.BackupSearchFile"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "type": "string"
                            }
                        }
                    }
                }
            }
        },
        "/settings/backup/update": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "更新备份账号信息",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Backup Account"
                ],
                "summary": "Update backup account",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.BackupOperate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "type"
                    ],
                    "formatEN": "update backup account [types]",
                    "formatZH": "更新备份账号 [types]",
                    "paramKeys": []
                }
            }
        },
        "/settings/basedir": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取安装根目录",
                "tags": [
                    "System Setting"
                ],
                "summary": "Load local backup dir",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            }
        },
        "/settings/clean": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "清理系统垃圾文件",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "System Setting"
                ],
                "summary": "System clean",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/dto.Clean"
                            }
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [],
                    "formatEN": "Clean system junk files",
                    "formatZH": "清理系统垃圾文件",
                    "paramKeys": []
                }
            }
        },
        "/settings/expired/handle": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "重置过期系统登录密码",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "System Setting"
                ],
                "summary": "Reset system password expired",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.PasswordUpdate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [],
                    "formatEN": "reset an expired Password",
                    "formatZH": "重置过期密码",
                    "paramKeys": []
                }
            }
        },
        "/settings/mfa": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取 mfa 信息",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "System Setting"
                ],
                "summary": "Load mfa info",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.MfaCredential"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/mfa.Otp"
                        }
                    }
                }
            }
        },
        "/settings/mfa/bind": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "Mfa 绑定",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "System Setting"
                ],
                "summary": "Bind mfa",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.MfaCredential"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [],
                    "formatEN": "bind mfa",
                    "formatZH": "mfa 绑定",
                    "paramKeys": []
                }
            }
        },
        "/settings/monitor/clean": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "清空监控数据",
                "tags": [
                    "System Setting"
                ],
                "summary": "Clean monitor datas",
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [],
                    "formatEN": "clean monitor datas",
                    "formatZH": "清空监控数据",
                    "paramKeys": []
                }
            }
        },
        "/settings/password/update": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "更新系统登录密码",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "System Setting"
                ],
                "summary": "Update system password",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.PasswordUpdate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [],
                    "formatEN": "update system password",
                    "formatZH": "修改系统密码",
                    "paramKeys": []
                }
            }
        },
        "/settings/port/update": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "更新系统端口",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "System Setting"
                ],
                "summary": "Update system port",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.PortUpdate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "serverPort"
                    ],
                    "formatEN": "update system port =\u003e [serverPort]",
                    "formatZH": "修改系统端口 =\u003e [serverPort]",
                    "paramKeys": []
                }
            }
        },
        "/settings/scan": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "扫描系统垃圾文件",
                "tags": [
                    "System Setting"
                ],
                "summary": "Scan system",
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [],
                    "formatEN": "scan System Junk Files",
                    "formatZH": "扫描系统垃圾文件",
                    "paramKeys": []
                }
            }
        },
        "/settings/search": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "加载系统配置信息",
                "tags": [
                    "System Setting"
                ],
                "summary": "Load system setting info",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/dto.SettingInfo"
                        }
                    }
                }
            }
        },
        "/settings/search/available": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取系统可用状态",
                "tags": [
                    "System Setting"
                ],
                "summary": "Load system available status",
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/settings/snapshot": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "创建系统快照",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "System Setting"
                ],
                "summary": "Create system snapshot",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.SnapshotCreate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "from",
                        "description"
                    ],
                    "formatEN": "Create system backup [description] to [from]",
                    "formatZH": "创建系统快照 [description] 到 [from]",
                    "paramKeys": []
                }
            }
        },
        "/settings/snapshot/del": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "删除系统快照",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "System Setting"
                ],
                "summary": "Delete system backup",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.BatchDeleteReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [
                        {
                            "db": "snapshots",
                            "input_column": "id",
                            "input_value": "ids",
                            "isList": true,
                            "output_column": "name",
                            "output_value": "name"
                        }
                    ],
                    "bodyKeys": [
                        "ids"
                    ],
                    "formatEN": "Delete system backup [name]",
                    "formatZH": "删除系统快照 [name]",
                    "paramKeys": []
                }
            }
        },
        "/settings/snapshot/description/update": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "更新快照描述信息",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "System Setting"
                ],
                "summary": "Update snapshot description",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.UpdateDescription"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [
                        {
                            "db": "snapshots",
                            "input_column": "id",
                            "input_value": "id",
                            "isList": false,
                            "output_column": "name",
                            "output_value": "name"
                        }
                    ],
                    "bodyKeys": [
                        "id",
                        "description"
                    ],
                    "formatEN": "The description of the snapshot [name] is modified =\u003e [description]",
                    "formatZH": "快照 [name] 描述信息修改 [description]",
                    "paramKeys": []
                }
            }
        },
        "/settings/snapshot/import": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "导入已有快照",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "System Setting"
                ],
                "summary": "Import system snapshot",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.SnapshotImport"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "from",
                        "names"
                    ],
                    "formatEN": "Sync system snapshots [names] from [from]",
                    "formatZH": "从 [from] 同步系统快照 [names]",
                    "paramKeys": []
                }
            }
        },
        "/settings/snapshot/recover": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "从系统快照恢复",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "System Setting"
                ],
                "summary": "Recover system backup",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.SnapshotRecover"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [
                        {
                            "db": "snapshots",
                            "input_column": "id",
                            "input_value": "id",
                            "isList": false,
                            "output_column": "name",
                            "output_value": "name"
                        }
                    ],
                    "bodyKeys": [
                        "id"
                    ],
                    "formatEN": "Recover from system backup [name]",
                    "formatZH": "从系统快照 [name] 恢复",
                    "paramKeys": []
                }
            }
        },
        "/settings/snapshot/rollback": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "从系统快照回滚",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "System Setting"
                ],
                "summary": "Rollback system backup",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.SnapshotRecover"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [
                        {
                            "db": "snapshots",
                            "input_column": "id",
                            "input_value": "id",
                            "isList": false,
                            "output_column": "name",
                            "output_value": "name"
                        }
                    ],
                    "bodyKeys": [
                        "id"
                    ],
                    "formatEN": "Rollback from system backup [name]",
                    "formatZH": "从系统快照 [name] 回滚",
                    "paramKeys": []
                }
            }
        },
        "/settings/snapshot/search": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取系统快照列表分页",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "System Setting"
                ],
                "summary": "Page system snapshot",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.SearchWithPage"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/dto.PageResult"
                        }
                    }
                }
            }
        },
        "/settings/snapshot/status": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取快照状态",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "System Setting"
                ],
                "summary": "Load Snapshot status",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.OperateByID"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/settings/ssl/download": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "下载证书",
                "tags": [
                    "System Setting"
                ],
                "summary": "Download system cert",
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/settings/ssl/info": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取证书信息",
                "tags": [
                    "System Setting"
                ],
                "summary": "Load system cert info",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/dto.SettingInfo"
                        }
                    }
                }
            }
        },
        "/settings/ssl/update": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "修改系统 ssl 登录",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "System Setting"
                ],
                "summary": "Update system ssl",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.SSLUpdate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "ssl"
                    ],
                    "formatEN": "update system ssl =\u003e [ssl]",
                    "formatZH": "修改系统 ssl =\u003e [ssl]",
                    "paramKeys": []
                }
            }
        },
        "/settings/time/option": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "加载系统可用时区",
                "tags": [
                    "System Setting"
                ],
                "summary": "Load time zone options",
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/settings/time/sync": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "系统时间同步",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "System Setting"
                ],
                "summary": "Sync system time",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.SyncTime"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "string"
                        }
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "ntpSite"
                    ],
                    "formatEN": "sync system time [ntpSite]",
                    "formatZH": "系统时间同步[ntpSite]",
                    "paramKeys": []
                }
            }
        },
        "/settings/update": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "更新系统配置",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "System Setting"
                ],
                "summary": "Update system setting",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.SettingUpdate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "key",
                        "value"
                    ],
                    "formatEN": "update system setting [key] =\u003e [value]",
                    "formatZH": "修改系统配置 [key] =\u003e [value]",
                    "paramKeys": []
                }
            }
        },
        "/settings/upgrade": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取版本 release notes",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "System Setting"
                ],
                "summary": "Load release notes by version",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.Upgrade"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "系统更新",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "System Setting"
                ],
                "summary": "Upgrade",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.Upgrade"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "version"
                    ],
                    "formatEN": "upgrade service =\u003e [version]",
                    "formatZH": "更新系统 =\u003e [version]",
                    "paramKeys": []
                }
            }
        },
        "/websites": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "创建网站",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Website"
                ],
                "summary": "Create website",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.WebsiteCreate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "primaryDomain"
                    ],
                    "formatEN": "Create website [primaryDomain]",
                    "formatZH": "创建网站 [primaryDomain]",
                    "paramKeys": []
                }
            }
        },
        "/websites/:id": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "通过 id 查询网站",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Website"
                ],
                "summary": "Search website by id",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "request",
                        "name": "id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/response.WebsiteDTO"
                        }
                    }
                }
            }
        },
        "/websites/:id/config/:type": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "通过 id 查询网站 nginx",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Website Nginx"
                ],
                "summary": "Search website nginx by id",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "request",
                        "name": "id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/response.FileInfo"
                        }
                    }
                }
            }
        },
        "/websites/:id/https": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取 https 配置",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Website HTTPS"
                ],
                "summary": "Load https conf",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "request",
                        "name": "id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/response.WebsiteHTTPS"
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "更新 https 配置",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Website HTTPS"
                ],
                "summary": "Update https conf",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.WebsiteHTTPSOp"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/response.WebsiteHTTPS"
                        }
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [
                        {
                            "db": "websites",
                            "input_column": "id",
                            "input_value": "websiteId",
                            "isList": false,
                            "output_column": "primary_domain",
                            "output_value": "domain"
                        }
                    ],
                    "bodyKeys": [
                        "websiteId"
                    ],
                    "formatEN": "Update website https [domain] conf",
                    "formatZH": "更新网站 [domain] https 配置",
                    "paramKeys": []
                }
            }
        },
        "/websites/acme": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "创建网站 acme",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Website Acme"
                ],
                "summary": "Create website acme account",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.WebsiteAcmeAccountCreate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/response.WebsiteAcmeAccountDTO"
                        }
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "email"
                    ],
                    "formatEN": "Create website acme [email]",
                    "formatZH": "创建网站 acme [email]",
                    "paramKeys": []
                }
            }
        },
        "/websites/acme/del": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "删除网站 acme",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Website Acme"
                ],
                "summary": "Delete website acme account",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.WebsiteResourceReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [
                        {
                            "db": "website_acme_accounts",
                            "input_column": "id",
                            "input_value": "id",
                            "isList": false,
                            "output_column": "email",
                            "output_value": "email"
                        }
                    ],
                    "bodyKeys": [
                        "id"
                    ],
                    "formatEN": "Delete website acme [email]",
                    "formatZH": "删除网站 acme [email]",
                    "paramKeys": []
                }
            }
        },
        "/websites/acme/search": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取网站 acme 列表分页",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Website Acme"
                ],
                "summary": "Page website acme accounts",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.PageInfo"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/dto.PageResult"
                        }
                    }
                }
            }
        },
        "/websites/auths": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取密码访问配置",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Website"
                ],
                "summary": "Get AuthBasic conf",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.NginxAuthReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/websites/auths/update": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "更新密码访问配置",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Website"
                ],
                "summary": "Get AuthBasic conf",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.NginxAuthUpdate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/websites/check": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "网站创建前检查",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Website"
                ],
                "summary": "Check before create website",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.WebsiteInstallCheckReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/response.WebsitePreInstallCheck"
                            }
                        }
                    }
                }
            }
        },
        "/websites/config": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取 nginx 配置",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Website Nginx"
                ],
                "summary": "Load nginx conf",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.NginxScopeReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/response.WebsiteNginxConfig"
                        }
                    }
                }
            }
        },
        "/websites/config/update": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "更新 nginx 配置",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Website Nginx"
                ],
                "summary": "Update nginx conf",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.NginxConfigUpdate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [
                        {
                            "db": "websites",
                            "input_column": "id",
                            "input_value": "websiteId",
                            "isList": false,
                            "output_column": "primary_domain",
                            "output_value": "domain"
                        }
                    ],
                    "bodyKeys": [
                        "websiteId"
                    ],
                    "formatEN": "Nginx conf update [domain]",
                    "formatZH": "nginx 配置修改 [domain]",
                    "paramKeys": []
                }
            }
        },
        "/websites/default/server": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "操作网站日志",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Website"
                ],
                "summary": "Change default server",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.WebsiteDefaultUpdate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [
                        {
                            "db": "websites",
                            "input_column": "id",
                            "input_value": "id",
                            "isList": false,
                            "output_column": "primary_domain",
                            "output_value": "domain"
                        }
                    ],
                    "bodyKeys": [
                        "id",
                        "operate"
                    ],
                    "formatEN": "Change default server =\u003e [domain]",
                    "formatZH": "修改默认 server =\u003e [domain]",
                    "paramKeys": []
                }
            }
        },
        "/websites/del": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "删除网站",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Website"
                ],
                "summary": "Delete website",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.WebsiteDelete"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [
                        {
                            "db": "websites",
                            "input_column": "id",
                            "input_value": "id",
                            "isList": false,
                            "output_column": "primary_domain",
                            "output_value": "domain"
                        }
                    ],
                    "bodyKeys": [
                        "id"
                    ],
                    "formatEN": "Delete website [domain]",
                    "formatZH": "删除网站 [domain]",
                    "paramKeys": []
                }
            }
        },
        "/websites/dir": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取网站目录配置",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Website"
                ],
                "summary": "Get website dir",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.WebsiteCommonReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/websites/dir/permission": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "更新网站目录权限",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Website"
                ],
                "summary": "Update Site Dir permission",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.WebsiteUpdateDirPermission"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [
                        {
                            "db": "websites",
                            "input_column": "id",
                            "input_value": "id",
                            "isList": false,
                            "output_column": "primary_domain",
                            "output_value": "domain"
                        }
                    ],
                    "bodyKeys": [
                        "id"
                    ],
                    "formatEN": "Update  domain [domain] dir permission",
                    "formatZH": "更新网站 [domain] 目录权限",
                    "paramKeys": []
                }
            }
        },
        "/websites/dir/update": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "更新网站目录",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Website"
                ],
                "summary": "Update Site Dir",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.WebsiteUpdateDir"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [
                        {
                            "db": "websites",
                            "input_column": "id",
                            "input_value": "id",
                            "isList": false,
                            "output_column": "primary_domain",
                            "output_value": "domain"
                        }
                    ],
                    "bodyKeys": [
                        "id"
                    ],
                    "formatEN": "Update  domain [domain] dir",
                    "formatZH": "更新网站 [domain] 目录",
                    "paramKeys": []
                }
            }
        },
        "/websites/dns": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "创建网站 dns",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Website DNS"
                ],
                "summary": "Create website dns account",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.WebsiteDnsAccountCreate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "name"
                    ],
                    "formatEN": "Create website dns [name]",
                    "formatZH": "创建网站 dns [name]",
                    "paramKeys": []
                }
            }
        },
        "/websites/dns/del": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "删除网站 dns",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Website DNS"
                ],
                "summary": "Delete website dns account",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.WebsiteResourceReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [
                        {
                            "db": "website_dns_accounts",
                            "input_column": "id",
                            "input_value": "id",
                            "isList": false,
                            "output_column": "name",
                            "output_value": "name"
                        }
                    ],
                    "bodyKeys": [
                        "id"
                    ],
                    "formatEN": "Delete website dns [name]",
                    "formatZH": "删除网站 dns [name]",
                    "paramKeys": []
                }
            }
        },
        "/websites/dns/search": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取网站 dns 列表分页",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Website DNS"
                ],
                "summary": "Page website dns accounts",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/dto.PageInfo"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/dto.PageResult"
                        }
                    }
                }
            }
        },
        "/websites/dns/update": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "更新网站 dns",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Website DNS"
                ],
                "summary": "Update website dns account",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.WebsiteDnsAccountUpdate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "name"
                    ],
                    "formatEN": "Update website dns [name]",
                    "formatZH": "更新网站 dns [name]",
                    "paramKeys": []
                }
            }
        },
        "/websites/domains": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "创建网站域名",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Website Domain"
                ],
                "summary": "Create website domain",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.WebsiteDomainCreate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/model.WebsiteDomain"
                        }
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "domain"
                    ],
                    "formatEN": "Create domain [domain]",
                    "formatZH": "创建域名 [domain]",
                    "paramKeys": []
                }
            }
        },
        "/websites/domains/:websiteId": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "通过网站 id 查询域名",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Website Domain"
                ],
                "summary": "Search website domains by websiteId",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "request",
                        "name": "websiteId",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/model.WebsiteDomain"
                            }
                        }
                    }
                }
            }
        },
        "/websites/domains/del": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "删除网站域名",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Website Domain"
                ],
                "summary": "Delete website domain",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.WebsiteDomainDelete"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [
                        {
                            "db": "website_domains",
                            "input_column": "id",
                            "input_value": "id",
                            "isList": false,
                            "output_column": "domain",
                            "output_value": "domain"
                        }
                    ],
                    "bodyKeys": [
                        "id"
                    ],
                    "formatEN": "Delete domain [domain]",
                    "formatZH": "删除域名 [domain]",
                    "paramKeys": []
                }
            }
        },
        "/websites/leech": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取防盗链配置",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Website"
                ],
                "summary": "Get AntiLeech conf",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.NginxCommonReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/websites/leech/update": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "更新防盗链配置",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Website"
                ],
                "summary": "Update AntiLeech",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.NginxAntiLeechUpdate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/websites/list": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取网站列表",
                "tags": [
                    "Website"
                ],
                "summary": "List websites",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/response.WebsiteDTO"
                            }
                        }
                    }
                }
            }
        },
        "/websites/log": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "操作网站日志",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Website"
                ],
                "summary": "Operate website log",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.WebsiteLogReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/response.WebsiteLog"
                        }
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [
                        {
                            "db": "websites",
                            "input_column": "id",
                            "input_value": "id",
                            "isList": false,
                            "output_column": "primary_domain",
                            "output_value": "domain"
                        }
                    ],
                    "bodyKeys": [
                        "id",
                        "operate"
                    ],
                    "formatEN": "[domain][operate] logs",
                    "formatZH": "[domain][operate] 日志",
                    "paramKeys": []
                }
            }
        },
        "/websites/nginx/update": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "更新 网站 nginx 配置",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Website Nginx"
                ],
                "summary": "Update website nginx conf",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.WebsiteNginxUpdate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [
                        {
                            "db": "websites",
                            "input_column": "id",
                            "input_value": "id",
                            "isList": false,
                            "output_column": "primary_domain",
                            "output_value": "domain"
                        }
                    ],
                    "bodyKeys": [
                        "id"
                    ],
                    "formatEN": "[domain] Nginx conf update",
                    "formatZH": "[domain] Nginx 配置修改",
                    "paramKeys": []
                }
            }
        },
        "/websites/operate": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "操作网站",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Website"
                ],
                "summary": "Operate website",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.WebsiteOp"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [
                        {
                            "db": "websites",
                            "input_column": "id",
                            "input_value": "id",
                            "isList": false,
                            "output_column": "primary_domain",
                            "output_value": "domain"
                        }
                    ],
                    "bodyKeys": [
                        "id",
                        "operate"
                    ],
                    "formatEN": "[operate] website [domain]",
                    "formatZH": "[operate] 网站 [domain]",
                    "paramKeys": []
                }
            }
        },
        "/websites/options": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取网站列表",
                "tags": [
                    "Website"
                ],
                "summary": "List website names",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "type": "string"
                            }
                        }
                    }
                }
            }
        },
        "/websites/php/config": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "更新 网站 PHP 配置",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Website PHP"
                ],
                "summary": "Update website php conf",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.WebsitePHPConfigUpdate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [
                        {
                            "db": "websites",
                            "input_column": "id",
                            "input_value": "id",
                            "isList": false,
                            "output_column": "primary_domain",
                            "output_value": "domain"
                        }
                    ],
                    "bodyKeys": [
                        "id"
                    ],
                    "formatEN": "[domain] PHP conf update",
                    "formatZH": "[domain] PHP 配置修改",
                    "paramKeys": []
                }
            }
        },
        "/websites/php/config/:id": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取网站 php 配置",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Website"
                ],
                "summary": "Load websit php conf",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "request",
                        "name": "id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/response.PHPConfig"
                        }
                    }
                }
            }
        },
        "/websites/php/update": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "更新 php 配置文件",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Website PHP"
                ],
                "summary": "Update php conf",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.WebsitePHPFileUpdate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [
                        {
                            "db": "websites",
                            "input_column": "id",
                            "input_value": "websiteId",
                            "isList": false,
                            "output_column": "primary_domain",
                            "output_value": "domain"
                        }
                    ],
                    "bodyKeys": [
                        "websiteId"
                    ],
                    "formatEN": "Nginx conf update [domain]",
                    "formatZH": "php 配置修改 [domain]",
                    "paramKeys": []
                }
            }
        },
        "/websites/php/version": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "变更 php 版本",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Website PHP"
                ],
                "summary": "Update php version",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.WebsitePHPVersionReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [
                        {
                            "db": "websites",
                            "input_column": "id",
                            "input_value": "websiteId",
                            "isList": false,
                            "output_column": "primary_domain",
                            "output_value": "domain"
                        }
                    ],
                    "bodyKeys": [
                        "websiteId"
                    ],
                    "formatEN": "php version update [domain]",
                    "formatZH": "php 版本变更 [domain]",
                    "paramKeys": []
                }
            }
        },
        "/websites/proxies": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取反向代理配置",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Website"
                ],
                "summary": "Get proxy conf",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.WebsiteProxyReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/websites/proxies/update": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "修改反向代理配置",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Website"
                ],
                "summary": "Update proxy conf",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.WebsiteProxyConfig"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [
                        {
                            "db": "websites",
                            "input_column": "id",
                            "input_value": "id",
                            "isList": false,
                            "output_column": "primary_domain",
                            "output_value": "domain"
                        }
                    ],
                    "bodyKeys": [
                        "id"
                    ],
                    "formatEN": "Update domain [domain] proxy config",
                    "formatZH": "修改网站 [domain] 反向代理配置 ",
                    "paramKeys": []
                }
            }
        },
        "/websites/proxy/file": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "更新反向代理文件",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Website"
                ],
                "summary": "Update proxy file",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.NginxProxyUpdate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [
                        {
                            "db": "websites",
                            "input_column": "id",
                            "input_value": "websiteID",
                            "isList": false,
                            "output_column": "primary_domain",
                            "output_value": "domain"
                        }
                    ],
                    "bodyKeys": [
                        "websiteID"
                    ],
                    "formatEN": "Nginx conf proxy file update [domain]",
                    "formatZH": "更新反向代理文件 [domain]",
                    "paramKeys": []
                }
            }
        },
        "/websites/redirect": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取重定向配置",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Website"
                ],
                "summary": "Get redirect conf",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.WebsiteProxyReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/websites/redirect/file": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "更新重定向文件",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Website"
                ],
                "summary": "Update redirect file",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.NginxRedirectUpdate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [
                        {
                            "db": "websites",
                            "input_column": "id",
                            "input_value": "websiteID",
                            "isList": false,
                            "output_column": "primary_domain",
                            "output_value": "domain"
                        }
                    ],
                    "bodyKeys": [
                        "websiteID"
                    ],
                    "formatEN": "Nginx conf redirect file update [domain]",
                    "formatZH": "更新重定向文件 [domain]",
                    "paramKeys": []
                }
            }
        },
        "/websites/redirect/update": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "修改重定向配置",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Website"
                ],
                "summary": "Update redirect conf",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.NginxRedirectReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [
                        {
                            "db": "websites",
                            "input_column": "id",
                            "input_value": "websiteID",
                            "isList": false,
                            "output_column": "primary_domain",
                            "output_value": "domain"
                        }
                    ],
                    "bodyKeys": [
                        "websiteID"
                    ],
                    "formatEN": "Update domain [domain] redirect config",
                    "formatZH": "修改网站 [domain] 重定向理配置 ",
                    "paramKeys": []
                }
            }
        },
        "/websites/rewrite": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取伪静态配置",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Website"
                ],
                "summary": "Get rewrite conf",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.NginxRewriteReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/websites/rewrite/update": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "更新伪静态配置",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Website"
                ],
                "summary": "Update rewrite conf",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.NginxRewriteUpdate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [
                        {
                            "db": "websites",
                            "input_column": "id",
                            "input_value": "websiteID",
                            "isList": false,
                            "output_column": "primary_domain",
                            "output_value": "domain"
                        }
                    ],
                    "bodyKeys": [
                        "websiteID"
                    ],
                    "formatEN": "Nginx conf rewrite update [domain]",
                    "formatZH": "伪静态配置修改 [domain]",
                    "paramKeys": []
                }
            }
        },
        "/websites/search": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取网站列表分页",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Website"
                ],
                "summary": "Page websites",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.WebsiteSearch"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/dto.PageResult"
                        }
                    }
                }
            }
        },
        "/websites/ssl": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "创建网站 ssl",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Website SSL"
                ],
                "summary": "Create website ssl",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.WebsiteSSLCreate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/request.WebsiteSSLCreate"
                        }
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "primaryDomain"
                    ],
                    "formatEN": "Create website ssl [primaryDomain]",
                    "formatZH": "创建网站 ssl [primaryDomain]",
                    "paramKeys": []
                }
            }
        },
        "/websites/ssl/:id": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "通过 id 查询 ssl",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Website SSL"
                ],
                "summary": "Search website ssl by id",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "request",
                        "name": "id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/websites/ssl/del": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "删除网站 ssl",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Website SSL"
                ],
                "summary": "Delete website ssl",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.WebsiteResourceReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [
                        {
                            "db": "website_ssls",
                            "input_column": "id",
                            "input_value": "id",
                            "isList": false,
                            "output_column": "primary_domain",
                            "output_value": "domain"
                        }
                    ],
                    "bodyKeys": [
                        "id"
                    ],
                    "formatEN": "Delete ssl [domain]",
                    "formatZH": "删除 ssl [domain]",
                    "paramKeys": []
                }
            }
        },
        "/websites/ssl/renew": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "重置网站 ssl",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Website SSL"
                ],
                "summary": "Reset website ssl",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.WebsiteSSLRenew"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [
                        {
                            "db": "website_ssls",
                            "input_column": "id",
                            "input_value": "SSLId",
                            "isList": false,
                            "output_column": "primary_domain",
                            "output_value": "domain"
                        }
                    ],
                    "bodyKeys": [
                        "SSLId"
                    ],
                    "formatEN": "Renew ssl [domain]",
                    "formatZH": "重置 ssl [domain]",
                    "paramKeys": []
                }
            }
        },
        "/websites/ssl/resolve": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "解析网站 ssl",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Website SSL"
                ],
                "summary": "Resolve website ssl",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.WebsiteDNSReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/response.WebsiteDNSRes"
                            }
                        }
                    }
                }
            }
        },
        "/websites/ssl/search": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取网站 ssl 列表分页",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Website SSL"
                ],
                "summary": "Page website ssl",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.WebsiteSSLSearch"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/websites/ssl/update": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "更新 ssl",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Website SSL"
                ],
                "summary": "Update ssl",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.WebsiteSSLUpdate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [
                        {
                            "db": "website_ssls",
                            "input_column": "id",
                            "input_value": "id",
                            "isList": false,
                            "output_column": "primary_domain",
                            "output_value": "domain"
                        }
                    ],
                    "bodyKeys": [
                        "id"
                    ],
                    "formatEN": "Update ssl config [domain]",
                    "formatZH": "更新证书设置 [domain]",
                    "paramKeys": []
                }
            }
        },
        "/websites/ssl/website/:websiteId": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "通过网站 id 查询 ssl",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Website SSL"
                ],
                "summary": "Search website ssl by website id",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "request",
                        "name": "websiteId",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/websites/update": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "更新网站",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Website"
                ],
                "summary": "Update website",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.WebsiteUpdate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [],
                    "bodyKeys": [
                        "primaryDomain"
                    ],
                    "formatEN": "Update website [primaryDomain]",
                    "formatZH": "更新网站 [primaryDomain]",
                    "paramKeys": []
                }
            }
        },
        "/websites/waf/config": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "获取网站 waf 配置",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Website WAF"
                ],
                "summary": "Load websit waf conf",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.WebsiteWafReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/response.WebsiteWafConfig"
                        }
                    }
                }
            }
        },
        "/websites/waf/file/update": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "更新 网站 waf 配置文件",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Website WAF"
                ],
                "summary": "Update website waf  file",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.WebsiteWafUpdate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [
                        {
                            "db": "websites",
                            "input_column": "id",
                            "input_value": "websiteId",
                            "isList": false,
                            "output_column": "primary_domain",
                            "output_value": "domain"
                        }
                    ],
                    "bodyKeys": [
                        "websiteId"
                    ],
                    "formatEN": "WAF conf file update [domain]",
                    "formatZH": "WAF 配置文件修改 [domain]",
                    "paramKeys": []
                }
            }
        },
        "/websites/waf/update": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "更新 网站 waf 配置",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Website WAF"
                ],
                "summary": "Update website waf conf",
                "parameters": [
                    {
                        "description": "request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/request.WebsiteWafUpdate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-panel-log": {
                    "BeforeFunctions": [
                        {
                            "db": "websites",
                            "input_column": "id",
                            "input_value": "websiteId",
                            "isList": false,
                            "output_column": "primary_domain",
                            "output_value": "domain"
                        }
                    ],
                    "bodyKeys": [
                        "websiteId"
                    ],
                    "formatEN": "WAF conf update [domain]",
                    "formatZH": "WAF 配置修改 [domain]",
                    "paramKeys": []
                }
            }
        }
    },
    "definitions": {
        "dto.AddrRuleOperate": {
            "type": "object",
            "required": [
                "address",
                "operation",
                "strategy"
            ],
            "properties": {
                "address": {
                    "type": "string"
                },
                "description": {
                    "type": "string"
                },
                "operation": {
                    "type": "string",
                    "enum": [
                        "add",
                        "remove"
                    ]
                },
                "strategy": {
                    "type": "string",
                    "enum": [
                        "accept",
                        "drop"
                    ]
                }
            }
        },
        "dto.AddrRuleUpdate": {
            "type": "object",
            "properties": {
                "newRule": {
                    "$ref": "#/definitions/dto.AddrRuleOperate"
                },
                "oldRule": {
                    "$ref": "#/definitions/dto.AddrRuleOperate"
                }
            }
        },
        "dto.AppInstallInfo": {
            "type": "object",
            "properties": {
                "id": {
                    "type": "integer"
                },
                "key": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                }
            }
        },
        "dto.AppResource": {
            "type": "object",
            "properties": {
                "name": {
                    "type": "string"
                },
                "type": {
                    "type": "string"
                }
            }
        },
        "dto.AppVersion": {
            "type": "object",
            "properties": {
                "detailId": {
                    "type": "integer"
                },
                "version": {
                    "type": "string"
                }
            }
        },
        "dto.BackupInfo": {
            "type": "object",
            "properties": {
                "backupPath": {
                    "type": "string"
                },
                "bucket": {
                    "type": "string"
                },
                "createdAt": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                },
                "type": {
                    "type": "string"
                },
                "vars": {
                    "type": "string"
                }
            }
        },
        "dto.BackupOperate": {
            "type": "object",
            "required": [
                "type",
                "vars"
            ],
            "properties": {
                "accessKey": {
                    "type": "string"
                },
                "backupPath": {
                    "type": "string"
                },
                "bucket": {
                    "type": "string"
                },
                "credential": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                },
                "type": {
                    "type": "string"
                },
                "vars": {
                    "type": "string"
                }
            }
        },
        "dto.BackupSearchFile": {
            "type": "object",
            "required": [
                "type"
            ],
            "properties": {
                "type": {
                    "type": "string"
                }
            }
        },
        "dto.BatchDelete": {
            "type": "object",
            "required": [
                "names"
            ],
            "properties": {
                "names": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                }
            }
        },
        "dto.BatchDeleteReq": {
            "type": "object",
            "required": [
                "ids"
            ],
            "properties": {
                "ids": {
                    "type": "array",
                    "items": {
                        "type": "integer"
                    }
                }
            }
        },
        "dto.BatchRuleOperate": {
            "type": "object",
            "required": [
                "type"
            ],
            "properties": {
                "rules": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/dto.PortRuleOperate"
                    }
                },
                "type": {
                    "type": "string"
                }
            }
        },
        "dto.CaptchaResponse": {
            "type": "object",
            "properties": {
                "captchaID": {
                    "type": "string"
                },
                "imagePath": {
                    "type": "string"
                }
            }
        },
        "dto.ChangeDBInfo": {
            "type": "object",
            "required": [
                "database",
                "from",
                "type",
                "value"
            ],
            "properties": {
                "database": {
                    "type": "string"
                },
                "from": {
                    "type": "string",
                    "enum": [
                        "local",
                        "remote"
                    ]
                },
                "id": {
                    "type": "integer"
                },
                "type": {
                    "type": "string",
                    "enum": [
                        "mysql",
                        "mariadb"
                    ]
                },
                "value": {
                    "type": "string"
                }
            }
        },
        "dto.ChangeHostGroup": {
            "type": "object",
            "required": [
                "groupID",
                "id"
            ],
            "properties": {
                "groupID": {
                    "type": "integer"
                },
                "id": {
                    "type": "integer"
                }
            }
        },
        "dto.ChangeRedisPass": {
            "type": "object",
            "required": [
                "value"
            ],
            "properties": {
                "value": {
                    "type": "string"
                }
            }
        },
        "dto.Clean": {
            "type": "object",
            "properties": {
                "name": {
                    "type": "string"
                },
                "size": {
                    "type": "integer"
                },
                "treeType": {
                    "type": "string"
                }
            }
        },
        "dto.CleanLog": {
            "type": "object",
            "required": [
                "logType"
            ],
            "properties": {
                "logType": {
                    "type": "string",
                    "enum": [
                        "login",
                        "operation"
                    ]
                }
            }
        },
        "dto.CommandInfo": {
            "type": "object",
            "properties": {
                "command": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                },
                "name": {
                    "type": "string"
                }
            }
        },
        "dto.CommandOperate": {
            "type": "object",
            "required": [
                "command",
                "name"
            ],
            "properties": {
                "command": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                },
                "name": {
                    "type": "string"
                }
            }
        },
        "dto.CommonBackup": {
            "type": "object",
            "required": [
                "type"
            ],
            "properties": {
                "detailName": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "type": {
                    "type": "string",
                    "enum": [
                        "app",
                        "mysql",
                        "mariadb",
                        "redis",
                        "website"
                    ]
                }
            }
        },
        "dto.CommonRecover": {
            "type": "object",
            "required": [
                "source",
                "type"
            ],
            "properties": {
                "detailName": {
                    "type": "string"
                },
                "file": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "source": {
                    "type": "string",
                    "enum": [
                        "OSS",
                        "S3",
                        "SFTP",
                        "MINIO",
                        "LOCAL",
                        "COS",
                        "KODO",
                        "OneDrive"
                    ]
                },
                "type": {
                    "type": "string",
                    "enum": [
                        "app",
                        "mysql",
                        "mariadb",
                        "redis",
                        "website"
                    ]
                }
            }
        },
        "dto.ComposeCreate": {
            "type": "object",
            "required": [
                "from"
            ],
            "properties": {
                "file": {
                    "type": "string"
                },
                "from": {
                    "type": "string",
                    "enum": [
                        "edit",
                        "path",
                        "template"
                    ]
                },
                "name": {
                    "type": "string"
                },
                "path": {
                    "type": "string"
                },
                "template": {
                    "type": "integer"
                }
            }
        },
        "dto.ComposeOperation": {
            "type": "object",
            "required": [
                "name",
                "operation",
                "path"
            ],
            "properties": {
                "name": {
                    "type": "string"
                },
                "operation": {
                    "type": "string",
                    "enum": [
                        "start",
                        "stop",
                        "down"
                    ]
                },
                "path": {
                    "type": "string"
                },
                "withFile": {
                    "type": "boolean"
                }
            }
        },
        "dto.ComposeTemplateCreate": {
            "type": "object",
            "required": [
                "name"
            ],
            "properties": {
                "content": {
                    "type": "string"
                },
                "description": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                }
            }
        },
        "dto.ComposeTemplateInfo": {
            "type": "object",
            "properties": {
                "content": {
                    "type": "string"
                },
                "createdAt": {
                    "type": "string"
                },
                "description": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                },
                "name": {
                    "type": "string"
                }
            }
        },
        "dto.ComposeTemplateUpdate": {
            "type": "object",
            "properties": {
                "content": {
                    "type": "string"
                },
                "description": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                }
            }
        },
        "dto.ComposeUpdate": {
            "type": "object",
            "required": [
                "content",
                "name",
                "path"
            ],
            "properties": {
                "content": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "path": {
                    "type": "string"
                }
            }
        },
        "dto.ContainerListStats": {
            "type": "object",
            "properties": {
                "containerID": {
                    "type": "string"
                },
                "cpuPercent": {
                    "type": "number"
                },
                "cpuTotalUsage": {
                    "type": "integer"
                },
                "memoryCache": {
                    "type": "integer"
                },
                "memoryLimit": {
                    "type": "integer"
                },
                "memoryPercent": {
                    "type": "number"
                },
                "memoryUsage": {
                    "type": "integer"
                },
                "percpuUsage": {
                    "type": "integer"
                },
                "systemUsage": {
                    "type": "integer"
                }
            }
        },
        "dto.ContainerOperate": {
            "type": "object",
            "properties": {
                "autoRemove": {
                    "type": "boolean"
                },
                "cmd": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "containerID": {
                    "type": "string"
                },
                "cpuShares": {
                    "type": "integer"
                },
                "entrypoint": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "env": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "exposedPorts": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/dto.PortHelper"
                    }
                },
                "forcePull": {
                    "type": "boolean"
                },
                "image": {
                    "type": "string"
                },
                "labels": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "memory": {
                    "type": "number"
                },
                "name": {
                    "type": "string"
                },
                "nanoCPUs": {
                    "type": "number"
                },
                "network": {
                    "type": "string"
                },
                "openStdin": {
                    "type": "boolean"
                },
                "publishAllPorts": {
                    "type": "boolean"
                },
                "restartPolicy": {
                    "type": "string"
                },
                "tty": {
                    "type": "boolean"
                },
                "volumes": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/dto.VolumeHelper"
                    }
                }
            }
        },
        "dto.ContainerOperation": {
            "type": "object",
            "required": [
                "name",
                "operation"
            ],
            "properties": {
                "name": {
                    "type": "string"
                },
                "newName": {
                    "type": "string"
                },
                "operation": {
                    "type": "string",
                    "enum": [
                        "start",
                        "stop",
                        "restart",
                        "kill",
                        "pause",
                        "unpause",
                        "rename",
                        "remove"
                    ]
                }
            }
        },
        "dto.ContainerPrune": {
            "type": "object",
            "required": [
                "pruneType"
            ],
            "properties": {
                "pruneType": {
                    "type": "string",
                    "enum": [
                        "container",
                        "image",
                        "volume",
                        "network"
                    ]
                },
                "withTagAll": {
                    "type": "boolean"
                }
            }
        },
        "dto.ContainerPruneReport": {
            "type": "object",
            "properties": {
                "deletedNumber": {
                    "type": "integer"
                },
                "spaceReclaimed": {
                    "type": "integer"
                }
            }
        },
        "dto.ContainerStats": {
            "type": "object",
            "properties": {
                "cache": {
                    "type": "number"
                },
                "cpuPercent": {
                    "type": "number"
                },
                "ioRead": {
                    "type": "number"
                },
                "ioWrite": {
                    "type": "number"
                },
                "memory": {
                    "type": "number"
                },
                "networkRX": {
                    "type": "number"
                },
                "networkTX": {
                    "type": "number"
                },
                "shotTime": {
                    "type": "string"
                }
            }
        },
        "dto.ContainerUpgrade": {
            "type": "object",
            "required": [
                "image",
                "name"
            ],
            "properties": {
                "forcePull": {
                    "type": "boolean"
                },
                "image": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                }
            }
        },
        "dto.CronjobBatchDelete": {
            "type": "object",
            "properties": {
                "cleanData": {
                    "type": "boolean"
                },
                "ids": {
                    "type": "array",
                    "items": {
                        "type": "integer"
                    }
                }
            }
        },
        "dto.CronjobClean": {
            "type": "object",
            "required": [
                "cronjobID"
            ],
            "properties": {
                "cleanData": {
                    "type": "boolean"
                },
                "cronjobID": {
                    "type": "integer"
                }
            }
        },
        "dto.CronjobCreate": {
            "type": "object",
            "required": [
                "name",
                "specType",
                "type"
            ],
            "properties": {
                "appID": {
                    "type": "string"
                },
                "containerName": {
                    "type": "string"
                },
                "day": {
                    "type": "integer"
                },
                "dbName": {
                    "type": "string"
                },
                "exclusionRules": {
                    "type": "string"
                },
                "hour": {
                    "type": "integer"
                },
                "keepLocal": {
                    "type": "boolean"
                },
                "minute": {
                    "type": "integer"
                },
                "name": {
                    "type": "string"
                },
                "retainCopies": {
                    "type": "integer",
                    "minimum": 1
                },
                "script": {
                    "type": "string"
                },
                "second": {
                    "type": "integer"
                },
                "sourceDir": {
                    "type": "string"
                },
                "specType": {
                    "type": "string"
                },
                "targetDirID": {
                    "type": "integer"
                },
                "type": {
                    "type": "string"
                },
                "url": {
                    "type": "string"
                },
                "website": {
                    "type": "string"
                },
                "week": {
                    "type": "integer",
                    "maximum": 6,
                    "minimum": 0
                }
            }
        },
        "dto.CronjobDownload": {
            "type": "object",
            "required": [
                "backupAccountID",
                "recordID"
            ],
            "properties": {
                "backupAccountID": {
                    "type": "integer"
                },
                "recordID": {
                    "type": "integer"
                }
            }
        },
        "dto.CronjobUpdate": {
            "type": "object",
            "required": [
                "id",
                "name",
                "specType"
            ],
            "properties": {
                "appID": {
                    "type": "string"
                },
                "containerName": {
                    "type": "string"
                },
                "day": {
                    "type": "integer"
                },
                "dbName": {
                    "type": "string"
                },
                "exclusionRules": {
                    "type": "string"
                },
                "hour": {
                    "type": "integer"
                },
                "id": {
                    "type": "integer"
                },
                "keepLocal": {
                    "type": "boolean"
                },
                "minute": {
                    "type": "integer"
                },
                "name": {
                    "type": "string"
                },
                "retainCopies": {
                    "type": "integer",
                    "minimum": 1
                },
                "script": {
                    "type": "string"
                },
                "second": {
                    "type": "integer"
                },
                "sourceDir": {
                    "type": "string"
                },
                "specType": {
                    "type": "string"
                },
                "targetDirID": {
                    "type": "integer"
                },
                "url": {
                    "type": "string"
                },
                "website": {
                    "type": "string"
                },
                "week": {
                    "type": "integer",
                    "maximum": 6,
                    "minimum": 0
                }
            }
        },
        "dto.CronjobUpdateStatus": {
            "type": "object",
            "required": [
                "id",
                "status"
            ],
            "properties": {
                "id": {
                    "type": "integer"
                },
                "status": {
                    "type": "string"
                }
            }
        },
        "dto.DBBaseInfo": {
            "type": "object",
            "properties": {
                "containerName": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "port": {
                    "type": "integer"
                }
            }
        },
        "dto.DaemonJsonConf": {
            "type": "object",
            "properties": {
                "cgroupDriver": {
                    "type": "string"
                },
                "insecureRegistries": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "iptables": {
                    "type": "boolean"
                },
                "isSwarm": {
                    "type": "boolean"
                },
                "liveRestore": {
                    "type": "boolean"
                },
                "logMaxFile": {
                    "type": "string"
                },
                "logMaxSize": {
                    "type": "string"
                },
                "registryMirrors": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "status": {
                    "type": "string"
                },
                "version": {
                    "type": "string"
                }
            }
        },
        "dto.DaemonJsonUpdateByFile": {
            "type": "object",
            "properties": {
                "file": {
                    "type": "string"
                }
            }
        },
        "dto.DashboardBase": {
            "type": "object",
            "properties": {
                "appInstalledNumber": {
                    "type": "integer"
                },
                "cpuCores": {
                    "type": "integer"
                },
                "cpuLogicalCores": {
                    "type": "integer"
                },
                "cpuModelName": {
                    "type": "string"
                },
                "cronjobNumber": {
                    "type": "integer"
                },
                "currentInfo": {
                    "$ref": "#/definitions/dto.DashboardCurrent"
                },
                "databaseNumber": {
                    "type": "integer"
                },
                "hostname": {
                    "type": "string"
                },
                "kernelArch": {
                    "type": "string"
                },
                "kernelVersion": {
                    "type": "string"
                },
                "os": {
                    "type": "string"
                },
                "platform": {
                    "type": "string"
                },
                "platformFamily": {
                    "type": "string"
                },
                "platformVersion": {
                    "type": "string"
                },
                "virtualizationSystem": {
                    "type": "string"
                },
                "websiteNumber": {
                    "type": "integer"
                }
            }
        },
        "dto.DashboardCurrent": {
            "type": "object",
            "properties": {
                "MemoryUsedPercent": {
                    "type": "number"
                },
                "cpuPercent": {
                    "type": "array",
                    "items": {
                        "type": "number"
                    }
                },
                "cpuTotal": {
                    "type": "integer"
                },
                "cpuUsed": {
                    "type": "number"
                },
                "cpuUsedPercent": {
                    "type": "number"
                },
                "diskData": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/dto.DiskInfo"
                    }
                },
                "ioCount": {
                    "type": "integer"
                },
                "ioReadBytes": {
                    "type": "integer"
                },
                "ioReadTime": {
                    "type": "integer"
                },
                "ioWriteBytes": {
                    "type": "integer"
                },
                "ioWriteTime": {
                    "type": "integer"
                },
                "load1": {
                    "type": "number"
                },
                "load15": {
                    "type": "number"
                },
                "load5": {
                    "type": "number"
                },
                "loadUsagePercent": {
                    "type": "number"
                },
                "memoryAvailable": {
                    "type": "integer"
                },
                "memoryTotal": {
                    "type": "integer"
                },
                "memoryUsed": {
                    "type": "integer"
                },
                "netBytesRecv": {
                    "type": "integer"
                },
                "netBytesSent": {
                    "type": "integer"
                },
                "procs": {
                    "type": "integer"
                },
                "shotTime": {
                    "type": "string"
                },
                "timeSinceUptime": {
                    "type": "string"
                },
                "uptime": {
                    "type": "integer"
                }
            }
        },
        "dto.DatabaseCreate": {
            "type": "object",
            "required": [
                "from",
                "name",
                "password",
                "type",
                "username",
                "version"
            ],
            "properties": {
                "address": {
                    "type": "string"
                },
                "description": {
                    "type": "string"
                },
                "from": {
                    "type": "string",
                    "enum": [
                        "local",
                        "remote"
                    ]
                },
                "name": {
                    "type": "string",
                    "maxLength": 256
                },
                "password": {
                    "type": "string"
                },
                "port": {
                    "type": "integer"
                },
                "type": {
                    "type": "string"
                },
                "username": {
                    "type": "string"
                },
                "version": {
                    "type": "string"
                }
            }
        },
        "dto.DatabaseDelete": {
            "type": "object",
            "required": [
                "id"
            ],
            "properties": {
                "deleteBackup": {
                    "type": "boolean"
                },
                "forceDelete": {
                    "type": "boolean"
                },
                "id": {
                    "type": "integer"
                }
            }
        },
        "dto.DatabaseInfo": {
            "type": "object",
            "properties": {
                "address": {
                    "type": "string"
                },
                "createdAt": {
                    "type": "string"
                },
                "description": {
                    "type": "string"
                },
                "from": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                },
                "name": {
                    "type": "string",
                    "maxLength": 256
                },
                "password": {
                    "type": "string"
                },
                "port": {
                    "type": "integer"
                },
                "type": {
                    "type": "string"
                },
                "username": {
                    "type": "string"
                },
                "version": {
                    "type": "string"
                }
            }
        },
        "dto.DatabaseOption": {
            "type": "object",
            "properties": {
                "address": {
                    "type": "string"
                },
                "database": {
                    "type": "string"
                },
                "from": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                },
                "type": {
                    "type": "string"
                },
                "version": {
                    "type": "string"
                }
            }
        },
        "dto.DatabaseSearch": {
            "type": "object",
            "required": [
                "page",
                "pageSize"
            ],
            "properties": {
                "info": {
                    "type": "string"
                },
                "order": {
                    "type": "string"
                },
                "orderBy": {
                    "type": "string"
                },
                "page": {
                    "type": "integer"
                },
                "pageSize": {
                    "type": "integer"
                },
                "type": {
                    "type": "string"
                }
            }
        },
        "dto.DatabaseUpdate": {
            "type": "object",
            "required": [
                "password",
                "type",
                "username",
                "version"
            ],
            "properties": {
                "address": {
                    "type": "string"
                },
                "description": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                },
                "password": {
                    "type": "string"
                },
                "port": {
                    "type": "integer"
                },
                "type": {
                    "type": "string"
                },
                "username": {
                    "type": "string"
                },
                "version": {
                    "type": "string"
                }
            }
        },
        "dto.DiskInfo": {
            "type": "object",
            "properties": {
                "device": {
                    "type": "string"
                },
                "free": {
                    "type": "integer"
                },
                "inodesFree": {
                    "type": "integer"
                },
                "inodesTotal": {
                    "type": "integer"
                },
                "inodesUsed": {
                    "type": "integer"
                },
                "inodesUsedPercent": {
                    "type": "number"
                },
                "path": {
                    "type": "string"
                },
                "total": {
                    "type": "integer"
                },
                "type": {
                    "type": "string"
                },
                "used": {
                    "type": "integer"
                },
                "usedPercent": {
                    "type": "number"
                }
            }
        },
        "dto.DockerOperation": {
            "type": "object",
            "required": [
                "operation"
            ],
            "properties": {
                "operation": {
                    "type": "string",
                    "enum": [
                        "start",
                        "restart",
                        "stop"
                    ]
                }
            }
        },
        "dto.DownloadRecord": {
            "type": "object",
            "required": [
                "fileDir",
                "fileName",
                "source"
            ],
            "properties": {
                "fileDir": {
                    "type": "string"
                },
                "fileName": {
                    "type": "string"
                },
                "source": {
                    "type": "string",
                    "enum": [
                        "OSS",
                        "S3",
                        "SFTP",
                        "MINIO",
                        "LOCAL",
                        "COS",
                        "KODO",
                        "OneDrive"
                    ]
                }
            }
        },
        "dto.FirewallBaseInfo": {
            "type": "object",
            "properties": {
                "name": {
                    "type": "string"
                },
                "pingStatus": {
                    "type": "string"
                },
                "status": {
                    "type": "string"
                },
                "version": {
                    "type": "string"
                }
            }
        },
        "dto.FirewallOperation": {
            "type": "object",
            "required": [
                "operation"
            ],
            "properties": {
                "operation": {
                    "type": "string",
                    "enum": [
                        "start",
                        "stop",
                        "disablePing",
                        "enablePing"
                    ]
                }
            }
        },
        "dto.ForBuckets": {
            "type": "object",
            "required": [
                "credential",
                "type",
                "vars"
            ],
            "properties": {
                "accessKey": {
                    "type": "string"
                },
                "credential": {
                    "type": "string"
                },
                "type": {
                    "type": "string"
                },
                "vars": {
                    "type": "string"
                }
            }
        },
        "dto.GenerateLoad": {
            "type": "object",
            "required": [
                "encryptionMode"
            ],
            "properties": {
                "encryptionMode": {
                    "type": "string",
                    "enum": [
                        "rsa",
                        "ed25519",
                        "ecdsa",
                        "dsa"
                    ]
                }
            }
        },
        "dto.GenerateSSH": {
            "type": "object",
            "required": [
                "encryptionMode"
            ],
            "properties": {
                "encryptionMode": {
                    "type": "string",
                    "enum": [
                        "rsa",
                        "ed25519",
                        "ecdsa",
                        "dsa"
                    ]
                },
                "password": {
                    "type": "string"
                }
            }
        },
        "dto.GroupCreate": {
            "type": "object",
            "required": [
                "name",
                "type"
            ],
            "properties": {
                "id": {
                    "type": "integer"
                },
                "name": {
                    "type": "string"
                },
                "type": {
                    "type": "string"
                }
            }
        },
        "dto.GroupInfo": {
            "type": "object",
            "properties": {
                "id": {
                    "type": "integer"
                },
                "isDefault": {
                    "type": "boolean"
                },
                "name": {
                    "type": "string"
                },
                "type": {
                    "type": "string"
                }
            }
        },
        "dto.GroupSearch": {
            "type": "object",
            "required": [
                "type"
            ],
            "properties": {
                "type": {
                    "type": "string"
                }
            }
        },
        "dto.GroupUpdate": {
            "type": "object",
            "required": [
                "type"
            ],
            "properties": {
                "id": {
                    "type": "integer"
                },
                "isDefault": {
                    "type": "boolean"
                },
                "name": {
                    "type": "string"
                },
                "type": {
                    "type": "string"
                }
            }
        },
        "dto.HostConnTest": {
            "type": "object",
            "required": [
                "addr",
                "port",
                "user"
            ],
            "properties": {
                "addr": {
                    "type": "string"
                },
                "authMode": {
                    "type": "string",
                    "enum": [
                        "password",
                        "key"
                    ]
                },
                "passPhrase": {
                    "type": "string"
                },
                "password": {
                    "type": "string"
                },
                "port": {
                    "type": "integer",
                    "maximum": 65535,
                    "minimum": 1
                },
                "privateKey": {
                    "type": "string"
                },
                "user": {
                    "type": "string"
                }
            }
        },
        "dto.HostOperate": {
            "type": "object",
            "required": [
                "addr",
                "port",
                "user"
            ],
            "properties": {
                "addr": {
                    "type": "string"
                },
                "authMode": {
                    "type": "string",
                    "enum": [
                        "password",
                        "key"
                    ]
                },
                "description": {
                    "type": "string"
                },
                "groupID": {
                    "type": "integer"
                },
                "id": {
                    "type": "integer"
                },
                "name": {
                    "type": "string"
                },
                "passPhrase": {
                    "type": "string"
                },
                "password": {
                    "type": "string"
                },
                "port": {
                    "type": "integer",
                    "maximum": 65535,
                    "minimum": 1
                },
                "privateKey": {
                    "type": "string"
                },
                "rememberPassword": {
                    "type": "boolean"
                },
                "user": {
                    "type": "string"
                }
            }
        },
        "dto.HostTree": {
            "type": "object",
            "properties": {
                "children": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/dto.TreeChild"
                    }
                },
                "id": {
                    "type": "integer"
                },
                "label": {
                    "type": "string"
                }
            }
        },
        "dto.ImageBuild": {
            "type": "object",
            "required": [
                "dockerfile",
                "from",
                "name"
            ],
            "properties": {
                "dockerfile": {
                    "type": "string"
                },
                "from": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "tags": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                }
            }
        },
        "dto.ImageLoad": {
            "type": "object",
            "required": [
                "path"
            ],
            "properties": {
                "path": {
                    "type": "string"
                }
            }
        },
        "dto.ImagePull": {
            "type": "object",
            "required": [
                "imageName"
            ],
            "properties": {
                "imageName": {
                    "type": "string"
                },
                "repoID": {
                    "type": "integer"
                }
            }
        },
        "dto.ImagePush": {
            "type": "object",
            "required": [
                "name",
                "repoID",
                "tagName"
            ],
            "properties": {
                "name": {
                    "type": "string"
                },
                "repoID": {
                    "type": "integer"
                },
                "tagName": {
                    "type": "string"
                }
            }
        },
        "dto.ImageRepoDelete": {
            "type": "object",
            "required": [
                "ids"
            ],
            "properties": {
                "ids": {
                    "type": "array",
                    "items": {
                        "type": "integer"
                    }
                }
            }
        },
        "dto.ImageRepoOption": {
            "type": "object",
            "properties": {
                "downloadUrl": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                },
                "name": {
                    "type": "string"
                }
            }
        },
        "dto.ImageRepoUpdate": {
            "type": "object",
            "properties": {
                "auth": {
                    "type": "boolean"
                },
                "downloadUrl": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                },
                "password": {
                    "type": "string",
                    "maxLength": 256
                },
                "protocol": {
                    "type": "string"
                },
                "username": {
                    "type": "string",
                    "maxLength": 256
                }
            }
        },
        "dto.ImageSave": {
            "type": "object",
            "required": [
                "name",
                "path",
                "tagName"
            ],
            "properties": {
                "name": {
                    "type": "string"
                },
                "path": {
                    "type": "string"
                },
                "tagName": {
                    "type": "string"
                }
            }
        },
        "dto.ImageTag": {
            "type": "object",
            "required": [
                "sourceID",
                "targetName"
            ],
            "properties": {
                "repoID": {
                    "type": "integer"
                },
                "sourceID": {
                    "type": "string"
                },
                "targetName": {
                    "type": "string"
                }
            }
        },
        "dto.InspectReq": {
            "type": "object",
            "properties": {
                "id": {
                    "type": "string"
                },
                "type": {
                    "type": "string"
                }
            }
        },
        "dto.LogOption": {
            "type": "object",
            "properties": {
                "logMaxFile": {
                    "type": "string"
                },
                "logMaxSize": {
                    "type": "string"
                }
            }
        },
        "dto.Login": {
            "type": "object",
            "properties": {
                "authMethod": {
                    "type": "string"
                },
                "captcha": {
                    "type": "string"
                },
                "captchaID": {
                    "type": "string"
                },
                "ignoreCaptcha": {
                    "type": "boolean"
                },
                "language": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "password": {
                    "type": "string"
                }
            }
        },
        "dto.MFALogin": {
            "type": "object",
            "properties": {
                "authMethod": {
                    "type": "string"
                },
                "code": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "password": {
                    "type": "string"
                }
            }
        },
        "dto.MfaCredential": {
            "type": "object",
            "properties": {
                "code": {
                    "type": "string"
                },
                "interval": {
                    "type": "string"
                },
                "secret": {
                    "type": "string"
                }
            }
        },
        "dto.MysqlConfUpdateByFile": {
            "type": "object",
            "required": [
                "database",
                "type"
            ],
            "properties": {
                "database": {
                    "type": "string"
                },
                "file": {
                    "type": "string"
                },
                "type": {
                    "type": "string",
                    "enum": [
                        "mysql",
                        "mariadb"
                    ]
                }
            }
        },
        "dto.MysqlDBCreate": {
            "type": "object",
            "required": [
                "database",
                "format",
                "from",
                "name",
                "password",
                "permission",
                "username"
            ],
            "properties": {
                "database": {
                    "type": "string"
                },
                "description": {
                    "type": "string"
                },
                "format": {
                    "type": "string",
                    "enum": [
                        "utf8mb4",
                        "utf8",
                        "gbk",
                        "big5"
                    ]
                },
                "from": {
                    "type": "string",
                    "enum": [
                        "local",
                        "remote"
                    ]
                },
                "name": {
                    "type": "string"
                },
                "password": {
                    "type": "string"
                },
                "permission": {
                    "type": "string"
                },
                "username": {
                    "type": "string"
                }
            }
        },
        "dto.MysqlDBDelete": {
            "type": "object",
            "required": [
                "database",
                "id",
                "type"
            ],
            "properties": {
                "database": {
                    "type": "string"
                },
                "deleteBackup": {
                    "type": "boolean"
                },
                "forceDelete": {
                    "type": "boolean"
                },
                "id": {
                    "type": "integer"
                },
                "type": {
                    "type": "string",
                    "enum": [
                        "mysql",
                        "mariadb"
                    ]
                }
            }
        },
        "dto.MysqlDBDeleteCheck": {
            "type": "object",
            "required": [
                "database",
                "id",
                "type"
            ],
            "properties": {
                "database": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                },
                "type": {
                    "type": "string",
                    "enum": [
                        "mysql",
                        "mariadb"
                    ]
                }
            }
        },
        "dto.MysqlDBSearch": {
            "type": "object",
            "required": [
                "database",
                "page",
                "pageSize"
            ],
            "properties": {
                "database": {
                    "type": "string"
                },
                "info": {
                    "type": "string"
                },
                "order": {
                    "type": "string"
                },
                "orderBy": {
                    "type": "string"
                },
                "page": {
                    "type": "integer"
                },
                "pageSize": {
                    "type": "integer"
                }
            }
        },
        "dto.MysqlLoadDB": {
            "type": "object",
            "required": [
                "database",
                "from",
                "type"
            ],
            "properties": {
                "database": {
                    "type": "string"
                },
                "from": {
                    "type": "string",
                    "enum": [
                        "local",
                        "remote"
                    ]
                },
                "type": {
                    "type": "string",
                    "enum": [
                        "mysql",
                        "mariadb"
                    ]
                }
            }
        },
        "dto.MysqlOption": {
            "type": "object",
            "properties": {
                "database": {
                    "type": "string"
                },
                "from": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                },
                "name": {
                    "type": "string"
                },
                "type": {
                    "type": "string"
                }
            }
        },
        "dto.MysqlStatus": {
            "type": "object",
            "properties": {
                "Aborted_clients": {
                    "type": "string"
                },
                "Aborted_connects": {
                    "type": "string"
                },
                "Bytes_received": {
                    "type": "string"
                },
                "Bytes_sent": {
                    "type": "string"
                },
                "Com_commit": {
                    "type": "string"
                },
                "Com_rollback": {
                    "type": "string"
                },
                "Connections": {
                    "type": "string"
                },
                "Created_tmp_disk_tables": {
                    "type": "string"
                },
                "Created_tmp_tables": {
                    "type": "string"
                },
                "File": {
                    "type": "string"
                },
                "Innodb_buffer_pool_pages_dirty": {
                    "type": "string"
                },
                "Innodb_buffer_pool_read_requests": {
                    "type": "string"
                },
                "Innodb_buffer_pool_reads": {
                    "type": "string"
                },
                "Key_read_requests": {
                    "type": "string"
                },
                "Key_reads": {
                    "type": "string"
                },
                "Key_write_requests": {
                    "type": "string"
                },
                "Key_writes": {
                    "type": "string"
                },
                "Max_used_connections": {
                    "type": "string"
                },
                "Open_tables": {
                    "type": "string"
                },
                "Opened_files": {
                    "type": "string"
                },
                "Opened_tables": {
                    "type": "string"
                },
                "Position": {
                    "type": "string"
                },
                "Qcache_hits": {
                    "type": "string"
                },
                "Qcache_inserts": {
                    "type": "string"
                },
                "Questions": {
                    "type": "string"
                },
                "Run": {
                    "type": "string"
                },
                "Select_full_join": {
                    "type": "string"
                },
                "Select_range_check": {
                    "type": "string"
                },
                "Sort_merge_passes": {
                    "type": "string"
                },
                "Table_locks_waited": {
                    "type": "string"
                },
                "Threads_cached": {
                    "type": "string"
                },
                "Threads_connected": {
                    "type": "string"
                },
                "Threads_created": {
                    "type": "string"
                },
                "Threads_running": {
                    "type": "string"
                },
                "Uptime": {
                    "type": "string"
                }
            }
        },
        "dto.MysqlVariables": {
            "type": "object",
            "properties": {
                "binlog_cache_size": {
                    "type": "string"
                },
                "innodb_buffer_pool_size": {
                    "type": "string"
                },
                "innodb_log_buffer_size": {
                    "type": "string"
                },
                "join_buffer_size": {
                    "type": "string"
                },
                "key_buffer_size": {
                    "type": "string"
                },
                "long_query_time": {
                    "type": "string"
                },
                "max_connections": {
                    "type": "string"
                },
                "max_heap_table_size": {
                    "type": "string"
                },
                "query_cache_size": {
                    "type": "string"
                },
                "query_cache_type": {
                    "type": "string"
                },
                "read_buffer_size": {
                    "type": "string"
                },
                "read_rnd_buffer_size": {
                    "type": "string"
                },
                "slow_query_log": {
                    "type": "string"
                },
                "sort_buffer_size": {
                    "type": "string"
                },
                "table_open_cache": {
                    "type": "string"
                },
                "thread_cache_size": {
                    "type": "string"
                },
                "thread_stack": {
                    "type": "string"
                },
                "tmp_table_size": {
                    "type": "string"
                }
            }
        },
        "dto.MysqlVariablesUpdate": {
            "type": "object",
            "required": [
                "database",
                "type"
            ],
            "properties": {
                "database": {
                    "type": "string"
                },
                "type": {
                    "type": "string",
                    "enum": [
                        "mysql",
                        "mariadb"
                    ]
                },
                "variables": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/dto.MysqlVariablesUpdateHelper"
                    }
                }
            }
        },
        "dto.MysqlVariablesUpdateHelper": {
            "type": "object",
            "properties": {
                "param": {
                    "type": "string"
                },
                "value": {}
            }
        },
        "dto.NetworkCreate": {
            "type": "object",
            "properties": {
                "driver": {
                    "type": "string"
                },
                "gateway": {
                    "type": "string"
                },
                "ipRange": {
                    "type": "string"
                },
                "labels": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "name": {
                    "type": "string"
                },
                "options": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "subnet": {
                    "type": "string"
                }
            }
        },
        "dto.NginxKey": {
            "type": "string",
            "enum": [
                "index",
                "limit-conn",
                "ssl",
                "cache",
                "http-per",
                "proxy-cache"
            ],
            "x-enum-varnames": [
                "Index",
                "LimitConn",
                "SSL",
                "CACHE",
                "HttpPer",
                "ProxyCache"
            ]
        },
        "dto.Operate": {
            "type": "object",
            "required": [
                "operation"
            ],
            "properties": {
                "operation": {
                    "type": "string"
                }
            }
        },
        "dto.OperateByID": {
            "type": "object",
            "required": [
                "id"
            ],
            "properties": {
                "id": {
                    "type": "integer"
                }
            }
        },
        "dto.OperationWithName": {
            "type": "object",
            "required": [
                "name"
            ],
            "properties": {
                "name": {
                    "type": "string"
                }
            }
        },
        "dto.OperationWithNameAndType": {
            "type": "object",
            "required": [
                "name",
                "type"
            ],
            "properties": {
                "name": {
                    "type": "string"
                },
                "type": {
                    "type": "string"
                }
            }
        },
        "dto.Options": {
            "type": "object",
            "properties": {
                "option": {
                    "type": "string"
                }
            }
        },
        "dto.PageContainer": {
            "type": "object",
            "required": [
                "page",
                "pageSize"
            ],
            "properties": {
                "filters": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "order": {
                    "type": "string"
                },
                "orderBy": {
                    "type": "string"
                },
                "page": {
                    "type": "integer"
                },
                "pageSize": {
                    "type": "integer"
                }
            }
        },
        "dto.PageInfo": {
            "type": "object",
            "required": [
                "page",
                "pageSize"
            ],
            "properties": {
                "page": {
                    "type": "integer"
                },
                "pageSize": {
                    "type": "integer"
                }
            }
        },
        "dto.PageResult": {
            "type": "object",
            "properties": {
                "items": {},
                "total": {
                    "type": "integer"
                }
            }
        },
        "dto.PasswordUpdate": {
            "type": "object",
            "required": [
                "newPassword",
                "oldPassword"
            ],
            "properties": {
                "newPassword": {
                    "type": "string"
                },
                "oldPassword": {
                    "type": "string"
                }
            }
        },
        "dto.PortHelper": {
            "type": "object",
            "properties": {
                "containerPort": {
                    "type": "string"
                },
                "hostIP": {
                    "type": "string"
                },
                "hostPort": {
                    "type": "string"
                },
                "protocol": {
                    "type": "string"
                }
            }
        },
        "dto.PortRuleOperate": {
            "type": "object",
            "required": [
                "operation",
                "port",
                "protocol",
                "strategy"
            ],
            "properties": {
                "address": {
                    "type": "string"
                },
                "description": {
                    "type": "string"
                },
                "operation": {
                    "type": "string",
                    "enum": [
                        "add",
                        "remove"
                    ]
                },
                "port": {
                    "type": "string"
                },
                "protocol": {
                    "type": "string",
                    "enum": [
                        "tcp",
                        "udp",
                        "tcp/udp"
                    ]
                },
                "strategy": {
                    "type": "string",
                    "enum": [
                        "accept",
                        "drop"
                    ]
                }
            }
        },
        "dto.PortRuleUpdate": {
            "type": "object",
            "properties": {
                "newRule": {
                    "$ref": "#/definitions/dto.PortRuleOperate"
                },
                "oldRule": {
                    "$ref": "#/definitions/dto.PortRuleOperate"
                }
            }
        },
        "dto.PortUpdate": {
            "type": "object",
            "required": [
                "serverPort"
            ],
            "properties": {
                "serverPort": {
                    "type": "integer",
                    "maximum": 65535,
                    "minimum": 1
                }
            }
        },
        "dto.RecordSearch": {
            "type": "object",
            "required": [
                "name",
                "page",
                "pageSize",
                "type"
            ],
            "properties": {
                "detailName": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "page": {
                    "type": "integer"
                },
                "pageSize": {
                    "type": "integer"
                },
                "type": {
                    "type": "string"
                }
            }
        },
        "dto.RedisConf": {
            "type": "object",
            "properties": {
                "containerName": {
                    "type": "string"
                },
                "maxclients": {
                    "type": "string"
                },
                "maxmemory": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "port": {
                    "type": "integer"
                },
                "requirepass": {
                    "type": "string"
                },
                "timeout": {
                    "type": "string"
                }
            }
        },
        "dto.RedisConfPersistenceUpdate": {
            "type": "object",
            "required": [
                "type"
            ],
            "properties": {
                "appendfsync": {
                    "type": "string"
                },
                "appendonly": {
                    "type": "string"
                },
                "save": {
                    "type": "string"
                },
                "type": {
                    "type": "string",
                    "enum": [
                        "aof",
                        "rbd"
                    ]
                }
            }
        },
        "dto.RedisConfUpdate": {
            "type": "object",
            "properties": {
                "maxclients": {
                    "type": "string"
                },
                "maxmemory": {
                    "type": "string"
                },
                "timeout": {
                    "type": "string"
                }
            }
        },
        "dto.RedisConfUpdateByFile": {
            "type": "object",
            "properties": {
                "file": {
                    "type": "string"
                },
                "restartNow": {
                    "type": "boolean"
                }
            }
        },
        "dto.RedisPersistence": {
            "type": "object",
            "properties": {
                "appendfsync": {
                    "type": "string"
                },
                "appendonly": {
                    "type": "string"
                },
                "save": {
                    "type": "string"
                }
            }
        },
        "dto.RedisStatus": {
            "type": "object",
            "properties": {
                "connected_clients": {
                    "type": "string"
                },
                "instantaneous_ops_per_sec": {
                    "type": "string"
                },
                "keyspace_hits": {
                    "type": "string"
                },
                "keyspace_misses": {
                    "type": "string"
                },
                "latest_fork_usec": {
                    "type": "string"
                },
                "mem_fragmentation_ratio": {
                    "type": "string"
                },
                "tcp_port": {
                    "type": "string"
                },
                "total_commands_processed": {
                    "type": "string"
                },
                "total_connections_received": {
                    "type": "string"
                },
                "uptime_in_days": {
                    "type": "string"
                },
                "used_memory": {
                    "type": "string"
                },
                "used_memory_peak": {
                    "type": "string"
                },
                "used_memory_rss": {
                    "type": "string"
                }
            }
        },
        "dto.ResourceLimit": {
            "type": "object",
            "properties": {
                "cpu": {
                    "type": "integer"
                },
                "memory": {
                    "type": "integer"
                }
            }
        },
        "dto.SSHConf": {
            "type": "object",
            "properties": {
                "file": {
                    "type": "string"
                }
            }
        },
        "dto.SSHHistory": {
            "type": "object",
            "properties": {
                "address": {
                    "type": "string"
                },
                "area": {
                    "type": "string"
                },
                "authMode": {
                    "type": "string"
                },
                "date": {
                    "type": "string"
                },
                "dateStr": {
                    "type": "string"
                },
                "message": {
                    "type": "string"
                },
                "port": {
                    "type": "string"
                },
                "status": {
                    "type": "string"
                },
                "user": {
                    "type": "string"
                }
            }
        },
        "dto.SSHInfo": {
            "type": "object",
            "properties": {
                "listenAddress": {
                    "type": "string"
                },
                "message": {
                    "type": "string"
                },
                "passwordAuthentication": {
                    "type": "string"
                },
                "permitRootLogin": {
                    "type": "string"
                },
                "port": {
                    "type": "string"
                },
                "pubkeyAuthentication": {
                    "type": "string"
                },
                "status": {
                    "type": "string"
                },
                "useDNS": {
                    "type": "string"
                }
            }
        },
        "dto.SSHLog": {
            "type": "object",
            "properties": {
                "failedCount": {
                    "type": "integer"
                },
                "logs": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/dto.SSHHistory"
                    }
                },
                "successfulCount": {
                    "type": "integer"
                },
                "totalCount": {
                    "type": "integer"
                }
            }
        },
        "dto.SSHLogAnalysis": {
            "type": "object",
            "properties": {
                "address": {
                    "type": "string"
                },
                "area": {
                    "type": "string"
                },
                "failedCount": {
                    "type": "integer"
                },
                "status": {
                    "type": "string"
                },
                "successfulCount": {
                    "type": "integer"
                }
            }
        },
        "dto.SSLUpdate": {
            "type": "object",
            "required": [
                "ssl"
            ],
            "properties": {
                "cert": {
                    "type": "string"
                },
                "domain": {
                    "type": "string"
                },
                "key": {
                    "type": "string"
                },
                "ssl": {
                    "type": "string",
                    "enum": [
                        "enable",
                        "disable"
                    ]
                },
                "sslID": {
                    "type": "integer"
                },
                "sslType": {
                    "type": "string"
                }
            }
        },
        "dto.SearchForAnalysis": {
            "type": "object",
            "required": [
                "orderBy",
                "page",
                "pageSize"
            ],
            "properties": {
                "orderBy": {
                    "type": "string",
                    "enum": [
                        "Success",
                        "Failed"
                    ]
                },
                "page": {
                    "type": "integer"
                },
                "pageSize": {
                    "type": "integer"
                }
            }
        },
        "dto.SearchForTree": {
            "type": "object",
            "properties": {
                "info": {
                    "type": "string"
                }
            }
        },
        "dto.SearchHostWithPage": {
            "type": "object",
            "required": [
                "page",
                "pageSize"
            ],
            "properties": {
                "groupID": {
                    "type": "integer"
                },
                "info": {
                    "type": "string"
                },
                "page": {
                    "type": "integer"
                },
                "pageSize": {
                    "type": "integer"
                }
            }
        },
        "dto.SearchLgLogWithPage": {
            "type": "object",
            "required": [
                "page",
                "pageSize"
            ],
            "properties": {
                "ip": {
                    "type": "string"
                },
                "page": {
                    "type": "integer"
                },
                "pageSize": {
                    "type": "integer"
                },
                "status": {
                    "type": "string"
                }
            }
        },
        "dto.SearchOpLogWithPage": {
            "type": "object",
            "required": [
                "page",
                "pageSize"
            ],
            "properties": {
                "operation": {
                    "type": "string"
                },
                "page": {
                    "type": "integer"
                },
                "pageSize": {
                    "type": "integer"
                },
                "source": {
                    "type": "string"
                },
                "status": {
                    "type": "string"
                }
            }
        },
        "dto.SearchRecord": {
            "type": "object",
            "required": [
                "page",
                "pageSize"
            ],
            "properties": {
                "cronjobID": {
                    "type": "integer"
                },
                "endTime": {
                    "type": "string"
                },
                "page": {
                    "type": "integer"
                },
                "pageSize": {
                    "type": "integer"
                },
                "startTime": {
                    "type": "string"
                },
                "status": {
                    "type": "string"
                }
            }
        },
        "dto.SearchSSHLog": {
            "type": "object",
            "required": [
                "Status",
                "page",
                "pageSize"
            ],
            "properties": {
                "Status": {
                    "type": "string",
                    "enum": [
                        "Success",
                        "Failed",
                        "All"
                    ]
                },
                "info": {
                    "type": "string"
                },
                "page": {
                    "type": "integer"
                },
                "pageSize": {
                    "type": "integer"
                }
            }
        },
        "dto.SearchWithPage": {
            "type": "object",
            "required": [
                "page",
                "pageSize"
            ],
            "properties": {
                "info": {
                    "type": "string"
                },
                "order": {
                    "type": "string"
                },
                "orderBy": {
                    "type": "string"
                },
                "page": {
                    "type": "integer"
                },
                "pageSize": {
                    "type": "integer"
                }
            }
        },
        "dto.SettingInfo": {
            "type": "object",
            "properties": {
                "allowIPs": {
                    "type": "string"
                },
                "appStoreLastModified": {
                    "type": "string"
                },
                "appStoreVersion": {
                    "type": "string"
                },
                "bindDomain": {
                    "type": "string"
                },
                "complexityVerification": {
                    "type": "string"
                },
                "defaultNetwork": {
                    "type": "string"
                },
                "dingVars": {
                    "type": "string"
                },
                "email": {
                    "type": "string"
                },
                "emailVars": {
                    "type": "string"
                },
                "expirationDays": {
                    "type": "string"
                },
                "expirationTime": {
                    "type": "string"
                },
                "language": {
                    "type": "string"
                },
                "lastCleanData": {
                    "type": "string"
                },
                "lastCleanSize": {
                    "type": "string"
                },
                "lastCleanTime": {
                    "type": "string"
                },
                "localTime": {
                    "type": "string"
                },
                "messageType": {
                    "type": "string"
                },
                "mfaInterval": {
                    "type": "string"
                },
                "mfaSecret": {
                    "type": "string"
                },
                "mfaStatus": {
                    "type": "string"
                },
                "monitorInterval": {
                    "type": "string"
                },
                "monitorStatus": {
                    "type": "string"
                },
                "monitorStoreDays": {
                    "type": "string"
                },
                "ntpSite": {
                    "type": "string"
                },
                "panelName": {
                    "type": "string"
                },
                "port": {
                    "type": "string"
                },
                "securityEntrance": {
                    "type": "string"
                },
                "serverPort": {
                    "type": "string"
                },
                "sessionTimeout": {
                    "type": "string"
                },
                "ssl": {
                    "type": "string"
                },
                "sslType": {
                    "type": "string"
                },
                "systemIP": {
                    "type": "string"
                },
                "systemVersion": {
                    "type": "string"
                },
                "theme": {
                    "type": "string"
                },
                "timeZone": {
                    "type": "string"
                },
                "userName": {
                    "type": "string"
                },
                "weChatVars": {
                    "type": "string"
                }
            }
        },
        "dto.SettingUpdate": {
            "type": "object",
            "required": [
                "key"
            ],
            "properties": {
                "key": {
                    "type": "string"
                },
                "value": {
                    "type": "string"
                }
            }
        },
        "dto.SnapshotCreate": {
            "type": "object",
            "required": [
                "from"
            ],
            "properties": {
                "description": {
                    "type": "string",
                    "maxLength": 256
                },
                "from": {
                    "type": "string",
                    "enum": [
                        "OSS",
                        "S3",
                        "SFTP",
                        "MINIO",
                        "COS",
                        "KODO",
                        "OneDrive"
                    ]
                },
                "id": {
                    "type": "integer"
                }
            }
        },
        "dto.SnapshotImport": {
            "type": "object",
            "properties": {
                "description": {
                    "type": "string",
                    "maxLength": 256
                },
                "from": {
                    "type": "string"
                },
                "names": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                }
            }
        },
        "dto.SnapshotRecover": {
            "type": "object",
            "required": [
                "id"
            ],
            "properties": {
                "id": {
                    "type": "integer"
                },
                "isNew": {
                    "type": "boolean"
                },
                "reDownload": {
                    "type": "boolean"
                }
            }
        },
        "dto.SyncTime": {
            "type": "object",
            "properties": {
                "ntpSite": {
                    "type": "string"
                }
            }
        },
        "dto.TreeChild": {
            "type": "object",
            "properties": {
                "id": {
                    "type": "integer"
                },
                "label": {
                    "type": "string"
                }
            }
        },
        "dto.UpdateDescription": {
            "type": "object",
            "required": [
                "id"
            ],
            "properties": {
                "description": {
                    "type": "string",
                    "maxLength": 256
                },
                "id": {
                    "type": "integer"
                }
            }
        },
        "dto.UpdateFirewallDescription": {
            "type": "object",
            "required": [
                "strategy"
            ],
            "properties": {
                "address": {
                    "type": "string"
                },
                "description": {
                    "type": "string"
                },
                "port": {
                    "type": "string"
                },
                "protocol": {
                    "type": "string"
                },
                "strategy": {
                    "type": "string",
                    "enum": [
                        "accept",
                        "drop"
                    ]
                },
                "type": {
                    "type": "string"
                }
            }
        },
        "dto.Upgrade": {
            "type": "object",
            "properties": {
                "version": {
                    "type": "string"
                }
            }
        },
        "dto.UpgradeInfo": {
            "type": "object",
            "properties": {
                "latestVersion": {
                    "type": "string"
                },
                "newVersion": {
                    "type": "string"
                },
                "releaseNote": {
                    "type": "string"
                }
            }
        },
        "dto.UserLoginInfo": {
            "type": "object",
            "properties": {
                "mfaStatus": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "token": {
                    "type": "string"
                }
            }
        },
        "dto.VolumeCreate": {
            "type": "object",
            "properties": {
                "driver": {
                    "type": "string"
                },
                "labels": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "name": {
                    "type": "string"
                },
                "options": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                }
            }
        },
        "dto.VolumeHelper": {
            "type": "object",
            "properties": {
                "containerDir": {
                    "type": "string"
                },
                "mode": {
                    "type": "string"
                },
                "sourceDir": {
                    "type": "string"
                }
            }
        },
        "files.FileInfo": {
            "type": "object",
            "properties": {
                "content": {
                    "type": "string"
                },
                "extension": {
                    "type": "string"
                },
                "gid": {
                    "type": "string"
                },
                "group": {
                    "type": "string"
                },
                "isDir": {
                    "type": "boolean"
                },
                "isHidden": {
                    "type": "boolean"
                },
                "isSymlink": {
                    "type": "boolean"
                },
                "itemTotal": {
                    "type": "integer"
                },
                "items": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/files.FileInfo"
                    }
                },
                "linkPath": {
                    "type": "string"
                },
                "mimeType": {
                    "type": "string"
                },
                "modTime": {
                    "type": "string"
                },
                "mode": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "path": {
                    "type": "string"
                },
                "size": {
                    "type": "integer"
                },
                "type": {
                    "type": "string"
                },
                "uid": {
                    "type": "string"
                },
                "updateTime": {
                    "type": "string"
                },
                "user": {
                    "type": "string"
                }
            }
        },
        "mfa.Otp": {
            "type": "object",
            "properties": {
                "qrImage": {
                    "type": "string"
                },
                "secret": {
                    "type": "string"
                }
            }
        },
        "model.App": {
            "type": "object",
            "properties": {
                "createdAt": {
                    "type": "string"
                },
                "crossVersionUpdate": {
                    "type": "boolean"
                },
                "document": {
                    "type": "string"
                },
                "github": {
                    "type": "string"
                },
                "icon": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                },
                "key": {
                    "type": "string"
                },
                "lastModified": {
                    "type": "integer"
                },
                "limit": {
                    "type": "integer"
                },
                "name": {
                    "type": "string"
                },
                "readMe": {
                    "type": "string"
                },
                "recommend": {
                    "type": "integer"
                },
                "required": {
                    "type": "string"
                },
                "resource": {
                    "type": "string"
                },
                "shortDescEn": {
                    "type": "string"
                },
                "shortDescZh": {
                    "type": "string"
                },
                "status": {
                    "type": "string"
                },
                "tags": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "type": {
                    "type": "string"
                },
                "updatedAt": {
                    "type": "string"
                },
                "website": {
                    "type": "string"
                }
            }
        },
        "model.AppInstall": {
            "type": "object",
            "properties": {
                "app": {
                    "$ref": "#/definitions/model.App"
                },
                "appDetailId": {
                    "type": "integer"
                },
                "appId": {
                    "type": "integer"
                },
                "containerName": {
                    "type": "string"
                },
                "createdAt": {
                    "type": "string"
                },
                "description": {
                    "type": "string"
                },
                "dockerCompose": {
                    "type": "string"
                },
                "env": {
                    "type": "string"
                },
                "httpPort": {
                    "type": "integer"
                },
                "httpsPort": {
                    "type": "integer"
                },
                "id": {
                    "type": "integer"
                },
                "message": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "param": {
                    "type": "string"
                },
                "serviceName": {
                    "type": "string"
                },
                "status": {
                    "type": "string"
                },
                "updatedAt": {
                    "type": "string"
                },
                "version": {
                    "type": "string"
                }
            }
        },
        "model.Tag": {
            "type": "object",
            "properties": {
                "createdAt": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                },
                "key": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "sort": {
                    "type": "integer"
                },
                "updatedAt": {
                    "type": "string"
                }
            }
        },
        "model.Website": {
            "type": "object",
            "properties": {
                "IPV6": {
                    "type": "boolean"
                },
                "accessLog": {
                    "type": "boolean"
                },
                "alias": {
                    "type": "string"
                },
                "appInstallId": {
                    "type": "integer"
                },
                "createdAt": {
                    "type": "string"
                },
                "defaultServer": {
                    "type": "boolean"
                },
                "domains": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/model.WebsiteDomain"
                    }
                },
                "errorLog": {
                    "type": "boolean"
                },
                "expireDate": {
                    "type": "string"
                },
                "group": {
                    "type": "string"
                },
                "httpConfig": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                },
                "primaryDomain": {
                    "type": "string"
                },
                "protocol": {
                    "type": "string"
                },
                "proxy": {
                    "type": "string"
                },
                "proxyType": {
                    "type": "string"
                },
                "remark": {
                    "type": "string"
                },
                "rewrite": {
                    "type": "string"
                },
                "runtimeID": {
                    "type": "integer"
                },
                "siteDir": {
                    "type": "string"
                },
                "status": {
                    "type": "string"
                },
                "type": {
                    "type": "string"
                },
                "updatedAt": {
                    "type": "string"
                },
                "user": {
                    "type": "string"
                },
                "webSiteGroupId": {
                    "type": "integer"
                },
                "webSiteSSL": {
                    "$ref": "#/definitions/model.WebsiteSSL"
                },
                "webSiteSSLId": {
                    "type": "integer"
                }
            }
        },
        "model.WebsiteAcmeAccount": {
            "type": "object",
            "properties": {
                "createdAt": {
                    "type": "string"
                },
                "email": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                },
                "updatedAt": {
                    "type": "string"
                },
                "url": {
                    "type": "string"
                }
            }
        },
        "model.WebsiteDomain": {
            "type": "object",
            "properties": {
                "createdAt": {
                    "type": "string"
                },
                "domain": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                },
                "port": {
                    "type": "integer"
                },
                "updatedAt": {
                    "type": "string"
                },
                "websiteId": {
                    "type": "integer"
                }
            }
        },
        "model.WebsiteSSL": {
            "type": "object",
            "properties": {
                "acmeAccount": {
                    "$ref": "#/definitions/model.WebsiteAcmeAccount"
                },
                "acmeAccountId": {
                    "type": "integer"
                },
                "autoRenew": {
                    "type": "boolean"
                },
                "certURL": {
                    "type": "string"
                },
                "createdAt": {
                    "type": "string"
                },
                "dnsAccountId": {
                    "type": "integer"
                },
                "domains": {
                    "type": "string"
                },
                "expireDate": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                },
                "organization": {
                    "type": "string"
                },
                "pem": {
                    "type": "string"
                },
                "primaryDomain": {
                    "type": "string"
                },
                "privateKey": {
                    "type": "string"
                },
                "provider": {
                    "type": "string"
                },
                "startDate": {
                    "type": "string"
                },
                "type": {
                    "type": "string"
                },
                "updatedAt": {
                    "type": "string"
                },
                "websites": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/model.Website"
                    }
                }
            }
        },
        "request.AppInstallCreate": {
            "type": "object",
            "required": [
                "appDetailId",
                "name"
            ],
            "properties": {
                "advanced": {
                    "type": "boolean"
                },
                "allowPort": {
                    "type": "boolean"
                },
                "appDetailId": {
                    "type": "integer"
                },
                "containerName": {
                    "type": "string"
                },
                "cpuQuota": {
                    "type": "number"
                },
                "dockerCompose": {
                    "type": "string"
                },
                "editCompose": {
                    "type": "boolean"
                },
                "memoryLimit": {
                    "type": "number"
                },
                "memoryUnit": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "params": {
                    "type": "object",
                    "additionalProperties": true
                },
                "services": {
                    "type": "object",
                    "additionalProperties": {
                        "type": "string"
                    }
                }
            }
        },
        "request.AppInstalledIgnoreUpgrade": {
            "type": "object",
            "required": [
                "detailID",
                "operate"
            ],
            "properties": {
                "detailID": {
                    "type": "integer"
                },
                "operate": {
                    "type": "string",
                    "enum": [
                        "cancel",
                        "ignore"
                    ]
                }
            }
        },
        "request.AppInstalledInfo": {
            "type": "object",
            "required": [
                "key"
            ],
            "properties": {
                "key": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                }
            }
        },
        "request.AppInstalledOperate": {
            "type": "object",
            "required": [
                "installId",
                "operate"
            ],
            "properties": {
                "backup": {
                    "type": "boolean"
                },
                "backupId": {
                    "type": "integer"
                },
                "deleteBackup": {
                    "type": "boolean"
                },
                "deleteDB": {
                    "type": "boolean"
                },
                "detailId": {
                    "type": "integer"
                },
                "forceDelete": {
                    "type": "boolean"
                },
                "installId": {
                    "type": "integer"
                },
                "operate": {
                    "type": "string"
                }
            }
        },
        "request.AppInstalledSearch": {
            "type": "object",
            "required": [
                "page",
                "pageSize"
            ],
            "properties": {
                "name": {
                    "type": "string"
                },
                "page": {
                    "type": "integer"
                },
                "pageSize": {
                    "type": "integer"
                },
                "tags": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "type": {
                    "type": "string"
                },
                "unused": {
                    "type": "boolean"
                },
                "update": {
                    "type": "boolean"
                }
            }
        },
        "request.AppInstalledUpdate": {
            "type": "object",
            "required": [
                "installId",
                "params"
            ],
            "properties": {
                "advanced": {
                    "type": "boolean"
                },
                "allowPort": {
                    "type": "boolean"
                },
                "containerName": {
                    "type": "string"
                },
                "cpuQuota": {
                    "type": "number"
                },
                "dockerCompose": {
                    "type": "string"
                },
                "editCompose": {
                    "type": "boolean"
                },
                "installId": {
                    "type": "integer"
                },
                "memoryLimit": {
                    "type": "number"
                },
                "memoryUnit": {
                    "type": "string"
                },
                "params": {
                    "type": "object",
                    "additionalProperties": true
                }
            }
        },
        "request.AppSearch": {
            "type": "object",
            "required": [
                "page",
                "pageSize"
            ],
            "properties": {
                "name": {
                    "type": "string"
                },
                "page": {
                    "type": "integer"
                },
                "pageSize": {
                    "type": "integer"
                },
                "recommend": {
                    "type": "boolean"
                },
                "resource": {
                    "type": "string"
                },
                "tags": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "type": {
                    "type": "string"
                }
            }
        },
        "request.DirSizeReq": {
            "type": "object",
            "required": [
                "path"
            ],
            "properties": {
                "path": {
                    "type": "string"
                }
            }
        },
        "request.FileBatchDelete": {
            "type": "object",
            "required": [
                "paths"
            ],
            "properties": {
                "isDir": {
                    "type": "boolean"
                },
                "paths": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                }
            }
        },
        "request.FileCompress": {
            "type": "object",
            "required": [
                "dst",
                "files",
                "name",
                "type"
            ],
            "properties": {
                "dst": {
                    "type": "string"
                },
                "files": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "name": {
                    "type": "string"
                },
                "replace": {
                    "type": "boolean"
                },
                "type": {
                    "type": "string"
                }
            }
        },
        "request.FileCreate": {
            "type": "object",
            "required": [
                "mode",
                "path"
            ],
            "properties": {
                "content": {
                    "type": "string"
                },
                "isDir": {
                    "type": "boolean"
                },
                "isLink": {
                    "type": "boolean"
                },
                "isSymlink": {
                    "type": "boolean"
                },
                "linkPath": {
                    "type": "string"
                },
                "mode": {
                    "type": "integer"
                },
                "path": {
                    "type": "string"
                },
                "sub": {
                    "type": "boolean"
                }
            }
        },
        "request.FileDeCompress": {
            "type": "object",
            "required": [
                "dst",
                "path",
                "type"
            ],
            "properties": {
                "dst": {
                    "type": "string"
                },
                "path": {
                    "type": "string"
                },
                "type": {
                    "type": "string"
                }
            }
        },
        "request.FileDelete": {
            "type": "object",
            "required": [
                "path"
            ],
            "properties": {
                "isDir": {
                    "type": "boolean"
                },
                "path": {
                    "type": "string"
                }
            }
        },
        "request.FileDownload": {
            "type": "object",
            "required": [
                "compress",
                "name",
                "paths",
                "type"
            ],
            "properties": {
                "compress": {
                    "type": "boolean"
                },
                "name": {
                    "type": "string"
                },
                "paths": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "type": {
                    "type": "string"
                }
            }
        },
        "request.FileEdit": {
            "type": "object",
            "required": [
                "content",
                "path"
            ],
            "properties": {
                "content": {
                    "type": "string"
                },
                "path": {
                    "type": "string"
                }
            }
        },
        "request.FileMove": {
            "type": "object",
            "required": [
                "newPath",
                "oldPaths",
                "type"
            ],
            "properties": {
                "newPath": {
                    "type": "string"
                },
                "oldPaths": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "type": {
                    "type": "string"
                }
            }
        },
        "request.FileOption": {
            "type": "object",
            "properties": {
                "containSub": {
                    "type": "boolean"
                },
                "dir": {
                    "type": "boolean"
                },
                "expand": {
                    "type": "boolean"
                },
                "page": {
                    "type": "integer"
                },
                "pageSize": {
                    "type": "integer"
                },
                "path": {
                    "type": "string"
                },
                "search": {
                    "type": "string"
                },
                "showHidden": {
                    "type": "boolean"
                }
            }
        },
        "request.FilePathCheck": {
            "type": "object",
            "required": [
                "path"
            ],
            "properties": {
                "path": {
                    "type": "string"
                }
            }
        },
        "request.FileRename": {
            "type": "object",
            "required": [
                "newName",
                "oldName"
            ],
            "properties": {
                "newName": {
                    "type": "string"
                },
                "oldName": {
                    "type": "string"
                }
            }
        },
        "request.FileRoleUpdate": {
            "type": "object",
            "required": [
                "group",
                "path",
                "sub",
                "user"
            ],
            "properties": {
                "group": {
                    "type": "string"
                },
                "path": {
                    "type": "string"
                },
                "sub": {
                    "type": "boolean"
                },
                "user": {
                    "type": "string"
                }
            }
        },
        "request.FileWget": {
            "type": "object",
            "required": [
                "name",
                "path",
                "url"
            ],
            "properties": {
                "name": {
                    "type": "string"
                },
                "path": {
                    "type": "string"
                },
                "url": {
                    "type": "string"
                }
            }
        },
        "request.HostToolConfig": {
            "type": "object",
            "required": [
                "type"
            ],
            "properties": {
                "content": {
                    "type": "string"
                },
                "operate": {
                    "type": "string",
                    "enum": [
                        "get",
                        "set"
                    ]
                },
                "type": {
                    "type": "string",
                    "enum": [
                        "supervisord"
                    ]
                }
            }
        },
        "request.HostToolCreate": {
            "type": "object",
            "required": [
                "type"
            ],
            "properties": {
                "configPath": {
                    "type": "string"
                },
                "serviceName": {
                    "type": "string"
                },
                "type": {
                    "type": "string"
                }
            }
        },
        "request.HostToolLogReq": {
            "type": "object",
            "required": [
                "type"
            ],
            "properties": {
                "type": {
                    "type": "string",
                    "enum": [
                        "supervisord"
                    ]
                }
            }
        },
        "request.HostToolReq": {
            "type": "object",
            "required": [
                "type"
            ],
            "properties": {
                "operate": {
                    "type": "string",
                    "enum": [
                        "status",
                        "restart",
                        "start",
                        "stop"
                    ]
                },
                "type": {
                    "type": "string",
                    "enum": [
                        "supervisord"
                    ]
                }
            }
        },
        "request.NewAppInstall": {
            "type": "object",
            "properties": {
                "advanced": {
                    "type": "boolean"
                },
                "allowPort": {
                    "type": "boolean"
                },
                "appDetailID": {
                    "type": "integer"
                },
                "containerName": {
                    "type": "string"
                },
                "cpuQuota": {
                    "type": "number"
                },
                "dockerCompose": {
                    "type": "string"
                },
                "editCompose": {
                    "type": "boolean"
                },
                "memoryLimit": {
                    "type": "number"
                },
                "memoryUnit": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "params": {
                    "type": "object",
                    "additionalProperties": true
                }
            }
        },
        "request.NginxAntiLeechUpdate": {
            "type": "object",
            "required": [
                "enable",
                "extends",
                "return",
                "websiteID"
            ],
            "properties": {
                "blocked": {
                    "type": "boolean"
                },
                "cache": {
                    "type": "boolean"
                },
                "cacheTime": {
                    "type": "integer"
                },
                "cacheUint": {
                    "type": "string"
                },
                "enable": {
                    "type": "boolean"
                },
                "extends": {
                    "type": "string"
                },
                "logEnable": {
                    "type": "boolean"
                },
                "noneRef": {
                    "type": "boolean"
                },
                "return": {
                    "type": "string"
                },
                "serverNames": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "websiteID": {
                    "type": "integer"
                }
            }
        },
        "request.NginxAuthReq": {
            "type": "object",
            "required": [
                "websiteID"
            ],
            "properties": {
                "websiteID": {
                    "type": "integer"
                }
            }
        },
        "request.NginxAuthUpdate": {
            "type": "object",
            "required": [
                "operate",
                "password",
                "username",
                "websiteID"
            ],
            "properties": {
                "operate": {
                    "type": "string"
                },
                "password": {
                    "type": "string"
                },
                "remark": {
                    "type": "string"
                },
                "username": {
                    "type": "string"
                },
                "websiteID": {
                    "type": "integer"
                }
            }
        },
        "request.NginxCommonReq": {
            "type": "object",
            "required": [
                "websiteID"
            ],
            "properties": {
                "websiteID": {
                    "type": "integer"
                }
            }
        },
        "request.NginxConfigFileUpdate": {
            "type": "object",
            "required": [
                "backup",
                "content"
            ],
            "properties": {
                "backup": {
                    "type": "boolean"
                },
                "content": {
                    "type": "string"
                }
            }
        },
        "request.NginxConfigUpdate": {
            "type": "object",
            "required": [
                "websiteId"
            ],
            "properties": {
                "operate": {
                    "type": "string"
                },
                "params": {},
                "scope": {
                    "$ref": "#/definitions/dto.NginxKey"
                },
                "websiteId": {
                    "type": "integer"
                }
            }
        },
        "request.NginxProxyUpdate": {
            "type": "object",
            "required": [
                "content",
                "name",
                "websiteID"
            ],
            "properties": {
                "content": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "websiteID": {
                    "type": "integer"
                }
            }
        },
        "request.NginxRedirectReq": {
            "type": "object",
            "required": [
                "enable",
                "keepPath",
                "name",
                "operate",
                "redirect",
                "target",
                "type",
                "websiteID"
            ],
            "properties": {
                "domains": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "enable": {
                    "type": "boolean"
                },
                "keepPath": {
                    "type": "boolean"
                },
                "name": {
                    "type": "string"
                },
                "operate": {
                    "type": "string"
                },
                "path": {
                    "type": "string"
                },
                "redirect": {
                    "type": "string"
                },
                "redirectRoot": {
                    "type": "boolean"
                },
                "target": {
                    "type": "string"
                },
                "type": {
                    "type": "string"
                },
                "websiteID": {
                    "type": "integer"
                }
            }
        },
        "request.NginxRedirectUpdate": {
            "type": "object",
            "required": [
                "content",
                "name",
                "websiteID"
            ],
            "properties": {
                "content": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "websiteID": {
                    "type": "integer"
                }
            }
        },
        "request.NginxRewriteReq": {
            "type": "object",
            "required": [
                "name",
                "websiteId"
            ],
            "properties": {
                "name": {
                    "type": "string"
                },
                "websiteId": {
                    "type": "integer"
                }
            }
        },
        "request.NginxRewriteUpdate": {
            "type": "object",
            "required": [
                "content",
                "name",
                "websiteId"
            ],
            "properties": {
                "content": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "websiteId": {
                    "type": "integer"
                }
            }
        },
        "request.NginxScopeReq": {
            "type": "object",
            "required": [
                "scope"
            ],
            "properties": {
                "scope": {
                    "$ref": "#/definitions/dto.NginxKey"
                },
                "websiteId": {
                    "type": "integer"
                }
            }
        },
        "request.NodeModuleReq": {
            "type": "object",
            "required": [
                "ID"
            ],
            "properties": {
                "ID": {
                    "type": "integer"
                }
            }
        },
        "request.NodePackageReq": {
            "type": "object",
            "properties": {
                "codeDir": {
                    "type": "string"
                }
            }
        },
        "request.PortUpdate": {
            "type": "object",
            "properties": {
                "key": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "port": {
                    "type": "integer"
                }
            }
        },
        "request.ProcessReq": {
            "type": "object",
            "required": [
                "PID"
            ],
            "properties": {
                "PID": {
                    "type": "integer"
                }
            }
        },
        "request.RuntimeCreate": {
            "type": "object",
            "properties": {
                "appDetailId": {
                    "type": "integer"
                },
                "clean": {
                    "type": "boolean"
                },
                "codeDir": {
                    "type": "string"
                },
                "image": {
                    "type": "string"
                },
                "install": {
                    "type": "boolean"
                },
                "name": {
                    "type": "string"
                },
                "params": {
                    "type": "object",
                    "additionalProperties": true
                },
                "port": {
                    "type": "integer"
                },
                "resource": {
                    "type": "string"
                },
                "source": {
                    "type": "string"
                },
                "type": {
                    "type": "string"
                },
                "version": {
                    "type": "string"
                }
            }
        },
        "request.RuntimeDelete": {
            "type": "object",
            "properties": {
                "forceDelete": {
                    "type": "boolean"
                },
                "id": {
                    "type": "integer"
                }
            }
        },
        "request.RuntimeOperate": {
            "type": "object",
            "properties": {
                "ID": {
                    "type": "integer"
                },
                "operate": {
                    "type": "string"
                }
            }
        },
        "request.RuntimeSearch": {
            "type": "object",
            "required": [
                "page",
                "pageSize"
            ],
            "properties": {
                "name": {
                    "type": "string"
                },
                "page": {
                    "type": "integer"
                },
                "pageSize": {
                    "type": "integer"
                },
                "status": {
                    "type": "string"
                },
                "type": {
                    "type": "string"
                }
            }
        },
        "request.RuntimeUpdate": {
            "type": "object",
            "properties": {
                "clean": {
                    "type": "boolean"
                },
                "codeDir": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                },
                "image": {
                    "type": "string"
                },
                "install": {
                    "type": "boolean"
                },
                "name": {
                    "type": "string"
                },
                "params": {
                    "type": "object",
                    "additionalProperties": true
                },
                "port": {
                    "type": "integer"
                },
                "rebuild": {
                    "type": "boolean"
                },
                "source": {
                    "type": "string"
                },
                "version": {
                    "type": "string"
                }
            }
        },
        "request.SearchUploadWithPage": {
            "type": "object",
            "required": [
                "page",
                "pageSize",
                "path"
            ],
            "properties": {
                "page": {
                    "type": "integer"
                },
                "pageSize": {
                    "type": "integer"
                },
                "path": {
                    "type": "string"
                }
            }
        },
        "request.SupervisorProcessConfig": {
            "type": "object",
            "properties": {
                "command": {
                    "type": "string"
                },
                "dir": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "numprocs": {
                    "type": "string"
                },
                "operate": {
                    "type": "string"
                },
                "user": {
                    "type": "string"
                }
            }
        },
        "request.SupervisorProcessFileReq": {
            "type": "object",
            "required": [
                "file",
                "name",
                "operate"
            ],
            "properties": {
                "content": {
                    "type": "string"
                },
                "file": {
                    "type": "string",
                    "enum": [
                        "out.log",
                        "err.log",
                        "config"
                    ]
                },
                "name": {
                    "type": "string"
                },
                "operate": {
                    "type": "string",
                    "enum": [
                        "get",
                        "clear",
                        "update"
                    ]
                }
            }
        },
        "request.WebsiteAcmeAccountCreate": {
            "type": "object",
            "required": [
                "email"
            ],
            "properties": {
                "email": {
                    "type": "string"
                }
            }
        },
        "request.WebsiteCommonReq": {
            "type": "object",
            "required": [
                "id"
            ],
            "properties": {
                "id": {
                    "type": "integer"
                }
            }
        },
        "request.WebsiteCreate": {
            "type": "object",
            "required": [
                "alias",
                "primaryDomain",
                "type",
                "webSiteGroupID"
            ],
            "properties": {
                "IPV6": {
                    "type": "boolean"
                },
                "alias": {
                    "type": "string"
                },
                "appID": {
                    "type": "integer"
                },
                "appInstall": {
                    "$ref": "#/definitions/request.NewAppInstall"
                },
                "appInstallID": {
                    "type": "integer"
                },
                "appType": {
                    "type": "string",
                    "enum": [
                        "new",
                        "installed"
                    ]
                },
                "otherDomains": {
                    "type": "string"
                },
                "port": {
                    "type": "integer"
                },
                "primaryDomain": {
                    "type": "string"
                },
                "proxy": {
                    "type": "string"
                },
                "proxyType": {
                    "type": "string"
                },
                "remark": {
                    "type": "string"
                },
                "runtimeID": {
                    "type": "integer"
                },
                "type": {
                    "type": "string"
                },
                "webSiteGroupID": {
                    "type": "integer"
                }
            }
        },
        "request.WebsiteDNSReq": {
            "type": "object",
            "required": [
                "acmeAccountId",
                "domains"
            ],
            "properties": {
                "acmeAccountId": {
                    "type": "integer"
                },
                "domains": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                }
            }
        },
        "request.WebsiteDefaultUpdate": {
            "type": "object",
            "required": [
                "id"
            ],
            "properties": {
                "id": {
                    "type": "integer"
                }
            }
        },
        "request.WebsiteDelete": {
            "type": "object",
            "required": [
                "id"
            ],
            "properties": {
                "deleteApp": {
                    "type": "boolean"
                },
                "deleteBackup": {
                    "type": "boolean"
                },
                "forceDelete": {
                    "type": "boolean"
                },
                "id": {
                    "type": "integer"
                }
            }
        },
        "request.WebsiteDnsAccountCreate": {
            "type": "object",
            "required": [
                "authorization",
                "name",
                "type"
            ],
            "properties": {
                "authorization": {
                    "type": "object",
                    "additionalProperties": {
                        "type": "string"
                    }
                },
                "name": {
                    "type": "string"
                },
                "type": {
                    "type": "string"
                }
            }
        },
        "request.WebsiteDnsAccountUpdate": {
            "type": "object",
            "required": [
                "authorization",
                "id",
                "name",
                "type"
            ],
            "properties": {
                "authorization": {
                    "type": "object",
                    "additionalProperties": {
                        "type": "string"
                    }
                },
                "id": {
                    "type": "integer"
                },
                "name": {
                    "type": "string"
                },
                "type": {
                    "type": "string"
                }
            }
        },
        "request.WebsiteDomainCreate": {
            "type": "object",
            "required": [
                "domain",
                "port",
                "websiteId"
            ],
            "properties": {
                "domain": {
                    "type": "string"
                },
                "port": {
                    "type": "integer"
                },
                "websiteId": {
                    "type": "integer"
                }
            }
        },
        "request.WebsiteDomainDelete": {
            "type": "object",
            "required": [
                "id"
            ],
            "properties": {
                "id": {
                    "type": "integer"
                }
            }
        },
        "request.WebsiteHTTPSOp": {
            "type": "object",
            "required": [
                "enable",
                "websiteId"
            ],
            "properties": {
                "SSLProtocol": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "algorithm": {
                    "type": "string"
                },
                "certificate": {
                    "type": "string"
                },
                "certificatePath": {
                    "type": "string"
                },
                "enable": {
                    "type": "boolean"
                },
                "httpConfig": {
                    "type": "string",
                    "enum": [
                        "HTTPSOnly",
                        "HTTPAlso",
                        "HTTPToHTTPS"
                    ]
                },
                "importType": {
                    "type": "string"
                },
                "privateKey": {
                    "type": "string"
                },
                "privateKeyPath": {
                    "type": "string"
                },
                "type": {
                    "type": "string",
                    "enum": [
                        "existed",
                        "auto",
                        "manual"
                    ]
                },
                "websiteId": {
                    "type": "integer"
                },
                "websiteSSLId": {
                    "type": "integer"
                }
            }
        },
        "request.WebsiteInstallCheckReq": {
            "type": "object",
            "required": [
                "InstallIds"
            ],
            "properties": {
                "InstallIds": {
                    "type": "array",
                    "items": {
                        "type": "integer"
                    }
                }
            }
        },
        "request.WebsiteLogReq": {
            "type": "object",
            "required": [
                "id",
                "logType",
                "operate"
            ],
            "properties": {
                "id": {
                    "type": "integer"
                },
                "logType": {
                    "type": "string"
                },
                "operate": {
                    "type": "string"
                },
                "page": {
                    "type": "integer"
                },
                "pageSize": {
                    "type": "integer"
                }
            }
        },
        "request.WebsiteNginxUpdate": {
            "type": "object",
            "required": [
                "content",
                "id"
            ],
            "properties": {
                "content": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                }
            }
        },
        "request.WebsiteOp": {
            "type": "object",
            "required": [
                "id"
            ],
            "properties": {
                "id": {
                    "type": "integer"
                },
                "operate": {
                    "type": "string"
                }
            }
        },
        "request.WebsitePHPConfigUpdate": {
            "type": "object",
            "required": [
                "id",
                "scope"
            ],
            "properties": {
                "disableFunctions": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "id": {
                    "type": "integer"
                },
                "params": {
                    "type": "object",
                    "additionalProperties": {
                        "type": "string"
                    }
                },
                "scope": {
                    "type": "string"
                },
                "uploadMaxSize": {
                    "type": "string"
                }
            }
        },
        "request.WebsitePHPFileUpdate": {
            "type": "object",
            "required": [
                "content",
                "id",
                "type"
            ],
            "properties": {
                "content": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                },
                "type": {
                    "type": "string"
                }
            }
        },
        "request.WebsitePHPVersionReq": {
            "type": "object",
            "required": [
                "retainConfig",
                "runtimeID",
                "websiteID"
            ],
            "properties": {
                "retainConfig": {
                    "type": "boolean"
                },
                "runtimeID": {
                    "type": "integer"
                },
                "websiteID": {
                    "type": "integer"
                }
            }
        },
        "request.WebsiteProxyConfig": {
            "type": "object",
            "required": [
                "cache",
                "cacheTime",
                "cacheUnit",
                "enable",
                "id",
                "match",
                "modifier",
                "name",
                "operate",
                "proxyHost",
                "proxyPass"
            ],
            "properties": {
                "cache": {
                    "type": "boolean"
                },
                "cacheTime": {
                    "type": "integer"
                },
                "cacheUnit": {
                    "type": "string"
                },
                "content": {
                    "type": "string"
                },
                "enable": {
                    "type": "boolean"
                },
                "filePath": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                },
                "match": {
                    "type": "string"
                },
                "modifier": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "operate": {
                    "type": "string"
                },
                "proxyHost": {
                    "type": "string"
                },
                "proxyPass": {
                    "type": "string"
                },
                "replaces": {
                    "type": "object",
                    "additionalProperties": {
                        "type": "string"
                    }
                }
            }
        },
        "request.WebsiteProxyReq": {
            "type": "object",
            "required": [
                "id"
            ],
            "properties": {
                "id": {
                    "type": "integer"
                }
            }
        },
        "request.WebsiteResourceReq": {
            "type": "object",
            "required": [
                "id"
            ],
            "properties": {
                "id": {
                    "type": "integer"
                }
            }
        },
        "request.WebsiteSSLCreate": {
            "type": "object",
            "required": [
                "acmeAccountId",
                "autoRenew",
                "primaryDomain",
                "provider"
            ],
            "properties": {
                "acmeAccountId": {
                    "type": "integer"
                },
                "autoRenew": {
                    "type": "boolean"
                },
                "dnsAccountId": {
                    "type": "integer"
                },
                "otherDomains": {
                    "type": "string"
                },
                "primaryDomain": {
                    "type": "string"
                },
                "provider": {
                    "type": "string"
                }
            }
        },
        "request.WebsiteSSLRenew": {
            "type": "object",
            "required": [
                "SSLId"
            ],
            "properties": {
                "SSLId": {
                    "type": "integer"
                }
            }
        },
        "request.WebsiteSSLSearch": {
            "type": "object",
            "required": [
                "page",
                "pageSize"
            ],
            "properties": {
                "acmeAccountID": {
                    "type": "string"
                },
                "page": {
                    "type": "integer"
                },
                "pageSize": {
                    "type": "integer"
                }
            }
        },
        "request.WebsiteSSLUpdate": {
            "type": "object",
            "required": [
                "autoRenew",
                "id"
            ],
            "properties": {
                "autoRenew": {
                    "type": "boolean"
                },
                "id": {
                    "type": "integer"
                }
            }
        },
        "request.WebsiteSearch": {
            "type": "object",
            "required": [
                "page",
                "pageSize"
            ],
            "properties": {
                "name": {
                    "type": "string"
                },
                "order": {
                    "type": "string"
                },
                "orderBy": {
                    "type": "string"
                },
                "page": {
                    "type": "integer"
                },
                "pageSize": {
                    "type": "integer"
                },
                "websiteGroupId": {
                    "type": "integer"
                }
            }
        },
        "request.WebsiteUpdate": {
            "type": "object",
            "required": [
                "id",
                "primaryDomain",
                "webSiteGroupID"
            ],
            "properties": {
                "IPV6": {
                    "type": "boolean"
                },
                "expireDate": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                },
                "primaryDomain": {
                    "type": "string"
                },
                "remark": {
                    "type": "string"
                },
                "webSiteGroupID": {
                    "type": "integer"
                }
            }
        },
        "request.WebsiteUpdateDir": {
            "type": "object",
            "required": [
                "id",
                "siteDir"
            ],
            "properties": {
                "id": {
                    "type": "integer"
                },
                "siteDir": {
                    "type": "string"
                }
            }
        },
        "request.WebsiteUpdateDirPermission": {
            "type": "object",
            "required": [
                "group",
                "id",
                "user"
            ],
            "properties": {
                "group": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                },
                "user": {
                    "type": "string"
                }
            }
        },
        "request.WebsiteWafReq": {
            "type": "object",
            "required": [
                "key",
                "rule",
                "websiteId"
            ],
            "properties": {
                "key": {
                    "type": "string"
                },
                "rule": {
                    "type": "string"
                },
                "websiteId": {
                    "type": "integer"
                }
            }
        },
        "request.WebsiteWafUpdate": {
            "type": "object",
            "required": [
                "enable",
                "key",
                "websiteId"
            ],
            "properties": {
                "enable": {
                    "type": "boolean"
                },
                "key": {
                    "type": "string"
                },
                "websiteId": {
                    "type": "integer"
                }
            }
        },
        "response.AppDTO": {
            "type": "object",
            "properties": {
                "createdAt": {
                    "type": "string"
                },
                "crossVersionUpdate": {
                    "type": "boolean"
                },
                "document": {
                    "type": "string"
                },
                "github": {
                    "type": "string"
                },
                "icon": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                },
                "installed": {
                    "type": "boolean"
                },
                "key": {
                    "type": "string"
                },
                "lastModified": {
                    "type": "integer"
                },
                "limit": {
                    "type": "integer"
                },
                "name": {
                    "type": "string"
                },
                "readMe": {
                    "type": "string"
                },
                "recommend": {
                    "type": "integer"
                },
                "required": {
                    "type": "string"
                },
                "resource": {
                    "type": "string"
                },
                "shortDescEn": {
                    "type": "string"
                },
                "shortDescZh": {
                    "type": "string"
                },
                "status": {
                    "type": "string"
                },
                "tags": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/model.Tag"
                    }
                },
                "type": {
                    "type": "string"
                },
                "updatedAt": {
                    "type": "string"
                },
                "versions": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "website": {
                    "type": "string"
                }
            }
        },
        "response.AppDetailDTO": {
            "type": "object",
            "properties": {
                "appId": {
                    "type": "integer"
                },
                "createdAt": {
                    "type": "string"
                },
                "dockerCompose": {
                    "type": "string"
                },
                "downloadCallBackUrl": {
                    "type": "string"
                },
                "downloadUrl": {
                    "type": "string"
                },
                "enable": {
                    "type": "boolean"
                },
                "id": {
                    "type": "integer"
                },
                "ignoreUpgrade": {
                    "type": "boolean"
                },
                "image": {
                    "type": "string"
                },
                "lastModified": {
                    "type": "integer"
                },
                "lastVersion": {
                    "type": "string"
                },
                "params": {},
                "status": {
                    "type": "string"
                },
                "update": {
                    "type": "boolean"
                },
                "updatedAt": {
                    "type": "string"
                },
                "version": {
                    "type": "string"
                }
            }
        },
        "response.AppInstalledCheck": {
            "type": "object",
            "properties": {
                "app": {
                    "type": "string"
                },
                "appInstallId": {
                    "type": "integer"
                },
                "containerName": {
                    "type": "string"
                },
                "createdAt": {
                    "type": "string"
                },
                "httpPort": {
                    "type": "integer"
                },
                "httpsPort": {
                    "type": "integer"
                },
                "installPath": {
                    "type": "string"
                },
                "isExist": {
                    "type": "boolean"
                },
                "lastBackupAt": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "status": {
                    "type": "string"
                },
                "version": {
                    "type": "string"
                }
            }
        },
        "response.AppParam": {
            "type": "object",
            "properties": {
                "edit": {
                    "type": "boolean"
                },
                "key": {
                    "type": "string"
                },
                "labelEn": {
                    "type": "string"
                },
                "labelZh": {
                    "type": "string"
                },
                "multiple": {
                    "type": "boolean"
                },
                "required": {
                    "type": "boolean"
                },
                "rule": {
                    "type": "string"
                },
                "showValue": {
                    "type": "string"
                },
                "type": {
                    "type": "string"
                },
                "value": {},
                "values": {}
            }
        },
        "response.AppService": {
            "type": "object",
            "properties": {
                "config": {},
                "from": {
                    "type": "string"
                },
                "label": {
                    "type": "string"
                },
                "value": {
                    "type": "string"
                }
            }
        },
        "response.FileInfo": {
            "type": "object",
            "properties": {
                "content": {
                    "type": "string"
                },
                "extension": {
                    "type": "string"
                },
                "gid": {
                    "type": "string"
                },
                "group": {
                    "type": "string"
                },
                "isDir": {
                    "type": "boolean"
                },
                "isHidden": {
                    "type": "boolean"
                },
                "isSymlink": {
                    "type": "boolean"
                },
                "itemTotal": {
                    "type": "integer"
                },
                "items": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/files.FileInfo"
                    }
                },
                "linkPath": {
                    "type": "string"
                },
                "mimeType": {
                    "type": "string"
                },
                "modTime": {
                    "type": "string"
                },
                "mode": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "path": {
                    "type": "string"
                },
                "size": {
                    "type": "integer"
                },
                "type": {
                    "type": "string"
                },
                "uid": {
                    "type": "string"
                },
                "updateTime": {
                    "type": "string"
                },
                "user": {
                    "type": "string"
                }
            }
        },
        "response.FileTree": {
            "type": "object",
            "properties": {
                "children": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/response.FileTree"
                    }
                },
                "id": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "path": {
                    "type": "string"
                }
            }
        },
        "response.IgnoredApp": {
            "type": "object",
            "properties": {
                "detailID": {
                    "type": "integer"
                },
                "icon": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "version": {
                    "type": "string"
                }
            }
        },
        "response.NginxParam": {
            "type": "object",
            "properties": {
                "name": {
                    "type": "string"
                },
                "params": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                }
            }
        },
        "response.NginxStatus": {
            "type": "object",
            "properties": {
                "accepts": {
                    "type": "string"
                },
                "active": {
                    "type": "string"
                },
                "handled": {
                    "type": "string"
                },
                "reading": {
                    "type": "string"
                },
                "requests": {
                    "type": "string"
                },
                "waiting": {
                    "type": "string"
                },
                "writing": {
                    "type": "string"
                }
            }
        },
        "response.PHPConfig": {
            "type": "object",
            "properties": {
                "disableFunctions": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "params": {
                    "type": "object",
                    "additionalProperties": {
                        "type": "string"
                    }
                },
                "uploadMaxSize": {
                    "type": "string"
                }
            }
        },
        "response.WebsiteAcmeAccountDTO": {
            "type": "object",
            "properties": {
                "createdAt": {
                    "type": "string"
                },
                "email": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                },
                "updatedAt": {
                    "type": "string"
                },
                "url": {
                    "type": "string"
                }
            }
        },
        "response.WebsiteDNSRes": {
            "type": "object",
            "properties": {
                "domain": {
                    "type": "string"
                },
                "err": {
                    "type": "string"
                },
                "resolve": {
                    "type": "string"
                },
                "value": {
                    "type": "string"
                }
            }
        },
        "response.WebsiteDTO": {
            "type": "object",
            "properties": {
                "IPV6": {
                    "type": "boolean"
                },
                "accessLog": {
                    "type": "boolean"
                },
                "accessLogPath": {
                    "type": "string"
                },
                "alias": {
                    "type": "string"
                },
                "appInstallId": {
                    "type": "integer"
                },
                "appName": {
                    "type": "string"
                },
                "createdAt": {
                    "type": "string"
                },
                "defaultServer": {
                    "type": "boolean"
                },
                "domains": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/model.WebsiteDomain"
                    }
                },
                "errorLog": {
                    "type": "boolean"
                },
                "errorLogPath": {
                    "type": "string"
                },
                "expireDate": {
                    "type": "string"
                },
                "group": {
                    "type": "string"
                },
                "httpConfig": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                },
                "primaryDomain": {
                    "type": "string"
                },
                "protocol": {
                    "type": "string"
                },
                "proxy": {
                    "type": "string"
                },
                "proxyType": {
                    "type": "string"
                },
                "remark": {
                    "type": "string"
                },
                "rewrite": {
                    "type": "string"
                },
                "runtimeID": {
                    "type": "integer"
                },
                "runtimeName": {
                    "type": "string"
                },
                "siteDir": {
                    "type": "string"
                },
                "sitePath": {
                    "type": "string"
                },
                "status": {
                    "type": "string"
                },
                "type": {
                    "type": "string"
                },
                "updatedAt": {
                    "type": "string"
                },
                "user": {
                    "type": "string"
                },
                "webSiteGroupId": {
                    "type": "integer"
                },
                "webSiteSSL": {
                    "$ref": "#/definitions/model.WebsiteSSL"
                },
                "webSiteSSLId": {
                    "type": "integer"
                }
            }
        },
        "response.WebsiteHTTPS": {
            "type": "object",
            "properties": {
                "SSL": {
                    "$ref": "#/definitions/model.WebsiteSSL"
                },
                "SSLProtocol": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "algorithm": {
                    "type": "string"
                },
                "enable": {
                    "type": "boolean"
                },
                "httpConfig": {
                    "type": "string"
                }
            }
        },
        "response.WebsiteLog": {
            "type": "object",
            "properties": {
                "content": {
                    "type": "string"
                },
                "enable": {
                    "type": "boolean"
                },
                "end": {
                    "type": "boolean"
                },
                "path": {
                    "type": "string"
                }
            }
        },
        "response.WebsiteNginxConfig": {
            "type": "object",
            "properties": {
                "enable": {
                    "type": "boolean"
                },
                "params": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/response.NginxParam"
                    }
                }
            }
        },
        "response.WebsitePreInstallCheck": {
            "type": "object",
            "properties": {
                "appName": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "status": {
                    "type": "string"
                },
                "version": {
                    "type": "string"
                }
            }
        },
        "response.WebsiteWafConfig": {
            "type": "object",
            "properties": {
                "content": {
                    "type": "string"
                },
                "enable": {
                    "type": "boolean"
                }
            }
        }
    }
}`

// SwaggerInfo holds exported Swagger Info so clients can modify it
var SwaggerInfo = &swag.Spec{
	Version:          "1.0",
	Host:             "localhost",
	BasePath:         "/api/v1",
	Schemes:          []string{},
	Title:            "1Panel",
	Description:      "开源Linux面板",
	InfoInstanceName: "swagger",
	SwaggerTemplate:  docTemplate,
}

func init() {
	swag.Register(SwaggerInfo.InstanceName(), SwaggerInfo)
}
