import fit2cloudEnLocale from 'fit2cloud-ui-plus/src/locale/lang/en';
const message = {
    commons: {
        true: 'true',
        false: 'false',
        example: 'e.g.:',
        button: {
            create: 'Create ',
            add: 'Add ',
            save: 'Save ',
            set: 'Setting',
            sync: 'Sync ',
            delete: 'Delete ',
            edit: 'Edit',
            enable: 'Enable',
            disable: 'Disable',
            confirm: 'Confirm',
            cancel: 'Cancel',
            reset: 'Reset',
            restart: 'Restart',
            conn: 'Connect',
            disconn: 'Disconnect',
            clean: 'Clean',
            login: 'Login',
            close: 'Close',
            stop: 'Stop',
            start: 'Start',
            view: 'View',
            watch: 'Watch',
            handle: 'Handle',
            expand: 'Expand',
            collapse: 'Collapse',
            log: 'Log',
            back: 'Back',
            backup: 'Backup',
            recover: 'Recover',
            retry: 'Retry',
            upload: 'Upload',
            download: 'Download',
            init: 'Init',
            verify: 'Verify',
            saveAndEnable: 'Save and enable',
            import: 'Import',
            search: 'Search',
            refresh: 'Refresh',
            get: 'Get',
            upgrade: 'Upgrade',
            ignore: 'Ignore upgrade',
            copy: 'Copy',
            random: 'Random',
            uninstall: 'Uninstall',
            fullscreen: 'Fullscreen',
            quitFullscreen: 'Quit Fullscreen',
        },
        search: {
            timeStart: 'Time start',
            timeEnd: 'Time end',
            timeRange: 'To',
            dateStart: 'Date start',
            dateEnd: 'Date end',
        },
        table: {
            all: 'All',
            total: 'Total {0}',
            name: 'Name',
            type: 'Type',
            status: 'Status',
            statusSuccess: 'Success',
            statusFailed: 'Failed',
            statusWaiting: 'Waiting...',
            records: 'Records',
            group: 'Group',
            createdAt: 'Creation Time',
            publishedAt: 'Publish Time',
            date: 'Date',
            updatedAt: 'Update Time',
            operate: 'Operations',
            message: 'Message',
            description: 'Description',
            interval: 'Interval',
            user: 'User',
            title: 'Title',
            port: 'Port',
            protocol: 'Protocol',
            tableSetting: 'Table setting',
            autoRefresh: 'Auto refresh',
            refreshRate: 'Rate',
        },
        loadingText: {
            Upgrading: 'System upgrade, please wait...',
            Restarting: 'System restart, please wait...',
            Recovering: 'Recovering from snapshot, please wait...',
            Rollbacking: 'Rollbacking from snapshot, please wait...',
        },
        msg: {
            noneData: 'No data available',
            delete: 'This operation delete cannot be rolled back. Do you want to continue?',
            clean: 'This operation clean cannot be rolled back. Do you want to continue?',
            deleteTitle: 'Delete',
            deleteSuccess: 'Delete Success',
            loginSuccess: 'Login Success',
            operationSuccess: 'Successful operation',
            copySuccess: 'Copy Successful',
            notSupportOperation: 'This operation is not supported',
            requestTimeout: 'The request timed out, please try again later',
            infoTitle: 'Hint',
            notRecords: 'No execution record is generated for the current task',
            sureLogOut: 'Are you sure you want to log out?',
            createSuccess: 'Create Success',
            updateSuccess: 'Update Success',
            uploadSuccess: 'Update Success',
            operate: 'Operate',
            operateConfirm: 'If you are sure about the operation, please input it manually',
            inputOrSelect: 'Please select or enter',
            copyFailed: 'Copy failed',
            notFound: 'Sorry, the page you requested does not exist.',
            unSupportType: 'Current file type is not supported!',
            unSupportSize: 'The uploaded file exceeds {0}M, please confirm!',
            fileExist: 'The file already exists in the current folder. Repeat uploading is not supported!',
            fileNameErr:
                'You can upload only files whose name contains 1 to 256 characters, including English, Chinese, digits, or periods (.-_)',
            confirmNoNull: 'Make sure the value {0} is not empty',
            errPort: 'Incorrect port information, please confirm!',
        },
        login: {
            username: 'UserName',
            password: 'Password',
            welcome: 'Welcome back, please enter your username and password to log in!',
            errorAuthInfo: 'The user name or password you entered is incorrect, please re-enter!',
            errorMfaInfo: 'Incorrect authentication information, please try again!',
            captchaHelper: 'Captcha',
            errorCaptcha: 'Captcha code error!',
            notSafe: 'Access Denied',
            safeEntrance1: 'The secure login has been enabled in the current environment',
            safeEntrance2: 'Enter the following command on the SSH terminal to view the panel entry: 1pctl user-info',
            errIP1: 'Authorized IP address access is enabled in the current environment',
            errDomain1: 'Access domain name binding is enabled in the current environment',
            errHelper: 'To reset the binding information, run the following command on the SSH terminal: ',
            codeInput: 'Please enter the 6-digit verification code of the MFA validator',
            mfaTitle: 'MFA Certification',
            mfaCode: 'MFA verification code',
            title: 'Linux Server Management Panel',
            licenseHelper:
                'Agree &laquo; <a href="https://www.fit2cloud.com/legal/licenses.html" target="_blank">Community License Agreement</a> &raquo;',
            errorAgree: 'Please click to agree to the Community Software License Agreement',
            logout: 'Logout',
        },
        rule: {
            username: 'Please enter a username',
            password: 'Please enter a password',
            rePassword: 'The passwords are inconsistent. Please check and re-enter the password',
            requiredInput: 'Please enter the required fields',
            requiredSelect: 'Please select the required fields',
            illegalInput: 'There are illegal characters in the input box.',
            commonName: 'Support English, Chinese, numbers, .-, and _ length 1-30',
            userName: 'Support English, Chinese, numbers and _ length 3-30',
            simpleName: 'Support English, numbers and _ length 1-30',
            dbName: 'Support English, Chinese, numbers, .-, and _ length 1-64',
            imageName: 'Support English, numbers, :/.-_, length 1-150',
            volumeName: 'Support English, numbers, .-_, length 2-30',
            complexityPassword:
                'Longer than eight characters and contains at least two combinations of letters, digits, and special characters',
            commonPassword: 'Please enter a password with more than 6 characters',
            linuxName: 'Length 1-128, the name cannot contain symbols such as {0}',
            email: 'Email format error',
            number: 'Please enter the correct number',
            integer: 'Please enter the correct positive integer',
            ip: 'Please enter the correct IP address',
            host: 'Enter the correct IP address or domain name',
            hostHelper: 'Support input of IP address or domain',
            port: 'Please enter the correct port',
            selectHelper: 'Please select the correct {0} file',
            domain: 'domain name format error',
            databaseName: 'Support English, numbers, _, length 1-30',
            ipErr: 'IP [{0}] format error, please check',
            numberRange: 'Number range: {0} - {1}',
            paramName: 'Support English, numbers, .- and _, length 2-30',
            paramComplexity:
                'Support English, numbers, {0}, length 6-128,Special characters cannot be at the beginning and end',
            paramUrlAndPort: 'The format is http(s)://(domain name/ip):(port)',
            nginxDoc: 'Only supports English case, numbers, and .',
            appName: 'Support English, numbers, - and _, length 2-30, and cannot start and end with -_',
            containerName: 'Supports letters, numbers, -, _ and .; cannot start with - _ or .; length: 1-127',
            mirror: 'Support image accelerator addresses that start with http(s)://, English uppercase and lowercase letters, numbers, periods, and hyphens, and there should be no empty lines.',
            disableFunction: 'Only support letters ,underscores,and,',
            leechExts: 'Only support letters, numbers and,',
            paramSimple: 'Support lowercase letters and numbers, length 1-128',
        },
        res: {
            paramError: 'The request failed, please try again later!',
            forbidden: 'The current user has no permission',
            serverError: 'Service exception',
            notFound: 'The resource does not exist',
            commonError: 'The request failed',
        },
        service: {
            serviceNotStarted: 'The {0} service is not currently started',
        },
        status: {
            running: 'Running',
            done: 'Done',
            success: 'Success',
            waiting: 'Waiting',
            waiting1: 'Waiting',
            failed: 'Failed',
            stopped: 'Stopped',
            error: 'Error',
            created: 'Created',
            restarting: 'Restarting',
            uploading: 'Uploading',
            unhealthy: 'Unhealthy',
            removing: 'Removing',
            paused: 'Paused',
            exited: 'Exited',
            installing: 'Installing',
            enabled: 'Enabled',
            disabled: 'Disabled',
            normal: 'Normal',
            building: 'Building',
            downloaderr: 'Download Error',
            upgrading: 'Upgrading',
            upgradeerr: 'Upgrade Error',
            pullerr: 'Pull Image Error',
            rebuilding: 'ReBuilding',
            deny: 'Denied',
            accept: 'Accepted',
            used: 'Used',
            unUsed: 'Unused',
            starting: 'Starting',
            recreating: 'Recreating',
            creating: 'Creating',
        },
        units: {
            second: 'Second',
            minute: 'Minute',
            hour: 'Hour',
            day: 'Day',
            week: 'Week',
            month: 'Month',
            year: 'Year',
            time: 'Time',
            core: 'Core',
        },
        operate: {
            down: 'Stop',
            up: 'Start',
            restart: 'Restart',
            install: 'Install',
            uninstall: 'Uninstall',
            update: 'Update',
        },
    },
    menu: {
        home: 'Overview',
        apps: 'App Store',
        website: 'Website',
        project: 'Project',
        config: 'Config',
        ssh: 'SSH Setting',
        firewall: 'Firewall',
        ssl: 'Certificate',
        database: 'Database',
        container: 'Container',
        cronjob: 'Cronjob',
        host: 'Host',
        security: 'Security',
        files: 'File',
        monitor: 'Monitor',
        terminal: 'Terminal',
        settings: 'Setting',
        toolbox: 'Toolbox',
        logs: 'Log',
        runtime: 'Runtime',
        processManage: 'Process',
        process: 'Process',
        network: 'Network',
        supervisor: 'Supervisor',
    },
    home: {
        overview: 'Overview',
        entranceHelper:
            'Enabling a secure entrance can help improve system security. If necessary, go to the Control Panel settings, select Security, and enable the secure entrance.',
        appInstalled: 'App installed',
        systemInfo: 'System info',
        hostname: 'Hostname',
        platformVersion: 'Platform version',
        kernelVersion: 'Kernel version',
        kernelArch: 'Kernel arch',
        network: 'Network',
        io: 'Disk IO',
        baseInfo: 'Base info',
        totalSend: 'Total send',
        totalRecv: 'Total recv',
        rwPerSecond: 'IO times',
        ioDelay: 'IO delay',
        uptime: 'Up Time',
        runningTime: 'Running Time',

        runSmoothly: 'Run smoothly',
        runNormal: 'Run normal',
        runSlowly: 'Run slowly',
        runJam: 'Run Blockaged',

        core: 'Physical core',
        logicCore: 'Logic core',
        loadAverage: 'Average load in the last {0} minutes',
        load: 'Load',
        mount: 'Mount point',
        fileSystem: 'File system',
        total: 'Total',
        used: 'Used',
        free: 'Free',
        percent: 'Percent',
        app: 'Recommended Apps',
        goInstall: 'Go install',

        networkCard: 'NetworkCard',
        disk: 'Disk',
    },
    tabs: {
        more: 'More',
        hide: 'Hide',
        closeCurrent: 'Close current',
        closeOther: 'Close other',
        closeAll: 'Close All',
    },
    header: {
        logout: 'Logout',
    },
    database: {
        database: 'database',
        deleteBackupHelper: 'Delete database backups simultaneously',
        delete: 'Delete operation cannot be rolled back, please input "',
        deleteHelper: '" to delete this database',
        create: 'Create database',
        noMysql: 'Database service (MySQL or MariaDB)',
        goUpgrade: 'Go for upgrade',
        goInstall: 'Go for install',
        source: 'Source',
        permission: 'Permission',
        permissionForIP: 'IP',
        permissionAll: 'All of them(%)',
        databaseConnInfo: 'Conn info',
        rootPassword: 'Root password',
        serviceName: 'Service Name',
        serviceNameHelper: 'Access between containers in the same network.',
        backupList: 'Backup',
        loadBackup: 'Import',
        remoteAccess: 'Remote access',
        remoteHelper: 'Multiple IP comma-delimited, example: 172.16.10.111, 172.16.10.112',
        remoteConnHelper:
            'Remote connection to mysql as user root may have security risks. Therefore, perform this operation with caution.',
        changePassword: 'Password',
        changePasswordHelper:
            'The database has been associated with an application. Changing the password will change the database password of the application at the same time. The change takes effect after the application restarts.',

        confChange: 'Configuration change',
        confNotFound:
            'The configuration file could not be found. Please upgrade the application to the latest version in the app store and try again!',

        portHelper:
            'This port is the exposed port of the container. You need to save the modification separately and restart the container!',

        loadFromRemote: 'load from Server',
        loadFromRemoteHelper:
            'This action will synchronize the database info on the server to 1Panel, do you want to continue?',
        passwordHelper: 'Unable to retrieve, please modify',
        local: 'Local',
        remote: 'Remote',
        remoteDB: 'Remote DB',
        createRemoteDB: 'Create Remote Server',
        editRemoteDB: 'Edit Remote Server',
        localDB: 'Local DB',
        address: 'DB address',
        version: 'DB version',
        userHelper: 'The root user or a database user with root privileges can access the remote database.',

        selectFile: 'Select file',
        dropHelper: 'You can drag and drop the uploaded file here or',
        clickHelper: 'click to upload',
        supportUpType: 'Only sql, sql.gz, and tar.gz files are supported',
        zipFormat: 'tar.gz compressed package structure: test.tar.gz compressed package must contain test.sql',

        currentStatus: 'Current state',
        baseParam: 'Basic parameter',
        performanceParam: 'Performance parameter',
        runTime: 'Startup time',
        connections: 'Total connections',
        bytesSent: 'Send bytes',
        bytesReceived: 'Received bytes',
        queryPerSecond: 'Query per second',
        txPerSecond: 'Tx per second',
        connInfo: 'active/peak connections',
        connInfoHelper: 'If the value is too large, increase max_connections',
        threadCacheHit: 'Thread cache hit',
        threadCacheHitHelper: 'If it is too low, increase thread_cache_size',
        indexHit: 'Index hit',
        indexHitHelper: 'If it is too low, increase key_buffer_size',
        innodbIndexHit: 'Innodb index hit rate',
        innodbIndexHitHelper: 'If it is too low, increase innodb_buffer_pool_size',
        cacheHit: 'Querying the Cache Hit',
        cacheHitHelper: 'If it is too low, increase query_cache_size',
        tmpTableToDB: 'Temporary table to disk',
        tmpTableToDBHelper: 'If it is too large, try increasing tmp_table_size',
        openTables: 'Open tables',
        openTablesHelper: 'The configuration value of table_open_cache must be greater than or equal to this value',
        selectFullJoin: 'Select full join',
        selectFullJoinHelper: 'If the value is not 0, check whether the index of the data table is correct',
        selectRangeCheck: 'The number of joins with no index',
        selectRangeCheckHelper: 'If the value is not 0, check whether the index of the data table is correct',
        sortMergePasses: 'Number of sorted merges',
        sortMergePassesHelper: 'If the value is too large, increase sort_buffer_size',
        tableLocksWaited: 'Lock table number',
        tableLocksWaitedHelper: 'If the value is too large, consider increasing your database performance',

        performanceTuning: 'Performance tuning',
        optimizationScheme: 'Optimization scheme',
        keyBufferSizeHelper: 'Buffer size for index',
        queryCacheSizeHelper: 'Query cache. If this function is disabled, set this parameter to 0',
        tmpTableSizeHelper: 'Temporary table cache size',
        innodbBufferPoolSizeHelper: 'Innodb buffer size',
        innodbLogBufferSizeHelper: 'Innodb log buffer size',
        sortBufferSizeHelper: '* connections, buffer size per thread sort',
        readBufferSizeHelper: '* connections, read buffer size',
        readRndBufferSizeHelper: '* connections, random read buffer size',
        joinBufferSizeHelper: '* connections, association table cache size',
        threadStackelper: '* connections, stack size per thread',
        binlogCacheSizeHelper: '* onnections, binary log cache size (multiples of 4096)',
        threadCacheSizeHelper: 'Thread pool size',
        tableOpenCacheHelper: 'Table cache',
        maxConnectionsHelper: 'Max connections',
        restart: 'Restart',

        log: 'Logs',
        slowLog: 'Slowlogs',
        noData: 'No slow log yet...',

        isOn: 'On',
        longQueryTime: 'threshold(s)',
        thresholdRangeHelper: 'Please enter the correct threshold (1 - 600).',

        timeout: 'Timeout',
        timeoutHelper: 'Idle connection timeout period. 0 indicates that the connection is on continuously',
        maxclients: 'Max clients',
        requirepassHelper:
            'Leave this blank to indicate that no password has been set. Changes need to be saved separately and the container restarted!',
        databases: 'Number of databases',
        maxmemory: 'Maximum memory usage',
        maxmemoryHelper: '0 indicates no restriction',
        tcpPort: 'Current listening port',
        uptimeInDays: 'Days in operation',
        connectedClients: 'Number of connected clients',
        usedMemory: 'Redis indicates the peak value of memory allocated historically',
        usedMemoryRss: 'Total system memory used by Redis',
        memFragmentationRatio: 'Memory fragmentation ratio',
        totalConnectionsReceived: 'Total number of clients connected since run',
        totalCommandsProcessed: 'The total number of commands executed since the run',
        instantaneousOpsPerSec: 'Number of commands executed by the server per second',
        keyspaceHits: 'The number of times a database key was successfully found',
        keyspaceMisses: 'Number of failed attempts to find the database key',
        hit: 'Find the database key hit ratio',
        latestForkUsec: 'The number of microseconds spent on the last fork() operation',

        recoverHelper: 'Data is about to be overwritten with [{0}]. Do you want to continue?',
        submitIt: 'Overwrite the data',

        baseConf: 'Basic configuration',
        allConf: 'All configuration',
        restartNow: 'Restart now',
        restartNowHelper1:
            'You need to restart the system after the configuration changes take effect. If your data needs to be persisted, perform the save operation first.',
        restartNowHelper: 'The modification takes effect only after the system restarts.',

        persistence: 'Persistence',
        rdbHelper1: 'In seconds, insert',
        rdbHelper2: 'The data',
        rdbHelper3: 'Meeting either condition triggers RDB persistence',
        rdbInfo: 'Ensure that the value in the rule list ranges from 1 to 100000',

        containerConn: 'Container connection address',
        containerConnHelper: 'PHP runtime environment/container-installed applications use this connection address',
        remoteConn: 'External connection address',
        remoteConnHelper2: 'Use this address for non-container or external connections',
        localIP: 'Local IP',
    },
    container: {
        create: 'Create container',
        edit: 'Edit container',
        updateContainerHelper:
            'Container editing requires rebuilding the container. Any data that has not been persisted will be lost. Do you want to continue?',
        containerList: 'Container list',
        operatorHelper: '{0} will be performed on the following container, Do you want to continue?',
        operatorAppHelper:
            'The {0} operation will be performed on the following containers, some of which are from the App Store. This operation may affect the normal use of the service, Do you want to continue?',
        start: 'Start',
        stop: 'Stop',
        restart: 'Restart',
        kill: 'Kill',
        pause: 'Pause',
        unpause: 'Unpause',
        rename: 'Rename',
        remove: 'Remove',
        containerPrune: 'Container prune',
        containerPruneHelper1: 'Cleaning containers will delete all containers that are in a stopped state.',
        containerPruneHelper2:
            'If the containers are from the app store, after performing the cleanup, you need to go to the [Installed] list in the [App Store] and click the [Rebuild] button to reinstall them.',
        containerPruneHelper3: 'This operation cannot be rolled back. Do you want to continue?',
        imagePrune: 'Image prune',
        imagePruneSome: 'Clean unlabeled',
        imagePruneSomeHelper: 'Clean the images with the tag "none" that are not used by any containers.',
        imagePruneAll: 'Clean unused',
        imagePruneAllHelper: 'Clean the images that are not used by any containers.',
        networkPrune: 'Network prune',
        networkPruneHelper: 'Remove all unused networks. Do you want to continue?',
        volumePrune: 'Volume prune',
        volumePruneHelper: 'Remove all unused local volumes. Do you want to continue?',
        cleanSuccess: 'The operation is successful, the number of this cleanup: {0}!',
        cleanSuccessWithSpace:
            'The operation is successful. The number of disks cleared this time is {0}. The disk space freed is {1}!',
        container: 'Container',
        unExposedPort: 'The current port mapping address is 127.0.0.1, which cannot enable external access.',
        upTime: 'UpTime',
        all: 'All',
        fetch: 'Fetch',
        lines: 'Lines',
        linesHelper: 'Please enter the correct number of logs to retrieve!',
        lastDay: 'Last Day',
        last4Hour: 'Last 4 Hours',
        lastHour: 'Last Hour',
        last10Min: 'Last 10 Minutes',
        cleanLog: 'Clean log',
        downLogHelper1: 'Are you sure you want to download all logs for container {0}?',
        downLogHelper2: 'Are you sure you want to download the recent {1} logs for container {0}?',
        cleanLogHelper:
            'Clearing logs requires restarting the container, and this operation cannot be rolled back. Do you want to continue?',
        newName: 'New name',
        source: 'Resource rate',
        cpuUsage: 'CPU Usage',
        cpuTotal: 'CPU Total',
        core: 'Core',
        memUsage: 'Memory Usage',
        memTotal: 'Memory Limit',
        memCache: 'Memory Cache',
        ip: 'IP address',
        cpuShare: 'CPU Share',
        cpuShareHelper:
            'The default CPU share for a container is 1024, which can be increased to give the container more CPU time.',

        command: 'Command',
        console: 'Console Interaction',
        tty: 'TTY (-t)',
        openStdin: 'OpenStdin (-i)',
        custom: 'Custom',
        emptyUser: 'When empty, you will log in as  default',
        containerTerminal: 'Terminal',

        upgradeHelper: 'This operation only supports upgrading container versions.',
        ignoreCompare: 'Force Upgrade',
        ignoreCompareHelper:
            'Skip the comparison between old and new versions, upgrade directly. This operation may result in service unavailability.',
        upgradeWarning: 'The target version is lower than the original image version. Please try again!',
        upgradeWarning2:
            'The upgrade operation requires rebuilding the container, and any non-persistent data will be lost. Do you want to continue?',
        oldImage: 'Current image',
        targetImage: 'Target image',
        targetImageHelper: 'Please enter the target image version',
        appHelper:
            'This container is sourced from the application store. Upgrading it may cause the service to be unavailable.',

        input: 'Input',
        forcePull: 'forced image pull ',
        forcePullHelper: 'Ignore existing images on the server and pull again.',
        server: 'Host',
        serverExample: 'e.g. 80, 80-88, ip:80 or ip:80-88',
        containerExample: 'e.g. 80 or 80-88',
        exposePort: 'Expose port',
        exposeAll: 'Expose all',
        cmdHelper: "e.g. 'nginx' '-g' 'daemon off;' OR nginx -g daemon off;",
        entrypointHelper: 'e.g. /bin/sh -c',
        autoRemove: 'Auto remove',
        cpuQuota: 'NacosCPU',
        memoryLimit: 'Memory',
        limitHelper: 'If you limit it to 0, then the limitation is turned off, and the maximum available is {0}.',
        mount: 'Mount',
        volumeOption: 'Volume',
        hostOption: 'Host',
        serverPath: 'Server path',
        containerDir: 'Container path',
        volumeHelper: 'Ensure that the content of the storage volume is correct',
        modeRW: 'RW',
        modeR: 'R',
        mode: 'Mode',
        env: 'Environment',
        restartPolicy: 'Restart policy',
        always: 'always',
        unlessStopped: 'unless-stopped',
        onFailure: 'on-failure（five times by default）',
        no: 'never',

        monitor: 'Monitor',
        refreshTime: 'Refresh time',
        cache: 'Cache',

        image: 'Image',
        imagePull: 'Image pull',
        imagePush: 'Image push',
        imageDelete: 'Image delete',
        imageDeleteTag: 'Image tag delete',
        repoName: 'Repo Name',
        imageName: 'Image name',
        pull: 'Pull',
        path: 'Path',
        importImage: 'Image import',
        build: 'Build',
        imageBuild: 'Image build',
        pathSelect: 'Path',
        label: 'Label',
        imageTag: 'Image Tag',
        push: 'Push',
        fileName: 'FileName',
        export: 'Export',
        exportImage: 'Image export',
        version: 'Version',
        size: 'Size',
        from: 'From',
        tag: 'Tag',
        tagHelper: 'one in a row, for example, \nkey1=value1\nkey2=value2',
        imageNameHelper: 'Image name and Tag, for example: nginx:latest',

        network: 'Network',
        createNetwork: 'Create network',
        networkName: 'Name',
        driver: 'Driver',
        option: 'Option',
        attachable: 'Attachable',
        subnet: 'Subnet',
        scope: 'IP Scope',
        gateway: 'Gateway',

        volume: 'Volume',
        volumeDir: 'Volume dir',
        nfsEnable: 'Enable NFS storage',
        nfsAddress: 'Address',
        mountpoint: 'Mountpoint',
        mountpointNFSHelper: 'e.g. /nfs, /nfs-share',
        options: 'Options',
        createVolume: 'Create volume',

        repo: 'Repo',
        createRepo: 'Add repo',
        httpRepo: 'The http repository needs to restart the docker service to add credit',
        delInsecure: 'Deletion of credit',
        delInsecureHelper: 'docker service needs to be restarted to delete the credit. Do you want to delete it?',
        downloadUrl: 'Download URL',
        imageRepo: 'Image repo',
        repoHelper: 'Does it include a mirror repository/organization/project?',
        auth: 'Auth',
        mirrorHelper:
            'If there are multiple mirrors, newlines must be displayed, for example:\nhttp://xxxxxx.m.daocloud.io \nhttps://xxxxxx.mirror.aliyuncs.com',
        registrieHelper:
            'If multiple private repositories exist, newlines must be displayed, for example:\n172.16.10.111:8081 \n172.16.10.112:8081',

        compose: 'Compose',
        fromChangeHelper: 'Switching the source will clear the current edited content. Do you want to continue?',
        composePathHelper: 'Config file save path: {0}',
        composeHelper:
            'The composition created through 1Panel editor or template will be saved in the {0}/docker/compose directory.',
        deleteFile: 'Delete file',
        deleteComposeHelper:
            'Delete all files in the {0} directory, including persistent files in this directory. Please proceed with caution!',
        deleteCompose: '" Delete this composition.',
        apps: 'Apps',
        local: 'Local',
        createCompose: 'Create compose',
        template: 'Template',
        composeTemplate: 'Compose template',
        createComposeTemplate: 'Create compose template',
        description: 'Description',
        content: 'Content',
        contentEmpty: 'Compose content cannot be empty, please enter and try again!',
        containerNumber: 'Container number',
        down: 'Down',
        up: 'Up',
        composeDetailHelper:
            'The compose is created external to 1Panel. The start and stop operations are not supported.',
        composeOperatorHelper: '{1} operation will be performed on {0}. Do you want to continue?',

        setting: 'Setting',
        operatorStatusHelper: 'This action will {0} Docker service, do you want to continue?',
        dockerStatus: 'Docker Service',
        daemonJsonPathHelper: 'Ensure that the configuration path is the same as that specified in docker.service.',
        mirrors: 'Registry mirrors',
        mirrorsHelper:
            'The acceleration URL is preferred to perform operations. If this parameter is set to empty, mirror acceleration is disabled.',
        mirrorsHelper2: 'For details, see the official documents, ',
        registries: 'Insecure registries',
        cutLog: 'Log option',
        cutLogHelper1: 'The current configuration will only affect newly created containers.',
        cutLogHelper2: 'Existing containers need to be recreated for the configuration to take effect.',
        cutLogHelper3:
            'Please note that recreating containers may result in data loss. If your containers contain important data, make sure to backup before performing the rebuilding operation.',
        maxSize: 'Max-Size',
        maxFile: 'Max-File',
        liveHelper:
            'Allows the running container state to be preserved in case of unexpected shutdown or crash of the Docker daemon',
        liveWithSwarmHelper: 'live-restore daemon configuration is incompatible with swarm mode.',
        iptablesDisable: 'Close iptables',
        iptablesHelper1: 'Automatic configuration of iptables rules for Docker.',
        iptablesHelper2:
            'Disabling iptables will result in the containers being unable to communicate with external networks.',
        daemonJsonPath: 'Conf Path',
        serviceUnavailable: 'Docker service is not started at present, please click',
        startIn: ' to start',
    },
    cronjob: {
        create: 'Create Cronjob',
        edit: 'Edit Cronjob',
        cronTask: 'Cronjob',
        changeStatus: 'Change status',
        disableMsg:
            'Stopping the scheduled task will result in the task no longer automatically executing. Do you want to continue?',
        enableMsg:
            'Enabling the scheduled task will allow the task to automatically execute on a regular basis. Do you want to continue?',
        taskType: 'Cronjob type',
        record: 'Records',
        shell: 'Shell script',
        containerCheckBox: 'In container (no need to enter the container command)',
        containerName: 'Container name',
        ntp: 'Time synchronization',
        app: 'Backup app',
        website: 'Backup website',
        rulesHelper:
            'When there are multiple compression exclusion rules, they need to be displayed with line breaks. For example: \n*.log \n*.sql',
        lastRecordTime: 'Last execution time',
        all: 'All',
        failedRecord: 'Failed records',
        successRecord: 'Successful records',
        database: 'Backup database',
        missBackupAccount: 'The backup account could not be found',
        syncDate: 'Synchronization time ',
        releaseMemory: 'Free memory',
        curl: 'Access URL',
        taskName: 'Cronjob name',
        cronSpec: 'Lifecycle',
        cronSpecHelper: 'Enter the correct execution period',
        cleanHelper:
            'This operation records all job execution records, backup files, and log files. Do you want to continue?',
        directory: 'Backup directory',
        sourceDir: 'Backup directory',
        snapshot: 'System Snapshot',
        allOptionHelper:
            'The current task plan is to back up all [{0}]. Direct download is not supported at the moment. You can check the backup list of [{0}] menu.',
        exclusionRules: 'Exclusive rule',
        saveLocal: 'Retain local backups (the same as the number of cloud storage copies)',
        url: 'URL Address',
        target: 'Target',
        targetHelper: 'Third-party backup accounts are maintained in panel settings.',
        retainCopies: 'Retain copies',
        retainCopiesHelper: 'Number of copies of execution records, log files, and backup files',
        cronSpecRule: 'Please enter a correct lifecycle',
        perMonth: 'Every monthly',
        perWeek: 'Every week',
        perHour: 'Every hour',
        perNDay: 'Every N days',
        perDay: 'Every days',
        perNHour: 'Every N hours',
        perNMinute: 'Every N minutes',
        perNSecond: 'Every N seconds',
        per: 'Every ',
        handle: 'Handle',
        day: 'Day',
        monday: 'Monday',
        tuesday: 'Tuesday',
        wednesday: 'Wednesday',
        thursday: 'Thursday',
        friday: 'Friday',
        saturday: 'Saturday',
        sunday: 'Sunday',
        shellContent: 'Script content',
        errRecord: 'Incorrect logging',
        errHandle: 'Cronjob execution failure',
        noRecord: 'The execution did not generate any logs',
        cleanData: 'Clean data',
        cleanDataHelper: 'Delete the backup file generated during this task.',
        noLogs: 'No task output yet...',
        errPath: 'Backup path [{0}] error, cannot download!',
        cutWebsiteLog: 'cut website log',
        cutWebsiteLogHelper: 'The cut log files will be backed up to the backup directory of 1Panel',
    },
    monitor: {
        monitor: 'Monitor',
        globalFilter: 'Global Filter',
        enableMonitor: 'Enable',
        storeDays: 'Expiration days',
        cleanMonitor: 'Clearing monitoring records',

        avgLoad: 'Average load',
        loadDetail: 'Load detail',
        resourceUsage: 'Resource utilization rate',
        networkCard: 'NetworkCard',
        read: 'Read',
        write: 'Write',
        readWriteCount: 'Read or write Times',
        readWriteTime: 'Read or write delay',
        today: 'Today',
        yesterday: 'Yesterday',
        lastNDay: 'Last {0} day',
        memory: 'Memory',
        cache: 'Cache',
        disk: 'Disk',
        network: 'Network',
        up: 'Up',
        down: 'Down',
        interval: 'Interval(min)',
    },
    terminal: {
        conn: 'connection',
        connLocalErr: 'Unable to automatically authenticate, please fill in the local server login information!',
        testConn: 'Test connection',
        saveAndConn: 'Save and Connect',
        connTestOk: 'Connection information available',
        connTestFailed: 'Connection unavailable, please check connection information!',
        host: 'Host',
        createConn: 'New connection',
        group: 'Group',
        noHost: 'No host',
        groupChange: 'Change group',
        expand: 'Expand all',
        fold: 'All contract',
        batchInput: 'Batch input',
        quickCommand: 'Quick command',
        quickCommandHelper: 'Frequently used command list for quick selection at the bottom of the terminal interface',
        groupDeleteHelper:
            'After the group is removed, all connections in the group will be migrated to the default group. Confirm the information',
        command: 'Command',
        quickCmd: 'Quick command',
        addHost: 'Add Host',
        localhost: 'Localhost',
        ip: 'Address',
        authMode: 'Auth Mode',
        passwordMode: 'Password',
        rememberPassword: 'Remember password',
        keyMode: 'PrivateKey',
        key: 'Private key',
        keyPassword: 'Private key password',
        emptyTerminal: 'No terminal is currently connected',
    },
    logs: {
        panelLog: 'Panel logs',
        operation: 'Operation logs',
        login: 'Login logs',
        loginIP: 'Login IP',
        loginAddress: 'Login address',
        loginAgent: 'Login agent',
        loginStatus: 'Login status',
        system: 'System logs',
        deleteLogs: 'Clearing Logs',
        resource: 'Resource',
        operate: 'Operate',
        detail: {
            hosts: 'Host',
            apps: 'App',
            websites: 'Website',
            containers: 'Container',
            files: 'File Manage',
            runtimes: 'Runtime',
            process: 'Process',
            logs: 'Panel Logs',
            settings: 'Panel Setting',
            cronjobs: 'Cronjob',
            databases: 'Database',
        },
        websiteLog: 'Website Log',
        runLog: 'Run Log',
        errLog: 'Err Log',
    },
    file: {
        dir: 'Folder',
        upload: 'Upload',
        download: 'Download',
        fileName: 'File name',
        search: 'Find',
        mode: 'Permission',
        owner: 'Owner',
        file: 'File',
        remoteFile: 'Remote download',
        share: 'Share',
        sync: 'Data Synchronization',
        size: 'Size',
        updateTime: 'Modification Time',
        open: 'Open',
        rename: 'Rename',
        role: 'Permission',
        info: 'Attribute',
        linkFile: 'Soft link',
        terminal: 'Terminal',
        shareList: 'Share list',
        zip: 'Compressed',
        group: 'User group',
        path: 'Path',
        public: 'Public',
        setRole: 'Set permissions',
        link: 'Whether to link',
        rRole: 'Read',
        wRole: 'Write',
        xRole: 'Executable',
        name: 'Name',
        compress: 'Compress',
        deCompress: 'Decompress',
        compressType: 'Compress format',
        compressDst: 'Compress path',
        replace: 'Overwrite existing files',
        compressSuccess: 'Compressed successfully',
        deCompressSuccess: 'Decompress succeeded',
        deCompressDst: 'Decompress path',
        linkType: 'Link Type',
        softLink: 'Soft link',
        hardLink: 'Hard link',
        linkPath: 'Link Path',
        selectFile: 'Select file',
        downloadSuccess: 'Download succeeded',
        downloadUrl: 'Download URL',
        downloadStart: 'Download start!',
        moveSuccess: 'Move success',
        copySuccess: 'Copy success',
        move: 'Move',
        copy: 'Copy',
        calculate: 'Calculate',
        canNotDeCompress: 'Cannot decompress this file',
        uploadSuccess: 'Upload successful!',
        downloadProcess: 'Download progress',
        downloading: 'Downloading...',
        infoDetail: 'File Properties',
        list: 'File List',
        sub: 'Include subdirectory',
        downlodSuccess: 'Download Success',
        theme: 'Theme',
        language: 'Language',
        eol: 'End Of Line',
        copyDir: 'Copy Dir',
        paste: 'Paste',
        cancel: 'Cancel',
        changeOwner: 'Modify user and user group',
        containSub: 'Modify sub-file attributes at the same time',
        ownerHelper:
            'The default user of the PHP operating environment: the user group is 1000:1000, it is normal that the users inside and outside the container show inconsistencies',
        searchHelper: 'Support wildcards such as *',
        uploadFailed: '[{0}] File Upload file',
        fileUploadStart: 'Uploading [{0}]....',
        currentSelect: 'Current Select: ',
        unsupportType: 'Unsupported file type',
        deleteHelper: 'The following resources will be deleted, this operation cannot be rolled back, continue? ',
    },
    ssh: {
        sshAlert:
            'The list data is sorted based on login time, but please note that changing time zones or other operations may cause deviations in the time of login logs.',
        sshOperate: 'Operation [{0}] on the SSH service is performed. Do you want to continue?',
        sshChange: 'SSH Setting',
        sshChangeHelper: 'This action changed {0} to [{1}]. Do you want to continue?',
        sshFileChangeHelper:
            'Modifying the configuration file may cause service availability. Exercise caution when performing this operation. Do you want to continue?',
        portHelper: 'Specifies the port number monitored by the SSH service. The default port number is 22.',
        listenAddress: 'Listening address',
        addressHelper:
            'Specify the IP address monitored by the SSH service. The default value is 0.0.0.0. That is, all network interfaces are monitored.',
        permitRootLogin: 'root user',
        rootSettingHelper: 'The default login mode is SSH for user root.',
        rootHelper1: 'Allow SSH login',
        rootHelper2: 'Disable SSH login',
        rootHelper3: 'Only key login is allowed',
        rootHelper4: 'Only predefined commands can be executed. No other operations can be performed.',
        passwordAuthentication: 'Password auth',
        pwdAuthHelper: 'Whether to enable password authentication. This parameter is enabled by default.',
        pubkeyAuthentication: 'Key auth',
        key: 'Key',
        password: 'Password',
        pubkey: 'Key info',
        encryptionMode: 'Encryption mode',
        passwordHelper: 'Can contain 6 to 10 digits and English cases',
        generate: 'Generate key',
        reGenerate: 'Regenerate key',
        keyAuthHelper: 'Whether to enable key authentication. This parameter is enabled by default.',
        useDNS: 'useDNS',
        dnsHelper:
            'Controls whether the DNS resolution function is enabled on the SSH server to verify the identity of the connection.',
        analysis: 'Statistical information',
        denyHelper:
            "Performing a 'deny' operation on the following addresses. After setting, the IP will be prohibited from accessing the server. Do you want to continue?",
        acceptHelper:
            "Performing an 'accept' operation on the following addresses. After setting, the IP will regain normal access. Do you want to continue?",
        noAddrWarning: 'No [{0}] addresses are currently selected. Please check and try again!',
        successful: 'Success',
        failed: 'Failed',
        loginLogs: 'SSH login log',
        loginMode: 'Login mode',
        authenticating: 'Key',
        publickey: 'Key',
        belong: 'Belong',
        local: 'Local',
        config: 'Configuration',
        session: 'Session',
        loginTime: 'Login Time',
        loginIP: 'Login IP',
        disconnect: 'Disconnect',
        stopSSHWarn: 'Whether to disconnect this SSH connection',
    },
    setting: {
        all: 'All',
        panel: 'Panel',
        userChange: 'Change username',
        userChangeHelper: 'Change the user name to log out. Do you want to continue?',
        user: 'User Name',
        passwd: 'Password',
        emailHelper: 'For password retrieval',
        title: 'Panel Alias',
        panelPort: 'Panel Port',
        portHelper:
            'The recommended port range is 8888 to 65535. Note: If the server has a security group, permit the new port from the security group in advance',
        portChange: 'Port change',
        portChangeHelper: 'Modify the service port and restart the service. Do you want to continue?',
        theme: 'Theme',
        dark: 'Dark',
        light: 'Light',
        language: 'Language',
        languageHelper:
            'By default, it follows the browser language. This parameter takes effect only on the current browser',
        sessionTimeout: 'Timeout',
        sessionTimeoutError: 'The minimum timeout is 300 seconds',
        sessionTimeoutHelper:
            'If you do not operate the panel for more than {0} seconds, the panel automatically logs out',
        systemIP: 'System Address',
        systemIPWarning: 'The server address is not currently set. Please set it in the control panel first!',
        defaultNetwork: 'Network Card',
        syncTime: 'Server Time',
        timeZone: 'Time Zone',
        timeZoneChangeHelper: 'Changing the time zone requires restarting the service. Do you want to continue?',
        timeZoneHelper:
            'Timezone modification depends on the system timedatectl service. take effect after restart the 1Panel service.',
        timeZoneCN: 'Bei Jing',
        timeZoneAM: 'Los Angeles',
        timeZoneNY: 'New York',
        ntpALi: 'Alibaba',
        ntpGoogle: 'Google',
        syncSite: 'Ntp Server',
        syncSiteHelper:
            'This operation will use {0} as the source for system time synchronization. Do you want to continue?',
        changePassword: 'Password change',
        oldPassword: 'Original password',
        newPassword: 'New password',
        retryPassword: 'Confirm password',
        duplicatePassword: 'The new password cannot be the same as the original password, please re-enter!',
        diskClean: 'Cache Clean',

        thirdParty: 'Third-party account',
        createBackupAccount: 'Add {0}',
        noTypeForCreate: 'No backup type is currently created',
        LOCAL: 'Server disks',
        currentPath: 'Current path',
        OSS: 'Ali OSS',
        S3: 'Amazon S3',
        MINIO: 'MINIO',
        SFTP: 'SFTP',
        OneDrive: 'Microsoft OneDrive',
        backupDir: 'Backup dir',
        isCN: 'Domestic version',
        code: 'Auth code',
        codeHelper:
            'Please click on the "Acquire" button, then login to OneDrive and copy the content after "code" in the redirected link. Paste it into this input box. For specific instructions, please refer to the official documentation.',
        loadCode: 'Acquire',
        COS: 'Tencent COS',
        KODO: 'Qiniu Kodo',
        scType: ' Storage type',
        typeStandard: 'Standard',
        typeStandard_IA: 'Standard_IA',
        typeArchive: 'Archive',
        typeDeep_Archive: 'Deep_Archive',
        scStandard:
            'Standard Storage is suitable for business scenarios with a large number of hot files that require real-time access, frequent data interaction, and so on.',
        scStandard_IA:
            'Low-frequency storage is suitable for business scenarios with relatively low access frequency, and stores data for at least 30 days.',
        scArchive: 'Archival storage is suitable for business scenarios with extremely low access frequency.',
        scDeep_Archive: 'Durable cold storage is suitable for business scenarios with extremely low access frequency.',
        archiveHelper:
            'Archival storage files cannot be downloaded directly and must first be restored through the corresponding cloud service provider`s website. Please use with caution!',
        domainHelper: 'The accelerated domain name must contain http:// or https://',
        backupAlert:
            "In theory, as long as the cloud provider is compatible with the S3 protocol, existing Amazon S3 cloud storage can be used for backup. For specific configurations, please refer to the <a target=“_blank” href='https://1panel.cn/docs/user_manual/settings/#3'>official documentation.</a> ",
        domain: 'Accelerate domain',
        backupAccount: 'Backup account',
        loadBucket: 'Get bucket',
        accountName: 'Account name',
        accountKey: 'Account key',
        address: 'Address',
        path: 'Path',

        safe: 'Security',
        entrance: 'Entrance',
        showEntrance: 'Enable Home Page Notification Not Enabled',
        entranceHelper: 'Enabling secure entry will only allow logging in to the panel through specified secure entry.',
        entranceError:
            'Please enter a secure login entry point of 6-10 characters, only numbers or letters are supported.',
        entranceInputHelper: 'When the security entry is set to blank, the security entry is cancelled.',
        randomGenerate: 'Random',
        expirationTime: 'Expiration Time',
        unSetting: 'Unset',
        noneSetting:
            'Set the expiration time for the panel password. After the expiration, you need to reset the password',
        expirationHelper: 'If the password expiration time is [0] days, the password expiration function is disabled',
        days: 'Expiration Days',
        expiredHelper: 'The current password has expired. Please change the password again.',
        timeoutHelper:
            '[ {0} days ] The panel password is about to expire. After the expiration, you need to reset the password',
        complexity: 'Complexity Verification',
        complexityHelper:
            'The password must contain at least eight characters and contain at least three uppercase letters, lowercase letters, digits, and special characters',

        bindDomain: 'Bind Domain',
        unBindDomain: 'Unbind domain',
        unBindDomainHelper:
            'The action of unbinding a domain name may cause system insecurity. Do you want to continue?',
        bindDomainHelper:
            'After the domain binding, only the domain in the setting can be used to access 1Panel service',
        bindDomainHelper1: 'If the binding domain is empty, the binding of the domain is cancelled',
        bindDomainWarning:
            'After domain binding, you will be logged out and can only access 1Panel service through the domain name specified in the settings. Do you want to continue?',
        allowIPs: 'Authorized IP',
        unAllowIPs: 'Unauthorized IP',
        unAllowIPsWarning:
            'Authorizing an empty IP will allow all IPs to access the system, which may cause system insecurity. Do you want to continue?',
        allowIPsHelper:
            'After setting the authorized IP address, only the IP address in the setting can access the 1Panel service',
        allowIPsWarning:
            'After setting the authorized IP address, only the IP address in the setting can access the 1Panel service. Do you want to continue?',
        allowIPsHelper1: 'If the authorized IP address is empty, the authorized IP address is canceled',
        allowIPEgs:
            'If multiple ip authorizations exist, newlines need to be displayed. For example, \n172.16.10.111 \n172.16.10.0/24',
        mfa: 'MFA',
        secret: 'Secret',
        mfaInterval: 'Refresh interval (s)',
        mfaTitleHelper:
            'Used to differentiate between different 1Panel hosts. After modification, please rescan or manually add the key information!',
        mfaIntervalHelper: 'Please rescan or manually add key information after modifying the refresh time.',
        mfaAlert:
            'MFA password is generated based on the current time. Please ensure that the server time is synchronized.',
        mfaHelper: 'After this function is enabled, the mobile application verification code will be verified',
        mfaHelper1: 'Download a MFA verification mobile app e.g.:',
        mfaHelper2: 'Scan the following QR code using the mobile app to obtain the 6-digit verification code',
        mfaHelper3: 'Enter six digits from the app',
        mfaCode: 'Code',
        sslChangeHelper: 'Modify the https setting and restart the service. Do you want to continue?',
        sslDisable: 'Disable',
        sslDisableHelper:
            'If the https service is disabled, you need to restart the panel for it to take effect. Do you want to continue?',

        https: 'Setting up HTTPS protocol access for the panel can enhance the security of panel access.',
        certType: 'Certificate type',
        selfSigned: 'Self signed',
        selfSignedHelper:
            'It is normal for self-signed certificates to be not trusted by browsers and display a security warning as the certificate is not issued by a trusted third party.',
        select: 'Select',
        domainOrIP: 'Domain or IP：',
        timeOut: 'Timeout',
        rootCrtDownload: 'Root certificate download',
        primaryKey: 'Primary key',
        certificate: 'Certificate',

        snapshot: 'Snapshot',
        status: 'Snapshot status',
        panelInfo: 'Write 1Panel basic information',
        panelBin: 'Backup 1Panel system files',
        daemonJson: 'Backup Docker configuration file',
        appData: 'Backup installed apps from 1Panel',
        panelData: 'Backup 1Panel data directory',
        backupData: 'Backup local backup directory for 1Panel',
        compress: 'Create snapshot file',
        upload: 'Upload snapshot file',
        thirdPartySupport: 'Only third-party accounts are supported',
        recoverDetail: 'Recover detail',
        createSnapshot: 'Create snapshot',
        importSnapshot: 'Sync snapshot',
        recover: 'Recover',
        noRecoverRecord: 'No recovery record has been recorded',
        lastRecoverAt: 'Last recovery time',
        lastRollbackAt: 'Last rollback time',
        noRollbackRecord: 'No rollback record has been recorded',
        reDownload: 'Download the backup file again',
        recoverRecord: 'Recover record',
        recoverHelper:
            'The recovery is about to start from snapshot {0}, and the recovery needs to restart docker and 1panel service, do you want to continue?',
        rollback: 'Rollback',
        rollbackHelper:
            'This recovery is about to be rolled back, which will replace all the files recovered this time. In the process, docker and 1panel services may need to be restarted. Do you want to continue?',

        upgrading: 'Please wait while the upgrade is underway...',
        upgradeHelper: 'The upgrade requires a service restart. Do you want to continue?',
        noUpgrade: 'It is currently the latest version',
        versionHelper:
            'Name rules: [major version].[functional version].[Bug fix version], as shown in the following example:',
        versionHelper1: 'v1.0.1 is a Bug fix after v1.0.0',
        versionHelper2: 'v1.1.0 is a feature release after v1.0.0',
        newVersion: '(Bug fix version)',
        latestVersion: '(Functional version)',
        upgradeCheck: 'Check for updates',
        upgradeNotes: 'Release note',
        upgradeNow: 'Upgrade now',
        source: 'Download source',
        hasNewVersion: 'New version Available',

        about: 'About',
        project: 'Project Address',
        issue: 'Feedback',
        doc: 'Official document',
        star: 'Star',
        description: '1Panel, Modern, open source Linux server operation and maintenance management panel.',
        forum: 'Forum',
        doc2: 'Document',
        currentVersion: 'Version',
    },
    clean: {
        scan: 'Start Scanning',
        clean: 'Clean Now',
        reScan: 'Rescan',
        cleanHelper:
            'After checking the files and directories for cleaning, it cannot be undone (system cache cleaning requires a service restart). Do you want to continue?',
        statusSuggest: '( Recommended Cleaning )',
        statusClean: '( Very Clean )',
        statusEmpty: 'Very clean, no cleaning needed!',
        statusWarning: '( Proceed with Caution )',
        lastCleanTime: 'Last Cleaned: {0}',
        lastCleanHelper: 'Files and directories cleaned: {0}, Total cleaned: {1}',
        cleanSuccessful: 'Cleaning Successful!',
        currentCleanHelper: 'Files and directories cleaned in this session: {0}, Total cleaned: {1}',
        suggest: '(Recommended)',
        totalScan: 'Total junk files to be cleaned: ',
        selectScan: 'Total selected junk files: ',

        system: 'System Junk',
        systemHelper:
            'Temporary files generated during snapshots, upgrades, and obsolete file contents during version iterations',
        panelOriginal: 'System snapshot recovery backup files',
        upgrade: 'System upgrade backup files',
        upgradeHelper: '(Recommend keeping the latest upgrade backup for system rollback)',
        cache: 'System cache files',
        cacheHelper: '(Proceed with caution, clearing requires a service restart)',
        snapshot: 'System snapshot temporary files',
        snapshotTmp: 'System snapshot upload temporary files',
        snapshotLocal: 'System snapshot creation temporary files',
        rollback: 'Backup files before recover',
        unused: 'Unused system directories',
        oldUpgrade: 'Unused pre-upgrade backup directories',
        oldOriginal: 'Unused pre-snapshot recovery backup directories',
        oldAppsBak: 'Unused application backup directories',

        upload: 'Temporary upload files',
        uploadHelper: 'Temporary files uploaded from the system backup list',
        download: 'Temporary Download Files',
        downloadHelper: 'Temporary files downloaded from third-party backup accounts by the system',
        website: 'Website',
        app: 'Application',
        database: 'Database',
        directory: 'Directory',

        systemLog: 'System Log Files',
        systemLogHelper:
            'System log information, container build or image pull log information, and log files generated in scheduled tasks',
        dockerLog: 'Container operation log files',
        taskLog: 'Scheduled task execution log files',
        shell: 'Shell script scheduled tasks',
        containerShell: 'Container internal Shell script scheduled tasks',
        curl: 'CURL scheduled tasks',
    },
    app: {
        app: 'Application',
        installName: 'Name',
        installed: 'Installed',
        all: 'All',
        version: 'Version',
        detail: 'Details',
        params: 'Param',
        install: 'Install',
        author: 'Author',
        source: 'Source',
        sync: 'Sync',
        appName: 'Application Name',
        status: 'Status',
        container: 'Container',
        restart: 'Restart',
        start: 'Start',
        stop: 'Stop',
        rebuild: 'Rebuild',
        description: 'Description',
        deleteWarn:
            'The delete operation will delete all data and backups together. This operation cannot be rolled back. Do you want to continue? ',
        syncSuccess: 'Sync successfully',
        canUpgrade: 'Upgrade',
        backupName: 'File Name',
        backupPath: 'File Path',
        backupdate: 'Backup time',
        update: 'update',
        versionSelect: 'Please select a version',
        operatorHelper: 'Operation {0} will be performed on the selected application, Do you want to continue? ',
        checkInstalledWarn: '{0} is not detected, please enter the app store and click to install!',
        gotoInstalled: 'Go to install',
        search: 'Search',
        limitHelper: 'The application has already been installed, does not support repeated installation',
        deleteHelper: '{0} has been associated with the following resources and cannot be deleted',
        checkTitle: 'Prompt',
        website: 'website',
        database: 'database',
        defaultConfig: 'Default Configuration',
        defaultConfigHelper: 'It has been restored to the default configuration, it will take effect after saving',
        forceDelete: 'Force delete',
        forceDeleteHelper:
            'Forced deletion will ignore errors generated during the deletion process and eventually delete metadata',
        deleteBackup: 'Delete backup',
        deleteBackupHelper: 'Also delete the application backup',
        deleteDB: 'Delete Database',
        deleteDBHelper: 'Also delete the database',
        noService: 'No {0}',
        toInstall: 'to install',
        param: 'parameter configuration',
        alreadyRun: 'Age',
        syncAppList: 'Sync',
        less1Minute: 'Less than 1 minute',
        appOfficeWebsite: 'Office website',
        github: 'Github',
        document: 'Cocument',
        updatePrompt: 'The current application is the latest version',
        installPrompt: 'No apps installed yet',
        updateHelper: 'Updating parameters may cause the application to fail to start, please operate with caution',
        updateWarn: 'Update parameters need to rebuild the application, Do you want to continue? ',
        busPort: 'Service Port',
        syncStart: 'Start syncing! Please refresh the app store later',
        advanced: 'Advanced Settings',
        cpuCore: 'Number of cores',
        containerName: 'Container Name',
        containerNameHelper: 'can be empty, it will be automatically generated',
        allowPort: 'Port external access',
        allowPortHelper: 'Allowing external port access will release the firewall port',
        appInstallWarn:
            'The application does not release the external access port by default, you can choose to release it in the advanced settings',
        upgradeStart: 'Start upgrading! Please refresh the page later',
        toFolder: 'Open the installation directory',
        editCompose: 'Edit compose file',
        editComposeHelper: 'Editing the compose file may cause the software installation to fail',
        composeNullErr: 'compose cannot be empty',
        takeDown: 'TakeDown',
        allReadyInstalled: 'Installed',
        installHelper: 'Configuring image acceleration can solve the problem of image pull failure',
        upgradeHelper: 'The abnormal application needs to be synchronized to the normal state first',
        installWarn:
            'Currently, if the port external access is not checked, it will not be able to access through the external network IP: port. Do you want to continue?',
        restoreWarn:
            'The restore operation will delete the current data of the application and restart it. This operation cannot be rolled back, continue?',
        showIgnore: 'View ignore application',
        cancelIgnore: 'Cancel ignore',
        ignoreList: 'ignore list',
        appHelper: 'Please view the installation instructions of some applications on the application details page',
        backupApp: 'Backup application before upgrade',
        backupAppHelper: 'If the upgrade fails, you can use the application backup to roll back',
        delete: 'Delete',
        openrestyDeleteHelper:
            'Forcibly deleting OpenResty will delete all websites, please confirm the risk before operation',
        downloadLogHelper1: 'All logs of {0} application are about to be downloaded. Do you want to continue? ',
        downloadLogHelper2:
            'The latest {1} logs of {0} application are about to be downloaded. Do you want to continue? ',
        syncAllAppHelper: 'All applications are about to be synchronized. Do you want to continue? ',
    },
    website: {
        website: 'Website',
        primaryDomain: 'Primary Domain',
        otherDomains: 'Other Domains',
        static: 'Static',
        deployment: 'Deployment',
        supportUpType: 'Only .tar.gz files are supported',
        zipFormat: '.tar.gz compressed package structure: test.tar.gz compressed package must contain {0} file',
        proxy: 'Reverse Proxy',
        alias: 'Path Name',
        remark: 'Remark',
        group: 'Group',
        groupSetting: 'Group Management',
        createGroup: 'Create Group',
        app: 'Application',
        appNew: 'New Application',
        appInstalled: 'Installed Application',
        create: 'Create Website',
        delete: 'Delete Website',
        deleteApp: 'Delete Application',
        deleteBackup: 'Delete Backup',
        domain: 'Domain',
        domainHelper: 'One domain per line, support * and IP address, support domain name: port',
        addDomain: 'Add Domain',
        domainConfig: 'Domain Settings',
        defaultDoc: 'Default Document',
        perserver: 'Concurrency',
        perserverHelper: 'Limit the maximum concurrency of the current site',
        perip: 'Single IP',
        peripHelper: 'Limit the maximum number of concurrent access to a single IP',
        rate: 'Flow Limit',
        rateHelper: 'Limit the flow of each request (unit: KB)',
        limitHelper: 'Enable flow control',
        other: 'Other',
        currentSSL: 'Current Certificate',
        dnsAccount: 'DNS Account',
        applySSL: 'Certificate Application',
        SSLList: 'Certificate List',
        createDnsAccount: 'DNS Account',
        aliyun: 'Aliyun DNS',
        manual: 'Manual parsing',
        key: 'Key',
        check: 'View',
        acmeAccountManage: 'Acme Account',
        email: 'Email',
        addAccount: 'Add new account',
        acmeAccount: 'Acme Account',
        provider: 'Verification method',
        dnsManual: 'Manual resolution',
        expireDate: 'Expiration Time',
        brand: 'Issuer',
        deploySSL: 'Deployment',
        deploySSLHelper: 'Are you sure to deploy the certificate? ',
        ssl: 'Certificate',
        dnsAccountManage: 'DNS Account',
        renewSSL: 'Renew',
        renewHelper: 'Are you sure to renew the certificate? ',
        renewSuccess: 'Renew Certificate',
        config: 'Configuration',
        enableHTTPS: 'Enable HTTPS',
        aliasHelper: 'Path Name is the folder name of the website directory',
        lastBackupAt: 'last backup time',
        null: 'none',
        nginxConfig: 'Nginx configuration',
        websiteConfig: 'Website Settings',
        basic: 'Basic',
        source: 'Configuration',
        security: 'Security',
        log: 'Log',
        nginxPer: 'Performance Tuning',
        neverExpire: 'Never Expire',
        setDefault: 'Set as default',
        default: 'Default',
        deleteHelper: 'Related application status is abnormal, please check',
        toApp: 'Go to the installed list',
        cycle: 'Cycle',
        frequency: 'Frequency',
        ccHelper:
            'Accumulatively request the same URL more than {1} times within {0} seconds, trigger CC defense, block this IP',
        mustSave: 'The modification needs to be saved to take effect',
        fileExt: 'file extension',
        fileExtBlock: 'file extension blacklist',
        value: 'value',
        enable: 'Enable',
        proxyAddress: 'Proxy Address',
        proxyHelper: 'Example: 127.0.0.1:8080',
        forceDelete: 'Force Delete',
        forceDeleteHelper:
            'Forced deletion will ignore errors generated during the deletion process and eventually delete metadata',
        deleteAppHelper: 'Delete associated applications and application backups at the same time',
        deleteBackupHelper: 'Also delete website backup',
        deleteConfirmHelper:
            'The delete operation cannot be rolled back, please enter <span style="color:red"> "{0}" </span> to delete',
        staticPath: 'Corresponding main directory:',
        limit: 'Scheme',
        blog: 'Forum/Blog',
        imageSite: 'Picture Site',
        downloadSite: 'Download Site',
        shopSite: 'Mall',
        doorSite: 'Portal',
        qiteSite: 'Enterprise',
        videoSite: 'Video',
        errLog: 'Error Log',
        accessLog: 'Website Log',
        stopHelper:
            'After stopping the site, it will not be able to access normally, and the user will display the stop page of the current site when visiting. Do you want to continue? ',
        startHelper:
            'After enabling the site, users can access the content of the site normally, do you want to continue? ',
        sitePath: 'Website Directory',
        siteAlias: 'Site  Alias',
        primaryPath: 'Main directory',
        folderTitle: 'The main directory of the website mainly contains four folders',
        wafFolder: 'Firewall Rules',
        indexFolder: 'Website root directory',
        logFolder: 'website log',
        sslFolder: 'Website certificate',
        enableOrNot: 'Enable',
        oldSSL: 'Select an existing certificate',
        manualSSL: 'manually import certificate',
        select: 'Select',
        selectSSL: 'Select Certificate',
        privateKey: 'Key (KEY)',
        certificate: 'Certificate (PEM format)',
        HTTPConfig: 'HTTP Options',
        HTTPSOnly: 'Disable HTTP',
        HTTPToHTTPS: 'Access HTTP automatically jumps to HTTPS',
        HTTPAlso: 'HTTP can be accessed directly',
        sslConfig: 'SSL options',
        disableHTTPS: 'Disable HTTPS',
        disableHTTPSHelper:
            'Disabling HTTPS will delete the certificate related configuration, Do you want to continue?',
        SSLHelper:
            'Note: Do not use SSL certificates for illegal websites \n If HTTPS access cannot be used after opening, please check whether the security group has correctly released port 443',
        SSLConfig: 'Certificate Settings',
        SSLProConfig: 'SSL protocol settings',
        supportProtocol: 'Supported protocol version',
        encryptionAlgorithm: 'Rncryption Algorithm',
        notSecurity: '(not safe)',
        encryptHelper:
            "Let's Encrypt has a frequency limit for issuing certificates, but it is sufficient to meet normal needs. Too frequent operations will cause issuance failure. For specific restrictions, please see <a target='_blank' href='https://letsencrypt.org/zh-cn/docs /rate-limits/'>official document</a> ",
        ipValue: 'Value',
        ext: 'file extension',
        wafInputHelper: 'Input data by line, one line',
        data: 'data',
        ever: 'permanent',
        nextYear: 'One year later',
        noLog: 'There are currently no logs...',
        defaultServer: 'Default Site',
        noDefaultServer: 'Not set',
        defaultServerHelper:
            'After setting the default site, all unbound domain names and IPs are directed to the default site\n which can effectively prevent malicious analysis',
        restoreHelper: 'Are you sure to restore using this backup?',
        websiteDeploymentHelper: 'Create a website using an application deployed from 1Panel',
        websiteStatictHelper: 'Create a website directory on the host',
        websiteProxyHelper:
            'The proxy has existing services, for example, the machine has installed the halo service using port 8080, then the proxy address is http://127.0.0.1:8080',
        runtimeProxyHelper: 'Use runtime created from 1Panel',
        runtime: 'Runtime',
        deleteRuntimeHelper:
            'The Runtime application needs to be deleted together with the website, please handle it with caution',
        proxyType: 'Listening Network Type',
        unix: 'Unix Network',
        tcp: 'TCP/IP Network',
        phpFPM: 'FPM Config',
        phpConfig: 'PHP Config',
        updateConfig: 'Update Config',
        isOn: 'On',
        isOff: 'Off',
        rewrite: 'Pseudo Static',
        rewriteMode: 'Scheme',
        current: 'Current',
        rewriteHelper:
            'If the website cannot be accessed normally after setting pseudo-static, please try to set it back to default',
        runDir: 'Run Directory',
        runUserHelper:
            'For websites deployed through the PHP runtime environment, all files, folder owners, and user groups under the index and subdirectories need to be set to 1000, command: chown -R 1000:1000 index',
        userGroup: 'User/Group',
        uGroup: 'Group',
        proxyPath: 'Proxy Path',
        proxyPass: 'Target URL',
        cache: 'Cache',
        createProxy: 'Create reverse proxy',
        editProxy: 'Edit reverse proxy',
        cacheTime: 'Cache time',
        enableCache: 'Open cache',
        proxyHost: 'Send domain name',
        disabled: 'Stopped',
        startProxy: 'Start Reverse proxy',
        stopProxy: 'Stop the Reverse proxy',
        proxyFile: 'Source',
        proxyHelper1: 'When accessing this directory, the content of the target URL will be returned and displayed',
        proxyPassHelper: 'The proxy site must be a URL that can be accessed normally',
        proxyHostHelper: 'Add the domain name to the request header and pass it to the proxy server',
        replacementHelper: 'Up to 5 replacements can be added, please leave blank if no replacement is required',
        modifier: 'Matching rules',
        modifierHelper: 'Example: = exact match, ~ regular match, ^~ match the beginning of the path, etc',
        replace: 'Text Replacement',
        addReplace: 'Add text replacement',
        replaced: 'Search string (cannot be empty)',
        replaceText: 'Replace with string',
        replacedErr: 'The search string cannot be empty',
        replacedErr2: 'The search string cannot be repeated',
        basicAuth: 'Password Access',
        editBasicAuthHelper:
            'The password is asymmetrically encrypted and cannot be echoed. Editing needs to reset the password',
        antiLeech: 'Anti-leech',
        extends: 'Extension',
        browserCache: 'Cache',
        leechLog: 'Record anti-leech log',
        accessDomain: 'Allowed domains',
        leechReturn: 'Response resource',
        noneRef: 'Allow empty source',
        disable: 'not enabled',
        disableLeechHelper: 'Whether to disable the anti-leech',
        disableLeech: 'Disable anti-leech',
        ipv6: 'Listen IPV6',
        leechReturnError: 'Please fill in the HTTP status code',
        selectAcme: 'Select Acme account',
        imported: 'Manually Created',
        importType: 'Import Type',
        pasteSSL: 'Paste code',
        localSSL: 'Select local file',
        privateKeyPath: 'Private key file',
        certificatePath: 'Certificate file',
        ipWhiteListHelper: 'The role of IP whitelist: all rules are invalid for IP whitelist',
        redirect: 'redirect',
        sourceDomain: 'Source domain',
        targetURL: 'Target URL address',
        keepPath: 'URI params',
        path: 'path',
        redirectType: 'redirection type',
        redirectWay: 'Way',
        keep: 'keep',
        notKeep: 'Do not keep',
        redirectRoot: 'Redirect to the homepage',
        redirectHelper: '301 permanent redirection, 302 temporary redirection',
        changePHPVersionWarn:
            'Switching the PHP version will delete the original PHP container (the website code that has been mounted will not be lost), continue? ',
        changeVersion: 'Switch version',
        retainConfig: 'Whether to keep php-fpm.conf and php.ini files',
        runDirHelper2: 'Please ensure that the secondary running directory is under the index directory',
        openrestryHelper:
            'OpenResty default HTTP port: {0} HTTPS port: {1}, which may affect website domain name access and HTTPS forced redirect',
        primaryDomainHelper: 'Support domain name: port',
    },
    php: {
        short_open_tag: 'Short tag support',
        max_execution_time: 'Maximum script execution time',
        max_input_time: 'Maximum input time',
        memory_limit: 'Script memory limit',
        post_max_size: 'POST data maximum size',
        file_uploads: 'Whether to allow uploading files',
        upload_max_filesize: 'The maximum size allowed to upload files',
        max_file_uploads: 'The maximum number of files allowed to be uploaded at the same time',
        default_socket_timeout: 'Socket timeout',
        error_reporting: 'Error level',
        display_errors: 'Whether to output detailed error information',
        cgi_fix_pathinfo: 'Whether to open pathinfo',
        date_timezone: 'Time zone',
        disableFunction: 'Disable function',
        disableFunctionHelper: 'Enter the function to be disabled, such as exec, please use multiple, split',
        uploadMaxSize: 'Upload limit',
        indexHelper:
            'In order to ensure the normal operation of the PHP website, please place the code in the index directory and avoid renaming',
    },
    nginx: {
        serverNamesHashBucketSizeHelper: 'The hash table size of the server name',
        clientHeaderBufferSizeHelper: 'The header buffer size requested by the client',
        clientMaxBodySizeHelper: 'Maximum upload file',
        keepaliveTimeoutHelper: 'Connection timeout',
        gzipMinLengthHelper: 'minimum compressed file',
        gzipCompLevelHelper: 'compression rate',
        gzipHelper: 'Whether to enable compressed transmission',
        connections: 'Active connections',
        accepts: 'Total connections (accepts)',
        handled: 'Total number of handshakes (handled)',
        requests: 'Total number of handshakes (requests)',
        reading: 'Number of requests (Reading)',
        writing: 'Number of Responses (Writing)',
        waiting: 'resident process (Waiting)',
        status: 'Current Status',
        nginxConfig: 'Settings',
        configResource: 'Configuration',
        saveAndReload: 'Save and Reload',
    },
    ssl: {
        create: 'Create Certificate',
        provider: 'Type',
        manualCreate: 'manually created',
        acmeAccount: 'Acme Account',
        resolveDomain: 'Resolve domain name',
        err: 'Error',
        value: 'record value',
        dnsResolveHelper: 'Please go to the DNS resolution service provider to add the following resolution records:',
        detail: 'Details',
        msg: 'Information',
        ssl: 'Certificate',
        key: 'Private Key',
        startDate: 'Effective Time',
        organization: 'issuing organization',
        renewConfirm: 'Are you sure to renew? ',
        autoRenew: 'Automatic renewal',
        autoRenewHelper: 'Automatic renewal 7 days from the expiration time',
        renewSuccess: 'Renewal succeeded',
        renewWebsite:
            'This certificate has been associated with the following websites, and the renewal will be applied to these websites simultaneously',
        createAcme: 'Create Account',
        acmeHelper: 'Acme account is used to apply for free certificates',
    },
    firewall: {
        create: 'Create rule',
        edit: 'Edit rule',
        notSupport:
            'No system firewall detected (firewalld or ufw). Please refer to the official documentation for installation.',
        ccDeny: 'CC Protection',
        ipWhiteList: 'IP Whitelist',
        ipBlockList: 'IP Blacklist',
        fileExtBlockList: 'File extension blacklist',
        urlWhiteList: 'URL Whitelist',
        urlBlockList: 'URL Blacklist',
        argsCheck: 'GET parameter check',
        postCheck: 'POST parameter verification',
        cookieBlockList: 'Cookie Blacklist',

        firewall: 'Firewall',
        dockerHelper:
            'Linux firewall {0} cannot disable Docker port mapping, the application can edit the parameters on the [Installed] page to control whether the port is released',
        quickJump: 'Quick jump',
        used: 'Used',
        unUsed: 'Unused',
        firewallHelper: '{0} System firewall',
        firewallNotStart: 'The system firewall is not enabled at present, please enable it first!',
        stopFirewallHelper:
            'After the system firewall is disabled, the server loses security protection. Do you want to continue?',
        startFirewallHelper:
            'After the firewall is enabled, the server security can be better protected. Do you want to continue?',
        noPing: 'Disable ping',
        noPingTitle: 'Disable ping',
        noPingHelper: 'If the ping function is disabled, the server cannot be pinged. Do you want to continue?',
        onPingHelper: 'If you disable ping, hackers may discover your server. Do you want to continue?',
        changeStrategy: 'Change the {0} strategy',
        changeStrategyIPHelper1:
            'Change the IP address strategy to [deny]. After the IP address is set, access to the server is prohibited. Do you want to continue?',
        changeStrategyIPHelper2:
            'Change the IP address strategy to [allow]. After the IP address is set, normal access is restored. Do you want to continue?',
        changeStrategyPortHelper1:
            'Change the port policy to [drop]. After the port policy is set, external access is denied. Do you want to continue?',
        changeStrategyPortHelper2:
            'Change the port policy to [accept]. After the port policy is set, normal port access will be restored. Do you want to continue?',
        stop: 'Stop',
        portFormatError: 'Please enter the correct port information!',
        portHelper1: 'Multiple ports, e.g. 8080 and 8081',
        portHelper2: 'Range port, e.g. 8080-8089',
        changeStrategyHelper:
            'Change [{1}] {0} strategy to [{2}]. After setting, {0} will access {2} externally. Do you want to continue?',
        portHelper: 'Multiple ports can be entered, e.g. 80,81, or range ports, e.g. 80-88',
        strategy: 'Strategy',
        accept: 'Accept',
        drop: 'Drop',
        source: 'Source',
        anyWhere: 'AnyWhere',
        address: 'Specified IP',
        addressHelper: 'Support IP address or IP segment',
        allow: 'Allow',
        deny: 'Deny',
        addressFormatError: 'Please enter a valid ip address!',
        addressHelper1: 'Supports input of single IPs or IP ranges: 172.16.10.11 or 172.16.0.0/24',
        addressHelper2: 'For multiple IPs or IP ranges, separate with commas: 172.16.10.11, 172.16.0.0/24',
        allIP: 'All IP',
        portRule: 'Port rule',
        ipRule: 'IP rule',
    },
    runtime: {
        runtime: 'Runtime',
        image: 'Image',
        workDir: 'Working directory',
        create: 'Create runtime',
        resource: 'Source',
        appstore: 'App Store',
        local: 'Local',
        app: 'Application',
        localHelper: 'The local operating environment needs to be installed by itself',
        version: 'Version',
        versionHelper: 'PHP version, e.g. v8.0',
        buildHelper:
            'The more extensions you select, the more CPU will be occupied during the image making process, so avoid selecting all extensions,If there is no extension you want, you can manually enter it and select it',
        openrestryWarn: 'PHP needs to be upgraded to OpenResty to version 1.21.4.1 or later to use',
        toupgrade: 'To Upgrade',
        edit: 'Edit runtime',
        extendHelper:
            'Extensions that do not exist in the list can be selected after manual input, for example: input sockets, and then select the first one in the drop-down list,',
        rebuildHelper: 'After editing the extension, you need to to rebuild the PHP application to take effect',
        phpPluginHelper:
            '<a target="_blank" href="https://1panel.cn/docs/user_manual/websites/php/#php_1">View PHP extension list</a> ',
        rebuild: 'Rebuild PHP App',
        source: 'PHP extension source',
        ustc: 'University of Science and Technology of China',
        netease: 'Netease',
        aliyun: 'Alibaba Cloud',
        default: 'default',
        tsinghua: 'Tsinghua University',
        xtomhk: 'XTOM Mirror Station (Hong Kong)',
        xtom: 'XTOM Mirror Station (Global)',
        phpsourceHelper: 'Choose the appropriate source according to your network environment',
        appPort: 'App Port',
        externalPort: 'External Port',
        packageManager: 'Package Manager',
        codeDir: 'Code Directory',
        appPortHelper: 'The port used by the application',
        externalPortHelper: 'The port exposed to the outside world',
        runScript: 'Run Script',
        runScriptHelper: 'The startup command list is parsed from the package.json file in the source directory',
        open: 'Open',
        close: 'Close',
        operatorHelper:
            'The {0} operation will be performed on the selected operating environment. Do you want to continue? ',
        statusHelper:
            'Status description: Starting - the container has been started, but the application is starting; abnormal - the container has been started, but the application status is abnormal',
        taobao: 'Taobao',
        tencent: 'Tencent',
        imageSource: 'Image source',
        moduleManager: 'Module Management',
        module: 'Module',
        nodeOperatorHelper:
            'Is {0} {1} module? The operation may cause abnormality in the operating environment, please confirm before proceeding',
    },
    process: {
        pid: 'Process ID',
        ppid: 'Parent process ID',
        numThreads: 'Threads',
        memory: 'Memory',
        diskRead: 'Disk read',
        diskWrite: 'Disk write',
        netSent: 'uplink',
        netRecv: 'downstream',
        numConnections: 'Connections',
        startTime: 'Start time',
        status: 'Status',
        running: 'Running',
        sleep: 'sleep',
        stop: 'stop',
        idle: 'idle',
        zombie: 'zombie process',
        wait: 'waiting',
        lock: 'lock',
        blocked: 'blocked',
        cmdLine: 'Start command',
        basic: 'Basic information',
        mem: 'Memory information',
        openFiles: 'File Open',
        file: 'File',
        env: 'Environment variable',
        noenv: 'None',
        net: 'Network connection',
        laddr: 'Source address/port',
        raddr: 'Destination address/port',
        stopProcess: 'End',
        stopProcessWarn: 'Are you sure you want to end this process (PID:{0})? ',
        processName: 'ProcessName',
    },
    tool: {
        supervisor: {
            loadStatusErr: 'Failed to retrieve process status, please check the status of the supervisor service.',
            notSupport: 'Supervisor is not detected, please refer to the official document for installation',
            list: 'Daemon process',
            config: 'Supervisor configuration',
            primaryConfig: 'Main configuration file location',
            notSupportCrl: 'The supervisorctl is not detected, please refer to the official document for installation',
            user: 'User',
            command: 'Command',
            dir: 'Directory',
            numprocs: 'Numprocs',
            initWarn:
                'The initialization operation needs to modify the [include] files parameter of the configuration file, the directory where the modified service configuration file is located: 1panel installation directory/1panel/tools/supervisord/supervisor.d/',
            operatorHelper: 'Operation {1} will be performed on {0}, continue? ',
            uptime: 'running time',
            notStartWarn: 'Supervisor is not started, please start it first',
            serviceName: 'Service name',
            initHelper:
                'The initialization process will modify the configuration file, causing all existing processes to stop, please confirm the risk in advance',
            serviceNameHelper: 'Supervisor service name managed by systemctl, usually supervisor or supervisord',
            restartHelper:
                'Initialization will restart the service, causing all the original daemon processes to close',
            msg: 'Message',
            RUNNING: 'Running',
            STOPPED: 'Stopped',
            STOPPING: 'Stopping',
            STARTING: 'Starting',
            FATAL: 'Failed to start',
            BACKOFF: 'Start exception',
            statusCode: 'Status code',
            manage: 'Management',
        },
    },
};

export default {
    ...fit2cloudEnLocale,
    ...message,
};
