import fit2cloudTwLocale from 'fit2cloud-ui-plus/src/locale/lang/zh-cn';
const message = {
    commons: {
        true: '是',
        false: '否',
        example: '例：',
        button: {
            create: '創建',
            add: '添加',
            save: '保存',
            set: '設置',
            sync: '同步',
            delete: '刪除',
            edit: '編輯',
            enable: '啟用',
            disable: '禁用',
            confirm: '確認',
            cancel: '取消',
            reset: '重置',
            restart: '重啟',
            conn: '連接',
            disconn: '斷開',
            clean: '清空',
            login: '登錄',
            close: '關閉',
            stop: '關閉',
            start: '開啟',
            view: '詳情',
            watch: '追蹤',
            handle: '執行',
            expand: '展開',
            collapse: '收起',
            log: '日誌',
            back: '返回',
            backup: '備份',
            recover: '恢復',
            retry: '重試',
            upload: '上傳',
            download: '下載',
            init: '初始化',
            verify: '驗證',
            saveAndEnable: '保存並啟用',
            import: '導入',
            search: '搜索',
            refresh: '刷新',
            get: '獲取',
            upgrade: '升級',
            ignore: '忽略升級',
            copy: '復製',
            random: '隨機密碼',
            uninstall: '卸載',
            fullscreen: '全屏',
            quitFullscreen: '退出全屏',
        },
        search: {
            timeStart: '開始時間',
            timeEnd: '結束時間',
            timeRange: '至',
            dateStart: '開始日期',
            dateEnd: '結束日期',
        },
        table: {
            all: '所有',
            total: '共 {0} 條',
            name: '名稱',
            type: '類型',
            status: '狀態',
            statusSuccess: '成功',
            statusFailed: '失敗',
            statusWaiting: '進行中...',
            records: '任務輸出',
            group: '分組',
            createdAt: '創建時間',
            publishedAt: '發布時間',
            date: '時間',
            updatedAt: '更新時間',
            operate: '操作',
            message: '信息',
            description: '描述信息',
            interval: '耗時',
            user: '用戶',
            title: '標題',
            port: '端口',
            protocol: '協議',
            tableSetting: '列表設置',
            autoRefresh: '定時刷新',
            refreshRate: '刷新頻率',
        },
        loadingText: {
            Upgrading: '系統升級中，請稍候...',
            Restarting: '系統重啟中，請稍候...',
            Recovering: '從快照恢復中，請稍候...',
            Rollbacking: '快照回滾中，請稍候...',
        },
        msg: {
            noneData: '暫無數據',
            delete: '刪除 操作不可回滾，是否繼續？',
            clean: '清空 操作不可回滾，是否繼續？',
            deleteTitle: '刪除',
            deleteSuccess: '刪除成功',
            loginSuccess: '登錄成功',
            operationSuccess: '操作成功',
            copySuccess: '復製成功',
            notSupportOperation: '不支持的當前操作',
            requestTimeout: '請求超時,請稍後重試',
            infoTitle: '提示',
            notRecords: '當前任務未產生執行記錄',
            sureLogOut: '您是否確認退出登錄?',
            createSuccess: '創建成功',
            updateSuccess: '更新成功',
            uploadSuccess: '上傳成功',
            operate: '操作',
            operateConfirm: '如果確認操作，請手動輸入',
            inputOrSelect: '請選擇或輸入',
            copyFailed: '復製失敗',
            backupSuccess: '備份成功',
            restoreSuccess: '備份成功',
            notFound: '抱歉，您訪問的頁面不存在',
            unSupportType: '不支持當前文件類型！',
            unSupportSize: '上傳文件超過 {0}M，請確認！',
            fileExist: '當前文件夾已存在該文件，不支持重復上傳！',
            fileNameErr: '僅支持上傳名稱包含英文、中文、數字或者 .-_ ,長度 1-256 位的文件',
            confirmNoNull: '請確認 {0} 值不為空',
            errPort: '錯誤的端口信息，請確認！',
        },
        login: {
            username: '用戶名',
            password: '密碼',
            welcome: '歡迎回來，請輸入用戶名和密碼登錄！',
            errorAuthInfo: '您輸入的用戶名或密碼不正確，請重新輸入！',
            errorMfaInfo: '錯誤的驗證信息，請重試！',
            captchaHelper: '驗證碼',
            errorCaptcha: '驗證碼錯誤！',
            notSafe: '暫無權限訪問',
            safeEntrance1: '當前環境已經開啟了安全入口登錄',
            safeEntrance2: '在 SSH 終端輸入以下命令來查看面板入口: 1pctl user-info',
            errIP1: '當前環境已經開啟了授權 IP 訪問',
            errDomain1: '當前環境已經開啟了訪問域名綁定',
            errHelper: '可在 SSH 終端輸入以下命令來重置綁定信息: ',
            codeInput: '請輸入 MFA 驗證器的 6 位驗證碼',
            mfaTitle: 'MFA 認證',
            mfaCode: 'MFA 驗證碼',
            title: 'Linux 服務器運維管理面板',
            licenseHelper:
                '同意 &laquo; <a href="https://www.fit2cloud.com/legal/licenses.html" target="_blank"> 飛致雲社區軟件許可協議</a> &raquo;',
            errorAgree: '請點擊同意社區軟件許可協議',
            logout: '退出登錄',
        },
        rule: {
            username: '請輸入用戶名',
            password: '請輸入密碼',
            rePassword: '密碼不一致，請檢查後重新輸入',
            requiredInput: '請填寫必填項',
            requiredSelect: '請選擇必選項',
            illegalInput: '輸入框中存在不合法字符',
            commonName: '支持英文、中文、數字、.-和_,長度1-30',
            userName: '支持英文、中文、數字和_,長度3-30',
            simpleName: '支持英文、數字、_,長度1-30',
            dbName: '支持英文、中文、數字、.-_,長度1-64',
            imageName: '支持英文、數字、:/.-_,長度1-150',
            volumeName: '支持英文、數字、.-和_,長度2-30',
            complexityPassword: '請輸入長度大於 8 位且包含字母、數字、特殊字符至少兩項的密碼組合',
            commonPassword: '請輸入 6 位以上長度密碼',
            linuxName: '長度1-128，名稱不能含有{0}等符號',
            email: '請輸入正確的郵箱',
            number: '請輸入正確的數字',
            integer: '請輸入正確的正整數',
            ip: '請輸入正確的 IP 地址',
            host: '請輸入正確的 IP 或者域名',
            hostHelper: '支持輸入 ip 或者域名',
            port: '請輸入正確的端口,1-65535',
            selectHelper: '請選擇正確的 {0} 文件',
            domain: '域名格式錯誤',
            databaseName: '支持英文、數字、_,長度1-30',
            ipErr: 'IP [{0}] 格式錯誤,請檢查',
            numberRange: '數字範圍: {0} - {1}',
            paramName: '支持英文、數字、.-和_,長度2-64',
            paramComplexity: '支持英文、數字、{0},長度6-128，特殊字符不能在首尾',
            paramUrlAndPort: '格式為 http(s)://(域名/ip):(端口)',
            nginxDoc: '僅支持英文大小寫，數字，和.',
            appName: '支持英文、數字、-和_,長度2-30,並且不能以-_開頭和結尾',
            containerName: '支持字母、數字、_-和.,不能以-_或.開頭,長度1-127',
            mirror: '支持以 http(s):// 開頭，英文大小寫，數字，. 和 - 的鏡像加速地址，且不能有空行',
            disableFunction: '僅支持字母、下劃線和,',
            leechExts: '僅支持字母數字和,',
            paramSimple: '支持小寫字母和數字,長度 1-128',
        },
        res: {
            paramError: '請求失敗,請稍後重試!',
            forbidden: '當前用戶無權限',
            serverError: '服務異常',
            notFound: '資源不存在',
            commonError: '請求失敗',
        },
        service: {
            serviceNotStarted: '當前未啟動 {0} 服務',
        },
        status: {
            running: '已啟動',
            done: '已完成',
            success: '成功',
            waiting: '執行中',
            waiting1: '等待中',
            failed: '失敗',
            stopped: '已停止',
            error: '失敗',
            created: '已創建',
            restarting: '重啟中',
            uploading: '上傳中',
            unhealthy: '異常',
            removing: '遷移中',
            paused: '暫停',
            exited: '停止',
            installing: '安裝中',
            enabled: '已啟用',
            disabled: '已停止',
            normal: '正常',
            building: '製作鏡像中',
            downloaderr: '下載失敗',
            upgrading: '升級中',
            upgradeerr: '升級失敗',
            pullerr: '鏡像拉取失敗',
            rebuilding: '重建中',
            deny: '已屏蔽',
            accept: '已放行',
            used: '已使用',
            unUsed: '未使用',
            starting: '啟動中',
            recreating: '重建中',
            creating: '創建中',
        },
        units: {
            second: '秒',
            minute: '分鐘',
            hour: '小時',
            day: '天',
            week: '周',
            month: '月',
            year: '年',
            time: '次',
            core: '核',
        },
        operate: {
            down: '停止',
            up: '啟動',
            restart: '重啟',
            install: '安裝',
            uninstall: '卸載',
            update: '更新',
        },
    },
    menu: {
        home: '概覽',
        apps: '應用商店',
        website: '網站',
        project: '項目',
        config: '配置',
        ssh: 'SSH 配置',
        firewall: '防火墻',
        ssl: '證書',
        database: '數據庫',
        container: '容器',
        cronjob: '計劃任務',
        host: '主機',
        files: '文件',
        monitor: '監控',
        terminal: '終端',
        settings: '面板設置',
        toolbox: '工具箱',
        logs: '日誌審計',
        runtime: '運行環境',
        processManage: '進程管理',
        process: '進程',
        network: '網絡',
        supervisor: '進程守護',
    },
    home: {
        overview: '概覽',
        entranceHelper: '設置安全入口有利於提高系統的安全性，如有需要，前往 面板設置-安全 中，啟用安全入口',
        appInstalled: '已安裝應用',
        systemInfo: '系統信息',
        hostname: '主機名稱',
        platformVersion: '發行版本',
        kernelVersion: '內核版本',
        kernelArch: '系統類型',
        network: '流量',
        io: '磁盤 IO',
        baseInfo: '基本信息',
        totalSend: '總發送',
        totalRecv: '總接收',
        rwPerSecond: '讀寫次數',
        ioDelay: '讀寫延遲',
        uptime: '啟動時間',
        runningTime: '運行時間',

        runSmoothly: '運行流暢',
        runNormal: '運行正常',
        runSlowly: '運行緩慢',
        runJam: '運行堵塞',

        core: '物理核心',
        logicCore: '邏輯核心',
        loadAverage: '最近 {0} 分鐘平均負載',
        load: '負載',
        mount: '掛載點',
        fileSystem: '文件系統',
        total: '總數',
        used: '已用',
        free: '可用',
        percent: '使用率',
        app: '推薦應用',
        goInstall: '去安裝',

        networkCard: '網卡',
        disk: '磁盤',
    },
    tabs: {
        more: '更多',
        hide: '收起',
        closeCurrent: '關閉當前',
        closeOther: '關閉其它',
        closeAll: '關閉所有',
    },
    header: {
        logout: '退出登錄',
    },
    database: {
        database: '數據庫',
        deleteBackupHelper: '同時刪除數據庫備份',
        delete: '刪除操作無法回滾，請輸入 "',
        deleteHelper: '" 刪除此數據庫',
        create: '創建數據庫',
        noMysql: '數據庫服務 (MySQL 或 MariaDB)',
        goUpgrade: '去應用商店升級',
        goInstall: '去應用商店安裝',
        source: '來源',
        permission: '權限',
        permissionForIP: '指定 IP',
        permissionAll: '所有人(%)',
        databaseConnInfo: '連接信息',
        rootPassword: 'root 密碼',
        serviceName: '服務名稱',
        serviceNameHelper: '用於同一 network 下的容器間訪問',
        backupList: '備份列表',
        loadBackup: '導入備份',
        remoteAccess: '遠程訪問',
        remoteHelper: '多個 ip 以逗號分隔，例：172.16.10.111,172.16.10.112',
        remoteConnHelper: 'root 帳號遠程連接 mysql 有安全風險，開啟需謹慎！',
        changePassword: '改密',
        changePasswordHelper: '當前數據庫已經關聯應用，修改密碼將同步修改應用中數據庫密碼，修改後重啟生效。',

        portHelper: '該端口為容器對外暴露端口，修改需要單獨保存並且重啟容器！',

        confChange: '配置修改',
        confNotFound: '未能找到該應用配置文件，請在應用商店升級該應用至最新版本後重試！',

        loadFromRemote: '從服務器獲取',
        loadFromRemoteHelper: '此操作將同步服務器上數據庫信息到 1Panel，是否繼續？',
        passwordHelper: '無法獲取密碼，請修改',
        local: '本地',
        remote: '遠程',
        remoteDB: '遠程服務器',
        createRemoteDB: '添加遠程服務器',
        editRemoteDB: '編輯遠程服務器',
        localDB: '本地數據庫',
        address: '數據庫地址',
        version: '數據庫版本',
        userHelper: 'root 用戶或者擁有 root 權限的數據庫用戶',

        selectFile: '選擇文件',
        dropHelper: '將上傳文件拖拽到此處，或者',
        clickHelper: '點擊上傳',
        supportUpType: '僅支持 sql、sql.gz、tar.gz 文件',
        zipFormat: 'tar.gz 壓縮包結構：test.tar.gz 壓縮包內，必需包含 test.sql',

        currentStatus: '當前狀態',
        baseParam: '基礎參數',
        performanceParam: '性能參數',
        runTime: '啟動時間',
        connections: '總連接數',
        bytesSent: '發送',
        bytesReceived: '接收',
        queryPerSecond: '每秒查詢',
        txPerSecond: '每秒事務',
        connInfo: '活動/峰值連接數',
        connInfoHelper: '若值過大，增加 max_connections',
        threadCacheHit: '線程緩存命中率',
        threadCacheHitHelper: '若過低,增加 thread_cache_size',
        indexHit: '索引命中率',
        indexHitHelper: '若過低,增加 key_buffer_size',
        innodbIndexHit: 'Innodb 索引命中率',
        innodbIndexHitHelper: '若過低,增加 innodb_buffer_pool_size',
        cacheHit: '查詢緩存命中率',
        cacheHitHelper: '若過低,增加 query_cache_size',
        tmpTableToDB: '創建臨時表到磁盤',
        tmpTableToDBHelper: '若過大,嘗試增加 tmp_table_size',
        openTables: '已打開的表',
        openTablesHelper: 'table_open_cache 配置值應大於等於此值',
        selectFullJoin: '沒有使用索引的量',
        selectFullJoinHelper: '若不為0，請檢查數據表的索引是否合理',
        selectRangeCheck: '沒有索引的 JOIN 量',
        selectRangeCheckHelper: '若不為0，請檢查數據表的索引是否合理',
        sortMergePasses: '排序後的合並次數',
        sortMergePassesHelper: '若值過大，增加sort_buffer_size',
        tableLocksWaited: '鎖表次數',
        tableLocksWaitedHelper: '若值過大，請考慮增加您的數據庫性能',

        performanceTuning: '性能調整',
        optimizationScheme: '優化方案',
        keyBufferSizeHelper: '用於索引的緩沖區大小',
        queryCacheSizeHelper: '查詢緩存，不開啟請設為0',
        tmpTableSizeHelper: '臨時表緩存大小',
        innodbBufferPoolSizeHelper: 'Innodb 緩沖區大小',
        innodbLogBufferSizeHelper: 'Innodb 日誌緩沖區大小',
        sortBufferSizeHelper: '* 連接數, 每個線程排序的緩沖大小',
        readBufferSizeHelper: '* 連接數, 讀入緩沖區大小',
        readRndBufferSizeHelper: '* 連接數, 隨機讀取緩沖區大小',
        joinBufferSizeHelper: '* 連接數, 關聯表緩存大小',
        threadStackelper: '* 連接數, 每個線程的堆棧大小',
        binlogCacheSizeHelper: '* 連接數, 二進製日誌緩存大小(4096的倍數)',
        threadCacheSizeHelper: '線程池大小',
        tableOpenCacheHelper: '表緩存',
        maxConnectionsHelper: '最大連接數',
        restart: '重啟數據庫',

        log: '日誌',
        slowLog: '慢日誌',
        noData: '暫無慢日誌...',

        isOn: '開啟',
        longQueryTime: '閾值(秒)',
        thresholdRangeHelper: '請輸入正確的閾值(1 - 600)',

        timeout: '超時時間',
        timeoutHelper: '空閑連接超時時間，0表示不斷開',
        maxclients: '最大連接數',
        requirepassHelper: '留空代表沒有設置密碼，修改需要單獨保存並且重啟容器！',
        databases: '數據庫數量',
        maxmemory: '最大內存使用',
        maxmemoryHelper: '0 表示不做限製',
        tcpPort: '當前監聽端口',
        uptimeInDays: '已運行天數',
        connectedClients: '連接的客戶端數量',
        usedMemory: 'Redis 歷史分配內存的峰值',
        usedMemoryRss: 'Redis 當前占用的系統內存總量',
        memFragmentationRatio: '內存碎片比率',
        totalConnectionsReceived: '運行以來連接過的客戶端的總數量',
        totalCommandsProcessed: '運行以來執行過的命令的總數量',
        instantaneousOpsPerSec: '服務器每秒鐘執行的命令數量',
        keyspaceHits: '查找數據庫鍵成功的次數',
        keyspaceMisses: '查找數據庫鍵失敗的次數',
        hit: '查找數據庫鍵命中率',
        latestForkUsec: '最近一次 fork() 操作耗費的微秒數',

        recoverHelper: '即將使用 [{0}] 對數據進行覆蓋，是否繼續?',
        submitIt: '覆蓋數據',

        baseConf: '基礎配置',
        allConf: '全部配置',
        restartNow: '立即重啟',
        restartNowHelper1: '修改配置後需要重啟生效，若您的數據需要持久化請先執行 save 操作。',
        restartNowHelper: '修改配置後需要重啟生效。',

        persistence: '持久化',
        rdbHelper1: '秒內,插入',
        rdbHelper2: '條數據',
        rdbHelper3: '符合任意一個條件將會觸發RDB持久化',
        rdbInfo: '請確認規則列表中值在 1-100000 之間',

        containerConn: '容器連接地址',
        containerConnHelper: 'PHP 運行環境/容器安裝的應用使用此連接地址',
        remoteConn: '外部連接地址',
        remoteConnHelper2: '非容器或外部連接使用此地址',
        localIP: '本機 IP',
    },
    container: {
        create: '創建容器',
        edit: '編輯容器',
        updateContainerHelper: '容器編輯需要重建容器，任何未持久化的數據將會丟失，是否繼續？',
        containerList: '容器列表',
        operatorHelper: '將對以下容器進行 {0} 操作，是否繼續？',
        operatorAppHelper:
            '將對以下容器進行 {0} 操作，其中部分來源於應用商店，該操作可能會影響到該服務的正常使用，是否確認？',
        start: '啟動',
        stop: '停止',
        restart: '重啟',
        kill: '強製停止',
        pause: '暫停',
        unpause: '恢復',
        rename: '重命名',
        remove: '刪除',
        containerPrune: '清理容器',
        containerPruneHelper1: '清理容器 將刪除所有處於停止狀態的容器。',
        containerPruneHelper2:
            '若容器來自於應用商店，在執行清理操作後，您需要前往 [應用商店] 的 [已安裝] 列表，點擊 [重建] 按鈕進行重新安裝。',
        containerPruneHelper3: '該操作無法回滾，是否繼續？',
        imagePrune: '清理鏡像',
        imagePruneSome: '未標簽鏡像',
        imagePruneSomeHelper: '清理下列標簽為 none 且未被任何容器使用的鏡像。',
        imagePruneAll: '未使用鏡像',
        imagePruneAllHelper: '清理下列未被任何容器使用的鏡像。',
        networkPrune: '清理網絡',
        networkPruneHelper: '清理網絡 將刪除所有未被使用的網絡，該操作無法回滾，是否繼續？',
        volumePrune: '清理存儲卷',
        volumePruneHelper: '清理存儲卷 將刪除所有未被使用的本地存儲卷，該操作無法回滾，是否繼續？',
        cleanSuccess: '操作成功，本次清理數量: {0} 個！',
        cleanSuccessWithSpace: '操作成功，本次清理數量: {0} 個，釋放磁盤空間: {1}！',
        container: '容器',
        unExposedPort: '當前端口映射地址為 127.0.0.1，無法實現外部訪問',
        upTime: '運行時長',
        all: '全部',
        fetch: '過濾',
        lines: '條數',
        linesHelper: '請輸入正確的日誌獲取條數！',
        lastDay: '最近一天',
        last4Hour: '最近 4 小時',
        lastHour: '最近 1 小時',
        last10Min: '最近 10 分鐘',
        cleanLog: '清空日誌',
        downLogHelper1: '即將下載 {0} 容器所有日誌，是否繼續？',
        downLogHelper2: '即將下載 {0} 容器最近 {1} 條日誌，是否繼續？',
        cleanLogHelper: '清空日誌需要重啟容器，該操作無法回滾，是否繼續？',
        newName: '新名稱',
        source: '資源使用率',
        cpuUsage: 'CPU 使用',
        cpuTotal: 'CPU 總計',
        core: '核心數',
        memUsage: '內存使用',
        memTotal: '內存限額',
        memCache: '緩存使用',
        ip: 'IP 地址',
        cpuShare: 'CPU 權重',
        cpuShareHelper: '容器默認份額為 1024 個 CPU，增大可使當前容器獲得更多的 CPU 時間',

        command: '命令',
        console: '控製臺交互',
        tty: '偽終端 ( -t )',
        openStdin: '標準輸入 ( -i )',
        custom: '自定義',
        containerTerminal: '終端',
        emptyUser: '為空時，將使用容器默認的用戶登錄',

        upgradeHelper: '該操作僅支持容器版本升級',
        ignoreCompare: '強製升級',
        ignoreCompareHelper: '跳過新老版本比較，直接升級，該操作可能導致服務不可用',
        upgradeWarning: '當前目標版本低於原鏡像版本，請重新輸入！',
        upgradeWarning2: '升級操作需要重建容器，任何未持久化的數據將會丟失，是否繼續？',
        oldImage: '當前鏡像',
        targetImage: '目標鏡像',
        targetImageHelper: '請輸入目標鏡像版本',
        appHelper: '該容器來源於應用商店，升級可能導致該服務不可用',

        input: '手動輸入',
        forcePull: '強製拉取鏡像',
        forcePullHelper: '忽略服務器已存在的鏡像，重新拉取一次',
        server: '服務器',
        serverExample: '例： 80, 80-88, ip:80 或者 ip:80-88',
        containerExample: '例： 80 或者 80-88',
        exposePort: '暴露端口',
        exposeAll: '暴露所有',
        cmdHelper: "例： 'nginx' '-g' 'daemon off;' 或 nginx -g daemon off;",
        entrypointHelper: '例： /bin/sh -c',
        autoRemove: '容器退出後自動刪除容器',
        cpuQuota: 'CPU 限製',
        memoryLimit: '內存限製',
        limitHelper: '限製為 0 則關閉限製，最大可用為 {0}',
        mount: '掛載',
        volumeOption: '掛載卷',
        hostOption: '本機目錄',
        serverPath: '服務器目錄',
        containerDir: '容器目錄',
        volumeHelper: '請確認存儲卷內容輸入正確',
        modeRW: '讀寫',
        modeR: '只讀',
        mode: '權限',
        env: '環境變量',
        restartPolicy: '重啟規則',
        always: '一直重啟',
        unlessStopped: '未手動停止則重啟',
        onFailure: '失敗後重啟（默認重啟 5 次）',
        no: '不重啟',

        monitor: '監控',
        refreshTime: '刷新間隔',
        cache: '緩存',

        image: '鏡像',
        imagePull: '拉取鏡像',
        imagePush: '推送鏡像',
        imageDelete: '刪除鏡像',
        imageDeleteTag: '刪除 Tag',
        repoName: '倉庫名',
        imageName: '鏡像名',
        httpRepo: 'http 倉庫添加授信需要重啟 docker 服務',
        delInsecure: '刪除授信',
        delInsecureHelper: '刪除授信需要重啟 docker 服務，是否刪除？',
        pull: '拉取',
        path: '路徑',
        importImage: '導入鏡像',
        imageBuild: '構建鏡像',
        build: '構建鏡像',
        pathSelect: '路徑選擇',
        label: '標簽',
        imageTag: '鏡像標簽',
        push: '推送',
        fileName: '文件名',
        export: '導出',
        exportImage: '導出鏡像',
        version: '版本',
        size: '大小',
        from: '來源',
        tag: '標簽',
        tagHelper: '一行一個，例： \nkey1=value1\nkey2=value2',
        imageNameHelper: '鏡像名稱及 Tag，例：nginx:latest',

        network: '網絡',
        createNetwork: '創建網絡',
        networkName: '網絡名',
        driver: '模式',
        option: '參數',
        attachable: '可用',
        subnet: '子網',
        scope: 'IP 範圍',
        gateway: '網關',

        volume: '存儲卷',
        volumeDir: '存儲卷目錄',
        nfsEnable: '啟用 NFS 存儲',
        nfsAddress: '地址',
        mountpoint: '掛載點',
        mountpointNFSHelper: '例：/nfs, /nfs-share',
        options: '可選參數',
        createVolume: '創建存儲卷',

        repo: '倉庫',
        createRepo: '添加倉庫',
        downloadUrl: '下載地址',
        imageRepo: '鏡像倉庫',
        repoHelper: '是否包含鏡像倉庫/組織/項目?',
        auth: '認證',
        mirrorHelper:
            '當存在多個加速器時，需要換行顯示，例： \nhttp://xxxxxx.m.daocloud.io \nhttps://xxxxxx.mirror.aliyuncs.com',
        registrieHelper: '當存在多個私有倉庫時，需要換行顯示，例：\n172.16.10.111:8081 \n172.16.10.112:8081',

        compose: '編排',
        fromChangeHelper: '切換來源將清空當前已編輯內容，是否繼續？',
        composePathHelper: '配置文件保存路徑: {0}',
        composeHelper: '通過 1Panel 編輯或者模版創建的編排，將保存在 {0}/docker/compose 路徑下',
        deleteFile: '刪除文件',
        deleteComposeHelper: '刪除 {0} 目录下所有文件，包括該文件下的持久化文件等，請謹慎操作！',
        deleteCompose: '" 刪除此編排',
        apps: '應用商店',
        local: '本地',
        createCompose: '創建編排',
        template: '模版',
        composeTemplate: '編排模版',
        createComposeTemplate: '創建編排模版',
        description: '描述',
        content: '內容',
        contentEmpty: '編排內容不能為空，請輸入後重試！',
        containerNumber: '容器數量',
        down: '刪除',
        up: '啟動',
        composeDetailHelper: '該 compose 為 1Panel 編排外部創建。暫不支持啟停操作。',
        composeOperatorHelper: '將對 {0} 進行 {1} 操作，是否繼續？',

        setting: '配置',
        operatorStatusHelper: '此操作將{0}Docker 服務，是否繼續？',
        dockerStatus: 'Docker 服務',
        daemonJsonPathHelper: '請保證配置路徑與 docker.service 中指定的配置路徑保持一致。',
        mirrors: '鏡像加速',
        mirrorsHelper: '優先使用加速 URL 執行操作，設置為空則取消鏡像加速。',
        mirrorsHelper2: '具體操作配置請參照官方文檔',
        registries: '私有倉庫',
        cutLog: '日誌切割',
        cutLogHelper1: '當前配置只會影響新創建的容器；',
        cutLogHelper2: '已經創建的容器需要重新創建使配置生效；',
        cutLogHelper3:
            '註意，重新創建容器可能會導致數據丟失。如果你的容器中有重要數據，確保在執行重建操作之前進行備份。',
        maxSize: '文件大小',
        maxFile: '保留份數',
        liveHelper: '允許在 Docker 守護進程發生意外停機或崩潰時保留正在運行的容器狀態',
        liveWithSwarmHelper: 'live-restore 守護進程配置與 Swarm 模式不兼容',
        iptablesDisable: '關閉 iptables',
        iptablesHelper1: 'Docker 對 iptables 規則的自動配置',
        iptablesHelper2: '關閉 iptables 會導致容器無法與外部網絡通信。',
        daemonJsonPath: '配置路徑',
        serviceUnavailable: '當前未啟動 Docker 服務，請在',
        startIn: '中開啟',
    },
    cronjob: {
        create: '創建計劃任務',
        edit: '編輯計劃任務',
        cronTask: '計劃任務',
        changeStatus: '狀態修改',
        disableMsg: '停止計劃任務會導致該任務不再自動執行。是否繼續？',
        enableMsg: '啟用計劃任務會讓該任務定期自動執行。是否繼續？',
        taskType: '任務類型',
        record: '報告',
        shell: 'Shell 腳本',
        containerCheckBox: '在容器中執行（無需再輸入進入容器命令）',
        containerName: '容器名稱',
        ntp: '時間同步',
        app: '備份應用',
        website: '備份網站',
        rulesHelper: '當存在多個壓縮排除規則時，需要換行顯示，例：\n*.log \n*.sql',
        lastRecordTime: '上次執行時間',
        database: '備份數據庫',
        missBackupAccount: '未能找到備份賬號',
        syncDate: '同步時間 ',
        releaseMemory: '釋放內存',
        curl: '訪問 URL',
        taskName: '任務名稱',
        cronSpec: '執行周期',
        cronSpecHelper: '請輸入正確的執行周期',
        cleanHelper: '該操作將所有任務執行記錄、備份文件和日誌文件，是否繼續？',
        directory: '備份目錄',
        sourceDir: '備份目錄',
        snapshot: '系統快照',
        allOptionHelper: '當前計劃任務為備份所有【{0}】，暫不支持直接下載，可在【{0}】備份列表中查看',
        exclusionRules: '排除規則',
        saveLocal: '同時保留本地備份（和雲存儲保留份數一致）',
        url: 'URL 地址',
        target: '備份到',
        targetHelper: '第三方備份賬號在面板設置中維護',
        retainCopies: '保留份數',
        retainCopiesHelper: '執行記錄、日誌文件、備份文件保留份數',
        cronSpecRule: '請輸入正確的執行周期',
        perMonth: '每月',
        perWeek: '每周',
        perHour: '每小時',
        perNDay: '每隔 N 日',
        perDay: '每天',
        perNHour: '每隔 N 時',
        perNMinute: '每隔 N 分鐘',
        perNSecond: '每隔 N 秒',
        per: '每隔',
        handle: '執行',
        day: '日',
        monday: '周一',
        tuesday: '周二',
        wednesday: '周三',
        thursday: '周四',
        friday: '周五',
        saturday: '周六',
        sunday: '周日',
        shellContent: '腳本內容',
        errRecord: '錯誤的日誌記錄',
        errHandle: '任務執行失敗',
        noRecord: '當前計劃任務暫未產生記錄',
        cleanData: '刪除備份文件',
        cleanDataHelper: '刪除該任務執行過程中產生的備份文件',
        noLogs: '暫無任務輸出...',
        errPath: '備份路徑 [{0}] 錯誤，無法下載！',
        cutWebsiteLog: '切割網站日誌',
        cutWebsiteLogHelper: '切割的日誌文件會備份到 1Panel 的 backup 目錄下',
    },
    monitor: {
        monitor: '監控',
        globalFilter: '全局過濾',
        enableMonitor: '監控狀態',
        storeDays: '保存天數',
        cleanMonitor: '清空監控記錄',

        avgLoad: '平均負載',
        loadDetail: '負載詳情',
        resourceUsage: '資源使用率',
        networkCard: '網卡',
        read: '讀取',
        write: '寫入',
        readWriteCount: '讀寫次數',
        readWriteTime: '讀寫延遲',
        today: '今天',
        yesterday: '昨天',
        lastNDay: '近 {0} 天',
        memory: '內存',
        cache: '緩存',
        disk: '磁盤',
        network: '網絡',
        up: '上行',
        down: '下行',
        interval: '采集間隔（分鐘）',
    },
    terminal: {
        conn: '連接',
        connLocalErr: '無法自動認證，請填寫本地服務器的登錄信息！',
        testConn: '連接測試',
        saveAndConn: '保存並連接',
        connTestOk: '連接信息可用',
        connTestFailed: '連接不可用，請檢查連接信息！',
        host: '主機',
        createConn: '新建連接',
        group: '分組',
        noHost: '暫無主機',
        groupChange: '切換分組',
        expand: '全部展開',
        fold: '全部收縮',
        batchInput: '批量輸入',
        quickCommand: '快速命令',
        quickCommandHelper: '常用命令列表，用於在終端界面底部快速選擇',
        groupDeleteHelper: '移除組後，組內所有連接將遷移到 default 組內，是否確認',
        command: '命令',
        addHost: '添加主機',
        localhost: '本地服務器',
        ip: '主機地址',
        authMode: '認證方式',
        passwordMode: '密碼認證',
        rememberPassword: '記住密碼',
        keyMode: '私鑰認證',
        key: '私鑰',
        keyPassword: '私鑰密碼',
        emptyTerminal: '暫無終端連接',
    },
    logs: {
        panelLog: '面板日誌',
        operation: '操作日誌',
        login: '訪問日誌',
        loginIP: '登錄 IP',
        loginAddress: '登錄地址',
        loginAgent: '用戶代理',
        loginStatus: '登錄狀態',
        system: '系統日誌',
        deleteLogs: '清空日誌',
        resource: '資源',
        operate: '操作',
        detail: {
            hosts: '主機',
            apps: '應用',
            websites: '網站',
            containers: '容器',
            files: '文件管理',
            runtimes: '運行環境',
            process: '進程管理',
            logs: '日誌審計',
            settings: '面板設置',
            cronjobs: '計劃任務',
            databases: '數據庫',
        },
        websiteLog: '網站日誌',
        runLog: '運行日誌',
        errLog: '錯誤日誌',
    },
    file: {
        dir: '文件夾',
        upload: '上傳',
        download: '下載',
        fileName: '文件名',
        search: '在當前目錄下查找',
        mode: '權限',
        owner: '所有者',
        file: '文件',
        remoteFile: '遠程下載',
        share: '分享',
        sync: '數據同步',
        size: '大小',
        updateTime: '修改時間',
        open: '打開',
        rename: '重命名',
        role: '權限',
        info: '屬性',
        linkFile: '軟連接文件',
        terminal: '終端',
        shareList: '分享列表',
        zip: '壓縮',
        group: '用戶組',
        path: '路徑',
        public: '公共',
        setRole: '設置權限',
        link: '是否鏈接',
        rRole: '讀取',
        wRole: '寫入',
        xRole: '可執行',
        compress: '壓縮',
        deCompress: '解壓',
        compressType: '壓縮格式',
        compressDst: '壓縮路徑',
        replace: '覆蓋已存在的文件',
        compressSuccess: '壓縮成功',
        deCompressSuccess: '解壓成功',
        deCompressDst: '解壓路徑',
        linkType: '鏈接類型',
        softLink: '軟鏈接',
        hardLink: '硬鏈接',
        linkPath: '鏈接路徑',
        selectFile: '選擇文件',
        downloadSuccess: '下載成功',
        downloadUrl: '下載地址',
        downloadStart: '下載開始!',
        moveSuccess: '移動成功',
        copySuccess: '復製成功',
        move: '移動',
        copy: '復製',
        calculate: '計算',
        canNotDeCompress: '無法解壓此文件',
        uploadSuccess: '上傳成功!',
        downloadProcess: '下載進度',
        downloading: '正在下載...',
        infoDetail: '文件屬性',
        root: '根目錄',
        list: '文件列表',
        sub: '包含子目錄',
        downlodSuccess: '下載完成',
        theme: '主題',
        language: '語言',
        eol: '行尾符',
        copyDir: '復製路徑',
        paste: '粘貼',
        cancel: '取消',
        changeOwner: '修改用戶和用戶組',
        containSub: '同時修改子文件屬性',
        ownerHelper: 'PHP 運行環境默認用戶:用戶組為 1000:1000, 容器內外用戶顯示不一致為正常現象',
        searchHelper: '支持 * 等通配符',
        uploadFailed: '【{0}】 文件上傳失敗',
        fileUploadStart: '正在上傳【{0}】....',
        currentSelect: '當前選中: ',
        unsupportType: '不支持的文件類型',
        deleteHelper: '以下資源將被刪除，此操作不可回滾，是否繼續？',
    },
    ssh: {
        sshAlert: '列表數據根據登錄時間排序，但請註意，切換時區或其他操作可能導致登錄日誌的時間出現偏差。',
        sshOperate: '對 SSH 服務進行 [{0}] 操作，是否繼續？',
        sshChange: 'SSH 配置修改',
        sshChangeHelper: '此操作將 {0} 修改為 [{1}] ，是否繼續？',
        sshFileChangeHelper: '直接修改配置文件可能會導致服務不可用，請謹慎操作，是否繼續？',
        port: '連接端口',
        portHelper: '指定 SSH 服務監聽的端口號，默認為 22。',
        listenAddress: '監聽地址',
        addressHelper: '指定 SSH 服務監聽的 IP 地址，默認為 0.0.0.0，即所有的網絡接口都會被監聽。',
        permitRootLogin: 'root 用戶',
        rootSettingHelper: 'root 用戶 SSH 登錄方式，默認所有 SSH 登錄。',
        rootHelper1: '允許 SSH 登錄',
        rootHelper2: '禁止 SSH 登錄',
        rootHelper3: '僅允許密鑰登錄',
        rootHelper4: '僅允許執行預先定義的命令，不能進行其他操作',
        passwordAuthentication: '密碼認證',
        pwdAuthHelper: '是否啟用密碼認證，默認啟用。',
        pubkeyAuthentication: '密鑰認證',
        key: '密鑰',
        password: '密碼',
        pubkey: '密鑰信息',
        encryptionMode: '加密方式',
        passwordHelper: '支持大小寫英文、數字,長度6-10',
        generate: '生成密鑰',
        reGenerate: '重新生成密鑰',
        keyAuthHelper: '是否啟用密鑰認證，默認啟用。',
        useDNS: '反向解析',
        dnsHelper: '控製 SSH 服務器是否啟用 DNS 解析功能，從而驗證連接方的身份。',
        analysis: '統計信息',
        denyHelper: '將對下列地址進行【屏蔽】操作，設置後該 IP 將禁止訪問服務器，是否繼續？',
        acceptHelper: '將對下列地址進行【放行】操作，設置後該 IP 將恢復正常訪問，是否繼續？',
        noAddrWarning: '當前未選中任何可【{0}】地址，請檢查後重試！',
        successful: '成功',
        failed: '失敗',
        loginLogs: 'SSH 登錄日誌',
        loginMode: '登錄方式',
        authenticating: '密鑰',
        publickey: '密鑰',
        belong: '歸屬地',
        local: '內網',
        remote: '外網',
        config: '配置',
        session: '會話',
        loginTime: '登錄時間',
        loginIP: '登錄IP',
        disconnect: '斷開',
        stopSSHWarn: '是否斷開此SSH連接',
    },
    setting: {
        all: '全部',
        panel: '面板',
        user: '用戶名稱',
        userChange: '修改用戶名',
        userChangeHelper: '修改用戶名將退出登陸，是否繼續？',
        passwd: '用戶密碼',
        emailHelper: '用於密碼找回',
        title: '面板別名',
        panelPort: '面板端口',
        portHelper: '建議端口範圍8888 - 65535，註意：有安全組的服務器請提前在安全組放行新端口',
        portChange: '端口修改',
        portChangeHelper: '服務端口修改需要重啟服務，是否繼續？',
        theme: '主題顏色',
        componentSize: '組件大小',
        dark: '暗色',
        light: '亮色',
        language: '系統語言',
        languageHelper: '默認跟隨瀏覽器語言，設置後只對當前瀏覽器生效，更換瀏覽器後需要重新設置',
        sessionTimeout: '超時時間',
        sessionTimeoutError: '最小超時時間為 300 秒',
        sessionTimeoutHelper: '如果用戶超過 {0} 秒未操作面板，面板將自動退出登錄',
        systemIP: '服務器地址',
        systemIPWarning: '當前未設置服務器地址，請先在面板設置中設置！',
        defaultNetwork: '默認網卡',
        syncTime: '服務器時間',
        timeZone: '系統時區',
        timeZoneChangeHelper: '系統時區修改需要重啟服務，是否繼續？',
        timeZoneHelper: '時區修改依賴於系統 timedatectl 服務，重啟 1Panel 服務後生效。',
        timeZoneCN: '北京',
        timeZoneAM: '洛杉磯',
        timeZoneNY: '紐約',
        ntpALi: '阿裏',
        ntpGoogle: '谷歌',
        syncSite: 'NTP 服務器',
        syncSiteHelper: '該操作將使用 {0} 作為源進行系統時間同步，是否繼續？',
        changePassword: '密碼修改',
        oldPassword: '原密碼',
        newPassword: '新密碼',
        retryPassword: '確認密碼',
        duplicatePassword: '新密碼不能與原始密碼一致，請重新輸入！',
        diskClean: '缓存清理',

        thirdParty: '第三方賬號',
        createBackupAccount: '添加 {0}',
        noTypeForCreate: '當前無可創建備份類型',
        LOCAL: '服務器磁盤',
        currentPath: '當前路徑',
        OSS: '阿裏雲 OSS',
        S3: '亞馬遜 S3 雲存儲',
        MINIO: 'MINIO',
        SFTP: 'SFTP',
        OneDrive: '微軟 OneDrive',
        backupDir: '備份路徑',
        isCN: '國內版',
        code: '授權碼',
        codeHelper:
            '請點擊獲取按鈕，然後登錄 OneDrive 復製跳轉鏈接中 code 後面的內容，粘貼到該輸入框中，具體操作可參考官方文檔。',
        loadCode: '獲取',
        COS: '騰訊雲 COS',
        KODO: '七牛雲 Kodo',
        scType: '存儲類型',
        typeStandard: '標準存儲',
        typeStandard_IA: '低頻存儲',
        typeArchive: '歸檔存儲',
        typeDeep_Archive: '深度歸檔存儲',
        scStandard: '標準存儲，適用於實時訪問的大量熱點文件、頻繁的數據交互等業務場景。',
        scStandard_IA: '低頻存儲，適用於較低訪問頻率（例如平均每月訪問頻率1到2次）的業務場景，最少存儲30天。',
        scArchive: '歸檔存儲，適用於極低訪問頻率（例如半年訪問1次）的業務場景。',
        scDeep_Archive: '深度歸檔存儲，適用於極低訪問頻率（例如1年訪問1~2次）的業務場景。',
        archiveHelper: '歸檔存儲的文件無法直接下載，需要先在對應的雲服務商網站進行恢復操作，請謹慎使用！',
        domainHelper: '加速域名必須包含 http:// 或者 https://',
        backupAlert:
            "理論上只要雲廠商兼容 S3 協議，就可以用現有的亞馬遜 S3 雲存儲來備份，具體配置參考 <a target=「_blank」 href='https://1panel.cn/docs/user_manual/settings/#3'>官方文檔</a> ",
        domain: '加速域名',
        backupAccount: '備份賬號',
        loadBucket: '獲取桶',
        accountName: '賬戶名稱',
        accountKey: '賬戶密鑰',
        address: '地址',
        path: '路徑',

        snapshot: '快照',
        status: '快照狀態',
        panelInfo: '寫入 1Panel 基礎信息',
        panelBin: '備份 1Panel 系統文件',
        daemonJson: '備份 Docker 配置文件',
        appData: '備份 1Panel 已安裝應用',
        panelData: '備份 1Panel 數據目錄',
        backupData: '備份 1Panel 本地備份目錄',
        compress: '製作快照文件',
        upload: '上傳快照文件',
        thirdPartySupport: '僅支持第三方賬號',
        recoverDetail: '恢復詳情',
        createSnapshot: '創建快照',
        importSnapshot: '同步快照',
        recover: '恢復',
        noRecoverRecord: '暫無恢復記錄',
        lastRecoverAt: '上次恢復時間',
        lastRollbackAt: '上次回滾時間',
        noRollbackRecord: '暫無回滾記錄',
        reDownload: '重新下載備份文件',
        statusAll: '全部',
        statusSuccess: '成功',
        statusFailed: '失敗',
        versionChange: '版本變化',
        snapshotFrom: '快照存儲位置',
        recoverHelper: '即將從快照 {0} 開始恢復，恢復需要重啟 docker 以及 1panel 服務，是否繼續？',
        rollback: '回滾',
        rollbackHelper:
            '即將回滾本次恢復，回滾將替換所有本次恢復的文件，過程中可能需要重啟 docker 以及 1panel 服務，是否繼續？',

        upgrading: '正在升級中，請稍候...',
        upgradeHelper: '升級操作需要重啟服務，是否繼續？',
        noUpgrade: '當前已經是最新版本',
        versionHelper: '1Panel 版本號命名規則為： [大版本].[功能版本].[Bug 修復版本]，例：',
        versionHelper1: 'v1.0.1 是 v1.0.0 之後的 Bug 修復版本',
        versionHelper2: 'v1.1.0 是 v1.0.0 之後的功能版本',
        newVersion: '(Bug 修復版本)',
        latestVersion: '(功能版本)',
        upgradeCheck: '檢查更新',
        upgradeNotes: '更新內容',
        upgradeNow: '立即更新',
        source: '下載源',
        hasNewVersion: '有新版本',

        safe: '安全',
        entrance: '安全入口',
        showEntrance: '啟用概覽頁未開啟提醒',
        entranceHelper: '開啟安全入口後只能通過指定安全入口登錄面板',
        entranceError: '請輸入 6-10 位安全登錄入口，僅支持輸入數字或字母',
        entranceInputHelper: '安全入口設置為空時，則取消安全入口',
        randomGenerate: '隨機生成',
        expirationTime: '密碼過期時間',
        unSetting: '未設置',
        noneSetting: '為面板密碼設置過期時間，過期後需要重新設置密碼',
        expirationHelper: '密碼過期時間為 [0] 天時，則關閉密碼過期功能',
        days: '過期天數',
        expiredHelper: '當前密碼已過期，請重新修改密碼：',
        timeoutHelper: '【 {0} 天後 】面板密碼即將過期，過期後需要重新設置密碼',
        complexity: '密碼復雜度驗證',
        complexityHelper: '開啟後密碼必須滿足密碼長度大於 8 位且包含字母、數字及特殊字符',
        bindDomain: '域名綁定',
        unBindDomain: '域名解綁',
        unBindDomainHelper: '解除域名綁定可能造成系統不安全，是否繼續？',
        bindDomainHelper: '設置域名綁定後，僅能通過設置中域名訪問 1Panel 服務',
        bindDomainHelper1: '綁定域名為空時，則取消域名綁定',
        bindDomainWarning: '設置域名綁定後，將退出當前登錄，且僅能通過設置中域名訪問 1Panel 服務，是否繼續？',
        allowIPs: '授權 IP',
        unAllowIPs: '取消授權',
        unAllowIPsWarning: '授權 IP 為空將允許所有 IP 訪問系統，可能造成系統不安全，是否繼續？',
        allowIPsHelper: '設置授權 IP 後，僅有設置中的 IP 可以訪問 1Panel 服務',
        allowIPsWarning: '設置授權 IP 後，僅有設置中的 IP 可以訪問 1Panel 服務，是否繼續？',
        allowIPsHelper1: '授權 IP 為空時，則取消授權 IP',
        allowIPEgs: '當存在多個授權 IP 時，需要換行顯示，例： \n172.16.10.111 \n172.16.10.0/24',
        mfa: '兩步驗證',
        secret: '密鑰',
        mfaAlert: '兩步驗證密碼是基於當前時間生成，請確保服務器時間已同步',
        mfaHelper: '開啟後會驗證手機應用驗證碼',
        mfaHelper1: '下載兩步驗證手機應用 如:',
        mfaHelper2: '使用手機應用掃描以下二維碼，獲取 6 位驗證碼',
        mfaHelper3: '輸入手機應用上的 6 位數字',
        mfaCode: '驗證碼',
        mfaInterval: '刷新時間（秒）',
        mfaTitleHelper: '用於區分不同 1Panel 主機，修改後請重新掃描或手動添加密鑰信息！',
        mfaIntervalHelper: '修改刷新時間後，請重新掃描或手動添加密鑰信息！',
        sslChangeHelper: 'https 設置修改需要重啟服務，是否繼續？',
        sslDisable: '禁用',
        sslDisableHelper: '禁用 https 服務，需要重啟面板才能生效，是否繼續？',

        https: '為面板設置 https 協議訪問，提升面板訪問安全性',
        certType: '證書類型',
        selfSigned: '自簽名',
        selfSignedHelper: '自簽證書，不被瀏覽器信任，顯示不安全是正常現象',
        select: '選擇已有',
        domainOrIP: '域名或 IP：',
        timeOut: '過期時間：',
        rootCrtDownload: '根證書下載',
        primaryKey: '密鑰',
        certificate: '證書',

        about: '關於',
        project: '項目地址',
        issue: '問題反饋',
        doc: '官方文檔',
        star: '點亮 Star',
        description: '1Panel，現代化、開源的 Linux 服務器運維管理面板。',
        forum: '論壇',
        doc2: '文檔',
        currentVersion: '當前運行版本：',
    },
    clean: {
        scan: '開始掃描',
        clean: '立即清理',
        reScan: '重新掃描',
        cleanHelper: '已勾選文件及目錄清理後無法回滾（系統緩存文件清理需要重啟服務），是否繼續？',
        statusSuggest: '( 建議清理 )',
        statusClean: '( 很幹凈 )',
        statusEmpty: '非常幹凈，無需清理！',
        statusWarning: '( 謹慎操作 )',
        lastCleanTime: '上次清理時間: {0}',
        lastCleanHelper: '清理文件及目錄：{0} 個， 總計清理：{1}',
        cleanSuccessful: '清理成功！',
        currentCleanHelper: '本次清理文件及目錄：{0} 個， 總計清理：{1}',
        suggest: '( 建議清理 )',
        totalScan: '待清理垃圾文件共計： ',
        selectScan: '已選中垃圾文件共計： ',

        system: '系統垃圾',
        systemHelper: '快照、升級等過程中產生的臨時文件以及版本叠代過程中廢棄的文件內容',
        panelOriginal: '系統快照恢復前備份文件',
        upgrade: '系統升級備份文件',
        upgradeHelper: '( 建議保留最新的升級備份用於系統回滾 )',
        cache: '系統緩存文件',
        cacheHelper: '( 謹慎操作，清理需要重啟服務 )',
        snapshot: '系統快照臨時文件',
        snapshotTmp: '系統快照上傳臨時文件',
        snapshotLocal: '系統快照製作臨時文件',
        rollback: '恢復前備份目錄',
        unused: '系統廢棄目錄',
        oldUpgrade: '廢棄升級前備份目錄',
        oldOriginal: '廢棄快照恢復前備份目錄',
        oldAppsBak: '廢棄應用備份目錄',

        upload: '臨時上傳文件',
        uploadHelper: '系統上傳備份列表中上傳的臨時文件',
        download: '臨時下載文件',
        downloadHelper: '系統從第三方備份賬號下載的臨時文件',
        website: '網站',
        app: '應用',
        database: '數據庫',
        directory: '文件夾',

        systemLog: '系統日誌文件',
        systemLogHelper: '系統日誌信息、容器構建或鏡像拉取等日誌信息以及計劃任務中產生的日誌文件',
        dockerLog: '容器操作日誌文件',
        taskLog: '計劃任務執行日誌文件',
        shell: 'Shell 腳本計劃任務',
        containerShell: '容器內執行 Shell 腳本計劃任務',
        curl: 'CURL 計劃任務',
    },
    app: {
        app: '應用',
        installName: '安裝名稱',
        installed: '已安裝',
        all: '全部',
        version: '版本',
        detail: '詳情',
        params: '參數',
        install: '安裝',
        author: '作者',
        source: '來源',
        sync: '同步',
        appName: '應用名稱',
        status: '狀態',
        container: '容器',
        restart: '重啟',
        start: '啟動',
        stop: '停止',
        rebuild: '重建',
        description: '描述',
        deleteWarn: '刪除操作會把所有數據和備份一並刪除，此操作不可回滾，是否繼續？',
        syncSuccess: '同步成功',
        canUpgrade: '可升級',
        backupName: '文件名稱',
        backupPath: '文件路徑',
        backupdate: '備份時間',
        update: '更新',
        versionSelect: '請選擇版本',
        operatorHelper: '將對選中應用進行 {0} 操作，是否繼續？',
        checkInstalledWarn: '未檢測到 {0} ,請進入應用商店點擊安裝!',
        gotoInstalled: '去安裝',
        search: '搜索',
        limitHelper: '該應用已安裝，不支持重復安裝',
        deleteHelper: '{0}已經關聯以下資源，無法刪除',
        checkTitle: '提示',
        website: '網站',
        database: '數據庫',
        defaultConfig: '默認配置',
        defaultConfigHelper: '已恢復為默認配置，保存後生效',
        forceDelete: '強製刪除',
        forceDeleteHelper: '強製刪除，會忽略刪除過程中產生的錯誤並最終刪除元數據',
        deleteBackup: '刪除備份',
        deleteBackupHelper: '同時刪除應用備份',
        deleteDB: '刪除數據庫',
        deleteDBHelper: '同時刪除與應用關聯的數據庫',
        noService: '無{0}',
        toInstall: '去安裝',
        param: '參數配置',
        syncAppList: '更新應用列表',
        alreadyRun: '已安裝',
        less1Minute: '小於1分鐘',
        appOfficeWebsite: '官方網站',
        github: '開源社區',
        document: '文檔說明',
        updatePrompt: '當前應用均為最新版本',
        installPrompt: '尚未安裝任何應用',
        updateHelper: '更新參數可能導致應用無法啟動，請提前備份並謹慎操作',
        updateWarn: '更新參數需要重建應用，是否繼續？',
        busPort: '服務端口',
        syncStart: '開始同步！請稍後刷新應用商店',
        advanced: '高級設置',
        cpuCore: '核心數',
        containerName: '容器名稱',
        containerNameHelper: '可以為空，為空自動生成',
        allowPort: '端口外部訪問',
        allowPortHelper: '允許端口外部訪問會放開防火墻端口',
        appInstallWarn: '應用端口默認不允許外部訪問，可以在下方高級設置中選擇放開',
        upgradeStart: '開始升級！請稍後刷新頁面',
        toFolder: '進入安裝目錄',
        editCompose: '編輯 compose 文件',
        editComposeHelper: '編輯 compose 文件可能導致軟件安裝失敗',
        composeNullErr: 'compose 不能為空',
        takeDown: '已廢棄',
        allReadyInstalled: '已安裝',
        installHelper: '配置鏡像加速可以解決鏡像拉取失敗的問題',
        upgradeHelper: '異常應用需要先同步到正常狀態',
        installWarn: '當前未勾選端口外部訪問，將無法通過外網IP:端口訪問，是否繼續？ ',
        restoreWarn: '恢復操作將刪除該應用當前數據並重啟。此操作不可回滾，是否繼續?',
        showIgnore: '查看忽略應用',
        cancelIgnore: '取消忽略',
        ignoreList: '忽略列表',
        appHelper: '部分應用的安裝使用說明請在應用詳情頁查看',
        backupApp: '升級前備份應用',
        backupAppHelper: '升級失敗可以使用應用備份回滾',
        delete: '刪除',
        openrestyDeleteHelper: '強制刪除 OpenResty 會刪除所有的網站，請確認風險後操作',
        downloadLogHelper1: '即將下載 {0} 套用所有日誌，是否繼續？ ',
        downloadLogHelper2: '即將下載 {0} 應用最近 {1} 條日誌，是否繼續？ ',
        syncAllAppHelper: '即將同步所有應用，是否繼續？ ',
    },
    website: {
        website: '網站',
        primaryDomain: '主域名',
        otherDomains: '其他域名',
        static: '靜態網站',
        deployment: '一鍵部署',
        supportUpType: '僅支持 .tar.gz 文件',
        zipFormat: '.tar.gz 壓縮包結構：test.tar.gz 壓縮包內，必需包含 {0} 文件',
        proxy: '反向代理',
        alias: '代號',
        remark: '備註',
        group: '分組',
        groupSetting: '分組管理',
        createGroup: '創建分組',
        app: '應用',
        appNew: '新裝應用',
        appInstalled: '已裝應用',
        create: '創建網站',
        delete: '刪除網站',
        deleteApp: '刪除應用',
        deleteBackup: '刪除備份',
        domain: '域名',
        domainHelper: '一行一個域名,支持*和IP地址,支持域名:端口',
        addDomain: '新增域名',
        domainConfig: '域名設置',
        defaultDoc: '默認文檔',
        perserver: '並發限製',
        perserverHelper: '限製當前站點最大並發數',
        perip: '單IP限製',
        peripHelper: '限製單個IP訪問最大並發數',
        rate: '流量限製',
        rateHelper: '限製每個請求的流量上(單位:KB)',
        limitHelper: '啟用流量控製',
        other: '其他',
        currentSSL: '當前證書',
        dnsAccount: 'DNS賬號',
        applySSL: '證書申請',
        SSLList: '證書列表',
        createDnsAccount: 'DNS賬戶',
        aliyun: '阿裏雲DNS',
        manual: '手動解析',
        key: '密鑰',
        check: '查看',
        acmeAccountManage: 'Acme 賬戶',
        email: '郵箱',
        addAccount: '創建賬戶',
        acmeAccount: 'Acme 賬戶',
        provider: '驗證方式',
        dnsManual: '手動解析',
        expireDate: '過期時間',
        brand: '頒發者',
        deploySSL: '部署',
        deploySSLHelper: '確定部署證書？',
        ssl: '證書',
        dnsAccountManage: 'DNS 賬戶',
        renewSSL: '續簽',
        renewHelper: '確定續簽證書？',
        renewSuccess: '續簽證書',
        config: '配置',
        enableHTTPS: '啟用 HTTPS',
        aliasHelper: '代號是網站目錄的文件夾名稱',
        lastBackupAt: '上次備份時間',
        null: '無',
        nginxConfig: 'Nginx配置',
        websiteConfig: '網站設置',
        basic: '基本',
        source: '配置文件',
        security: '安全',
        log: '日誌',
        nginxPer: '性能調整',
        neverExpire: '永不過期',
        setDefault: '設為默認',
        default: '默認',
        deleteHelper: '相關應用狀態不正常，請檢查',
        toApp: '去已安裝列表',
        cycle: '周期',
        frequency: '頻率',
        ccHelper: '{0} 秒內累計請求同一URL超過 {1} 次,觸發CC防禦,封鎖此IP',
        mustSave: '修改之後需要保存才能生效',
        fileExt: '文件擴展名',
        fileExtBlock: '文件擴展名黑名單',
        value: '值',
        enable: '開啟',
        proxyAddress: '代理地址',
        proxyHelper: '例: 127.0.0.1:8080',
        forceDelete: '強製刪除',
        forceDeleteHelper: '強製刪除，會忽略刪除過程中產生的錯誤並最終刪除元數據',
        deleteAppHelper: '同時刪除關聯應用、數據庫以及應用備份',
        deleteBackupHelper: '同時刪除網站備份',
        deleteConfirmHelper: '刪除操作無法回滾，請輸入 <span style="color:red"> "{0}" </span> 刪除',
        staticPath: '對應主目錄:',
        limit: '限製方案',
        blog: '論壇/博客',
        imageSite: '圖片站',
        downloadSite: '下載站',
        shopSite: '商城',
        doorSite: '門戶',
        qiteSite: '企業',
        videoSite: '視頻',
        errLog: '錯誤日誌',
        accessLog: '網站日誌',
        stopHelper: '停止站點後將無法正常訪問，用戶訪問會顯示當前站點停止頁面，是否繼續操作？',
        startHelper: '啟用站點後，用戶可以正常訪問網站內容，是否繼續操作？',
        sitePath: '網站目錄',
        siteAlias: '網站代號',
        primaryPath: '主目錄',
        folderTitle: '網站主目錄主要包含四個文件夾',
        wafFolder: '防火墻規則',
        indexFolder: '網站root目錄',
        logFolder: '網站日誌',
        sslFolder: '網站證書',
        enableOrNot: '是否啟用',
        oldSSL: '選擇已有證書',
        manualSSL: '手動導入證書',
        select: '選擇',
        selectSSL: '選擇證書',
        privateKey: '私鑰(KEY)',
        certificate: '證書(PEM格式)',
        HTTPConfig: 'HTTP 選項',
        HTTPSOnly: '禁止 HTTP',
        HTTPToHTTPS: '訪問HTTP自動跳轉到HTTPS',
        HTTPAlso: 'HTTP可直接訪問',
        sslConfig: 'SSL 選項',
        disableHTTPS: '禁用 HTTPS',
        disableHTTPSHelper: '禁用 HTTPS會刪除證書相關配置，是否繼續？',
        SSLHelper: '註意：請勿將SSL證書用於非法網站 \n 如開啟後無法使用HTTPS訪問，請檢查安全組是否正確放行443端口',
        SSLConfig: '證書設置',
        SSLProConfig: 'SSL 協議設置',
        supportProtocol: '支持的協議版本',
        encryptionAlgorithm: '加密算法',
        notSecurity: '（不安全）',
        encryptHelper:
            "Let's Encrypt 簽發證書有頻率限製，但足以滿足正常需求，過於頻繁操作會導致簽發失敗。具體限製請看 <a target=「_blank」 href='https://letsencrypt.org/zh-cn/docs/rate-limits/'>官方文檔</a> ",
        ipValue: '值',
        ext: '文件擴展名',
        wafInputHelper: '按行輸入數據，一行一個',
        data: '數據',
        ever: '永久',
        nextYear: '一年後',
        noLog: '當前沒有日誌...',
        defaultServer: '默認站點',
        noDefaultServer: '未設置',
        defaultServerHelper: '設置默認站點後,所有未綁定的域名和IP都被定向到默認站點\n可有效防止惡意解析',
        websiteDeploymentHelper: '使用從 1Panel 部署的應用創建網站',
        websiteStatictHelper: '在主機上創建網站目錄',
        websiteProxyHelper:
            '代理已有服務,例如本機已安裝使用 8080 端口的 halo 服務，那麼代理地址為 http://127.0.0.1:8080',
        restoreHelper: '確認使用此備份恢復？',
        wafValueHelper: '值',
        wafRemarkHelper: '描述',
        runtimeProxyHelper: '使用從 1Panel 創建的運行環境',
        runtime: '運行環境',
        deleteRuntimeHelper: '運行環境應用需要跟網站一並刪除，請謹慎處理',
        proxyType: '監聽網絡類型',
        unix: 'Unix 網絡',
        tcp: 'TCP/IP 網絡',
        phpFPM: 'FPM 配置文件',
        phpConfig: 'PHP 配置文件',
        updateConfig: '配置修改',
        isOn: '開啟',
        isOff: '關閉',
        rewrite: '偽靜態',
        rewriteMode: '方案',
        current: '當前',
        rewriteHelper: '若設置偽靜態後，網站無法正常訪問，請嘗試設置回default',
        runDir: '運行目錄',
        runUserHelper:
            '通過 PHP 運行環境部署的網站，需要將 index 和子目錄下的所有文件、文件夾所有者和用戶組設置為 1000',
        userGroup: '運行用戶/組',
        uGroup: '用戶組',
        proxyPath: '前端請求路徑',
        proxyPass: '後端代理地址',
        cache: '緩存',
        createProxy: '創建反向代理',
        editProxy: '編輯反向代理',
        cacheTime: '緩存時間',
        enableCache: '開啟緩存',
        proxyHost: '後端域名',
        disabled: '已停止',
        startProxy: '開啟反向代理',
        stopProxy: '關閉反向代理',
        proxyFile: '源文',
        proxyHelper1: '訪問這個目錄時將會把目標URL的內容返回並顯示',
        proxyPassHelper: '代理的站點，必須為可正常訪問的URL',
        proxyHostHelper: '將域名添加到請求頭傳遞到代理服務器',
        replacementHelper: '最多可以添加5條替換內容,如果不需要替換請留空',
        modifier: '匹配規則',
        modifierHelper: '例：= 精確匹配，~ 正則匹配，^~ 匹配路徑開頭 等',
        replace: '文本替換',
        addReplace: '添加文本替換',
        replaced: '搜索字符串（不能為空）',
        replaceText: '替換為字符串',
        replacedErr: '搜索字符串不能為空',
        replacedErr2: '搜索字符串不能重復',
        basicAuth: '密碼訪問',
        editBasicAuthHelper: '密碼為非對稱加密，無法回顯，編輯需要重新設置密碼',
        antiLeech: '防盜鏈',
        extends: '擴展名',
        browserCache: '瀏覽器緩存',
        leechLog: '記錄防盜鏈日誌',
        accessDomain: '允許的域名',
        leechReturn: '響應資源',
        noneRef: '允許來源為空',
        disable: '未啟用',
        disableLeechHelper: '是否禁用防盜鏈',
        disableLeech: '禁用防盜鏈',
        ipv6: '監聽 IPV6 端口',
        leechReturnError: '請填寫 HTTP 狀態碼',
        selectAcme: '選擇 Acme 賬號',
        imported: '手動創建',
        importType: '導入方式',
        pasteSSL: '粘貼代碼',
        localSSL: '選擇本地文件',
        privateKeyPath: '私鑰文件',
        certificatePath: '證書文件',
        ipWhiteListHelper: 'IP白名單的作用：所有規則對IP白名單無效',
        redirect: '重定向',
        sourceDomain: '源域名/路徑',
        targetURL: '目標URL地址',
        keepPath: '保留URI參數',
        path: '路徑',
        redirectType: '重定向類型',
        redirectWay: '方式',
        keep: '保留',
        notKeep: '不保留',
        redirectRoot: '重定向到首頁',
        redirectHelper: '301永久重定向，302臨時重定向',
        changePHPVersionWarn: '切換 PHP 版本會刪除原有的 PHP 容器（不會丟失已經掛載的網站代碼），是否繼續？ ',
        changeVersion: '切換版本',
        retainConfig: '是否保留 php-fpm.conf 和 php.ini 文件',
        runDirHelper2: '請確保二級運行目錄位於 index 目錄下',
        openrestryHelper: 'OpenResty 默認 HTTP 端口：{0} HTTPS 端口：{1}，可能影響網站域名訪問和 HTTPS 強制跳轉',
        primaryDomainHelper: '支援網域:port',
    },
    php: {
        short_open_tag: '短標簽支持',
        max_execution_time: '最大腳本運行時間',
        max_input_time: '最大輸入時間',
        memory_limit: ' 腳本內存限製',
        post_max_size: 'POST數據最大尺寸',
        file_uploads: '是否允許上傳文件',
        upload_max_filesize: '允許上傳文件的最大尺寸',
        max_file_uploads: '允許同時上傳文件的最大數量',
        default_socket_timeout: 'Socket超時時間',
        error_reporting: '錯誤級別',
        display_errors: '是否輸出詳細錯誤信息',
        cgi_fix_pathinfo: '是否開啟pathinfo',
        date_timezone: '時區',
        disableFunction: '禁用函數',
        disableFunctionHelper: '輸入要禁用的函數，例如exec，多個請用,分割',
        uploadMaxSize: '上傳限製',
        indexHelper: '為保障PHP網站正常運行，請將代碼放置於 index 目錄，並避免重命名',
    },
    nginx: {
        serverNamesHashBucketSizeHelper: '服務器名字的hash表大小',
        clientHeaderBufferSizeHelper: '客戶端請求的頭buffer大小',
        clientMaxBodySizeHelper: '最大上傳文件',
        keepaliveTimeoutHelper: '連接超時時間',
        gzipMinLengthHelper: '最小壓縮文件',
        gzipCompLevelHelper: '壓縮率',
        gzipHelper: '是否開啟壓縮傳輸',
        connections: '活動連接(Active connections)',
        accepts: '總連接次數(accepts)',
        handled: '總握手次數(handled)',
        requests: '總請求數(requests)',
        reading: '請求數(Reading)',
        writing: '響應數(Writing)',
        waiting: '駐留進程(Waiting)',
        status: '當前狀態',
        nginxConfig: '設置',
        configResource: '配置修改',
        saveAndReload: '保存並重載',
    },
    ssl: {
        create: '創建證書',
        provider: '類型',
        manualCreate: '手動創建',
        acmeAccount: 'Acme 賬號',
        resolveDomain: '解析域名',
        err: '錯誤',
        value: '記錄值',
        dnsResolveHelper: '請到DNS解析服務商處添加以下解析記錄：',
        detail: '詳情',
        msg: '證書信息',
        ssl: '證書',
        key: '私鑰',
        startDate: '生效時間',
        organization: '簽發機構',
        renewConfirm: '是否確定續簽？',
        autoRenew: '自動續簽',
        autoRenewHelper: '距離到期時間7天自動續簽',
        renewSuccess: '續簽成功',
        renewWebsite: '該證書已經和以下網站關聯，續簽會同步應用到這些網站',
        createAcme: '創建賬戶',
        acmeHelper: 'Acme 賬戶用於申請免費證書',
    },
    firewall: {
        create: '創建規則',
        edit: '編輯規則',
        notSupport: '未檢測到系統防火墻（firewalld 或者 ufw），請參考官方文檔進行安裝',
        ccDeny: 'CC 防護',
        ipWhiteList: 'IP 白名單',
        ipBlockList: 'IP 黑名單',
        fileExtBlockList: '文件擴展名黑名單',
        urlWhiteList: 'URL 白名單',
        urlBlockList: 'URL 黑名單',
        argsCheck: 'GET 參數校驗',
        postCheck: 'POST 參數校驗',
        cookieBlockList: 'Cookie 黑名單',

        firewall: '防火墻',
        dockerHelper: 'Linux 防火墻 {0} 無法禁用 Docker 端口映射，應用可以在 [已安裝] 頁面編輯參數來控製端口是否放開',
        quickJump: '快速跳轉',
        used: '已使用',
        unUsed: '未使用',
        firewallHelper: '{0}系統防火墻',
        firewallNotStart: '當前未開啟系統防火墻，請先開啟！',
        stopFirewallHelper: '系統防火墻關閉後，服務器將失去安全防護，是否繼續？',
        startFirewallHelper: '系統防火墻開啟後，可以更好的防護服務器安全，是否繼續？',
        noPing: '禁 ping',
        noPingTitle: '是否禁 ping',
        noPingHelper: '禁 ping 後將無法 ping 通服務器，是否繼續？',
        onPingHelper: '解除禁 ping 後您的服務器可能會被黑客發現，是否繼續？',
        changeStrategy: '修改{0}策略',
        changeStrategyIPHelper1: 'IP 策略修改為【屏蔽】，設置後該 IP 將禁止訪問服務器，是否繼續？',
        changeStrategyIPHelper2: 'IP 策略修改為【放行】，設置後該 IP 將恢復正常訪問，是否繼續？',
        changeStrategyPortHelper1: '端口策略修改為【拒絕】，設置後端口將拒絕外部訪問，是否繼續？',
        changeStrategyPortHelper2: '端口策略修改為【允許】，設置後端口將恢復正常訪問，是否繼續？',
        stop: '禁止',
        portFormatError: '請輸入正確的端口信息！',
        portHelper1: '多個端口，如：8080,8081',
        portHelper2: '範圍端口，如：8080-8089',
        strategy: '策略',
        accept: '允許',
        drop: '拒絕',
        source: '來源',
        anyWhere: '所有 IP',
        address: '指定 IP',
        addressHelper: '支持輸入 IP 或 IP 段',
        allow: '放行',
        deny: '屏蔽',
        addressFormatError: '請輸入合法的 ip 地址！',
        addressHelper1: '支持輸入 IP 或 IP 段：172.16.10.11 或 172.16.0.0/24',
        addressHelper2: '多個 IP 或 IP 段 請用 "," 隔開：172.16.10.11,172.16.0.0/24',
        allIP: '所有 IP',
        portRule: '端口規則',
        ipRule: 'IP 規則',
    },
    runtime: {
        runtime: '運行環境',
        image: '鏡像',
        workDir: '工作目錄',
        create: '創建運行環境',
        resource: '來源',
        appstore: '應用商店',
        local: '本地',
        app: '應用',
        localHelper: '本地運行環境需要自行安裝',
        version: '版本',
        versionHelper: 'PHP的版本,例 v8.0',
        buildHelper: '選擇的擴展越多，製作鏡像過程中占用 CPU 越多，請盡量避免選擇全部擴展',
        openrestryWarn: 'PHP 需要升級  OpenResty 至 1.21.4.1 版本以上才能使用',
        toupgrade: '去升級',
        edit: '編輯運行環境',
        extendHelper: '列表中不存在的擴展，可以手動輸入之後選擇，例:輸入 sockets ，然後在下拉列表中選擇第一個',
        rebuildHelper: '編輯擴展後需要【重建】PHP 應用之後才能生效',
        phpPluginHelper:
            "<a target=“_blank” href='https://1panel.cn/docs/user_manual/websites/php/#php_1'>查看 PHP 擴展列表</a> ",
        rebuild: '重建 PHP 應用',
        source: 'PHP 擴展源',
        ustc: '中國科學技術大學',
        netease: '網易',
        aliyun: '阿里雲',
        default: '默認',
        tsinghua: '清華大學',
        xtomhk: 'XTOM 鏡像站（香港）',
        xtom: 'XTOM 鏡像站（全球）',
        phpsourceHelper: '根據你的網絡環境選擇合適的源',
        appPort: '應用端口',
        externalPort: '外部映射端口',
        packageManager: '包管理器',
        codeDir: '源碼目錄',
        appPortHelper: '應用端口是指容器內部運行的端口',
        externalPortHelper: '外部映射端口是指將容器內部端口映射到外部的端口',
        runScript: '啟動命令',
        runScriptHelper: '啟動命令是指容器啟動後運行的命令',
        open: '開啟',
        close: '關閉',
        operatorHelper: '將對選取的執行環境進行 {0} 操作，是否繼續？ ',
        statusHelper: '狀態說明：啟動中-容器已啟動，但應用正在啟動；異常-容器已啟動，但應用狀態異常',
        taobao: '淘寶',
        tencent: '騰訊',
        imageSource: '鏡像源',
        moduleManager: '模塊管理',
        module: '模塊',
        nodeOperatorHelper: '是否{0} {1} 模組？ 操作可能導致運轉環境異常，請確認後操作',
    },
    process: {
        pid: '進程ID',
        ppid: '父進程ID',
        numThreads: '線程',
        memory: '內存',
        diskRead: '磁盤讀',
        diskWrite: '磁盤寫',
        netSent: '上行',
        netRecv: '下行',
        numConnections: '連接',
        startTime: '啟動時間',
        status: '狀態',
        running: '運行中',
        sleep: '睡眠',
        stop: '停止',
        idle: '空閑',
        zombie: '僵屍進程',
        wait: '等待',
        lock: '鎖定',
        blocked: '阻塞',
        cmdLine: '啟動命令',
        basic: '基本信息',
        mem: '內存信息',
        openFiles: '文件打開',
        file: '文件',
        env: '環境變量',
        noenv: '無',
        net: '網絡連接',
        laddr: '源地址/端口',
        raddr: '目標地址/端口',
        stopProcess: '結束',
        stopProcessWarn: '是否確定結束此進程 (PID:{0})？',
        processName: '進程名稱',
    },
    tool: {
        supervisor: {
            loadStatusErr: '獲取進程狀態失敗，請檢查 supervisor 服務狀態',
            notSupport: '未檢測到 Supervisor，請參考官方文檔進行安裝',
            list: '守護進程',
            config: 'Supervisor 配置',
            primaryConfig: '主配置文件位置',
            notSupportCrl: '未檢測到 supervisorctl，請參考官方文檔進行安裝',
            user: '啟動用戶',
            command: '啟動命令',
            dir: '運行目錄',
            numprocs: '進程數量',
            initWarn:
                '初始化操作需要修改配置文件的 [include] files 參數，修改後的服務配置文件所在目錄: 1panel安裝目錄/1panel/tools/supervisord/supervisor.d/',
            operatorHelper: '將對 {0} 進行 {1} 操作，是否繼續？ ',
            uptime: '運行時長',
            notStartWarn: 'Supervisor 未啟動，請先啟動',
            serviceName: '服務名稱',
            initHelper: '尚未初始化 Supervisor ，請先初始化',
            serviceNameHelper: 'systemctl 管理的 Supervisor 服務名稱，一般為 supervisor 或 supervisord',
            restartHelper: '初始化會重啟服務，導致原有的守護進程全部關閉',
            msg: '信息',
            RUNNING: '運行中',
            STOPPED: '已停止',
            STOPPING: '停止中',
            STARTING: '啟動中',
            FATAL: '啟動失敗',
            BACKOFF: '啟動異常',
            statusCode: '狀態碼',
            manage: '管理',
        },
    },
};
export default {
    ...fit2cloudTwLocale,
    ...message,
};
