/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hcatalog.common;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public enum HCatContext {
    INSTANCE;

    private Configuration conf = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized HCatContext setConf(Configuration newConf) {
        Preconditions.checkNotNull((Object)newConf, (Object)"Required parameter 'newConf' must not be null.");
        if (this.conf == null) {
            this.conf = newConf;
            return this;
        }
        if (this.conf != newConf) {
            Configuration configuration = this.conf;
            synchronized (configuration) {
                for (Map.Entry entry : this.conf) {
                    if (!((String)entry.getKey()).matches("hcat.*") || newConf.get((String)entry.getKey()) != null) continue;
                    newConf.set((String)entry.getKey(), (String)entry.getValue());
                }
            }
            this.conf = newConf;
        }
        return this;
    }

    public Optional<Configuration> getConf() {
        return Optional.fromNullable((Object)this.conf);
    }
}

