/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	edgefsrookiov1 "github.com/rook/rook/pkg/apis/edgefs.rook.io/v1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeNFSs implements NFSInterface
type FakeNFSs struct {
	Fake *FakeEdgefsV1
	ns   string
}

var nfssResource = schema.GroupVersionResource{Group: "edgefs.rook.io", Version: "v1", Resource: "nfss"}

var nfssKind = schema.GroupVersionKind{Group: "edgefs.rook.io", Version: "v1", Kind: "NFS"}

// Get takes name of the nFS, and returns the corresponding nFS object, and an error if there is any.
func (c *FakeNFSs) Get(ctx context.Context, name string, options v1.GetOptions) (result *edgefsrookiov1.NFS, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(nfssResource, c.ns, name), &edgefsrookiov1.NFS{})

	if obj == nil {
		return nil, err
	}
	return obj.(*edgefsrookiov1.NFS), err
}

// List takes label and field selectors, and returns the list of NFSs that match those selectors.
func (c *FakeNFSs) List(ctx context.Context, opts v1.ListOptions) (result *edgefsrookiov1.NFSList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(nfssResource, nfssKind, c.ns, opts), &edgefsrookiov1.NFSList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &edgefsrookiov1.NFSList{ListMeta: obj.(*edgefsrookiov1.NFSList).ListMeta}
	for _, item := range obj.(*edgefsrookiov1.NFSList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested nFSs.
func (c *FakeNFSs) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(nfssResource, c.ns, opts))

}

// Create takes the representation of a nFS and creates it.  Returns the server's representation of the nFS, and an error, if there is any.
func (c *FakeNFSs) Create(ctx context.Context, nFS *edgefsrookiov1.NFS, opts v1.CreateOptions) (result *edgefsrookiov1.NFS, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(nfssResource, c.ns, nFS), &edgefsrookiov1.NFS{})

	if obj == nil {
		return nil, err
	}
	return obj.(*edgefsrookiov1.NFS), err
}

// Update takes the representation of a nFS and updates it. Returns the server's representation of the nFS, and an error, if there is any.
func (c *FakeNFSs) Update(ctx context.Context, nFS *edgefsrookiov1.NFS, opts v1.UpdateOptions) (result *edgefsrookiov1.NFS, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(nfssResource, c.ns, nFS), &edgefsrookiov1.NFS{})

	if obj == nil {
		return nil, err
	}
	return obj.(*edgefsrookiov1.NFS), err
}

// Delete takes name of the nFS and deletes it. Returns an error if one occurs.
func (c *FakeNFSs) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(nfssResource, c.ns, name), &edgefsrookiov1.NFS{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeNFSs) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(nfssResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &edgefsrookiov1.NFSList{})
	return err
}

// Patch applies the patch and returns the patched nFS.
func (c *FakeNFSs) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *edgefsrookiov1.NFS, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(nfssResource, c.ns, name, pt, data, subresources...), &edgefsrookiov1.NFS{})

	if obj == nil {
		return nil, err
	}
	return obj.(*edgefsrookiov1.NFS), err
}
