/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	"time"

	v1 "github.com/rook/rook/pkg/apis/edgefs.rook.io/v1"
	scheme "github.com/rook/rook/pkg/client/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// ISCSIsGetter has a method to return a ISCSIInterface.
// A group's client should implement this interface.
type ISCSIsGetter interface {
	ISCSIs(namespace string) ISCSIInterface
}

// ISCSIInterface has methods to work with ISCSI resources.
type ISCSIInterface interface {
	Create(ctx context.Context, iSCSI *v1.ISCSI, opts metav1.CreateOptions) (*v1.ISCSI, error)
	Update(ctx context.Context, iSCSI *v1.ISCSI, opts metav1.UpdateOptions) (*v1.ISCSI, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.ISCSI, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.ISCSIList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.ISCSI, err error)
	ISCSIExpansion
}

// iSCSIs implements ISCSIInterface
type iSCSIs struct {
	client rest.Interface
	ns     string
}

// newISCSIs returns a ISCSIs
func newISCSIs(c *EdgefsV1Client, namespace string) *iSCSIs {
	return &iSCSIs{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the iSCSI, and returns the corresponding iSCSI object, and an error if there is any.
func (c *iSCSIs) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.ISCSI, err error) {
	result = &v1.ISCSI{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("iscsis").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of ISCSIs that match those selectors.
func (c *iSCSIs) List(ctx context.Context, opts metav1.ListOptions) (result *v1.ISCSIList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.ISCSIList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("iscsis").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested iSCSIs.
func (c *iSCSIs) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("iscsis").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a iSCSI and creates it.  Returns the server's representation of the iSCSI, and an error, if there is any.
func (c *iSCSIs) Create(ctx context.Context, iSCSI *v1.ISCSI, opts metav1.CreateOptions) (result *v1.ISCSI, err error) {
	result = &v1.ISCSI{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("iscsis").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(iSCSI).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a iSCSI and updates it. Returns the server's representation of the iSCSI, and an error, if there is any.
func (c *iSCSIs) Update(ctx context.Context, iSCSI *v1.ISCSI, opts metav1.UpdateOptions) (result *v1.ISCSI, err error) {
	result = &v1.ISCSI{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("iscsis").
		Name(iSCSI.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(iSCSI).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the iSCSI and deletes it. Returns an error if one occurs.
func (c *iSCSIs) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("iscsis").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *iSCSIs) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("iscsis").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched iSCSI.
func (c *iSCSIs) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.ISCSI, err error) {
	result = &v1.ISCSI{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("iscsis").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
