/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	"time"

	v1 "github.com/rook/rook/pkg/apis/edgefs.rook.io/v1"
	scheme "github.com/rook/rook/pkg/client/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// ISGWsGetter has a method to return a ISGWInterface.
// A group's client should implement this interface.
type ISGWsGetter interface {
	ISGWs(namespace string) ISGWInterface
}

// ISGWInterface has methods to work with ISGW resources.
type ISGWInterface interface {
	Create(ctx context.Context, iSGW *v1.ISGW, opts metav1.CreateOptions) (*v1.ISGW, error)
	Update(ctx context.Context, iSGW *v1.ISGW, opts metav1.UpdateOptions) (*v1.ISGW, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.ISGW, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.ISGWList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.ISGW, err error)
	ISGWExpansion
}

// iSGWs implements ISGWInterface
type iSGWs struct {
	client rest.Interface
	ns     string
}

// newISGWs returns a ISGWs
func newISGWs(c *EdgefsV1Client, namespace string) *iSGWs {
	return &iSGWs{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the iSGW, and returns the corresponding iSGW object, and an error if there is any.
func (c *iSGWs) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.ISGW, err error) {
	result = &v1.ISGW{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("isgws").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of ISGWs that match those selectors.
func (c *iSGWs) List(ctx context.Context, opts metav1.ListOptions) (result *v1.ISGWList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.ISGWList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("isgws").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested iSGWs.
func (c *iSGWs) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("isgws").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a iSGW and creates it.  Returns the server's representation of the iSGW, and an error, if there is any.
func (c *iSGWs) Create(ctx context.Context, iSGW *v1.ISGW, opts metav1.CreateOptions) (result *v1.ISGW, err error) {
	result = &v1.ISGW{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("isgws").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(iSGW).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a iSGW and updates it. Returns the server's representation of the iSGW, and an error, if there is any.
func (c *iSGWs) Update(ctx context.Context, iSGW *v1.ISGW, opts metav1.UpdateOptions) (result *v1.ISGW, err error) {
	result = &v1.ISGW{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("isgws").
		Name(iSGW.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(iSGW).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the iSGW and deletes it. Returns an error if one occurs.
func (c *iSGWs) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("isgws").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *iSGWs) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("isgws").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched iSGW.
func (c *iSGWs) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.ISGW, err error) {
	result = &v1.ISGW{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("isgws").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
