/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	"time"

	v1 "github.com/rook/rook/pkg/apis/edgefs.rook.io/v1"
	scheme "github.com/rook/rook/pkg/client/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// NFSsGetter has a method to return a NFSInterface.
// A group's client should implement this interface.
type NFSsGetter interface {
	NFSs(namespace string) NFSInterface
}

// NFSInterface has methods to work with NFS resources.
type NFSInterface interface {
	Create(ctx context.Context, nFS *v1.NFS, opts metav1.CreateOptions) (*v1.NFS, error)
	Update(ctx context.Context, nFS *v1.NFS, opts metav1.UpdateOptions) (*v1.NFS, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.NFS, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.NFSList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.NFS, err error)
	NFSExpansion
}

// nFSs implements NFSInterface
type nFSs struct {
	client rest.Interface
	ns     string
}

// newNFSs returns a NFSs
func newNFSs(c *EdgefsV1Client, namespace string) *nFSs {
	return &nFSs{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the nFS, and returns the corresponding nFS object, and an error if there is any.
func (c *nFSs) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.NFS, err error) {
	result = &v1.NFS{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("nfss").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of NFSs that match those selectors.
func (c *nFSs) List(ctx context.Context, opts metav1.ListOptions) (result *v1.NFSList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.NFSList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("nfss").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested nFSs.
func (c *nFSs) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("nfss").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a nFS and creates it.  Returns the server's representation of the nFS, and an error, if there is any.
func (c *nFSs) Create(ctx context.Context, nFS *v1.NFS, opts metav1.CreateOptions) (result *v1.NFS, err error) {
	result = &v1.NFS{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("nfss").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(nFS).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a nFS and updates it. Returns the server's representation of the nFS, and an error, if there is any.
func (c *nFSs) Update(ctx context.Context, nFS *v1.NFS, opts metav1.UpdateOptions) (result *v1.NFS, err error) {
	result = &v1.NFS{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("nfss").
		Name(nFS.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(nFS).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the nFS and deletes it. Returns an error if one occurs.
func (c *nFSs) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("nfss").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *nFSs) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("nfss").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched nFS.
func (c *nFSs) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.NFS, err error) {
	result = &v1.NFS{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("nfss").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
