<p align="center">
  <a href="https://directus.io" target="_blank" rel="noopener noreferrer">
    <img src="https://user-images.githubusercontent.com/522079/43096167-3a1b1118-8e86-11e8-9fb2-7b4e3b1368bc.png" width="140" alt="Directus Logo"/>
  </a>
</p>

<p>&nbsp;</p>

<h1 align="center">
  The All-New Directus 7<br>Future-Proof Headless CMS
</h1>

<h3 align="center">
  <a href="https://directus.io">Website</a> • 
  <a href="https://docs.directus.io">Docs</a> • 
  <a href="https://docs.directus.io/api/reference.html">API Reference</a> • 
  <a href="https://docs.directus.io/app/user-guide.html">User Guide</a> • 
  <a href="https://directus.app">Demo</a> • 
  <a href="https://docs.directus.io/supporting-directus.html">Contribute</a>
</h3>

<p>&nbsp;</p>

> _The Directus 7 App has been rebuilt from the ground-up in Vue.js and decoupled from our new "versionless" API. Both can easily be customized and extended to suit your project's needs._


<p align="center">
  <img src="https://semaphoreci.com/api/v1/directus/app/branches/build/badge.svg">
</p>

<p>&nbsp;</p>

## 🐰 Introduction

Directus is an open-source suite of software for managing content in projects of any size. Instances of the [Directus API](https://github.com/directus/api) allow you to easily connect any SQL database content anywhere (websites, native apps, wearables, IoT devices, kiosks, etc) while the [Directus App](https://github.com/directus/app) allows non-technical users to intuitively manage that content. 

* **No Assumptions.** That’s our motto, and we mean it. It’s your content, your workflow, your stack, your servers, and your database – Directus stays out of the way.
* **Pure, decoupled content.** Directus stores all your data unaltered, in SQL databases designed by you. Connect to your data from anywhere everywhere.
* **Directus is a simple toolkit, not a one-size-fits-all behemoth.** Every aspect of the framework can be tailored, extended, or even bypassed if needed. Truly limitless.
* **Full internationalization.** Manage multilingual content in as many languages as your project needs. And for international teams, the Directus App itself supports translations.

<p>&nbsp;</p>

## 📖 Documentation

* [What is Directus?](https://docs.directus.io/what-is-directus.html)
* [Installing the Directus Suite](https://docs.directus.io/install.html)
* [Extending Directus](https://docs.directus.io/extensions/)
* Directus App
  * [App Docs](https://docs.directus.io/app/admin-guide/)
  * [User Guide](https://docs.directus.io/app/user-guide.html)
  * [Install the App](https://docs.directus.io/app/admin-guide/install.html)
* Directus API
  * [API Docs](https://docs.directus.io/api/admin-guide/)
  * [API Reference](https://docs.directus.io/api/reference.html)
  * [Install the API](https://docs.directus.io/api/admin-guide/install.html)
* Tutorials
  * [Tutorials](https://medium.com/directus)
  * [Videos](https://www.youtube.com/playlist?list=PLD--x9rY3ZL31stRPkA4FdGC4idIM-8-d)

<p>&nbsp;</p>

## 🤲 Help & Resources

### Open-Source Support

For help with open-source instances please post questions with the `directus` tag on [Stack Overflow](https://stackoverflow.com/questions/tagged/directus).

### Premium Support

[Premium Support](https://directus.io) is only available to Directus Cloud customers, Patreon Sponsors, and Contracted Clients.

### Reporting Bugs

If you believe you've found a bug in the Directus Core codebase, please submit new tickets to either the [App](https://github.com/directus/app/issues/new?template=Bug_report.md) or the [API](https://github.com/directus/api/issues/new?template=Bug_report.md). **For all security related issues, please chat with us directly through [directus.io](https://directus.io/).**

### Community Discussions

Join us on [Slack](https://slack.directus.io) to talk to hundreds of members of the Directus community.

### Updates & Social

Follow us on [Twitter](https://twitter.com/directus) to be the first to hear about product updates and sneak peeks.

### Feature Requests

Feature requests are managed as GitHub issues within the appropriate Directus repository. Before making a new submission, first [browse existing feature requests](https://github.com/directus/app/issues?q=is%3Aissue+is%3Aopen+sort%3Areactions-%2B1-desc+label%3Aenhancement) using the `enhancement` label. If you find a similar request, simply vote for it using the :+1: or :-1: reactions and add any additional context in the comments. If _not_, [add a new feature request](https://github.com/directus/app/issues/new?template=Feature_request.md) by completing the provided template.

### Contributing

We love pull-requests! To work on Directus you'll need to install it locally from source by following the instructions below. Submit all pull-requests to the `development` branch of our `api` and `app` repositories.

* [Setup API Development Environment](https://docs.directus.io/api/contributor-guide/install-dev.html)
* [Setup App Development Environment](https://docs.directus.io/app/contributor-guide/install-dev.html)

### Online Demos

We have two online demos available so you can easily check out Directus in action: [stable](https://directus.app) or [canary](https://next.directus.app)

<p>&nbsp;</p>

## ❤️ Supporting Directus

Directus is a GPLv3-licensed open source project with development made possible by support from our core team, contributors, and sponsors. It's not easy building premium open-source software; if you would like to help ensure Directus stays free, please consider becoming a sponsor.

* [Become a backer or sponsor through Patreon](https://www.patreon.com/directus)
* [One-time donation through PayPal](https://paypal.com/directus)
* [Other ways to help](https://docs.directus.io/supporting-directus.html)

### Sponsors

[RANGER Studio](http://rangerstudio.com), Bas Jansen

### Core Team

<table>
   <tr>
      <td>
         <a href="https://github.com/benhaynes"><img width="160px" src="https://user-images.githubusercontent.com/522079/42234532-dfa61084-7ec2-11e8-96df-23aa48c6d450.jpg"><br>
         Ben Haynes</a><br>
         <i>Project Lead</i>
      </td>
      <td>
         <a href="https://github.com/rijkvanzanten"><img width="160px" src="https://user-images.githubusercontent.com/522079/42234533-dfb6039a-7ec2-11e8-950c-04b34d47d6e4.jpg"><br>
         Rijk van Zanten</a><br>
         <i>App Lead</i>
      </td>
      <td>
         <a href="https://github.com/wellingguzman"><img width="160px" src="https://user-images.githubusercontent.com/522079/42234534-dfc56d1c-7ec2-11e8-94ca-7b422788d6cd.jpg"><br>
         Welling Guzmán</a><br>
         <i>API Lead</i>
      </td>
   </tr>
</table>

**Other Key Contributors: [coolov](https://github.com/coolov), [freen](https://github.com/freen), [jel-massih](https://github.com/jel-massih), [Lasha](https://github.com/Lasha)**

<p>&nbsp;</p>

----

<p align="center">
  Directus is released under the <a href="http://www.gnu.org/copyleft/gpl.html">GPLv3</a> license. <a href="http://rangerstudio.com">RANGER Studio LLC</a> owns all Directus trademarks and logos on behalf of our project's community. Copyright © 2006-2018, <a href="http://rangerstudio.com">RANGER Studio LLC</a>.
</p>
