# Okta Provider for OAuth 2.0 Client
[![Latest Version](https://img.shields.io/github/release/wellingguzman/oauth2-okta.svg?style=flat-square)](https://github.com/wellingguzman/oauth2-okta/releases)
[![Software License](https://img.shields.io/badge/license-MIT-brightgreen.svg?style=flat-square)](LICENSE.md)
[![Build Status](https://img.shields.io/travis/wellingguman/oauth2-okta/master.svg?style=flat-square)](https://travis-ci.org/wellingguzman/oauth2-okta)
[![Coverage Status](https://img.shields.io/scrutinizer/coverage/g/wellingguzman/oauth2-okta.svg?style=flat-square)](https://scrutinizer-ci.com/g/wellingguzman/oauth2-okta/code-structure)
[![Quality Score](https://img.shields.io/scrutinizer/g/wellingguzman/oauth2-okta.svg?style=flat-square)](https://scrutinizer-ci.com/g/wellingguzman/oauth2-okta)
[![Total Downloads](https://img.shields.io/packagist/dt/wellingguzman/oauth2-okta.svg?style=flat-square)](https://packagist.org/packages/wellingguzan/oauth2-okta)

This package provides Okta OAuth 2.0 support for the PHP League's [OAuth 2.0 Client](https://github.com/thephpleague/oauth2-client).

## Installation

To install, use composer:

```
composer require wellingguzman/oauth2-okta
```

## Usage

Usage is the same as The League's OAuth client, using `\WellingGuzman\OAuth2\Client\Provider\Okta` as the provider.

### Authorization Code Flow

```php
$provider = new WellingGuzman\OAuth2\Client\Provider\Okta([
    'baseUrl'           => '{base-url}',
    'clientId'          => '{okta-client-id}',
    'clientSecret'      => '{okta-client-secret}',
    'redirectUri'       => 'https://example.com/callback-url',
]);

if (!isset($_GET['code'])) {

    // If we don't have an authorization code then get one
    $authUrl = $provider->getAuthorizationUrl();
    $_SESSION['oauth2state'] = $provider->getState();
    header('Location: '.$authUrl);
    exit;

// Check given state against previously stored one to mitigate CSRF attack
} elseif (empty($_GET['state']) || ($_GET['state'] !== $_SESSION['oauth2state'])) {

    unset($_SESSION['oauth2state']);
    exit('Invalid state');

} else {

    // Try to get an access token (using the authorization code grant)
    $token = $provider->getAccessToken('authorization_code', [
        'code' => $_GET['code']
    ]);

    // Optional: Now you have a token you can look up a users profile data
    try {

        // We got an access token, let's now get the user's details
        $user = $provider->getResourceOwner($token);

        // Use these details to create a new profile
        printf('Hello %s!', $user->getNickname());

    } catch (Exception $e) {

        // Failed to get user details
        exit('Oh dear...');
    }

    // Use this to interact with an API on the users behalf
    echo $token->getToken();
}
```

### Managing Scopes

When creating your Okta authorization URL, you can specify the state and scopes your application may authorize.

```php
$options = [
    'state' => 'OPTIONAL_CUSTOM_CONFIGURED_STATE',
    'scope' => ['openid email profile']
];

$authorizationUrl = $provider->getAuthorizationUrl($options);
```
If neither are defined, the provider will utilize internal defaults.

At the time of authoring this documentation, the [following scopes are available](https://developer.okta.com/standards/OIDC/#scopes).

- openid
- profile
- email
- phone
- address
- groups

## Testing

``` bash
$ ./vendor/bin/phpunit
```

## Contributing

Please see [CONTRIBUTING](https://github.com/wellinguzman/oauth2-okta/blob/master/CONTRIBUTING.md) for details.

## Credits

- [Welling Guzman](https://github.com/wellingguzman)
- [All Contributors](https://github.com/wellingguzman/oauth2-okta/contributors)

## License

The MIT License (MIT). Please see [License File](https://github.com/wellingguzman/oauth2-okta/blob/master/LICENSE) for more information.
