/*
 * Copyright (C) 2007-2018 52°North Initiative for Geospatial Open Source
 * Software GmbH
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 as published
 * by the Free Software Foundation.
 *
 * If the program is linked with libraries which are licensed under one of
 * the following licenses, the combination of the program with the linked
 * library is not considered a "derivative work" of the program:
 *
 *       • Apache License, version 2.0
 *       • Apache Software License, version 1.0
 *       • GNU Lesser General Public License, version 3
 *       • Mozilla Public License, versions 1.0, 1.1 and 2.0
 *       • Common Development and Distribution License (CDDL), version 1.0
 *
 * Therefore the distribution of the program linked with libraries licensed
 * under the aforementioned licenses, is permitted by the copyright holders
 * if the distribution is compliant with both the GNU General Public
 * License version 2 and the aforementioned licenses.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 */
package org.n52.wps.io.datahandler.generator;

import java.io.IOException;
import java.io.InputStream;

import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.n52.wps.io.data.IData;
import org.n52.wps.io.data.binding.complex.GenericXMLDataBinding;

public class GenericXMLDataGenerator extends AbstractGenerator {

    public GenericXMLDataGenerator(){
        super();
        supportedIDataTypes.add(GenericXMLDataBinding.class);
    }

    @Override
    public boolean isSupportedSchema(String schema) {
        //no schema checks
        return true;
    }

    @Override
    public InputStream generateStream(IData data, String mimeType, String schema)
            throws IOException {

        if(data instanceof GenericXMLDataBinding){

            XmlObject xmlData = ((GenericXMLDataBinding)data).getPayload();

            XmlOptions xmlOptions = new XmlOptions();

            xmlOptions.setSaveNoXmlDecl();

            return xmlData.newInputStream(xmlOptions);

        }

        return XmlObject.Factory.newInstance().newInputStream();
    }

}
