/*
 * Decompiled with CFR 0.152.
 */
import com.hp.hpl.jena.rdf.model.Model;
import com.ibm.lsid.LSID;
import com.ibm.lsid.LSIDException;
import com.ibm.lsid.MetadataResponse;
import com.ibm.lsid.client.LSIDAssigner;
import com.ibm.lsid.client.LSIDAuthority;
import com.ibm.lsid.client.LSIDResolver;
import com.ibm.lsid.client.async.AsyncLSIDResolver;
import com.ibm.lsid.client.async.ResolutionListener;
import com.ibm.lsid.client.metadata.LSIDMetadata;
import com.ibm.lsid.client.metadata.rdf.jena.JenaMetadataFactory;
import com.ibm.lsid.client.metadata.rdf.jena.JenaMetadataStore;
import com.ibm.lsid.client.metadata.rdf.xslt.XSLTMetadata;
import com.ibm.lsid.wsdl.FileLocation;
import com.ibm.lsid.wsdl.LSIDDataPort;
import com.ibm.lsid.wsdl.LSIDMetadataPort;
import com.ibm.lsid.wsdl.LSIDWSDLWrapper;
import com.ibm.lsid.wsdl.SOAPLocation;
import com.ibm.lsid.wsdl.WSDLConstants;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.w3c.dom.Document;

public class LSIDTestClient
implements ResolutionListener,
WSDLConstants {
    public static final String lsid10 = "urn:lsid:ncbi.nlm.nih.gov.lsid.biopathways.org:genbank_gi:30350027";
    public static final String lsid11 = "urn:lsid:ncbi.nlm.nih.gov.lsid.biopathways.org:genbank:bm872070";
    public static final String lsid12 = "urn:lsid:ncbi.nlm.nih.gov.lsid.biopathways.org:genbank:u34074";
    public static final String lsid13 = "urn:lsid:ncbi.nlm.nih.gov.lsid.biopathways.org:genbank:l17325.1";
    public static final String lsid14 = "urn:lsid:ncbi.nlm.nih.gov.lsid.biopathways.org:genbank:x00353";
    public static final String lsid15 = "urn:lsid:ncbi.nlm.nih.gov.lsid.biopathways.org:genbank:nm_002165";
    public static final String lsid16 = "urn:lsid:ncbi.nlm.nih.gov.lsid.biopathways.org:genbank_gi:30407099";
    public static final String lsid21 = "urn:lsid:ncbi.nlm.nih.gov.lsid.biopathways.org:proteins:aah52812";
    public static final String lsid22 = "urn:lsid:ncbi.nlm.nih.gov.lsid.biopathways.org:proteins_gi:871485";
    public static final String lsid30 = "urn:lsid:ncbi.nlm.nih.gov.lsid.biopathways.org:pubmed:12441807";
    public static final String lsid40 = "urn:lsid:ncbi.nlm.nih.gov.lsid.biopathways.org:omim:601077";
    public static final String lsid41 = "urn:lsid:ncbi.nlm.nih.gov.lsid.biopathways.org:omim:605956";
    public static final String lsid42 = "urn:lsid:ncbi.nlm.nih.gov.lsid.biopathways.org:omim:601077-text";
    public static final String lsid43 = "urn:lsid:ncbi.nlm.nih.gov.lsid.biopathways.org:omim:606518";
    public static final String lsid44 = "urn:lsid:ncbi.nlm.nih.gov.lsid.biopathways.org:omim:158050";
    public static final String lsid50 = "urn:lsid:ncbi.nlm.nih.gov.lsid.biopathways.org:locuslink:3397";
    public static final String lsid51 = "urn:lsid:ncbi.nlm.nih.gov.lsid.biopathways.org:predicates:transvar";
    public static final String lsid60 = "urn:lsid:ncbi.nlm.nih.gov.lsid.biopathways.org:predicates:lsid_xref";
    public static final String lsid61 = "urn:lsid:ncbi.nlm.nih.gov.lsid.biopathways.org:predicates:locus";
    public static final String lsid62 = "urn:lsid:ncbi.nlm.nih.gov.lsid.biopathways.org:types:mrna";
    public static final String lsid70 = "urn:lsid:ensembl.org.lsid.biopathways.org:homosapiens_gene:ensg00000002016";
    public static final String lsid71 = "urn:lsid:ensembl.org.lsid.biopathways.org:homosapiens_gene:ensg00000002016-fasta";
    public static final String lsid72 = "urn:lsid:ensembl.org.lsid.biopathways.org:homosapiens_exon:ense00001155775";
    public static final String lsid73 = "urn:lsid:ensembl.org.lsid.biopathways.org:homosapiens_exon:ense00001155775-fasta";
    public static final String lsid74 = "urn:lsid:ensembl.org.lsid.biopathways.org:predicates:confidence";
    public static final String lsid75 = "urn:lsid:ensembl.org.lsid.biopathways.org:predicates:exon";
    public static final String lsid76 = "urn:lsid:ensembl.org.lsid.biopathways.org:types:gene";
    public static final String lsid77 = "urn:lsid:ensembl.org.lsid.biopathways.org:homosapiens_ref:12153";
    public static final String lsid78 = "urn:lsid:ensembl.org.lsid.biopathways.org:homosapiens_analysis:61";
    public static final String lsid79 = "urn:lsid:ensembl.org.lsid.biopathways.org:homosapiens_translation:18099";
    public static final String lsid80 = "urn:lsid:ensembl.org.lsid.biopathways.org:homosapiens_transcript:18099";
    public static final String lsid90 = "urn:lsid:genome.ucsc.edu.lsid.biopathways.org:hg13:chr2_1-1000";
    public static final String lsid91 = "urn:lsid:genome.ucsc.edu.lsid.biopathways.org:types:segment";
    public static final String lsid92 = "urn:lsid:genome.ucsc.edu.lsid.biopathways.org:formats:dasgff";
    public static final String lsid93 = "urn:lsid:genome.ucsc.edu.lsid.biopathways.org:predicates:type_reference";
    public static final String lsid100 = "urn:lsid:ebi.ac.uk.lsid.biopathways.org:swissprot-proteins:p01879";
    public static final String lsid101 = "urn:lsid:ebi.ac.uk.lsid.biopathways.org:swissprot-data:p01879-sprot";
    public static final String lsid102 = "urn:lsid:ebi.ac.uk.lsid.biopathways.org:swissprot-proteins:q9hc29";
    public static final String lsid110 = "urn:lsid:geneontology.org.lsid.biopathways.org:go.id:0003673";
    public static final String lsid111 = "urn:lsid:geneontology.org.lsid.biopathways.org:types:gene_ontology";
    public static final String lsid112 = "urn:lsid:geneontology.org.lsid.biopathways.org:go.id:0003674";
    public static final String lsid113 = "urn:lsid:geneontology.org.lsid.biopathways.org:types:molecular_function";
    public static final String lsid120 = "urn:lsid:gene.ucl.ac.uk.lsid.biopathways.org:hugo:MVP";
    public static final String lsid200 = "urn:lsid:lsid.biopathways.org:formats:fasta";
    public static final String lsid01 = "URN:lsid:PDB.org:PDB:1AFT";
    public static final String lsid02 = "urn:lsid:pdb.org:PDB:1AFT-MMCIF";
    public static final String lsid03 = "urn:lsid:pdb.org:PDB:1AFT-PDB";
    public static final String lsid04 = "urn:lsid:pdb.org:PDB:1AFT-FASTA";
    public static final String lsid999 = "urn:lsid:ncbi.nlm.nih.gov.lsid.biopathways.org:bad:object";
    public static final String lsid1000 = "urn:lsid:mygrid.org.uk:test:1";
    public static final String lsid1001 = "urn:lsid:gdb.org:GenomicSegment:GDB132938";
    private Hashtable lsids = new Hashtable();

    public static void main(String[] args) throws Exception {
        System.err.println(LSIDTestClient.testAuthority(lsid10, "soap"));
    }

    public static String testAuthority(String lsidString, String protocol) throws Exception {
        String output;
        block5: {
            LSID lsid = new LSID(lsidString);
            LSIDResolver resolver = new LSIDResolver(lsid);
            output = lsid.toString() + "\n";
            try {
                LSIDWSDLWrapper wrapper = resolver.getWSDLWrapper();
                LSIDMetadataPort port = wrapper.getMetadataPortForProtocol(protocol);
                MetadataResponse resp = resolver.getMetadata(port);
                InputStream in = resp.getMetadata();
                byte[] bytes = new byte[1024];
                int numbytes = in.read(bytes);
                int totalmeta = 0;
                while (numbytes != -1) {
                    totalmeta += numbytes;
                    numbytes = in.read(bytes);
                }
                output = output + "metadata bytes read: " + totalmeta + "\n";
                output = output + "metadata expires: " + resp.getExpires() + "\n";
                output = output + "metadata format: " + resp.getFormat() + "\n";
                in.close();
                LSIDDataPort dataport = resolver.getWSDLWrapper().getDataPortForProtocol(protocol);
                if (dataport == null) {
                    output = output + "No data \n";
                    break block5;
                }
                in = null;
                in = resolver.getData(dataport);
                bytes = new byte[1024];
                int total = 0;
                int bytesread = in.read(bytes);
                while (bytesread > -1) {
                    total += bytesread;
                    bytesread = in.read(bytes);
                }
                in.close();
                output = output + "Data Read: " + total + " bytes of data.\n";
            }
            catch (Exception e) {
                output = output + "Error: " + e.getMessage() + "\n";
                StringWriter writer = new StringWriter();
                e.printStackTrace(new PrintWriter(writer));
                output = output + writer + "\n";
            }
        }
        return output;
    }

    public static void testDataByRange(String lsidString, int start, int length, String protocol) throws Exception {
        LSID lsid = new LSID(lsidString);
        LSIDResolver resolver = new LSIDResolver(lsid);
        InputStream in = resolver.getData(start, length);
        System.err.println(in.available());
        in.close();
    }

    public static void testMetadataStore(String lsidString, String protocol) throws Exception {
        LSID lsid = new LSID(lsidString);
        LSIDResolver resolver = new LSIDResolver(lsid);
        LSIDMetadata metadata = resolver.getMetadataStore(resolver.getWSDLWrapper().getMetadataPortForProtocol(protocol));
        System.out.println("format: " + metadata.getFormat(lsid));
        System.out.println("type: " + metadata.getType(lsid));
        LSID[] instances = metadata.getInstances(lsid);
        System.out.println("Instances:");
        int i = 0;
        while (i < instances.length) {
            System.out.println("inst: " + instances[i]);
            System.out.println("fmt: " + instances[i].getFormat());
            System.out.println("abs: " + instances[i].getAbstr());
            ++i;
        }
        if (metadata instanceof JenaMetadataStore) {
            System.out.println("Using Jena");
            JenaMetadataStore store = (JenaMetadataStore)metadata;
            Model model = store.getModel();
        } else if (metadata instanceof XSLTMetadata) {
            System.out.println("Using XML");
            XSLTMetadata store = (XSLTMetadata)metadata;
            Document doc = store.getDocument();
        }
    }

    public static void testAuthorityAsync(LSID lsid) throws LSIDException {
        LSIDTestClient testAsync = new LSIDTestClient();
        AsyncLSIDResolver alr = new AsyncLSIDResolver((ResolutionListener)testAsync, lsid);
        testAsync.storeLSID(alr.getWSDLWrapper(), lsid);
        testAsync.storeLSID(alr.getMetadata(), lsid);
        testAsync.storeLSID(alr.getData(), lsid);
        alr.destroy();
    }

    public void storeLSID(Integer requestID, LSID lsid) {
        this.lsids.put(String.valueOf(requestID), lsid);
    }

    public LSID getLSID(Integer requestID) {
        return (LSID)this.lsids.get(String.valueOf(requestID));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void getDataComplete(Integer requestID, InputStream data) {
        block9: {
            byte[] bytes = new byte[1024];
            int total = 0;
            int numbytes = data.read(bytes);
            while (numbytes != -1) {
                total += numbytes;
                numbytes = data.read(bytes);
            }
            System.err.println("REQ: " + requestID + " Data Bytes Read: " + total);
            Object var7_7 = null;
            try {
                data.close();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            break block9;
            {
                catch (IOException e) {
                    e.printStackTrace();
                    Object var7_8 = null;
                    try {
                        data.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    data.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    public void getMetadataStoreComplete(Integer requestID, LSIDMetadata metadata) {
        try {
            System.err.println("REQ: " + requestID + " Metadata Type: " + metadata.getType(this.getLSID(requestID)));
        }
        catch (LSIDException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void getMetadataComplete(Integer requestID, MetadataResponse metadata) {
        block9: {
            InputStream mdata = metadata.getMetadata();
            byte[] bytes = new byte[1024];
            int total = 0;
            int numbytes = mdata.read(bytes);
            while (numbytes != -1) {
                total += numbytes;
                numbytes = mdata.read(bytes);
            }
            System.err.println("REQ: " + requestID + " Metadata Bytes Read: " + total + " Expires: " + metadata.getExpires());
            Object var8_8 = null;
            try {
                mdata.close();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            break block9;
            {
                catch (IOException e) {
                    e.printStackTrace();
                    Object var8_9 = null;
                    try {
                        mdata.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    mdata.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    public void resolveAuthorityComplete(Integer requestID, LSIDAuthority authority) {
        System.err.println("REQ: " + requestID + " Authority URL: " + authority.getUrl());
    }

    public void getWSDLWrapperComplete(Integer requestID, LSIDWSDLWrapper wrapper) {
        System.err.println("REQ: " + requestID + " WSDL Length: " + wrapper.getWSDL().length());
    }

    public void requestFailed(Integer requestID, LSIDException cause) {
        System.err.println("REQ: " + requestID + " failed");
        cause.printStackTrace();
    }

    public static void testFile(LSID lsid) throws LSIDException {
        try {
            LSIDResolver resolver = new LSIDResolver(lsid);
            FileLocation loc = new FileLocation("/lsid/java/License.txt");
            InputStream data = resolver.getData(loc);
            System.err.println(data.available());
            byte[] bytes = new byte[1024];
            int numbytes = data.read(bytes);
            while (numbytes != -1) {
                System.err.println(new String(bytes));
                numbytes = data.read(bytes);
            }
            data.close();
            InputStream mdata = resolver.getMetadata(loc, null).getMetadata();
            System.err.println(mdata.available());
            byte[] mbytes = new byte[1024];
            int mnumbytes = mdata.read(mbytes);
            while (mnumbytes != -1) {
                System.err.println(new String(mbytes));
                mnumbytes = mdata.read(mbytes);
            }
            mdata.close();
        }
        catch (IOException e) {
            throw new LSIDException(e, "error reading file stream");
        }
    }

    public static void testFANNotify(LSID lsid, LSIDAuthority foreignAuthority) throws LSIDException {
        LSIDResolver.notifyForeignAuthority(foreignAuthority, lsid, null);
    }

    public static void testFANRevoke(LSID lsid, LSIDAuthority foreignAuthority) throws LSIDException {
        LSIDResolver.revokeNotificationForeignAuthority(foreignAuthority, lsid, null);
    }

    public static void testFANLookup(LSID lsid) throws LSIDException {
        LSIDResolver resolver = new LSIDResolver(lsid);
        LSIDWSDLWrapper wrapper = resolver.getWSDLWrapper();
        String service = (String)wrapper.getServiceNames().nextElement();
        System.err.println("Getting all metadata using service: " + service);
        Enumeration portnames = wrapper.getMetadataPortNamesForService(service);
        Object metadata = null;
        while (portnames.hasMoreElements()) {
            String portname = (String)portnames.nextElement();
            LSIDMetadataPort port = wrapper.getMetadataPort(portname);
            metadata = resolver.getMetadataStore(port);
        }
        System.err.println(metadata.getClass().getName());
        LSIDAuthority[] auths = metadata.getForeignAuthorities(lsid);
        int i = 0;
        while (i < auths.length) {
            System.err.println(auths[i]);
            ++i;
        }
    }

    public static void testAggregateMetadata(LSID lsid) throws LSIDException {
        JenaMetadataFactory factory = new JenaMetadataFactory();
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("model-type", "memory");
        factory.setProperties(properties);
        JenaMetadataStore store = (JenaMetadataStore)factory.createInstance();
        store.addAllMetadata(lsid);
        Model model = store.getModel();
        model.write((OutputStream)System.out);
    }

    public static void testAssigning(String endpoint) throws LSIDException {
        LSIDAssigner assigner = new LSIDAssigner(new SOAPLocation(endpoint));
        Properties props = new Properties();
        props.put("smith", "dan");
        props.put("bh", "szekel");
        LSID lsid = assigner.assignLSID("myauth", "myns", props);
        System.err.println("assigned LSID: " + lsid);
        lsid = assigner.assignLSIDForNewRevision(lsid);
        System.err.println("revised lsid: " + lsid);
        LSID[] suggested = new LSID[]{new LSID("urn:lsid:myauth:myns:whos"), new LSID("urn:lsid:myauth:myns:on"), new LSID("urn:lsid:myauth:myns:first")};
        lsid = assigner.assignLSIDFromList(props, suggested);
        System.err.println("From list LSID: " + lsid);
        String pattern = assigner.getLSIDPattern("myauth", "myns", props);
        System.err.println("assigned Pattern: " + pattern);
        String[] suggestedStrings = new String[]{"urn:lsid:myauth:myns", "urn:lsid:myauth:dansns", "urn:lsid:myauth:bensns"};
        pattern = assigner.getLSIDPatternFromList(props, suggestedStrings);
        System.err.println("assigned Patter: " + pattern);
        String[] names = assigner.getAllowedPropertyNames();
        int i = 0;
        while (i < names.length) {
            System.err.print(names[i] + " ");
            ++i;
        }
        System.err.println();
        String[][] authns = assigner.getAuthoritiesAndNamespaces();
        int i2 = 0;
        while (i2 < authns.length) {
            System.err.println(authns[i2][0] + ":" + authns[i2][1]);
            ++i2;
        }
    }
}

