/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid.client;

import com.ibm.lsid.LSID;
import com.ibm.lsid.MalformedLSIDException;
import com.ibm.lsid.wsdl.LSIDWSDLWrapper;

public class LSIDAuthority {
    public static final String AUTHORITY_ID_PREFIX = "lsidauth:";
    private static final String AUTHORITY_PROTOCOL = "http";
    private static final String AUTHORITY_PATH = "/authority/";
    private String authority;
    private String server;
    private int port = -1;
    private String url;
    private LSIDWSDLWrapper authorityWSDL;

    public LSIDAuthority(String authstr) throws MalformedLSIDException {
        try {
            this.authority = authstr.toLowerCase();
            if (this.authority.startsWith(AUTHORITY_ID_PREFIX)) {
                this.authority = this.authority.substring(AUTHORITY_ID_PREFIX.length());
            }
        }
        catch (Exception e) {
            throw new MalformedLSIDException(e, "LSID Authority must be valid authority string, or of form: lsidauth:<validauthoritystring>");
        }
    }

    public LSIDAuthority(LSID lsid) throws MalformedLSIDException {
        this.authority = lsid.getAuthority().getAuthority();
    }

    public String getAuthority() {
        return this.authority;
    }

    public String getAuthorityID() {
        return AUTHORITY_ID_PREFIX + this.authority;
    }

    public String toString() {
        return this.authority;
    }

    public boolean equals(Object o) {
        if (!(o instanceof LSIDAuthority)) {
            return false;
        }
        LSIDAuthority auth = (LSIDAuthority)o;
        return o.toString().equals(this.toString());
    }

    public int getPort() {
        return this.port;
    }

    public String getServer() {
        return this.server;
    }

    public String getUrl() {
        if (this.url == null) {
            if (this.server != null && this.port != -1) {
                this.url = "http://" + this.getServer() + ":" + this.getPort() + AUTHORITY_PATH;
            } else {
                return null;
            }
        }
        return this.url;
    }

    void setPort(int port) {
        this.port = port;
    }

    void setServer(String server) {
        this.server = server;
    }

    void setUrl(String url) {
        this.url = url;
    }

    void setWSDL(LSIDWSDLWrapper wsdl) {
        this.authorityWSDL = wsdl;
    }

    public LSIDWSDLWrapper getWSDL() {
        return this.authorityWSDL;
    }

    public boolean isResolved() {
        return this.getUrl() != null;
    }

    static String getAuthorityEnpointURL(String server, int port) {
        return "http://" + server + ":" + port + AUTHORITY_PATH;
    }
}

