/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid.client.metadata.rdf.jena;

import com.hp.hpl.jena.rdf.arp.JenaReader;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFException;
import com.hp.hpl.jena.rdql.Query;
import com.hp.hpl.jena.rdql.QueryResults;
import com.hp.hpl.jena.rdql.QueryResultsMem;
import com.hp.hpl.jena.rdql.ResultBinding;
import com.hp.hpl.jena.rdql.Value;
import com.ibm.lsid.LSID;
import com.ibm.lsid.LSIDException;
import com.ibm.lsid.MalformedLSIDException;
import com.ibm.lsid.MetadataResponse;
import com.ibm.lsid.client.LSIDAuthority;
import com.ibm.lsid.client.LSIDResolver;
import com.ibm.lsid.client.metadata.LSIDMetadata;
import com.ibm.lsid.client.metadata.LSIDMetadataException;
import com.ibm.lsid.wsdl.LSIDMetadataPort;
import com.ibm.lsid.wsdl.LSIDWSDLWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;

public class JenaMetadataStore
implements LSIDMetadata {
    private Model model;
    private JenaReader reader = new JenaReader();

    public JenaMetadataStore(Model model) {
        this.model = model;
    }

    /*
     * Loose catch block
     */
    public void addMetadata(MetadataResponse metadata) throws LSIDMetadataException {
        block7: {
            InputStream in = null;
            in = metadata.getMetadata();
            this.reader.read(this.model, in, "");
            Object var5_3 = null;
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            break block7;
            {
                catch (RDFException e) {
                    throw new LSIDMetadataException((Exception)((Object)e), "Error loading meta data from input stream");
                }
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    public boolean addAllMetadata(LSID lsid) throws LSIDException {
        LSIDResolver resolver = new LSIDResolver(lsid);
        LSIDWSDLWrapper wsdl = resolver.getWSDLWrapper();
        Enumeration services = wsdl.getServiceNames();
        boolean aggregate = true;
        while (services.hasMoreElements()) {
            Enumeration ports = wsdl.getMetadataPortNamesForService((String)services.nextElement());
            boolean portAdded = false;
            while (ports.hasMoreElements() && !portAdded) {
                try {
                    String portName = (String)ports.nextElement();
                    LSIDMetadataPort port = wsdl.getMetadataPort(portName);
                    MetadataResponse response = resolver.getMetadata(port);
                    this.addMetadata(response);
                    portAdded = true;
                }
                catch (LSIDMetadataException e) {
                    e.printStackTrace();
                }
                catch (LSIDException e) {
                    e.printStackTrace();
                }
            }
            if (portAdded) continue;
            aggregate = false;
        }
        return aggregate;
    }

    public String getFormat(LSID lsid) throws LSIDMetadataException {
        String query = "SELECT\t?format WHERE\t(<" + lsid + ">, <dc:format>, ?format) " + "USING\tdc FOR <http://purl.org/dc/elements/1.1/> ";
        QueryResults results = Query.exec((String)query, (Model)this.model);
        if (results.hasNext()) {
            ResultBinding result = (ResultBinding)results.next();
            Value value = result.getValue("format");
            String format = value.asUnquotedString();
            lsid.setFormat(format);
            return format;
        }
        return null;
    }

    public LSID[] getInstances(LSID lsid) throws LSIDMetadataException {
        String query = "SELECT\t?instance, ?format WHERE (<" + lsid + ">, <biop:storedas>, ?instance), " + "(?instance, <dc:format>, ?format) USING " + "biop FOR <urn:lsid:lsid.biopathways.org:predicates:>, " + "dc FOR <http://purl.org/dc/elements/1.1/>";
        QueryResultsMem qrm = new QueryResultsMem(Query.exec((String)query, (Model)this.model));
        LSID[] instances = new LSID[qrm.size()];
        int i = 0;
        while (qrm.hasNext()) {
            ResultBinding result = (ResultBinding)qrm.next();
            try {
                LSID instance = new LSID(result.getValue("instance").asUnquotedString());
                instance.setFormat(result.getValue("format").asUnquotedString());
                instance.setAbstr(lsid);
                instances[i++] = instance;
            }
            catch (MalformedLSIDException e) {
                throw new LSIDMetadataException(e, "Bad LSID in getInstances");
            }
        }
        lsid.setInstances(instances);
        return instances;
    }

    public String getType(LSID lsid) throws LSIDMetadataException {
        String query = "SELECT\t?type WHERE\t(<" + lsid + ">, <rdf:type>, ?type) USING " + "rdf FOR <http://www.w3.org/1999/02/22-rdf-syntax-ns#>";
        QueryResults results = Query.exec((String)query, (Model)this.model);
        if (results.hasNext()) {
            ResultBinding result = (ResultBinding)results.next();
            Value value = result.getValue("type");
            String type = value.asUnquotedString();
            lsid.setType(type);
            return type;
        }
        return null;
    }

    public LSID getAbstract(LSID lsid) throws LSIDMetadataException {
        String query = "SELECT ?abstract WHERE (?abstract, <biop:storedas>, <" + lsid + ">) " + "USING biop FOR <urn:lsid:lsid.biopathways.org:predicates:> ";
        QueryResults results = Query.exec((String)query, (Model)this.model);
        if (results.hasNext()) {
            ResultBinding result = (ResultBinding)results.next();
            Value value = result.getValue("abstract");
            try {
                LSID abstr = new LSID(value.asUnquotedString());
                lsid.setAbstr(abstr);
                return abstr;
            }
            catch (MalformedLSIDException e) {
                throw new LSIDMetadataException(e, "bad abstract lsid");
            }
        }
        return null;
    }

    public Model getModel() {
        return this.model;
    }

    public LSIDAuthority[] getForeignAuthorities(LSID lsid) throws LSIDMetadataException {
        String query = "SELECT\t?auth WHERE\t(<" + lsid + ">, <biop:foreignauthority>, ?auth) USING " + "biop FOR <urn:lsid:lsid.biopathways.org:predicates:>";
        QueryResults results = Query.exec((String)query, (Model)this.model);
        Vector<LSIDAuthority> authsVector = new Vector<LSIDAuthority>();
        while (results.hasNext()) {
            ResultBinding result = (ResultBinding)results.next();
            Value value = result.getValue("auth");
            String auth = value.asUnquotedString();
            try {
                authsVector.add(new LSIDAuthority(auth));
            }
            catch (MalformedLSIDException e) {
                throw new LSIDMetadataException(e, "bad foreign authority in metadata");
            }
        }
        LSIDAuthority[] auths = new LSIDAuthority[authsVector.size()];
        authsVector.toArray(auths);
        return auths;
    }
}

