/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.WindowCloseListener;
import com.google.gwt.user.client.WindowResizeListener;
import java.util.Iterator;
import java.util.Vector;

public class Window {
    private static Vector closingListeners = new Vector();
    private static Vector resizeListeners = new Vector();

    public static void addWindowCloseListener(WindowCloseListener listener) {
        closingListeners.add(listener);
    }

    public static void addWindowResizeListener(WindowResizeListener listener) {
        resizeListeners.add(listener);
    }

    public static native void alert(String var0);

    public static native boolean confirm(String var0);

    public static native void enableScrolling(boolean var0);

    public static native int getClientHeight();

    public static native int getClientWidth();

    public static native String getTitle();

    public static native void open(String var0, String var1, String var2);

    public static void removeWindowCloseListener(WindowCloseListener listener) {
        closingListeners.remove(listener);
    }

    public static void removeWindowResizeListener(WindowResizeListener listener) {
        resizeListeners.remove(listener);
    }

    public static native void setMargin(String var0);

    public static native void setTitle(String var0);

    static void onClosed() {
        GWT.UncaughtExceptionHandler handler = GWT.getUncaughtExceptionHandler();
        if (handler != null) {
            Window.fireClosedAndCatch(handler);
        } else {
            Window.fireClosedImpl();
        }
    }

    static String onClosing() {
        GWT.UncaughtExceptionHandler handler = GWT.getUncaughtExceptionHandler();
        if (handler != null) {
            return Window.fireClosingAndCatch(handler);
        }
        return Window.fireClosingImpl();
    }

    static void onResize() {
        GWT.UncaughtExceptionHandler handler = GWT.getUncaughtExceptionHandler();
        if (handler != null) {
            Window.fireResizedAndCatch(handler);
        } else {
            Window.fireResizedImpl();
        }
    }

    private static void fireClosedAndCatch(GWT.UncaughtExceptionHandler handler) {
        try {
            Window.fireClosedImpl();
        }
        catch (Throwable e) {
            handler.onUncaughtException(e);
        }
    }

    private static void fireClosedImpl() {
        Iterator it = closingListeners.iterator();
        while (it.hasNext()) {
            WindowCloseListener listener = (WindowCloseListener)it.next();
            listener.onWindowClosed();
        }
    }

    private static String fireClosingAndCatch(GWT.UncaughtExceptionHandler handler) {
        try {
            return Window.fireClosingImpl();
        }
        catch (Throwable e) {
            handler.onUncaughtException(e);
            return null;
        }
    }

    private static String fireClosingImpl() {
        String ret = null;
        Iterator it = closingListeners.iterator();
        while (it.hasNext()) {
            WindowCloseListener listener = (WindowCloseListener)it.next();
            String msg = listener.onWindowClosing();
            if (ret != null) continue;
            ret = msg;
        }
        return ret;
    }

    private static void fireResizedAndCatch(GWT.UncaughtExceptionHandler handler) {
        try {
            Window.fireResizedImpl();
        }
        catch (Throwable e) {
            handler.onUncaughtException(e);
        }
    }

    private static void fireResizedImpl() {
        Iterator it = resizeListeners.iterator();
        while (it.hasNext()) {
            WindowResizeListener listener = (WindowResizeListener)it.next();
            listener.onWindowResized(Window.getClientWidth(), Window.getClientHeight());
        }
    }

    private static native void init();

    private Window() {
    }

    static {
        Window.init();
    }
}

