/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.FocusListener;
import com.google.gwt.user.client.ui.FocusListenerCollection;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.HasFocus;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.KeyboardListener;
import com.google.gwt.user.client.ui.KeyboardListenerCollection;
import com.google.gwt.user.client.ui.MouseListener;
import com.google.gwt.user.client.ui.MouseListenerCollection;
import com.google.gwt.user.client.ui.SourcesTreeEvents;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.TreeListener;
import com.google.gwt.user.client.ui.TreeListenerCollection;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class Tree
extends Widget
implements HasWidgets,
SourcesTreeEvents,
HasFocus {
    private final Set childWidgets = new HashSet();
    private TreeItem curSelection;
    private final Element focusable;
    private FocusListenerCollection focusListeners;
    private String imageBase = GWT.getModuleBaseURL();
    private KeyboardListenerCollection keyboardListeners;
    private TreeListenerCollection listeners;
    private MouseListenerCollection mouseListeners = null;
    private final TreeItem root;
    private int lastEventType;

    public Tree() {
        this.setElement(DOM.createDiv());
        DOM.setStyleAttribute(this.getElement(), "position", "relative");
        this.focusable = FocusPanel.impl.createFocusable();
        DOM.setStyleAttribute(this.focusable, "fontSize", "0");
        DOM.setStyleAttribute(this.focusable, "position", "absolute");
        DOM.setIntStyleAttribute(this.focusable, "zIndex", -1);
        DOM.appendChild(this.getElement(), this.focusable);
        this.sinkEvents(1021);
        DOM.sinkEvents(this.focusable, 0x1B80 | DOM.getEventsSunk(this.focusable));
        this.root = new TreeItem(){

            public void addItem(TreeItem item) {
                if (item.getParentItem() != null || item.getTree() != null) {
                    item.remove();
                }
                item.setTree(this.getTree());
                item.setParentItem(null);
                this.getChildren().add(item);
                DOM.setIntStyleAttribute(item.getElement(), "marginLeft", 0);
            }

            public void removeItem(TreeItem item) {
                if (!this.getChildren().contains(item)) {
                    return;
                }
                item.setTree(null);
                item.setParentItem(null);
                this.getChildren().remove(item);
            }
        };
        this.root.setTree(this);
        this.setStyleName("gwt-Tree");
    }

    public void add(Widget widget) {
        this.addItem(widget);
    }

    public void addFocusListener(FocusListener listener) {
        if (this.focusListeners == null) {
            this.focusListeners = new FocusListenerCollection();
        }
        this.focusListeners.add(listener);
    }

    public TreeItem addItem(String itemText) {
        TreeItem ret = new TreeItem(itemText);
        this.addItem(ret);
        return ret;
    }

    public void addItem(TreeItem item) {
        this.root.addItem(item);
        DOM.appendChild(this.getElement(), item.getElement());
    }

    public TreeItem addItem(Widget widget) {
        TreeItem item = this.root.addItem(widget);
        DOM.appendChild(this.getElement(), item.getElement());
        return item;
    }

    public void addKeyboardListener(KeyboardListener listener) {
        if (this.keyboardListeners == null) {
            this.keyboardListeners = new KeyboardListenerCollection();
        }
        this.keyboardListeners.add(listener);
    }

    public void addMouseListener(MouseListener listener) {
        if (this.mouseListeners == null) {
            this.mouseListeners = new MouseListenerCollection();
        }
        this.mouseListeners.add(listener);
    }

    public void addTreeListener(TreeListener listener) {
        if (this.listeners == null) {
            this.listeners = new TreeListenerCollection();
        }
        this.listeners.add(listener);
    }

    public void clear() {
        int size = this.root.getChildCount();
        for (int i = size - 1; i >= 0; --i) {
            this.root.getChild(i).remove();
        }
    }

    public void ensureSelectedItemVisible() {
        if (this.curSelection == null) {
            return;
        }
        for (TreeItem parent = this.curSelection.getParentItem(); parent != null; parent = parent.getParentItem()) {
            parent.setState(true);
        }
    }

    public String getImageBase() {
        return this.imageBase;
    }

    public TreeItem getItem(int index) {
        return this.root.getChild(index);
    }

    public int getItemCount() {
        return this.root.getChildCount();
    }

    public TreeItem getSelectedItem() {
        return this.curSelection;
    }

    public int getTabIndex() {
        return FocusPanel.impl.getTabIndex(this.focusable);
    }

    public Iterator iterator() {
        return this.getChildWidgets().iterator();
    }

    public void onBrowserEvent(Event event) {
        int eventType = DOM.eventGetType(event);
        switch (eventType) {
            case 1: {
                Element e = DOM.eventGetTarget(event);
                if (this.shouldTreeDelegateFocusToElement(e)) break;
                this.setFocus(true);
                break;
            }
            case 4: {
                if (this.mouseListeners != null) {
                    this.mouseListeners.fireMouseEvent(this, event);
                }
                this.elementClicked(this.root, DOM.eventGetTarget(event));
                break;
            }
            case 8: {
                if (this.mouseListeners == null) break;
                this.mouseListeners.fireMouseEvent(this, event);
                break;
            }
            case 64: {
                if (this.mouseListeners == null) break;
                this.mouseListeners.fireMouseEvent(this, event);
                break;
            }
            case 16: {
                if (this.mouseListeners == null) break;
                this.mouseListeners.fireMouseEvent(this, event);
                break;
            }
            case 32: {
                if (this.mouseListeners == null) break;
                this.mouseListeners.fireMouseEvent(this, event);
                break;
            }
            case 2048: {
                if (this.focusListeners == null) break;
                this.focusListeners.fireFocusEvent(this, event);
                break;
            }
            case 4096: {
                if (this.focusListeners == null) break;
                this.focusListeners.fireFocusEvent(this, event);
                break;
            }
            case 128: {
                if (this.curSelection == null) {
                    if (this.root.getChildCount() > 0) {
                        this.onSelection(this.root.getChild(0), true);
                    }
                    super.onBrowserEvent(event);
                    return;
                }
                if (this.lastEventType == 128) {
                    return;
                }
                switch (DOM.eventGetKeyCode(event)) {
                    case 38: {
                        this.moveSelectionUp(this.curSelection);
                        DOM.eventPreventDefault(event);
                        break;
                    }
                    case 40: {
                        this.moveSelectionDown(this.curSelection, true);
                        DOM.eventPreventDefault(event);
                        break;
                    }
                    case 37: {
                        if (this.curSelection.getState()) {
                            this.curSelection.setState(false);
                        }
                        DOM.eventPreventDefault(event);
                        break;
                    }
                    case 39: {
                        if (!this.curSelection.getState()) {
                            this.curSelection.setState(true);
                        }
                        DOM.eventPreventDefault(event);
                    }
                }
            }
            case 512: {
                if (eventType == 512 && DOM.eventGetKeyCode(event) == 9) {
                    Vector chain = new Vector();
                    this.collectElementChain(chain, this.getElement(), DOM.eventGetTarget(event));
                    TreeItem item = this.findItemByChain(chain, 0, this.root);
                    if (item != this.getSelectedItem()) {
                        this.setSelectedItem(item, true);
                    }
                }
            }
            case 256: {
                if (this.keyboardListeners == null) break;
                this.keyboardListeners.fireKeyboardEvent(this, event);
            }
        }
        super.onBrowserEvent(event);
        this.lastEventType = eventType;
    }

    public boolean remove(Widget w) {
        throw new UnsupportedOperationException("Widgets should never be directly removed from a tree");
    }

    public void removeFocusListener(FocusListener listener) {
        if (this.focusListeners != null) {
            this.focusListeners.remove(listener);
        }
    }

    public void removeItem(TreeItem item) {
        this.root.removeItem(item);
        DOM.removeChild(this.getElement(), item.getElement());
    }

    public void removeItems() {
        while (this.getItemCount() > 0) {
            this.removeItem(this.getItem(0));
        }
    }

    public void removeKeyboardListener(KeyboardListener listener) {
        if (this.keyboardListeners != null) {
            this.keyboardListeners.remove(listener);
        }
    }

    public void removeTreeListener(TreeListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    public void setAccessKey(char key) {
        FocusPanel.impl.setAccessKey(this.focusable, key);
    }

    public void setFocus(boolean focus) {
        if (focus) {
            FocusPanel.impl.focus(this.focusable);
        } else {
            FocusPanel.impl.blur(this.focusable);
        }
    }

    public void setImageBase(String baseUrl) {
        this.imageBase = baseUrl;
        this.root.updateStateRecursive();
    }

    public void setSelectedItem(TreeItem item) {
        this.setSelectedItem(item, true);
    }

    public void setSelectedItem(TreeItem item, boolean fireEvents) {
        if (item == null) {
            if (this.curSelection == null) {
                return;
            }
            this.curSelection.setSelected(false);
            this.curSelection = null;
            return;
        }
        this.onSelection(item, fireEvents);
    }

    public void setTabIndex(int index) {
        FocusPanel.impl.setTabIndex(this.focusable, index);
    }

    public Iterator treeItemIterator() {
        ArrayList accum = new ArrayList();
        this.root.addTreeItems(accum);
        return accum.iterator();
    }

    protected void onAttach() {
        super.onAttach();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Widget child = (Widget)it.next();
            child.onAttach();
        }
    }

    protected void onDetach() {
        super.onDetach();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Widget child = (Widget)it.next();
            child.onDetach();
        }
    }

    protected void onLoad() {
        this.root.updateStateRecursive();
    }

    void adopt(TreeItem.ContentPanel content) {
        this.getChildWidgets().add(content);
        content.treeSetParent(this);
    }

    void disown(TreeItem.ContentPanel item) {
        this.getChildWidgets().remove(item);
        item.treeSetParent(null);
    }

    void fireStateChanged(TreeItem item) {
        if (this.listeners != null) {
            this.listeners.fireItemStateChanged(item);
        }
    }

    Set getChildWidgets() {
        return this.childWidgets;
    }

    private void collectElementChain(Vector chain, Element hRoot, Element hElem) {
        if (hElem == null || DOM.compare(hElem, hRoot)) {
            return;
        }
        this.collectElementChain(chain, hRoot, DOM.getParent(hElem));
        chain.add(hElem);
    }

    private boolean elementClicked(TreeItem root, Element hElem) {
        Vector chain = new Vector();
        this.collectElementChain(chain, this.getElement(), hElem);
        TreeItem item = this.findItemByChain(chain, 0, root);
        if (item != null) {
            if (DOM.compare(item.getImageElement(), hElem)) {
                item.setState(!item.getState(), true);
                return true;
            }
            if (DOM.isOrHasChild(item.getElement(), hElem)) {
                this.onSelection(item, true);
                return true;
            }
        }
        return false;
    }

    private TreeItem findDeepestOpenChild(TreeItem item) {
        if (!item.getState()) {
            return item;
        }
        return this.findDeepestOpenChild(item.getChild(item.getChildCount() - 1));
    }

    private TreeItem findItemByChain(Vector chain, int idx, TreeItem root) {
        if (idx == chain.size()) {
            return root;
        }
        Element hCurElem = (Element)chain.get(idx);
        int n = root.getChildCount();
        for (int i = 0; i < n; ++i) {
            TreeItem child = root.getChild(i);
            if (!DOM.compare(child.getElement(), hCurElem)) continue;
            TreeItem retItem = this.findItemByChain(chain, idx + 1, root.getChild(i));
            if (retItem == null) {
                return child;
            }
            return retItem;
        }
        return this.findItemByChain(chain, idx + 1, root);
    }

    private void moveFocus(TreeItem selection) {
        HasFocus focusableWidget = selection.getFocusableWidget();
        if (focusableWidget != null) {
            focusableWidget.setFocus(true);
            DOM.scrollIntoView(((Widget)((Object)focusableWidget)).getElement());
        } else {
            Element selectedElem = selection.getContentElem();
            int containerLeft = this.getAbsoluteLeft();
            int containerTop = this.getAbsoluteTop();
            int left = DOM.getAbsoluteLeft(selectedElem) - containerLeft;
            int top = DOM.getAbsoluteTop(selectedElem) - containerTop;
            int width = DOM.getIntAttribute(selectedElem, "offsetWidth");
            int height = DOM.getIntAttribute(selectedElem, "offsetHeight");
            DOM.setIntStyleAttribute(this.focusable, "left", left);
            DOM.setIntStyleAttribute(this.focusable, "top", top);
            DOM.setIntStyleAttribute(this.focusable, "width", width);
            DOM.setIntStyleAttribute(this.focusable, "height", height);
            DOM.scrollIntoView(this.focusable);
            FocusPanel.impl.focus(this.focusable);
        }
    }

    private void moveSelectionDown(TreeItem sel, boolean dig) {
        if (sel == this.root) {
            return;
        }
        TreeItem parent = sel.getParentItem();
        if (parent == null) {
            parent = this.root;
        }
        int idx = parent.getChildIndex(sel);
        if (!dig || !sel.getState()) {
            if (idx < parent.getChildCount() - 1) {
                this.onSelection(parent.getChild(idx + 1), true);
            } else {
                this.moveSelectionDown(parent, false);
            }
        } else if (sel.getChildCount() > 0) {
            this.onSelection(sel.getChild(0), true);
        }
    }

    private void moveSelectionUp(TreeItem sel) {
        int idx;
        TreeItem parent = sel.getParentItem();
        if (parent == null) {
            parent = this.root;
        }
        if ((idx = parent.getChildIndex(sel)) > 0) {
            TreeItem sibling = parent.getChild(idx - 1);
            this.onSelection(this.findDeepestOpenChild(sibling), true);
        } else {
            this.onSelection(parent, true);
        }
    }

    private void onSelection(TreeItem item, boolean fireEvents) {
        if (item == this.root) {
            return;
        }
        if (this.curSelection != null) {
            this.curSelection.setSelected(false);
        }
        this.curSelection = item;
        if (this.curSelection != null) {
            this.moveFocus(this.curSelection);
            this.curSelection.setSelected(true);
            if (fireEvents && this.listeners != null) {
                this.listeners.fireItemSelected(this.curSelection);
            }
        }
    }

    private native boolean shouldTreeDelegateFocusToElement(Element var1);
}

