/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.dsml;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.exolab.castor.util.Messages;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.HandlerBase;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributeListImpl;

public class ImportDescriptor
extends HandlerBase
implements Serializable {
    private Hashtable _policies = new Hashtable();
    private boolean _insideRoot;

    public Enumeration listDNs() {
        return this._policies.keys();
    }

    public void addPolicy(String name, int policy) {
        this._policies.put(name, new Integer(policy));
    }

    public int getDirectPolicy(String name) {
        Integer policy = (Integer)this._policies.get(name);
        if (policy != null) {
            return policy;
        }
        return 0;
    }

    public int getPolicy(String name) {
        Integer policy = (Integer)this._policies.get(name);
        if (policy != null) {
            return policy;
        }
        DN dn = new DN(name);
        int i = 1;
        while (i < dn.size()) {
            name = dn.suffix(i);
            policy = (Integer)this._policies.get(name);
            if (policy != null) {
                return policy;
            }
            ++i;
        }
        return 0;
    }

    public void produce(DocumentHandler docHandler) throws SAXException {
        AttributeListImpl attrList = new AttributeListImpl();
        docHandler.startElement("dsml", attrList);
        attrList = new AttributeListImpl();
        docHandler.startElement("import-policies", attrList);
        Enumeration enumeration = this.listDNs();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            int policy = this.getDirectPolicy(name);
            attrList = new AttributeListImpl();
            attrList.addAttribute("dn", "ID", name);
            if ((policy & 1) != 0) {
                attrList.addAttribute("delete-empty", null, "true");
            }
            if ((policy & 2) != 0) {
                attrList.addAttribute("replace-attr", null, "true");
            }
            if ((policy & 4) != 0) {
                attrList.addAttribute("refresh-only", null, "true");
            }
            if ((policy & 0x10) != 0) {
                attrList.addAttribute("update-only", null, "true");
            }
            if ((policy & 8) != 0) {
                attrList.addAttribute("new-attr-only", null, "true");
            }
            docHandler.startElement("import-policy", attrList);
            docHandler.endElement("import-policy");
        }
        docHandler.endElement("import-policies");
        docHandler.endElement("dsml");
    }

    public void startElement(String tagName, AttributeList attr) throws SAXException {
        if (tagName.equals("dsml")) {
            if (this._insideRoot) {
                throw new SAXException(Messages.format("dsml.elementNested", "dsml"));
            }
            this._insideRoot = true;
        } else {
            if (!this._insideRoot) {
                throw new SAXException(Messages.format("dsml.expectingOpeningTag", "dsml", tagName));
            }
            if (!tagName.equals("import-policies")) {
                if (tagName.equals("import-policy")) {
                    String dn = attr.getValue("dn");
                    if (dn == null) {
                        throw new SAXException(Messages.format("dsml.missingAttribute", "import-policy", "dn"));
                    }
                    int policy = 0;
                    if ("true".equals(attr.getValue("delete-empty"))) {
                        policy |= 1;
                    }
                    if ("true".equals(attr.getValue("refresh-only"))) {
                        policy |= 4;
                    }
                    if ("true".equals(attr.getValue("replace-attr"))) {
                        policy |= 2;
                    }
                    if ("true".equals(attr.getValue("new-attr-only"))) {
                        policy |= 8;
                    }
                    if ("true".equals(attr.getValue("update-only"))) {
                        policy |= 0x10;
                    }
                    this.addPolicy(dn, policy);
                } else {
                    throw new SAXException(Messages.format("dsml.expectingOpeningTag", "import-policies", tagName));
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void endElement(String tagName) throws SAXException {
        if (tagName.equals("dsml")) {
            if (!this._insideRoot) throw new SAXException(Messages.format("dsml.closingOutsideRoot", tagName));
            this._insideRoot = false;
            return;
        } else {
            if (!this._insideRoot) {
                throw new SAXException(Messages.format("dsml.closingOutsideRoot", tagName));
            }
            if (tagName.equals("import-policies") || tagName.equals("import-policy")) return;
            throw new SAXException(Messages.format("dsml.expectingClosingTag", "import-policies", tagName));
        }
    }

    static class DN {
        private String[] _names;

        DN(String name) {
            StringTokenizer token = new StringTokenizer(name, ", ");
            this._names = new String[token.countTokens()];
            int i = 0;
            while (token.hasMoreTokens()) {
                this._names[i] = token.nextToken();
                ++i;
            }
        }

        int size() {
            return this._names.length;
        }

        String suffix(int index) {
            StringBuffer name = new StringBuffer(this._names[index]);
            ++index;
            while (index < this._names.length) {
                name.append(',').append(this._names[index]);
                ++index;
            }
            return name.toString();
        }
    }

    static class Names {
        Names() {
        }

        static class Attribute {
            public static final String DN = "dn";
            public static final String DeleteEmpty = "delete-empty";
            public static final String ReplaceAttr = "replace-attr";
            public static final String RefreshOnly = "refresh-only";
            public static final String UpdateOnly = "update-only";
            public static final String NewAttrOnly = "new-attr-only";

            Attribute() {
            }
        }

        static class Element {
            public static final String Policies = "import-policies";
            public static final String Policy = "import-policy";

            Element() {
            }
        }
    }

    public static class Policy {
        public static final int DeleteEmpty = 1;
        public static final int ReplaceAttr = 2;
        public static final int RefreshOnly = 4;
        public static final int NewAttrOnly = 8;
        public static final int UpdateOnly = 16;
        public static final int DefaultPolicy = 0;
    }
}

