/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.types;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.exolab.castor.types.GMonthDay;
import org.exolab.castor.types.OperationNotSupportedException;

public class GMonth
extends GMonthDay {
    private static final String MONTH_FORMAT = "--MM--";
    private static final String BAD_GMONTH = "Bad gMonth format: ";

    public GMonth() {
    }

    public GMonth(short month) {
        this.setMonth(month);
    }

    public GMonth(int month) {
        this.setMonth((short)month);
    }

    public GMonth(String gmonth) throws ParseException {
        this();
        GMonth.parseGMonthInternal(gmonth, this);
    }

    public Date toDate() {
        Date date = null;
        SimpleDateFormat df = new SimpleDateFormat(MONTH_FORMAT);
        if (this.isUTC()) {
            SimpleTimeZone timeZone = new SimpleTimeZone(0, "UTC");
            int offset = 0;
            offset = (this.getZoneMinute() + this.getZoneHour() * 60) * 60 * 1000;
            offset = this.isZoneNegative() ? -offset : offset;
            timeZone.setRawOffset(offset);
            timeZone.setID(TimeZone.getAvailableIDs(offset)[0]);
            df.setTimeZone(timeZone);
        }
        try {
            date = df.parse(this.toString());
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
        return date;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append('-');
        result.append('-');
        result.append(this.getMonth());
        if (result.length() == 3) {
            result.insert(2, 0);
        }
        result.append('-');
        result.append('-');
        if (this.isUTC()) {
            if (this.getZoneHour() == 0 && this.getZoneMinute() == 0) {
                result.append('Z');
            } else {
                StringBuffer timeZone = new StringBuffer();
                if (this.isZoneNegative()) {
                    timeZone.append('-');
                } else {
                    timeZone.append('+');
                }
                if (this.getZoneHour() / 10 == 0) {
                    timeZone.append(0);
                }
                timeZone.append(this.getZoneHour());
                timeZone.append(':');
                if (this.getZoneMinute() / 10 == 0) {
                    timeZone.append(0);
                }
                timeZone.append(this.getZoneMinute());
                result.append(timeZone.toString());
                Object var2_2 = null;
            }
        }
        return result.toString();
    }

    public static Object parse(String str) throws ParseException {
        return GMonth.parseGMonth(str);
    }

    public static GMonth parseGMonth(String str) throws ParseException {
        GMonth result = new GMonth();
        return GMonth.parseGMonthInternal(str, result);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static GMonth parseGMonthInternal(String str, GMonth result) throws ParseException {
        if (str == null) {
            throw new IllegalArgumentException("The string to be parsed must not be null.");
        }
        if (result == null) {
            result = new GMonth();
        }
        char[] chars = str.toCharArray();
        int idx = 0;
        boolean hasNumber = false;
        boolean has2Digits = false;
        int number = -1;
        int number2 = 0;
        int flags = 63;
        while (idx < chars.length) {
            char ch = chars[idx++];
            switch (ch) {
                case '-': {
                    if (flags == 63 && number == -1) {
                        flags = 31;
                    } else if (flags == 31 && number == -1) {
                        flags = 15;
                    } else if (flags == 15) {
                        if (!has2Digits) throw new ParseException(BAD_GMONTH + str + "\nThe month field must have 2 digits.", idx);
                        result.setMonth((short)number);
                        flags = 7;
                        number = -1;
                    } else if (flags == 7 && number == -1) {
                        flags = 3;
                    } else {
                        if (flags != 3 || number != -1) throw new ParseException(BAD_GMONTH + str + "\nA gMonth must follow the pattern --MM--(Z|((+|-)hh:mm)).", idx);
                        result.setUTC();
                        result.setZoneNegative(true);
                        flags = 1;
                    }
                    hasNumber = false;
                    has2Digits = false;
                    break;
                }
                case 'Z': {
                    if (flags != 3) {
                        throw new ParseException(BAD_GMONTH + str + "\n'Z' " + "is wrongly placed.", idx);
                    }
                    result.setUTC();
                    break;
                }
                case '+': {
                    if (flags != 3) {
                        throw new ParseException(BAD_GMONTH + str + "\n'+' " + "is wrongly placed.", idx);
                    }
                    result.setUTC();
                    flags = 1;
                    hasNumber = false;
                    has2Digits = false;
                    break;
                }
                case ':': {
                    if (flags != 1) {
                        throw new ParseException(BAD_GMONTH + str + "\n':' " + "is wrongly placed.", idx);
                    }
                    number2 = number;
                    number = -1;
                    flags = 0;
                    hasNumber = false;
                    has2Digits = false;
                    break;
                }
                default: {
                    if ('0' > ch || ch > '9') throw new ParseException(str + ": Invalid character: " + ch, idx);
                    if (hasNumber) {
                        number = (short)(number * 10 + (ch - 48));
                        has2Digits = true;
                        break;
                    }
                    hasNumber = true;
                    number = (short)(ch - 48);
                    break;
                }
            }
        }
        if (flags != 3 && flags != 0) {
            throw new ParseException(BAD_GMONTH + str + "\nA gMonth must follow the pattern --MM--(Z|((+|-)hh:mm)).", idx);
        }
        if (flags != 0) return result;
        if (number == -1) throw new ParseException(str + "\n In a time zone, the minute field must always be present.", idx);
        result.setZone((short)number2, (short)number);
        return result;
    }

    public short getDay() {
        String err = "GMonth: couldn't access to the Day field.";
        throw new OperationNotSupportedException(err);
    }

    public void setDay(short day) {
        String err = "GMonth: couldn't access to the Day field.";
        throw new OperationNotSupportedException(err);
    }
}

