/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema;

import java.util.Enumeration;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.AttributeGroupDecl;
import org.exolab.castor.xml.schema.AttributeGroupReference;
import org.exolab.castor.xml.schema.BlockList;
import org.exolab.castor.xml.schema.ContentModelGroup;
import org.exolab.castor.xml.schema.ContentModelGroupImpl;
import org.exolab.castor.xml.schema.ContentType;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.FinalList;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.ModelGroup;
import org.exolab.castor.xml.schema.Particle;
import org.exolab.castor.xml.schema.Referable;
import org.exolab.castor.xml.schema.Resolver;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.schema.SimpleContent;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.Structure;
import org.exolab.castor.xml.schema.Wildcard;
import org.exolab.castor.xml.schema.XMLType;

public class ComplexType
extends XMLType
implements ContentModelGroup,
Referable {
    private boolean _abstract = false;
    private Wildcard _anyAttribute = null;
    private AttributeGroupDecl _attributes = null;
    private String _baseType = null;
    private BlockList _block = null;
    private boolean _complexContent = false;
    private ContentType _content = ContentType.elemOnly;
    private ContentModelGroup _contentModel = null;
    private FinalList _final = null;
    private Structure _parent = null;
    private boolean _restricted = false;
    private boolean _simpleContent = false;

    public ComplexType(Schema schema) {
        this(schema, null);
    }

    public ComplexType(Schema schema, String name) {
        if (schema == null) {
            String err = XMLType.NULL_ARGUMENT + "; 'schema' must not be null.";
            throw new IllegalArgumentException(err);
        }
        this.setSchema(schema);
        this.setName(name);
        this._attributes = new AttributeGroupDecl(schema);
        this._contentModel = new ContentModelGroupImpl();
    }

    public void addAttributeDecl(AttributeDecl attrDecl) throws SchemaException {
        this._attributes.addAttribute(attrDecl);
        attrDecl.setParent(this);
    }

    public void removeAttributeDecl(AttributeDecl attrDecl) {
        this._attributes.removeAttribute(attrDecl);
    }

    public void addAttributeGroupReference(AttributeGroupReference attrGroupRef) {
        this._attributes.addReference(attrGroupRef);
    }

    public void removeAttributeGroupReference(AttributeGroupReference attrGroupRef) {
        this._attributes.removeReference(attrGroupRef);
    }

    public AttributeDecl createAttributeDecl(String name) {
        return new AttributeDecl(this.getSchema(), name);
    }

    public Wildcard getAnyAttribute() {
        return this._anyAttribute;
    }

    public AttributeDecl getAttributeDecl(String name) {
        return this._attributes.getAttribute(name);
    }

    public Enumeration getAttributeDecls() {
        return this._attributes.getAttributes();
    }

    public Enumeration getLocalAttributeDecls() {
        return this._attributes.getLocalAttributes();
    }

    public Enumeration getAttributeGroupReferences() {
        return this._attributes.getLocalAttributeGroupReferences();
    }

    public XMLType getBaseType() {
        if (this._baseType != null && super.getBaseType() == null) {
            XMLType baseType = this.getSchema().getType(this._baseType);
            this.setBaseType(baseType);
        }
        return super.getBaseType();
    }

    public BlockList getBlock() {
        return this._block;
    }

    public ContentType getContentType() {
        return this._content;
    }

    public FinalList getFinal() {
        return this._final;
    }

    public Structure getParent() {
        return this._parent;
    }

    public String getReferenceId() {
        return "complexType:" + this.getName();
    }

    public boolean hasAny() {
        boolean result = false;
        Enumeration enumeration = this._contentModel.enumerate();
        while (enumeration.hasMoreElements() && !result) {
            Structure struct = (Structure)enumeration.nextElement();
            switch (struct.getStructureType()) {
                case 8: {
                    break;
                }
                case 10: 
                case 16: {
                    result = ((Group)struct).hasAny();
                    break;
                }
                case 24: {
                    result = true;
                    break;
                }
            }
        }
        return result;
    }

    public boolean isAbstract() {
        return this._abstract;
    }

    public boolean isTopLevel() {
        if (this.getName() == null) {
            return false;
        }
        if (this.getSchema() == null) {
            return false;
        }
        return this.getSchema().getComplexType(this.getName()) == this;
    }

    public boolean isComplexContent() {
        return this._complexContent;
    }

    public boolean isSimpleContent() {
        return this._simpleContent;
    }

    public boolean isRestricted() {
        return this._restricted;
    }

    public void setAbstract(boolean isAbstract) {
        this._abstract = isAbstract;
    }

    public void setAnyAttribute(Wildcard wildcard) throws SchemaException {
        if (wildcard != null) {
            if (this._anyAttribute != null) {
                String err = "<anyAttribute> already set in this complexType: " + this.getName();
                throw new SchemaException(err);
            }
            if (!wildcard.isAttributeWildcard()) {
                String err = "In complexType, " + this.getName() + "the wildcard must be an <anyAttribute>";
                throw new SchemaException(err);
            }
        }
        this._anyAttribute = wildcard;
    }

    public boolean removeWildcard(Wildcard wildcard) {
        if (wildcard == null) {
            return false;
        }
        if (wildcard.equals(this._anyAttribute)) {
            this._anyAttribute = null;
            return true;
        }
        return false;
    }

    public void addWildcard(Wildcard wildcard) throws SchemaException {
        this.setAnyAttribute(wildcard);
    }

    public void setBase(String base) {
        this._baseType = base;
    }

    public void setBaseType(XMLType baseType) {
        super.setBaseType(baseType);
        if (baseType != null) {
            ComplexType complexType;
            if (baseType.isSimpleType()) {
                this._simpleContent = true;
                this._content = new SimpleContent((SimpleType)baseType);
            } else if (baseType.isComplexType() && (complexType = (ComplexType)baseType).isSimpleContent()) {
                this._simpleContent = true;
                this._content = ((SimpleContent)complexType.getContentType()).copy();
            }
        }
    }

    public void setBlock(BlockList block) {
        if (block != null && block.hasSubstitution()) {
            String err = "'substitution' is an illegal value of the 'block' attribute for a complexType definition.";
            throw new IllegalArgumentException(err);
        }
        this._block = block;
    }

    public void setBlock(String block) {
        if (block == null) {
            this._block = null;
        } else {
            this.setBlock(new BlockList(block));
        }
    }

    public void setComplexContent(boolean complexContent) {
        this._complexContent = complexContent;
    }

    public void setContentType(ContentType contentType) {
        this._content = contentType;
    }

    public void setFinal(FinalList finalList) {
        this._final = finalList;
    }

    public void setFinal(String finalValue) {
        this._final = finalValue == null ? null : new FinalList(finalValue);
    }

    public void setSimpleContent(boolean simpleContent) {
        this._simpleContent = simpleContent;
    }

    public void setRestriction(boolean restricted) {
        this._restricted = restricted;
    }

    public void useResolver(Resolver resolver) {
    }

    public void addElementDecl(ElementDecl elementDecl) throws SchemaException {
        this._contentModel.addElementDecl(elementDecl);
        elementDecl.setParent(this);
    }

    public boolean removeElementDecl(ElementDecl element) {
        return this._contentModel.removeElementDecl(element);
    }

    public void addGroup(Group group) throws SchemaException {
        this._contentModel.addGroup(group);
        group.setParent(this);
    }

    public boolean removeGroup(Group group) {
        boolean result = this._contentModel.removeGroup(group);
        group.setParent(null);
        return result;
    }

    public void addGroup(ModelGroup group) throws SchemaException {
        this._contentModel.addGroup(group);
        group.setParent(this);
    }

    public boolean removeGroup(ModelGroup group) {
        boolean result = this._contentModel.removeGroup(group);
        group.setParent(null);
        return result;
    }

    public Enumeration enumerate() {
        return this._contentModel.enumerate();
    }

    public ElementDecl getElementDecl(String name) {
        return this._contentModel.getElementDecl(name);
    }

    public int getMaxOccurs() {
        Particle particle;
        if (this._contentModel.getParticleCount() > 0 && (particle = this._contentModel.getParticle(0)) instanceof ContentModelGroup) {
            return particle.getMaxOccurs();
        }
        return this._contentModel.getMaxOccurs();
    }

    public int getMinOccurs() {
        Particle particle;
        if (this._contentModel.getParticleCount() > 0 && (particle = this._contentModel.getParticle(0)) instanceof ContentModelGroup) {
            return particle.getMinOccurs();
        }
        return this._contentModel.getMinOccurs();
    }

    public Particle getParticle(int index) {
        return this._contentModel.getParticle(index);
    }

    public int getParticleCount() {
        return this._contentModel.getParticleCount();
    }

    public short getStructureType() {
        return 6;
    }

    public void validate() throws ValidationException {
        if (this._parent != null && this._parent.getStructureType() != 19 && this.getName() != null) {
            String err = "Only top-level complexTypes can be named.";
            err = err + this.getName() + "is not a valid complexType.";
            throw new ValidationException(err);
        }
        this._attributes.validate();
        Enumeration enumeration = this._contentModel.enumerate();
        while (enumeration.hasMoreElements()) {
            ((Structure)enumeration.nextElement()).validate();
        }
        XMLType type = this.getBaseType();
        if (type == null && this._baseType != null) {
            String error = "The base type '" + this._baseType + "' was not found.";
            throw new ValidationException(error);
        }
        if (type != null) {
            if (type.getStructureType() == 21) {
                if (this._restricted) {
                    String name = this.getName();
                    if (name == null) {
                        name = "anonymous-complexType-for-element: ";
                        if (this._parent != null) {
                            name = this._parent.getStructureType() == 8 ? name + ((ElementDecl)this._parent).getName() : name + this._parent.toString();
                        }
                    }
                    String err = "complexType: " + name;
                    err = err + "; A complex type cannot be a restriction of a simpleType:";
                    err = err + type.getName();
                    throw new ValidationException(err);
                }
            } else if (type.getStructureType() == 6 && this._simpleContent && ((ComplexType)type).getContentType().getType() != 4) {
                String name = this.getName();
                if (name == null) {
                    name = "anonymous-complexType-for-element: ";
                    if (this._parent != null) {
                        name = this._parent.getStructureType() == 8 ? name + ((ElementDecl)this._parent).getName() : name + this._parent.toString();
                    }
                }
                String err = "complexType: " + name;
                err = err + "; When a complexType is a restriction of simpleContent the base type must be a complexType whose base is also simpleContent.";
                throw new ValidationException(err);
            }
        }
    }

    protected void setParent(Structure parent) {
        if (parent != null) {
            switch (parent.getStructureType()) {
                case 8: 
                case 19: {
                    break;
                }
                default: {
                    String error = "Invalid parent for ComplexType";
                    throw new IllegalArgumentException(error);
                }
            }
        }
        this._parent = parent;
    }
}

