/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.commandline;

import java.io.File;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.SVNStatusUtils;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineException;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineStatusFromXml;

abstract class CmdLineStatusPart {
    protected SVNStatusKind textStatus;
    protected SVNStatusKind propStatus;

    protected CmdLineStatusPart(SVNStatusKind sVNStatusKind, SVNStatusKind sVNStatusKind2) {
        this.textStatus = sVNStatusKind;
        this.propStatus = sVNStatusKind2;
    }

    public boolean isManaged() {
        return SVNStatusUtils.isManaged(this.textStatus);
    }

    public abstract boolean isCopied();

    public boolean hasRemote() {
        return this.isManaged() && this.getTextStatus() != SVNStatusKind.ADDED;
    }

    public SVNStatusKind getTextStatus() {
        return this.textStatus;
    }

    public SVNStatusKind getPropStatus() {
        return this.propStatus;
    }

    public abstract SVNStatusKind getRepositoryTextStatus();

    public abstract SVNStatusKind getRepositoryPropStatus();

    public abstract File getFile();

    public abstract String getPath();

    static class CmdLineStatusPartFromXml
    extends CmdLineStatusPart {
        private CmdLineStatusFromXml status;

        private CmdLineStatusPartFromXml(CmdLineStatusFromXml cmdLineStatusFromXml) {
            super(cmdLineStatusFromXml.getTextStatus(), cmdLineStatusFromXml.getPropStatus());
            this.status = cmdLineStatusFromXml;
        }

        public static CmdLineStatusPartFromXml[] createStatusParts(byte[] byArray) throws CmdLineException {
            CmdLineStatusFromXml[] cmdLineStatusFromXmlArray = CmdLineStatusFromXml.createStatuses(byArray);
            CmdLineStatusPartFromXml[] cmdLineStatusPartFromXmlArray = new CmdLineStatusPartFromXml[cmdLineStatusFromXmlArray.length];
            for (int i = 0; i < cmdLineStatusFromXmlArray.length; ++i) {
                cmdLineStatusPartFromXmlArray[i] = new CmdLineStatusPartFromXml(cmdLineStatusFromXmlArray[i]);
            }
            return cmdLineStatusPartFromXmlArray;
        }

        public File getFile() {
            return this.status.getFile();
        }

        public boolean isCopied() {
            return this.status.isCopied();
        }

        public SVNStatusKind getRepositoryTextStatus() {
            return this.status.getRepositoryTextStatus();
        }

        public SVNStatusKind getRepositoryPropStatus() {
            return this.status.getRepositoryPropStatus();
        }

        public String getPath() {
            return this.status.getPath();
        }
    }

    static class CmdLineStatusPartFromStdout
    extends CmdLineStatusPart {
        public static final int STATUS_FILE_WIDTH = 40;
        protected String path;
        protected File file;
        protected char history;

        CmdLineStatusPartFromStdout(String string) {
            super(CmdLineStatusPartFromStdout.getTextStatus(string.charAt(0)), CmdLineStatusPartFromStdout.getPropStatus(string.charAt(1)));
            this.history = string.charAt(3);
            this.path = string.substring(40).trim();
            this.file = new File(this.path);
        }

        public boolean isCopied() {
            return this.history == '+';
        }

        private static SVNStatusKind getTextStatus(char c) {
            switch (c) {
                case ' ': {
                    return SVNStatusKind.NORMAL;
                }
                case 'A': {
                    return SVNStatusKind.ADDED;
                }
                case '!': {
                    return SVNStatusKind.MISSING;
                }
                case 'D': {
                    return SVNStatusKind.DELETED;
                }
                case 'R': {
                    return SVNStatusKind.REPLACED;
                }
                case 'M': {
                    return SVNStatusKind.MODIFIED;
                }
                case 'G': {
                    return SVNStatusKind.MERGED;
                }
                case 'C': {
                    return SVNStatusKind.CONFLICTED;
                }
                case '~': {
                    return SVNStatusKind.OBSTRUCTED;
                }
                case 'I': {
                    return SVNStatusKind.IGNORED;
                }
                case 'X': {
                    return SVNStatusKind.EXTERNAL;
                }
                case '?': {
                    return SVNStatusKind.UNVERSIONED;
                }
                case 'L': {
                    return SVNStatusKind.LOCKED;
                }
            }
            return SVNStatusKind.NONE;
        }

        private static SVNStatusKind getPropStatus(char c) {
            switch (c) {
                case ' ': {
                    return SVNStatusKind.NONE;
                }
                case 'C': {
                    return SVNStatusKind.CONFLICTED;
                }
                case 'M': {
                    return SVNStatusKind.MODIFIED;
                }
            }
            return SVNStatusKind.NORMAL;
        }

        public File getFile() {
            return this.file.getAbsoluteFile();
        }

        public String getPath() {
            return this.path;
        }

        public SVNStatusKind getRepositoryTextStatus() {
            return null;
        }

        public SVNStatusKind getRepositoryPropStatus() {
            return null;
        }
    }
}

