/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.xbill.DNS.Name;
import org.xbill.DNS.TextParseException;

public class FindServer {
    private static String[] servers = null;
    private static Name[] searchlist = null;

    private FindServer() {
    }

    private static void addServer(String server, List list) {
        if (list.contains(server)) {
            return;
        }
        list.add(server);
    }

    private static void addSearch(String search, List list) {
        Name name;
        try {
            name = Name.fromString(search, Name.root);
        }
        catch (TextParseException e) {
            return;
        }
        if (list.contains(name)) {
            return;
        }
        list.add(name);
    }

    private static void findProperty() {
        StringTokenizer st;
        ArrayList l = new ArrayList(0);
        String prop = System.getProperty("dns.server");
        if (prop != null) {
            st = new StringTokenizer(prop, ",");
            while (st.hasMoreTokens()) {
                FindServer.addServer(st.nextToken(), l);
            }
            if (l.size() > 0) {
                servers = l.toArray(new String[l.size()]);
            }
        }
        l.clear();
        prop = System.getProperty("dns.search");
        if (prop != null) {
            st = new StringTokenizer(prop, ",");
            while (st.hasMoreTokens()) {
                FindServer.addSearch(st.nextToken(), l);
            }
            if (l.size() > 0) {
                searchlist = l.toArray(new Name[l.size()]);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void findResolvConf(String file) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            return;
        }
        InputStreamReader isr = new InputStreamReader(in);
        BufferedReader br = new BufferedReader(isr);
        ArrayList lserver = new ArrayList(0);
        ArrayList lsearch = new ArrayList(0);
        try {
            String line;
            while ((line = br.readLine()) != null) {
                StringTokenizer st;
                void var6_7;
                if (var6_7.startsWith("nameserver")) {
                    st = new StringTokenizer((String)var6_7);
                    st.nextToken();
                    FindServer.addServer(st.nextToken(), lserver);
                    continue;
                }
                if (var6_7.startsWith("domain")) {
                    st = new StringTokenizer((String)var6_7);
                    st.nextToken();
                    if (!st.hasMoreTokens()) continue;
                    FindServer.addSearch(st.nextToken(), lsearch);
                    continue;
                }
                if (!var6_7.startsWith("search")) continue;
                st = new StringTokenizer((String)var6_7);
                st.nextToken();
                while (st.hasMoreTokens()) {
                    FindServer.addSearch(st.nextToken(), lsearch);
                }
            }
            br.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (servers == null && lserver.size() > 0) {
            servers = lserver.toArray(new String[lserver.size()]);
        }
        if (searchlist == null && lsearch.size() > 0) {
            searchlist = lsearch.toArray(new Name[lsearch.size()]);
        }
    }

    private static void findUnix() {
        FindServer.findResolvConf("/etc/resolv.conf");
    }

    private static void findNetware() {
        FindServer.findResolvConf("sys:/etc/resolv.cfg");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void findWin(InputStream in) {
        block17: {
            BufferedReader br;
            block16: {
                br = new BufferedReader(new InputStreamReader(in));
                ArrayList lserver = new ArrayList();
                String line = null;
                boolean readingServers = false;
                while ((line = br.readLine()) != null) {
                    StringTokenizer st = new StringTokenizer(line);
                    if (!st.hasMoreTokens()) {
                        readingServers = false;
                        continue;
                    }
                    String s = st.nextToken();
                    if (line.indexOf(":") != -1) {
                        readingServers = false;
                    }
                    if (line.indexOf("Host Name") != -1) {
                        Name name;
                        while (st.hasMoreTokens()) {
                            s = st.nextToken();
                        }
                        try {
                            name = Name.fromString(s, null);
                        }
                        catch (TextParseException e) {
                            continue;
                        }
                        if (name.labels() == 1) continue;
                        name = Name.concatenate(new Name(name, 1), Name.root);
                        if (searchlist != null) continue;
                        searchlist = new Name[]{name};
                        continue;
                    }
                    if (!readingServers && line.indexOf("DNS Servers") == -1) continue;
                    while (st.hasMoreTokens()) {
                        s = st.nextToken();
                    }
                    if (s.equals(":")) continue;
                    FindServer.addServer(s, lserver);
                    readingServers = true;
                }
                if (servers != null || lserver.size() <= 0) break block16;
                servers = lserver.toArray(new String[lserver.size()]);
            }
            Object var10_10 = null;
            try {
                br.close();
            }
            catch (IOException e2) {}
            break block17;
            {
                catch (IOException e) {
                    Object var10_11 = null;
                    try {
                        br.close();
                    }
                    catch (IOException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                try {
                    br.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private static void find95() {
        String s = "winipcfg.out";
        try {
            Process p = Runtime.getRuntime().exec("winipcfg /all /batch " + s);
            p.waitFor();
            File f = new File(s);
            FindServer.findWin(new FileInputStream(f));
            new File(s).delete();
        }
        catch (Exception e) {
            return;
        }
    }

    private static void findNT() {
        try {
            Process p = Runtime.getRuntime().exec("ipconfig /all");
            FindServer.findWin(p.getInputStream());
            p.destroy();
        }
        catch (Exception e) {
            return;
        }
    }

    public static String[] servers() {
        return servers;
    }

    public static String server() {
        if (servers == null) {
            return null;
        }
        return servers[0];
    }

    public static Name[] searchPath() {
        return searchlist;
    }

    static {
        FindServer.findProperty();
        if (servers == null || searchlist == null) {
            String OS = System.getProperty("os.name");
            if (OS.indexOf("Windows") != -1) {
                if (OS.indexOf("NT") != -1 || OS.indexOf("2000") != -1 || OS.indexOf("XP") != -1) {
                    FindServer.findNT();
                } else {
                    FindServer.find95();
                }
            } else if (OS.indexOf("NetWare") != -1) {
                FindServer.findNetware();
            } else {
                FindServer.findUnix();
            }
        }
    }
}

