/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.Random;
import org.xbill.DNS.Flags;
import org.xbill.DNS.Opcode;
import org.xbill.DNS.Rcode;
import org.xbill.DNS.Section;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;

public class Header {
    private int id;
    private boolean[] flags;
    private short rcode;
    private byte opcode;
    private int[] counts = new int[4];
    private static Random random = new Random();
    public static final int LENGTH = 12;

    public Header(int id) {
        this.flags = new boolean[16];
        this.id = id;
    }

    public Header() {
        this(random.nextInt(65535));
    }

    Header(DataByteInputStream in) throws IOException {
        this(in.readUnsignedShort());
        this.readFlags(in);
        int i = 0;
        while (i < this.counts.length) {
            this.counts[i] = in.readUnsignedShort();
            ++i;
        }
    }

    public Header(byte[] b) throws IOException {
        this(new DataByteInputStream(b));
    }

    void toWire(DataByteOutputStream out) {
        out.writeShort(this.getID());
        this.writeFlags(out);
        int i = 0;
        while (i < this.counts.length) {
            out.writeShort((short)this.counts[i]);
            ++i;
        }
    }

    public byte[] toWire() {
        DataByteOutputStream out = new DataByteOutputStream();
        this.toWire(out);
        return out.toByteArray();
    }

    public void setFlag(int bit) {
        this.flags[bit] = true;
    }

    public void unsetFlag(int bit) {
        this.flags[bit] = false;
    }

    public boolean getFlag(int bit) {
        return this.flags[bit];
    }

    boolean[] getFlags() {
        return this.flags;
    }

    public int getID() {
        return this.id & 0xFFFF;
    }

    public void setID(int id) {
        this.id = id;
    }

    static short randomID() {
        return (short)random.nextInt(65535);
    }

    public void setRcode(short value) {
        this.rcode = value;
    }

    public short getRcode() {
        return this.rcode;
    }

    public void setOpcode(byte value) {
        this.opcode = value;
    }

    public byte getOpcode() {
        return this.opcode;
    }

    void setCount(int field, int value) {
        this.counts[field] = value;
    }

    void incCount(int field) {
        int n = field;
        this.counts[n] = this.counts[n] + 1;
    }

    void decCount(int field) {
        int n = field;
        this.counts[n] = this.counts[n] - 1;
    }

    public int getCount(int field) {
        return this.counts[field];
    }

    private void writeFlags(DataByteOutputStream out) {
        int flags1 = 0;
        short flags2 = 0;
        int i = 0;
        while (i < 8) {
            if (this.flags[i]) {
                flags1 = (short)(flags1 | 1 << 7 - i);
            }
            if (this.flags[i + 8]) {
                flags2 = (short)(flags2 | 1 << 7 - i);
            }
            ++i;
        }
        flags1 = (short)(flags1 | this.opcode << 3);
        flags2 = (short)(flags2 | this.rcode);
        out.writeByte(flags1);
        out.writeByte(flags2);
    }

    private void readFlags(DataByteInputStream in) throws IOException {
        short flags1 = (short)in.readUnsignedByte();
        short flags2 = (short)in.readUnsignedByte();
        int i = 0;
        while (i < 8) {
            this.flags[i] = (flags1 & 1 << 7 - i) != 0;
            this.flags[i + 8] = (flags2 & 1 << 7 - i) != 0;
            ++i;
        }
        this.opcode = (byte)(flags1 >> 3 & 0xF);
        this.rcode = (byte)(flags2 & 0xF);
    }

    public String printFlags() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.flags.length) {
            String s;
            if (this.getFlag(i) && (s = Flags.string(i)) != null) {
                sb.append(s);
                sb.append(" ");
            }
            ++i;
        }
        return sb.toString();
    }

    String toStringWithRcode(short newrcode) {
        StringBuffer sb = new StringBuffer();
        sb.append(";; ->>HEADER<<- ");
        sb.append("opcode: " + Opcode.string(this.getOpcode()));
        sb.append(", status: " + Rcode.string(newrcode));
        sb.append(", id: " + this.getID());
        sb.append("\n");
        sb.append(";; flags: " + this.printFlags());
        sb.append("; ");
        int i = 0;
        while (i < 4) {
            sb.append(Section.string(i) + ": " + this.getCount(i) + " ");
            ++i;
        }
        return sb.toString();
    }

    public String toString() {
        return this.toStringWithRcode(this.getRcode());
    }

    public Object clone() {
        Header h = new Header(this.id);
        System.arraycopy(this.counts, 0, h.counts, 0, this.counts.length);
        System.arraycopy(this.flags, 0, h.flags, 0, this.flags.length);
        h.rcode = this.rcode;
        h.rcode = this.rcode;
        h.opcode = this.opcode;
        return h;
    }
}

