/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.Task;

import java.util.LinkedList;

public class WorkerThread
extends Thread {
    private Runnable task;
    private String name;
    private static int nactive = 0;
    private static LinkedList list = new LinkedList();
    private static int max = 10;
    private static long lifetime = 900000L;

    private WorkerThread() {
        this.setDaemon(true);
    }

    public static synchronized void setLifetime(long time) {
        lifetime = time;
    }

    public static synchronized void setMaxThreads(int maxThreads) {
        max = maxThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WorkerThread getThread() {
        WorkerThread t;
        LinkedList linkedList = list;
        synchronized (linkedList) {
            if (list.size() > 0) {
                t = (WorkerThread)list.getFirst();
                list.remove(t);
            } else if (nactive >= max) {
                do {
                    try {
                        list.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                } while (list.size() == 0);
                t = (WorkerThread)list.getFirst();
                list.remove(t);
            } else {
                t = new WorkerThread();
            }
            ++nactive;
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assignThread(Runnable task, String name) {
        while (true) {
            try {
                WorkerThread t;
                WorkerThread workerThread = t = WorkerThread.getThread();
                synchronized (workerThread) {
                    t.task = task;
                    t.name = name;
                    if (!t.isAlive()) {
                        t.start();
                    } else {
                        t.notify();
                    }
                }
                return;
            }
            catch (IllegalThreadStateException e) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            Runnable runnable;
            WorkerThread workerThread = this;
            synchronized (workerThread) {
                this.setName(this.name);
                runnable = this.task;
            }
            try {
                runnable.run();
            }
            catch (Throwable t) {
                System.err.println(t);
            }
            WorkerThread workerThread2 = this;
            synchronized (workerThread2) {
                this.setName("idle thread");
                LinkedList linkedList = list;
                synchronized (linkedList) {
                    list.add(this);
                    list.notify();
                    --nactive;
                }
                this.task = null;
                try {
                    this.wait(lifetime);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (this.task == null) {
                    LinkedList linkedList2 = list;
                    synchronized (linkedList2) {
                        list.remove(this);
                    }
                    return;
                }
            }
        }
    }
}

