/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.xbill.DNS.DClass;
import org.xbill.DNS.Master;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.Rcode;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.SOARecord;
import org.xbill.DNS.Section;
import org.xbill.DNS.SimpleResolver;
import org.xbill.DNS.TTL;
import org.xbill.DNS.Type;
import org.xbill.DNS.utils.MyStringTokenizer;

public class update {
    Message query;
    Message response;
    Resolver res;
    String server = null;
    Name zone = Name.root;
    int defaultTTL;
    short defaultClass = 1;
    PrintStream log = null;

    void print(Object o) {
        System.out.println(o);
        if (this.log != null) {
            this.log.println(o);
        }
    }

    public update(InputStream in) throws IOException {
        ArrayList<BufferedReader> inputs = new ArrayList<BufferedReader>();
        ArrayList<InputStream> istreams = new ArrayList<InputStream>();
        this.query = new Message();
        this.query.getHeader().setOpcode((byte)5);
        InputStreamReader isr = new InputStreamReader(in);
        BufferedReader br = new BufferedReader(isr);
        inputs.add(br);
        istreams.add(in);
        while (true) {
            try {
                MyStringTokenizer st;
                String line;
                while (true) {
                    line = null;
                    do {
                        InputStream is = (InputStream)istreams.get(istreams.size() - 1);
                        br = (BufferedReader)inputs.get(inputs.size() - 1);
                        if (is == System.in) {
                            System.out.print("> ");
                        }
                        if ((line = Master.readExtendedLine(br)) != null) continue;
                        br.close();
                        inputs.remove(br);
                        istreams.remove(is);
                        if (!inputs.isEmpty()) continue;
                        return;
                    } while (line == null);
                    if (this.log != null) {
                        this.log.println("> " + line);
                    }
                    if (line.length() == 0 || line.charAt(0) == '#') continue;
                    if (line.charAt(0) == '>') {
                        line = line.substring(1);
                    }
                    if ((st = new MyStringTokenizer(line)).hasMoreTokens()) break;
                }
                String operation = st.nextToken();
                if (operation.equals("server")) {
                    this.server = st.nextToken();
                    this.res = new SimpleResolver(this.server);
                    if (!st.hasMoreTokens()) continue;
                    String portstr = st.nextToken();
                    this.res.setPort(Short.parseShort(portstr));
                    continue;
                }
                if (operation.equals("key")) {
                    String keyname = st.nextToken();
                    String keydata = st.nextToken();
                    if (this.res == null) {
                        this.res = new SimpleResolver(this.server);
                    }
                    this.res.setTSIGKey(keyname, keydata);
                    continue;
                }
                if (operation.equals("edns")) {
                    if (this.res == null) {
                        this.res = new SimpleResolver(this.server);
                    }
                    this.res.setEDNS(Short.parseShort(st.nextToken()));
                    continue;
                }
                if (operation.equals("port")) {
                    if (this.res == null) {
                        this.res = new SimpleResolver(this.server);
                    }
                    this.res.setPort(Short.parseShort(st.nextToken()));
                    continue;
                }
                if (operation.equals("tcp")) {
                    if (this.res == null) {
                        this.res = new SimpleResolver(this.server);
                    }
                    this.res.setTCP(true);
                    continue;
                }
                if (operation.equals("class")) {
                    String s = st.nextToken();
                    short newClass = DClass.value(s);
                    if (newClass > 0) {
                        this.defaultClass = newClass;
                        continue;
                    }
                    this.print("Invalid class " + newClass);
                    continue;
                }
                if (operation.equals("ttl")) {
                    this.defaultTTL = TTL.parseTTL(st.nextToken());
                    continue;
                }
                if (operation.equals("origin") || operation.equals("zone")) {
                    this.zone = Name.fromString(st.nextToken(), Name.root);
                    continue;
                }
                if (operation.equals("require")) {
                    this.doRequire(st);
                    continue;
                }
                if (operation.equals("prohibit")) {
                    this.doProhibit(st);
                    continue;
                }
                if (operation.equals("add")) {
                    this.doAdd(st);
                    continue;
                }
                if (operation.equals("delete")) {
                    this.doDelete(st);
                    continue;
                }
                if (operation.equals("glue")) {
                    this.doGlue(st);
                    continue;
                }
                if (operation.equals("help") || operation.equals("?")) {
                    if (st.hasMoreTokens()) {
                        update.help(st.nextToken());
                        continue;
                    }
                    update.help(null);
                    continue;
                }
                if (operation.equals("echo")) {
                    this.print(line.substring(4).trim());
                    continue;
                }
                if (operation.equals("send")) {
                    if (this.res == null) {
                        this.res = new SimpleResolver(this.server);
                    }
                    this.sendUpdate();
                    this.query = new Message();
                    this.query.getHeader().setOpcode((byte)5);
                    continue;
                }
                if (operation.equals("show")) {
                    this.print(this.query);
                    continue;
                }
                if (operation.equals("clear")) {
                    this.query = new Message();
                    this.query.getHeader().setOpcode((byte)5);
                    continue;
                }
                if (operation.equals("query")) {
                    this.doQuery(st);
                    continue;
                }
                if (operation.equals("quit") || operation.equals("q")) {
                    if (this.log != null) {
                        this.log.close();
                    }
                    Iterator it = inputs.iterator();
                    while (it.hasNext()) {
                        BufferedReader tbr = (BufferedReader)it.next();
                        tbr.close();
                    }
                    System.exit(0);
                    continue;
                }
                if (operation.equals("file")) {
                    this.doFile(st, inputs, istreams);
                    continue;
                }
                if (operation.equals("log")) {
                    this.doLog(st);
                    continue;
                }
                if (operation.equals("assert")) {
                    if (this.doAssert(st)) continue;
                    return;
                }
                if (operation.equals("sleep")) {
                    int interval = Integer.parseInt(st.nextToken());
                    try {
                        Thread.sleep(interval);
                    }
                    catch (InterruptedException e) {}
                    continue;
                }
                if (operation.equals("date")) {
                    Date now = new Date();
                    if (st.hasMoreTokens() && st.nextToken().equals("-ms")) {
                        this.print(Long.toString(now.getTime()));
                        continue;
                    }
                    this.print(now);
                    continue;
                }
                this.print("invalid keyword: " + operation);
                continue;
            }
            catch (NullPointerException npe) {
                System.out.println("Parse error");
                continue;
            }
            catch (InterruptedIOException iioe) {
                System.out.println("Operation timed out");
                continue;
            }
            catch (SocketException se) {
                System.out.println("Socket error");
                continue;
            }
            catch (IOException ioe) {
                System.out.println(ioe);
                continue;
            }
            break;
        }
    }

    void sendUpdate() throws IOException {
        if (this.query.getHeader().getCount(2) == 0) {
            this.print("Empty update message.  Ignoring.");
            return;
        }
        if (this.query.getHeader().getCount(0) == 0) {
            Name updzone = this.zone;
            short dclass = this.defaultClass;
            if (updzone == null) {
                Record[] recs = this.query.getSectionArray(2);
                int i = 0;
                while (i < recs.length) {
                    if (updzone == null) {
                        updzone = new Name(recs[i].getName(), 1);
                    }
                    if (recs[i].getDClass() != 254 && recs[i].getDClass() != 255) {
                        dclass = recs[i].getDClass();
                        break;
                    }
                    ++i;
                }
            }
            Record soa = Record.newRecord(updzone, (short)6, dclass);
            this.query.addRecord(soa, 0);
        }
        this.response = this.res.send(this.query);
        if (this.response == null) {
            return;
        }
        this.print(this.response);
    }

    Record parseRR(MyStringTokenizer st, short classValue, int TTLValue) throws IOException {
        short type;
        int ttl;
        Name name = Name.fromString(st.nextToken(), this.zone);
        String s = st.nextToken();
        try {
            ttl = TTL.parseTTL(s);
            s = st.nextToken();
        }
        catch (NumberFormatException e) {
            ttl = TTLValue;
        }
        if (DClass.value(s) >= 0) {
            classValue = DClass.value(s);
            s = st.nextToken();
        }
        if ((type = Type.value(s)) < 0) {
            throw new IOException("Invalid type: " + s);
        }
        Record record = Record.fromString(name, type, classValue, ttl, st, this.zone);
        if (record != null) {
            return record;
        }
        throw new IOException("Parse error");
    }

    void doRequire(MyStringTokenizer st) throws IOException {
        Record record;
        String s = st.nextToken();
        if (s.startsWith("-")) {
            this.print("qualifiers are now ignored");
            s = st.nextToken();
        }
        Name name = Name.fromString(s, this.zone);
        if (st.hasMoreTokens()) {
            s = st.nextToken();
            short type = Type.value(s);
            if (type < 0) {
                throw new IOException("Invalid type: " + s);
            }
            record = st.hasMoreTokens() ? Record.fromString(name, type, this.defaultClass, 0, st, this.zone) : Record.newRecord(name, type, (short)255, 0);
        } else {
            record = Record.newRecord(name, (short)255, (short)255, 0);
        }
        this.query.addRecord(record, 1);
        this.print(record);
    }

    void doProhibit(MyStringTokenizer st) throws IOException {
        short type;
        String s = st.nextToken();
        if (s.startsWith("-")) {
            this.print("qualifiers are now ignored");
            s = st.nextToken();
        }
        Name name = Name.fromString(s, this.zone);
        if (st.hasMoreTokens()) {
            s = st.nextToken();
            short s2 = Type.value(s);
            type = s2;
            if (s2 < 0) {
                throw new IOException("Invalid type: " + s);
            }
        } else {
            type = 255;
        }
        if (st.hasMoreTokens()) {
            throw new IOException("Cannot specify rdata to prohibit");
        }
        Record record = Record.newRecord(name, type, (short)254, 0);
        this.query.addRecord(record, 1);
        this.print(record);
    }

    void doAdd(MyStringTokenizer st) throws IOException {
        String s = st.nextToken();
        if (s.startsWith("-")) {
            this.print("qualifiers are now ignored");
        } else {
            st.putBackToken(s);
        }
        Record record = this.parseRR(st, this.defaultClass, this.defaultTTL);
        this.query.addRecord(record, 2);
        this.print(record);
    }

    void doDelete(MyStringTokenizer st) throws IOException {
        Record record;
        String s = st.nextToken();
        if (s.startsWith("-")) {
            this.print("qualifiers are now ignored");
            s = st.nextToken();
        }
        Name name = Name.fromString(s, this.zone);
        if (st.hasMoreTokens()) {
            short type;
            s = st.nextToken();
            short dclass = DClass.value(s);
            if (dclass >= 0) {
                if (!st.hasMoreTokens()) {
                    throw new IOException("Invalid format");
                }
                s = st.nextToken();
            }
            if ((type = Type.value(s)) < 0) {
                throw new IOException("Invalid type: " + s);
            }
            record = st.hasMoreTokens() ? Record.fromString(name, type, (short)254, 0, st, this.zone) : Record.newRecord(name, type, (short)255, 0);
        } else {
            record = Record.newRecord(name, (short)255, (short)255, 0);
        }
        this.query.addRecord(record, 2);
        this.print(record);
    }

    void doGlue(MyStringTokenizer st) throws IOException {
        String s = st.nextToken();
        if (s.startsWith("-")) {
            this.print("qualifiers are now ignored");
        } else {
            st.putBackToken(s);
        }
        Record record = this.parseRR(st, this.defaultClass, this.defaultTTL);
        this.query.addRecord(record, 3);
        this.print(record);
    }

    void doQuery(MyStringTokenizer st) throws IOException {
        Name name = null;
        short type = 1;
        short dclass = this.defaultClass;
        name = Name.fromString(st.nextToken(), this.zone);
        if (st.hasMoreTokens()) {
            type = Type.value(st.nextToken());
            if (type < 0) {
                throw new IOException("Invalid type");
            }
            if (st.hasMoreTokens() && (dclass = DClass.value(st.nextToken())) < 0) {
                throw new IOException("Invalid class");
            }
        }
        Record rec = Record.newRecord(name, type, dclass);
        Message newQuery = Message.newQuery(rec);
        if (this.res == null) {
            this.res = new SimpleResolver(this.server);
        }
        this.response = this.res.send(newQuery);
        this.print(this.response);
    }

    void doFile(MyStringTokenizer st, List inputs, List istreams) {
        String s = st.nextToken();
        try {
            InputStreamReader isr2;
            if (!s.equals("-")) {
                FileInputStream fis = new FileInputStream(s);
                isr2 = new InputStreamReader(fis);
                istreams.add(fis);
            } else {
                isr2 = new InputStreamReader(System.in);
                istreams.add(System.in);
            }
            BufferedReader br2 = new BufferedReader(isr2);
            inputs.add(br2);
        }
        catch (FileNotFoundException e) {
            this.print(s + " not found");
        }
    }

    void doLog(MyStringTokenizer st) {
        String s = st.nextToken();
        try {
            FileOutputStream fos = new FileOutputStream(s);
            this.log = new PrintStream(fos);
        }
        catch (Exception e) {
            this.print("Error opening " + s);
        }
    }

    boolean doAssert(MyStringTokenizer st) {
        String field = st.nextToken();
        String expected = st.nextToken();
        String value = null;
        boolean flag = true;
        if (this.response == null) {
            this.print("No response has been received");
            return true;
        }
        if (field.equalsIgnoreCase("rcode")) {
            short rcode = this.response.getHeader().getRcode();
            if (rcode != Rcode.value(expected)) {
                value = Rcode.string(rcode);
                flag = false;
            }
        } else if (field.equalsIgnoreCase("serial")) {
            Record[] answers = this.response.getSectionArray(1);
            if (answers.length < 1 || !(answers[0] instanceof SOARecord)) {
                this.print("Invalid response (no SOA)");
            } else {
                SOARecord soa = (SOARecord)answers[0];
                int serial = soa.getSerial();
                if (serial != Integer.parseInt(expected)) {
                    value = new Integer(serial).toString();
                    flag = false;
                }
            }
        } else if (field.equalsIgnoreCase("tsig")) {
            value = this.response.isSigned() ? (this.response.isVerified() ? "ok" : "failed") : "unsigned";
            if (!value.equalsIgnoreCase(expected)) {
                flag = false;
            }
        } else {
            byte section = Section.value(field);
            if (section >= 0) {
                int count = this.response.getHeader().getCount(section);
                if (count != Integer.parseInt(expected)) {
                    value = new Integer(count).toString();
                    flag = false;
                }
            } else {
                this.print("Invalid assertion keyword: " + field);
            }
        }
        if (!flag) {
            this.print("Expected " + field + " " + expected + ", received " + value);
            if (st.hasMoreTokens()) {
                this.print(st.nextToken());
            }
        }
        return flag;
    }

    static void help(String topic) {
        System.out.println();
        if (topic == null) {
            System.out.println("The following are supported commands:\nadd      assert   class    clear    date     delete\necho     file     glue     help     log      key\nedns     origin   port     prohibit query    quit\nrequire  send     server   show     sleep    tcp\nttl      zone     #\n");
        } else if (topic.equalsIgnoreCase("add")) {
            System.out.println("add <name> [ttl] [class] <type> <data>\n\nspecify a record to be added\n");
        } else if (topic.equalsIgnoreCase("assert")) {
            System.out.println("assert <field> <value> [msg]\n\nasserts that the value of the field in the last\nresponse matches the value specified.  If not,\nthe message is printed (if present) and the\nprogram exits.  The field may be any of <rcode>,\n<serial>, <tsig>, <qu>, <an>, <au>, or <ad>.\n");
        } else if (topic.equalsIgnoreCase("class")) {
            System.out.println("class <class>\n\nclass of the zone to be updated (default: IN)\n");
        } else if (topic.equalsIgnoreCase("clear")) {
            System.out.println("clear\n\nclears the current update packet\n");
        } else if (topic.equalsIgnoreCase("date")) {
            System.out.println("date [-ms]\n\nprints the current date and time in human readable\nformat or as the number of milliseconds since the\nepoch");
        } else if (topic.equalsIgnoreCase("delete")) {
            System.out.println("delete <name> [ttl] [class] <type> <data> \ndelete <name> <type> \ndelete <name>\n\nspecify a record or set to be deleted, or that\nall records at a name should be deleted\n");
        } else if (topic.equalsIgnoreCase("echo")) {
            System.out.println("echo <text>\n\nprints the text\n");
        } else if (topic.equalsIgnoreCase("file")) {
            System.out.println("file <file>\n\nopens the specified file as the new input source\n(- represents stdin)\n");
        } else if (topic.equalsIgnoreCase("glue")) {
            System.out.println("glue <name> [ttl] [class] <type> <data>\n\nspecify an additional record\n");
        } else if (topic.equalsIgnoreCase("help")) {
            System.out.println("?/help\nhelp [topic]\n\nprints a list of commands or help about a specific\ncommand\n");
        } else if (topic.equalsIgnoreCase("log")) {
            System.out.println("log <file>\n\nopens the specified file and uses it to log output\n");
        } else if (topic.equalsIgnoreCase("key")) {
            System.out.println("key <name> <data>\n\nTSIG key used to sign messages\n");
        } else if (topic.equalsIgnoreCase("edns")) {
            System.out.println("edns <level>\n\nEDNS level specified when sending messages\n");
        } else if (topic.equalsIgnoreCase("origin")) {
            System.out.println("origin <origin>\n\n<same as zone>\n");
        } else if (topic.equalsIgnoreCase("port")) {
            System.out.println("port <port>\n\nUDP/TCP port messages are sent to (default: 53)\n");
        } else if (topic.equalsIgnoreCase("prohibit")) {
            System.out.println("prohibit <name> <type> \nprohibit <name>\n\nrequire that a set or name is not present\n");
        } else if (topic.equalsIgnoreCase("query")) {
            System.out.println("query <name> [type [class]] \n\nissues a query\n");
        } else if (topic.equalsIgnoreCase("q") || topic.equalsIgnoreCase("quit")) {
            System.out.println("q/quit\n\nquits the program\n");
        } else if (topic.equalsIgnoreCase("require")) {
            System.out.println("require <name> [ttl] [class] <type> <data> \nrequire <name> <type> \nrequire <name>\n\nrequire that a record, set, or name is present\n");
        } else if (topic.equalsIgnoreCase("send")) {
            System.out.println("send\n\nsends and resets the current update packet\n");
        } else if (topic.equalsIgnoreCase("server")) {
            System.out.println("server <name> [port]\n\nserver that receives send updates/queries\n");
        } else if (topic.equalsIgnoreCase("show")) {
            System.out.println("show\n\nshows the current update packet\n");
        } else if (topic.equalsIgnoreCase("sleep")) {
            System.out.println("sleep <milliseconds>\n\npause for interval before next command\n");
        } else if (topic.equalsIgnoreCase("tcp")) {
            System.out.println("tcp\n\nTCP should be used to send all messages\n");
        } else if (topic.equalsIgnoreCase("ttl")) {
            System.out.println("ttl <ttl>\n\ndefault ttl of added records (default: 0)\n");
        } else if (topic.equalsIgnoreCase("zone")) {
            System.out.println("zone <zone>\n\nzone to update (default: .\n");
        } else if (topic.equalsIgnoreCase("#")) {
            System.out.println("# <text>\n\na comment\n");
        } else {
            System.out.println("Topic '" + topic + "' unrecognized\n");
        }
    }

    public static void main(String[] args) throws IOException {
        InputStream in = null;
        if (args.length == 1) {
            try {
                in = new FileInputStream(args[0]);
            }
            catch (FileNotFoundException e) {
                System.out.println(args[0] + " not found.");
                System.exit(-1);
            }
        } else {
            in = System.in;
        }
        update update2 = new update(in);
    }
}

