/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid.server.impl;

import com.ibm.lsid.ExpiringResponse;
import com.ibm.lsid.LSID;
import com.ibm.lsid.LSIDException;
import com.ibm.lsid.client.LSIDAuthority;
import com.ibm.lsid.server.LSIDAuthorityService;
import com.ibm.lsid.server.LSIDRequestContext;
import com.ibm.lsid.server.LSIDServerException;
import com.ibm.lsid.wsdl.LSIDDataPort;
import com.ibm.lsid.wsdl.LSIDMetadataPort;
import com.ibm.lsid.wsdl.LSIDWSDLWrapper;
import java.util.Date;

public abstract class SimpleAuthority
implements LSIDAuthorityService {
    public ExpiringResponse getAvailableServices(LSIDRequestContext ctx) throws LSIDServerException {
        LSID lsid = ctx.getLsid();
        String url = ctx.getReqUrl();
        try {
            LSIDWSDLWrapper wsdl = new LSIDWSDLWrapper(lsid);
            LSIDDataPort[] dataLocs = this.getDataLocations(lsid, url);
            if (dataLocs == null) {
                throw new LSIDServerException(201, "Unknown LSID");
            }
            int i = 0;
            while (i < dataLocs.length) {
                wsdl.setDataLocation(dataLocs[i]);
                ++i;
            }
            LSIDMetadataPort[] metaLocs = this.getMetadataLocations(lsid, url);
            if (metaLocs != null) {
                int i2 = 0;
                while (i2 < metaLocs.length) {
                    wsdl.setMetadataLocation(metaLocs[i2]);
                    ++i2;
                }
            }
            return new ExpiringResponse((Object)wsdl.toString(), this.getExpiration());
        }
        catch (LSIDException e) {
            throw new LSIDServerException((Exception)((Object)e), e.getErrorCode(), "Simple Authority Error in getAvailableOperations(" + lsid + "): ");
        }
    }

    protected Date getExpiration() {
        return null;
    }

    protected abstract LSIDDataPort[] getDataLocations(LSID var1, String var2) throws LSIDServerException;

    protected abstract LSIDMetadataPort[] getMetadataLocations(LSID var1, String var2) throws LSIDServerException;

    public void notifyForeignAuthority(LSIDRequestContext req, LSIDAuthority authorityName) throws LSIDServerException {
        throw new LSIDServerException(501, "FAN service not available");
    }

    public void revokeNotificationForeignAuthority(LSIDRequestContext req, LSIDAuthority authorityName) throws LSIDServerException {
        throw new LSIDServerException(501, "FAN service not available");
    }
}

