/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid.server.metadata.rdf;

import com.ibm.lsid.server.LSIDServerException;
import com.ibm.lsid.server.metadata.rdf.RDFConstants;
import com.ibm.lsid.server.metadata.rdf.Resource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class RDFDocument
implements RDFConstants {
    private Document doc;
    private Element root;
    private int rdfLimit = -1;
    private int nodeCount = 0;

    public RDFDocument() throws LSIDServerException {
        try {
            DocumentBuilder builder = new DocumentBuilderFactoryImpl().newDocumentBuilder();
            this.doc = builder.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new LSIDServerException(e, "Error building RDF");
        }
        this.root = this.doc.createElementNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "RDF");
        this.root.setPrefix("rdf");
        this.doc.appendChild(this.root);
    }

    public String getAsString() throws LSIDServerException {
        OutputFormat fmt = new OutputFormat();
        StringWriter writer = new StringWriter();
        XMLSerializer ser = new XMLSerializer((Writer)writer, fmt);
        ser.setNamespaces(true);
        try {
            ser.serialize(this.root);
            return writer.getBuffer().toString();
        }
        catch (IOException e) {
            throw new LSIDServerException(e, "Error serializing RDF Document");
        }
    }

    public InputStream getAsStream() throws LSIDServerException {
        return new ByteArrayInputStream(this.getAsString().getBytes());
    }

    public void addTriple(Resource subject, Resource predicate, Resource object) throws LSIDServerException {
        if (this.rdfLimit < this.nodeCount && this.rdfLimit != -1) {
            return;
        }
        Element pred = this.createDescription(subject, predicate);
        Attr obj = this.doc.createAttributeNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource");
        obj.setPrefix("rdf");
        obj.setValue(object.getUri());
        pred.setAttributeNodeNS(obj);
        ++this.nodeCount;
    }

    public void addTriple(Resource subject, Resource predicate, String objectLiteral) throws LSIDServerException {
        if (this.rdfLimit < this.nodeCount && this.rdfLimit != -1) {
            return;
        }
        Element pred = this.createDescription(subject, predicate);
        Text text = this.doc.createTextNode(objectLiteral);
        pred.appendChild(text);
        ++this.nodeCount;
    }

    private Element createDescription(Resource subject, Resource predicate) {
        Element desc = this.doc.createElementNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "Description");
        desc.setPrefix("rdf");
        this.root.appendChild(desc);
        Attr about = this.doc.createAttributeNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "about");
        about.setPrefix("rdf");
        about.setValue(subject.getUri());
        desc.setAttributeNodeNS(about);
        Element pred = this.doc.createElementNS(predicate.getNamespaceURI(), predicate.getName());
        pred.setPrefix("pred");
        desc.appendChild(pred);
        return pred;
    }

    public int getRdfLimit() {
        return this.rdfLimit;
    }

    public void setRdfLimit(int rdfLimit) {
        this.rdfLimit = rdfLimit;
    }
}

