/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid.server.soap;

import com.ibm.lsid.LSIDException;
import com.ibm.lsid.server.AuthenticationResponse;
import com.ibm.lsid.server.soap.LSIDAxisFault;
import com.ibm.lsid.soap.SOAPConstants;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;

public class AxisFaultBuilder
implements SOAPConstants {
    public static LSIDAxisFault createFault(LSIDException e) {
        LSIDAxisFault fault = new LSIDAxisFault();
        fault.setFaultString(e.getMessage());
        int errorCode = e.getErrorCode();
        fault.setErrorCode(errorCode);
        String description = e.getDescription();
        String faultCode = null;
        faultCode = errorCode >= 500 ? "Server" : "Client";
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        String stackTrace = sw.getBuffer().toString();
        fault.setFaultCodeAsString(faultCode);
        fault.addFaultDetail(new QName("errorcode"), String.valueOf(errorCode));
        fault.addFaultDetail(new QName("description"), description);
        fault.addFaultDetail(Constants.QNAME_FAULTDETAIL_EXCEPTIONNAME, stackTrace);
        return fault;
    }

    public static LSIDAxisFault createFault(int lsidErrorCode, String message) {
        LSIDAxisFault fault = new LSIDAxisFault();
        fault.setErrorCode(lsidErrorCode);
        fault.setFaultString(message);
        String description = message;
        String faultCode = null;
        faultCode = lsidErrorCode >= 500 ? "Server" : "Client";
        fault.setFaultCodeAsString(faultCode);
        fault.addFaultDetail(new QName("errorcode"), String.valueOf(lsidErrorCode));
        fault.addFaultDetail(new QName("description"), description);
        return fault;
    }

    public static LSIDAxisFault createFault(Exception e, String msg) {
        LSIDAxisFault fault = new LSIDAxisFault();
        int errorCode = 500;
        fault.setErrorCode(errorCode);
        fault.setFaultString(msg);
        String description = "Internal AXIS error";
        String faultCode = null;
        faultCode = errorCode >= 500 ? "Server" : "Client";
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        String stackTrace = sw.getBuffer().toString();
        fault.setFaultCodeAsString(faultCode);
        fault.addFaultDetail(new QName("errorcode"), String.valueOf(errorCode));
        fault.addFaultDetail(new QName("description"), description);
        fault.addFaultDetail(Constants.QNAME_FAULTDETAIL_EXCEPTIONNAME, stackTrace);
        return fault;
    }

    public static LSIDAxisFault createFault(AuthenticationResponse authresp) {
        LSIDAxisFault fault = new LSIDAxisFault();
        fault.setErrorCode(700);
        fault.setFaultCodeAsString("Server.Unauthenticated");
        Object reason = authresp.getResponseData();
        if (reason != null) {
            fault.setFaultString("reason: " + reason.toString());
        } else {
            fault.setFaultString("no reason given");
        }
        fault.addFaultDetail(new QName("description"), "Authentication error");
        fault.addFaultDetail(new QName("errorcode"), String.valueOf(700));
        return fault;
    }

    public static AxisFault createFault(AxisFault fault) {
        fault.addFaultDetail(new QName("description"), "Internal procesing error");
        fault.addFaultDetail(new QName("errorcode"), String.valueOf(500));
        return fault;
    }
}

