/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid.server.soap;

import com.ibm.lsid.LSID;
import com.ibm.lsid.LSIDException;
import com.ibm.lsid.MetadataResponse;
import com.ibm.lsid.server.LSIDMetadataService;
import com.ibm.lsid.server.LSIDRequestContext;
import com.ibm.lsid.server.conf.ServiceRegistry;
import com.ibm.lsid.server.soap.AxisFaultBuilder;
import com.ibm.lsid.server.soap.LSIDWebService;
import com.ibm.lsid.soap.SOAPConstants;
import com.ibm.lsid.soap.SOAPUtils;
import java.io.InputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.PrefixedQName;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.transport.http.HTTPConstants;

public class MetadataWebService
extends LSIDWebService
implements SOAPConstants {
    public SOAPBodyElement[] getMetadata(SOAPBodyElement[] bodyElements) throws AxisFault {
        try {
            LSID lsid = this.getLSID(bodyElements[0]);
            LSIDRequestContext ctx = this.getRequestContext(lsid);
            String[] formats = null;
            formats = this.getAcceptedFormats(bodyElements[0]);
            ServiceRegistry reg = this.getServiceRegistry("metaserviceImplRegistry");
            LSIDMetadataService service = (LSIDMetadataService)reg.lookupService(lsid);
            if (service == null) {
                throw AxisFaultBuilder.createFault(201, "Unknown lsid: " + lsid);
            }
            MetadataResponse response = service.getMetadata(ctx, formats);
            SOAPBodyElement ret = new SOAPBodyElement();
            ret.setName("getMetadataResponse");
            ret.setNamespaceURI("http://www.omg.org/LSID/2003/DataServiceSOAPBindings");
            SOAPBodyElement formatElt = new SOAPBodyElement();
            formatElt.setName("format");
            formatElt.addTextNode(response.getFormat());
            ret.addChildElement((SOAPElement)formatElt);
            if (response.getExpires() != null) {
                SOAPBodyElement expiresElt = new SOAPBodyElement();
                expiresElt.setName("expiration");
                Date expires = response.getExpires();
                expiresElt.addTextNode(SOAPUtils.writeDate((Date)expires));
                ret.addChildElement((SOAPElement)expiresElt);
            }
            this.addAttachment((InputStream)response.getValue());
            return new SOAPBodyElement[]{ret};
        }
        catch (LSIDException e) {
            throw AxisFaultBuilder.createFault(e);
        }
        catch (SOAPException e) {
            throw AxisFaultBuilder.createFault((Exception)((Object)e), "Error creating return value");
        }
    }

    protected LSIDRequestContext getRequestContext(LSID lsid) throws AxisFault {
        LSIDRequestContext rc = super.getRequestContext(lsid);
        MessageContext ctx = MessageContext.getCurrentContext();
        HttpServletRequest req = (HttpServletRequest)ctx.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        String hint = req.getPathInfo();
        if (hint != null && hint.charAt(0) == '/') {
            hint = hint.substring(1);
        }
        rc.setHint(hint);
        return rc;
    }

    private String[] getAcceptedFormats(SOAPBodyElement bodyElt) {
        Iterator it = bodyElt.getChildElements((Name)new PrefixedQName(null, "acceptedFormats", null));
        if (it.hasNext()) {
            MessageElement elt = (MessageElement)it.next();
            String formats = elt.getValue();
            StringTokenizer st = new StringTokenizer(formats, ",", false);
            Vector<String> v = new Vector<String>();
            while (st.hasMoreTokens()) {
                v.add(st.nextToken());
            }
            String[] formatsArray = new String[v.size()];
            v.toArray(formatsArray);
            return formatsArray;
        }
        return null;
    }
}

