/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.tigris.subversion.svnant.Add;
import org.tigris.subversion.svnant.Cat;
import org.tigris.subversion.svnant.Checkout;
import org.tigris.subversion.svnant.Commit;
import org.tigris.subversion.svnant.Copy;
import org.tigris.subversion.svnant.CreateRepository;
import org.tigris.subversion.svnant.Delete;
import org.tigris.subversion.svnant.Diff;
import org.tigris.subversion.svnant.Export;
import org.tigris.subversion.svnant.Feedback;
import org.tigris.subversion.svnant.Ignore;
import org.tigris.subversion.svnant.Import;
import org.tigris.subversion.svnant.Keywordsadd;
import org.tigris.subversion.svnant.Keywordsremove;
import org.tigris.subversion.svnant.Keywordsset;
import org.tigris.subversion.svnant.Mkdir;
import org.tigris.subversion.svnant.Move;
import org.tigris.subversion.svnant.Propdel;
import org.tigris.subversion.svnant.Propget;
import org.tigris.subversion.svnant.Propset;
import org.tigris.subversion.svnant.Revert;
import org.tigris.subversion.svnant.Status;
import org.tigris.subversion.svnant.SvnCommand;
import org.tigris.subversion.svnant.Switch;
import org.tigris.subversion.svnant.Update;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.SVNClientAdapterFactory;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineClientAdapterFactory;
import org.tigris.subversion.svnclientadapter.javahl.JhlClientAdapterFactory;

public class SvnTask
extends Task {
    private String username = null;
    private String password = null;
    private List commands = new ArrayList();
    private int logLevel = 0;
    private File logFile = new File("svn.log");
    private boolean javahl = true;
    private List notifyListeners = new ArrayList();
    private static boolean javahlAvailableInitialized = false;
    private static boolean javahlAvailable;
    private static boolean commandLineAvailableInitialized;
    private static boolean commandLineAvailable;

    public void setUsername(String string) {
        this.username = string;
    }

    public void setPassword(String string) {
        this.password = "\"\"".equals(string) ? "" : string;
    }

    public void setJavahl(boolean bl) {
        this.javahl = bl;
    }

    public void setLogLevel(int n) {
        if (n > 3) {
            n = 3;
        } else if (n < 0) {
            n = 0;
        }
        this.logLevel = n;
    }

    public void setLogFile(File file) {
        this.logFile = file;
    }

    public void addCheckout(Checkout checkout) {
        this.commands.add(checkout);
    }

    public void addAdd(Add add) {
        this.commands.add(add);
    }

    public void addCommit(Commit commit) {
        this.commands.add(commit);
    }

    public void addCopy(Copy copy) {
        this.commands.add(copy);
    }

    public void addDelete(Delete delete) {
        this.commands.add(delete);
    }

    public void addExport(Export export) {
        this.commands.add(export);
    }

    public void addImport(Import import_) {
        this.commands.add(import_);
    }

    public void addMkdir(Mkdir mkdir) {
        this.commands.add(mkdir);
    }

    public void addMove(Move move) {
        this.commands.add(move);
    }

    public void addUpdate(Update update) {
        this.commands.add(update);
    }

    public void addPropset(Propset propset) {
        this.commands.add(propset);
    }

    public void addDiff(Diff diff) {
        this.commands.add(diff);
    }

    public void addKeywordsSet(Keywordsset keywordsset) {
        this.commands.add(keywordsset);
    }

    public void addKeywordsAdd(Keywordsadd keywordsadd) {
        this.commands.add(keywordsadd);
    }

    public void addKeywordsRemove(Keywordsremove keywordsremove) {
        this.commands.add(keywordsremove);
    }

    public void addRevert(Revert revert) {
        this.commands.add(revert);
    }

    public void addCat(Cat cat) {
        this.commands.add(cat);
    }

    public void addPropdel(Propdel propdel) {
        this.commands.add(propdel);
    }

    public void addIgnore(Ignore ignore) {
        this.commands.add(ignore);
    }

    public void addCreateRepository(CreateRepository createRepository) {
        this.commands.add(createRepository);
    }

    public void addStatus(Status status) {
        this.commands.add(status);
    }

    public void addSwitch(Switch switch_) {
        this.commands.add(switch_);
    }

    public void addPropget(Propget propget) {
        this.commands.add(propget);
    }

    public void addNotifyListener(ISVNNotifyListener iSVNNotifyListener) {
        this.notifyListeners.add(iSVNNotifyListener);
    }

    private boolean isJavahlAvailable() {
        if (!javahlAvailableInitialized) {
            try {
                JhlClientAdapterFactory.setup();
            }
            catch (SVNClientException sVNClientException) {
                // empty catch block
            }
            javahlAvailable = SVNClientAdapterFactory.isSVNClientAvailable((String)"javahl");
            javahlAvailableInitialized = true;
        }
        return javahlAvailable;
    }

    private boolean isCommandLineAvailable() {
        if (!commandLineAvailableInitialized) {
            try {
                CmdLineClientAdapterFactory.setup();
            }
            catch (SVNClientException sVNClientException) {
                // empty catch block
            }
            commandLineAvailable = SVNClientAdapterFactory.isSVNClientAvailable((String)"commandline");
            commandLineAvailableInitialized = true;
        }
        return commandLineAvailable;
    }

    public void execute() throws BuildException {
        int n;
        ISVNClientAdapter iSVNClientAdapter;
        if (this.javahl && this.isJavahlAvailable()) {
            iSVNClientAdapter = SVNClientAdapterFactory.createSVNClient((String)"javahl");
            this.log("Using javahl");
        } else if (this.isCommandLineAvailable()) {
            iSVNClientAdapter = SVNClientAdapterFactory.createSVNClient((String)"commandline");
            this.log("Using command line interface");
        } else {
            throw new BuildException("Cannot use javahl nor command line svn client");
        }
        if (this.username != null) {
            iSVNClientAdapter.setUsername(this.username);
        }
        if (this.password != null) {
            iSVNClientAdapter.setPassword(this.password);
        }
        for (n = 0; n < this.notifyListeners.size(); ++n) {
            iSVNClientAdapter.addNotifyListener((ISVNNotifyListener)this.notifyListeners.get(n));
        }
        for (n = 0; n < this.commands.size(); ++n) {
            SvnCommand svnCommand = (SvnCommand)((Object)this.commands.get(n));
            Feedback feedback = new Feedback(svnCommand);
            iSVNClientAdapter.addNotifyListener((ISVNNotifyListener)feedback);
            svnCommand.execute(iSVNClientAdapter);
            iSVNClientAdapter.removeNotifyListener((ISVNNotifyListener)feedback);
        }
    }

    static {
        commandLineAvailableInitialized = false;
    }
}

