/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.ugraphic.Shadowable;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.USegmentType;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public enum BoxStyle {
    PLAIN('\u0000', 0.0){

        @Override
        protected Shadowable getShape(double width, double height, double roundCorner) {
            return new URectangle(width, height).rounded(roundCorner);
        }
    }
    ,
    SDL_INPUT('<', 10.0){

        @Override
        protected Shadowable getShape(double width, double height, double roundCorner) {
            UPolygon result = new UPolygon();
            result.addPoint(0.0, 0.0);
            result.addPoint(width + (double)DELTA_INPUT_OUTPUT, 0.0);
            result.addPoint(width, height / 2.0);
            result.addPoint(width + (double)DELTA_INPUT_OUTPUT, height);
            result.addPoint(0.0, height);
            return result;
        }
    }
    ,
    SDL_OUTPUT('>', 10.0){

        @Override
        protected Shadowable getShape(double width, double height, double roundCorner) {
            UPolygon result = new UPolygon();
            result.addPoint(0.0, 0.0);
            result.addPoint(width, 0.0);
            result.addPoint(width + (double)DELTA_INPUT_OUTPUT, height / 2.0);
            result.addPoint(width, height);
            result.addPoint(0.0, height);
            return result;
        }
    }
    ,
    SDL_PROCEDURE('|', 0.0){

        @Override
        protected void drawInternal(UGraphic ug, double width, double height, double shadowing, double roundCorner) {
            URectangle rect = new URectangle(width, height);
            rect.setDeltaShadow(shadowing);
            ug.draw(rect);
            ULine vline = ULine.vline(height);
            ug.apply(UTranslate.dx(PADDING)).draw(vline);
            ug.apply(UTranslate.dx(width - (double)PADDING)).draw(vline);
        }
    }
    ,
    SDL_SAVE('\\', 0.0){

        @Override
        protected Shadowable getShape(double width, double height, double roundCorner) {
            UPolygon result = new UPolygon();
            result.addPoint(0.0, 0.0);
            result.addPoint(width - (double)DELTA_INPUT_OUTPUT, 0.0);
            result.addPoint(width, height);
            result.addPoint(DELTA_INPUT_OUTPUT, height);
            return result;
        }
    }
    ,
    SDL_ANTISAVE('/', 0.0){

        @Override
        protected Shadowable getShape(double width, double height, double roundCorner) {
            UPolygon result = new UPolygon();
            result.addPoint(DELTA_INPUT_OUTPUT, 0.0);
            result.addPoint(width, 0.0);
            result.addPoint(width - (double)DELTA_INPUT_OUTPUT, height);
            result.addPoint(0.0, height);
            return result;
        }
    }
    ,
    SDL_CONTINUOUS('}', 0.0){

        @Override
        protected Shadowable getShape(double width, double height, double roundCorner) {
            UPath result = new UPath();
            double[] c1 = new double[]{DELTA_CONTINUOUS, 0.0};
            double[] c2 = new double[]{0.0, height / 2.0};
            double[] c3 = new double[]{DELTA_CONTINUOUS, height};
            result.add(c1, USegmentType.SEG_MOVETO);
            result.add(c2, USegmentType.SEG_LINETO);
            result.add(c3, USegmentType.SEG_LINETO);
            double[] c4 = new double[]{width - DELTA_CONTINUOUS, 0.0};
            double[] c5 = new double[]{width, height / 2.0};
            double[] c6 = new double[]{width - DELTA_CONTINUOUS, height};
            result.add(c4, USegmentType.SEG_MOVETO);
            result.add(c5, USegmentType.SEG_LINETO);
            result.add(c6, USegmentType.SEG_LINETO);
            return result;
        }
    }
    ,
    SDL_TASK(']', 0.0){

        @Override
        protected Shadowable getShape(double width, double height, double roundCorner) {
            return new URectangle(width, height);
        }
    };

    private final char style;
    private final double shield;
    private static int DELTA_INPUT_OUTPUT;
    private static double DELTA_CONTINUOUS;
    private static int PADDING;

    private BoxStyle(char style, double shield) {
        this.style = style;
        this.shield = shield;
    }

    public static BoxStyle fromChar(char style) {
        for (BoxStyle bs : BoxStyle.values()) {
            if (bs.style != style) continue;
            return bs;
        }
        return PLAIN;
    }

    public final UDrawable getUDrawable(final double width, final double height, final double shadowing, final double roundCorner) {
        return new UDrawable(){

            @Override
            public void drawU(UGraphic ug) {
                BoxStyle.this.drawInternal(ug, width - BoxStyle.this.getShield(), height, shadowing, roundCorner);
            }
        };
    }

    protected Shadowable getShape(double width, double height, double roundCorner) {
        return null;
    }

    protected void drawInternal(UGraphic ug, double width, double height, double shadowing, double roundCorner) {
        Shadowable s = this.getShape(width, height, roundCorner);
        s.setDeltaShadow(shadowing);
        ug.draw(s);
    }

    public final double getShield() {
        return this.shield;
    }

    static {
        DELTA_INPUT_OUTPUT = 10;
        DELTA_CONTINUOUS = 5.0;
        PADDING = 5;
    }
}

