/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.jsondiagram;

import java.util.ArrayList;
import java.util.Iterator;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.api.ThemeStyle;
import net.sourceforge.plantuml.command.PSystemAbstractFactory;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.DiagramType;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.json.Json;
import net.sourceforge.plantuml.json.JsonValue;
import net.sourceforge.plantuml.json.ParseException;
import net.sourceforge.plantuml.jsondiagram.JsonDiagram;
import net.sourceforge.plantuml.jsondiagram.StyleExtractor;

public class JsonDiagramFactory
extends PSystemAbstractFactory {
    public JsonDiagramFactory() {
        super(DiagramType.JSON);
    }

    @Override
    public Diagram createSystem(ThemeStyle style, UmlSource source, ISkinSimple skinParam) {
        JsonValue json;
        ArrayList<String> highlighted = new ArrayList<String>();
        StyleExtractor styleExtractor = null;
        try {
            StringBuilder sb = new StringBuilder();
            styleExtractor = new StyleExtractor(source.iterator2());
            Iterator<String> it = styleExtractor.getIterator();
            it.next();
            while (true) {
                String line = it.next();
                if (!it.hasNext()) break;
                if (line.startsWith("#")) {
                    if (!line.startsWith("#highlight ")) continue;
                    highlighted.add(line.substring("#highlight ".length()).trim());
                    continue;
                }
                sb.append(line);
                sb.append('\n');
            }
            json = Json.parse(sb.toString());
        }
        catch (ParseException e) {
            json = null;
        }
        JsonDiagram result = new JsonDiagram(style, source, UmlDiagramType.JSON, json, highlighted);
        if (styleExtractor != null) {
            styleExtractor.applyStyles(result.getSkinParam());
        }
        return result;
    }
}

