/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram;

import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.style.Styleable;

public enum ParticipantType implements Styleable
{
    PARTICIPANT(ColorParam.participantBackground),
    ACTOR(ColorParam.actorBackground),
    BOUNDARY(ColorParam.boundaryBackground),
    CONTROL(ColorParam.controlBackground),
    ENTITY(ColorParam.entityBackground),
    QUEUE(ColorParam.queueBackground),
    DATABASE(ColorParam.databaseBackground),
    COLLECTIONS(ColorParam.collectionsBackground);

    private final ColorParam background;

    private ParticipantType(ColorParam background) {
        this.background = background;
    }

    public ColorParam getBackgroundColorParam() {
        return this.background;
    }

    @Override
    public StyleSignatureBasic getStyleSignature() {
        if (this == PARTICIPANT) {
            return StyleSignatureBasic.of(SName.root, SName.element, SName.sequenceDiagram, SName.participant);
        }
        if (this == ACTOR) {
            return StyleSignatureBasic.of(SName.root, SName.element, SName.sequenceDiagram, SName.actor);
        }
        if (this == BOUNDARY) {
            return StyleSignatureBasic.of(SName.root, SName.element, SName.sequenceDiagram, SName.boundary);
        }
        if (this == CONTROL) {
            return StyleSignatureBasic.of(SName.root, SName.element, SName.sequenceDiagram, SName.control);
        }
        if (this == ENTITY) {
            return StyleSignatureBasic.of(SName.root, SName.element, SName.sequenceDiagram, SName.entity);
        }
        if (this == QUEUE) {
            return StyleSignatureBasic.of(SName.root, SName.element, SName.sequenceDiagram, SName.queue);
        }
        if (this == DATABASE) {
            return StyleSignatureBasic.of(SName.root, SName.element, SName.sequenceDiagram, SName.database);
        }
        if (this == COLLECTIONS) {
            return StyleSignatureBasic.of(SName.root, SName.element, SName.sequenceDiagram, SName.collections);
        }
        return null;
    }
}

